//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TForm
//	Include File:	tform.h
//	Purpose:	Implement a form class for HTML+
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		04-25-94	created
#include"globals.h"
#include"tform.h"
#include<string.h>

TForm::TForm(const char *cp_action, const char *cp_method)	{
//	Purpose:	Creation of a Form object.
//	Arguments:	cp_action	The address of the action server.
//			cp_method	The method to send information to the
//					server.
//	Remarks/Portability/Dependencies/Restrictions:
//		ENCTYPE not supported.
//	Revision History:
//		04-25-94	created

	//	Set relevant members to initial values.
	cp_ActionServer = NULL;
	m_SendAs = get;

	//	Determine values by arguments.
	//	First the action server.
	if(cp_action != NULL)	{
		cp_ActionServer = newStr(cp_action);
	}
	else	{
		//	Try to use the current document address from the
		//	current view.  This should be safe since this
		//	should never be executed unless a view is being
		//	created and it knows it's own URL.
		cp_ActionServer = newStr(TURLV_current->getURL());
	}

	if(cp_method != NULL)	{
		if(stricmp(cp_method, "post") == 0)	{
			m_SendAs = post;
		}
	}
}