#                              -*- Mode: Perl -*- 
# waisclient.pl -- 
# ITIID           : $ITI$ $Header $__Header$
# Author          : Miao-Jane Lin <mjlin@cs.cornell.edu>
# Created On      : Wed Apr 27 08:30:01 1994
# Last Modified By: Ulrich Pfeifer
# Last Modified On: Thu Jun 23 18:30:08 1994
# Update Count    : 400
# Status          : Unknown, Use with caution!
# 

#------------------------------------------------------------------------
# ask a query
#------------------------------------------------------------------------
sub do_waisq {
    local($query, @databases) = @_;
    local($connection, $server, $database, $port, $_);

    # clean global variables (dynamic binding !)
    local(%diagnostics, @headlines, @documenttext);

    for $connection (@databases) {
        if ($connection =~ m#/#) {
            ($server,$database) = split('/', $connection, 2);
        } else {
            $server   = "$defserver:$defport";
            $database = $connection;
        }
        if ($server =~ /:/) {
            ($server,$port) = split(':', $server);
        } else {
            $port = $defport;
        }
        &dprint("client($server, $database, $query, $port)\n");
        ($HL,$DI) = &WAISsearch($server, $port, $database, $query);
        for (split($WAISrecsep, $DI)) {
            &add_diag($server,$database,$_);
        }
        for $hl (split($WAISrecsep, $HL)) {
            $did = (split(/$WAISfldsepr/,$hl))[2];
            &dprint("direct_get: %s\n", $did);
            ($type) = ($did =~ m:[^/]*/([^/]*)/:);
            if ($directget || $type eq "WSRC") {
                ($tx,$di) = &WAISretrieve($server, $port, $database, $did);
                $hl .= "${WAISfldsep}$tx";
                for (split($WAISrecsep, $di)) {
                    &add_diag($server,$database,$_);
                }
            }
            push(@headlines, $hl);
        }
    }

    &print_header ("$query in @databases");
    print <<"EOH"
<DL>
<DT>Your query was:
<DD><b>$query</b>
</DL>
EOH
    ;

    &print_diag;
    &print_headlines;
    #print "<HR>\n<A HREF=\"http:$ENV{'PATH_INFO'}\">Back</A> to query form.\n";
    &print_footer;
    0;
}

sub get_text {
    local($url,$noprint) = @_;

    local($connetion, $database, $doctype) = &parse_url($url);
    local($server, $port) = split(/:/, $connetion);

    $port = 210 unless $port;
    $database = &decode($database);
    &dprint("server=%s database=%s port=%s qtype=%s url=%s",
            $server, $database, $port, 
            $TextRetrievalQuery, 
            $url);
    ($tx,$di) = &WAISretrieve($server, $port, $database, $url);
    push(@documenttext,$tx);
    for (split($WAISrecsep, $di)) {
        &add_diag($server,$database,$_);
    }
    unless ($noprint){
        &print_diag;
        &print_text($doctype);
    }
}

if ($0 =~ /waisserver/) {
    if ($#ARGV == $[) {
        &get_text(@ARGV);
    } else {
        &do_waisq(@ARGV);
    }
} else {
    1;
}

