#!/usr/local/bin/perl -w
# (c) 1996 - Alexandre FENYO - fenyo@enst.fr

use NDBM_File;
use Fcntl;

if ($#ARGV < 0) {
    print "usage: ", $0, " output_index_file\n", $0,
    " will read the databases from STDIN.\n";
    exit 1;
}

tie(%AS, NDBM_File, shift, O_RDWR|O_CREAT, 0644)
    || die "tie: $!";

$route = '';
while ($line = <>) {
  ($line =~ m%^\*rt: ([0-9./]*)$%) && ($route = $1);
  if ($line =~ m%^\*or: AS([0-9]*)%) {
    $AS{$route} = $1;
  };
};

untie(%AS);

__END__

