
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsepart.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsepart.h>


#line 26 "bsepart.proc"


/* --- insert-note --- */
static GType type_id_insert_note = 0;
static void
insert_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsepart.proc"
 {
#line 30 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Start Tick", NULL,
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Tick Duration", NULL,
			       1, BSE_PART_MAX_TICK, 1, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("note", "Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_int ("fine_tune", "Fine Tune", "Fine tune in cents per semitone",
			      BSE_MIN_FINE_TUNE, BSE_MAX_FINE_TUNE,
			      0, 10,
			      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_float ("velocity", "Velocity", NULL,
				0, 1.0,
				1.0, 0.01,
				BSE_PARAM_DEFAULT | BSE_PARAM_HINT_SCALE);
  *(out_pspecs++) = bse_param_spec_uint ("id", "ID", NULL,
			       0, BSE_PART_MAX_TICK, 0, 10, BSE_PARAM_DEFAULT);
}
#line 29 "bsepart.proc"
  proc->help = "Insert a new note into a part.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 49 "bsepart.proc"
 }
static BseErrorType
#line 49 "bsepart.proc"
insert_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 52 "bsepart.proc"
{
#line 53 "bsepart.proc"
  
  BsePart *self      = g_value_get_object (in_values++);
  guint    tick	     = g_value_get_uint (in_values++);
  guint    duration  = g_value_get_uint (in_values++);
  gint     note	     = bse_value_get_note (in_values++);
  gint     fine_tune = g_value_get_int (in_values++);
  gfloat   velocity  = g_value_get_float (in_values++);
  guint id;
  
#line 62 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 66 "bsepart.proc"
  
  id = bse_part_insert_note (self, tick, duration, note, fine_tune, velocity);

#line 69 "bsepart.proc"
  
  g_value_set_uint (out_values++, id);

  return BSE_ERROR_NONE;
}

/* --- change-note --- */
static GType type_id_change_note = 0;
static void
change_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 75 "bsepart.proc"
 {
#line 77 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("id", "ID", NULL,
			       0, BSE_PART_MAX_TICK, 0, 10, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Start Tick", NULL,
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Tick Duration", NULL,
			       1, BSE_PART_MAX_TICK, 1, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("note", "Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_int ("fine_tune", "Fine Tune", "Fine tune in cents per semitone",
			      BSE_MIN_FINE_TUNE, BSE_MAX_FINE_TUNE,
			      0, 10,
			      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_float ("velocity", "Velocity", NULL,
				0, 1.0,
				1.0, 0.01,
				BSE_PARAM_DEFAULT | BSE_PARAM_HINT_SCALE);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 76 "bsepart.proc"
  proc->help = "Change an existing note within a part.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 99 "bsepart.proc"
 }
static BseErrorType
#line 99 "bsepart.proc"
change_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 102 "bsepart.proc"
{
#line 103 "bsepart.proc"
  
  BsePart *self      = g_value_get_object (in_values++);
  guint    id	     = g_value_get_uint (in_values++);
  guint    tick	     = g_value_get_uint (in_values++);
  guint    duration  = g_value_get_uint (in_values++);
  gint     note	     = bse_value_get_note (in_values++);
  gint     fine_tune = g_value_get_int (in_values++);
  gfloat   velocity  = g_value_get_float (in_values++);
  gboolean success;

#line 113 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 117 "bsepart.proc"
  
  success = bse_part_change_note (self, id, tick, duration, note, fine_tune, velocity);

#line 120 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NOT_FOUND);

  return BSE_ERROR_NONE;
}

/* --- delete-event --- */
static GType type_id_delete_event = 0;
static void
delete_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 126 "bsepart.proc"
 {
#line 128 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("id", "ID", NULL,
			       0, BSE_PART_MAX_TICK, 0, 10, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 127 "bsepart.proc"
  proc->help = "Delete an existing event from a part.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 136 "bsepart.proc"
 }
static BseErrorType
#line 136 "bsepart.proc"
delete_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 139 "bsepart.proc"
{
#line 140 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    id	    = g_value_get_uint (in_values++);
  gboolean deleted;
  
#line 145 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 149 "bsepart.proc"
  
  deleted = bse_part_delete_event (self, id);

#line 152 "bsepart.proc"
  
  g_value_set_enum (out_values++, deleted ? BSE_ERROR_NONE : BSE_ERROR_NOT_FOUND);

  return BSE_ERROR_NONE;
}

/* --- is-selected-event --- */
static GType type_id_is_selected_event = 0;
static void
is_selected_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 158 "bsepart.proc"
 {
#line 160 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("id", "ID", NULL,
			       0, BSE_PART_MAX_TICK, 0, 10, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("selected", "Selected", NULL,
				FALSE,
				BSE_PARAM_DEFAULT);
}
#line 159 "bsepart.proc"
  proc->help = "Check whether a specific event is selected.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 168 "bsepart.proc"
 }
static BseErrorType
#line 168 "bsepart.proc"
is_selected_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 171 "bsepart.proc"
{
#line 172 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    id	    = g_value_get_uint (in_values++);
  gboolean selected;
  
#line 177 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 181 "bsepart.proc"
  
  selected = bse_part_is_selected_event (self, id);

#line 184 "bsepart.proc"
  
  g_value_set_boolean (out_values++, selected);

  return BSE_ERROR_NONE;
}

/* --- list-notes-crossing --- */
static GType type_id_list_notes_crossing = 0;
static void
list_notes_crossing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 190 "bsepart.proc"
 {
#line 192 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Start Tick", NULL,
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Tick Duration", NULL,
			       1, BSE_PART_MAX_TICK, 1, 384, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note_list", NULL, NULL,
			      BSW_TYPE_ITER_PART_NOTE,
			      BSE_PARAM_DEFAULT);
}
#line 191 "bsepart.proc"
  proc->help = "List all notes within or crossing a tick range.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 202 "bsepart.proc"
 }
static BseErrorType
#line 202 "bsepart.proc"
list_notes_crossing_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 205 "bsepart.proc"
{
#line 206 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    tick	    = g_value_get_uint (in_values++);
  guint    duration = g_value_get_uint (in_values++);
  BswIterPartNote *iter;

#line 212 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 216 "bsepart.proc"
  
  iter = bse_part_list_notes_around (self, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE);

#line 219 "bsepart.proc"
  
  g_value_set_boxed_take_ownership (out_values++, iter);

  return BSE_ERROR_NONE;
}

/* --- queue-notes-within --- */
static GType type_id_queue_notes_within = 0;
static void
queue_notes_within_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 225 "bsepart.proc"
 {
#line 227 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Start Tick", NULL,
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Tick Duration", NULL,
			       1, BSE_PART_MAX_TICK, 1, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("min_note", "Minimum Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("max_note", "Maximum Note", NULL,
				      BSE_PARAM_DEFAULT);
}
#line 226 "bsepart.proc"
  proc->help = "Queue updates for all notes starting within the given region.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 238 "bsepart.proc"
 }
static BseErrorType
#line 238 "bsepart.proc"
queue_notes_within_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 241 "bsepart.proc"
{
#line 242 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    tick	    = g_value_get_uint (in_values++);
  guint    duration = g_value_get_uint (in_values++);
  gint     min_note = bse_value_get_note (in_values++);
  gint     max_note = bse_value_get_note (in_values++);

#line 249 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 253 "bsepart.proc"
  
  bse_part_queue_notes_within (self, tick, duration, min_note, max_note);

  return BSE_ERROR_NONE;
}

/* --- list-selected-notes --- */
static GType type_id_list_selected_notes = 0;
static void
list_selected_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 259 "bsepart.proc"
 {
#line 261 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note_list", NULL, NULL,
			      BSW_TYPE_ITER_PART_NOTE,
			      BSE_PARAM_DEFAULT);
}
#line 260 "bsepart.proc"
  proc->help = "List all currently selected notes.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 267 "bsepart.proc"
 }
static BseErrorType
#line 267 "bsepart.proc"
list_selected_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 270 "bsepart.proc"
{
#line 271 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  BswIterPartNote *iter;

#line 275 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 279 "bsepart.proc"
  
  iter = bse_part_list_selected_notes (self);

#line 282 "bsepart.proc"
  
  g_value_set_boxed_take_ownership (out_values++, iter);

  return BSE_ERROR_NONE;
}

/* --- check-overlap --- */
static GType type_id_check_overlap = 0;
static void
check_overlap_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 288 "bsepart.proc"
 {
#line 290 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Start Tick", NULL,
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Tick Duration", NULL,
			       1, BSE_PART_MAX_TICK, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("note", "Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note_list", NULL, NULL,
			      BSW_TYPE_ITER_PART_NOTE,
			      BSE_PARAM_DEFAULT);
}
#line 289 "bsepart.proc"
  proc->help = "Check whether a note would overlap with neighbours.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 302 "bsepart.proc"
 }
static BseErrorType
#line 302 "bsepart.proc"
check_overlap_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 305 "bsepart.proc"
{
#line 306 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    tick	    = g_value_get_uint (in_values++);
  guint    duration = g_value_get_uint (in_values++);
  gint     note     = bse_value_get_note (in_values++);
  BswIterPartNote *iter;

#line 313 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 317 "bsepart.proc"
  
  iter = bse_part_list_notes_around (self, tick, duration, note, note);

#line 320 "bsepart.proc"
  
  g_value_set_boxed_take_ownership (out_values++, iter);

  return BSE_ERROR_NONE;
}

/* --- get-notes --- */
static GType type_id_get_notes = 0;
static void
get_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 326 "bsepart.proc"
 {
#line 328 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Tick", NULL,
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("note", "Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note_list", NULL, NULL,
			      BSW_TYPE_ITER_PART_NOTE,
			      BSE_PARAM_DEFAULT);
}
#line 327 "bsepart.proc"
  proc->help = "Retrive all notes of specific frequency at a specific tick.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 338 "bsepart.proc"
 }
static BseErrorType
#line 338 "bsepart.proc"
get_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 341 "bsepart.proc"
{
#line 342 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    tick	    = g_value_get_uint (in_values++);
  gint     note     = bse_value_get_note (in_values++);
  BswIterPartNote *iter;

#line 348 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 352 "bsepart.proc"
  
  iter = bse_part_list_notes_at (self, tick, note);

#line 355 "bsepart.proc"
  
  g_value_set_boxed_take_ownership (out_values++, iter);

  return BSE_ERROR_NONE;
}

/* --- get-min-note --- */
static GType type_id_get_min_note = 0;
static void
get_min_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 361 "bsepart.proc"
 {
#line 363 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_note_simple ("note", "Note", NULL,
				      BSE_PARAM_DEFAULT);
}
#line 362 "bsepart.proc"
  proc->help = "Retrive the minimum note supported in this part.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 368 "bsepart.proc"
 }
static BseErrorType
#line 368 "bsepart.proc"
get_min_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 371 "bsepart.proc"
{
#line 372 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);

#line 375 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 379 "bsepart.proc"
  
  g_value_set_int (out_values++, BSE_MIN_NOTE);

  return BSE_ERROR_NONE;
}

/* --- get-max-note --- */
static GType type_id_get_max_note = 0;
static void
get_max_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 385 "bsepart.proc"
 {
#line 387 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_note_simple ("note", "Note", NULL,
				      BSE_PARAM_DEFAULT);
}
#line 386 "bsepart.proc"
  proc->help = "Retrive the maximum note supported in this part.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 392 "bsepart.proc"
 }
static BseErrorType
#line 392 "bsepart.proc"
get_max_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 395 "bsepart.proc"
{
#line 396 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);

#line 399 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 403 "bsepart.proc"
  
  g_value_set_int (out_values++, BSE_MAX_NOTE);

  return BSE_ERROR_NONE;
}

/* --- get-max-tick --- */
static GType type_id_get_max_tick = 0;
static void
get_max_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 409 "bsepart.proc"
 {
#line 411 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_uint ("tick", "Tick", "Maximum Tick",
			       0, BSE_PART_MAX_TICK, 0, 384, BSE_PARAM_DEFAULT);
}
#line 410 "bsepart.proc"
  proc->help = "Retrive the maximum tick count represented in a part.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 416 "bsepart.proc"
 }
static BseErrorType
#line 416 "bsepart.proc"
get_max_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 419 "bsepart.proc"
{
#line 420 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);

#line 423 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 427 "bsepart.proc"
  
  g_value_set_uint (out_values++, BSE_PART_MAX_TICK);

  return BSE_ERROR_NONE;
}

/* --- select-rectangle-exclusive --- */
static GType type_id_select_rectangle_exclusive = 0;
static void
select_rectangle_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 433 "bsepart.proc"
 {
#line 435 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", "Part",
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Tick", "Selection Tick",
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Duration", "Selection Duration",
			       0, BSE_PART_MAX_TICK, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("min_note", "Minimum Selection Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("max_note", "Maximum Selection Note", NULL,
				      BSE_PARAM_DEFAULT);
}
#line 434 "bsepart.proc"
  proc->help = "Select all notes within rectangle and deselect all others.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 446 "bsepart.proc"
 }
static BseErrorType
#line 446 "bsepart.proc"
select_rectangle_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 449 "bsepart.proc"
{
#line 450 "bsepart.proc"
  
  BsePart *self   = g_value_get_object (in_values++);
  guint tick      = g_value_get_uint (in_values++);
  guint duration  = g_value_get_uint (in_values++);
  gint  min_note  = bse_value_get_note (in_values++);
  gint  max_note  = bse_value_get_note (in_values++);
  
#line 457 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_rectangle_ex (self, tick, duration, min_note, max_note);

  return BSE_ERROR_NONE;
}

/* --- select-rectangle --- */
static GType type_id_select_rectangle = 0;
static void
select_rectangle_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 466 "bsepart.proc"
 {
#line 468 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", "Part",
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Tick", "Selection Tick",
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Duration", "Selection Duration",
			       0, BSE_PART_MAX_TICK, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("min_note", "Minimum Selection Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("max_note", "Maximum Selection Note", NULL,
				      BSE_PARAM_DEFAULT);
}
#line 467 "bsepart.proc"
  proc->help = "Select all notes within rectangle.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 479 "bsepart.proc"
 }
static BseErrorType
#line 479 "bsepart.proc"
select_rectangle_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 482 "bsepart.proc"
{
#line 483 "bsepart.proc"
  
  BsePart *self   = g_value_get_object (in_values++);
  guint tick      = g_value_get_uint (in_values++);
  guint duration  = g_value_get_uint (in_values++);
  gint  min_note  = bse_value_get_note (in_values++);
  gint  max_note  = bse_value_get_note (in_values++);
  
#line 490 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_rectangle (self, tick, duration, min_note, max_note);

  return BSE_ERROR_NONE;
}

/* --- deselect-rectangle --- */
static GType type_id_deselect_rectangle = 0;
static void
deselect_rectangle_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 499 "bsepart.proc"
 {
#line 501 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", "Part",
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("tick", "Tick", "Selection Tick",
			       0, BSE_PART_MAX_TICK - 1, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("duration", "Duration", "Selection Duration",
			       0, BSE_PART_MAX_TICK, 0, 384, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("min_note", "Minimum Selection Note", NULL,
				      BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_note_simple ("max_note", "Maximum Selection Note", NULL,
				      BSE_PARAM_DEFAULT);
}
#line 500 "bsepart.proc"
  proc->help = "Deselect all notes within rectangle.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 512 "bsepart.proc"
 }
static BseErrorType
#line 512 "bsepart.proc"
deselect_rectangle_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 515 "bsepart.proc"
{
#line 516 "bsepart.proc"
  
  BsePart *self   = g_value_get_object (in_values++);
  guint tick      = g_value_get_uint (in_values++);
  guint duration  = g_value_get_uint (in_values++);
  gint  min_note  = bse_value_get_note (in_values++);
  gint  max_note  = bse_value_get_note (in_values++);
  
#line 523 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_deselect_rectangle (self, tick, duration, min_note, max_note);

  return BSE_ERROR_NONE;
}

/* --- select-event --- */
static GType type_id_select_event = 0;
static void
select_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 532 "bsepart.proc"
 {
#line 534 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("id", "ID", NULL,
			       0, BSE_PART_MAX_TICK, 0, 10, BSE_PARAM_DEFAULT);
}
#line 533 "bsepart.proc"
  proc->help = "Select an existing event.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 539 "bsepart.proc"
 }
static BseErrorType
#line 539 "bsepart.proc"
select_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 542 "bsepart.proc"
{
#line 543 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    id	    = g_value_get_uint (in_values++);
  gboolean id_valid;
  
#line 548 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 552 "bsepart.proc"
  
  id_valid = bse_part_select_event (self, id);

  return id_valid ? BSE_ERROR_NONE : BSE_ERROR_PROC_PARAM_INVAL;
}

/* --- deselect-event --- */
static GType type_id_deselect_event = 0;
static void
deselect_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 558 "bsepart.proc"
 {
#line 560 "bsepart.proc"
  *(in_pspecs++) = g_param_spec_object ("part", "Part", NULL,
 			       BSE_TYPE_PART, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_uint ("id", "ID", NULL,
			       0, BSE_PART_MAX_TICK, 0, 10, BSE_PARAM_DEFAULT);
}
#line 559 "bsepart.proc"
  proc->help = "Deselect an existing event.";
#line 23 "bsepart.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 24 "bsepart.proc"
  proc->copyright = "Tim Janik";
#line 25 "bsepart.proc"
  proc->date = "2002";
#line 565 "bsepart.proc"
 }
static BseErrorType
#line 565 "bsepart.proc"
deselect_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 568 "bsepart.proc"
{
#line 569 "bsepart.proc"
  
  BsePart *self     = g_value_get_object (in_values++);
  guint    id	    = g_value_get_uint (in_values++);
  gboolean id_valid;
  
#line 574 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 578 "bsepart.proc"
  
  id_valid = bse_part_deselect_event (self, id);

  return id_valid ? BSE_ERROR_NONE : BSE_ERROR_PROC_PARAM_INVAL;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_insert_note, "BsePart+insert-note", NULL, 0, insert_note_setup, insert_note_exec, NULL, "/Method/BsePart/General/Insert Note", { 0, }, },
  { &type_id_change_note, "BsePart+change-note", NULL, 0, change_note_setup, change_note_exec, NULL, "/Method/BsePart/General/Change Note", { 0, }, },
  { &type_id_delete_event, "BsePart+delete-event", NULL, 0, delete_event_setup, delete_event_exec, NULL, "/Method/BsePart/General/Delete Event", { 0, }, },
  { &type_id_is_selected_event, "BsePart+is-selected-event", NULL, 0, is_selected_event_setup, is_selected_event_exec, NULL, "/Method/BsePart/General/Is Selected Event", { 0, }, },
  { &type_id_list_notes_crossing, "BsePart+list-notes-crossing", NULL, 0, list_notes_crossing_setup, list_notes_crossing_exec, NULL, "/Method/BsePart/General/List Notes Crossing", { 0, }, },
  { &type_id_queue_notes_within, "BsePart+queue-notes-within", NULL, 0, queue_notes_within_setup, queue_notes_within_exec, NULL, "/Method/BsePart/General/Queue Notes Within", { 0, }, },
  { &type_id_list_selected_notes, "BsePart+list-selected-notes", NULL, 0, list_selected_notes_setup, list_selected_notes_exec, NULL, "/Method/BsePart/General/List Selected Notes", { 0, }, },
  { &type_id_check_overlap, "BsePart+check-overlap", NULL, 0, check_overlap_setup, check_overlap_exec, NULL, "/Method/BsePart/General/Check Overlap", { 0, }, },
  { &type_id_get_notes, "BsePart+get-notes", NULL, 0, get_notes_setup, get_notes_exec, NULL, "/Method/BsePart/General/Get Notes", { 0, }, },
  { &type_id_get_min_note, "BsePart+get-min-note", NULL, 0, get_min_note_setup, get_min_note_exec, NULL, "/Method/BsePart/General/Get Min Note", { 0, }, },
  { &type_id_get_max_note, "BsePart+get-max-note", NULL, 0, get_max_note_setup, get_max_note_exec, NULL, "/Method/BsePart/General/Get Max Note", { 0, }, },
  { &type_id_get_max_tick, "BsePart+get-max-tick", NULL, 0, get_max_tick_setup, get_max_tick_exec, NULL, "/Method/BsePart/General/Get Max Tick", { 0, }, },
  { &type_id_select_rectangle_exclusive, "BsePart+select-rectangle-exclusive", NULL, 0, select_rectangle_exclusive_setup, select_rectangle_exclusive_exec, NULL, "/Method/BsePart/General/Select Rectangle Exclusive", { 0, }, },
  { &type_id_select_rectangle, "BsePart+select-rectangle", NULL, 0, select_rectangle_setup, select_rectangle_exec, NULL, "/Method/BsePart/General/Select Rectangle", { 0, }, },
  { &type_id_deselect_rectangle, "BsePart+deselect-rectangle", NULL, 0, deselect_rectangle_setup, deselect_rectangle_exec, NULL, "/Method/BsePart/General/Deselect Rectangle", { 0, }, },
  { &type_id_select_event, "BsePart+select-event", NULL, 0, select_event_setup, select_event_exec, NULL, "/Method/BsePart/General/Select Event", { 0, }, },
  { &type_id_deselect_event, "BsePart+deselect-event", NULL, 0, deselect_event_setup, deselect_event_exec, NULL, "/Method/BsePart/General/Deselect Event", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
