
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseprocedure.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsescripthelper.h>
#include <bse/bseserver.h>
#include <bse/bswprivate.h>


#line 28 "bseprocedure.proc"

/* --- bse-note-to-freq --- */
static GType type_id_bse_note_to_freq = 0;
static void
bse_note_to_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bseprocedure.proc"
 {
#line 31 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_uint ("note", "Note", NULL,
			       BSE_MIN_NOTE, BSE_MAX_NOTE,
			       BSE_KAMMER_NOTE, 1,
			       BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_int ("fine_tune", "Fine Tune", NULL,
			      BSE_MIN_FINE_TUNE, BSE_MAX_FINE_TUNE,
			      0, 1, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_float ("frequency", "Frequency", NULL,
				0, BSE_MAX_FREQUENCY_f, BSE_KAMMER_FREQUENCY_f, 0.1,
				BSE_PARAM_DEFAULT);
#line 30 "bseprocedure.proc"
  proc->help = "Retrive the frequency of a certain note.";
#line 25 "bseprocedure.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseprocedure.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseprocedure.proc"
  proc->date = "2002";
#line 41 "bseprocedure.proc"
}  }
static BseErrorType
#line 41 "bseprocedure.proc"
bse_note_to_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 44 "bseprocedure.proc"
{
#line 45 "bseprocedure.proc"
  
  gint       note       = g_value_get_uint (in_values++);
  gint       fine_tune  = g_value_get_int (in_values++);
  BswNoteDescription *info;
  gfloat freq;
  
#line 51 "bseprocedure.proc"
  
  info = bsw_note_description (note, fine_tune);
  if (!info->name)
    freq = 0;
  else
    freq = info->freq;
  bsw_note_description_free (info);

#line 59 "bseprocedure.proc"
  
  g_value_set_float (out_values++, freq);
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-from-freq --- */
static GType type_id_bse_note_from_freq = 0;
static void
bse_note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 65 "bseprocedure.proc"
 {
#line 67 "bseprocedure.proc"
  *(in_pspecs++)    = bse_param_spec_float ("frequency", "Frequency", NULL,
				0, BSE_MAX_FREQUENCY_f, BSE_KAMMER_FREQUENCY_f, 0.1,
				BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_uint ("note", "Note", NULL,
			       BSE_MIN_NOTE, BSE_MAX_NOTE,
			       BSE_KAMMER_NOTE, 1,
			       BSE_PARAM_DEFAULT);
#line 66 "bseprocedure.proc"
  proc->help = "Retrive the note of a certain frequency.";
#line 25 "bseprocedure.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bseprocedure.proc"
  proc->copyright = "Tim Janik";
#line 27 "bseprocedure.proc"
  proc->date = "2002";
#line 74 "bseprocedure.proc"
}  }
static BseErrorType
#line 74 "bseprocedure.proc"
bse_note_from_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 77 "bseprocedure.proc"
{
#line 78 "bseprocedure.proc"
  
  gfloat frequency = g_value_get_float (in_values++);
  
#line 81 "bseprocedure.proc"
  
  g_value_set_uint (out_values++, bse_note_from_freq (frequency));
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_bse_note_to_freq, "bse-note-to-freq", NULL, 0, bse_note_to_freq_setup, bse_note_to_freq_exec, NULL, "/Proc/Utils/Notes/Note to Freq", { 0, }, },
  { &type_id_bse_note_from_freq, "bse-note-from-freq", NULL, 0, bse_note_from_freq_setup, bse_note_from_freq_exec, NULL, "/Proc/Utils/Notes/Note from Freq", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
