
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesong.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsesong.h>
#include        <bse/bsepart.h>
#include        <bse/bsetrack.h>

#line 28 "bsesong.proc"


/* --- create-part --- */
static GType type_id_create_part = 0;
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bsesong.proc"
 {
#line 32 "bsesong.proc"
  *(in_pspecs++)    = g_param_spec_object ("song", "Song", NULL,
                               BSE_TYPE_SONG, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("part", "Part", NULL,
                               BSE_TYPE_PART, BSE_PARAM_DEFAULT);
#line 31 "bsesong.proc"
  proc->help = "Create a new Part in a Song";
#line 25 "bsesong.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesong.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesong.proc"
  proc->date = "2002";
#line 36 "bsesong.proc"
}  }
static BseErrorType
#line 36 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 39 "bsesong.proc"
{
#line 40 "bsesong.proc"
  
  BseSong *song = g_value_get_object (in_values++);
  BsePart *part;

#line 44 "bsesong.proc"
  
  if (!BSE_IS_SONG (song))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 48 "bsesong.proc"
  
  part = bse_object_new (BSE_TYPE_PART,
                         NULL);
  bse_container_add_item (BSE_CONTAINER (song), BSE_ITEM (part));

#line 53 "bsesong.proc"
  
  g_value_set_object (out_values++, G_OBJECT (part));
  g_object_unref (part);

  return BSE_ERROR_NONE;
}

/* --- remove-part --- */
static GType type_id_remove_part = 0;
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 60 "bsesong.proc"
 {
#line 62 "bsesong.proc"
  *(in_pspecs++)    = g_param_spec_object ("song", "Song", NULL,
                               BSE_TYPE_SONG, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_object ("part", "Part", NULL,
                               BSE_TYPE_PART, BSE_PARAM_DEFAULT);
#line 61 "bsesong.proc"
  proc->help = "Delete a Part from a Song";
#line 25 "bsesong.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesong.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesong.proc"
  proc->date = "2002";
#line 66 "bsesong.proc"
}  }
static BseErrorType
#line 66 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 69 "bsesong.proc"
{
#line 70 "bsesong.proc"
  
  BseSong *self = g_value_get_object (in_values++);
  BsePart *part = g_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 75 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) || BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 79 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    bse_container_remove_item (BSE_CONTAINER (self), BSE_ITEM (part));

  return error;
}

/* --- create-track --- */
static GType type_id_create_track = 0;
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 88 "bsesong.proc"
 {
#line 90 "bsesong.proc"
  *(in_pspecs++)    = g_param_spec_object ("song", "Song", NULL,
                               BSE_TYPE_SONG, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("track", "Track", NULL,
                               BSE_TYPE_TRACK, BSE_PARAM_DEFAULT);
#line 89 "bsesong.proc"
  proc->help = "Create a new Track for a Song";
#line 25 "bsesong.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesong.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesong.proc"
  proc->date = "2002";
#line 94 "bsesong.proc"
}  }
static BseErrorType
#line 94 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 97 "bsesong.proc"
{
#line 98 "bsesong.proc"
  
  BseSong *self = g_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  GObject *track = NULL;

#line 103 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 107 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    track = bse_container_new_item (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);

#line 113 "bsesong.proc"
  
  g_value_set_object (out_values++, track);

  return error;
}

/* --- remove-track --- */
static GType type_id_remove_track = 0;
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 119 "bsesong.proc"
 {
#line 121 "bsesong.proc"
  *(in_pspecs++)    = g_param_spec_object ("song", "Song", NULL,
                               BSE_TYPE_SONG, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_object ("track", "Track", NULL,
                               BSE_TYPE_TRACK, BSE_PARAM_DEFAULT);
#line 120 "bsesong.proc"
  proc->help = "Delete a Track from a Song";
#line 25 "bsesong.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 26 "bsesong.proc"
  proc->copyright = "Tim Janik";
#line 27 "bsesong.proc"
  proc->date = "2002";
#line 125 "bsesong.proc"
}  }
static BseErrorType
#line 125 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 128 "bsesong.proc"
{
#line 129 "bsesong.proc"
  
  BseSong *self   = g_value_get_object (in_values++);
  BseTrack *track = g_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 134 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 139 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    bse_container_remove_item (BSE_CONTAINER (self), BSE_ITEM (track));

  return error;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_create_part, "BseSong+create-part", NULL, 0, create_part_setup, create_part_exec, NULL, "/Method/BseSong/General/Create Part", { 0, }, },
  { &type_id_remove_part, "BseSong+remove-part", NULL, 0, remove_part_setup, remove_part_exec, NULL, "/Method/BseSong/General/Remove Part", { 0, }, },
  { &type_id_create_track, "BseSong+create-track", NULL, 0, create_track_setup, create_track_exec, NULL, "/Method/BseSong/General/Create Track", { 0, }, },
  { &type_id_remove_track, "BseSong+remove-track", NULL, 0, remove_track_setup, remove_track_exec, NULL, "/Method/BseSong/General/Remove Track", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
