
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseitem.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseitem.h>
#include <bse/bsecontainer.h>
#include <bse/bseparasite.h>	// FIXME


#line 28 "bseitem.proc"


/* --- get-type --- */
static GType type_id_get_type = 0;
static void
get_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bseitem.proc"
 {
#line 32 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("type_id", "Type ID", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 31 "bseitem.proc"
  proc->help = "Retrieve an item's type ID.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 36 "bseitem.proc"
}  }
static BseErrorType
#line 36 "bseitem.proc"
get_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 39 "bseitem.proc"
{
#line 40 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 43 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 47 "bseitem.proc"
  
  sfi_value_set_static_string (out_values++, g_type_name (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-name --- */
static GType type_id_get_type_name = 0;
static void
get_type_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 53 "bseitem.proc"
 {
#line 55 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("type_name", "Type Name", NULL,
			    NULL,
			    SFI_PARAM_DEFAULT);
#line 54 "bseitem.proc"
  proc->help = "Retrieve an item's type name.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 60 "bseitem.proc"
}  }
static BseErrorType
#line 60 "bseitem.proc"
get_type_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 63 "bseitem.proc"
{
#line 64 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 67 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 71 "bseitem.proc"
  
  sfi_value_set_string (out_values++, g_type_name (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-blurb --- */
static GType type_id_get_type_blurb = 0;
static void
get_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 77 "bseitem.proc"
 {
#line 79 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("type_blurb", "Type Blurb", NULL,
			    NULL,
			    SFI_PARAM_DEFAULT);
#line 78 "bseitem.proc"
  proc->help = "Retrieve an item's type description.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 84 "bseitem.proc"
}  }
static BseErrorType
#line 84 "bseitem.proc"
get_type_blurb_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 87 "bseitem.proc"
{
#line 88 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 91 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 95 "bseitem.proc"
  
  sfi_value_set_string (out_values++, bse_type_blurb (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-parent --- */
static GType type_id_get_parent = 0;
static void
get_parent_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 101 "bseitem.proc"
 {
#line 103 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("parent", "Parent", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 102 "bseitem.proc"
  proc->help = "Retrieve an item's parent.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 107 "bseitem.proc"
}  }
static BseErrorType
#line 107 "bseitem.proc"
get_parent_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 110 "bseitem.proc"
{
#line 111 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 114 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 118 "bseitem.proc"
  
  bse_value_set_object (out_values++, item->parent);
  
  return BSE_ERROR_NONE;
}

/* --- get-project --- */
static GType type_id_get_project = 0;
static void
get_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 124 "bseitem.proc"
 {
#line 126 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("project", "Project", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 125 "bseitem.proc"
  proc->help = "Retrieve an item's project.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 130 "bseitem.proc"
}  }
static BseErrorType
#line 130 "bseitem.proc"
get_project_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 133 "bseitem.proc"
{
#line 134 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 137 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 141 "bseitem.proc"
  
  bse_value_set_object (out_values++, bse_item_get_project (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-uname-path --- */
static GType type_id_get_uname_path = 0;
static void
get_uname_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 147 "bseitem.proc"
 {
#line 149 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("uname_path", NULL, NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 148 "bseitem.proc"
  proc->help = "Retrieve the project relative uname path for this item.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 153 "bseitem.proc"
}  }
static BseErrorType
#line 153 "bseitem.proc"
get_uname_path_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 156 "bseitem.proc"
{
#line 157 "bseitem.proc"
  
  BseItem *item = bse_value_get_object (in_values++);
  BseProject *project;
  
#line 161 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  project = bse_item_get_project (item);
  
#line 167 "bseitem.proc"
  
  sfi_value_take_string (out_values++,
			 project ? bse_container_make_upath (BSE_CONTAINER (project), item) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- use --- */
static GType type_id_use = 0;
static void
use_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 174 "bseitem.proc"
 {
#line 176 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("used_item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 175 "bseitem.proc"
  proc->help = "Increment use count to keep an item alive.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 180 "bseitem.proc"
}  }
static BseErrorType
#line 180 "bseitem.proc"
use_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 183 "bseitem.proc"
{
#line 184 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 187 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item) || (!item->parent && !item->use_count))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 191 "bseitem.proc"
  
  bse_item_use (item);
  
#line 194 "bseitem.proc"
  
  bse_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- unuse --- */
static GType type_id_unuse = 0;
static void
unuse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 200 "bseitem.proc"
 {
#line 202 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 201 "bseitem.proc"
  proc->help = "Decrement use count for when an item is not needed anymore.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 204 "bseitem.proc"
}  }
static BseErrorType
#line 204 "bseitem.proc"
unuse_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 207 "bseitem.proc"
{
#line 208 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 211 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 215 "bseitem.proc"
  
  if (item->use_count < 1)
    return BSE_ERROR_NOT_OWNER;

  bse_item_unuse (item);
  
  return BSE_ERROR_NONE;
}

/* --- set-name --- */
static GType type_id_set_name = 0;
static void
set_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 224 "bseitem.proc"
 {
#line 226 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 225 "bseitem.proc"
  proc->help = "Set an item's name.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 230 "bseitem.proc"
}  }
static BseErrorType
#line 230 "bseitem.proc"
set_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 233 "bseitem.proc"
{
#line 234 "bseitem.proc"
  
  BseItem *item     = bse_value_get_object (in_values++);
  const gchar *name = g_value_get_string (in_values++);

#line 238 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 242 "bseitem.proc"
  
  g_object_set (item, "uname", name, NULL);

  return BSE_ERROR_NONE;
}


/* --- get-name --- */
static GType type_id_get_name = 0;
static void
get_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 249 "bseitem.proc"
 {
#line 251 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 250 "bseitem.proc"
  proc->help = "Retrieve an item's name.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 255 "bseitem.proc"
}  }
static BseErrorType
#line 255 "bseitem.proc"
get_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 258 "bseitem.proc"
{
#line 259 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 262 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 266 "bseitem.proc"
  
  sfi_value_set_string (out_values++, BSE_OBJECT_UNAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-name-or-type --- */
static GType type_id_get_name_or_type = 0;
static void
get_name_or_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 272 "bseitem.proc"
 {
#line 274 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 273 "bseitem.proc"
  proc->help = "Retrieve an item's name or type if it has no name.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 278 "bseitem.proc"
}  }
static BseErrorType
#line 278 "bseitem.proc"
get_name_or_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 281 "bseitem.proc"
{
#line 282 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  gchar *name = NULL;
  
#line 286 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 290 "bseitem.proc"
  
  name = BSE_OBJECT_UNAME (item);
  if (name)
    sfi_value_set_string (out_values++, name);
  else
    sfi_value_set_string (out_values++, BSE_OBJECT_TYPE_NAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- common-ancestor --- */
static GType type_id_common_ancestor = 0;
static void
common_ancestor_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 300 "bseitem.proc"
 {
#line 302 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", "First item",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("item2", "Item2", "Second item",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("ancestor", "ancestor", "Common ancestor of both items",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 301 "bseitem.proc"
  proc->help = "Retrieve the common ancestor of two items if there's any.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 308 "bseitem.proc"
}  }
static BseErrorType
#line 308 "bseitem.proc"
common_ancestor_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 311 "bseitem.proc"
{
#line 312 "bseitem.proc"
  
  BseItem *item  = bse_value_get_object (in_values++);
  BseItem *item2 = bse_value_get_object (in_values++);
  
#line 316 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item) || !BSE_IS_ITEM (item2))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 320 "bseitem.proc"
  
  bse_value_set_object (out_values++, bse_item_common_ancestor (item, item2));
  
  return BSE_ERROR_NONE;
}

/* --- get-seqid --- */
static GType type_id_get_seqid = 0;
static void
get_seqid_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 326 "bseitem.proc"
 {
#line 330 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("seq_id", "Sequential ID", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 327 "bseitem.proc"
  proc->help = ("Retrieve an item's sequential ID. The sequential ID depends "
	   "on the item's type an it's position inbetween siblings "
	   "of the same type within it's immediate container.");
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 334 "bseitem.proc"
}  }
static BseErrorType
#line 334 "bseitem.proc"
get_seqid_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 337 "bseitem.proc"
{
#line 338 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 341 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 345 "bseitem.proc"
  
  sfi_value_set_int (out_values++, bse_item_get_seqid (item));
  
  return BSE_ERROR_NONE;
}

/* --- check-is-a --- */
static GType type_id_check_is_a = 0;
static void
check_is_a_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 351 "bseitem.proc"
 {
#line 353 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", "Item", "The Item",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("type_name", "Type Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("is_a", NULL, NULL,
			  FALSE, SFI_PARAM_DEFAULT);
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 359 "bseitem.proc"
}  }
static BseErrorType
#line 359 "bseitem.proc"
check_is_a_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 362 "bseitem.proc"
{
#line 363 "bseitem.proc"
  
  BseItem *item    = bse_value_get_object (in_values++);
  gchar *type_name = sfi_value_get_string (in_values++);
  GType type;
  gboolean is_a;
  
#line 369 "bseitem.proc"
  
  if (!type_name)
    type_name = "";
  
#line 373 "bseitem.proc"
  
  type = g_type_from_name (type_name);
  is_a = item && g_type_is_a (G_OBJECT_TYPE (item), type);
  
#line 377 "bseitem.proc"
  
  sfi_value_set_bool (out_values++, is_a);
  
  return BSE_ERROR_NONE;
}

/* --- list-proxies --- */
static GType type_id_list_proxies = 0;
static void
list_proxies_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 383 "bseitem.proc"
 {
#line 385 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("property_name", NULL, "Proxy property name",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_boxed ("proxy_list", "Proxy List", NULL, BSE_TYPE_PROXY_SEQ, SFI_PARAM_DEFAULT);
#line 384 "bseitem.proc"
  proc->help = "List possible values for a proxy property of an item.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 390 "bseitem.proc"
}  }
static BseErrorType
#line 390 "bseitem.proc"
list_proxies_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 393 "bseitem.proc"
{
#line 394 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  gchar   *property = sfi_value_get_string (in_values++);
  
#line 398 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 402 "bseitem.proc"
  
  bse_value_take_boxed (out_values++, bse_item_list_proxies (self, property));
  
  return BSE_ERROR_NONE;
}

/* --- get-icon --- */
static GType type_id_get_icon = 0;
static void
get_icon_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 408 "bseitem.proc"
 {
#line 410 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_boxed ("icon", NULL, NULL,
				BSE_TYPE_ICON, SFI_PARAM_DEFAULT);
#line 409 "bseitem.proc"
  proc->help = "Get the current icon of an item.";
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 414 "bseitem.proc"
}  }
static BseErrorType
#line 414 "bseitem.proc"
get_icon_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 417 "bseitem.proc"
{
#line 418 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  
#line 421 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 425 "bseitem.proc"
  
  bse_value_set_boxed (out_values++, bse_object_get_icon (BSE_OBJECT (self)));
  
  return BSE_ERROR_NONE;
}

/* --- fixme-set-parasite --- */
static GType type_id_fixme_set_parasite = 0;
static void
fixme_set_parasite_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 431 "bseitem.proc"
 {
#line 432 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_fblock ("parasite", NULL, NULL, SFI_PARAM_DEFAULT);
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 436 "bseitem.proc"
}  }
static BseErrorType
#line 436 "bseitem.proc"
fixme_set_parasite_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 439 "bseitem.proc"
{
#line 440 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  const gchar *name = sfi_value_get_string (in_values++);
  SfiFBlock *fblock = sfi_value_get_fblock (in_values++);
  
#line 445 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !name || !fblock)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 449 "bseitem.proc"
  
  bse_parasite_set_floats (BSE_OBJECT (self), name, fblock->n_values, fblock->values);
  
  return BSE_ERROR_NONE;
}

/* --- fixme-get-parasite --- */
static GType type_id_fixme_get_parasite = 0;
static void
fixme_get_parasite_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 455 "bseitem.proc"
 {
#line 456 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_fblock ("parasite", NULL, NULL, SFI_PARAM_DEFAULT);
#line 26 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 460 "bseitem.proc"
}  }
static BseErrorType
#line 460 "bseitem.proc"
fixme_get_parasite_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 463 "bseitem.proc"
{
#line 464 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  const gchar *name = sfi_value_get_string (in_values++);
  
#line 468 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 472 "bseitem.proc"
  
  sfi_value_take_fblock (out_values++, bse_parasite_get_floats (BSE_OBJECT (self), name));
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_get_type, "BseItem+get-type", NULL, 0, get_type_setup, get_type_exec, NULL, "/Method/BseItem/General/Get Type", { 0, }, },
  { &type_id_get_type_name, "BseItem+get-type-name", NULL, 0, get_type_name_setup, get_type_name_exec, NULL, "/Method/BseItem/General/Get Type Name", { 0, }, },
  { &type_id_get_type_blurb, "BseItem+get-type-blurb", NULL, 0, get_type_blurb_setup, get_type_blurb_exec, NULL, "/Method/BseItem/General/Get Type Blurb", { 0, }, },
  { &type_id_get_parent, "BseItem+get-parent", NULL, 0, get_parent_setup, get_parent_exec, NULL, "/Method/BseItem/General/Get Parent", { 0, }, },
  { &type_id_get_project, "BseItem+get-project", NULL, 0, get_project_setup, get_project_exec, NULL, "/Method/BseItem/General/Get Project", { 0, }, },
  { &type_id_get_uname_path, "BseItem+get-uname-path", NULL, 0, get_uname_path_setup, get_uname_path_exec, NULL, "/Method/BseItem/General/Get Uname Path", { 0, }, },
  { &type_id_use, "BseItem+use", NULL, 0, use_setup, use_exec, NULL, "/Method/BseItem/General/Use", { 0, }, },
  { &type_id_unuse, "BseItem+unuse", NULL, 0, unuse_setup, unuse_exec, NULL, "/Method/BseItem/General/Unuse", { 0, }, },
  { &type_id_set_name, "BseItem+set-name", NULL, 0, set_name_setup, set_name_exec, NULL, "/Method/BseItem/General/Set Name", { 0, }, },
  { &type_id_get_name, "BseItem+get-name", NULL, 0, get_name_setup, get_name_exec, NULL, "/Method/BseItem/General/Get Name", { 0, }, },
  { &type_id_get_name_or_type, "BseItem+get-name-or-type", NULL, 0, get_name_or_type_setup, get_name_or_type_exec, NULL, "/Method/BseItem/General/Get Name Or Type", { 0, }, },
  { &type_id_common_ancestor, "BseItem+common-ancestor", NULL, 0, common_ancestor_setup, common_ancestor_exec, NULL, "/Method/BseItem/General/Common Ancestor", { 0, }, },
  { &type_id_get_seqid, "BseItem+get-seqid", NULL, 0, get_seqid_setup, get_seqid_exec, NULL, "/Method/BseItem/General/Get Seqid", { 0, }, },
  { &type_id_check_is_a, "BseItem+check-is-a", "Check whether an item has a certain type.", 0, check_is_a_setup, check_is_a_exec, NULL, "/Method/BseItem/General/Check Is A", { 0, }, },
  { &type_id_list_proxies, "BseItem+list-proxies", NULL, 0, list_proxies_setup, list_proxies_exec, NULL, "/Method/BseItem/General/List Proxies", { 0, }, },
  { &type_id_get_icon, "BseItem+get-icon", NULL, 0, get_icon_setup, get_icon_exec, NULL, "/Method/BseItem/General/Get Icon", { 0, }, },
  { &type_id_fixme_set_parasite, "BseItem+fixme-set-parasite", NULL, 0, fixme_set_parasite_setup, fixme_set_parasite_exec, NULL, "/Method/BseItem/General/Fixme Set Parasite", { 0, }, },
  { &type_id_fixme_get_parasite, "BseItem+fixme-get-parasite", NULL, 0, fixme_get_parasite_setup, fixme_get_parasite_exec, NULL, "/Method/BseItem/General/Fixme Get Parasite", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
