
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesource.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesource.h>
#include <bse/bseundostack.h>
#include <bse/bseieee754.h>
#include <bse/bsemidievent.h>


#line 27 "bsesource.proc"

/* --- set-input-by-id --- */
static void
set_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsesource.proc"
 {
#line 30 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 42 "bsesource.proc"
 }
static BseErrorType
#line 42 "bsesource.proc"
set_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 45 "bsesource.proc"
{
#line 46 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error;
  
#line 53 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 58 "bsesource.proc"
  
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);

#line 63 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- set-input --- */
static void
set_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 69 "bsesource.proc"
 {
#line 71 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 83 "bsesource.proc"
 }
static BseErrorType
#line 83 "bsesource.proc"
set_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 86 "bsesource.proc"
{
#line 87 "bsesource.proc"
  
  BseSource *isource   = bse_value_get_object (in_values++);
  gchar *ichannel_ident = sfi_value_get_string (in_values++);
  BseSource *osource   = bse_value_get_object (in_values++);
  gchar *ochannel_ident = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error;
  
#line 95 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel_ident || !ochannel_ident)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 101 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_ident);
  ochannel = bse_source_find_ochannel (osource, ochannel_ident);
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
  
#line 108 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input-by-id --- */
static void
unset_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 114 "bsesource.proc"
 {
#line 116 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 128 "bsesource.proc"
 }
static BseErrorType
#line 128 "bsesource.proc"
unset_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 131 "bsesource.proc"
{
#line 132 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 139 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 143 "bsesource.proc"
  
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }

#line 154 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input --- */
static void
unset_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 160 "bsesource.proc"
 {
#line 162 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 174 "bsesource.proc"
 }
static BseErrorType
#line 174 "bsesource.proc"
unset_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 177 "bsesource.proc"
{
#line 178 "bsesource.proc"
  
  BseSource *isource   = bse_value_get_object (in_values++);
  gchar *ichannel_ident = sfi_value_get_string (in_values++);
  BseSource *osource   = bse_value_get_object (in_values++);
  gchar *ochannel_ident = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error = BSE_ERROR_NONE;
  
#line 186 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      !ichannel_ident || !ochannel_ident)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 191 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_ident);
  ochannel = bse_source_find_ochannel (osource, ochannel_ident);
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }
  
#line 204 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- clear-inputs --- */
static void
clear_inputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 210 "bsesource.proc"
 {
#line 212 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 215 "bsesource.proc"
 }
static BseErrorType
#line 215 "bsesource.proc"
clear_inputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 218 "bsesource.proc"
{
#line 219 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  
#line 223 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 227 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-inputs %s", bse_object_debug_name (isource));
  bse_source_backup_ichannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-inputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ichannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- clear-outputs --- */
static void
clear_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 237 "bsesource.proc"
 {
#line 239 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 242 "bsesource.proc"
 }
static BseErrorType
#line 242 "bsesource.proc"
clear_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 245 "bsesource.proc"
{
#line 246 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  BseUndoStack *ustack;

#line 250 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 254 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-outputs %s", bse_object_debug_name (isource));
  bse_source_backup_ochannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-outputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ochannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- has-output --- */
static void
has_output_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 264 "bsesource.proc"
 {
#line 266 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", NULL, NULL, BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("ochannel", NULL, NULL, 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", NULL, NULL, FALSE, SFI_PARAM_STANDARD);
}
#line 270 "bsesource.proc"
 }
static BseErrorType
#line 270 "bsesource.proc"
has_output_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 273 "bsesource.proc"
{
#line 274 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 278 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 282 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, bse_source_has_output (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- has-outputs --- */
static void
has_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 288 "bsesource.proc"
 {
#line 290 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", "Has Outputs", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 295 "bsesource.proc"
 }
static BseErrorType
#line 295 "bsesource.proc"
has_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 298 "bsesource.proc"
{
#line 299 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 302 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 306 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, source->outputs != NULL);
  
  return BSE_ERROR_NONE;
}

/* --- n-ichannels --- */
static void
n_ichannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 312 "bsesource.proc"
 {
#line 314 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 319 "bsesource.proc"
 }
static BseErrorType
#line 319 "bsesource.proc"
n_ichannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 322 "bsesource.proc"
{
#line 323 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 326 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 330 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_ICHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-label --- */
static void
ichannel_label_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 336 "bsesource.proc"
 {
#line 338 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_label", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 345 "bsesource.proc"
 }
static BseErrorType
#line 345 "bsesource.proc"
ichannel_label_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 348 "bsesource.proc"
{
#line 349 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 353 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 357 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_LABEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-ident --- */
static void
ichannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 363 "bsesource.proc"
 {
#line 365 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_ident", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 372 "bsesource.proc"
 }
static BseErrorType
#line 372 "bsesource.proc"
ichannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 375 "bsesource.proc"
{
#line 376 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 380 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 384 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_IDENT (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-blurb --- */
static void
ichannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 390 "bsesource.proc"
 {
#line 392 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 399 "bsesource.proc"
 }
static BseErrorType
#line 399 "bsesource.proc"
ichannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 402 "bsesource.proc"
{
#line 403 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 407 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 411 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_BLURB (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel-by-id --- */
static void
is_joint_ichannel_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 417 "bsesource.proc"
 {
#line 419 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 426 "bsesource.proc"
 }
static BseErrorType
#line 426 "bsesource.proc"
is_joint_ichannel_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 429 "bsesource.proc"
{
#line 430 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 434 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 438 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel --- */
static void
is_joint_ichannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 444 "bsesource.proc"
 {
#line 446 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 453 "bsesource.proc"
 }
static BseErrorType
#line 453 "bsesource.proc"
is_joint_ichannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 456 "bsesource.proc"
{
#line 457 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  gchar *ichannel   = sfi_value_get_string (in_values++);
  guint id;
  
#line 462 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !ichannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 466 "bsesource.proc"
  
  id = bse_source_find_ichannel (source, ichannel);
  sfi_value_set_bool (out_values++,
		      id < BSE_SOURCE_N_ICHANNELS (source) ? BSE_SOURCE_IS_JOINT_ICHANNEL (source, id) : FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-n-joints --- */
static void
ichannel_get_n_joints_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 474 "bsesource.proc"
 {
#line 476 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_joints", "Number of Connections", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 483 "bsesource.proc"
 }
static BseErrorType
#line 483 "bsesource.proc"
ichannel_get_n_joints_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 486 "bsesource.proc"
{
#line 487 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 492 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 496 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel))
    sfi_value_set_int (out_values++, input->jdata.n_joints);
  else
    sfi_value_set_int (out_values++, input->idata.osource ? 1 : 0);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-osource --- */
static void
ichannel_get_osource_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 506 "bsesource.proc"
 {
#line 508 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("osource", "Output Source", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 517 "bsesource.proc"
 }
static BseErrorType
#line 517 "bsesource.proc"
ichannel_get_osource_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 520 "bsesource.proc"
{
#line 521 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 527 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 531 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    bse_value_set_object (out_values++, input->jdata.joints[joint].osource);
  else if (joint < 1)
    bse_value_set_object (out_values++, input->idata.osource);
  else
    bse_value_set_object (out_values++, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-ochannel --- */
static void
ichannel_get_ochannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 543 "bsesource.proc"
 {
#line 545 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("ochannel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 554 "bsesource.proc"
 }
static BseErrorType
#line 554 "bsesource.proc"
ichannel_get_ochannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 557 "bsesource.proc"
{
#line 558 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 564 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 568 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    sfi_value_set_int (out_values++, input->jdata.joints[joint].ochannel);
  else if (joint < 1)
    sfi_value_set_int (out_values++, input->idata.ochannel);
  else
    sfi_value_set_int (out_values++, G_MAXINT);
  
  return BSE_ERROR_NONE;
}

/* --- n-ochannels --- */
static void
n_ochannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 580 "bsesource.proc"
 {
#line 582 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 587 "bsesource.proc"
 }
static BseErrorType
#line 587 "bsesource.proc"
n_ochannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 590 "bsesource.proc"
{
#line 591 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 594 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 598 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_OCHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-label --- */
static void
ochannel_label_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 604 "bsesource.proc"
 {
#line 606 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_label", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 613 "bsesource.proc"
 }
static BseErrorType
#line 613 "bsesource.proc"
ochannel_label_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 616 "bsesource.proc"
{
#line 617 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 621 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 625 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_LABEL (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-ident --- */
static void
ochannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 631 "bsesource.proc"
 {
#line 633 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_ident", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 640 "bsesource.proc"
 }
static BseErrorType
#line 640 "bsesource.proc"
ochannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 643 "bsesource.proc"
{
#line 644 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 648 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 652 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_IDENT (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-blurb --- */
static void
ochannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 658 "bsesource.proc"
 {
#line 660 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 667 "bsesource.proc"
 }
static BseErrorType
#line 667 "bsesource.proc"
ochannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 670 "bsesource.proc"
{
#line 671 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 675 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 679 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_BLURB (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- set-pos --- */
static void
set_pos_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 685 "bsesource.proc"
 {
#line 692 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("x-pos", "X Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("y-pos", "Y Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
}
#line 699 "bsesource.proc"
 }
static BseErrorType
#line 699 "bsesource.proc"
set_pos_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 702 "bsesource.proc"
{
#line 703 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  SfiReal xpos      = sfi_value_get_real (in_values++);
  SfiReal ypos      = sfi_value_get_real (in_values++);
  SfiReal epsilon = 1e-5;

#line 709 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || BSE_DOUBLE_IS_NANINF (xpos) || BSE_DOUBLE_IS_NANINF (ypos))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 713 "bsesource.proc"
  
  if (fabs (xpos - source->pos_x) > epsilon ||
      fabs (ypos - source->pos_y) > epsilon)
    {
      BseUndoStack *ustack = bse_item_undo_open (source, "set-xy-pos");
      bse_item_set (source,
                    "pos_x", xpos,
                    "pos_y", ypos,
                    NULL);
      bse_item_undo_close (ustack);
    }

  return BSE_ERROR_NONE;
}

/* --- set-automation --- */
static void
set_automation_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 728 "bsesource.proc"
 {
#line 730 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("midi_channel", _("MIDI Channel"), _("The MIDI Channel from which automation events should be received, 0 designates the default MIDI channel"),
                         0, 0, BSE_MIDI_MAX_CHANNELS, 1, SFI_PARAM_STANDARD ":scale:unprepared");
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", _("Control Type"), _("The type of control events used for automation"),
                                BSE_TYPE_MIDI_CONTROL_TYPE, BSE_MIDI_CONTROL_CONTINUOUS_16, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL, BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 740 "bsesource.proc"
 }
static BseErrorType
#line 740 "bsesource.proc"
set_automation_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 743 "bsesource.proc"
{
#line 744 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);
  gchar     *property     = sfi_value_get_string (in_values++);
  guint      midi_channel = sfi_value_get_int (in_values++);
  guint      control_type = g_value_get_enum (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 751 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 755 "bsesource.proc"
  
  guint old_midi_channel = 0;
  guint old_control_type = 0;
  bse_source_get_automation_property (source, property, &old_midi_channel, &old_control_type);
  if (old_midi_channel != midi_channel || old_control_type != control_type)
    {
      error = bse_source_set_automation_property (source, property, midi_channel, control_type);
      if (error == BSE_ERROR_NONE)
        bse_item_push_undo_proc (source, "set-automation", property, old_midi_channel, old_control_type);
    }

#line 766 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- get-automation-channel --- */
static void
get_automation_channel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 772 "bsesource.proc"
 {
#line 774 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("midi_channel", NULL, NULL, 0, 0, BSE_MIDI_MAX_CHANNELS, 1, SFI_PARAM_STANDARD ":scale:unprepared");
}
#line 780 "bsesource.proc"
 }
static BseErrorType
#line 780 "bsesource.proc"
get_automation_channel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 783 "bsesource.proc"
{
#line 784 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);
  gchar     *property     = sfi_value_get_string (in_values++);

#line 788 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 792 "bsesource.proc"
  
  guint midi_channel = 0;
  bse_source_get_automation_property (source, property, &midi_channel, NULL);
#line 795 "bsesource.proc"
  
  g_value_set_int (out_values++, midi_channel);
  
  return BSE_ERROR_NONE;
}

/* --- get-automation-control --- */
static void
get_automation_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 801 "bsesource.proc"
 {
#line 803 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("control_type", NULL, NULL, BSE_TYPE_MIDI_CONTROL_TYPE, BSE_MIDI_CONTROL_CONTINUOUS_16, SFI_PARAM_STANDARD);
}
#line 809 "bsesource.proc"
 }
static BseErrorType
#line 809 "bsesource.proc"
get_automation_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 812 "bsesource.proc"
{
#line 813 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);
  gchar     *property     = sfi_value_get_string (in_values++);

#line 817 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 821 "bsesource.proc"
  
  guint control_type = 0;
  bse_source_get_automation_property (source, property, NULL, &control_type);
#line 824 "bsesource.proc"
  
  g_value_set_enum (out_values++, control_type);
  
  return BSE_ERROR_NONE;
}

/* --- is-prepared --- */
static void
is_prepared_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 830 "bsesource.proc"
 {
#line 832 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_prepared", NULL, NULL, FALSE, SFI_PARAM_STANDARD);
#line 835 "bsesource.proc"
}  }
static BseErrorType
#line 835 "bsesource.proc"
is_prepared_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 838 "bsesource.proc"
{
#line 839 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);

#line 842 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 846 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_PREPARED (source));

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_set_input_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Connect a module input to another module's output.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 29;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_input_by_id = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Set Input By Id",
    NULL,
    __enode_set_input_by_id__fill_strings,
  },
  0, set_input_by_id_setup, set_input_by_id_exec, 
};
static void
__enode_set_input__fill_strings (BseExportStrings *es)
{
  es->blurb = "Connect a module input to another module's output.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 70;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_input = {
  { (BseExportNode*) &__enode_set_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input", 
    NULL,
    "/Methods/BseSource/General/Set Input",
    NULL,
    __enode_set_input__fill_strings,
  },
  0, set_input_setup, set_input_exec, 
};
static void
__enode_unset_input_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect a module input.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 115;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_unset_input_by_id = {
  { (BseExportNode*) &__enode_set_input, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Unset Input By Id",
    NULL,
    __enode_unset_input_by_id__fill_strings,
  },
  0, unset_input_by_id_setup, unset_input_by_id_exec, 
};
static void
__enode_unset_input__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect a module input.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 161;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_unset_input = {
  { (BseExportNode*) &__enode_unset_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input", 
    NULL,
    "/Methods/BseSource/General/Unset Input",
    NULL,
    __enode_unset_input__fill_strings,
  },
  0, unset_input_setup, unset_input_exec, 
};
static void
__enode_clear_inputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect all module inputs.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 211;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_clear_inputs = {
  { (BseExportNode*) &__enode_unset_input, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-inputs", 
    NULL,
    "/Methods/BseSource/General/Clear Inputs",
    NULL,
    __enode_clear_inputs__fill_strings,
  },
  0, clear_inputs_setup, clear_inputs_exec, 
};
static void
__enode_clear_outputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect all module outputs.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 238;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_clear_outputs = {
  { (BseExportNode*) &__enode_clear_inputs, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-outputs", 
    NULL,
    "/Methods/BseSource/General/Clear Outputs",
    NULL,
    __enode_clear_outputs__fill_strings,
  },
  0, clear_outputs_setup, clear_outputs_exec, 
};
static void
__enode_has_output__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a module's output channel is connected.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 265;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_has_output = {
  { (BseExportNode*) &__enode_clear_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+has-output", 
    NULL,
    "/Methods/BseSource/General/Has Output",
    NULL,
    __enode_has_output__fill_strings,
  },
  0, has_output_setup, has_output_exec, 
};
static void
__enode_has_outputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a module has output channel connections.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 289;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_has_outputs = {
  { (BseExportNode*) &__enode_has_output, BSE_EXPORT_NODE_PROC,
    "BseSource+has-outputs", 
    NULL,
    "/Methods/BseSource/General/Has Outputs",
    NULL,
    __enode_has_outputs__fill_strings,
  },
  0, has_outputs_setup, has_outputs_exec, 
};
static void
__enode_n_ichannels__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the number of input channels of a module.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 313;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_ichannels = {
  { (BseExportNode*) &__enode_has_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ichannels", 
    NULL,
    "/Methods/BseSource/General/N Ichannels",
    NULL,
    __enode_n_ichannels__fill_strings,
  },
  0, n_ichannels_setup, n_ichannels_exec, 
};
static void
__enode_ichannel_label__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get input channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 337;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_label = {
  { (BseExportNode*) &__enode_n_ichannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-label", 
    NULL,
    "/Methods/BseSource/General/Ichannel Label",
    NULL,
    __enode_ichannel_label__fill_strings,
  },
  0, ichannel_label_setup, ichannel_label_exec, 
};
static void
__enode_ichannel_ident__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get canonical input channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 364;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_ident = {
  { (BseExportNode*) &__enode_ichannel_label, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ichannel Ident",
    NULL,
    __enode_ichannel_ident__fill_strings,
  },
  0, ichannel_ident_setup, ichannel_ident_exec, 
};
static void
__enode_ichannel_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get input channel description.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 391;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_blurb = {
  { (BseExportNode*) &__enode_ichannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ichannel Blurb",
    NULL,
    __enode_ichannel_blurb__fill_strings,
  },
  0, ichannel_blurb_setup, ichannel_blurb_exec, 
};
static void
__enode_is_joint_ichannel_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check if an input channel is a joint (multi-connect) channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 418;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_joint_ichannel_by_id = {
  { (BseExportNode*) &__enode_ichannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel-by-id", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel By Id",
    NULL,
    __enode_is_joint_ichannel_by_id__fill_strings,
  },
  0, is_joint_ichannel_by_id_setup, is_joint_ichannel_by_id_exec, 
};
static void
__enode_is_joint_ichannel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check if an input channel is a joint (multi-connect) channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 445;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_joint_ichannel = {
  { (BseExportNode*) &__enode_is_joint_ichannel_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel",
    NULL,
    __enode_is_joint_ichannel__fill_strings,
  },
  0, is_joint_ichannel_setup, is_joint_ichannel_exec, 
};
static void
__enode_ichannel_get_n_joints__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the number of inputs connected to an input channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 475;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_n_joints = {
  { (BseExportNode*) &__enode_is_joint_ichannel, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-n-joints", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get N Joints",
    NULL,
    __enode_ichannel_get_n_joints__fill_strings,
  },
  0, ichannel_get_n_joints_setup, ichannel_get_n_joints_exec, 
};
static void
__enode_ichannel_get_osource__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve output module connected to a specific joint of an input channel";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 507;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_osource = {
  { (BseExportNode*) &__enode_ichannel_get_n_joints, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-osource", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Osource",
    NULL,
    __enode_ichannel_get_osource__fill_strings,
  },
  0, ichannel_get_osource_setup, ichannel_get_osource_exec, 
};
static void
__enode_ichannel_get_ochannel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve output channel of the module connected to a specific joint of an input channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 544;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_ochannel = {
  { (BseExportNode*) &__enode_ichannel_get_osource, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-ochannel", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Ochannel",
    NULL,
    __enode_ichannel_get_ochannel__fill_strings,
  },
  0, ichannel_get_ochannel_setup, ichannel_get_ochannel_exec, 
};
static void
__enode_n_ochannels__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the number of output channels of a module.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 581;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_ochannels = {
  { (BseExportNode*) &__enode_ichannel_get_ochannel, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ochannels", 
    NULL,
    "/Methods/BseSource/General/N Ochannels",
    NULL,
    __enode_n_ochannels__fill_strings,
  },
  0, n_ochannels_setup, n_ochannels_exec, 
};
static void
__enode_ochannel_label__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get output channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 605;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_label = {
  { (BseExportNode*) &__enode_n_ochannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-label", 
    NULL,
    "/Methods/BseSource/General/Ochannel Label",
    NULL,
    __enode_ochannel_label__fill_strings,
  },
  0, ochannel_label_setup, ochannel_label_exec, 
};
static void
__enode_ochannel_ident__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get canonical output channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 632;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_ident = {
  { (BseExportNode*) &__enode_ochannel_label, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ochannel Ident",
    NULL,
    __enode_ochannel_ident__fill_strings,
  },
  0, ochannel_ident_setup, ochannel_ident_exec, 
};
static void
__enode_ochannel_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get output channel description.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 659;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_blurb = {
  { (BseExportNode*) &__enode_ochannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ochannel Blurb",
    NULL,
    __enode_ochannel_blurb__fill_strings,
  },
  0, ochannel_blurb_setup, ochannel_blurb_exec, 
};
static void
__enode_set_pos__fill_strings (BseExportStrings *es)
{
  es->blurb = "Set the x and y position of a module. In contrast to setting the position "
          "through ordinary object property setters, this function will not update "
          "the module position if the passed in arguments are sufficiently equal to "
          "the values already set on the object. As such, it does not record an extra "
          "undo step for setting properties to values they already have and if necessary "
          "turns setting of x and y positions into an atomic undo operation.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 686;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_pos = {
  { (BseExportNode*) &__enode_ochannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+set-pos", 
    NULL,
    "/Methods/BseSource/General/Set Pos",
    NULL,
    __enode_set_pos__fill_strings,
  },
  0, set_pos_setup, set_pos_exec, 
};
static void
__enode_set_automation__fill_strings (BseExportStrings *es)
{
  es->blurb = "Setup automation parameters for a property.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 729;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_automation = {
  { (BseExportNode*) &__enode_set_pos, BSE_EXPORT_NODE_PROC,
    "BseSource+set-automation", 
    NULL,
    "/Methods/BseSource/General/Set Automation",
    NULL,
    __enode_set_automation__fill_strings,
  },
  0, set_automation_setup, set_automation_exec, 
};
static void
__enode_get_automation_channel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get MIDI channel from an automation property.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 773;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_automation_channel = {
  { (BseExportNode*) &__enode_set_automation, BSE_EXPORT_NODE_PROC,
    "BseSource+get-automation-channel", 
    NULL,
    "/Methods/BseSource/General/Get Automation Channel",
    NULL,
    __enode_get_automation_channel__fill_strings,
  },
  0, get_automation_channel_setup, get_automation_channel_exec, 
};
static void
__enode_get_automation_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get control type from an automation property.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 802;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_automation_control = {
  { (BseExportNode*) &__enode_get_automation_channel, BSE_EXPORT_NODE_PROC,
    "BseSource+get-automation-control", 
    NULL,
    "/Methods/BseSource/General/Get Automation Control",
    NULL,
    __enode_get_automation_control__fill_strings,
  },
  0, get_automation_control_setup, get_automation_control_exec, 
};
static void
__enode_is_prepared__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a source is prepared for synthesis processing.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 831;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_prepared = {
  { (BseExportNode*) &__enode_get_automation_control, BSE_EXPORT_NODE_PROC,
    "BseSource+is-prepared", 
    NULL,
    "/Methods/BseSource/General/Is Prepared",
    NULL,
    __enode_is_prepared__fill_strings,
  },
  0, is_prepared_setup, is_prepared_exec, 
};
BseExportNode* bse__builtin_init_bsesource_genprc_c (void);
BseExportNode* bse__builtin_init_bsesource_genprc_c (void)
{
  return (BseExportNode*) &__enode_is_prepared;
}

/*
 * Generated data ends here
 */
