@#  GUBI - Gtk+ User Interface Builder
@#  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
@#
@#  This program is free software; you can redistribute it and/or modify
@#  it under the terms of the GNU General Public License as published by
@#  the Free Software Foundation; either version 2 of the License, or
@#  (at your option) any later version.
@#
@#  This program is distributed in the hope that it will be useful,
@#  but WITHOUT ANY WARRANTY; without even the implied warranty of
@#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
@#  GNU General Public License for more details.
@#
@#  You should have received a copy of the GNU General Public License
@#  along with this program; if not, write to the Free Software
@#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
@#
@#  RCS_ID("$Id: Makefile.tpl,v 1.4 1997/08/18 03:09:26 timj Exp $")
## @fname@: makefile for Main from @builder_long@
 # file created @Y@/@o@/@d@ @h@:@m@:@s@ by @builder_short@ (@fstate@)
 # RCS_ID("@_@")
 # RCS_KEY(Template, "$Template: Makefile.tpl 1997 gubi $")
##

PRGNAME	=main

CODE_PROFILE    = defined
CODE_DEBUG      = defined

## config part

# specify your target machine
#TARGET	= i386
#TARGET	= i486
TARGET	= Pentium
#TARGET	= PentiumPro

# enable profiling ?
#EN_PROFILE	= defined

# enable debug code and symbols ?
EN_DEBUG	= defined

# debug/profiling code with gdb extensions ?
# i can't use it here, because gcc misgets -lg (libg* missing?)
# CODE_GDB_D	= defined
CODE_GDB_P	= defined

# optimizations only (don't use -fomit-frame-pointer)
OPTMZ	= -O3 -fstrength-reduce -fexpensive-optimizations -finline-functions \
	  -frerun-cse-after-loop -fnonnull-objects -freg-struct-return
	# -funroll-loops: problems with -O and templates (see Rep-CppBug_1.C)

## global part

# target directory
PREFIX	= /usr/local

SHELL	= /bin/bash
PWD	= /bin/pwd
TOUCH	= touch
RM	= rm -f
CCPP	= g++
CC	= gcc
CPP	= gcc -E
LD	= gcc # -Werror
CP	= cp -a
LN	= ln -s
FLEX	= flex
BYACC	= bison
MAKEDEP	= gcc -M
STRIP	= : strip --strip-all

BINDIR	= $(PREFIX)/bin
DEPFILE	= .depend

LEXFLGS	=-Ca -Cf
YACFLGS	= # -t		# -t is for debugging

DEBUG	=
# gcc: don't combine -pg & -fomit-frame-pointer
ifdef	CODE_GDB_P
	X_OPTMZ	=
else
	X_OPTMZ	= -fomit-frame-pointer
endif
ifdef	EN_PROFILE
	ifdef	CODE_PROFILE
		ifdef	CODE_GDB_P
			DEBUG	= -pg
			LDFLAGS	= -pg
		else
			DEBUG	= -p
			LDFLAGS	= -p
		endif
	endif
endif
ifdef	EN_DEBUG
	ifdef	CODE_DEBUG
		ifdef	CODE_GDB_D
			DEBUG	+= -DDEBUG -ggdb
			LDFLAGS	+= -ggdb
		else
			DEBUG	+= -DDEBUG -g
			LDFLAGS	+= -g
		endif
	endif
endif
DEFINES	= -DPRGNAME=\"$(PRGNAME)\"
WARN	= -Wall -Wmissing-prototypes -Wstrict-prototypes \
	  -Woverloaded-virtual # -Werror # -Winline
CFLAGS	= -pipe $(WARN) $(OPTMZ) $(X_OPTMZ) #-fhandle-signatures #-fhandle-exceptions #-frtti
DEBUG	+= # -fverbose-asm
INCLUDES= -I$(PREFIX)/include -I./include
LDFLAGS	+= -L$(PREFIX)/lib

ifeq	($(strip $(TARGET)), i386)
MACHINE	= -D__i386__ -m386 -DCPU=386
endif
ifeq	($(strip $(TARGET)), i486)
MACHINE	= -D__i386__ -m486 -DCPU=486
endif
ifeq	($(strip $(TARGET)), Pentium)
MACHINE	= -D__i386__ -m486 -DCPU=586 -malign-loops=2 -malign-jumps=2 -malign-functions=2
endif
ifeq	($(strip $(TARGET)), PentiumPro)
MACHINE	= -D__i386__ -m486 -DCPU=686 -malign-loops=2 -malign-jumps=2 -malign-functions=2
endif

# c++ => bin
%.o:	%.C
	$(CCPP) $(CFLAGS) $(DEFINES) $(INCLUDES) $(MACHINE) -o $@@ -c $<

# c => bin
%.o:	%.c
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) $(MACHINE) -o $@@ -c $<

# asm => bin
%.o:	%.S
	$(CCPP)	$(CFLAGS) $(DEFINES) $(INCLUDES) $(MACHINE) -o $@@ -c $<

# c++ => asm
%.S:	%.C
	$(CCPP)	-S $(CFLAGS) $(DEFINES) $(INCLUDES) $(MACHINE) -o $@@ -c $<

# c => asm
%.S:	%.c
	$(CC)	-S $(CFLAGS) $(DEFINES) $(INCLUDES) $(MACHINE) -o $@@ -c $<

# yacc => .tab.c
%.tab.c:	%.y
	$(BYACC)	$(YACFLGS) -o $@@ $<

# yacc => .tab.h
%.tab.h %.tab.c:	%.y
	$(BYACC)	-d $(YACFLGS) $<

# yacc => .output
%.output:	%.y
	$(BYACC)	-v $(YACFLGS) -o $@@ $<

# lexx => .yy.c
%.yy.c:	%.l
	$(FLEX)	$(LEXFLGS) -o$@@ $<

.Cdepend::
	@@for file in $(patsubst %.o,%,$(LOFILES) $(OFILE)); do \
		if [ -f "$$file.C" ]; then \
			echo -ne "\n# makedepend $$file.C:\n" >>$(DEPFILE) ; \
			echo $(MAKEDEP) $(CFLAGS) $(DEFINES) $(INCLUDES) \
				$(MACHINE) $$file.C ; \
			$(MAKEDEP) $(CFLAGS) $(DEFINES) $(INCLUDES) \
				$(MACHINE) $$file.C >>$(DEPFILE) ; \
		fi ;\
	done
	@@$(RM)	$(DEPFILE).bak

.cdepend::
	@@for file in $(patsubst %.o,%,$(LOFILES) $(OFILE)); do \
		if [ -f "$$file.c" ]; then \
			echo -ne "\n# makedepend $$file.c:\n" >>$(DEPFILE) ; \
			echo $(MAKEDEP) $(CFLAGS) $(DEFINES) $(INCLUDES) \
				$(MACHINE) $$file.c ; \
			$(MAKEDEP) $(CFLAGS) $(DEFINES) $(INCLUDES) \
				$(MACHINE) $$file.c >>$(DEPFILE) ; \
		fi ;\
	done
	@@$(RM)	$(DEPFILE).bak

.clean.depend::
	@@echo	>$(DEPFILE)

.Ccdepend::	.clean.depend	.Cdepend .cdepend

.prginstall::

.oclean::
	$(RM)	*.o *.S

.lexclean::
	$(RM)	*.yy.c

.yaccclean::
	$(RM)	*.output *.tab.[ch]

.rclean::	.lexclean .yaccclean
	$(RM)	core .gdb_history
	$(RM)	*.bak
	@@$(RM)	$(DEPFILE) $(DEPFILE).bak $(DEPFILE).tmp DEADJOE
	@@for file in $(patsubst %.o,%,$(LOFILES) $(OFILE)); do \
		if [ -x "$$file" ]; then \
			echo "$(RM)	$$file" ; \
			$(RM)	$$file ; \
		fi ;\
	done
	@@$(RM)	$(DEPFILE).bak

## Makefile part

DEBUG	+=
DEFINES += $(DEBUG)
CFLAGS	+= -ansi # -x c++
INCLUDES+= -I/usr/include/X11 -I/usr/local/include/gtk -I/usr/local/include/gdk
LDFLAGS	+= -L/usr/X11R6/lib
LIBS	= -lX11 -lXext -lgtk -lgdk -lglib -lm

OFILE	= main.o
LOFILES	= gbuild.o widgets.o ufunc.o

all:	link

gtest:	gtest.o
	$(LD)		gtest.o $(LDFLAGS) $(LIBS) -o $(PRGNAME)
	$(STRIP)	$(PRGNAME)
	sync
	

install:	.prginstall

link:	$(LOFILES) $(OFILE)
	$(LD)		$(OFILE) $(LOFILES) $(LDFLAGS) $(LIBS) -o $(PRGNAME)
	$(STRIP)	$(PRGNAME)
	sync

depend:	.Ccdepend

clean:	.oclean .yaccclean .lexclean

realclean:	clean .rclean
	$(RM)	$(PRGNAME)

# DO NOT DELETE
-include ./$(DEPFILE)
