/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ASTMethodDeclaration;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.JThis;
import bsh.Name;
import bsh.Primitive;
import bsh.Reflect;
import bsh.This;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NameSpace
implements Serializable {
    private NameSpace parent;
    private Hashtable variables;
    private Hashtable methods;
    private Hashtable importedClasses;
    private Vector importedPackages;
    private This thisReference;
    public String name;
    private transient Hashtable classCache;
    transient Interpreter interpreter;
    static transient Hashtable absoluteNonClasses;
    static transient Hashtable absoluteClassCache;
    static boolean checkedForSwing;
    static boolean haveSwing;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$bsh$NameSpace;

    static {
        absoluteClassCache = new Hashtable();
    }

    public NameSpace(NameSpace nameSpace, String string, Interpreter interpreter) {
        this.name = string;
        this.parent = nameSpace;
        this.interpreter = interpreter;
    }

    public NameSpace(String string, Interpreter interpreter) {
        this(null, string, interpreter);
    }

    private static void assignmentError(Class clazz, Class clazz2) throws EvalError {
        String string = Reflect.normalizeClassName(clazz);
        String string2 = Reflect.normalizeClassName(clazz2);
        throw new EvalError("Can't assign " + string2 + " to " + string);
    }

    public void bind(NameSpace nameSpace) {
        this.parent = nameSpace;
    }

    public static Object checkAssignableFrom(Object object, Class clazz) throws EvalError {
        Class<Boolean> clazz2;
        Class clazz3;
        if (object == null) {
            throw new InterpreterError("null value in checkAssignable");
        }
        if (object == Primitive.VOID) {
            throw new EvalError("void cannot be\tused in\tan assignment statement");
        }
        if (object == Primitive.NULL) {
            if (!clazz.isPrimitive()) {
                return object;
            }
            throw new EvalError("Can't assign null to primitive type " + clazz.getName());
        }
        if (object instanceof Primitive) {
            clazz3 = ((Primitive)object).getType();
            clazz2 = clazz3;
            if (!clazz.isPrimitive()) {
                if ((class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = NameSpace.class$("java.lang.Boolean"))).isAssignableFrom(clazz) || (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = NameSpace.class$("java.lang.Character"))).isAssignableFrom(clazz) || (class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = NameSpace.class$("java.lang.Number"))).isAssignableFrom(clazz)) {
                    object = ((Primitive)object).getValue();
                    clazz3 = object.getClass();
                } else {
                    NameSpace.assignmentError(clazz, clazz2);
                }
            }
        } else {
            clazz3 = object.getClass();
            clazz2 = clazz3;
            if (clazz.isPrimitive()) {
                if (clazz3 == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = NameSpace.class$("java.lang.Boolean")))) {
                    object = new Primitive((Boolean)object);
                    clazz3 = Boolean.TYPE;
                } else if (clazz3 == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = NameSpace.class$("java.lang.Character")))) {
                    object = new Primitive((Character)object);
                    clazz3 = Character.TYPE;
                } else if ((class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = NameSpace.class$("java.lang.Number"))).isAssignableFrom(clazz3)) {
                    object = new Primitive((Number)object);
                    clazz3 = ((Primitive)object).getType();
                } else {
                    NameSpace.assignmentError(clazz, clazz2);
                }
            }
        }
        if (!Reflect.isAssignableFrom(clazz, clazz3)) {
            if (clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = NameSpace.class$("java.lang.Short"))) && clazz3 == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = NameSpace.class$("java.lang.Byte")))) {
                return new Short(((Number)object).shortValue());
            }
            if (clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = NameSpace.class$("java.lang.Integer")))) {
                if (clazz3 == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz3 == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = NameSpace.class$("java.lang.Short")))) {
                    return new Integer(((Number)object).intValue());
                }
                if (clazz3 == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = NameSpace.class$("java.lang.Character")))) {
                    return new Integer(((Number)object).intValue());
                }
            }
            if (clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = NameSpace.class$("java.lang.Long")))) {
                if (clazz3 == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz3 == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = NameSpace.class$("java.lang.Short"))) || clazz3 == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = NameSpace.class$("java.lang.Integer")))) {
                    return new Long(((Number)object).longValue());
                }
                if (clazz3 == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = NameSpace.class$("java.lang.Character")))) {
                    return new Long(((Number)object).longValue());
                }
            }
            if (clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = NameSpace.class$("java.lang.Float")))) {
                if (clazz3 == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz3 == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = NameSpace.class$("java.lang.Short"))) || clazz3 == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = NameSpace.class$("java.lang.Integer"))) || clazz3 == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = NameSpace.class$("java.lang.Long")))) {
                    return new Float(((Number)object).floatValue());
                }
                if (clazz3 == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = NameSpace.class$("java.lang.Character")))) {
                    return new Float(((Number)object).floatValue());
                }
            }
            if (clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = NameSpace.class$("java.lang.Double")))) {
                if (clazz3 == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz3 == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = NameSpace.class$("java.lang.Short"))) || clazz3 == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = NameSpace.class$("java.lang.Integer"))) || clazz3 == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = NameSpace.class$("java.lang.Long"))) || clazz3 == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = NameSpace.class$("java.lang.Float")))) {
                    return new Double(((Number)object).doubleValue());
                }
                if (clazz3 == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = NameSpace.class$("java.lang.Character")))) {
                    return new Double(((Number)object).doubleValue());
                }
            }
            NameSpace.assignmentError(clazz, clazz2);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String[] enumerationToStringArray(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static Class getAbsoluteClass(String string) {
        return NameSpace.getClass(null, string);
    }

    private static Class getClass(NameSpace nameSpace, String string) {
        Object object;
        if (nameSpace != null && !Name.isCompound(string)) {
            Object object2;
            object = nameSpace.getImportedClass(string);
            if (object != null) {
                object2 = (Class)absoluteClassCache.get(object);
                if (object2 != null) {
                    return object2;
                }
                if (absoluteNonClasses.get(object) == null) {
                    try {
                        object2 = Class.forName(object);
                        absoluteClassCache.put(object, object2);
                        return object2;
                    }
                    catch (Exception exception) {
                        Interpreter.debug("imported class: " + object + " not found");
                        absoluteNonClasses.put(object, "unused");
                    }
                }
            }
            object2 = nameSpace.getImportedPackages();
            int n = 0;
            while (n < ((String[])object2).length) {
                String string2 = String.valueOf(object2[n]) + "." + string;
                Class<?> clazz = (Class<?>)absoluteClassCache.get(string2);
                if (clazz != null) {
                    return clazz;
                }
                if (absoluteNonClasses.get(string2) == null) {
                    try {
                        clazz = Class.forName(string2);
                        absoluteClassCache.put(string2, clazz);
                        return clazz;
                    }
                    catch (Exception exception) {
                        absoluteNonClasses.put(string2, "unused");
                    }
                }
                ++n;
            }
        }
        if (absoluteNonClasses.get(string) == null) {
            try {
                object = (Class)absoluteClassCache.get(string);
                if (object != null) {
                    return object;
                }
                object = Class.forName(string);
                absoluteClassCache.put(string, object);
                return object;
            }
            catch (Exception exception) {
                absoluteNonClasses.put(string, "unused");
            }
        }
        Interpreter.debug("getClass(): " + string + " not\tfound.");
        return null;
    }

    public Class getClass(String string) {
        Class clazz = null;
        if (this.classCache != null) {
            clazz = (Class)this.classCache.get(string);
        }
        if (clazz == null && (clazz = NameSpace.getClass(this, string)) != null) {
            if (this.classCache == null) {
                this.classCache = new Hashtable();
            }
            this.classCache.put(string, clazz);
        }
        return clazz;
    }

    public NameSpace getGlobal() {
        if (this.parent != null) {
            return this.parent.getGlobal();
        }
        return this;
    }

    This getGlobalThis() {
        if (this.parent != null) {
            return this.parent.getGlobalThis();
        }
        return this.getThis();
    }

    public String getImportedClass(String string) {
        String string2 = null;
        if (this.importedClasses != null) {
            string2 = (String)this.importedClasses.get(string);
        }
        if (string2 == null && this.parent != null) {
            return this.parent.getImportedClass(string);
        }
        return string2;
    }

    public String[] getImportedPackages() {
        if (this.importedPackages == null) {
            if (this.parent != null) {
                return this.parent.getImportedPackages();
            }
            return new String[0];
        }
        Object[] objectArray = new String[this.importedPackages.size()];
        this.importedPackages.copyInto(objectArray);
        return objectArray;
    }

    public ASTMethodDeclaration getMethod(String string) {
        ASTMethodDeclaration aSTMethodDeclaration = null;
        if (this.methods != null) {
            aSTMethodDeclaration = (ASTMethodDeclaration)this.methods.get(string);
        }
        if (aSTMethodDeclaration == null && this.parent != null) {
            return this.parent.getMethod(string);
        }
        return aSTMethodDeclaration;
    }

    public String[] getMethodNames() {
        if (this.methods == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.methods.keys());
    }

    public NameSpace getParent() {
        return this.parent;
    }

    public NameSpace getSuper() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    This getThis() {
        if (this.thisReference == null) {
            this.thisReference = NameSpace.haveSwing() ? new JThis(this, this.interpreter) : new This(this, this.interpreter);
        }
        return this.thisReference;
    }

    public Object getVariable(String string) {
        if (string.equals("this")) {
            return this.getThis();
        }
        if (string.equals("super")) {
            if (this.parent == null) {
                return this.getThis();
            }
            return this.parent.getThis();
        }
        if (string.equals("global")) {
            return this.getGlobalThis();
        }
        Object object = null;
        if (this.variables != null) {
            object = this.variables.get(string);
        }
        if (object == null && this.parent != null) {
            object = this.parent.getVariable(string);
        }
        if (object instanceof TypedVariable) {
            object = ((TypedVariable)object).getValue();
        }
        return object == null ? Primitive.VOID : object;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.variables.keys());
    }

    public static boolean haveSwing() {
        if (checkedForSwing) {
            return haveSwing;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("javax.swing.JButton");
        }
        catch (Exception exception) {}
        haveSwing = clazz != null;
        checkedForSwing = true;
        return haveSwing;
    }

    public void importClass(String string) {
        if (this.importedClasses == null) {
            this.importedClasses = new Hashtable();
        }
        this.importedClasses.put(Name.suffix(string, 1), string);
    }

    public void importPackage(String string) {
        if (this.importedPackages == null) {
            this.importedPackages = new Vector();
        }
        this.importedPackages.addElement(string);
    }

    public static void loadDefaultImports(NameSpace nameSpace) throws IOException {
        String string;
        InputStream inputStream = (class$bsh$NameSpace != null ? class$bsh$NameSpace : (class$bsh$NameSpace = NameSpace.class$("bsh.NameSpace"))).getResourceAsStream(string = "lib/defaultImports");
        if (inputStream == null) {
            throw new IOException("couldn't load resource: " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                nameSpace.importClass(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Interpreter.debug("failed to load default imports...");
        }
    }

    public static void loadJavaPackagesOptimization() throws IOException {
        String string;
        if (absoluteNonClasses != null) {
            return;
        }
        absoluteNonClasses = new Hashtable();
        InputStream inputStream = (class$bsh$NameSpace != null ? class$bsh$NameSpace : (class$bsh$NameSpace = NameSpace.class$("bsh.NameSpace"))).getResourceAsStream(string = "lib/javaPackages");
        if (inputStream == null) {
            throw new IOException("couldn't load resource: " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                absoluteNonClasses.put(string2, "unused");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Interpreter.debug("failed to load java package names...");
        }
    }

    public void prune() {
        this.parent = null;
        if (this.methods != null) {
            Enumeration enumeration = this.methods.elements();
            while (enumeration.hasMoreElements()) {
                ((ASTMethodDeclaration)enumeration.nextElement()).prune();
            }
        }
    }

    public void setMethod(String string, ASTMethodDeclaration aSTMethodDeclaration) {
        if (this.methods == null) {
            this.methods = new Hashtable();
        }
        this.methods.put(string, aSTMethodDeclaration);
    }

    public void setTypedVariable(String string, Class clazz, Object object, boolean bl) throws EvalError {
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (this.variables.containsKey(string)) {
            this.setVariable(string, object);
        }
        if (object == null) {
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE) {
                    object = new Primitive(Boolean.FALSE);
                } else if (clazz == Byte.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Short.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Character.TYPE) {
                    object = new Primitive('\u0000');
                } else if (clazz == Integer.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Long.TYPE) {
                    object = new Primitive(0L);
                } else if (clazz == Float.TYPE) {
                    object = new Primitive(0.0f);
                } else if (clazz == Double.TYPE) {
                    object = new Primitive(0.0);
                }
            } else {
                object = Primitive.NULL;
            }
        }
        this.variables.put(string, new TypedVariable(clazz, object, bl));
    }

    public void setVariable(String string, Object object) throws EvalError {
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (object == null) {
            this.variables.remove(string);
        } else {
            Object v = this.variables.get(string);
            if (v != null && v instanceof TypedVariable) {
                try {
                    ((TypedVariable)v).setValue(object);
                }
                catch (EvalError evalError) {
                    throw new EvalError("Typed variable: " + string + ": " + evalError.getMessage());
                }
            } else {
                this.variables.put(string, object);
            }
        }
    }

    public String toString() {
        return "NameSpace: " + (this.name == null ? super.toString() : String.valueOf(this.name) + " : " + super.toString());
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    static class TypedVariable
    implements Serializable {
        Class type;
        Object value;
        boolean isFinal;

        TypedVariable(Class clazz, Object object, boolean bl) {
            this.type = clazz;
            this.value = object;
            this.isFinal = bl;
        }

        Object getType() {
            return this.type;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object object) throws EvalError {
            if (this.isFinal) {
                throw new EvalError("Final variable, can't assign");
            }
            this.value = object = NameSpace.checkAssignableFrom(object, this.type);
        }
    }
}

