/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jde.debugger.DebuggeeProcess;
import jde.debugger.JDEException;

public class ProcessRegistry {
    Map processes = Collections.synchronizedMap(new HashMap());
    private static ProcessRegistry registry = new ProcessRegistry();

    private ProcessRegistry() {
    }

    public void addProcess(Integer procID, DebuggeeProcess proc) {
        Map map = this.processes;
        synchronized (map) {
            this.processes.put(procID, proc);
        }
    }

    public void removeProcess(Integer procID) {
        Map map = this.processes;
        synchronized (map) {
            this.processes.remove(procID);
        }
    }

    public boolean processExists(Integer procID) {
        Map map = this.processes;
        synchronized (map) {
            boolean bl = this.processes.containsKey(procID) && this.getProcess(procID) != null;
            return bl;
        }
    }

    public DebuggeeProcess getProcess(Integer procID) {
        Map map = this.processes;
        synchronized (map) {
            DebuggeeProcess debuggeeProcess = (DebuggeeProcess)this.processes.get(procID);
            return debuggeeProcess;
        }
    }

    public static ProcessRegistry getRegistry() {
        return registry;
    }

    public void shutdownProcesses() throws JDEException {
        Map map = this.processes;
        synchronized (map) {
            Iterator iterator = this.processes.values().iterator();
            while (iterator.hasNext()) {
                ((DebuggeeProcess)iterator.next()).shutdown();
                iterator.remove();
            }
        }
    }
}

