/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterConstants;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;

class BSHBinaryExpression
extends SimpleNode
implements InterpreterConstants {
    public int kind;

    BSHBinaryExpression(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Object object;
        Object object2 = ((SimpleNode)this.jjtGetChild(0)).eval(nameSpace, interpreter);
        if (this.kind == 32) {
            if (object2 instanceof Primitive) {
                return new Primitive(false);
            }
            Class clazz = ((BSHType)this.jjtGetChild(1)).getType(nameSpace);
            boolean bl = Reflect.isAssignableFrom(clazz, object2.getClass());
            return new Primitive(bl);
        }
        if (this.kind == 87 || this.kind == 88) {
            object = object2;
            if (this.isPrimitiveValue(object2)) {
                object = ((Primitive)object2).getValue();
            }
            if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                return new Primitive(false);
            }
        }
        if (this.kind == 85 || this.kind == 86) {
            object = object2;
            if (this.isPrimitiveValue(object2)) {
                object = ((Primitive)object2).getValue();
            }
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                return new Primitive(true);
            }
        }
        boolean bl = this.isWrapper(object2);
        Object object3 = ((SimpleNode)this.jjtGetChild(1)).eval(nameSpace, interpreter);
        boolean bl2 = this.isWrapper(object3);
        if (!(!bl && !this.isPrimitiveValue(object2) || !bl2 && !this.isPrimitiveValue(object3) || bl && bl2 && this.kind == 79)) {
            return BSHBinaryExpression.primitiveBinaryOperation(object2, object3, this.kind);
        }
        switch (this.kind) {
            case 79: {
                return new Primitive(object2 == object3);
            }
            case 84: {
                return new Primitive(object2 != object3);
            }
            case 91: {
                if (!(object2 instanceof String) && !(object3 instanceof String)) break;
                return object2.toString() + object3.toString();
            }
        }
        if (object2 instanceof Primitive || object3 instanceof Primitive) {
            if (object2 == Primitive.VOID || object3 == Primitive.VOID) {
                throw new EvalError("illegal use of undefined object or 'void' literal", this);
            }
            if (object2 == Primitive.NULL || object3 == Primitive.NULL) {
                throw new EvalError("illegal use of null object or 'null' literal", this);
            }
        }
        throw new EvalError("Operator: '" + InterpreterConstants.tokenImage[this.kind] + "' inappropriate for objects", this);
    }

    public static Object primitiveBinaryOperation(Object object, Object object2, int n) throws EvalError {
        if (object instanceof Primitive && object2 instanceof Primitive) {
            return Primitive.binaryOperation((Primitive)object, (Primitive)object2, n);
        }
        if (object instanceof Primitive) {
            object = ((Primitive)object).getValue();
        }
        if (object2 instanceof Primitive) {
            object2 = ((Primitive)object2).getValue();
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        Object[] objectArray = Primitive.promotePrimitives(object, object2);
        Object object3 = objectArray[0];
        Object object4 = objectArray[1];
        if (object3.getClass() != object4.getClass()) {
            throw new EvalError("type mismatch in operator.  " + clazz + " cannot be matched with " + clazz2);
        }
        if (object3 instanceof Boolean) {
            return Primitive.booleanBinaryOperation((Boolean)object3, (Boolean)object4, n);
        }
        if (object3 instanceof Integer) {
            Object object5 = Primitive.intBinaryOperation((Integer)object3, (Integer)object4, n);
            return object5;
        }
        if (object3 instanceof Long) {
            return Primitive.longBinaryOperation((Long)object3, (Long)object4, n);
        }
        if (object3 instanceof Float) {
            return Primitive.floatBinaryOperation((Float)object3, (Float)object4, n);
        }
        if (object3 instanceof Double) {
            return Primitive.doubleBinaryOperation((Double)object3, (Double)object4, n);
        }
        throw new EvalError("Invalid types in binary operator");
    }

    private boolean isPrimitiveValue(Object object) {
        return object instanceof Primitive && object != Primitive.VOID && object != Primitive.NULL;
    }

    private boolean isWrapper(Object object) {
        return object instanceof Boolean || object instanceof Character || object instanceof Number;
    }
}

