/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jde.util.ClassPathEntry;
import jde.util.ImmutableClassPathEntry;

class ProjectClasses {
    private String classPath;
    private static ArrayList bootClassPathEntries = new ArrayList();
    private List classPathEntries = (List)bootClassPathEntries.clone();

    ProjectClasses(String classPath) throws IOException {
        this.classPath = classPath;
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String classPathEntry = st.nextToken();
            File classPathFile = new File(classPathEntry);
            if (!classPathFile.exists()) continue;
            this.classPathEntries.add(ClassPathEntry.instanceForEntry(classPathFile));
        }
    }

    void reloadClasses() throws IOException {
        Iterator i = this.classPathEntries.iterator();
        while (i.hasNext()) {
            ClassPathEntry cpe = (ClassPathEntry)i.next();
            cpe.reload();
        }
    }

    public String getClassPath() {
        return this.classPath;
    }

    List getClassNames(String unqualifiedName) throws IOException {
        ArrayList rv = new ArrayList();
        Iterator i = this.classPathEntries.iterator();
        while (i.hasNext()) {
            ClassPathEntry cpe = (ClassPathEntry)i.next();
            rv.addAll(cpe.getClassNames(unqualifiedName));
        }
        return rv;
    }

    public String toString() {
        return this.classPathEntries.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new ProjectClasses(System.getProperty("java.class.path")).getClassNames(args[0]));
    }

    static void loadBootClassPathEntries() throws IOException {
        String bootClassPath = System.getProperty("sun.boot.class.path");
        String extDirs = System.getProperty("java.ext.dirs");
        StringTokenizer st = new StringTokenizer(bootClassPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            ProjectClasses.addToBootClassPath(file);
        }
        if (extDirs != null) {
            st = new StringTokenizer(extDirs, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File[] extFiles = new File(st.nextToken()).listFiles();
                if (extFiles == null) continue;
                int i = 0;
                while (i < extFiles.length) {
                    ProjectClasses.addToBootClassPath(extFiles[i]);
                    ++i;
                }
            }
        }
    }

    static void addToBootClassPath(File file) throws IOException {
        ClassPathEntry entry;
        if (file.exists() && null != (entry = ClassPathEntry.instanceForEntry(file))) {
            bootClassPathEntries.add(new ImmutableClassPathEntry(entry));
        }
    }

    static {
        try {
            ProjectClasses.loadBootClassPathEntries();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

