/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetString
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.args.remove(0), "object ID");
        ObjectReference oRef = this.proc.getStore().get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        if (!(oRef instanceof StringReference)) {
            throw new JDEException("Object is not a string");
        }
        this.jde.signalCommandResult(this.procID, this.cmdID, Rep.getStringRep((StringReference)oRef, this.proc.getStore()));
    }

    public Object clone() {
        return new GetString();
    }
}

