/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class Scope
implements Comparable,
Serializable {
    private static final int SCOPECODE_NOTHING = 0;
    private static final int SCOPECODE_PUBLIC = 1;
    private static final int SCOPECODE_PROTECTED = 2;
    private static final int SCOPECODE_PACKAGE = 3;
    private static final int SCOPECODE_PRIVATE = 4;
    private static final int SCOPECODE_ANONINNER = 5;
    private static final String SCOPENAME_NOTHING = "nothing";
    private static final String SCOPENAME_PUBLIC = "public";
    private static final String SCOPENAME_PROTECTED = "protected";
    private static final String SCOPENAME_PACKAGE = "package";
    private static final String SCOPENAME_PRIVATE = "private";
    private static final String SCOPENAME_ANONINNER = "anoninner";
    static final Scope NOTHING = new Scope(0, "nothing");
    static final Scope PUBLIC = new Scope(1, "public");
    static final Scope PROTECTED = new Scope(2, "protected");
    static final Scope PACKAGE = new Scope(3, "package");
    static final Scope PRIVATE = new Scope(4, "private");
    static final Scope ANONINNER = new Scope(5, "anoninner");
    private static final Map NAME_TO_SCOPE = new HashMap();
    private final int mCode;
    private final String mName;

    public String toString() {
        return "Scope[" + this.mCode + " (" + this.mName + ")]";
    }

    String getName() {
        return this.mName;
    }

    public int compareTo(Object aObject) {
        Scope scope = (Scope)aObject;
        return this.mCode - scope.mCode;
    }

    boolean isIn(Scope aScope) {
        return this.compareTo(aScope) <= 0;
    }

    private Scope(int aCode, String aName) {
        this.mCode = aCode;
        this.mName = aName;
    }

    static Scope getInstance(String aScopeName) {
        String scopeName = aScopeName.toLowerCase();
        Scope retVal = (Scope)NAME_TO_SCOPE.get(scopeName);
        if (retVal == null) {
            throw new IllegalArgumentException(scopeName);
        }
        return retVal;
    }

    private Object readResolve() throws ObjectStreamException {
        return Scope.getInstance(this.mName);
    }

    static {
        NAME_TO_SCOPE.put(SCOPENAME_NOTHING, NOTHING);
        NAME_TO_SCOPE.put(SCOPENAME_PUBLIC, PUBLIC);
        NAME_TO_SCOPE.put(SCOPENAME_PROTECTED, PROTECTED);
        NAME_TO_SCOPE.put(SCOPENAME_PACKAGE, PACKAGE);
        NAME_TO_SCOPE.put(SCOPENAME_PRIVATE, PRIVATE);
        NAME_TO_SCOPE.put(SCOPENAME_ANONINNER, ANONINNER);
    }
}

