/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import jde.debugger.JDE;
import jde.debugger.Protocol;

public class CommandStream
extends StreamTokenizer
implements Protocol {
    private final Reader m_reader;

    public CommandStream(BufferedReader in) {
        super(in);
        this.m_reader = in;
        this.setSyntax();
    }

    public List nextCommand() {
        List<String> commandLine = new ArrayList<String>();
        try {
            int token = this.nextToken();
            while (token != 10) {
                switch (token) {
                    case -1: {
                        throw new IOException("EOF occurred reading command stream.");
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        commandLine.add(this.sval);
                        break;
                    }
                    default: {
                        commandLine.add(String.valueOf((char)token));
                    }
                }
                token = this.nextToken();
            }
            if (commandLine.size() < 3) {
                if (commandLine.size() > 0) {
                    JDE.commandResult(new Integer(-1), "Malformed command", false, true);
                }
                commandLine = this.nextCommand();
            }
        }
        catch (IOException ex) {
            commandLine = null;
        }
        return commandLine;
    }

    private void setSyntax() {
        this.resetSyntax();
        this.eolIsSignificant(true);
        this.whitespaceChars(0, 32);
        this.wordChars(33, 255);
        this.quoteChar(34);
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        CommandStream commandStream = new CommandStream(in);
        out.print("> ");
        out.flush();
        List command = commandStream.nextCommand();
        while (command != null && !((String)command.get(2)).startsWith("qu")) {
            int n = command.size();
            int i = 0;
            while (i < n) {
                out.println(command.get(i));
                ++i;
            }
            out.print("> ");
            out.flush();
            command = commandStream.nextCommand();
        }
    }

    static {
        try {
            StdIn.fix();
        }
        catch (IOException exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    private static final class StdIn {
        private static InputStream in;
        private static PipedInputStream pis;
        private static PipedOutputStream pos;
        private static Thread pump;

        private StdIn() {
        }

        public static synchronized void fix() throws IOException {
            if (in != null) {
                return;
            }
            in = System.in;
            pos = new PipedOutputStream();
            pis = new PipedInputStream(pos);
            System.setIn(pis);
            pump.setDaemon(true);
            pump.setPriority(1);
            pump.start();
        }

        static /* synthetic */ InputStream access$000() {
            return in;
        }

        static /* synthetic */ PipedOutputStream access$100() {
            return pos;
        }

        static {
            pump = new Thread("StdIn Pump"){

                public void run() {
                    byte[] buf = new byte[5120];
                    try {
                        while (true) {
                            int available;
                            if ((available = StdIn.access$000().available()) == 0) {
                                Thread.sleep(50L);
                                continue;
                            }
                            int howMany = Math.min(buf.length, available);
                            StdIn.access$000().read(buf, 0, howMany);
                            StdIn.access$100().write(buf, 0, howMany);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return;
                    }
                }
            };
        }
    }
}

