/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.InterpreterConstants;
import bsh.InterpreterError;
import java.io.Serializable;

public class Primitive
implements InterpreterConstants,
Serializable {
    private Object value;
    public static final Primitive NULL = new Primitive(SpecialPrimitive.NULL_VALUE);
    public static final Primitive VOID = new Primitive(SpecialPrimitive.VOID_TYPE);

    public Primitive(byte by) {
        this(new Byte(by));
    }

    public Primitive(char c) {
        this(new Character(c));
    }

    public Primitive(double d) {
        this(new Double(d));
    }

    public Primitive(float f) {
        this(new Float(f));
    }

    public Primitive(int n) {
        this(new Integer(n));
    }

    public Primitive(long l) {
        this(new Long(l));
    }

    public Primitive(Boolean bl) {
        this((Object)bl);
    }

    public Primitive(Byte by) {
        this((Object)by);
    }

    public Primitive(Character c) {
        this((Object)c);
    }

    public Primitive(Double d) {
        this((Object)d);
    }

    public Primitive(Float f) {
        this((Object)f);
    }

    public Primitive(Integer n) {
        this((Object)n);
    }

    public Primitive(Long l) {
        this((Object)l);
    }

    public Primitive(Number number) {
        this((Object)number);
    }

    private Primitive(Object object) {
        if (object == null) {
            throw new InterpreterError("Use Primitve.NULL instead of Primitive(null)");
        }
        this.value = object;
    }

    public Primitive(Short s) {
        this((Object)s);
    }

    public Primitive(short s) {
        this(new Short(s));
    }

    public Primitive(boolean bl) {
        this(new Boolean(bl));
    }

    public static Primitive binaryOperation(Primitive primitive, Primitive primitive2, int n) throws EvalError {
        if (primitive == NULL || primitive2 == NULL) {
            throw new EvalError("illegal use of null object or 'null' literal");
        }
        if (primitive == VOID || primitive2 == VOID) {
            throw new EvalError("illegal use of undefined object or 'void' literal");
        }
        Class clazz = primitive.getType();
        Class clazz2 = primitive2.getType();
        Object[] objectArray = Primitive.promotePrimitives(primitive.getValue(), primitive2.getValue());
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (object.getClass() != object2.getClass()) {
            throw new EvalError("type mismatch in operator.  " + clazz + " cannot be matched with " + clazz2);
        }
        if (object instanceof Boolean) {
            return new Primitive(Primitive.booleanBinaryOperation((Boolean)object, (Boolean)object2, n));
        }
        if (object instanceof Integer) {
            Object object3 = Primitive.intBinaryOperation((Integer)object, (Integer)object2, n);
            return new Primitive(object3);
        }
        if (object instanceof Long) {
            return new Primitive(Primitive.longBinaryOperation((Long)object, (Long)object2, n));
        }
        if (object instanceof Float) {
            return new Primitive(Primitive.floatBinaryOperation((Float)object, (Float)object2, n));
        }
        if (object instanceof Double) {
            return new Primitive(Primitive.doubleBinaryOperation((Double)object, (Double)object2, n));
        }
        throw new EvalError("Invalid type in binary operator");
    }

    static Boolean booleanBinaryOperation(Boolean bl, Boolean bl2, int n) throws EvalError {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        switch (n) {
            case 78: {
                return new Boolean(bl3 == bl4);
            }
            case 83: {
                return new Boolean(bl3 != bl4);
            }
            case 84: 
            case 85: {
                return new Boolean(bl3 || bl4);
            }
            case 86: 
            case 87: {
                return new Boolean(bl3 && bl4);
            }
        }
        throw new InterpreterError("unimplemented binary operator");
    }

    static boolean booleanUnaryOperation(Boolean bl, int n) throws EvalError {
        boolean bl2 = bl;
        switch (n) {
            case 74: {
                return bl2 ^ true;
            }
        }
        throw new EvalError("Operator inappropriate for boolean");
    }

    public boolean booleanValue() throws EvalError {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new EvalError("Primitive not a boolean");
    }

    static Object doubleBinaryOperation(Double d, Double d2, int n) throws EvalError {
        double d3 = d;
        double d4 = d2;
        switch (n) {
            case 72: 
            case 73: {
                return new Boolean(d3 < d4);
            }
            case 70: 
            case 71: {
                return new Boolean(d3 > d4);
            }
            case 78: {
                return new Boolean(d3 == d4);
            }
            case 79: 
            case 80: {
                return new Boolean(d3 <= d4);
            }
            case 81: 
            case 82: {
                return new Boolean(d3 >= d4);
            }
            case 83: {
                return new Boolean(d3 != d4);
            }
            case 90: {
                return new Double(d3 + d4);
            }
            case 91: {
                return new Double(d3 - d4);
            }
            case 92: {
                return new Double(d3 * d4);
            }
            case 93: {
                return new Double(d3 / d4);
            }
            case 99: {
                return new Double(d3 % d4);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                throw new EvalError("Can't shift doubles");
            }
        }
        throw new InterpreterError("Unimplemented binary double operator");
    }

    static double doubleUnaryOperation(Double d, int n) {
        double d2 = d;
        switch (n) {
            case 90: {
                return d2;
            }
            case 91: {
                return -d2;
            }
        }
        throw new InterpreterError("bad double unaryOperation");
    }

    static Object floatBinaryOperation(Float f, Float f2, int n) throws EvalError {
        float f3 = f.floatValue();
        float f4 = f2.floatValue();
        switch (n) {
            case 72: 
            case 73: {
                return new Boolean(f3 < f4);
            }
            case 70: 
            case 71: {
                return new Boolean(f3 > f4);
            }
            case 78: {
                return new Boolean(f3 == f4);
            }
            case 79: 
            case 80: {
                return new Boolean(f3 <= f4);
            }
            case 81: 
            case 82: {
                return new Boolean(f3 >= f4);
            }
            case 83: {
                return new Boolean(f3 != f4);
            }
            case 90: {
                return new Float(f3 + f4);
            }
            case 91: {
                return new Float(f3 - f4);
            }
            case 92: {
                return new Float(f3 * f4);
            }
            case 93: {
                return new Float(f3 / f4);
            }
            case 99: {
                return new Float(f3 % f4);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                throw new EvalError("Can't shift floats ");
            }
        }
        throw new InterpreterError("Unimplemented binary float operator");
    }

    static float floatUnaryOperation(Float f, int n) {
        float f2 = f.floatValue();
        switch (n) {
            case 90: {
                return f2;
            }
            case 91: {
                return -f2;
            }
        }
        throw new InterpreterError("bad float unaryOperation");
    }

    public Class getType() {
        return this.getType(this.value);
    }

    private Class getType(Object object) {
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    public Object getValue() {
        if (this.value == SpecialPrimitive.NULL_VALUE) {
            return null;
        }
        if (this.value == SpecialPrimitive.VOID_TYPE) {
            throw new InterpreterError("attempt to unwrap void type");
        }
        return this.value;
    }

    static Object intBinaryOperation(Integer n, Integer n2, int n3) {
        int n4 = n;
        int n5 = n2;
        switch (n3) {
            case 72: 
            case 73: {
                return new Boolean(n4 < n5);
            }
            case 70: 
            case 71: {
                return new Boolean(n4 > n5);
            }
            case 78: {
                return new Boolean(n4 == n5);
            }
            case 79: 
            case 80: {
                return new Boolean(n4 <= n5);
            }
            case 81: 
            case 82: {
                return new Boolean(n4 >= n5);
            }
            case 83: {
                return new Boolean(n4 != n5);
            }
            case 90: {
                return new Integer(n4 + n5);
            }
            case 91: {
                return new Integer(n4 - n5);
            }
            case 92: {
                return new Integer(n4 * n5);
            }
            case 93: {
                return new Integer(n4 / n5);
            }
            case 99: {
                return new Integer(n4 % n5);
            }
            case 100: 
            case 101: {
                return new Integer(n4 << n5);
            }
            case 102: 
            case 103: {
                return new Integer(n4 >> n5);
            }
            case 104: 
            case 105: {
                return new Integer(n4 >>> n5);
            }
            case 94: 
            case 95: {
                return new Integer(n4 & n5);
            }
            case 96: 
            case 97: {
                return new Integer(n4 | n5);
            }
            case 98: {
                return new Integer(n4 ^ n5);
            }
        }
        throw new InterpreterError("Unimplemented binary integer operator");
    }

    static int intUnaryOperation(Integer n, int n2) {
        int n3 = n;
        switch (n2) {
            case 90: {
                return n3;
            }
            case 91: {
                return -n3;
            }
            case 75: {
                return ~n3;
            }
            case 88: {
                return n3 + 1;
            }
            case 89: {
                return n3 - 1;
            }
        }
        throw new InterpreterError("bad integer unaryOperation");
    }

    public int intValue() throws EvalError {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        throw new EvalError("Primitive not a number");
    }

    static Object longBinaryOperation(Long l, Long l2, int n) {
        long l3 = l;
        long l4 = l2;
        switch (n) {
            case 72: 
            case 73: {
                return new Boolean(l3 < l4);
            }
            case 70: 
            case 71: {
                return new Boolean(l3 > l4);
            }
            case 78: {
                return new Boolean(l3 == l4);
            }
            case 79: 
            case 80: {
                return new Boolean(l3 <= l4);
            }
            case 81: 
            case 82: {
                return new Boolean(l3 >= l4);
            }
            case 83: {
                return new Boolean(l3 != l4);
            }
            case 90: {
                return new Long(l3 + l4);
            }
            case 91: {
                return new Long(l3 - l4);
            }
            case 92: {
                return new Long(l3 * l4);
            }
            case 93: {
                return new Long(l3 / l4);
            }
            case 99: {
                return new Long(l3 % l4);
            }
            case 100: 
            case 101: {
                return new Long(l3 << (int)l4);
            }
            case 102: 
            case 103: {
                return new Long(l3 >> (int)l4);
            }
            case 104: 
            case 105: {
                return new Long(l3 >>> (int)l4);
            }
            case 94: 
            case 95: {
                return new Long(l3 & l4);
            }
            case 96: 
            case 97: {
                return new Long(l3 | l4);
            }
            case 98: {
                return new Long(l3 ^ l4);
            }
        }
        throw new InterpreterError("Unimplemented binary long operator");
    }

    static long longUnaryOperation(Long l, int n) {
        long l2 = l;
        switch (n) {
            case 90: {
                return l2;
            }
            case 91: {
                return -l2;
            }
            case 75: {
                return l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 88: {
                return l2 + 1L;
            }
            case 89: {
                return l2 - 1L;
            }
        }
        throw new InterpreterError("bad long unaryOperation");
    }

    public Number numberValue() throws EvalError {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        throw new EvalError("Primitive not a number");
    }

    static Object promotePrimitive(Object object) {
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        if (object instanceof Byte || object instanceof Short) {
            return new Integer(((Number)object).intValue());
        }
        return object;
    }

    static Object[] promotePrimitives(Object object, Object object2) {
        object = Primitive.promotePrimitive(object);
        object2 = Primitive.promotePrimitive(object2);
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            boolean bl = number instanceof Double;
            if (bl || number2 instanceof Double) {
                if (bl) {
                    object2 = new Double(number2.doubleValue());
                } else {
                    object = new Double(number.doubleValue());
                }
            } else {
                bl = number instanceof Float;
                if (bl || number2 instanceof Float) {
                    if (bl) {
                        object2 = new Float(number2.floatValue());
                    } else {
                        object = new Float(number.floatValue());
                    }
                } else {
                    bl = number instanceof Long;
                    if (bl || number2 instanceof Long) {
                        if (bl) {
                            object2 = new Long(number2.longValue());
                        } else {
                            object = new Long(number.longValue());
                        }
                    }
                }
            }
        }
        return new Object[]{object, object2};
    }

    public String toString() {
        if (this.value == SpecialPrimitive.NULL_VALUE) {
            return "null";
        }
        if (this.value == SpecialPrimitive.VOID_TYPE) {
            return "void";
        }
        return this.value.toString();
    }

    public static Primitive unaryOperation(Primitive primitive, int n) throws EvalError {
        if (primitive == NULL) {
            throw new EvalError("illegal use of null object or 'null' literal");
        }
        if (primitive == VOID) {
            throw new EvalError("illegal use of undefined object or 'void' literal");
        }
        Class clazz = primitive.getType();
        Object object = Primitive.promotePrimitive(primitive.getValue());
        if (object instanceof Boolean) {
            return new Primitive(Primitive.booleanUnaryOperation((Boolean)object, n));
        }
        if (object instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object, n);
            if (n == 88 || n == 89) {
                if (clazz == Byte.TYPE) {
                    return new Primitive((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Primitive((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Primitive((char)n2);
                }
            }
            return new Primitive(n2);
        }
        if (object instanceof Long) {
            return new Primitive(Primitive.longUnaryOperation((Long)object, n));
        }
        if (object instanceof Float) {
            return new Primitive(Primitive.floatUnaryOperation((Float)object, n));
        }
        if (object instanceof Double) {
            return new Primitive(Primitive.doubleUnaryOperation((Double)object, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    private static class SpecialPrimitive
    implements Serializable {
        public static final SpecialPrimitive NULL_VALUE = new SpecialPrimitive();
        public static final SpecialPrimitive VOID_TYPE = new SpecialPrimitive();

        private SpecialPrimitive() {
        }
    }
}

