/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArguments;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.InvocationTargetException;

class BSHLHSPrimarySuffix
extends SimpleNode {
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int PROPERTY = 3;
    public int operation;
    Object index;
    public String field;
    public String method;

    BSHLHSPrimarySuffix(int n) {
        super(n);
    }

    public LHS doLHSSuffix(Object object, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(object, nameSpace, interpreter);
                }
                case 2: {
                    return this.doName(object, nameSpace, interpreter);
                }
                case 3: {
                    return this.doProperty(object, nameSpace, interpreter);
                }
            }
            throw new InterpreterError("LHS suffix");
        }
        catch (ReflectError reflectError) {
            throw new EvalError("reflection error: " + reflectError, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TargetError(invocationTargetException.getTargetException(), (SimpleNode)this);
        }
    }

    private LHS doName(Object object, NameSpace nameSpace, Interpreter interpreter) throws EvalError, ReflectError, InvocationTargetException {
        if (this.jjtGetNumChildren() == 0) {
            return Reflect.getLHSObjectField(object, this.field);
        }
        Object[] objectArray = ((BSHArguments)this.jjtGetChild(0)).getArguments(nameSpace, interpreter);
        try {
            object = Reflect.invokeObjectMethod(interpreter, object, this.method, objectArray);
        }
        catch (EvalError evalError) {
            throw new EvalError(evalError.getMessage(), this);
        }
        return Reflect.getLHSObjectField(object, this.field);
    }

    private LHS doIndex(Object object, NameSpace nameSpace, Interpreter interpreter) throws EvalError, ReflectError {
        int n;
        if (!object.getClass().isArray()) {
            throw new EvalError("Not an array", this);
        }
        try {
            Primitive primitive = (Primitive)((SimpleNode)this.jjtGetChild(0)).eval(nameSpace, interpreter);
            n = primitive.intValue();
        }
        catch (Exception exception) {
            throw new EvalError("You can only index arrays by integer types", this);
        }
        return new LHS(object, n);
    }

    private LHS doProperty(Object object, NameSpace nameSpace, Interpreter interpreter) throws EvalError, ReflectError {
        if (object == Primitive.VOID) {
            throw new EvalError("Attempt to access property on a void type", this);
        }
        if (object instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this);
        }
        Object object2 = ((SimpleNode)this.jjtGetChild(0)).eval(nameSpace, interpreter);
        if (!(object2 instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this);
        }
        Interpreter.debug("LHS property access: ");
        return new LHS(object, (String)object2);
    }
}

