/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jde.wizards.DefaultNameFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class DelegateFactory
extends MethodFactory {
    private Hashtable interfaces = new Hashtable();
    static DelegateFactory delegateFactory;

    public DelegateFactory() {
    }

    public DelegateFactory(NameFactory factory) {
        super(factory);
    }

    private final void sortByDeclaringClass(Signature sig) {
        String declaring = sig.getDeclaringClass().getName();
        if (this.interfaces.containsKey(declaring)) {
            Vector v = (Vector)this.interfaces.get(declaring);
            if (!v.contains(sig)) {
                v.addElement(sig);
            }
        } else {
            Vector<Signature> v = new Vector<Signature>();
            v.addElement(sig);
            this.interfaces.put(declaring, v);
        }
    }

    public void flush() {
        super.flush();
        this.interfaces.clear();
    }

    public void process(String interfaceName) throws ClassNotFoundException {
        this.process(interfaceName, true);
    }

    public void process(String name, boolean truncate) throws ClassNotFoundException {
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        Class<?> aclass = Class.forName(name);
        Method[] methods = aclass.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.sortByDeclaringClass(new Signature(methods[i], this, truncate, true));
            ++i;
        }
    }

    public static void makeDelegates(String attributeName, String className, boolean javadoc, boolean truncate, boolean newline) {
        if (delegateFactory == null) {
            delegateFactory = new DelegateFactory();
        }
        delegateFactory.flush();
        delegateFactory.makeInterfaceInternal(attributeName, className, javadoc, truncate, newline);
    }

    private void makeInterfaceInternal(String attributeName, String className, boolean javadoc, boolean truncate, boolean newline) {
        try {
            this.process(className, truncate);
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find class named: " + className + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (Exception e) {
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dump(new PrintWriter(System.out, true), attributeName, javadoc, truncate, newline);
    }

    public static void getImportedClasses() {
        String res = "(list ";
        Enumeration i = DelegateFactory.delegateFactory.imports.keys();
        while (i.hasMoreElements()) {
            Class c = (Class)i.nextElement();
            res = res + "\"" + c.getName() + "\" ";
        }
        res = res + ")";
        MethodFactory.println(res);
    }

    public String getMethodSkeleton(Signature sig, boolean javadoc, boolean newline, String attributeName) {
        String res = "";
        res = res + "\n";
        if (javadoc) {
            res = res + sig.toJavaDoc() + "\n";
        }
        if (newline) {
            res = res + sig + "\n";
            res = res + "{\n";
        } else {
            res = res + sig + " {\n";
        }
        Method m = sig.getMethod();
        Class<?> cl = m.getReturnType();
        res = !cl.getName().equals("void") ? res + "  return " + attributeName + "." + m.getName() + "(" + sig.getParameterNames(m.getParameterTypes()) + ");\n" : res + "  " + attributeName + "." + m.getName() + "(" + sig.getParameterNames(m.getParameterTypes()) + ");\n";
        res = res + "}\n";
        return res;
    }

    public void dump(PrintWriter out, String attributeName, boolean javadoc, boolean truncate, boolean newline) {
        StringBuffer buf = new StringBuffer("\"");
        Enumeration declaring_classes = this.interfaces.keys();
        while (declaring_classes.hasMoreElements()) {
            String interf = (String)declaring_classes.nextElement();
            Vector v = (Vector)this.interfaces.get(interf);
            buf.append("// Code for delegation of ");
            buf.append(interf);
            buf.append(" methods to ");
            buf.append(attributeName);
            buf.append("\n");
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Signature sig = (Signature)e.nextElement();
                buf.append(this.getMethodSkeleton(sig, javadoc, newline, attributeName));
            }
        }
        buf.append("\"");
        MethodFactory.println(buf.toString());
    }
}

