/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jde.debugger.DebuggeeSIO;
import jde.debugger.EventHandler;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.ProcessRegistry;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.spec.BreakpointSpec;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.EventRequestSpecList;
import jde.debugger.spec.ExceptionSpec;
import jde.debugger.spec.WatchpointSpec;

public class DebuggeeProcess
implements Protocol {
    final Integer procID;
    EventHandler eventHandler;
    VirtualMachine vm;
    EventRequestSpecList eventRequestSpecs;
    ObjectStore store;
    private long objIdCounter = 0L;
    private boolean shuttingDown = false;
    DebuggeeSIO debuggeeSIO;
    ProcessRegistry procRegistry = ProcessRegistry.getRegistry();
    JDE jde = JDE.getJDE();

    public DebuggeeProcess(Integer procID, VirtualMachine vm) {
        this.procID = procID;
        this.vm = vm;
        this.store = new ObjectStore(this);
        this.eventHandler = new EventHandler(this);
        this.eventRequestSpecs = new EventRequestSpecList(this);
        ClassPrepareRequest cprequest = vm.eventRequestManager().createClassPrepareRequest();
        cprequest.putProperty("default", "default");
        cprequest.setSuspendPolicy(2);
        cprequest.enable();
        this.debuggeeSIO = new DebuggeeSIO(this);
    }

    public final VirtualMachine getVM() {
        return this.vm;
    }

    public final Integer getId() {
        return this.procID;
    }

    public final Long generateObjectID() {
        Integer n = Jdebug.debuggerID;
        synchronized (n) {
            Long l = new Long(this.objIdCounter++);
            return l;
        }
    }

    public final ObjectStore getStore() {
        return this.store;
    }

    public final EventQueue getEventQueue() {
        return this.vm.eventQueue();
    }

    public final void shutdown() {
        this.shuttingDown = true;
        Process process = null;
        if (this.vm != null) {
            process = this.vm.process();
        }
        try {
            try {
                if (this.vm != null) {
                    this.vm.dispose();
                    this.vm = null;
                    this.eventHandler.shutdown();
                }
                this.debuggeeSIO.shutdown();
            }
            catch (Exception ex) {
                Object var4_3 = null;
                if (process != null) {
                    process.destroy();
                }
                this.procRegistry.removeProcess(this.procID);
            }
            Object var4_2 = null;
            if (process != null) {
                process.destroy();
            }
            this.procRegistry.removeProcess(this.procID);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (process != null) {
                process.destroy();
            }
            this.procRegistry.removeProcess(this.procID);
            throw throwable;
        }
    }

    public List findClassesMatchingPattern(String pattern) throws JDEException {
        if (this.vm == null) {
            return null;
        }
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        if (pattern.startsWith("*.")) {
            pattern = pattern.substring(1);
            List<ReferenceType> classes = this.vm.allClasses();
            Iterator<ReferenceType> iter = classes.iterator();
            while (iter.hasNext()) {
                ReferenceType type = iter.next();
                if (!type.name().endsWith(pattern)) continue;
                result.add(type);
            }
            return result;
        }
        return this.vm.classesByName(pattern);
    }

    public ThreadReference getThread(String name) {
        List<ThreadReference> list = this.vm.allThreads();
        Iterator<ThreadReference> it = list.iterator();
        while (it.hasNext()) {
            ThreadReference thread = it.next();
            if (!thread.name().equals(name)) continue;
            return thread;
        }
        return null;
    }

    public LispForm getAllThreadsInformation() {
        List<ThreadGroupReference> l = this.vm.topLevelThreadGroups();
        String info = "(list ";
        Iterator<ThreadGroupReference> it = l.iterator();
        while (it.hasNext()) {
            info = info + Protocol.BR + Rep.getThreadGroupRep(it.next(), this.store);
        }
        info = info + ")";
        return new LispForm(info);
    }

    public void resolve(ReferenceType ref) {
        this.eventRequestSpecs.resolve(ref);
    }

    public void informJDEInstallSuccessful(EventRequestSpec spec) {
        this.jde.signal(this.procID, "spec-resolved", spec.getID());
    }

    public void removeSpecAndInformJDE(EventRequestSpec spec, String problem) {
        if (spec instanceof BreakpointSpec) {
            this.jde.signal(this.procID, "invalid-break", new LispForm(spec.getID() + " \"" + problem + "\""));
        } else if (spec instanceof WatchpointSpec) {
            this.jde.signal(this.procID, "invalid-watch", new LispForm(spec.getID() + " \"" + problem + "\""));
        } else if (spec instanceof ExceptionSpec) {
            this.jde.signal(this.procID, "invalid-trace_exceptions", new LispForm(spec.getID() + " \"" + problem + "\""));
        }
        this.eventRequestSpecs.delete(spec);
    }

    public EventRequestSpecList getEventRequestSpecs() {
        return this.eventRequestSpecs;
    }

    public DebuggeeSIO getSIO() {
        return this.debuggeeSIO;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }
}

