/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.Map;
import jde.debugger.Debug;
import jde.debugger.DebuggeeProcess;
import jde.debugger.JDEException;
import jde.debugger.command.DebugSessionCommand;

public class ListenShmem
extends DebugSessionCommand {
    protected void doCommand() throws JDEException {
        if (this.args.size() < 1) {
            throw new JDEException("Missing name");
        }
        final String address = this.args.remove(0).toString();
        String connectSpec = "com.sun.jdi.SharedMemoryListen";
        final ListeningConnector connector = (ListeningConnector)this.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        Thread thread = new Thread("Listen on shared memory channel."){

            public void run() {
                try {
                    Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
                    Connector.Argument nameArg = argumentMap.get("name");
                    nameArg.setValue(address);
                    ListenShmem.this.jde.signalCommandResult(ListenShmem.this.procID, ListenShmem.this.cmdID);
                    ListenShmem.this.jde.signal(ListenShmem.this.procID, "message", "Listening at shared memory address: " + address);
                    connector.startListening(argumentMap);
                    VirtualMachine vm = connector.accept(argumentMap);
                    connector.stopListening(argumentMap);
                    DebuggeeProcess proc = new DebuggeeProcess(ListenShmem.this.procID, vm);
                    if (ListenShmem.this.procRegistry.processExists(ListenShmem.this.procID)) {
                        proc.shutdown();
                        ListenShmem.this.jde.signal(ListenShmem.this.procID, "message", "An application with the same ID already exists.");
                    }
                    ListenShmem.this.procRegistry.addProcess(ListenShmem.this.procID, proc);
                    ListenShmem.this.jde.signal(ListenShmem.this.procID, "message", "Attached VM (shmem) " + vm.description());
                }
                catch (IOException ex) {
                    Debug.printIf(ex);
                    ListenShmem.this.jde.signal(ListenShmem.this.procID, "message", "I/O error occured while listening at shared memory address:" + address);
                }
                catch (IllegalConnectorArgumentsException ex) {
                    ListenShmem.this.jde.signal(ListenShmem.this.procID, "message", "Illegal argument error occurred while listening at shared memory address: " + address);
                }
            }
        };
        thread.start();
    }

    public Object clone() {
        return new ListenShmem();
    }
}

