/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.Configuration;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.regexp.RESyntaxException;

public final class Main {
    static /* synthetic */ Class class$com$puppycrawl$tools$checkstyle$Main;

    public static void main(String[] aArgs) {
        if (aArgs.length == 0) {
            Main.usage();
        }
        String format = "plain";
        String output = null;
        Properties properties = System.getProperties();
        ArrayList<String> files = new ArrayList<String>();
        int i = 0;
        while (i < aArgs.length) {
            if ("-f".equals(aArgs[i])) {
                format = aArgs[++i];
            } else if ("-o".equals(aArgs[i])) {
                output = aArgs[++i];
            } else if ("-r".equals(aArgs[i])) {
                Main.traverse(new File(aArgs[++i]), files);
            } else if ("-p".equals(aArgs[i])) {
                properties = Main.loadProperties(new File(aArgs[++i]));
            } else {
                files.add(aArgs[i]);
            }
            ++i;
        }
        OutputStream out = System.out;
        boolean closeOut = false;
        if (output != null) {
            try {
                out = new FileOutputStream(output);
                closeOut = true;
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not find file: '" + output + "'");
                System.exit(1);
            }
        }
        AuditListener listener = null;
        if ("xml".equals(format)) {
            listener = new XMLLogger(out, closeOut);
        } else if ("plain".equals(format)) {
            listener = new DefaultLogger(out, closeOut);
        } else {
            System.out.println("Invalid format: (" + format + "). Must be 'plain' or 'xml'.");
            Main.usage();
        }
        Checker c = null;
        try {
            c = new Checker(new Configuration(properties, System.out));
            c.addListener(listener);
        }
        catch (RESyntaxException rese) {
            System.out.println("Unable to create an regexp object: " + rese.getMessage());
            rese.printStackTrace(System.out);
            System.exit(1);
        }
        catch (IOException ex) {
            System.out.println("I/O error occurred: " + ex.getMessage());
            ex.printStackTrace(System.out);
            System.exit(1);
        }
        int numErrs = c.process(files.toArray(new String[files.size()]));
        c.destroy();
        System.exit(numErrs);
    }

    private static void usage() {
        System.out.println("Usage: java " + (class$com$puppycrawl$tools$checkstyle$Main == null ? (class$com$puppycrawl$tools$checkstyle$Main = Main.class$("com.puppycrawl.tools.checkstyle.Main")) : class$com$puppycrawl$tools$checkstyle$Main).getName() + " <options> <file>......");
        System.out.println("Options");
        System.out.println("\t-f <format>\tsets output format. (plain|xml). Default to plain.");
        System.out.println("\t-o <file>\tsets output file name. Defaults to stdout");
        System.out.println("\t-r <dir>\ttraverses the directory for Java source files.");
        System.out.println("\t-p <file>\tuses a properties file instead of the system properties.");
        System.exit(1);
    }

    private static void traverse(File aNode, List aFiles) {
        if (aNode.canRead()) {
            if (aNode.isDirectory()) {
                File[] nodes = aNode.listFiles();
                int i = 0;
                while (i < nodes.length) {
                    Main.traverse(nodes[i], aFiles);
                    ++i;
                }
            } else if (aNode.isFile() && aNode.getPath().endsWith(".java")) {
                aFiles.add(aNode.getPath());
            }
        }
    }

    private static Properties loadProperties(File aFile) {
        Properties properties = new Properties();
        try {
            FileInputStream fis = null;
            fis = new FileInputStream(aFile);
            properties.load(fis);
            fis.close();
        }
        catch (IOException ex) {
            System.out.println("Unable to load properties from file: " + aFile.getAbsolutePath());
            ex.printStackTrace(System.out);
            System.exit(1);
        }
        return properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

