/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:  Mark Allender (allender@cs.uiuc.edu)
 *               Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

#ifndef CALLBACK_H
#define CALLBACK_H

#include "graph.h"
/*
 *  This header file contains the structure information for the callbacks.
 *  We have structures that will take care of 1) a key table in which the
 *  key and mouse bindings for the callbacks are stored.  2) a function table
 *  in which the actual data for the particular callback function is stored,
 *  (notice that this gives us ways to put multiple bindings on the same
 *  callback function).  3) a possible table to hold tag and domains.  At
 *  compilation time, a choice can be made between either storing tag/domain
 *  information directly (more memory), or being able to store tag/domain
 *  information in a table (less memory).  There is a speed tradeoff here
 *  as well.
 *  A callback has several different part associated with it.  First,
 *  the user supplies a name to this callback.  This is identical in nature
 *  to the unique id's associated with nodes and edges.  Next, the function
 *  type must be specified.  The function may be one of the builtin functions,
 *  or a bus-message type function.  Data that is either sent back on the
 *  bus, or has some significance to the internal function being assigned
 *  in given.  And tag and domain information is also given.
*/
#define ADDKEY 0
#define UPDATEKEY 1
#define REMOVEKEY 2
#define SHIFT 3
#define CTRL 4
#define META 5
#define UP 6
#define DOWN 7
#define MAKEASSOC 8
#define UPDATEASSOC 9
#define REMOVEASSOC 10

/*
 *  Defines for function lists.
*/
#define ADDFUNCTION 0
#define UPFUNCTION 1
#define RMFUNCTION 2
#define DATA 3
#define TAG 4
#define FDOMAIN 5
#define FUNCTION 6

#define UP_MASK 1
#define DOWN_MASK 2

struct FunctionList
{
  char *function;
  struct FunctionList *next;
};

struct KeyBindings
{
  char key;				/* key or button being bound */
  short keymask;			/* mask for key/button modifiers */
  short udmask;				/* mask for motion on buttons */
  short noclobber;
  struct FunctionList *func_list;      	/* list of functions for key */
  struct KeyBindings *next;
};

struct FunctionBindings
{
  char *name;				/* this is the user defined name */
  char *function;			/* specifies what type of callback */
  char *data;				/* the actual data for the callback */
  char *tag;				
  char *domain;
  short noclobber;
  struct FunctionBindings *next;
};

/*
 *  Now, we will define the structures that contain the browser wide
 *  callback key and function bindings.  This is similiar in nature to
 *  the definitions for browser wide display tables (in that it preforms
 *  the same function of providing a browser wide set of data.
*/

struct KeyBindings *CallbackKeys;
struct FunctionBindings *CallbackFunctions;

struct CallbackInfo
{
  int data_mask;		/* Tells what data we know */
  int start_x, start_y;		/* Position of first event */
  int end_x, end_y;		/* Swept region if there is one */
  int mod_mask;			/* The mask of keyboard modifiers (ctrl) */
  int keysym;			/* This is the key or the button */
  int buttonmask;		/* Button mask for mouse buttons */
  Vertex *node;			/* The node we were over */
  Edge *edge;			/* The edge we were over */
  NodeList *selected_nodes;	/* List of selected nodes */
  NodeList *swept_nodes;	/* List of swept nodes */
};

struct CallbackTable
{
  char *FunctionName;		/* The name of the function */
  int (*Function)();		/* And the function to run */
};

#endif
