/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:  Thomas Fruchterman
 *		 John Jozwiak
 *		 Mark Allender (allender@cs.uiuc.edu)
 *               Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */
/*
     Nature -- a force-directed graph-drawing program
     author: Thomas Fruchterman
     copyright 1990 Thomas Fruchterman

	Converted to C December, 1990  Mark Allender
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#if 0
#ifndef NeXT
#include <malloc.h>
#endif
#endif
#include "extern.h"
#include "graph.h"

/*
   input contains the routines which read the graph
   and symbol table management

   many methods for Graph and Vertex are here, and I wonder
   if they really ought to be in graph.cc
*/

Link *
AddLink(fnode, tnode, edge)
     Vertex *fnode, *tnode;
     Edge *edge;
{
  Link *nlink;
  EdgeIdList *elist;

  /* Right now we don't support looped edges */
  if (fnode == tnode)
  {
    return;
  }
  /* Add a new link box. */
  nlink = NEW(Link);
  nlink->fnode = fnode;		/* Point to the from node */
  nlink->tnode = tnode;		/* Point to the to node */
  nlink->edge = edge;		/* Point to the edge */
  nlink->n_adj_node = fnode->links;
/*
 *  If what fnode used to point to is not NULL, then we must fix up
 *  the ptr_type for that link structure and tell it that we are now
 *  pointing to a link structure, and not a Vertex *.  Do this by
 *  zeroing out the lower order bits by anding the EDGEMASK.
*/
  if (nlink->n_adj_node != NULL) {
    nlink->n_adj_node->p_adj_node = nlink;
    nlink->n_adj_node->ptr_type &= EDGEMASK;
  }
  nlink->p_adj_node = (Link *)fnode;
  nlink->n_edge_adj_node = edge->links;
  if (nlink->n_edge_adj_node != NULL) {
    nlink->n_edge_adj_node->p_edge_adj_node = nlink;
    nlink->n_edge_adj_node->ptr_type &= NODEMASK;
  }
  nlink->p_edge_adj_node = (Link *)edge;
  nlink->ptr_type = NODEMASK | EDGEMASK;
  fnode->links = nlink;
  edge->links = nlink;
  /* Now record the fact that this edge points to the to node */
  elist = NEW(EdgeIdList);
  elist->edge_id = edge->values->i_name;
  elist->next = tnode->edge_id_list;
  tnode->edge_id_list = elist;
  /* Now we want to record the fact that the edge links these two nodes. */
  if (NewNodetoList (&edge->edge_nodes, fnode)) edge->node_count++;
  if (NewNodetoList (&edge->edge_nodes, tnode)) edge->node_count++;
}
    
/*
   AssignStrVal was created by Doug Bogia on Aug. 26, 1991
   Description:
     This assigns the passed in value to the variable if it is non-null
     otherwise it assigns the default
   Entry:
     FillValue-------> None.
     NewValue--------> This is the data to use unless it is null
     DefaultValue----> This is the data to use if NewValue is null
   Exit:
     FillValue-------> This will have the new data
     NewValue--------> None.
     DefaultValue----> None.
   Returns:
     None.
*/
void AssignStrVal (FillValue, NewValue, DefaultValue)
  char **          FillValue;
  char *           NewValue;
  char *           DefaultValue;
{
  /* Start of variables section */
  /* End of variables section */
  if (NewValue)
  {
    *FillValue = NewValue;
  }
  else
  {
    *FillValue = (char *)malloc (strlen(DefaultValue)+1);
    strcpy (*FillValue, DefaultValue);
  }
} /* End of AssignStrVal */

void
AssignCommons(common, name, label, type, short_l, long_l, key_list, 
	      fixed, flag)
  CommonVals *common;
  char *name, *label, *type, *short_l, *long_l;
  KeyList *key_list;
  int fixed, flag;
{
  common->i_name = name;
  if (flag & NODEMASK)
    AssignStrVal (&common->labels[0], label, "Node (No label)");
  else
    AssignStrVal(&common->labels[0], label, "Edge (No label)");
  AssignStrVal (&common->type, type, "No type");
  AssignStrVal(&common->labels[1], short_l, "");
  AssignStrVal(&common->labels[2], long_l, "");
  common->status = 0;
  common->super_node = NULL;
  common->status |= fixed;
  common->key_list = key_list;
}

Vertex *
MakeVertex(i_name, label, type, short_l, long_l, fixed, xpos, ypos, key_list)
     char *i_name, *label, *type, *short_l, *long_l;
     char *xpos, *ypos;
     int fixed;
     KeyList *key_list;
{
  Vertex *new_v;

  new_v = NEW(Vertex);
  new_v->values = NEW(CommonVals);
  AssignCommons(new_v->values, i_name, label, type, short_l, long_l,
		key_list, fixed, NODEMASK);
  new_v->links = NULL;
  new_v->edge_id_list = NULL;
  new_v->pos[0] = (xpos ? atof(xpos) : 0.25 + (drand48() / 2.0));
  new_v->pos[1] = (ypos ? atof(ypos) : 0.25 + (drand48() / 2.0));
  new_v->newpos[0] = 0.0;		/* needed for graphReassign */
  new_v->newpos[1] = 0.0;	        /* needed for graphReassign */
  new_v->next = graph->v;
  graph->v = new_v;
  return new_v;
}

Edge *
MakeEdge(i_name, label, type, short_l, long_l, key_list)
     char *i_name, *label, *type, *short_l, *long_l;
     KeyList *key_list;
{
  int i;
  Edge *new_e;

  new_e = NEW(Edge);
  new_e->values = NEW(CommonVals);
  AssignCommons(new_e->values, i_name, label, type, short_l, long_l,
		key_list, FALSE, EDGEMASK);
  new_e->next = graph->edges;
  new_e->links = NULL;
  new_e->edge_nodes = NULL;
  new_e->super_edge = NULL;
  new_e->node_count = 0;
  graph->edges = new_e;
  return new_e;
}
