/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server text support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node121.text,v $ */

static char rcsid[] = "text.c $Revision: 1.1 $ $Date: 92/05/08 15:25:10 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/Text.h>
#include <Xm/Form.h>
/* ------------------------------------------------------------------------ */
extern void
  TextRemove(), TextUpdate(), TextReply(), TextEditable(),
  TextRealized(), TextTransmit();

extern t_generic_widget TextHandle();

struct widget_class_struct TextClassRecord =
{
  WS_TEXT, "text",
  TextHandle, TextRemove, NULL, TextUpdate, TextReply, TextRealized,
  TextTransmit, TextEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct text_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  Widget label_widget;
  Widget text_widget;
} * t_text_widget;

/* ------------------------------------------------------------------------ */
void
TextSize(str, width, height)
     char *str;
     int *width, *height;
{
  int count = 1;
  int cols = 20, x;
  char *tmp;

  *width = 10;
  *height = 2;

  if (NULL == str) return;

  while (NULL != (tmp = strchr(str, '\n')))
    {
      count += 1;
      x = tmp - str;
      if (x > cols) cols = x;
      str = tmp + 1;
    }
  x = strlen(str);			/* length of last, non-CR line */
  if (x > cols) cols = x;
  *height = count < 2 ? 2 : count;
  *width = cols < 10 ? 10 : cols;
  return;
}
/* ------------------------------------------------------------------------ */
/* sexp should be (text "id" "text" &key title "title") */
static struct keyword_entry_struct TextKeywords[] =
{
  { ":title", NULL, KEYWORD_COOKED },
};

t_generic_widget
TextHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_text_widget text;
  t_sexp s_value;
  char *value, *title;
  int width, height;
  int n;
  Arg argl[16];

  /* check things to see if they're in the right format */
  if (NULL == parent || NULL == sexp) return NULL;
  s_value = MBnth(sexp, 2);
  if (!MB_STRINGP(s_value))
    {
      if (MBLogLevel > 1) fprintf(stderr, "Bad type for text value\n");
      return NULL;
    }

  text = NEW_STRUCT(text_widget_struct);
  text->type = WS_TEXT;
  text->class = &TextClassRecord;
  text->parent = parent;
  text->top = parent->top;
  text->id = Getnth(sexp, 1);

  MBparse_keywords(MBnthcdr(sexp,3), TextKeywords, ARRAY_SIZE(TextKeywords));
  title = (char *)TextKeywords[0].result;

  XtSetArg(argl[0], XmNuserData, text);
  XtSetArg(argl[1], XmNresizable, True);
  XtSetArg(argl[2], XmNallowResize, True);
  text->widget = XtCreateWidget("form", xmFormWidgetClass,
				      parent->widget, argl, 3);

  text->label_widget = CreateTitle(NULL == title ? "" : title,
				   text->widget);
  n = 0;
  XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNalignment, XmALIGNMENT_CENTER), ++n;
  XtSetValues(text->label_widget, argl, n);

  value = MBCstring(s_value);
  n = 0;
  XtSetArg(argl[n], XmNeditable, False), ++n;
  XtSetArg(argl[n], XmNbottomAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  if (NULL != title)
    {
      XtSetArg(argl[n], XmNtopAttachment, XmATTACH_WIDGET), ++n;
      XtSetArg(argl[n], XmNtopWidget, text->label_widget), ++n;
    }
  else
    XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNvalue, value), ++n;
  XtSetArg(argl[n], XmNeditMode, XmMULTI_LINE_EDIT), ++n;
  XtSetArg(argl[n], XmNautoShowCursorPosition, False), ++n;
  TextSize(value, &width, &height);
  XtSetArg(argl[n], XmNrows, height), ++n;
  XtSetArg(argl[n], XmNcolumns, width), ++n;
#if 0
  text->text_widget = XmCreateScrolledText(text->widget, "text", argl, n);
#else
  XtSetArg(argl[n], XmNsensitive, False), ++n;
  text->text_widget = XtCreateWidget("text", xmTextWidgetClass,
				     text->widget, argl, n);
#endif

  if (NULL != title)
    {
      n = 0;
      XtSetArg(argl[n], XmNtopAttachment, XmATTACH_WIDGET), ++n;
      XtSetArg(argl[n], XmNtopWidget, text->label_widget), ++n;
      XtSetValues(text->text_widget, argl, n);

      XtManageChild(text->label_widget);
    }

  XtManageChild(text->text_widget);
  XtFree(title); XtFree(value);

  return (t_generic_widget)text;
}
/* ------------------------------------------------------------------------ */
void
TextRemove(self) t_text_widget self;
{
  MBfree(self->id);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the text */
static struct keyword_entry_struct TextUpdateKeys[] =
{
  { ":title", NULL, KEYWORD_COOKED },
  { ":value", NULL, KEYWORD_COOKED },
};

void
TextUpdate(self,sexp)
     t_text_widget self;
     t_sexp sexp;
{
  char *label, *value;
  Arg argl[1];
  short l_width, t_width;

  if (!MBequal(MBnth(sexp,1), self->id)) return;

  MBparse_keywords(MBnthcdr(sexp,2), TextUpdateKeys,
		ARRAY_SIZE(TextUpdateKeys));
  label = (char *)TextUpdateKeys[0].result;
  value = (char *)TextUpdateKeys[1].result;

  if (NULL != label) SetTitle(self->label_widget, label);
  if (NULL != value) XmTextSetString(self->text_widget, value);

  XtFree(label); XtFree(value);
}
/* ------------------------------------------------------------------------ */
void
TextReply(self, reply)
     t_text_widget self;
     t_mbus_reply reply;
{
  self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
void
TextRealized(self) t_text_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
TextEditable(self, flag)
     t_text_widget self;
     int flag;
{
}
/* ------------------------------------------------------------------------ */
void
TextTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_text_widget self;
{
}
/* ------------------------------------------------------------------------ */
