#ifndef lint
static char *rcs_id = "$Id: sort.c,v 1.4 1992/11/30 07:35:09 proj Exp $";
#endif /* lint */
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/*	Version 4.0
 */
/*
sort program
*/

#include <stdio.h>
#include "commonhd.h"
#include "config.h"
#include "jslib.h"
#include "jh.h"
#include "jdata.h"

extern int init_heap();
extern void ujis_header(), read_ujis(), reverse_yomi(), sort(),
  output_ujis();
int reverse = 0;
struct JT jt;
struct wnn_file_head file_head;

void
main(argc, argv)
int argc;
char **argv;
{
    int c;
    char *cswidth_name;
    extern char *get_cswidth_name();
    extern void set_cswidth();
    extern int optind;
    extern char *optarg;

    if (cswidth_name = get_cswidth_name(WNN_DEFAULT_LANG))
	set_cswidth(create_cswidth(cswidth_name));
    while ((c = getopt(argc,argv,"r")) != EOF) {
	switch(c){
	case 'r':
	    reverse = 1;
	    break;
	}
    }
    init_heap(MAX_ENTRIES * HEAP_PER_LINE,
	      MAX_ENTRIES * YOMI_PER_LINE,
	      MAX_ENTRIES, MAX_ENTRIES, stdin);
    
#ifdef CHINESE
    { int which_dict;
    ujis_header(&which_dict);
    }
#else
    ujis_header();
#endif
    read_ujis(NORMAL, 0, 0);
#ifdef CHINESE
    sort();
#else
    if(reverse)
	reverse_yomi();
    sort();
    if(reverse)
	reverse_yomi();
#endif
    output_ujis(stdout, 0, 1);
}
