/*
 * Decompiled with CFR 0.152.
 */
package jde.ui.design;

import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jde.ui.design.DesignAction;
import jde.ui.design.StringBundle;
import jde.ui.design.StringBundleEvent;
import jde.ui.design.StringBundleEventListener;

public class StringBundleView
extends JInternalFrame {
    StringTableModel fTableModel;
    JTable fStringTable;
    StringBundle fStrings;
    String[] columnName = new String[]{"Key", "String"};

    public StringBundleView(StringBundle strings) {
        super("String Bundle: " + strings.getName());
        this.setSize(200, 200);
        this.setVisible(true);
        this.setResizable(true);
        this.fStrings = strings;
        this.fTableModel = new StringTableModel();
        this.fTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
            }
        });
        this.fStringTable = new JTable(this.fTableModel);
        JScrollPane scrollPane = new JScrollPane(this.fStringTable);
        this.getContentPane().add(scrollPane);
        this.createMenubar();
        this.fStrings.addStringBundleEventListener(new StringEventHandler());
    }

    public void createMenubar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("String");
        DesignAction action = new DesignAction("Add", "add_string");
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.getAccessibleContext().setAccessibleDescription("Adds a string to the active string bundle.");
        menu.add(action);
        action = new DesignAction("Delete", "delete_string");
        menuItem = new JMenuItem(action);
        menuItem.getAccessibleContext().setAccessibleDescription("Removes the selected string from the active string bundle.");
        menu.add(action);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    public StringBundle getStringBundle() {
        return this.fStrings;
    }

    class StringEventHandler
    implements StringBundleEventListener {
        public void handleEvent(StringBundleEvent event) {
            switch (event.getType()) {
                case 0: {
                    StringBundleView.this.fTableModel.fireTableDataChanged();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    class StringTableModel
    extends AbstractTableModel {
        StringTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return StringBundleView.this.fStrings.getSize();
        }

        public String getColumnName(int col) {
            return StringBundleView.this.columnName[col];
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= StringBundleView.this.fStrings.getSize()) {
                return null;
            }
            if (columnIndex == 0) {
                return StringBundleView.this.fStrings.getKey(rowIndex);
            }
            if (columnIndex == 1) {
                return StringBundleView.this.fStrings.getString(rowIndex);
            }
            throw new Error("Invalid columnIndex: " + columnIndex);
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                StringBundleView.this.fStrings.setKey((String)value, row);
            } else {
                StringBundleView.this.fStrings.setString((String)value, row);
            }
        }
    }
}

