; -*- coding: iso-2022-7bit  -*-
;;; u-cns-4.el --- tables between UCS and CNS 11643:1992 plane 4

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-4 'unicode-assoc
     'cns11643-4-vs-unicode-assoc)

(defvar cns11643-4-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(J!!(B . "0x20086") ; <CJK>
       (?$(J!"(B . "0x4E40") ; <CJK>
       (?$(J!#(B . "0x4E41") ; <CJK>
       (?$(J!$(B . "0x4E5A") ; <CJK>
       (?$(J!%(B . "0x21FE8") ; <CJK>
       (?$(J!&(B . "0x4E02") ; <CJK>
       (?$(J!'(B . "0x4E29") ; <CJK>
       (?$(J!((B . "0x2010E") ; <CJK>
       (?$(J!)(B . "0x20627") ; <CJK>
       (?$(J!*(B . "0x5202") ; <CJK>
       (?$(J!+(B . "0x353E") ; <CJK>
       (?$(J!,(B . "0x5DDC") ; <CJK>
       (?$(J!-(B . "0x2053C") ; <CJK>
       (?$(J!.(B . "0x20675") ; <CJK>
       (?$(J!/(B . "0x2F828") ; <CJK>
       (?$(J!0(B . "0x5342") ; <CJK>
       (?$(J!1(B . "0x536A") ; <CJK>
       (?$(J!2(B . "0x5B52") ; <CJK>
       (?$(J!3(B . "0x2193C") ; <CJK>
       (?$(J!4(B . "0x2F875") ; <CJK>
       (?$(J!5(B . "0x2F878") ; <CJK>
       (?$(J!6(B . "0x5FC4") ; <CJK>
       (?$(J!7(B . "0x624C") ; <CJK>
       (?$(J!8(B . "0x72AD") ; <CJK>
       (?$(J!9(B . "0x4E12") ; <CJK>
       (?$(J!:(B . "0x4E2F") ; <CJK>
       (?$(J!;(B . "0x4E96") ; <CJK>
       (?$(J!<(B . "0x4ED0") ; <CJK>
       (?$(J!=(B . "0x5142") ; <CJK>
       (?$(J!>(B . "0x5183") ; <CJK>
       (?$(J!?(B . "0x2F819") ; <CJK>
       (?$(J!@(B . "0x206A5") ; <CJK>
       (?$(J!A(B . "0x206AA") ; <CJK>
       (?$(J!B(B . "0x2090F") ; <CJK>
       (?$(J!C(B . "0x20A0E") ; <CJK>
       (?$(J!D(B . "0x5383") ; <CJK>
       (?$(J!E(B . "0x53B8") ; <CJK>
       (?$(J!F(B . "0x20B9C") ; <CJK>
       (?$(J!G(B . "0x20B9B") ; <CJK>
       (?$(J!H(B . "0x2123C") ; <CJK>
       (?$(J!I(B . "0x5928") ; <CJK>
       (?$(J!J(B . "0x21BC2") ; <CJK>
       (?$(J!K(B . "0x5C23") ; <CJK>
       (?$(J!L(B . "0x5E01") ; <CJK>
       (?$(J!M(B . "0x5F00") ; <CJK>
       (?$(J!N(B . "0x233B4") ; <CJK>
       (?$(J!O(B . "0x3CB8") ; <CJK>
       (?$(J!P(B . "0x706C") ; <CJK>
       (?$(J!Q(B . "0x722B") ; <CJK>
       (?$(J!R(B . "0x5188") ; <CJK>
       (?$(J!S(B . "0x8279") ; <CJK>
       (?$(J!T(B . "0x8FB6") ; <CJK>
       (?$(J!U(B . "0x4E17") ; <CJK>
       (?$(J!V(B . "0x20065") ; <CJK>
       (?$(J!W(B . "0x340C") ; <CJK>
       (?$(J!X(B . "0x201B2") ; <CJK>
       (?$(J!Y(B . "0x3430") ; <CJK>
       (?$(J!Z(B . "0x4EE2") ; <CJK>
       (?$(J![(B . "0x4EDB") ; <CJK>
       (?$(J!\(B . "0x20477") ; <CJK>
       (?$(J!](B . "0x20542") ; <CJK>
       (?$(J!^(B . "0x51AD") ; <CJK>
       (?$(J!_(B . "0x20633") ; <CJK>
       (?$(J!`(B . "0x51F7") ; <CJK>
       (?$(J!a(B . "0x34DA") ; <CJK>
       (?$(J!b(B . "0x206AF") ; <CJK>
       (?$(J!c(B . "0x20836") ; <CJK>
       (?$(J!d(B . "0x3513") ; <CJK>
       (?$(J!e(B . "0x531B") ; <CJK>
       (?$(J!f(B . "0x5388") ; <CJK>
       (?$(J!g(B . "0x5387") ; <CJK>
       (?$(J!h(B . "0x20B22") ; <CJK>
       (?$(J!i(B . "0x53CF") ; <CJK>
       (?$(J!j(B . "0x53FD") ; <CJK>
       (?$(J!k(B . "0x3563") ; <CJK>
       (?$(J!l(B . "0x53E7") ; <CJK>
       (?$(J!m(B . "0x56DC") ; <CJK>
       (?$(J!n(B . "0x211A3") ; <CJK>
       (?$(J!o(B . "0x56D9") ; <CJK>
       (?$(J!p(B . "0x5725") ; <CJK>
       (?$(J!q(B . "0x5727") ; <CJK>
       (?$(J!r(B . "0x5933") ; <CJK>
       (?$(J!s(B . "0x5C13") ; <CJK>
       (?$(J!t(B . "0x21C25") ; <CJK>
       (?$(J!u(B . "0x21C24") ; <CJK>
       (?$(J!v(B . "0x5C75") ; <CJK>
       (?$(J!w(B . "0x22052") ; <CJK>
       (?$(J!x(B . "0x22189") ; <CJK>
       (?$(J!y(B . "0x224BF") ; <CJK>
       (?$(J!z(B . "0x39C4") ; <CJK>
       (?$(J!{(B . "0x39C3") ; <CJK>
       (?$(J!|(B . "0x66F1") ; <CJK>
       (?$(J!}(B . "0x233B5") ; <CJK>
       (?$(J!~(B . "0x2574C") ; <CJK>
       (?$(J"!(B . "0x7F52") ; <CJK>
       (?$(J""(B . "0x28E14") ; <CJK>
       (?$(J"#(B . "0x28E12") ; <CJK>
       (?$(J"$(B . "0x3401") ; <CJK>
       (?$(J"%(B . "0x200A3") ; <CJK>
       (?$(J"&(B . "0x200A2") ; <CJK>
       (?$(J"'(B . "0x4E51") ; <CJK>
       (?$(J"((B . "0x4E6A") ; <CJK>
       (?$(J")(B . "0x201B6") ; <CJK>
       (?$(J"*(B . "0x4F0C") ; <CJK>
       (?$(J"+(B . "0x201B5") ; <CJK>
       (?$(J",(B . "0x201B4") ; <CJK>
       (?$(J"-(B . "0x4EFE") ; <CJK>
       (?$(J".(B . "0x4F1B") ; <CJK>
       (?$(J"/(B . "0x201C2") ; <CJK>
       (?$(J"0(B . "0x201B8") ; <CJK>
       (?$(J"1(B . "0x343A") ; <CJK>
       (?$(J"2(B . "0x20479") ; <CJK>
       (?$(J"3(B . "0x34AB") ; <CJK>
       (?$(J"4(B . "0x5173") ; <CJK>
       (?$(J"5(B . "0x20508") ; <CJK>
       (?$(J"6(B . "0x518E") ; <CJK>
       (?$(J"7(B . "0x2057A") ; <CJK>
       (?$(J"8(B . "0x205B6") ; <CJK>
       (?$(J"9(B . "0x206BD") ; <CJK>
       (?$(J":(B . "0x206B7") ; <CJK>
       (?$(J";(B . "0x206BC") ; <CJK>
       (?$(J"<(B . "0x34DD") ; <CJK>
       (?$(J"=(B . "0x206C4") ; <CJK>
       (?$(J">(B . "0x206C9") ; <CJK>
       (?$(J"?(B . "0x52A5") ; <CJK>
       (?$(J"@(B . "0x3515") ; <CJK>
       (?$(J"A(B . "0x52A7") ; <CJK>
       (?$(J"B(B . "0x52A4") ; <CJK>
       (?$(J"C(B . "0x20930") ; <CJK>
       (?$(J"D(B . "0x20983") ; <CJK>
       (?$(J"E(B . "0x20985") ; <CJK>
       (?$(J"F(B . "0x20A12") ; <CJK>
       (?$(J"G(B . "0x20A34") ; <CJK>
       (?$(J"H(B . "0x53BD") ; <CJK>
       (?$(J"I(B . "0x20AE4") ; <CJK>
       (?$(J"J(B . "0x20ADE") ; <CJK>
       (?$(J"K(B . "0x20B2A") ; <CJK>
       (?$(J"L(B . "0x5402") ; <CJK>
       (?$(J"M(B . "0x20BAF") ; <CJK>
       (?$(J"N(B . "0x20BB4") ; <CJK>
       (?$(J"O(B . "0x20BB3") ; <CJK>
       (?$(J"P(B . "0x20BB1") ; <CJK>
       (?$(J"Q(B . "0x572B") ; <CJK>
       (?$(J"R(B . "0x591B") ; <CJK>
       (?$(J"S(B . "0x5935") ; <CJK>
       (?$(J"T(B . "0x215DE") ; <CJK>
       (?$(J"U(B . "0x36A7") ; <CJK>
       (?$(J"V(B . "0x36A5") ; <CJK>
       (?$(J"W(B . "0x216B8") ; <CJK>
       (?$(J"X(B . "0x216B0") ; <CJK>
       (?$(J"Y(B . "0x36A6") ; <CJK>
       (?$(J"Z(B . "0x219C2") ; <CJK>
       (?$(J"[(B . "0x5B90") ; <CJK>
       (?$(J"\(B . "0x5C17") ; <CJK>
       (?$(J"](B . "0x377C") ; <CJK>
       (?$(J"^(B . "0x21C2A") ; <CJK>
       (?$(J"_(B . "0x5C70") ; <CJK>
       (?$(J"`(B . "0x5C7D") ; <CJK>
       (?$(J"a(B . "0x37A9") ; <CJK>
       (?$(J"b(B . "0x21FE9") ; <CJK>
       (?$(J"c(B . "0x5DE9") ; <CJK>
       (?$(J"d(B . "0x22057") ; <CJK>
       (?$(J"e(B . "0x3834") ; <CJK>
       (?$(J"f(B . "0x3835") ; <CJK>
       (?$(J"g(B . "0x221B6") ; <CJK>
       (?$(J"h(B . "0x221D7") ; <CJK>
       (?$(J"i(B . "0x221DE") ; <CJK>
       (?$(J"j(B . "0x38A8") ; <CJK>
       (?$(J"k(B . "0x5F19") ; <CJK>
       (?$(J"l(B . "0x5F1C") ; <CJK>
       (?$(J"m(B . "0x5F75") ; <CJK>
       (?$(J"n(B . "0x224C2") ; <CJK>
       (?$(J"o(B . "0x225AB") ; <CJK>
       (?$(J"p(B . "0x38FF") ; <CJK>
       (?$(J"q(B . "0x5FC8") ; <CJK>
       (?$(J"r(B . "0x2298F") ; <CJK>
       (?$(J"s(B . "0x39C7") ; <CJK>
       (?$(J"t(B . "0x39C6") ; <CJK>
       (?$(J"u(B . "0x39C8") ; <CJK>
       (?$(J"v(B . "0x22A6D") ; <CJK>
       (?$(J"w(B . "0x22EB5") ; <CJK>
       (?$(J"x(B . "0x3AD0") ; <CJK>
       (?$(J"y(B . "0x3AD1") ; <CJK>
       (?$(J"z(B . "0x233C0") ; <CJK>
       (?$(J"{(B . "0x233BF") ; <CJK>
       (?$(J"|(B . "0x3C59") ; <CJK>
       (?$(J"}(B . "0x239B9") ; <CJK>
       (?$(J"~(B . "0x23B1C") ; <CJK>
       (?$(J#!(B . "0x6C12") ; <CJK>
       (?$(J#"(B . "0x3CBD") ; <CJK>
       (?$(J##(B . "0x23C80") ; <CJK>
       (?$(J#$(B . "0x24184") ; <CJK>
       (?$(J#%(B . "0x24185") ; <CJK>
       (?$(J#&(B . "0x3E28") ; <CJK>
       (?$(J#'(B . "0x72B3") ; <CJK>
       (?$(J#((B . "0x24724") ; <CJK>
       (?$(J#)(B . "0x3EA9") ; <CJK>
       (?$(J#*(B . "0x7390") ; <CJK>
       (?$(J#+(B . "0x7536") ; <CJK>
       (?$(J#,(B . "0x2634C") ; <CJK>
       (?$(J#-(B . "0x43CC") ; <CJK>
       (?$(J#.(B . "0x26AF6") ; <CJK>
       (?$(J#/(B . "0x8281") ; <CJK>
       (?$(J#0(B . "0x8FB8") ; <CJK>
       (?$(J#1(B . "0x28670") ; <CJK>
       (?$(J#2(B . "0x48B4") ; <CJK>
       (?$(J#3(B . "0x28675") ; <CJK>
       (?$(J#4(B . "0x28E17") ; <CJK>
       (?$(J#5(B . "0x4E23") ; <CJK>
       (?$(J#6(B . "0x3416") ; <CJK>
       (?$(J#7(B . "0x342C") ; <CJK>
       (?$(J#8(B . "0x201F1") ; <CJK>
       (?$(J#9(B . "0x4F2E") ; <CJK>
       (?$(J#:(B . "0x201DA") ; <CJK>
       (?$(J#;(B . "0x514F") ; <CJK>
       (?$(J#<(B . "0x205B9") ; <CJK>
       (?$(J#=(B . "0x51BA") ; <CJK>
       (?$(J#>(B . "0x34DF") ; <CJK>
       (?$(J#?(B . "0x34E0") ; <CJK>
       (?$(J#@(B . "0x5222") ; <CJK>
       (?$(J#A(B . "0x206CE") ; <CJK>
       (?$(J#B(B . "0x206D2") ; <CJK>
       (?$(J#C(B . "0x206D0") ; <CJK>
       (?$(J#D(B . "0x3517") ; <CJK>
       (?$(J#E(B . "0x20843") ; <CJK>
       (?$(J#F(B . "0x52AF") ; <CJK>
       (?$(J#G(B . "0x52B0") ; <CJK>
       (?$(J#H(B . "0x52B1") ; <CJK>
       (?$(J#I(B . "0x2084D") ; <CJK>
       (?$(J#J(B . "0x20934") ; <CJK>
       (?$(J#K(B . "0x352F") ; <CJK>
       (?$(J#L(B . "0x209D9") ; <CJK>
       (?$(J#M(B . "0x5364") ; <CJK>
       (?$(J#N(B . "0x20A18") ; <CJK>
       (?$(J#O(B . "0x53D3") ; <CJK>
       (?$(J#P(B . "0x20B38") ; <CJK>
       (?$(J#Q(B . "0x356A") ; <CJK>
       (?$(J#R(B . "0x20BD7") ; <CJK>
       (?$(J#S(B . "0x3570") ; <CJK>
       (?$(J#T(B . "0x356D") ; <CJK>
       (?$(J#U(B . "0x20BDC") ; <CJK>
       (?$(J#V(B . "0x20BCB") ; <CJK>
       (?$(J#W(B . "0x20BD6") ; <CJK>
       (?$(J#X(B . "0x20BD8") ; <CJK>
       (?$(J#Y(B . "0x356E") ; <CJK>
       (?$(J#Z(B . "0x20BD1") ; <CJK>
       (?$(J#[(B . "0x2F83E") ; <CJK>
       (?$(J#\(B . "0x2F83C") ; <CJK>
       (?$(J#](B . "0x20BD2") ; <CJK>
       (?$(J#^(B . "0x362B") ; <CJK>
       (?$(J#_(B . "0x3628") ; <CJK>
       (?$(J#`(B . "0x21259") ; <CJK>
       (?$(J#a(B . "0x5759") ; <CJK>
       (?$(J#b(B . "0x593F") ; <CJK>
       (?$(J#c(B . "0x215E5") ; <CJK>
       (?$(J#d(B . "0x215E6") ; <CJK>
       (?$(J#e(B . "0x3692") ; <CJK>
       (?$(J#f(B . "0x215E8") ; <CJK>
       (?$(J#g(B . "0x598B") ; <CJK>
       (?$(J#h(B . "0x216BD") ; <CJK>
       (?$(J#i(B . "0x5991") ; <CJK>
       (?$(J#j(B . "0x5995") ; <CJK>
       (?$(J#k(B . "0x216BE") ; <CJK>
       (?$(J#l(B . "0x21949") ; <CJK>
       (?$(J#m(B . "0x373F") ; <CJK>
       (?$(J#n(B . "0x219CD") ; <CJK>
       (?$(J#o(B . "0x5B8A") ; <CJK>
       (?$(J#p(B . "0x374F") ; <CJK>
       (?$(J#q(B . "0x3774") ; <CJK>
       (?$(J#r(B . "0x21B5E") ; <CJK>
       (?$(J#s(B . "0x21BD0") ; <CJK>
       (?$(J#t(B . "0x377D") ; <CJK>
       (?$(J#u(B . "0x21D06") ; <CJK>
       (?$(J#v(B . "0x37B7") ; <CJK>
       (?$(J#w(B . "0x37A3") ; <CJK>
       (?$(J#x(B . "0x37B0") ; <CJK>
       (?$(J#y(B . "0x37B1") ; <CJK>
       (?$(J#z(B . "0x5C87") ; <CJK>
       (?$(J#{(B . "0x37AB") ; <CJK>
       (?$(J#|(B . "0x21D7C") ; <CJK>
       (?$(J#}(B . "0x21D71") ; <CJK>
       (?$(J#~(B . "0x21FEF") ; <CJK>
       (?$(J$!(B . "0x383A") ; <CJK>
       (?$(J$"(B . "0x3837") ; <CJK>
       (?$(J$#(B . "0x5E0D") ; <CJK>
       (?$(J$$(B . "0x3838") ; <CJK>
       (?$(J$%(B . "0x3840") ; <CJK>
       (?$(J$&(B . "0x2218D") ; <CJK>
       (?$(J$'(B . "0x221B7") ; <CJK>
       (?$(J$((B . "0x5E8E") ; <CJK>
       (?$(J$)(B . "0x389F") ; <CJK>
       (?$(J$*(B . "0x22333") ; <CJK>
       (?$(J$+(B . "0x2237F") ; <CJK>
       (?$(J$,(B . "0x5F7A") ; <CJK>
       (?$(J$-(B . "0x225F2") ; <CJK>
       (?$(J$.(B . "0x3904") ; <CJK>
       (?$(J$/(B . "0x3909") ; <CJK>
       (?$(J$0(B . "0x3906") ; <CJK>
       (?$(J$1(B . "0x38FD") ; <CJK>
       (?$(J$2(B . "0x390A") ; <CJK>
       (?$(J$3(B . "0x3907") ; <CJK>
       (?$(J$4(B . "0x22A2A") ; <CJK>
       (?$(J$5(B . "0x22A8B") ; <CJK>
       (?$(J$6(B . "0x39CA") ; <CJK>
       (?$(J$7(B . "0x22A83") ; <CJK>
       (?$(J$8(B . "0x22A8A") ; <CJK>
       (?$(J$9(B . "0x6290") ; <CJK>
       (?$(J$:(B . "0x39C9") ; <CJK>
       (?$(J$;(B . "0x22A8E") ; <CJK>
       (?$(J$<(B . "0x629A") ; <CJK>
       (?$(J$=(B . "0x22EB6") ; <CJK>
       (?$(J$>(B . "0x653C") ; <CJK>
       (?$(J$?(B . "0x653A") ; <CJK>
       (?$(J$@(B . "0x3A7F") ; <CJK>
       (?$(J$A(B . "0x6598") ; <CJK>
       (?$(J$B(B . "0x230D8") ; <CJK>
       (?$(J$C(B . "0x3AD2") ; <CJK>
       (?$(J$D(B . "0x23156") ; <CJK>
       (?$(J$E(B . "0x233D2") ; <CJK>
       (?$(J$F(B . "0x6765") ; <CJK>
       (?$(J$G(B . "0x2F8DB") ; <CJK>
       (?$(J$H(B . "0x3B43") ; <CJK>
       (?$(J$I(B . "0x233C2") ; <CJK>
       (?$(J$J(B . "0x23887") ; <CJK>
       (?$(J$K(B . "0x23881") ; <CJK>
       (?$(J$L(B . "0x239C2") ; <CJK>
       (?$(J$M(B . "0x239BC") ; <CJK>
       (?$(J$N(B . "0x23B23") ; <CJK>
       (?$(J$O(B . "0x3CC1") ; <CJK>
       (?$(J$P(B . "0x23C93") ; <CJK>
       (?$(J$Q(B . "0x3CC5") ; <CJK>
       (?$(J$R(B . "0x3DA3") ; <CJK>
       (?$(J$S(B . "0x2418D") ; <CJK>
       (?$(J$T(B . "0x2418E") ; <CJK>
       (?$(J$U(B . "0x3E2A") ; <CJK>
       (?$(J$V(B . "0x3E5F") ; <CJK>
       (?$(J$W(B . "0x2473B") ; <CJK>
       (?$(J$X(B . "0x2474D") ; <CJK>
       (?$(J$Y(B . "0x3E5D") ; <CJK>
       (?$(J$Z(B . "0x24734") ; <CJK>
       (?$(J$[(B . "0x24731") ; <CJK>
       (?$(J$\(B . "0x248F2") ; <CJK>
       (?$(J$](B . "0x248F0") ; <CJK>
       (?$(J$^(B . "0x3F17") ; <CJK>
       (?$(J$_(B . "0x24C15") ; <CJK>
       (?$(J$`(B . "0x24D28") ; <CJK>
       (?$(J$a(B . "0x3F71") ; <CJK>
       (?$(J$b(B . "0x3F72") ; <CJK>
       (?$(J$c(B . "0x24F25") ; <CJK>
       (?$(J$d(B . "0x250E7") ; <CJK>
       (?$(J$e(B . "0x400F") ; <CJK>
       (?$(J$f(B . "0x250E9") ; <CJK>
       (?$(J$g(B . "0x25417") ; <CJK>
       (?$(J$h(B . "0x79C2") ; <CJK>
       (?$(J$i(B . "0x4191") ; <CJK>
       (?$(J$j(B . "0x2626C") ; <CJK>
       (?$(J$k(B . "0x26280") ; <CJK>
       (?$(J$l(B . "0x2634B") ; <CJK>
       (?$(J$m(B . "0x43B2") ; <CJK>
       (?$(J$n(B . "0x43CF") ; <CJK>
       (?$(J$o(B . "0x43CE") ; <CJK>
       (?$(J$p(B . "0x809E") ; <CJK>
       (?$(J$q(B . "0x268DE") ; <CJK>
       (?$(J$r(B . "0x268FB") ; <CJK>
       (?$(J$s(B . "0x81EB") ; <CJK>
       (?$(J$t(B . "0x26951") ; <CJK>
       (?$(J$u(B . "0x8289") ; <CJK>
       (?$(J$v(B . "0x4496") ; <CJK>
       (?$(J$w(B . "0x26B01") ; <CJK>
       (?$(J$x(B . "0x26B02") ; <CJK>
       (?$(J$y(B . "0x8296") ; <CJK>
       (?$(J$z(B . "0x26B05") ; <CJK>
       (?$(J${(B . "0x8287") ; <CJK>
       (?$(J$|(B . "0x26B03") ; <CJK>
       (?$(J$}(B . "0x4497") ; <CJK>
       (?$(J$~(B . "0x28451") ; <CJK>
       (?$(J%!(B . "0x8FC0") ; <CJK>
       (?$(J%"(B . "0x488B") ; <CJK>
       (?$(J%#(B . "0x8FC3") ; <CJK>
       (?$(J%$(B . "0x28453") ; <CJK>
       (?$(J%%(B . "0x2867A") ; <CJK>
       (?$(J%&(B . "0x28678") ; <CJK>
       (?$(J%'(B . "0x28676") ; <CJK>
       (?$(J%((B . "0x28679") ; <CJK>
       (?$(J%)(B . "0x2868F") ; <CJK>
       (?$(J%*(B . "0x2867C") ; <CJK>
       (?$(J%+(B . "0x9578") ; <CJK>
       (?$(J%,(B . "0x28E1B") ; <CJK>
       (?$(J%-(B . "0x28E1C") ; <CJK>
       (?$(J%.(B . "0x9625") ; <CJK>
       (?$(J%/(B . "0x23D92") ; <CJK>
       (?$(J%0(B . "0x4E75") ; <CJK>
       (?$(J%1(B . "0x4E74") ; <CJK>
       (?$(J%2(B . "0x2012E") ; <CJK>
       (?$(J%3(B . "0x2012C") ; <CJK>
       (?$(J%4(B . "0x342D") ; <CJK>
       (?$(J%5(B . "0x2020C") ; <CJK>
       (?$(J%6(B . "0x4F99") ; <CJK>
       (?$(J%7(B . "0x2020B") ; <CJK>
       (?$(J%8(B . "0x3450") ; <CJK>
       (?$(J%9(B . "0x344B") ; <CJK>
       (?$(J%:(B . "0x20205") ; <CJK>
       (?$(J%;(B . "0x344F") ; <CJK>
       (?$(J%<(B . "0x344C") ; <CJK>
       (?$(J%=(B . "0x2F805") ; <CJK>
       (?$(J%>(B . "0x4F71") ; <CJK>
       (?$(J%?(B . "0x5153") ; <CJK>
       (?$(J%@(B . "0x51BF") ; <CJK>
       (?$(J%A(B . "0x205C2") ; <CJK>
       (?$(J%B(B . "0x205C3") ; <CJK>
       (?$(J%C(B . "0x51C0") ; <CJK>
       (?$(J%D(B . "0x20648") ; <CJK>
       (?$(J%E(B . "0x51EE") ; <CJK>
       (?$(J%F(B . "0x20646") ; <CJK>
       (?$(J%G(B . "0x34E4") ; <CJK>
       (?$(J%H(B . "0x34E3") ; <CJK>
       (?$(J%I(B . "0x206EA") ; <CJK>
       (?$(J%J(B . "0x34E1") ; <CJK>
       (?$(J%K(B . "0x206EB") ; <CJK>
       (?$(J%L(B . "0x34E2") ; <CJK>
       (?$(J%M(B . "0x206EE") ; <CJK>
       (?$(J%N(B . "0x523D") ; <CJK>
       (?$(J%O(B . "0x3519") ; <CJK>
       (?$(J%P(B . "0x52BD") ; <CJK>
       (?$(J%Q(B . "0x530C") ; <CJK>
       (?$(J%R(B . "0x208D8") ; <CJK>
       (?$(J%S(B . "0x24C1E") ; <CJK>
       (?$(J%T(B . "0x209DF") ; <CJK>
       (?$(J%U(B . "0x209DE") ; <CJK>
       (?$(J%V(B . "0x3541") ; <CJK>
       (?$(J%W(B . "0x7F37") ; <CJK>
       (?$(J%X(B . "0x20A4F") ; <CJK>
       (?$(J%Y(B . "0x53C0") ; <CJK>
       (?$(J%Z(B . "0x355E") ; <CJK>
       (?$(J%[(B . "0x20C0D") ; <CJK>
       (?$(J%\(B . "0x20C08") ; <CJK>
       (?$(J%](B . "0x3579") ; <CJK>
       (?$(J%^(B . "0x20C09") ; <CJK>
       (?$(J%_(B . "0x546E") ; <CJK>
       (?$(J%`(B . "0x5483") ; <CJK>
       (?$(J%a(B . "0x20C12") ; <CJK>
       (?$(J%b(B . "0x20C65") ; <CJK>
       (?$(J%c(B . "0x545E") ; <CJK>
       (?$(J%d(B . "0x545D") ; <CJK>
       (?$(J%e(B . "0x577E") ; <CJK>
       (?$(J%f(B . "0x5779") ; <CJK>
       (?$(J%g(B . "0x21289") ; <CJK>
       (?$(J%h(B . "0x577A") ; <CJK>
       (?$(J%i(B . "0x576C") ; <CJK>
       (?$(J%j(B . "0x21284") ; <CJK>
       (?$(J%k(B . "0x2129E") ; <CJK>
       (?$(J%l(B . "0x2128B") ; <CJK>
       (?$(J%m(B . "0x3632") ; <CJK>
       (?$(J%n(B . "0x5787") ; <CJK>
       (?$(J%o(B . "0x21562") ; <CJK>
       (?$(J%p(B . "0x591D") ; <CJK>
       (?$(J%q(B . "0x3694") ; <CJK>
       (?$(J%r(B . "0x5946") ; <CJK>
       (?$(J%s(B . "0x3697") ; <CJK>
       (?$(J%t(B . "0x215F9") ; <CJK>
       (?$(J%u(B . "0x5943") ; <CJK>
       (?$(J%v(B . "0x215F7") ; <CJK>
       (?$(J%w(B . "0x3696") ; <CJK>
       (?$(J%x(B . "0x3698") ; <CJK>
       (?$(J%y(B . "0x21606") ; <CJK>
       (?$(J%z(B . "0x216DD") ; <CJK>
       (?$(J%{(B . "0x36B2") ; <CJK>
       (?$(J%|(B . "0x216D9") ; <CJK>
       (?$(J%}(B . "0x216DF") ; <CJK>
       (?$(J%~(B . "0x216E2") ; <CJK>
       (?$(J&!(B . "0x36B9") ; <CJK>
       (?$(J&"(B . "0x5B61") ; <CJK>
       (?$(J&#(B . "0x5B66") ; <CJK>
       (?$(J&$(B . "0x200F1") ; <CJK>
       (?$(J&%(B . "0x5B90") ; <CJK>
       (?$(J&&(B . "0x3775") ; <CJK>
       (?$(J&'(B . "0x377F") ; <CJK>
       (?$(J&((B . "0x377E") ; <CJK>
       (?$(J&)(B . "0x5C29") ; <CJK>
       (?$(J&*(B . "0x378F") ; <CJK>
       (?$(J&+(B . "0x21C3F") ; <CJK>
       (?$(J&,(B . "0x21C3E") ; <CJK>
       (?$(J&-(B . "0x21D0B") ; <CJK>
       (?$(J&.(B . "0x37BD") ; <CJK>
       (?$(J&/(B . "0x5CB2") ; <CJK>
       (?$(J&0(B . "0x21D83") ; <CJK>
       (?$(J&1(B . "0x37BB") ; <CJK>
       (?$(J&2(B . "0x37BC") ; <CJK>
       (?$(J&3(B . "0x21D86") ; <CJK>
       (?$(J&4(B . "0x5CC0") ; <CJK>
       (?$(J&5(B . "0x2207C") ; <CJK>
       (?$(J&6(B . "0x383D") ; <CJK>
       (?$(J&7(B . "0x383E") ; <CJK>
       (?$(J&8(B . "0x3874") ; <CJK>
       (?$(J&9(B . "0x221F7") ; <CJK>
       (?$(J&:(B . "0x387A") ; <CJK>
       (?$(J&;(B . "0x3876") ; <CJK>
       (?$(J&<(B . "0x3878") ; <CJK>
       (?$(J&=(B . "0x3875") ; <CJK>
       (?$(J&>(B . "0x221FB") ; <CJK>
       (?$(J&?(B . "0x2233B") ; <CJK>
       (?$(J&@(B . "0x38AF") ; <CJK>
       (?$(J&A(B . "0x38B0") ; <CJK>
       (?$(J&B(B . "0x38C7") ; <CJK>
       (?$(J&C(B . "0x38CC") ; <CJK>
       (?$(J&D(B . "0x225F9") ; <CJK>
       (?$(J&E(B . "0x225CA") ; <CJK>
       (?$(J&F(B . "0x3916") ; <CJK>
       (?$(J&G(B . "0x225FF") ; <CJK>
       (?$(J&H(B . "0x3912") ; <CJK>
       (?$(J&I(B . "0x391D") ; <CJK>
       (?$(J&J(B . "0x22609") ; <CJK>
       (?$(J&K(B . "0x22603") ; <CJK>
       (?$(J&L(B . "0x3915") ; <CJK>
       (?$(J&M(B . "0x390F") ; <CJK>
       (?$(J&N(B . "0x3914") ; <CJK>
       (?$(J&O(B . "0x601F") ; <CJK>
       (?$(J&P(B . "0x5FE2") ; <CJK>
       (?$(J&Q(B . "0x22610") ; <CJK>
       (?$(J&R(B . "0x2299A") ; <CJK>
       (?$(J&S(B . "0x2299F") ; <CJK>
       (?$(J&T(B . "0x39B0") ; <CJK>
       (?$(J&U(B . "0x39BF") ; <CJK>
       (?$(J&V(B . "0x39C0") ; <CJK>
       (?$(J&W(B . "0x22A87") ; <CJK>
       (?$(J&X(B . "0x39D2") ; <CJK>
       (?$(J&Y(B . "0x39D9") ; <CJK>
       (?$(J&Z(B . "0x22EB7") ; <CJK>
       (?$(J&[(B . "0x3A7A") ; <CJK>
       (?$(J&\(B . "0x22F08") ; <CJK>
       (?$(J&](B . "0x22EF9") ; <CJK>
       (?$(J&^(B . "0x3A81") ; <CJK>
       (?$(J&_(B . "0x3A82") ; <CJK>
       (?$(J&`(B . "0x22EF4") ; <CJK>
       (?$(J&a(B . "0x6616") ; <CJK>
       (?$(J&b(B . "0x65F9") ; <CJK>
       (?$(J&c(B . "0x3ADA") ; <CJK>
       (?$(J&d(B . "0x26657") ; <CJK>
       (?$(J&e(B . "0x6788") ; <CJK>
       (?$(J&f(B . "0x233D6") ; <CJK>
       (?$(J&g(B . "0x679B") ; <CJK>
       (?$(J&h(B . "0x2F8DE") ; <CJK>
       (?$(J&i(B . "0x676E") ; <CJK>
       (?$(J&j(B . "0x679E") ; <CJK>
       (?$(J&k(B . "0x233D4") ; <CJK>
       (?$(J&l(B . "0x3C22") ; <CJK>
       (?$(J&m(B . "0x3C1F") ; <CJK>
       (?$(J&n(B . "0x23890") ; <CJK>
       (?$(J&o(B . "0x2388D") ; <CJK>
       (?$(J&p(B . "0x3C21") ; <CJK>
       (?$(J&q(B . "0x6B24") ; <CJK>
       (?$(J&r(B . "0x23960") ; <CJK>
       (?$(J&s(B . "0x239CE") ; <CJK>
       (?$(J&t(B . "0x239CF") ; <CJK>
       (?$(J&u(B . "0x3C5C") ; <CJK>
       (?$(J&v(B . "0x6B7D") ; <CJK>
       (?$(J&w(B . "0x239D1") ; <CJK>
       (?$(J&x(B . "0x3C7D") ; <CJK>
       (?$(J&y(B . "0x3C8D") ; <CJK>
       (?$(J&z(B . "0x3C8F") ; <CJK>
       (?$(J&{(B . "0x6CE6") ; <CJK>
       (?$(J&|(B . "0x23CCA") ; <CJK>
       (?$(J&}(B . "0x6CCB") ; <CJK>
       (?$(J&~(B . "0x3CD0") ; <CJK>
       (?$(J'!(B . "0x23CB7") ; <CJK>
       (?$(J'"(B . "0x3CD8") ; <CJK>
       (?$(J'#(B . "0x23CB2") ; <CJK>
       (?$(J'$(B . "0x23CBB") ; <CJK>
       (?$(J'%(B . "0x23CB9") ; <CJK>
       (?$(J'&(B . "0x6CB5") ; <CJK>
       (?$(J''(B . "0x3DA7") ; <CJK>
       (?$(J'((B . "0x2419E") ; <CJK>
       (?$(J')(B . "0x7097") ; <CJK>
       (?$(J'*(B . "0x241B2") ; <CJK>
       (?$(J'+(B . "0x709B") ; <CJK>
       (?$(J',(B . "0x3E12") ; <CJK>
       (?$(J'-(B . "0x2456F") ; <CJK>
       (?$(J'.(B . "0x245AC") ; <CJK>
       (?$(J'/(B . "0x3E2F") ; <CJK>
       (?$(J'0(B . "0x24623") ; <CJK>
       (?$(J'1(B . "0x726B") ; <CJK>
       (?$(J'2(B . "0x3E2E") ; <CJK>
       (?$(J'3(B . "0x3E2C") ; <CJK>
       (?$(J'4(B . "0x3E5C") ; <CJK>
       (?$(J'5(B . "0x2476C") ; <CJK>
       (?$(J'6(B . "0x72D5") ; <CJK>
       (?$(J'7(B . "0x24732") ; <CJK>
       (?$(J'8(B . "0x2475E") ; <CJK>
       (?$(J'9(B . "0x3E62") ; <CJK>
       (?$(J':(B . "0x3E67") ; <CJK>
       (?$(J';(B . "0x3EB4") ; <CJK>
       (?$(J'<(B . "0x248FB") ; <CJK>
       (?$(J'=(B . "0x24B29") ; <CJK>
       (?$(J'>(B . "0x24BBD") ; <CJK>
       (?$(J'?(B . "0x24C1F") ; <CJK>
       (?$(J'@(B . "0x7543") ; <CJK>
       (?$(J'A(B . "0x22341") ; <CJK>
       (?$(J'B(B . "0x24C1D") ; <CJK>
       (?$(J'C(B . "0x759C") ; <CJK>
       (?$(J'D(B . "0x24D31") ; <CJK>
       (?$(J'E(B . "0x24D2F") ; <CJK>
       (?$(J'F(B . "0x3FEA") ; <CJK>
       (?$(J'G(B . "0x25043") ; <CJK>
       (?$(J'H(B . "0x3FFB") ; <CJK>
       (?$(J'I(B . "0x25041") ; <CJK>
       (?$(J'J(B . "0x4014") ; <CJK>
       (?$(J'K(B . "0x250F5") ; <CJK>
       (?$(J'L(B . "0x4013") ; <CJK>
       (?$(J'M(B . "0x4012") ; <CJK>
       (?$(J'N(B . "0x4010") ; <CJK>
       (?$(J'O(B . "0x4011") ; <CJK>
       (?$(J'P(B . "0x250F2") ; <CJK>
       (?$(J'Q(B . "0x4086") ; <CJK>
       (?$(J'R(B . "0x77E4") ; <CJK>
       (?$(J'S(B . "0x4098") ; <CJK>
       (?$(J'T(B . "0x2541E") ; <CJK>
       (?$(J'U(B . "0x25754") ; <CJK>
       (?$(J'V(B . "0x412A") ; <CJK>
       (?$(J'W(B . "0x25756") ; <CJK>
       (?$(J'X(B . "0x25929") ; <CJK>
       (?$(J'Y(B . "0x25927") ; <CJK>
       (?$(J'Z(B . "0x25928") ; <CJK>
       (?$(J'[(B . "0x7ACE") ; <CJK>
       (?$(J'\(B . "0x42B5") ; <CJK>
       (?$(J'](B . "0x26279") ; <CJK>
       (?$(J'^(B . "0x2627E") ; <CJK>
       (?$(J'_(B . "0x264B6") ; <CJK>
       (?$(J'`(B . "0x264B7") ; <CJK>
       (?$(J'a(B . "0x8013") ; <CJK>
       (?$(J'b(B . "0x43D6") ; <CJK>
       (?$(J'c(B . "0x43D8") ; <CJK>
       (?$(J'd(B . "0x80B7") ; <CJK>
       (?$(J'e(B . "0x43D9") ; <CJK>
       (?$(J'f(B . "0x43D4") ; <CJK>
       (?$(J'g(B . "0x43D7") ; <CJK>
       (?$(J'h(B . "0x2F981") ; <CJK>
       (?$(J'i(B . "0x80B9") ; <CJK>
       (?$(J'j(B . "0x80BB") ; <CJK>
       (?$(J'k(B . "0x2664D") ; <CJK>
       (?$(J'l(B . "0x81E4") ; <CJK>
       (?$(J'm(B . "0x81FD") ; <CJK>
       (?$(J'n(B . "0x820F") ; <CJK>
       (?$(J'o(B . "0x4460") ; <CJK>
       (?$(J'p(B . "0x26A09") ; <CJK>
       (?$(J'q(B . "0x26A08") ; <CJK>
       (?$(J'r(B . "0x449E") ; <CJK>
       (?$(J's(B . "0x44A1") ; <CJK>
       (?$(J't(B . "0x26B1E") ; <CJK>
       (?$(J'u(B . "0x26B1A") ; <CJK>
       (?$(J'v(B . "0x26B23") ; <CJK>
       (?$(J'w(B . "0x26B15") ; <CJK>
       (?$(J'x(B . "0x26B19") ; <CJK>
       (?$(J'y(B . "0x26B16") ; <CJK>
       (?$(J'z(B . "0x82BF") ; <CJK>
       (?$(J'{(B . "0x82CA") ; <CJK>
       (?$(J'|(B . "0x26B14") ; <CJK>
       (?$(J'}(B . "0x26B18") ; <CJK>
       (?$(J'~(B . "0x82C1") ; <CJK>
       (?$(J(!(B . "0x44A0") ; <CJK>
       (?$(J("(B . "0x2721F") ; <CJK>
       (?$(J(#(B . "0x275DD") ; <CJK>
       (?$(J($(B . "0x275DF") ; <CJK>
       (?$(J(%(B . "0x28469") ; <CJK>
       (?$(J(&(B . "0x8FD0") ; <CJK>
       (?$(J('(B . "0x488C") ; <CJK>
       (?$(J(((B . "0x2846C") ; <CJK>
       (?$(J()(B . "0x48B9") ; <CJK>
       (?$(J(*(B . "0x28693") ; <CJK>
       (?$(J(+(B . "0x90AE") ; <CJK>
       (?$(J(,(B . "0x28695") ; <CJK>
       (?$(J(-(B . "0x28694") ; <CJK>
       (?$(J(.(B . "0x28691") ; <CJK>
       (?$(J(/(B . "0x28697") ; <CJK>
       (?$(J(0(B . "0x28E30") ; <CJK>
       (?$(J(1(B . "0x49C1") ; <CJK>
       (?$(J(2(B . "0x49C2") ; <CJK>
       (?$(J(3(B . "0x9638") ; <CJK>
       (?$(J(4(B . "0x2FA18") ; <CJK>
       (?$(J(5(B . "0x341C") ; <CJK>
       (?$(J(6(B . "0x20231") ; <CJK>
       (?$(J(7(B . "0x345E") ; <CJK>
       (?$(J(8(B . "0x4FBC") ; <CJK>
       (?$(J(9(B . "0x3459") ; <CJK>
       (?$(J(:(B . "0x345C") ; <CJK>
       (?$(J(;(B . "0x20236") ; <CJK>
       (?$(J(<(B . "0x345F") ; <CJK>
       (?$(J(=(B . "0x4FE9") ; <CJK>
       (?$(J(>(B . "0x4FBD") ; <CJK>
       (?$(J(?(B . "0x4FE2") ; <CJK>
       (?$(J(@(B . "0x5158") ; <CJK>
       (?$(J(A(B . "0x205C9") ; <CJK>
       (?$(J(B(B . "0x205CA") ; <CJK>
       (?$(J(C(B . "0x34CE") ; <CJK>
       (?$(J(D(B . "0x20718") ; <CJK>
       (?$(J(E(B . "0x20712") ; <CJK>
       (?$(J(F(B . "0x20719") ; <CJK>
       (?$(J(G(B . "0x20710") ; <CJK>
       (?$(J(H(B . "0x20716") ; <CJK>
       (?$(J(I(B . "0x52C6") ; <CJK>
       (?$(J(J(B . "0x2085F") ; <CJK>
       (?$(J(K(B . "0x52C8") ; <CJK>
       (?$(J(L(B . "0x208DF") ; <CJK>
       (?$(J(M(B . "0x20917") ; <CJK>
       (?$(J(N(B . "0x5328") ; <CJK>
       (?$(J(O(B . "0x2093C") ; <CJK>
       (?$(J(P(B . "0x5329") ; <CJK>
       (?$(J(Q(B . "0x209EA") ; <CJK>
       (?$(J(R(B . "0x209E9") ; <CJK>
       (?$(J(S(B . "0x20A1C") ; <CJK>
       (?$(J(T(B . "0x20A58") ; <CJK>
       (?$(J(U(B . "0x20A64") ; <CJK>
       (?$(J(V(B . "0x20AF3") ; <CJK>
       (?$(J(W(B . "0x355F") ; <CJK>
       (?$(J(X(B . "0x20C97") ; <CJK>
       (?$(J(Y(B . "0x3585") ; <CJK>
       (?$(J(Z(B . "0x20C5A") ; <CJK>
       (?$(J([(B . "0x20C59") ; <CJK>
       (?$(J(\(B . "0x3586") ; <CJK>
       (?$(J(](B . "0x20C8E") ; <CJK>
       (?$(J(^(B . "0x57B4") ; <CJK>
       (?$(J(_(B . "0x212BC") ; <CJK>
       (?$(J(`(B . "0x57A9") ; <CJK>
       (?$(J(a(B . "0x3687") ; <CJK>
       (?$(J(b(B . "0x2160D") ; <CJK>
       (?$(J(c(B . "0x215FC") ; <CJK>
       (?$(J(d(B . "0x2160C") ; <CJK>
       (?$(J(e(B . "0x21707") ; <CJK>
       (?$(J(f(B . "0x2170A") ; <CJK>
       (?$(J(g(B . "0x36CA") ; <CJK>
       (?$(J(h(B . "0x21702") ; <CJK>
       (?$(J(i(B . "0x36C3") ; <CJK>
       (?$(J(j(B . "0x21726") ; <CJK>
       (?$(J(k(B . "0x21708") ; <CJK>
       (?$(J(l(B . "0x2171D") ; <CJK>
       (?$(J(m(B . "0x36C2") ; <CJK>
       (?$(J(n(B . "0x5B68") ; <CJK>
       (?$(J(o(B . "0x2194E") ; <CJK>
       (?$(J(p(B . "0x3741") ; <CJK>
       (?$(J(q(B . "0x219ED") ; <CJK>
       (?$(J(r(B . "0x219EE") ; <CJK>
       (?$(J(s(B . "0x219EF") ; <CJK>
       (?$(J(t(B . "0x3780") ; <CJK>
       (?$(J(u(B . "0x3781") ; <CJK>
       (?$(J(v(B . "0x21C50") ; <CJK>
       (?$(J(w(B . "0x21C4C") ; <CJK>
       (?$(J(x(B . "0x3793") ; <CJK>
       (?$(J(y(B . "0x3792") ; <CJK>
       (?$(J(z(B . "0x21C4F") ; <CJK>
       (?$(J({(B . "0x37C5") ; <CJK>
       (?$(J(|(B . "0x21DD4") ; <CJK>
       (?$(J(}(B . "0x5CD5") ; <CJK>
       (?$(J(~(B . "0x21DB0") ; <CJK>
       (?$(J)!(B . "0x3846") ; <CJK>
       (?$(J)"(B . "0x3841") ; <CJK>
       (?$(J)#(B . "0x3845") ; <CJK>
       (?$(J)$(B . "0x3842") ; <CJK>
       (?$(J)%(B . "0x383F") ; <CJK>
       (?$(J)&(B . "0x220A5") ; <CJK>
       (?$(J)'(B . "0x22209") ; <CJK>
       (?$(J)((B . "0x3882") ; <CJK>
       (?$(J))(B . "0x3881") ; <CJK>
       (?$(J)*(B . "0x387F") ; <CJK>
       (?$(J)+(B . "0x38A5") ; <CJK>
       (?$(J),(B . "0x5F2B") ; <CJK>
       (?$(J)-(B . "0x38B3") ; <CJK>
       (?$(J).(B . "0x38B5") ; <CJK>
       (?$(J)/(B . "0x223F3") ; <CJK>
       (?$(J)0(B . "0x223D7") ; <CJK>
       (?$(J)1(B . "0x5F8D") ; <CJK>
       (?$(J)2(B . "0x38DA") ; <CJK>
       (?$(J)3(B . "0x224DC") ; <CJK>
       (?$(J)4(B . "0x38DB") ; <CJK>
       (?$(J)5(B . "0x390D") ; <CJK>
       (?$(J)6(B . "0x6018") ; <CJK>
       (?$(J)7(B . "0x390E") ; <CJK>
       (?$(J)8(B . "0x2260B") ; <CJK>
       (?$(J)9(B . "0x391E") ; <CJK>
       (?$(J):(B . "0x3925") ; <CJK>
       (?$(J);(B . "0x3926") ; <CJK>
       (?$(J)<(B . "0x391C") ; <CJK>
       (?$(J)=(B . "0x3921") ; <CJK>
       (?$(J)>(B . "0x6057") ; <CJK>
       (?$(J)?(B . "0x6048") ; <CJK>
       (?$(J)@(B . "0x3927") ; <CJK>
       (?$(J)A(B . "0x391A") ; <CJK>
       (?$(J)B(B . "0x2263A") ; <CJK>
       (?$(J)C(B . "0x2260D") ; <CJK>
       (?$(J)D(B . "0x22611") ; <CJK>
       (?$(J)E(B . "0x6038") ; <CJK>
       (?$(J)F(B . "0x22620") ; <CJK>
       (?$(J)G(B . "0x22601") ; <CJK>
       (?$(J)H(B . "0x3924") ; <CJK>
       (?$(J)I(B . "0x22637") ; <CJK>
       (?$(J)J(B . "0x2F8A3") ; <CJK>
       (?$(J)K(B . "0x6071") ; <CJK>
       (?$(J)L(B . "0x229AA") ; <CJK>
       (?$(J)M(B . "0x39C1") ; <CJK>
       (?$(J)N(B . "0x39E1") ; <CJK>
       (?$(J)O(B . "0x22AE7") ; <CJK>
       (?$(J)P(B . "0x22AE8") ; <CJK>
       (?$(J)Q(B . "0x6312") ; <CJK>
       (?$(J)R(B . "0x39EB") ; <CJK>
       (?$(J)S(B . "0x22AF5") ; <CJK>
       (?$(J)T(B . "0x39E2") ; <CJK>
       (?$(J)U(B . "0x39D7") ; <CJK>
       (?$(J)V(B . "0x39E9") ; <CJK>
       (?$(J)W(B . "0x22B35") ; <CJK>
       (?$(J)X(B . "0x22AE6") ; <CJK>
       (?$(J)Y(B . "0x630A") ; <CJK>
       (?$(J)Z(B . "0x22AF8") ; <CJK>
       (?$(J)[(B . "0x6323") ; <CJK>
       (?$(J)\(B . "0x22AF1") ; <CJK>
       (?$(J)](B . "0x3A84") ; <CJK>
       (?$(J)^(B . "0x22F14") ; <CJK>
       (?$(J)_(B . "0x22F15") ; <CJK>
       (?$(J)`(B . "0x22F09") ; <CJK>
       (?$(J)a(B . "0x3AB5") ; <CJK>
       (?$(J)b(B . "0x3ABC") ; <CJK>
       (?$(J)c(B . "0x3ADC") ; <CJK>
       (?$(J)d(B . "0x3ADE") ; <CJK>
       (?$(J)e(B . "0x3ADF") ; <CJK>
       (?$(J)f(B . "0x2317B") ; <CJK>
       (?$(J)g(B . "0x662A") ; <CJK>
       (?$(J)h(B . "0x2317E") ; <CJK>
       (?$(J)i(B . "0x23366") ; <CJK>
       (?$(J)j(B . "0x23367") ; <CJK>
       (?$(J)k(B . "0x2340A") ; <CJK>
       (?$(J)l(B . "0x3B54") ; <CJK>
       (?$(J)m(B . "0x67E0") ; <CJK>
       (?$(J)n(B . "0x67BE") ; <CJK>
       (?$(J)o(B . "0x3B53") ; <CJK>
       (?$(J)p(B . "0x3C24") ; <CJK>
       (?$(J)q(B . "0x3C25") ; <CJK>
       (?$(J)r(B . "0x6B29") ; <CJK>
       (?$(J)s(B . "0x3C28") ; <CJK>
       (?$(J)t(B . "0x3C27") ; <CJK>
       (?$(J)u(B . "0x2389C") ; <CJK>
       (?$(J)v(B . "0x23962") ; <CJK>
       (?$(J)w(B . "0x239E1") ; <CJK>
       (?$(J)x(B . "0x239DE") ; <CJK>
       (?$(J)y(B . "0x239DF") ; <CJK>
       (?$(J)z(B . "0x239E9") ; <CJK>
       (?$(J){(B . "0x3C8B") ; <CJK>
       (?$(J)|(B . "0x23CE4") ; <CJK>
       (?$(J)}(B . "0x23CF7") ; <CJK>
       (?$(J)~(B . "0x3CDC") ; <CJK>
       (?$(J*!(B . "0x6D43") ; <CJK>
       (?$(J*"(B . "0x23CEA") ; <CJK>
       (?$(J*#(B . "0x23CF6") ; <CJK>
       (?$(J*$(B . "0x23D12") ; <CJK>
       (?$(J*%(B . "0x2F901") ; <CJK>
       (?$(J*&(B . "0x70A6") ; <CJK>
       (?$(J*'(B . "0x3DB2") ; <CJK>
       (?$(J*((B . "0x70C0") ; <CJK>
       (?$(J*)(B . "0x241D9") ; <CJK>
       (?$(J**(B . "0x722F") ; <CJK>
       (?$(J*+(B . "0x2455F") ; <CJK>
       (?$(J*,(B . "0x3E1B") ; <CJK>
       (?$(J*-(B . "0x24573") ; <CJK>
       (?$(J*.(B . "0x3E32") ; <CJK>
       (?$(J*/(B . "0x7271") ; <CJK>
       (?$(J*0(B . "0x2463F") ; <CJK>
       (?$(J*1(B . "0x24778") ; <CJK>
       (?$(J*2(B . "0x3E6B") ; <CJK>
       (?$(J*3(B . "0x2477D") ; <CJK>
       (?$(J*4(B . "0x3E6C") ; <CJK>
       (?$(J*5(B . "0x3E6D") ; <CJK>
       (?$(J*6(B . "0x24912") ; <CJK>
       (?$(J*7(B . "0x3EB9") ; <CJK>
       (?$(J*8(B . "0x3EBA") ; <CJK>
       (?$(J*9(B . "0x3F09") ; <CJK>
       (?$(J*:(B . "0x3F0A") ; <CJK>
       (?$(J*;(B . "0x24B2F") ; <CJK>
       (?$(J*<(B . "0x74EA") ; <CJK>
       (?$(J*=(B . "0x3F1B") ; <CJK>
       (?$(J*>(B . "0x24B30") ; <CJK>
       (?$(J*?(B . "0x24BDB") ; <CJK>
       (?$(J*@(B . "0x7520") ; <CJK>
       (?$(J*A(B . "0x3F58") ; <CJK>
       (?$(J*B(B . "0x24C29") ; <CJK>
       (?$(J*C(B . "0x3F5A") ; <CJK>
       (?$(J*D(B . "0x2F936") ; <CJK>
       (?$(J*E(B . "0x24D40") ; <CJK>
       (?$(J*F(B . "0x3F77") ; <CJK>
       (?$(J*G(B . "0x24D3D") ; <CJK>
       (?$(J*H(B . "0x24D3E") ; <CJK>
       (?$(J*I(B . "0x3F79") ; <CJK>
       (?$(J*J(B . "0x75A9") ; <CJK>
       (?$(J*K(B . "0x24D38") ; <CJK>
       (?$(J*L(B . "0x7685") ; <CJK>
       (?$(J*M(B . "0x24F48") ; <CJK>
       (?$(J*N(B . "0x3FEB") ; <CJK>
       (?$(J*O(B . "0x24FD0") ; <CJK>
       (?$(J*P(B . "0x3FFD") ; <CJK>
       (?$(J*Q(B . "0x3FFC") ; <CJK>
       (?$(J*R(B . "0x7706") ; <CJK>
       (?$(J*S(B . "0x4015") ; <CJK>
       (?$(J*T(B . "0x4018") ; <CJK>
       (?$(J*U(B . "0x76F6") ; <CJK>
       (?$(J*V(B . "0x4016") ; <CJK>
       (?$(J*W(B . "0x4017") ; <CJK>
       (?$(J*X(B . "0x4019") ; <CJK>
       (?$(J*Y(B . "0x7700") ; <CJK>
       (?$(J*Z(B . "0x401B") ; <CJK>
       (?$(J*[(B . "0x2510E") ; <CJK>
       (?$(J*\(B . "0x25109") ; <CJK>
       (?$(J*](B . "0x7702") ; <CJK>
       (?$(J*^(B . "0x25107") ; <CJK>
       (?$(J*_(B . "0x4087") ; <CJK>
       (?$(J*`(B . "0x2535F") ; <CJK>
       (?$(J*a(B . "0x25360") ; <CJK>
       (?$(J*b(B . "0x409C") ; <CJK>
       (?$(J*c(B . "0x2542A") ; <CJK>
       (?$(J*d(B . "0x409A") ; <CJK>
       (?$(J*e(B . "0x25429") ; <CJK>
       (?$(J*f(B . "0x40FF") ; <CJK>
       (?$(J*g(B . "0x40FE") ; <CJK>
       (?$(J*h(B . "0x2564D") ; <CJK>
       (?$(J*i(B . "0x4131") ; <CJK>
       (?$(J*j(B . "0x412E") ; <CJK>
       (?$(J*k(B . "0x4130") ; <CJK>
       (?$(J*l(B . "0x4132") ; <CJK>
       (?$(J*m(B . "0x2576C") ; <CJK>
       (?$(J*n(B . "0x79CC") ; <CJK>
       (?$(J*o(B . "0x412F") ; <CJK>
       (?$(J*p(B . "0x25767") ; <CJK>
       (?$(J*q(B . "0x4195") ; <CJK>
       (?$(J*r(B . "0x4196") ; <CJK>
       (?$(J*s(B . "0x25939") ; <CJK>
       (?$(J*t(B . "0x25934") ; <CJK>
       (?$(J*u(B . "0x25A59") ; <CJK>
       (?$(J*v(B . "0x41C5") ; <CJK>
       (?$(J*w(B . "0x427A") ; <CJK>
       (?$(J*x(B . "0x26223") ; <CJK>
       (?$(J*y(B . "0x4342") ; <CJK>
       (?$(J*z(B . "0x26282") ; <CJK>
       (?$(J*{(B . "0x4354") ; <CJK>
       (?$(J*|(B . "0x26283") ; <CJK>
       (?$(J*}(B . "0x262A8") ; <CJK>
       (?$(J*~(B . "0x26355") ; <CJK>
       (?$(J+!(B . "0x263F9") ; <CJK>
       (?$(J+"(B . "0x263F8") ; <CJK>
       (?$(J+#(B . "0x263FC") ; <CJK>
       (?$(J+$(B . "0x263FA") ; <CJK>
       (?$(J+%(B . "0x8009") ; <CJK>
       (?$(J+&(B . "0x2F97A") ; <CJK>
       (?$(J+'(B . "0x439F") ; <CJK>
       (?$(J+((B . "0x43A0") ; <CJK>
       (?$(J+)(B . "0x43A2") ; <CJK>
       (?$(J+*(B . "0x43E0") ; <CJK>
       (?$(J++(B . "0x26674") ; <CJK>
       (?$(J+,(B . "0x43E1") ; <CJK>
       (?$(J+-(B . "0x2666B") ; <CJK>
       (?$(J+.(B . "0x26671") ; <CJK>
       (?$(J+/(B . "0x43DF") ; <CJK>
       (?$(J+0(B . "0x26676") ; <CJK>
       (?$(J+1(B . "0x26A0E") ; <CJK>
       (?$(J+2(B . "0x4462") ; <CJK>
       (?$(J+3(B . "0x4461") ; <CJK>
       (?$(J+4(B . "0x26A10") ; <CJK>
       (?$(J+5(B . "0x26A0F") ; <CJK>
       (?$(J+6(B . "0x44A7") ; <CJK>
       (?$(J+7(B . "0x26B38") ; <CJK>
       (?$(J+8(B . "0x26B39") ; <CJK>
       (?$(J+9(B . "0x26B3A") ; <CJK>
       (?$(J+:(B . "0x82DA") ; <CJK>
       (?$(J+;(B . "0x26B37") ; <CJK>
       (?$(J+<(B . "0x26B3E") ; <CJK>
       (?$(J+=(B . "0x830A") ; <CJK>
       (?$(J+>(B . "0x4589") ; <CJK>
       (?$(J+?(B . "0x2719C") ; <CJK>
       (?$(J+@(B . "0x2722A") ; <CJK>
       (?$(J+A(B . "0x2723A") ; <CJK>
       (?$(J+B(B . "0x2722B") ; <CJK>
       (?$(J+C(B . "0x27228") ; <CJK>
       (?$(J+D(B . "0x275AA") ; <CJK>
       (?$(J+E(B . "0x2760F") ; <CJK>
       (?$(J+F(B . "0x461D") ; <CJK>
       (?$(J+G(B . "0x27610") ; <CJK>
       (?$(J+H(B . "0x277E6") ; <CJK>
       (?$(J+I(B . "0x472A") ; <CJK>
       (?$(J+J(B . "0x27D25") ; <CJK>
       (?$(J+K(B . "0x27E8E") ; <CJK>
       (?$(J+L(B . "0x47D3") ; <CJK>
       (?$(J+M(B . "0x4842") ; <CJK>
       (?$(J+N(B . "0x4843") ; <CJK>
       (?$(J+O(B . "0x2848B") ; <CJK>
       (?$(J+P(B . "0x4891") ; <CJK>
       (?$(J+Q(B . "0x2848C") ; <CJK>
       (?$(J+R(B . "0x2849A") ; <CJK>
       (?$(J+S(B . "0x4890") ; <CJK>
       (?$(J+T(B . "0x48BF") ; <CJK>
       (?$(J+U(B . "0x286B3") ; <CJK>
       (?$(J+V(B . "0x48BC") ; <CJK>
       (?$(J+W(B . "0x286B2") ; <CJK>
       (?$(J+X(B . "0x48C0") ; <CJK>
       (?$(J+Y(B . "0x49C7") ; <CJK>
       (?$(J+Z(B . "0x49C5") ; <CJK>
       (?$(J+[(B . "0x9655") ; <CJK>
       (?$(J+\(B . "0x28E44") ; <CJK>
       (?$(J+](B . "0x9652") ; <CJK>
       (?$(J+^(B . "0x4E35") ; <CJK>
       (?$(J+_(B . "0x20158") ; <CJK>
       (?$(J+`(B . "0x202A7") ; <CJK>
       (?$(J+a(B . "0x5034") ; <CJK>
       (?$(J+b(B . "0x5001") ; <CJK>
       (?$(J+c(B . "0x20263") ; <CJK>
       (?$(J+d(B . "0x500A") ; <CJK>
       (?$(J+e(B . "0x3466") ; <CJK>
       (?$(J+f(B . "0x2026A") ; <CJK>
       (?$(J+g(B . "0x20265") ; <CJK>
       (?$(J+h(B . "0x2026B") ; <CJK>
       (?$(J+i(B . "0x34AD") ; <CJK>
       (?$(J+j(B . "0x204ED") ; <CJK>
       (?$(J+k(B . "0x205D9") ; <CJK>
       (?$(J+l(B . "0x2073B") ; <CJK>
       (?$(J+m(B . "0x20732") ; <CJK>
       (?$(J+n(B . "0x5258") ; <CJK>
       (?$(J+o(B . "0x20735") ; <CJK>
       (?$(J+p(B . "0x20731") ; <CJK>
       (?$(J+q(B . "0x2073E") ; <CJK>
       (?$(J+r(B . "0x20743") ; <CJK>
       (?$(J+s(B . "0x20736") ; <CJK>
       (?$(J+t(B . "0x2086D") ; <CJK>
       (?$(J+u(B . "0x351D") ; <CJK>
       (?$(J+v(B . "0x208E4") ; <CJK>
       (?$(J+w(B . "0x3531") ; <CJK>
       (?$(J+x(B . "0x532B") ; <CJK>
       (?$(J+y(B . "0x209F4") ; <CJK>
       (?$(J+z(B . "0x354C") ; <CJK>
       (?$(J+{(B . "0x20A69") ; <CJK>
       (?$(J+|(B . "0x20A6B") ; <CJK>
       (?$(J+}(B . "0x3595") ; <CJK>
       (?$(J+~(B . "0x3591") ; <CJK>
       (?$(J,!(B . "0x3594") ; <CJK>
       (?$(J,"(B . "0x20CBF") ; <CJK>
       (?$(J,#(B . "0x20CC3") ; <CJK>
       (?$(J,$(B . "0x20CAE") ; <CJK>
       (?$(J,%(B . "0x358F") ; <CJK>
       (?$(J,&(B . "0x54EC") ; <CJK>
       (?$(J,'(B . "0x20CB1") ; <CJK>
       (?$(J,((B . "0x5515") ; <CJK>
       (?$(J,)(B . "0x54FE") ; <CJK>
       (?$(J,*(B . "0x20CBB") ; <CJK>
       (?$(J,+(B . "0x20CAF") ; <CJK>
       (?$(J,,(B . "0x20CB0") ; <CJK>
       (?$(J,-(B . "0x54E3") ; <CJK>
       (?$(J,.(B . "0x5516") ; <CJK>
       (?$(J,/(B . "0x3640") ; <CJK>
       (?$(J,0(B . "0x212EF") ; <CJK>
       (?$(J,1(B . "0x3641") ; <CJK>
       (?$(J,2(B . "0x212ED") ; <CJK>
       (?$(J,3(B . "0x57D3") ; <CJK>
       (?$(J,4(B . "0x212F0") ; <CJK>
       (?$(J,5(B . "0x21593") ; <CJK>
       (?$(J,6(B . "0x21634") ; <CJK>
       (?$(J,7(B . "0x2162B") ; <CJK>
       (?$(J,8(B . "0x5959") ; <CJK>
       (?$(J,9(B . "0x5A27") ; <CJK>
       (?$(J,:(B . "0x36D8") ; <CJK>
       (?$(J,;(B . "0x36D2") ; <CJK>
       (?$(J,<(B . "0x36DA") ; <CJK>
       (?$(J,=(B . "0x5A28") ; <CJK>
       (?$(J,>(B . "0x5A10") ; <CJK>
       (?$(J,?(B . "0x36D7") ; <CJK>
       (?$(J,@(B . "0x5A0E") ; <CJK>
       (?$(J,A(B . "0x3742") ; <CJK>
       (?$(J,B(B . "0x3757") ; <CJK>
       (?$(J,C(B . "0x21A04") ; <CJK>
       (?$(J,D(B . "0x21A03") ; <CJK>
       (?$(J,E(B . "0x21A02") ; <CJK>
       (?$(J,F(B . "0x5BAF") ; <CJK>
       (?$(J,G(B . "0x21A05") ; <CJK>
       (?$(J,H(B . "0x5BBA") ; <CJK>
       (?$(J,I(B . "0x5BB1") ; <CJK>
       (?$(J,J(B . "0x21A00") ; <CJK>
       (?$(J,K(B . "0x21B74") ; <CJK>
       (?$(J,L(B . "0x3778") ; <CJK>
       (?$(J,M(B . "0x3782") ; <CJK>
       (?$(J,N(B . "0x3797") ; <CJK>
       (?$(J,O(B . "0x21C65") ; <CJK>
       (?$(J,P(B . "0x21C63") ; <CJK>
       (?$(J,Q(B . "0x37C9") ; <CJK>
       (?$(J,R(B . "0x21DD7") ; <CJK>
       (?$(J,S(B . "0x37C8") ; <CJK>
       (?$(J,T(B . "0x37D6") ; <CJK>
       (?$(J,U(B . "0x37CC") ; <CJK>
       (?$(J,V(B . "0x21DE8") ; <CJK>
       (?$(J,W(B . "0x37D0") ; <CJK>
       (?$(J,X(B . "0x21DDB") ; <CJK>
       (?$(J,Y(B . "0x21DD8") ; <CJK>
       (?$(J,Z(B . "0x37CE") ; <CJK>
       (?$(J,[(B . "0x37C7") ; <CJK>
       (?$(J,\(B . "0x5CFC") ; <CJK>
       (?$(J,](B . "0x21E09") ; <CJK>
       (?$(J,^(B . "0x37CF") ; <CJK>
       (?$(J,_(B . "0x37CB") ; <CJK>
       (?$(J,`(B . "0x5CF2") ; <CJK>
       (?$(J,a(B . "0x5CFE") ; <CJK>
       (?$(J,b(B . "0x21DE5") ; <CJK>
       (?$(J,c(B . "0x21DE7") ; <CJK>
       (?$(J,d(B . "0x5DF8") ; <CJK>
       (?$(J,e(B . "0x2203F") ; <CJK>
       (?$(J,f(B . "0x3847") ; <CJK>
       (?$(J,g(B . "0x220C0") ; <CJK>
       (?$(J,h(B . "0x3848") ; <CJK>
       (?$(J,i(B . "0x220B9") ; <CJK>
       (?$(J,j(B . "0x220BA") ; <CJK>
       (?$(J,k(B . "0x3883") ; <CJK>
       (?$(J,l(B . "0x3885") ; <CJK>
       (?$(J,m(B . "0x3884") ; <CJK>
       (?$(J,n(B . "0x22220") ; <CJK>
       (?$(J,o(B . "0x2234F") ; <CJK>
       (?$(J,p(B . "0x5F2C") ; <CJK>
       (?$(J,q(B . "0x38B8") ; <CJK>
       (?$(J,r(B . "0x38BC") ; <CJK>
       (?$(J,s(B . "0x22491") ; <CJK>
       (?$(J,t(B . "0x22490") ; <CJK>
       (?$(J,u(B . "0x224EE") ; <CJK>
       (?$(J,v(B . "0x224F3") ; <CJK>
       (?$(J,w(B . "0x224EC") ; <CJK>
       (?$(J,x(B . "0x224F1") ; <CJK>
       (?$(J,y(B . "0x224EB") ; <CJK>
       (?$(J,z(B . "0x224F2") ; <CJK>
       (?$(J,{(B . "0x224F4") ; <CJK>
       (?$(J,|(B . "0x224ED") ; <CJK>
       (?$(J,}(B . "0x22641") ; <CJK>
       (?$(J,~(B . "0x22648") ; <CJK>
       (?$(J-!(B . "0x22645") ; <CJK>
       (?$(J-"(B . "0x3931") ; <CJK>
       (?$(J-#(B . "0x3934") ; <CJK>
       (?$(J-$(B . "0x3936") ; <CJK>
       (?$(J-%(B . "0x6082") ; <CJK>
       (?$(J-&(B . "0x2267F") ; <CJK>
       (?$(J-'(B . "0x2268B") ; <CJK>
       (?$(J-((B . "0x3923") ; <CJK>
       (?$(J-)(B . "0x2263B") ; <CJK>
       (?$(J-*(B . "0x2264E") ; <CJK>
       (?$(J-+(B . "0x393A") ; <CJK>
       (?$(J-,(B . "0x6091") ; <CJK>
       (?$(J--(B . "0x608F") ; <CJK>
       (?$(J-.(B . "0x2267C") ; <CJK>
       (?$(J-/(B . "0x39B4") ; <CJK>
       (?$(J-0(B . "0x39B5") ; <CJK>
       (?$(J-1(B . "0x39ED") ; <CJK>
       (?$(J-2(B . "0x39EC") ; <CJK>
       (?$(J-3(B . "0x39D8") ; <CJK>
       (?$(J-4(B . "0x22AF0") ; <CJK>
       (?$(J-5(B . "0x22B36") ; <CJK>
       (?$(J-6(B . "0x22B3F") ; <CJK>
       (?$(J-7(B . "0x22B43") ; <CJK>
       (?$(J-8(B . "0x22B31") ; <CJK>
       (?$(J-9(B . "0x22B34") ; <CJK>
       (?$(J-:(B . "0x22B46") ; <CJK>
       (?$(J-;(B . "0x39F6") ; <CJK>
       (?$(J-<(B . "0x39E7") ; <CJK>
       (?$(J-=(B . "0x22B2F") ; <CJK>
       (?$(J->(B . "0x22EC3") ; <CJK>
       (?$(J-?(B . "0x3A7C") ; <CJK>
       (?$(J-@(B . "0x3A7B") ; <CJK>
       (?$(J-A(B . "0x22F36") ; <CJK>
       (?$(J-B(B . "0x3A88") ; <CJK>
       (?$(J-C(B . "0x6547") ; <CJK>
       (?$(J-D(B . "0x654C") ; <CJK>
       (?$(J-E(B . "0x22F21") ; <CJK>
       (?$(J-F(B . "0x2F8C8") ; <CJK>
       (?$(J-G(B . "0x658A") ; <CJK>
       (?$(J-H(B . "0x23073") ; <CJK>
       (?$(J-I(B . "0x3ABE") ; <CJK>
       (?$(J-J(B . "0x230E6") ; <CJK>
       (?$(J-K(B . "0x3AE7") ; <CJK>
       (?$(J-L(B . "0x3AE5") ; <CJK>
       (?$(J-M(B . "0x3AEE") ; <CJK>
       (?$(J-N(B . "0x67E1") ; <CJK>
       (?$(J-O(B . "0x684A") ; <CJK>
       (?$(J-P(B . "0x2343F") ; <CJK>
       (?$(J-Q(B . "0x3B59") ; <CJK>
       (?$(J-R(B . "0x3B5E") ; <CJK>
       (?$(J-S(B . "0x2346B") ; <CJK>
       (?$(J-T(B . "0x3B5A") ; <CJK>
       (?$(J-U(B . "0x683F") ; <CJK>
       (?$(J-V(B . "0x3B61") ; <CJK>
       (?$(J-W(B . "0x3B58") ; <CJK>
       (?$(J-X(B . "0x3B5B") ; <CJK>
       (?$(J-Y(B . "0x67BD") ; <CJK>
       (?$(J-Z(B . "0x23471") ; <CJK>
       (?$(J-[(B . "0x3B5F") ; <CJK>
       (?$(J-\(B . "0x2F8E2") ; <CJK>
       (?$(J-](B . "0x3C2A") ; <CJK>
       (?$(J-^(B . "0x3C2D") ; <CJK>
       (?$(J-_(B . "0x238B0") ; <CJK>
       (?$(J-`(B . "0x3C23") ; <CJK>
       (?$(J-a(B . "0x3C2B") ; <CJK>
       (?$(J-b(B . "0x3C2C") ; <CJK>
       (?$(J-c(B . "0x239F3") ; <CJK>
       (?$(J-d(B . "0x3C7E") ; <CJK>
       (?$(J-e(B . "0x2F8F5") ; <CJK>
       (?$(J-f(B . "0x3C93") ; <CJK>
       (?$(J-g(B . "0x3C99") ; <CJK>
       (?$(J-h(B . "0x23B61") ; <CJK>
       (?$(J-i(B . "0x23B5F") ; <CJK>
       (?$(J-j(B . "0x3CB3") ; <CJK>
       (?$(J-k(B . "0x3CE7") ; <CJK>
       (?$(J-l(B . "0x3CEA") ; <CJK>
       (?$(J-m(B . "0x23D28") ; <CJK>
       (?$(J-n(B . "0x23D1E") ; <CJK>
       (?$(J-o(B . "0x23D29") ; <CJK>
       (?$(J-p(B . "0x2F902") ; <CJK>
       (?$(J-q(B . "0x23CEB") ; <CJK>
       (?$(J-r(B . "0x23D66") ; <CJK>
       (?$(J-s(B . "0x3DB4") ; <CJK>
       (?$(J-t(B . "0x241F6") ; <CJK>
       (?$(J-u(B . "0x70C9") ; <CJK>
       (?$(J-v(B . "0x3E17") ; <CJK>
       (?$(J-w(B . "0x24560") ; <CJK>
       (?$(J-x(B . "0x24577") ; <CJK>
       (?$(J-y(B . "0x245BB") ; <CJK>
       (?$(J-z(B . "0x3E21") ; <CJK>
       (?$(J-{(B . "0x245BC") ; <CJK>
       (?$(J-|(B . "0x3E38") ; <CJK>
       (?$(J-}(B . "0x3E37") ; <CJK>
       (?$(J-~(B . "0x3E74") ; <CJK>
       (?$(J.!(B . "0x3E73") ; <CJK>
       (?$(J."(B . "0x3E75") ; <CJK>
       (?$(J.#(B . "0x247A2") ; <CJK>
       (?$(J.$(B . "0x247B2") ; <CJK>
       (?$(J.%(B . "0x2479E") ; <CJK>
       (?$(J.&(B . "0x3E76") ; <CJK>
       (?$(J.'(B . "0x3E78") ; <CJK>
       (?$(J.((B . "0x2493A") ; <CJK>
       (?$(J.)(B . "0x24938") ; <CJK>
       (?$(J.*(B . "0x73BA") ; <CJK>
       (?$(J.+(B . "0x3F0C") ; <CJK>
       (?$(J.,(B . "0x3F20") ; <CJK>
       (?$(J.-(B . "0x3F1E") ; <CJK>
       (?$(J..(B . "0x24C4D") ; <CJK>
       (?$(J./(B . "0x3F5B") ; <CJK>
       (?$(J.0(B . "0x24C5E") ; <CJK>
       (?$(J.1(B . "0x3F5C") ; <CJK>
       (?$(J.2(B . "0x24D17") ; <CJK>
       (?$(J.3(B . "0x3F83") ; <CJK>
       (?$(J.4(B . "0x75C6") ; <CJK>
       (?$(J.5(B . "0x3F80") ; <CJK>
       (?$(J.6(B . "0x3F81") ; <CJK>
       (?$(J.7(B . "0x3F7E") ; <CJK>
       (?$(J.8(B . "0x3F88") ; <CJK>
       (?$(J.9(B . "0x3F85") ; <CJK>
       (?$(J.:(B . "0x3F89") ; <CJK>
       (?$(J.;(B . "0x3F7F") ; <CJK>
       (?$(J.<(B . "0x3F8E") ; <CJK>
       (?$(J.=(B . "0x24D64") ; <CJK>
       (?$(J.>(B . "0x24D67") ; <CJK>
       (?$(J.?(B . "0x3F84") ; <CJK>
       (?$(J.@(B . "0x75B7") ; <CJK>
       (?$(J.A(B . "0x768C") ; <CJK>
       (?$(J.B(B . "0x24F59") ; <CJK>
       (?$(J.C(B . "0x768D") ; <CJK>
       (?$(J.D(B . "0x24FDA") ; <CJK>
       (?$(J.E(B . "0x3FEE") ; <CJK>
       (?$(J.F(B . "0x3FED") ; <CJK>
       (?$(J.G(B . "0x3FFE") ; <CJK>
       (?$(J.H(B . "0x25051") ; <CJK>
       (?$(J.I(B . "0x3FFF") ; <CJK>
       (?$(J.J(B . "0x25055") ; <CJK>
       (?$(J.K(B . "0x2513B") ; <CJK>
       (?$(J.L(B . "0x25134") ; <CJK>
       (?$(J.M(B . "0x4023") ; <CJK>
       (?$(J.N(B . "0x25137") ; <CJK>
       (?$(J.O(B . "0x7717") ; <CJK>
       (?$(J.P(B . "0x25131") ; <CJK>
       (?$(J.Q(B . "0x771C") ; <CJK>
       (?$(J.R(B . "0x401F") ; <CJK>
       (?$(J.S(B . "0x2513F") ; <CJK>
       (?$(J.T(B . "0x25159") ; <CJK>
       (?$(J.U(B . "0x7714") ; <CJK>
       (?$(J.V(B . "0x25361") ; <CJK>
       (?$(J.W(B . "0x408F") ; <CJK>
       (?$(J.X(B . "0x4090") ; <CJK>
       (?$(J.Y(B . "0x25458") ; <CJK>
       (?$(J.Z(B . "0x25462") ; <CJK>
       (?$(J.[(B . "0x25450") ; <CJK>
       (?$(J.\(B . "0x40A0") ; <CJK>
       (?$(J.](B . "0x25451") ; <CJK>
       (?$(J.^(B . "0x40A6") ; <CJK>
       (?$(J._(B . "0x409F") ; <CJK>
       (?$(J.`(B . "0x25446") ; <CJK>
       (?$(J.a(B . "0x40A7") ; <CJK>
       (?$(J.b(B . "0x40A1") ; <CJK>
       (?$(J.c(B . "0x2562D") ; <CJK>
       (?$(J.d(B . "0x4102") ; <CJK>
       (?$(J.e(B . "0x4136") ; <CJK>
       (?$(J.f(B . "0x25948") ; <CJK>
       (?$(J.g(B . "0x25951") ; <CJK>
       (?$(J.h(B . "0x2594A") ; <CJK>
       (?$(J.i(B . "0x2594F") ; <CJK>
       (?$(J.j(B . "0x25950") ; <CJK>
       (?$(J.k(B . "0x25949") ; <CJK>
       (?$(J.l(B . "0x25A63") ; <CJK>
       (?$(J.m(B . "0x41C8") ; <CJK>
       (?$(J.n(B . "0x25A66") ; <CJK>
       (?$(J.o(B . "0x25A60") ; <CJK>
       (?$(J.p(B . "0x41D8") ; <CJK>
       (?$(J.q(B . "0x7B0C") ; <CJK>
       (?$(J.r(B . "0x41DD") ; <CJK>
       (?$(J.s(B . "0x41DC") ; <CJK>
       (?$(J.t(B . "0x25AF1") ; <CJK>
       (?$(J.u(B . "0x41D7") ; <CJK>
       (?$(J.v(B . "0x25B07") ; <CJK>
       (?$(J.w(B . "0x41DA") ; <CJK>
       (?$(J.x(B . "0x42BA") ; <CJK>
       (?$(J.y(B . "0x25F9B") ; <CJK>
       (?$(J.z(B . "0x25FA3") ; <CJK>
       (?$(J.{(B . "0x25F9D") ; <CJK>
       (?$(J.|(B . "0x42BE") ; <CJK>
       (?$(J.}(B . "0x42C2") ; <CJK>
       (?$(J.~(B . "0x42BB") ; <CJK>
       (?$(J/!(B . "0x42C0") ; <CJK>
       (?$(J/"(B . "0x25FA9") ; <CJK>
       (?$(J/#(B . "0x25FA7") ; <CJK>
       (?$(J/$(B . "0x25FA4") ; <CJK>
       (?$(J/%(B . "0x7D23") ; <CJK>
       (?$(J/&(B . "0x25FBA") ; <CJK>
       (?$(J/'(B . "0x221C1") ; <CJK>
       (?$(J/((B . "0x26226") ; <CJK>
       (?$(J/)(B . "0x4343") ; <CJK>
       (?$(J/*(B . "0x4355") ; <CJK>
       (?$(J/+(B . "0x26294") ; <CJK>
       (?$(J/,(B . "0x26293") ; <CJK>
       (?$(J/-(B . "0x4357") ; <CJK>
       (?$(J/.(B . "0x4368") ; <CJK>
       (?$(J//(B . "0x7F98") ; <CJK>
       (?$(J/0(B . "0x7F90") ; <CJK>
       (?$(J/1(B . "0x26407") ; <CJK>
       (?$(J/2(B . "0x2640D") ; <CJK>
       (?$(J/3(B . "0x26402") ; <CJK>
       (?$(J/4(B . "0x2640C") ; <CJK>
       (?$(J/5(B . "0x26409") ; <CJK>
       (?$(J/6(B . "0x26408") ; <CJK>
       (?$(J/7(B . "0x26413") ; <CJK>
       (?$(J/8(B . "0x43A1") ; <CJK>
       (?$(J/9(B . "0x264D2") ; <CJK>
       (?$(J/:(B . "0x803A") ; <CJK>
       (?$(J/;(B . "0x2653E") ; <CJK>
       (?$(J/<(B . "0x2653C") ; <CJK>
       (?$(J/=(B . "0x26667") ; <CJK>
       (?$(J/>(B . "0x2669E") ; <CJK>
       (?$(J/?(B . "0x43EA") ; <CJK>
       (?$(J/@(B . "0x266AD") ; <CJK>
       (?$(J/A(B . "0x43E7") ; <CJK>
       (?$(J/B(B . "0x266D9") ; <CJK>
       (?$(J/C(B . "0x26642") ; <CJK>
       (?$(J/D(B . "0x266A3") ; <CJK>
       (?$(J/E(B . "0x266A0") ; <CJK>
       (?$(J/F(B . "0x43E8") ; <CJK>
       (?$(J/G(B . "0x43E9") ; <CJK>
       (?$(J/H(B . "0x2667C") ; <CJK>
       (?$(J/I(B . "0x26904") ; <CJK>
       (?$(J/J(B . "0x4454") ; <CJK>
       (?$(J/K(B . "0x26958") ; <CJK>
       (?$(J/L(B . "0x26960") ; <CJK>
       (?$(J/M(B . "0x269C9") ; <CJK>
       (?$(J/N(B . "0x269C8") ; <CJK>
       (?$(J/O(B . "0x8226") ; <CJK>
       (?$(J/P(B . "0x4465") ; <CJK>
       (?$(J/Q(B . "0x26A1C") ; <CJK>
       (?$(J/R(B . "0x26A1A") ; <CJK>
       (?$(J/S(B . "0x448A") ; <CJK>
       (?$(J/T(B . "0x26B74") ; <CJK>
       (?$(J/U(B . "0x44B0") ; <CJK>
       (?$(J/V(B . "0x26B6E") ; <CJK>
       (?$(J/W(B . "0x26B6F") ; <CJK>
       (?$(J/X(B . "0x26B79") ; <CJK>
       (?$(J/Y(B . "0x44BC") ; <CJK>
       (?$(J/Z(B . "0x832E") ; <CJK>
       (?$(J/[(B . "0x26B77") ; <CJK>
       (?$(J/\(B . "0x8355") ; <CJK>
       (?$(J/](B . "0x831A") ; <CJK>
       (?$(J/^(B . "0x44B8") ; <CJK>
       (?$(J/_(B . "0x833D") ; <CJK>
       (?$(J/`(B . "0x26B7C") ; <CJK>
       (?$(J/a(B . "0x44B2") ; <CJK>
       (?$(J/b(B . "0x26B70") ; <CJK>
       (?$(J/c(B . "0x8330") ; <CJK>
       (?$(J/d(B . "0x44BD") ; <CJK>
       (?$(J/e(B . "0x26B7A") ; <CJK>
       (?$(J/f(B . "0x26B82") ; <CJK>
       (?$(J/g(B . "0x458A") ; <CJK>
       (?$(J/h(B . "0x8651") ; <CJK>
       (?$(J/i(B . "0x45A1") ; <CJK>
       (?$(J/j(B . "0x27244") ; <CJK>
       (?$(J/k(B . "0x45A2") ; <CJK>
       (?$(J/l(B . "0x27243") ; <CJK>
       (?$(J/m(B . "0x8688") ; <CJK>
       (?$(J/n(B . "0x27245") ; <CJK>
       (?$(J/o(B . "0x4615") ; <CJK>
       (?$(J/p(B . "0x27625") ; <CJK>
       (?$(J/q(B . "0x2761F") ; <CJK>
       (?$(J/r(B . "0x4620") ; <CJK>
       (?$(J/s(B . "0x4673") ; <CJK>
       (?$(J/t(B . "0x277E8") ; <CJK>
       (?$(J/u(B . "0x898E") ; <CJK>
       (?$(J/v(B . "0x898D") ; <CJK>
       (?$(J/w(B . "0x27809") ; <CJK>
       (?$(J/x(B . "0x278B7") ; <CJK>
       (?$(J/y(B . "0x278B9") ; <CJK>
       (?$(J/z(B . "0x27964") ; <CJK>
       (?$(J/{(B . "0x27963") ; <CJK>
       (?$(J/|(B . "0x8A09") ; <CJK>
       (?$(J/}(B . "0x8A14") ; <CJK>
       (?$(J/~(B . "0x46B1") ; <CJK>
       (?$(J0!(B . "0x27962") ; <CJK>
       (?$(J0"(B . "0x27965") ; <CJK>
       (?$(J0#(B . "0x472B") ; <CJK>
       (?$(J0$(B . "0x27BAC") ; <CJK>
       (?$(J0%(B . "0x4745") ; <CJK>
       (?$(J0&(B . "0x27D2A") ; <CJK>
       (?$(J0'(B . "0x4797") ; <CJK>
       (?$(J0((B . "0x4798") ; <CJK>
       (?$(J0)(B . "0x27E96") ; <CJK>
       (?$(J0*(B . "0x47D5") ; <CJK>
       (?$(J0+(B . "0x27FC2") ; <CJK>
       (?$(J0,(B . "0x2F9DE") ; <CJK>
       (?$(J0-(B . "0x4893") ; <CJK>
       (?$(J0.(B . "0x4896") ; <CJK>
       (?$(J0/(B . "0x9007") ; <CJK>
       (?$(J00(B . "0x4894") ; <CJK>
       (?$(J01(B . "0x284AA") ; <CJK>
       (?$(J02(B . "0x284B0") ; <CJK>
       (?$(J03(B . "0x48C7") ; <CJK>
       (?$(J04(B . "0x48C5") ; <CJK>
       (?$(J05(B . "0x286D4") ; <CJK>
       (?$(J06(B . "0x286CD") ; <CJK>
       (?$(J07(B . "0x286D6") ; <CJK>
       (?$(J08(B . "0x48C4") ; <CJK>
       (?$(J09(B . "0x287F0") ; <CJK>
       (?$(J0:(B . "0x9579") ; <CJK>
       (?$(J0;(B . "0x9584") ; <CJK>
       (?$(J0<(B . "0x49CE") ; <CJK>
       (?$(J0=(B . "0x49CA") ; <CJK>
       (?$(J0>(B . "0x49CC") ; <CJK>
       (?$(J0?(B . "0x9657") ; <CJK>
       (?$(J0@(B . "0x49C9") ; <CJK>
       (?$(J0A(B . "0x96BA") ; <CJK>
       (?$(J0B(B . "0x98E4") ; <CJK>
       (?$(J0C(B . "0x29D4B") ; <CJK>
       (?$(J0D(B . "0x20162") ; <CJK>
       (?$(J0E(B . "0x346E") ; <CJK>
       (?$(J0F(B . "0x202B7") ; <CJK>
       (?$(J0G(B . "0x5067") ; <CJK>
       (?$(J0H(B . "0x202AC") ; <CJK>
       (?$(J0I(B . "0x202AB") ; <CJK>
       (?$(J0J(B . "0x3471") ; <CJK>
       (?$(J0K(B . "0x202C1") ; <CJK>
       (?$(J0L(B . "0x34BB") ; <CJK>
       (?$(J0M(B . "0x34D3") ; <CJK>
       (?$(J0N(B . "0x205E8") ; <CJK>
       (?$(J0O(B . "0x20769") ; <CJK>
       (?$(J0P(B . "0x2075D") ; <CJK>
       (?$(J0Q(B . "0x2075F") ; <CJK>
       (?$(J0R(B . "0x34F3") ; <CJK>
       (?$(J0S(B . "0x34ED") ; <CJK>
       (?$(J0T(B . "0x34F5") ; <CJK>
       (?$(J0U(B . "0x20764") ; <CJK>
       (?$(J0V(B . "0x20762") ; <CJK>
       (?$(J0W(B . "0x34F1") ; <CJK>
       (?$(J0X(B . "0x34F2") ; <CJK>
       (?$(J0Y(B . "0x34F6") ; <CJK>
       (?$(J0Z(B . "0x3520") ; <CJK>
       (?$(J0[(B . "0x208F9") ; <CJK>
       (?$(J0\(B . "0x3528") ; <CJK>
       (?$(J0](B . "0x208EE") ; <CJK>
       (?$(J0^(B . "0x5318") ; <CJK>
       (?$(J0_(B . "0x532C") ; <CJK>
       (?$(J0`(B . "0x5359") ; <CJK>
       (?$(J0a(B . "0x209AB") ; <CJK>
       (?$(J0b(B . "0x209AC") ; <CJK>
       (?$(J0c(B . "0x209AA") ; <CJK>
       (?$(J0d(B . "0x5368") ; <CJK>
       (?$(J0e(B . "0x537E") ; <CJK>
       (?$(J0f(B . "0x20A86") ; <CJK>
       (?$(J0g(B . "0x20A7A") ; <CJK>
       (?$(J0h(B . "0x53A1") ; <CJK>
       (?$(J0i(B . "0x20D28") ; <CJK>
       (?$(J0j(B . "0x35A1") ; <CJK>
       (?$(J0k(B . "0x555B") ; <CJK>
       (?$(J0l(B . "0x35AA") ; <CJK>
       (?$(J0m(B . "0x35A9") ; <CJK>
       (?$(J0n(B . "0x20D31") ; <CJK>
       (?$(J0o(B . "0x35B5") ; <CJK>
       (?$(J0p(B . "0x35A5") ; <CJK>
       (?$(J0q(B . "0x35A8") ; <CJK>
       (?$(J0r(B . "0x5542") ; <CJK>
       (?$(J0s(B . "0x35A7") ; <CJK>
       (?$(J0t(B . "0x5547") ; <CJK>
       (?$(J0u(B . "0x20D2D") ; <CJK>
       (?$(J0v(B . "0x2F843") ; <CJK>
       (?$(J0w(B . "0x553D") ; <CJK>
       (?$(J0x(B . "0x20D2B") ; <CJK>
       (?$(J0y(B . "0x20D32") ; <CJK>
       (?$(J0z(B . "0x5560") ; <CJK>
       (?$(J0{(B . "0x57EB") ; <CJK>
       (?$(J0|(B . "0x21329") ; <CJK>
       (?$(J0}(B . "0x21326") ; <CJK>
       (?$(J0~(B . "0x21353") ; <CJK>
       (?$(J1!(B . "0x364D") ; <CJK>
       (?$(J1"(B . "0x21333") ; <CJK>
       (?$(J1#(B . "0x21334") ; <CJK>
       (?$(J1$(B . "0x2159D") ; <CJK>
       (?$(J1%(B . "0x369C") ; <CJK>
       (?$(J1&(B . "0x595F") ; <CJK>
       (?$(J1'(B . "0x21641") ; <CJK>
       (?$(J1((B . "0x36EA") ; <CJK>
       (?$(J1)(B . "0x36E5") ; <CJK>
       (?$(J1*(B . "0x21791") ; <CJK>
       (?$(J1+(B . "0x21769") ; <CJK>
       (?$(J1,(B . "0x5B6F") ; <CJK>
       (?$(J1-(B . "0x21A22") ; <CJK>
       (?$(J1.(B . "0x375E") ; <CJK>
       (?$(J1/(B . "0x21A34") ; <CJK>
       (?$(J10(B . "0x2F86D") ; <CJK>
       (?$(J11(B . "0x21B2E") ; <CJK>
       (?$(J12(B . "0x3786") ; <CJK>
       (?$(J13(B . "0x3784") ; <CJK>
       (?$(J14(B . "0x21BF4") ; <CJK>
       (?$(J15(B . "0x5C5A") ; <CJK>
       (?$(J16(B . "0x21E28") ; <CJK>
       (?$(J17(B . "0x37D9") ; <CJK>
       (?$(J18(B . "0x21E1C") ; <CJK>
       (?$(J19(B . "0x37DE") ; <CJK>
       (?$(J1:(B . "0x21E11") ; <CJK>
       (?$(J1;(B . "0x21E24") ; <CJK>
       (?$(J1<(B . "0x21E15") ; <CJK>
       (?$(J1=(B . "0x37DB") ; <CJK>
       (?$(J1>(B . "0x21E16") ; <CJK>
       (?$(J1?(B . "0x21E54") ; <CJK>
       (?$(J1@(B . "0x21E23") ; <CJK>
       (?$(J1A(B . "0x21FFF") ; <CJK>
       (?$(J1B(B . "0x3831") ; <CJK>
       (?$(J1C(B . "0x220CF") ; <CJK>
       (?$(J1D(B . "0x220D0") ; <CJK>
       (?$(J1E(B . "0x384B") ; <CJK>
       (?$(J1F(B . "0x220CE") ; <CJK>
       (?$(J1G(B . "0x3849") ; <CJK>
       (?$(J1H(B . "0x384A") ; <CJK>
       (?$(J1I(B . "0x384C") ; <CJK>
       (?$(J1J(B . "0x221C7") ; <CJK>
       (?$(J1K(B . "0x2225C") ; <CJK>
       (?$(J1L(B . "0x388A") ; <CJK>
       (?$(J1M(B . "0x22236") ; <CJK>
       (?$(J1N(B . "0x3889") ; <CJK>
       (?$(J1O(B . "0x388B") ; <CJK>
       (?$(J1P(B . "0x22243") ; <CJK>
       (?$(J1Q(B . "0x38BB") ; <CJK>
       (?$(J1R(B . "0x5FA2") ; <CJK>
       (?$(J1S(B . "0x5F9D") ; <CJK>
       (?$(J1T(B . "0x38E4") ; <CJK>
       (?$(J1U(B . "0x2252A") ; <CJK>
       (?$(J1V(B . "0x22501") ; <CJK>
       (?$(J1W(B . "0x5FA3") ; <CJK>
       (?$(J1X(B . "0x2250B") ; <CJK>
       (?$(J1Y(B . "0x2250F") ; <CJK>
       (?$(J1Z(B . "0x393B") ; <CJK>
       (?$(J1[(B . "0x392E") ; <CJK>
       (?$(J1\(B . "0x393E") ; <CJK>
       (?$(J1](B . "0x3946") ; <CJK>
       (?$(J1^(B . "0x3953") ; <CJK>
       (?$(J1_(B . "0x226DF") ; <CJK>
       (?$(J1`(B . "0x3944") ; <CJK>
       (?$(J1a(B . "0x226D2") ; <CJK>
       (?$(J1b(B . "0x393F") ; <CJK>
       (?$(J1c(B . "0x3942") ; <CJK>
       (?$(J1d(B . "0x394F") ; <CJK>
       (?$(J1e(B . "0x226CD") ; <CJK>
       (?$(J1f(B . "0x3952") ; <CJK>
       (?$(J1g(B . "0x394A") ; <CJK>
       (?$(J1h(B . "0x60C2") ; <CJK>
       (?$(J1i(B . "0x226DB") ; <CJK>
       (?$(J1j(B . "0x395A") ; <CJK>
       (?$(J1k(B . "0x60A5") ; <CJK>
       (?$(J1l(B . "0x3949") ; <CJK>
       (?$(J1m(B . "0x226CF") ; <CJK>
       (?$(J1n(B . "0x621C") ; <CJK>
       (?$(J1o(B . "0x229C0") ; <CJK>
       (?$(J1p(B . "0x621D") ; <CJK>
       (?$(J1q(B . "0x3A03") ; <CJK>
       (?$(J1r(B . "0x22B81") ; <CJK>
       (?$(J1s(B . "0x22B82") ; <CJK>
       (?$(J1t(B . "0x22B8A") ; <CJK>
       (?$(J1u(B . "0x22BA8") ; <CJK>
       (?$(J1v(B . "0x22B8C") ; <CJK>
       (?$(J1w(B . "0x6395") ; <CJK>
       (?$(J1x(B . "0x639A") ; <CJK>
       (?$(J1y(B . "0x3A01") ; <CJK>
       (?$(J1z(B . "0x3A06") ; <CJK>
       (?$(J1{(B . "0x39FB") ; <CJK>
       (?$(J1|(B . "0x39F9") ; <CJK>
       (?$(J1}(B . "0x22B8E") ; <CJK>
       (?$(J1~(B . "0x3A05") ; <CJK>
       (?$(J2!(B . "0x39FA") ; <CJK>
       (?$(J2"(B . "0x22B8B") ; <CJK>
       (?$(J2#(B . "0x63A6") ; <CJK>
       (?$(J2$(B . "0x22B96") ; <CJK>
       (?$(J2%(B . "0x39FE") ; <CJK>
       (?$(J2&(B . "0x22BCC") ; <CJK>
       (?$(J2'(B . "0x3A7D") ; <CJK>
       (?$(J2((B . "0x3A8C") ; <CJK>
       (?$(J2)(B . "0x22F4F") ; <CJK>
       (?$(J2*(B . "0x22F4A") ; <CJK>
       (?$(J2+(B . "0x6550") ; <CJK>
       (?$(J2,(B . "0x3A8E") ; <CJK>
       (?$(J2-(B . "0x22F4B") ; <CJK>
       (?$(J2.(B . "0x22F3D") ; <CJK>
       (?$(J2/(B . "0x6552") ; <CJK>
       (?$(J20(B . "0x22F44") ; <CJK>
       (?$(J21(B . "0x22F49") ; <CJK>
       (?$(J22(B . "0x2309E") ; <CJK>
       (?$(J23(B . "0x230F3") ; <CJK>
       (?$(J24(B . "0x65C8") ; <CJK>
       (?$(J25(B . "0x230F5") ; <CJK>
       (?$(J26(B . "0x3AF0") ; <CJK>
       (?$(J27(B . "0x3AF2") ; <CJK>
       (?$(J28(B . "0x231B3") ; <CJK>
       (?$(J29(B . "0x6658") ; <CJK>
       (?$(J2:(B . "0x3AF1") ; <CJK>
       (?$(J2;(B . "0x3AE6") ; <CJK>
       (?$(J2<(B . "0x231E5") ; <CJK>
       (?$(J2=(B . "0x231B6") ; <CJK>
       (?$(J2>(B . "0x2F8D8") ; <CJK>
       (?$(J2?(B . "0x6888") ; <CJK>
       (?$(J2@(B . "0x23486") ; <CJK>
       (?$(J2A(B . "0x3B6F") ; <CJK>
       (?$(J2B(B . "0x3B6D") ; <CJK>
       (?$(J2C(B . "0x3B69") ; <CJK>
       (?$(J2D(B . "0x234B6") ; <CJK>
       (?$(J2E(B . "0x23485") ; <CJK>
       (?$(J2F(B . "0x3B6E") ; <CJK>
       (?$(J2G(B . "0x234AB") ; <CJK>
       (?$(J2H(B . "0x3C2F") ; <CJK>
       (?$(J2I(B . "0x3C30") ; <CJK>
       (?$(J2J(B . "0x3C63") ; <CJK>
       (?$(J2K(B . "0x23A0D") ; <CJK>
       (?$(J2L(B . "0x23A8B") ; <CJK>
       (?$(J2M(B . "0x23A8C") ; <CJK>
       (?$(J2N(B . "0x6BB8") ; <CJK>
       (?$(J2O(B . "0x3C80") ; <CJK>
       (?$(J2P(B . "0x6BB9") ; <CJK>
       (?$(J2Q(B . "0x3C9A") ; <CJK>
       (?$(J2R(B . "0x3C94") ; <CJK>
       (?$(J2S(B . "0x3C96") ; <CJK>
       (?$(J2T(B . "0x3C95") ; <CJK>
       (?$(J2U(B . "0x3C97") ; <CJK>
       (?$(J2V(B . "0x23B72") ; <CJK>
       (?$(J2W(B . "0x3CF4") ; <CJK>
       (?$(J2X(B . "0x3CFE") ; <CJK>
       (?$(J2Y(B . "0x23D8F") ; <CJK>
       (?$(J2Z(B . "0x3D01") ; <CJK>
       (?$(J2[(B . "0x23D79") ; <CJK>
       (?$(J2\(B . "0x3D02") ; <CJK>
       (?$(J2](B . "0x23D77") ; <CJK>
       (?$(J2^(B . "0x3CF9") ; <CJK>
       (?$(J2_(B . "0x23D90") ; <CJK>
       (?$(J2`(B . "0x23D88") ; <CJK>
       (?$(J2a(B . "0x23D80") ; <CJK>
       (?$(J2b(B . "0x23D9E") ; <CJK>
       (?$(J2c(B . "0x3CF6") ; <CJK>
       (?$(J2d(B . "0x3CF7") ; <CJK>
       (?$(J2e(B . "0x23D82") ; <CJK>
       (?$(J2f(B . "0x23D34") ; <CJK>
       (?$(J2g(B . "0x23D89") ; <CJK>
       (?$(J2h(B . "0x3CFF") ; <CJK>
       (?$(J2i(B . "0x23D85") ; <CJK>
       (?$(J2j(B . "0x23D7E") ; <CJK>
       (?$(J2k(B . "0x23D7A") ; <CJK>
       (?$(J2l(B . "0x23DA6") ; <CJK>
       (?$(J2m(B . "0x6E0B") ; <CJK>
       (?$(J2n(B . "0x23DB5") ; <CJK>
       (?$(J2o(B . "0x241F4") ; <CJK>
       (?$(J2p(B . "0x3DBF") ; <CJK>
       (?$(J2q(B . "0x3DBC") ; <CJK>
       (?$(J2r(B . "0x7105") ; <CJK>
       (?$(J2s(B . "0x24229") ; <CJK>
       (?$(J2t(B . "0x24226") ; <CJK>
       (?$(J2u(B . "0x2422A") ; <CJK>
       (?$(J2v(B . "0x3DBE") ; <CJK>
       (?$(J2w(B . "0x3DC0") ; <CJK>
       (?$(J2x(B . "0x2457E") ; <CJK>
       (?$(J2y(B . "0x3E3B") ; <CJK>
       (?$(J2z(B . "0x3E39") ; <CJK>
       (?$(J2{(B . "0x2465B") ; <CJK>
       (?$(J2|(B . "0x24661") ; <CJK>
       (?$(J2}(B . "0x24660") ; <CJK>
       (?$(J2~(B . "0x3E3C") ; <CJK>
       (?$(J3!(B . "0x2479B") ; <CJK>
       (?$(J3"(B . "0x7314") ; <CJK>
       (?$(J3#(B . "0x7304") ; <CJK>
       (?$(J3$(B . "0x247C3") ; <CJK>
       (?$(J3%(B . "0x3E7D") ; <CJK>
       (?$(J3&(B . "0x247CD") ; <CJK>
       (?$(J3'(B . "0x3E7F") ; <CJK>
       (?$(J3((B . "0x3E7A") ; <CJK>
       (?$(J3)(B . "0x3E7C") ; <CJK>
       (?$(J3*(B . "0x7305") ; <CJK>
       (?$(J3+(B . "0x3E7E") ; <CJK>
       (?$(J3,(B . "0x7315") ; <CJK>
       (?$(J3-(B . "0x730D") ; <CJK>
       (?$(J3.(B . "0x3E80") ; <CJK>
       (?$(J3/(B . "0x3EBF") ; <CJK>
       (?$(J30(B . "0x3EC3") ; <CJK>
       (?$(J31(B . "0x24954") ; <CJK>
       (?$(J32(B . "0x24959") ; <CJK>
       (?$(J33(B . "0x3ECC") ; <CJK>
       (?$(J34(B . "0x3F0E") ; <CJK>
       (?$(J35(B . "0x3F0D") ; <CJK>
       (?$(J36(B . "0x24AF5") ; <CJK>
       (?$(J37(B . "0x3F26") ; <CJK>
       (?$(J38(B . "0x3F24") ; <CJK>
       (?$(J39(B . "0x3F25") ; <CJK>
       (?$(J3:(B . "0x3F23") ; <CJK>
       (?$(J3;(B . "0x3F21") ; <CJK>
       (?$(J3<(B . "0x3F29") ; <CJK>
       (?$(J3=(B . "0x24C69") ; <CJK>
       (?$(J3>(B . "0x24C65") ; <CJK>
       (?$(J3?(B . "0x3F8F") ; <CJK>
       (?$(J3@(B . "0x3F8D") ; <CJK>
       (?$(J3A(B . "0x24D7C") ; <CJK>
       (?$(J3B(B . "0x3F8B") ; <CJK>
       (?$(J3C(B . "0x3F92") ; <CJK>
       (?$(J3D(B . "0x24D80") ; <CJK>
       (?$(J3E(B . "0x3F90") ; <CJK>
       (?$(J3F(B . "0x24F65") ; <CJK>
       (?$(J3G(B . "0x3FEF") ; <CJK>
       (?$(J3H(B . "0x3FF0") ; <CJK>
       (?$(J3I(B . "0x24FDF") ; <CJK>
       (?$(J3J(B . "0x25060") ; <CJK>
       (?$(J3K(B . "0x4001") ; <CJK>
       (?$(J3L(B . "0x2505E") ; <CJK>
       (?$(J3M(B . "0x402E") ; <CJK>
       (?$(J3N(B . "0x402D") ; <CJK>
       (?$(J3O(B . "0x772E") ; <CJK>
       (?$(J3P(B . "0x4028") ; <CJK>
       (?$(J3Q(B . "0x4029") ; <CJK>
       (?$(J3R(B . "0x402C") ; <CJK>
       (?$(J3S(B . "0x2518F") ; <CJK>
       (?$(J3T(B . "0x25161") ; <CJK>
       (?$(J3U(B . "0x2515A") ; <CJK>
       (?$(J3V(B . "0x7741") ; <CJK>
       (?$(J3W(B . "0x4088") ; <CJK>
       (?$(J3X(B . "0x25367") ; <CJK>
       (?$(J3Y(B . "0x4092") ; <CJK>
       (?$(J3Z(B . "0x4091") ; <CJK>
       (?$(J3[(B . "0x77EA") ; <CJK>
       (?$(J3\(B . "0x253BB") ; <CJK>
       (?$(J3](B . "0x7844") ; <CJK>
       (?$(J3^(B . "0x40A9") ; <CJK>
       (?$(J3_(B . "0x40AC") ; <CJK>
       (?$(J3`(B . "0x40AE") ; <CJK>
       (?$(J3a(B . "0x40AA") ; <CJK>
       (?$(J3b(B . "0x4106") ; <CJK>
       (?$(J3c(B . "0x4105") ; <CJK>
       (?$(J3d(B . "0x414A") ; <CJK>
       (?$(J3e(B . "0x413E") ; <CJK>
       (?$(J3f(B . "0x413C") ; <CJK>
       (?$(J3g(B . "0x413B") ; <CJK>
       (?$(J3h(B . "0x2579B") ; <CJK>
       (?$(J3i(B . "0x4142") ; <CJK>
       (?$(J3j(B . "0x4141") ; <CJK>
       (?$(J3k(B . "0x4143") ; <CJK>
       (?$(J3l(B . "0x257A9") ; <CJK>
       (?$(J3m(B . "0x4145") ; <CJK>
       (?$(J3n(B . "0x25966") ; <CJK>
       (?$(J3o(B . "0x419A") ; <CJK>
       (?$(J3p(B . "0x419B") ; <CJK>
       (?$(J3q(B . "0x419F") ; <CJK>
       (?$(J3r(B . "0x419E") ; <CJK>
       (?$(J3s(B . "0x25A72") ; <CJK>
       (?$(J3t(B . "0x25A76") ; <CJK>
       (?$(J3u(B . "0x25B14") ; <CJK>
       (?$(J3v(B . "0x41DE") ; <CJK>
       (?$(J3w(B . "0x41E2") ; <CJK>
       (?$(J3x(B . "0x41E6") ; <CJK>
       (?$(J3y(B . "0x25B0F") ; <CJK>
       (?$(J3z(B . "0x7B29") ; <CJK>
       (?$(J3{(B . "0x41E3") ; <CJK>
       (?$(J3|(B . "0x7B27") ; <CJK>
       (?$(J3}(B . "0x41DF") ; <CJK>
       (?$(J3~(B . "0x25E41") ; <CJK>
       (?$(J4!(B . "0x25E46") ; <CJK>
       (?$(J4"(B . "0x7C9D") ; <CJK>
       (?$(J4#(B . "0x25E4B") ; <CJK>
       (?$(J4$(B . "0x25E43") ; <CJK>
       (?$(J4%(B . "0x427E") ; <CJK>
       (?$(J4&(B . "0x42C9") ; <CJK>
       (?$(J4'(B . "0x42CC") ; <CJK>
       (?$(J4((B . "0x25FC6") ; <CJK>
       (?$(J4)(B . "0x42D1") ; <CJK>
       (?$(J4*(B . "0x25FC7") ; <CJK>
       (?$(J4+(B . "0x42D0") ; <CJK>
       (?$(J4,(B . "0x25FCE") ; <CJK>
       (?$(J4-(B . "0x42CF") ; <CJK>
       (?$(J4.(B . "0x42C8") ; <CJK>
       (?$(J4/(B . "0x25FC9") ; <CJK>
       (?$(J40(B . "0x42CD") ; <CJK>
       (?$(J41(B . "0x25FCB") ; <CJK>
       (?$(J42(B . "0x25FC5") ; <CJK>
       (?$(J43(B . "0x4349") ; <CJK>
       (?$(J44(B . "0x4347") ; <CJK>
       (?$(J45(B . "0x4358") ; <CJK>
       (?$(J46(B . "0x436B") ; <CJK>
       (?$(J47(B . "0x436C") ; <CJK>
       (?$(J48(B . "0x436A") ; <CJK>
       (?$(J49(B . "0x26369") ; <CJK>
       (?$(J4:(B . "0x4380") ; <CJK>
       (?$(J4;(B . "0x4382") ; <CJK>
       (?$(J4<(B . "0x4384") ; <CJK>
       (?$(J4=(B . "0x7FC8") ; <CJK>
       (?$(J4>(B . "0x4383") ; <CJK>
       (?$(J4?(B . "0x2641E") ; <CJK>
       (?$(J4@(B . "0x264BA") ; <CJK>
       (?$(J4A(B . "0x43B6") ; <CJK>
       (?$(J4B(B . "0x26552") ; <CJK>
       (?$(J4C(B . "0x26551") ; <CJK>
       (?$(J4D(B . "0x26553") ; <CJK>
       (?$(J4E(B . "0x2669F") ; <CJK>
       (?$(J4F(B . "0x266DB") ; <CJK>
       (?$(J4G(B . "0x8126") ; <CJK>
       (?$(J4H(B . "0x43F1") ; <CJK>
       (?$(J4I(B . "0x266E3") ; <CJK>
       (?$(J4J(B . "0x43F6") ; <CJK>
       (?$(J4K(B . "0x43F3") ; <CJK>
       (?$(J4L(B . "0x43F0") ; <CJK>
       (?$(J4M(B . "0x811C") ; <CJK>
       (?$(J4N(B . "0x266D7") ; <CJK>
       (?$(J4O(B . "0x266E9") ; <CJK>
       (?$(J4P(B . "0x8128") ; <CJK>
       (?$(J4Q(B . "0x43F5") ; <CJK>
       (?$(J4R(B . "0x43F4") ; <CJK>
       (?$(J4S(B . "0x43F7") ; <CJK>
       (?$(J4T(B . "0x266DE") ; <CJK>
       (?$(J4U(B . "0x266DC") ; <CJK>
       (?$(J4V(B . "0x2693C") ; <CJK>
       (?$(J4W(B . "0x2F98B") ; <CJK>
       (?$(J4X(B . "0x4455") ; <CJK>
       (?$(J4Y(B . "0x26A22") ; <CJK>
       (?$(J4Z(B . "0x26A32") ; <CJK>
       (?$(J4[(B . "0x26A23") ; <CJK>
       (?$(J4\(B . "0x448B") ; <CJK>
       (?$(J4](B . "0x44CB") ; <CJK>
       (?$(J4^(B . "0x44C2") ; <CJK>
       (?$(J4_(B . "0x26BD4") ; <CJK>
       (?$(J4`(B . "0x26BC8") ; <CJK>
       (?$(J4a(B . "0x26BBC") ; <CJK>
       (?$(J4b(B . "0x44CA") ; <CJK>
       (?$(J4c(B . "0x44CC") ; <CJK>
       (?$(J4d(B . "0x26BCD") ; <CJK>
       (?$(J4e(B . "0x44C7") ; <CJK>
       (?$(J4f(B . "0x44C9") ; <CJK>
       (?$(J4g(B . "0x8370") ; <CJK>
       (?$(J4h(B . "0x26BBE") ; <CJK>
       (?$(J4i(B . "0x44C6") ; <CJK>
       (?$(J4j(B . "0x26C40") ; <CJK>
       (?$(J4k(B . "0x26BD6") ; <CJK>
       (?$(J4l(B . "0x44C3") ; <CJK>
       (?$(J4m(B . "0x8382") ; <CJK>
       (?$(J4n(B . "0x26BBD") ; <CJK>
       (?$(J4o(B . "0x83AC") ; <CJK>
       (?$(J4p(B . "0x26BBA") ; <CJK>
       (?$(J4q(B . "0x44C4") ; <CJK>
       (?$(J4r(B . "0x26BC0") ; <CJK>
       (?$(J4s(B . "0x2F99B") ; <CJK>
       (?$(J4t(B . "0x2F99D") ; <CJK>
       (?$(J4u(B . "0x26BC1") ; <CJK>
       (?$(J4v(B . "0x271A6") ; <CJK>
       (?$(J4w(B . "0x271A5") ; <CJK>
       (?$(J4x(B . "0x271A8") ; <CJK>
       (?$(J4y(B . "0x45A9") ; <CJK>
       (?$(J4z(B . "0x86AD") ; <CJK>
       (?$(J4{(B . "0x45A8") ; <CJK>
       (?$(J4|(B . "0x45A6") ; <CJK>
       (?$(J4}(B . "0x2725F") ; <CJK>
       (?$(J4~(B . "0x27270") ; <CJK>
       (?$(J5!(B . "0x2726A") ; <CJK>
       (?$(J5"(B . "0x27265") ; <CJK>
       (?$(J5#(B . "0x27267") ; <CJK>
       (?$(J5$(B . "0x2726F") ; <CJK>
       (?$(J5%(B . "0x27287") ; <CJK>
       (?$(J5&(B . "0x86CA") ; <CJK>
       (?$(J5'(B . "0x8851") ; <CJK>
       (?$(J5((B . "0x2763D") ; <CJK>
       (?$(J5)(B . "0x27643") ; <CJK>
       (?$(J5*(B . "0x4622") ; <CJK>
       (?$(J5+(B . "0x27640") ; <CJK>
       (?$(J5,(B . "0x4626") ; <CJK>
       (?$(J5-(B . "0x4624") ; <CJK>
       (?$(J5.(B . "0x4625") ; <CJK>
       (?$(J5/(B . "0x889D") ; <CJK>
       (?$(J50(B . "0x462A") ; <CJK>
       (?$(J51(B . "0x4674") ; <CJK>
       (?$(J52(B . "0x27818") ; <CJK>
       (?$(J53(B . "0x4679") ; <CJK>
       (?$(J54(B . "0x8990") ; <CJK>
       (?$(J55(B . "0x467A") ; <CJK>
       (?$(J56(B . "0x27819") ; <CJK>
       (?$(J57(B . "0x278C1") ; <CJK>
       (?$(J58(B . "0x89D8") ; <CJK>
       (?$(J59(B . "0x89D7") ; <CJK>
       (?$(J5:(B . "0x4697") ; <CJK>
       (?$(J5;(B . "0x278BC") ; <CJK>
       (?$(J5<(B . "0x278C8") ; <CJK>
       (?$(J5=(B . "0x8A2E") ; <CJK>
       (?$(J5>(B . "0x27971") ; <CJK>
       (?$(J5?(B . "0x46BC") ; <CJK>
       (?$(J5@(B . "0x2796E") ; <CJK>
       (?$(J5A(B . "0x46B3") ; <CJK>
       (?$(J5B(B . "0x27978") ; <CJK>
       (?$(J5C(B . "0x46BF") ; <CJK>
       (?$(J5D(B . "0x46B7") ; <CJK>
       (?$(J5E(B . "0x2F9CD") ; <CJK>
       (?$(J5F(B . "0x2797A") ; <CJK>
       (?$(J5G(B . "0x27BB1") ; <CJK>
       (?$(J5H(B . "0x27BAF") ; <CJK>
       (?$(J5I(B . "0x27BB0") ; <CJK>
       (?$(J5J(B . "0x4734") ; <CJK>
       (?$(J5K(B . "0x4746") ; <CJK>
       (?$(J5L(B . "0x4748") ; <CJK>
       (?$(J5M(B . "0x8C59") ; <CJK>
       (?$(J5N(B . "0x27CA8") ; <CJK>
       (?$(J5O(B . "0x27CA6") ; <CJK>
       (?$(J5P(B . "0x4756") ; <CJK>
       (?$(J5Q(B . "0x4767") ; <CJK>
       (?$(J5R(B . "0x27D48") ; <CJK>
       (?$(J5S(B . "0x27D45") ; <CJK>
       (?$(J5T(B . "0x4768") ; <CJK>
       (?$(J5U(B . "0x4799") ; <CJK>
       (?$(J5V(B . "0x479A") ; <CJK>
       (?$(J5W(B . "0x27EA0") ; <CJK>
       (?$(J5X(B . "0x27EA4") ; <CJK>
       (?$(J5Y(B . "0x47D8") ; <CJK>
       (?$(J5Z(B . "0x27FD4") ; <CJK>
       (?$(J5[(B . "0x47DB") ; <CJK>
       (?$(J5\(B . "0x47DC") ; <CJK>
       (?$(J5](B . "0x47DD") ; <CJK>
       (?$(J5^(B . "0x47D7") ; <CJK>
       (?$(J5_(B . "0x27FD2") ; <CJK>
       (?$(J5`(B . "0x28222") ; <CJK>
       (?$(J5a(B . "0x4849") ; <CJK>
       (?$(J5b(B . "0x484A") ; <CJK>
       (?$(J5c(B . "0x8EDA") ; <CJK>
       (?$(J5d(B . "0x282B7") ; <CJK>
       (?$(J5e(B . "0x282CC") ; <CJK>
       (?$(J5f(B . "0x9033") ; <CJK>
       (?$(J5g(B . "0x284E6") ; <CJK>
       (?$(J5h(B . "0x9018") ; <CJK>
       (?$(J5i(B . "0x489A") ; <CJK>
       (?$(J5j(B . "0x284C8") ; <CJK>
       (?$(J5k(B . "0x48CD") ; <CJK>
       (?$(J5l(B . "0x48CA") ; <CJK>
       (?$(J5m(B . "0x286F4") ; <CJK>
       (?$(J5n(B . "0x48CB") ; <CJK>
       (?$(J5o(B . "0x286ED") ; <CJK>
       (?$(J5p(B . "0x48CF") ; <CJK>
       (?$(J5q(B . "0x2867E") ; <CJK>
       (?$(J5r(B . "0x2F9E3") ; <CJK>
       (?$(J5s(B . "0x48CC") ; <CJK>
       (?$(J5t(B . "0x48EA") ; <CJK>
       (?$(J5u(B . "0x48ED") ; <CJK>
       (?$(J5v(B . "0x287F9") ; <CJK>
       (?$(J5w(B . "0x287FD") ; <CJK>
       (?$(J5x(B . "0x48E9") ; <CJK>
       (?$(J5y(B . "0x28807") ; <CJK>
       (?$(J5z(B . "0x491A") ; <CJK>
       (?$(J5{(B . "0x91EF") ; <CJK>
       (?$(J5|(B . "0x498D") ; <CJK>
       (?$(J5}(B . "0x49D2") ; <CJK>
       (?$(J5~(B . "0x28E78") ; <CJK>
       (?$(J6!(B . "0x28E7A") ; <CJK>
       (?$(J6"(B . "0x28E79") ; <CJK>
       (?$(J6#(B . "0x28F8A") ; <CJK>
       (?$(J6$(B . "0x49F2") ; <CJK>
       (?$(J6%(B . "0x2907B") ; <CJK>
       (?$(J6&(B . "0x291D5") ; <CJK>
       (?$(J6'(B . "0x291E9") ; <CJK>
       (?$(J6((B . "0x4A3D") ; <CJK>
       (?$(J6)(B . "0x291EB") ; <CJK>
       (?$(J6*(B . "0x4A3E") ; <CJK>
       (?$(J6+(B . "0x4AF8") ; <CJK>
       (?$(J6,(B . "0x4B23") ; <CJK>
       (?$(J6-(B . "0x9AD9") ; <CJK>
       (?$(J6.(B . "0x4EB4") ; <CJK>
       (?$(J6/(B . "0x2016C") ; <CJK>
       (?$(J60(B . "0x50A0") ; <CJK>
       (?$(J61(B . "0x5090") ; <CJK>
       (?$(J62(B . "0x3475") ; <CJK>
       (?$(J63(B . "0x5086") ; <CJK>
       (?$(J64(B . "0x5084") ; <CJK>
       (?$(J65(B . "0x202FA") ; <CJK>
       (?$(J66(B . "0x508A") ; <CJK>
       (?$(J67(B . "0x3476") ; <CJK>
       (?$(J68(B . "0x3473") ; <CJK>
       (?$(J69(B . "0x509F") ; <CJK>
       (?$(J6:(B . "0x50A1") ; <CJK>
       (?$(J6;(B . "0x20318") ; <CJK>
       (?$(J6<(B . "0x5093") ; <CJK>
       (?$(J6=(B . "0x34BD") ; <CJK>
       (?$(J6>(B . "0x205F6") ; <CJK>
       (?$(J6?(B . "0x51D5") ; <CJK>
       (?$(J6@(B . "0x2078A") ; <CJK>
       (?$(J6A(B . "0x20789") ; <CJK>
       (?$(J6B(B . "0x34F9") ; <CJK>
       (?$(J6C(B . "0x2077F") ; <CJK>
       (?$(J6D(B . "0x20788") ; <CJK>
       (?$(J6E(B . "0x34FA") ; <CJK>
       (?$(J6F(B . "0x20783") ; <CJK>
       (?$(J6G(B . "0x20784") ; <CJK>
       (?$(J6H(B . "0x20798") ; <CJK>
       (?$(J6I(B . "0x20763") ; <CJK>
       (?$(J6J(B . "0x20787") ; <CJK>
       (?$(J6K(B . "0x3521") ; <CJK>
       (?$(J6L(B . "0x2F827") ; <CJK>
       (?$(J6M(B . "0x3529") ; <CJK>
       (?$(J6N(B . "0x208F5") ; <CJK>
       (?$(J6O(B . "0x20950") ; <CJK>
       (?$(J6P(B . "0x3538") ; <CJK>
       (?$(J6Q(B . "0x354E") ; <CJK>
       (?$(J6R(B . "0x20A87") ; <CJK>
       (?$(J6S(B . "0x20A8A") ; <CJK>
       (?$(J6T(B . "0x20B65") ; <CJK>
       (?$(J6U(B . "0x20DB7") ; <CJK>
       (?$(J6V(B . "0x20DC1") ; <CJK>
       (?$(J6W(B . "0x20DC7") ; <CJK>
       (?$(J6X(B . "0x35C8") ; <CJK>
       (?$(J6Y(B . "0x35BC") ; <CJK>
       (?$(J6Z(B . "0x20DC5") ; <CJK>
       (?$(J6[(B . "0x20DCB") ; <CJK>
       (?$(J6\(B . "0x5590") ; <CJK>
       (?$(J6](B . "0x20DD1") ; <CJK>
       (?$(J6^(B . "0x35BB") ; <CJK>
       (?$(J6_(B . "0x35C2") ; <CJK>
       (?$(J6`(B . "0x35C0") ; <CJK>
       (?$(J6a(B . "0x20DB8") ; <CJK>
       (?$(J6b(B . "0x20DCA") ; <CJK>
       (?$(J6c(B . "0x35CA") ; <CJK>
       (?$(J6d(B . "0x20DDE") ; <CJK>
       (?$(J6e(B . "0x35C9") ; <CJK>
       (?$(J6f(B . "0x20DCE") ; <CJK>
       (?$(J6g(B . "0x35B8") ; <CJK>
       (?$(J6h(B . "0x5710") ; <CJK>
       (?$(J6i(B . "0x5817") ; <CJK>
       (?$(J6j(B . "0x21368") ; <CJK>
       (?$(J6k(B . "0x364E") ; <CJK>
       (?$(J6l(B . "0x2136B") ; <CJK>
       (?$(J6m(B . "0x5844") ; <CJK>
       (?$(J6n(B . "0x3650") ; <CJK>
       (?$(J6o(B . "0x582B") ; <CJK>
       (?$(J6p(B . "0x2136A") ; <CJK>
       (?$(J6q(B . "0x5845") ; <CJK>
       (?$(J6r(B . "0x21366") ; <CJK>
       (?$(J6s(B . "0x21377") ; <CJK>
       (?$(J6t(B . "0x21396") ; <CJK>
       (?$(J6u(B . "0x2136E") ; <CJK>
       (?$(J6v(B . "0x2F856") ; <CJK>
       (?$(J6w(B . "0x368A") ; <CJK>
       (?$(J6x(B . "0x21657") ; <CJK>
       (?$(J6y(B . "0x5965") ; <CJK>
       (?$(J6z(B . "0x21656") ; <CJK>
       (?$(J6{(B . "0x2179C") ; <CJK>
       (?$(J6|(B . "0x2179E") ; <CJK>
       (?$(J6}(B . "0x36FC") ; <CJK>
       (?$(J6~(B . "0x36F9") ; <CJK>
       (?$(J7!(B . "0x217A1") ; <CJK>
       (?$(J7"(B . "0x3763") ; <CJK>
       (?$(J7#(B . "0x21A42") ; <CJK>
       (?$(J7$(B . "0x5BCF") ; <CJK>
       (?$(J7%(B . "0x21A46") ; <CJK>
       (?$(J7&(B . "0x21A3E") ; <CJK>
       (?$(J7'(B . "0x21B33") ; <CJK>
       (?$(J7((B . "0x3787") ; <CJK>
       (?$(J7)(B . "0x3788") ; <CJK>
       (?$(J7*(B . "0x21BFA") ; <CJK>
       (?$(J7+(B . "0x379A") ; <CJK>
       (?$(J7,(B . "0x21C97") ; <CJK>
       (?$(J7-(B . "0x21C9B") ; <CJK>
       (?$(J7.(B . "0x21CAA") ; <CJK>
       (?$(J7/(B . "0x5D56") ; <CJK>
       (?$(J70(B . "0x21E73") ; <CJK>
       (?$(J71(B . "0x21E7C") ; <CJK>
       (?$(J72(B . "0x37E9") ; <CJK>
       (?$(J73(B . "0x21E86") ; <CJK>
       (?$(J74(B . "0x37EA") ; <CJK>
       (?$(J75(B . "0x5D54") ; <CJK>
       (?$(J76(B . "0x3850") ; <CJK>
       (?$(J77(B . "0x220F3") ; <CJK>
       (?$(J78(B . "0x220F0") ; <CJK>
       (?$(J79(B . "0x3856") ; <CJK>
       (?$(J7:(B . "0x3852") ; <CJK>
       (?$(J7;(B . "0x384F") ; <CJK>
       (?$(J7<(B . "0x3854") ; <CJK>
       (?$(J7=(B . "0x3851") ; <CJK>
       (?$(J7>(B . "0x220EC") ; <CJK>
       (?$(J7?(B . "0x222AF") ; <CJK>
       (?$(J7@(B . "0x388E") ; <CJK>
       (?$(J7A(B . "0x388F") ; <CJK>
       (?$(J7B(B . "0x22264") ; <CJK>
       (?$(J7C(B . "0x22268") ; <CJK>
       (?$(J7D(B . "0x2235A") ; <CJK>
       (?$(J7E(B . "0x5F3D") ; <CJK>
       (?$(J7F(B . "0x2251F") ; <CJK>
       (?$(J7G(B . "0x22525") ; <CJK>
       (?$(J7H(B . "0x38ED") ; <CJK>
       (?$(J7I(B . "0x38EB") ; <CJK>
       (?$(J7J(B . "0x5FA4") ; <CJK>
       (?$(J7K(B . "0x226C6") ; <CJK>
       (?$(J7L(B . "0x226D6") ; <CJK>
       (?$(J7M(B . "0x226C3") ; <CJK>
       (?$(J7N(B . "0x3962") ; <CJK>
       (?$(J7O(B . "0x2272C") ; <CJK>
       (?$(J7P(B . "0x395D") ; <CJK>
       (?$(J7Q(B . "0x2272E") ; <CJK>
       (?$(J7R(B . "0x2275E") ; <CJK>
       (?$(J7S(B . "0x22733") ; <CJK>
       (?$(J7T(B . "0x3961") ; <CJK>
       (?$(J7U(B . "0x3965") ; <CJK>
       (?$(J7V(B . "0x395C") ; <CJK>
       (?$(J7W(B . "0x2272D") ; <CJK>
       (?$(J7X(B . "0x22746") ; <CJK>
       (?$(J7Y(B . "0x395F") ; <CJK>
       (?$(J7Z(B . "0x226C1") ; <CJK>
       (?$(J7[(B . "0x2273A") ; <CJK>
       (?$(J7\(B . "0x229CC") ; <CJK>
       (?$(J7](B . "0x22B9D") ; <CJK>
       (?$(J7^(B . "0x22B83") ; <CJK>
       (?$(J7_(B . "0x22BF6") ; <CJK>
       (?$(J7`(B . "0x63EC") ; <CJK>
       (?$(J7a(B . "0x3A16") ; <CJK>
       (?$(J7b(B . "0x3A0A") ; <CJK>
       (?$(J7c(B . "0x22BF8") ; <CJK>
       (?$(J7d(B . "0x3A0E") ; <CJK>
       (?$(J7e(B . "0x3A12") ; <CJK>
       (?$(J7f(B . "0x22BFE") ; <CJK>
       (?$(J7g(B . "0x22BF3") ; <CJK>
       (?$(J7h(B . "0x3A11") ; <CJK>
       (?$(J7i(B . "0x22BEB") ; <CJK>
       (?$(J7j(B . "0x22BFA") ; <CJK>
       (?$(J7k(B . "0x3A10") ; <CJK>
       (?$(J7l(B . "0x22C07") ; <CJK>
       (?$(J7m(B . "0x22BFC") ; <CJK>
       (?$(J7n(B . "0x3A09") ; <CJK>
       (?$(J7o(B . "0x63FA") ; <CJK>
       (?$(J7p(B . "0x3A15") ; <CJK>
       (?$(J7q(B . "0x63D4") ; <CJK>
       (?$(J7r(B . "0x22F72") ; <CJK>
       (?$(J7s(B . "0x22F73") ; <CJK>
       (?$(J7t(B . "0x22F74") ; <CJK>
       (?$(J7u(B . "0x3A91") ; <CJK>
       (?$(J7v(B . "0x3A95") ; <CJK>
       (?$(J7w(B . "0x3A93") ; <CJK>
       (?$(J7x(B . "0x3A92") ; <CJK>
       (?$(J7y(B . "0x3A8F") ; <CJK>
       (?$(J7z(B . "0x22F5F") ; <CJK>
       (?$(J7{(B . "0x22F60") ; <CJK>
       (?$(J7|(B . "0x230AA") ; <CJK>
       (?$(J7}(B . "0x23134") ; <CJK>
       (?$(J7~(B . "0x3AF6") ; <CJK>
       (?$(J8!(B . "0x231B4") ; <CJK>
       (?$(J8"(B . "0x3AFB") ; <CJK>
       (?$(J8#(B . "0x231F0") ; <CJK>
       (?$(J8$(B . "0x6675") ; <CJK>
       (?$(J8%(B . "0x3AF9") ; <CJK>
       (?$(J8&(B . "0x2320D") ; <CJK>
       (?$(J8'(B . "0x231F3") ; <CJK>
       (?$(J8((B . "0x2320F") ; <CJK>
       (?$(J8)(B . "0x671C") ; <CJK>
       (?$(J8*(B . "0x3B7D") ; <CJK>
       (?$(J8+(B . "0x234C9") ; <CJK>
       (?$(J8,(B . "0x3B7A") ; <CJK>
       (?$(J8-(B . "0x3B7F") ; <CJK>
       (?$(J8.(B . "0x234C5") ; <CJK>
       (?$(J8/(B . "0x3B78") ; <CJK>
       (?$(J80(B . "0x234D7") ; <CJK>
       (?$(J81(B . "0x234CC") ; <CJK>
       (?$(J82(B . "0x68D9") ; <CJK>
       (?$(J83(B . "0x234E7") ; <CJK>
       (?$(J84(B . "0x3B70") ; <CJK>
       (?$(J85(B . "0x3B82") ; <CJK>
       (?$(J86(B . "0x234C1") ; <CJK>
       (?$(J87(B . "0x3B84") ; <CJK>
       (?$(J88(B . "0x234E8") ; <CJK>
       (?$(J89(B . "0x3C33") ; <CJK>
       (?$(J8:(B . "0x238CB") ; <CJK>
       (?$(J8;(B . "0x3C32") ; <CJK>
       (?$(J8<(B . "0x3C36") ; <CJK>
       (?$(J8=(B . "0x238C8") ; <CJK>
       (?$(J8>(B . "0x2397A") ; <CJK>
       (?$(J8?(B . "0x3C56") ; <CJK>
       (?$(J8@(B . "0x23979") ; <CJK>
       (?$(J8A(B . "0x2397E") ; <CJK>
       (?$(J8B(B . "0x3C67") ; <CJK>
       (?$(J8C(B . "0x23A1B") ; <CJK>
       (?$(J8D(B . "0x3C65") ; <CJK>
       (?$(J8E(B . "0x3C64") ; <CJK>
       (?$(J8F(B . "0x3C66") ; <CJK>
       (?$(J8G(B . "0x23A1F") ; <CJK>
       (?$(J8H(B . "0x23A19") ; <CJK>
       (?$(J8I(B . "0x3C81") ; <CJK>
       (?$(J8J(B . "0x3C82") ; <CJK>
       (?$(J8K(B . "0x3C83") ; <CJK>
       (?$(J8L(B . "0x3C9E") ; <CJK>
       (?$(J8M(B . "0x23B89") ; <CJK>
       (?$(J8N(B . "0x6BF1") ; <CJK>
       (?$(J8O(B . "0x3C9D") ; <CJK>
       (?$(J8P(B . "0x23B8B") ; <CJK>
       (?$(J8Q(B . "0x3D0F") ; <CJK>
       (?$(J8R(B . "0x3D12") ; <CJK>
       (?$(J8S(B . "0x23E09") ; <CJK>
       (?$(J8T(B . "0x23DFE") ; <CJK>
       (?$(J8U(B . "0x23E00") ; <CJK>
       (?$(J8V(B . "0x3D10") ; <CJK>
       (?$(J8W(B . "0x3D18") ; <CJK>
       (?$(J8X(B . "0x23E0B") ; <CJK>
       (?$(J8Y(B . "0x3D14") ; <CJK>
       (?$(J8Z(B . "0x3D19") ; <CJK>
       (?$(J8[(B . "0x6E37") ; <CJK>
       (?$(J8\(B . "0x6E7C") ; <CJK>
       (?$(J8](B . "0x23E4A") ; <CJK>
       (?$(J8^(B . "0x6E7D") ; <CJK>
       (?$(J8_(B . "0x6E86") ; <CJK>
       (?$(J8`(B . "0x3DC8") ; <CJK>
       (?$(J8a(B . "0x3DC4") ; <CJK>
       (?$(J8b(B . "0x3DC6") ; <CJK>
       (?$(J8c(B . "0x24279") ; <CJK>
       (?$(J8d(B . "0x3DC7") ; <CJK>
       (?$(J8e(B . "0x3DC3") ; <CJK>
       (?$(J8f(B . "0x2426C") ; <CJK>
       (?$(J8g(B . "0x24299") ; <CJK>
       (?$(J8h(B . "0x2F91B") ; <CJK>
       (?$(J8i(B . "0x24262") ; <CJK>
       (?$(J8j(B . "0x24514") ; <CJK>
       (?$(J8k(B . "0x3E19") ; <CJK>
       (?$(J8l(B . "0x3E1C") ; <CJK>
       (?$(J8m(B . "0x245C8") ; <CJK>
       (?$(J8n(B . "0x245D7") ; <CJK>
       (?$(J8o(B . "0x2460C") ; <CJK>
       (?$(J8p(B . "0x3E41") ; <CJK>
       (?$(J8q(B . "0x24670") ; <CJK>
       (?$(J8r(B . "0x3E42") ; <CJK>
       (?$(J8s(B . "0x3E43") ; <CJK>
       (?$(J8t(B . "0x24671") ; <CJK>
       (?$(J8u(B . "0x247DF") ; <CJK>
       (?$(J8v(B . "0x247E4") ; <CJK>
       (?$(J8w(B . "0x3E82") ; <CJK>
       (?$(J8x(B . "0x247E7") ; <CJK>
       (?$(J8y(B . "0x3E81") ; <CJK>
       (?$(J8z(B . "0x3E94") ; <CJK>
       (?$(J8{(B . "0x3E84") ; <CJK>
       (?$(J8|(B . "0x24990") ; <CJK>
       (?$(J8}(B . "0x3ED2") ; <CJK>
       (?$(J8~(B . "0x3F0F") ; <CJK>
       (?$(J9!(B . "0x3F22") ; <CJK>
       (?$(J9"(B . "0x24B4C") ; <CJK>
       (?$(J9#(B . "0x3F27") ; <CJK>
       (?$(J9$(B . "0x3F2A") ; <CJK>
       (?$(J9%(B . "0x74FA") ; <CJK>
       (?$(J9&(B . "0x3F28") ; <CJK>
       (?$(J9'(B . "0x24B4F") ; <CJK>
       (?$(J9((B . "0x3F60") ; <CJK>
       (?$(J9)(B . "0x24C7D") ; <CJK>
       (?$(J9*(B . "0x24C7E") ; <CJK>
       (?$(J9+(B . "0x24C7C") ; <CJK>
       (?$(J9,(B . "0x7572") ; <CJK>
       (?$(J9-(B . "0x24C8D") ; <CJK>
       (?$(J9.(B . "0x24D19") ; <CJK>
       (?$(J9/(B . "0x3F9B") ; <CJK>
       (?$(J90(B . "0x3F9C") ; <CJK>
       (?$(J91(B . "0x24DC0") ; <CJK>
       (?$(J92(B . "0x3F93") ; <CJK>
       (?$(J93(B . "0x3F94") ; <CJK>
       (?$(J94(B . "0x75DC") ; <CJK>
       (?$(J95(B . "0x3FA0") ; <CJK>
       (?$(J96(B . "0x3F99") ; <CJK>
       (?$(J97(B . "0x24DB6") ; <CJK>
       (?$(J98(B . "0x3FA1") ; <CJK>
       (?$(J99(B . "0x24DA8") ; <CJK>
       (?$(J9:(B . "0x3FF1") ; <CJK>
       (?$(J9;(B . "0x24FEB") ; <CJK>
       (?$(J9<(B . "0x24FE7") ; <CJK>
       (?$(J9=(B . "0x2506F") ; <CJK>
       (?$(J9>(B . "0x251C7") ; <CJK>
       (?$(J9?(B . "0x4036") ; <CJK>
       (?$(J9@(B . "0x2519F") ; <CJK>
       (?$(J9A(B . "0x4037") ; <CJK>
       (?$(J9B(B . "0x403F") ; <CJK>
       (?$(J9C(B . "0x403C") ; <CJK>
       (?$(J9D(B . "0x251C4") ; <CJK>
       (?$(J9E(B . "0x4034") ; <CJK>
       (?$(J9F(B . "0x4039") ; <CJK>
       (?$(J9G(B . "0x403B") ; <CJK>
       (?$(J9H(B . "0x4035") ; <CJK>
       (?$(J9I(B . "0x4030") ; <CJK>
       (?$(J9J(B . "0x4032") ; <CJK>
       (?$(J9K(B . "0x4038") ; <CJK>
       (?$(J9L(B . "0x403E") ; <CJK>
       (?$(J9M(B . "0x403A") ; <CJK>
       (?$(J9N(B . "0x2519B") ; <CJK>
       (?$(J9O(B . "0x25197") ; <CJK>
       (?$(J9P(B . "0x251C5") ; <CJK>
       (?$(J9Q(B . "0x2536B") ; <CJK>
       (?$(J9R(B . "0x253CE") ; <CJK>
       (?$(J9S(B . "0x40B6") ; <CJK>
       (?$(J9T(B . "0x7867") ; <CJK>
       (?$(J9U(B . "0x254B1") ; <CJK>
       (?$(J9V(B . "0x254AE") ; <CJK>
       (?$(J9W(B . "0x254B0") ; <CJK>
       (?$(J9X(B . "0x40B3") ; <CJK>
       (?$(J9Y(B . "0x4109") ; <CJK>
       (?$(J9Z(B . "0x7977") ; <CJK>
       (?$(J9[(B . "0x2573E") ; <CJK>
       (?$(J9\(B . "0x257B5") ; <CJK>
       (?$(J9](B . "0x257BA") ; <CJK>
       (?$(J9^(B . "0x414C") ; <CJK>
       (?$(J9_(B . "0x257B2") ; <CJK>
       (?$(J9`(B . "0x257B4") ; <CJK>
       (?$(J9a(B . "0x4153") ; <CJK>
       (?$(J9b(B . "0x414D") ; <CJK>
       (?$(J9c(B . "0x4151") ; <CJK>
       (?$(J9d(B . "0x414F") ; <CJK>
       (?$(J9e(B . "0x7A9B") ; <CJK>
       (?$(J9f(B . "0x25977") ; <CJK>
       (?$(J9g(B . "0x41A2") ; <CJK>
       (?$(J9h(B . "0x25986") ; <CJK>
       (?$(J9i(B . "0x2597B") ; <CJK>
       (?$(J9j(B . "0x41CD") ; <CJK>
       (?$(J9k(B . "0x25A7E") ; <CJK>
       (?$(J9l(B . "0x25B2E") ; <CJK>
       (?$(J9m(B . "0x41E7") ; <CJK>
       (?$(J9n(B . "0x25B2F") ; <CJK>
       (?$(J9o(B . "0x41F0") ; <CJK>
       (?$(J9p(B . "0x25B37") ; <CJK>
       (?$(J9q(B . "0x41E9") ; <CJK>
       (?$(J9r(B . "0x41EC") ; <CJK>
       (?$(J9s(B . "0x25B32") ; <CJK>
       (?$(J9t(B . "0x41E8") ; <CJK>
       (?$(J9u(B . "0x41EE") ; <CJK>
       (?$(J9v(B . "0x4202") ; <CJK>
       (?$(J9w(B . "0x25B36") ; <CJK>
       (?$(J9x(B . "0x25B39") ; <CJK>
       (?$(J9y(B . "0x25B35") ; <CJK>
       (?$(J9z(B . "0x25E5C") ; <CJK>
       (?$(J9{(B . "0x4282") ; <CJK>
       (?$(J9|(B . "0x4283") ; <CJK>
       (?$(J9}(B . "0x4286") ; <CJK>
       (?$(J9~(B . "0x25E7B") ; <CJK>
       (?$(J:!(B . "0x25E61") ; <CJK>
       (?$(J:"(B . "0x25FEE") ; <CJK>
       (?$(J:#(B . "0x25FEB") ; <CJK>
       (?$(J:$(B . "0x25FEF") ; <CJK>
       (?$(J:%(B . "0x26020") ; <CJK>
       (?$(J:&(B . "0x7D2A") ; <CJK>
       (?$(J:'(B . "0x7D65") ; <CJK>
       (?$(J:((B . "0x434A") ; <CJK>
       (?$(J:)(B . "0x26230") ; <CJK>
       (?$(J:*(B . "0x435A") ; <CJK>
       (?$(J:+(B . "0x7F64") ; <CJK>
       (?$(J:,(B . "0x262BE") ; <CJK>
       (?$(J:-(B . "0x436E") ; <CJK>
       (?$(J:.(B . "0x26367") ; <CJK>
       (?$(J:/(B . "0x2637C") ; <CJK>
       (?$(J:0(B . "0x4370") ; <CJK>
       (?$(J:1(B . "0x436F") ; <CJK>
       (?$(J:2(B . "0x26424") ; <CJK>
       (?$(J:3(B . "0x438A") ; <CJK>
       (?$(J:4(B . "0x4387") ; <CJK>
       (?$(J:5(B . "0x4388") ; <CJK>
       (?$(J:6(B . "0x26429") ; <CJK>
       (?$(J:7(B . "0x264EF") ; <CJK>
       (?$(J:8(B . "0x8020") ; <CJK>
       (?$(J:9(B . "0x43B7") ; <CJK>
       (?$(J::(B . "0x43FD") ; <CJK>
       (?$(J:;(B . "0x8120") ; <CJK>
       (?$(J:<(B . "0x2670D") ; <CJK>
       (?$(J:=(B . "0x4405") ; <CJK>
       (?$(J:>(B . "0x813C") ; <CJK>
       (?$(J:?(B . "0x4408") ; <CJK>
       (?$(J:@(B . "0x4403") ; <CJK>
       (?$(J:A(B . "0x4402") ; <CJK>
       (?$(J:B(B . "0x4404") ; <CJK>
       (?$(J:C(B . "0x3B39") ; <CJK>
       (?$(J:D(B . "0x4409") ; <CJK>
       (?$(J:E(B . "0x43FF") ; <CJK>
       (?$(J:F(B . "0x26764") ; <CJK>
       (?$(J:G(B . "0x813F") ; <CJK>
       (?$(J:H(B . "0x26715") ; <CJK>
       (?$(J:I(B . "0x43FC") ; <CJK>
       (?$(J:J(B . "0x4401") ; <CJK>
       (?$(J:K(B . "0x440A") ; <CJK>
       (?$(J:L(B . "0x81F0") ; <CJK>
       (?$(J:M(B . "0x81F5") ; <CJK>
       (?$(J:N(B . "0x446B") ; <CJK>
       (?$(J:O(B . "0x446C") ; <CJK>
       (?$(J:P(B . "0x26A35") ; <CJK>
       (?$(J:Q(B . "0x26A36") ; <CJK>
       (?$(J:R(B . "0x26A34") ; <CJK>
       (?$(J:S(B . "0x26A37") ; <CJK>
       (?$(J:T(B . "0x26C47") ; <CJK>
       (?$(J:U(B . "0x26C2B") ; <CJK>
       (?$(J:V(B . "0x44DE") ; <CJK>
       (?$(J:W(B . "0x26C41") ; <CJK>
       (?$(J:X(B . "0x26C43") ; <CJK>
       (?$(J:Y(B . "0x44DB") ; <CJK>
       (?$(J:Z(B . "0x26C42") ; <CJK>
       (?$(J:[(B . "0x44DD") ; <CJK>
       (?$(J:\(B . "0x44E3") ; <CJK>
       (?$(J:](B . "0x26C32") ; <CJK>
       (?$(J:^(B . "0x44E0") ; <CJK>
       (?$(J:_(B . "0x44D9") ; <CJK>
       (?$(J:`(B . "0x44D8") ; <CJK>
       (?$(J:a(B . "0x44E4") ; <CJK>
       (?$(J:b(B . "0x26C44") ; <CJK>
       (?$(J:c(B . "0x26C4A") ; <CJK>
       (?$(J:d(B . "0x44DA") ; <CJK>
       (?$(J:e(B . "0x44EF") ; <CJK>
       (?$(J:f(B . "0x2F9A0") ; <CJK>
       (?$(J:g(B . "0x8415") ; <CJK>
       (?$(J:h(B . "0x83BE") ; <CJK>
       (?$(J:i(B . "0x26C54") ; <CJK>
       (?$(J:j(B . "0x26C6E") ; <CJK>
       (?$(J:k(B . "0x26C52") ; <CJK>
       (?$(J:l(B . "0x44D7") ; <CJK>
       (?$(J:m(B . "0x45B3") ; <CJK>
       (?$(J:n(B . "0x45BB") ; <CJK>
       (?$(J:o(B . "0x86E5") ; <CJK>
       (?$(J:p(B . "0x45B2") ; <CJK>
       (?$(J:q(B . "0x86D2") ; <CJK>
       (?$(J:r(B . "0x45AD") ; <CJK>
       (?$(J:s(B . "0x27292") ; <CJK>
       (?$(J:t(B . "0x45AF") ; <CJK>
       (?$(J:u(B . "0x2F9B8") ; <CJK>
       (?$(J:v(B . "0x86E0") ; <CJK>
       (?$(J:w(B . "0x272BF") ; <CJK>
       (?$(J:x(B . "0x4616") ; <CJK>
       (?$(J:y(B . "0x4628") ; <CJK>
       (?$(J:z(B . "0x4623") ; <CJK>
       (?$(J:{(B . "0x88B3") ; <CJK>
       (?$(J:|(B . "0x27641") ; <CJK>
       (?$(J:}(B . "0x27669") ; <CJK>
       (?$(J:~(B . "0x27665") ; <CJK>
       (?$(J;!(B . "0x4675") ; <CJK>
       (?$(J;"(B . "0x467E") ; <CJK>
       (?$(J;#(B . "0x467C") ; <CJK>
       (?$(J;$(B . "0x27822") ; <CJK>
       (?$(J;%(B . "0x2781D") ; <CJK>
       (?$(J;&(B . "0x278D2") ; <CJK>
       (?$(J;'(B . "0x278DA") ; <CJK>
       (?$(J;((B . "0x278DB") ; <CJK>
       (?$(J;)(B . "0x46CE") ; <CJK>
       (?$(J;*(B . "0x46CD") ; <CJK>
       (?$(J;+(B . "0x46CF") ; <CJK>
       (?$(J;,(B . "0x8A53") ; <CJK>
       (?$(J;-(B . "0x279A4") ; <CJK>
       (?$(J;.(B . "0x2799E") ; <CJK>
       (?$(J;/(B . "0x8A37") ; <CJK>
       (?$(J;0(B . "0x8A47") ; <CJK>
       (?$(J;1(B . "0x8A5C") ; <CJK>
       (?$(J;2(B . "0x2799D") ; <CJK>
       (?$(J;3(B . "0x46C4") ; <CJK>
       (?$(J;4(B . "0x46CC") ; <CJK>
       (?$(J;5(B . "0x46C8") ; <CJK>
       (?$(J;6(B . "0x46C7") ; <CJK>
       (?$(J;7(B . "0x279AD") ; <CJK>
       (?$(J;8(B . "0x279A6") ; <CJK>
       (?$(J;9(B . "0x279A7") ; <CJK>
       (?$(J;:(B . "0x27BB3") ; <CJK>
       (?$(J;;(B . "0x27BE0") ; <CJK>
       (?$(J;<(B . "0x27C35") ; <CJK>
       (?$(J;=(B . "0x27C37") ; <CJK>
       (?$(J;>(B . "0x475A") ; <CJK>
       (?$(J;?(B . "0x476A") ; <CJK>
       (?$(J;@(B . "0x27D4A") ; <CJK>
       (?$(J;A(B . "0x476B") ; <CJK>
       (?$(J;B(B . "0x476D") ; <CJK>
       (?$(J;C(B . "0x476F") ; <CJK>
       (?$(J;D(B . "0x27E5E") ; <CJK>
       (?$(J;E(B . "0x479E") ; <CJK>
       (?$(J;F(B . "0x27EC0") ; <CJK>
       (?$(J;G(B . "0x47A4") ; <CJK>
       (?$(J;H(B . "0x47A3") ; <CJK>
       (?$(J;I(B . "0x47E4") ; <CJK>
       (?$(J;J(B . "0x47E8") ; <CJK>
       (?$(J;K(B . "0x47E9") ; <CJK>
       (?$(J;L(B . "0x47E0") ; <CJK>
       (?$(J;M(B . "0x47E3") ; <CJK>
       (?$(J;N(B . "0x27FF9") ; <CJK>
       (?$(J;O(B . "0x47EA") ; <CJK>
       (?$(J;P(B . "0x47E1") ; <CJK>
       (?$(J;Q(B . "0x47ED") ; <CJK>
       (?$(J;R(B . "0x4834") ; <CJK>
       (?$(J;S(B . "0x4835") ; <CJK>
       (?$(J;T(B . "0x4851") ; <CJK>
       (?$(J;U(B . "0x8EF0") ; <CJK>
       (?$(J;V(B . "0x284F0") ; <CJK>
       (?$(J;W(B . "0x489D") ; <CJK>
       (?$(J;X(B . "0x284F3") ; <CJK>
       (?$(J;Y(B . "0x2851B") ; <CJK>
       (?$(J;Z(B . "0x284F2") ; <CJK>
       (?$(J;[(B . "0x284FB") ; <CJK>
       (?$(J;\(B . "0x2871C") ; <CJK>
       (?$(J;](B . "0x28713") ; <CJK>
       (?$(J;^(B . "0x48D0") ; <CJK>
       (?$(J;_(B . "0x2870F") ; <CJK>
       (?$(J;`(B . "0x48EE") ; <CJK>
       (?$(J;a(B . "0x28816") ; <CJK>
       (?$(J;b(B . "0x28811") ; <CJK>
       (?$(J;c(B . "0x28812") ; <CJK>
       (?$(J;d(B . "0x48F2") ; <CJK>
       (?$(J;e(B . "0x2880E") ; <CJK>
       (?$(J;f(B . "0x921D") ; <CJK>
       (?$(J;g(B . "0x4988") ; <CJK>
       (?$(J;h(B . "0x28C67") ; <CJK>
       (?$(J;i(B . "0x28CF2") ; <CJK>
       (?$(J;j(B . "0x28CDA") ; <CJK>
       (?$(J;k(B . "0x498F") ; <CJK>
       (?$(J;l(B . "0x28CDC") ; <CJK>
       (?$(J;m(B . "0x49D8") ; <CJK>
       (?$(J;n(B . "0x28F94") ; <CJK>
       (?$(J;o(B . "0x28F9B") ; <CJK>
       (?$(J;p(B . "0x28F92") ; <CJK>
       (?$(J;q(B . "0x28F9A") ; <CJK>
       (?$(J;r(B . "0x29088") ; <CJK>
       (?$(J;s(B . "0x29086") ; <CJK>
       (?$(J;t(B . "0x4A3F") ; <CJK>
       (?$(J;u(B . "0x291EF") ; <CJK>
       (?$(J;v(B . "0x4A52") ; <CJK>
       (?$(J;w(B . "0x976B") ; <CJK>
       (?$(J;x(B . "0x2925E") ; <CJK>
       (?$(J;y(B . "0x4A50") ; <CJK>
       (?$(J;z(B . "0x29458") ; <CJK>
       (?$(J;{(B . "0x4AB1") ; <CJK>
       (?$(J;|(B . "0x29456") ; <CJK>
       (?$(J;}(B . "0x29454") ; <CJK>
       (?$(J;~(B . "0x4AF9") ; <CJK>
       (?$(J<!(B . "0x2959B") ; <CJK>
       (?$(J<"(B . "0x29696") ; <CJK>
       (?$(J<#(B . "0x296A4") ; <CJK>
       (?$(J<$(B . "0x4B26") ; <CJK>
       (?$(J<%(B . "0x4B28") ; <CJK>
       (?$(J<&(B . "0x2969A") ; <CJK>
       (?$(J<'(B . "0x29A12") ; <CJK>
       (?$(J<((B . "0x3480") ; <CJK>
       (?$(J<)(B . "0x50C0") ; <CJK>
       (?$(J<*(B . "0x3481") ; <CJK>
       (?$(J<+(B . "0x2036B") ; <CJK>
       (?$(J<,(B . "0x347E") ; <CJK>
       (?$(J<-(B . "0x347F") ; <CJK>
       (?$(J<.(B . "0x20337") ; <CJK>
       (?$(J</(B . "0x2033C") ; <CJK>
       (?$(J<0(B . "0x2F80A") ; <CJK>
       (?$(J<1(B . "0x204F7") ; <CJK>
       (?$(J<2(B . "0x34BE") ; <CJK>
       (?$(J<3(B . "0x20566") ; <CJK>
       (?$(J<4(B . "0x34D6") ; <CJK>
       (?$(J<5(B . "0x207A9") ; <CJK>
       (?$(J<6(B . "0x207AE") ; <CJK>
       (?$(J<7(B . "0x207AD") ; <CJK>
       (?$(J<8(B . "0x207C8") ; <CJK>
       (?$(J<9(B . "0x207A5") ; <CJK>
       (?$(J<:(B . "0x207B0") ; <CJK>
       (?$(J<;(B . "0x20895") ; <CJK>
       (?$(J<<(B . "0x52E5") ; <CJK>
       (?$(J<=(B . "0x20925") ; <CJK>
       (?$(J<>(B . "0x3534") ; <CJK>
       (?$(J<?(B . "0x20A99") ; <CJK>
       (?$(J<@(B . "0x53AF") ; <CJK>
       (?$(J<A(B . "0x20B74") ; <CJK>
       (?$(J<B(B . "0x20B70") ; <CJK>
       (?$(J<C(B . "0x20B6F") ; <CJK>
       (?$(J<D(B . "0x20E41") ; <CJK>
       (?$(J<E(B . "0x20E54") ; <CJK>
       (?$(J<F(B . "0x35D5") ; <CJK>
       (?$(J<G(B . "0x35D8") ; <CJK>
       (?$(J<H(B . "0x20E40") ; <CJK>
       (?$(J<I(B . "0x20E38") ; <CJK>
       (?$(J<J(B . "0x35D4") ; <CJK>
       (?$(J<K(B . "0x55D8") ; <CJK>
       (?$(J<L(B . "0x35D9") ; <CJK>
       (?$(J<M(B . "0x20E52") ; <CJK>
       (?$(J<N(B . "0x20E3A") ; <CJK>
       (?$(J<O(B . "0x20E57") ; <CJK>
       (?$(J<P(B . "0x2F84A") ; <CJK>
       (?$(J<Q(B . "0x20E59") ; <CJK>
       (?$(J<R(B . "0x5711") ; <CJK>
       (?$(J<S(B . "0x5867") ; <CJK>
       (?$(J<T(B . "0x213B4") ; <CJK>
       (?$(J<U(B . "0x213C0") ; <CJK>
       (?$(J<V(B . "0x365D") ; <CJK>
       (?$(J<W(B . "0x5843") ; <CJK>
       (?$(J<X(B . "0x365E") ; <CJK>
       (?$(J<Y(B . "0x3659") ; <CJK>
       (?$(J<Z(B . "0x21375") ; <CJK>
       (?$(J<[(B . "0x365A") ; <CJK>
       (?$(J<\(B . "0x36A0") ; <CJK>
       (?$(J<](B . "0x21660") ; <CJK>
       (?$(J<^(B . "0x21647") ; <CJK>
       (?$(J<_(B . "0x3705") ; <CJK>
       (?$(J<`(B . "0x217F0") ; <CJK>
       (?$(J<a(B . "0x3707") ; <CJK>
       (?$(J<b(B . "0x217EF") ; <CJK>
       (?$(J<c(B . "0x370E") ; <CJK>
       (?$(J<d(B . "0x370C") ; <CJK>
       (?$(J<e(B . "0x217EC") ; <CJK>
       (?$(J<f(B . "0x21983") ; <CJK>
       (?$(J<g(B . "0x3745") ; <CJK>
       (?$(J<h(B . "0x21984") ; <CJK>
       (?$(J<i(B . "0x2198F") ; <CJK>
       (?$(J<j(B . "0x3764") ; <CJK>
       (?$(J<k(B . "0x21A61") ; <CJK>
       (?$(J<l(B . "0x3765") ; <CJK>
       (?$(J<m(B . "0x21A69") ; <CJK>
       (?$(J<n(B . "0x5BDD") ; <CJK>
       (?$(J<o(B . "0x3766") ; <CJK>
       (?$(J<p(B . "0x21A62") ; <CJK>
       (?$(J<q(B . "0x3789") ; <CJK>
       (?$(J<r(B . "0x37EC") ; <CJK>
       (?$(J<s(B . "0x37F1") ; <CJK>
       (?$(J<t(B . "0x5D70") ; <CJK>
       (?$(J<u(B . "0x5D6A") ; <CJK>
       (?$(J<v(B . "0x37F0") ; <CJK>
       (?$(J<w(B . "0x37F8") ; <CJK>
       (?$(J<x(B . "0x5D74") ; <CJK>
       (?$(J<y(B . "0x5D5F") ; <CJK>
       (?$(J<z(B . "0x21EAE") ; <CJK>
       (?$(J<{(B . "0x5D61") ; <CJK>
       (?$(J<|(B . "0x5D73") ; <CJK>
       (?$(J<}(B . "0x21EB2") ; <CJK>
       (?$(J<~(B . "0x37F2") ; <CJK>
       (?$(J=!(B . "0x37F4") ; <CJK>
       (?$(J="(B . "0x2210B") ; <CJK>
       (?$(J=#(B . "0x3858") ; <CJK>
       (?$(J=$(B . "0x22110") ; <CJK>
       (?$(J=%(B . "0x2210D") ; <CJK>
       (?$(J=&(B . "0x385A") ; <CJK>
       (?$(J='(B . "0x3859") ; <CJK>
       (?$(J=((B . "0x3857") ; <CJK>
       (?$(J=)(B . "0x385B") ; <CJK>
       (?$(J=*(B . "0x5E50") ; <CJK>
       (?$(J=+(B . "0x2227F") ; <CJK>
       (?$(J=,(B . "0x22281") ; <CJK>
       (?$(J=-(B . "0x38A6") ; <CJK>
       (?$(J=.(B . "0x38C2") ; <CJK>
       (?$(J=/(B . "0x38C1") ; <CJK>
       (?$(J=0(B . "0x5F3F") ; <CJK>
       (?$(J=1(B . "0x2240B") ; <CJK>
       (?$(J=2(B . "0x2254E") ; <CJK>
       (?$(J=3(B . "0x38EF") ; <CJK>
       (?$(J=4(B . "0x5FB0") ; <CJK>
       (?$(J=5(B . "0x227EA") ; <CJK>
       (?$(J=6(B . "0x22745") ; <CJK>
       (?$(J=7(B . "0x3968") ; <CJK>
       (?$(J=8(B . "0x6135") ; <CJK>
       (?$(J=9(B . "0x612D") ; <CJK>
       (?$(J=:(B . "0x3973") ; <CJK>
       (?$(J=;(B . "0x396E") ; <CJK>
       (?$(J=<(B . "0x3974") ; <CJK>
       (?$(J==(B . "0x6102") ; <CJK>
       (?$(J=>(B . "0x3966") ; <CJK>
       (?$(J=?(B . "0x22728") ; <CJK>
       (?$(J=@(B . "0x2275D") ; <CJK>
       (?$(J=A(B . "0x229DC") ; <CJK>
       (?$(J=B(B . "0x39B9") ; <CJK>
       (?$(J=C(B . "0x6226") ; <CJK>
       (?$(J=D(B . "0x229D4") ; <CJK>
       (?$(J=E(B . "0x3A0C") ; <CJK>
       (?$(J=F(B . "0x22C64") ; <CJK>
       (?$(J=G(B . "0x22C68") ; <CJK>
       (?$(J=H(B . "0x3A20") ; <CJK>
       (?$(J=I(B . "0x22C62") ; <CJK>
       (?$(J=J(B . "0x3A1D") ; <CJK>
       (?$(J=K(B . "0x22C61") ; <CJK>
       (?$(J=L(B . "0x3A1C") ; <CJK>
       (?$(J=M(B . "0x22C66") ; <CJK>
       (?$(J=N(B . "0x3A21") ; <CJK>
       (?$(J=O(B . "0x3A1A") ; <CJK>
       (?$(J=P(B . "0x3A19") ; <CJK>
       (?$(J=Q(B . "0x22BF2") ; <CJK>
       (?$(J=R(B . "0x22C69") ; <CJK>
       (?$(J=S(B . "0x22C67") ; <CJK>
       (?$(J=T(B . "0x3A7E") ; <CJK>
       (?$(J=U(B . "0x22F9A") ; <CJK>
       (?$(J=V(B . "0x22F9B") ; <CJK>
       (?$(J=W(B . "0x22F85") ; <CJK>
       (?$(J=X(B . "0x22F9C") ; <CJK>
       (?$(J=Y(B . "0x3A9D") ; <CJK>
       (?$(J=Z(B . "0x22FA4") ; <CJK>
       (?$(J=[(B . "0x3A9E") ; <CJK>
       (?$(J=\(B . "0x3A9C") ; <CJK>
       (?$(J=](B . "0x656E") ; <CJK>
       (?$(J=^(B . "0x22F99") ; <CJK>
       (?$(J=_(B . "0x22F86") ; <CJK>
       (?$(J=`(B . "0x22F90") ; <CJK>
       (?$(J=a(B . "0x23081") ; <CJK>
       (?$(J=b(B . "0x230AE") ; <CJK>
       (?$(J=c(B . "0x65B1") ; <CJK>
       (?$(J=d(B . "0x65D4") ; <CJK>
       (?$(J=e(B . "0x3ACD") ; <CJK>
       (?$(J=f(B . "0x23138") ; <CJK>
       (?$(J=g(B . "0x3B0B") ; <CJK>
       (?$(J=h(B . "0x3B0A") ; <CJK>
       (?$(J=i(B . "0x6685") ; <CJK>
       (?$(J=j(B . "0x2353B") ; <CJK>
       (?$(J=k(B . "0x3B8F") ; <CJK>
       (?$(J=l(B . "0x6972") ; <CJK>
       (?$(J=m(B . "0x3B95") ; <CJK>
       (?$(J=n(B . "0x3B90") ; <CJK>
       (?$(J=o(B . "0x3B91") ; <CJK>
       (?$(J=p(B . "0x2354C") ; <CJK>
       (?$(J=q(B . "0x693A") ; <CJK>
       (?$(J=r(B . "0x3BB9") ; <CJK>
       (?$(J=s(B . "0x23547") ; <CJK>
       (?$(J=t(B . "0x23535") ; <CJK>
       (?$(J=u(B . "0x3B97") ; <CJK>
       (?$(J=v(B . "0x3B9E") ; <CJK>
       (?$(J=w(B . "0x23533") ; <CJK>
       (?$(J=x(B . "0x3B8B") ; <CJK>
       (?$(J=y(B . "0x23582") ; <CJK>
       (?$(J=z(B . "0x23540") ; <CJK>
       (?$(J={(B . "0x3C3B") ; <CJK>
       (?$(J=|(B . "0x3C3A") ; <CJK>
       (?$(J=}(B . "0x3C3C") ; <CJK>
       (?$(J=~(B . "0x3C3D") ; <CJK>
       (?$(J>!(B . "0x3C39") ; <CJK>
       (?$(J>"(B . "0x3C3E") ; <CJK>
       (?$(J>#(B . "0x3C6B") ; <CJK>
       (?$(J>$(B . "0x3C6C") ; <CJK>
       (?$(J>%(B . "0x23A36") ; <CJK>
       (?$(J>&(B . "0x23B0E") ; <CJK>
       (?$(J>'(B . "0x3CA2") ; <CJK>
       (?$(J>((B . "0x3CA1") ; <CJK>
       (?$(J>)(B . "0x3C9F") ; <CJK>
       (?$(J>*(B . "0x23BAD") ; <CJK>
       (?$(J>+(B . "0x23BAA") ; <CJK>
       (?$(J>,(B . "0x23E17") ; <CJK>
       (?$(J>-(B . "0x3D2D") ; <CJK>
       (?$(J>.(B . "0x23E67") ; <CJK>
       (?$(J>/(B . "0x3D36") ; <CJK>
       (?$(J>0(B . "0x3D2B") ; <CJK>
       (?$(J>1(B . "0x23E72") ; <CJK>
       (?$(J>2(B . "0x3D37") ; <CJK>
       (?$(J>3(B . "0x2F90A") ; <CJK>
       (?$(J>4(B . "0x23E61") ; <CJK>
       (?$(J>5(B . "0x23EB0") ; <CJK>
       (?$(J>6(B . "0x6EAD") ; <CJK>
       (?$(J>7(B . "0x3D25") ; <CJK>
       (?$(J>8(B . "0x3D2F") ; <CJK>
       (?$(J>9(B . "0x3D2C") ; <CJK>
       (?$(J>:(B . "0x23E6E") ; <CJK>
       (?$(J>;(B . "0x23E64") ; <CJK>
       (?$(J><(B . "0x3D32") ; <CJK>
       (?$(J>=(B . "0x23E8C") ; <CJK>
       (?$(J>>(B . "0x23E66") ; <CJK>
       (?$(J>?(B . "0x6E95") ; <CJK>
       (?$(J>@(B . "0x23E6B") ; <CJK>
       (?$(J>A(B . "0x23E5F") ; <CJK>
       (?$(J>B(B . "0x23E74") ; <CJK>
       (?$(J>C(B . "0x23E65") ; <CJK>
       (?$(J>D(B . "0x242BB") ; <CJK>
       (?$(J>E(B . "0x242BE") ; <CJK>
       (?$(J>F(B . "0x3DD5") ; <CJK>
       (?$(J>G(B . "0x242B9") ; <CJK>
       (?$(J>H(B . "0x3DD4") ; <CJK>
       (?$(J>I(B . "0x3DD6") ; <CJK>
       (?$(J>J(B . "0x242EF") ; <CJK>
       (?$(J>K(B . "0x3DD1") ; <CJK>
       (?$(J>L(B . "0x7243") ; <CJK>
       (?$(J>M(B . "0x245DA") ; <CJK>
       (?$(J>N(B . "0x3E46") ; <CJK>
       (?$(J>O(B . "0x728F") ; <CJK>
       (?$(J>P(B . "0x24690") ; <CJK>
       (?$(J>Q(B . "0x247E9") ; <CJK>
       (?$(J>R(B . "0x3E8C") ; <CJK>
       (?$(J>S(B . "0x3E8A") ; <CJK>
       (?$(J>T(B . "0x3E88") ; <CJK>
       (?$(J>U(B . "0x24811") ; <CJK>
       (?$(J>V(B . "0x2480D") ; <CJK>
       (?$(J>W(B . "0x247ED") ; <CJK>
       (?$(J>X(B . "0x24821") ; <CJK>
       (?$(J>Y(B . "0x3EDD") ; <CJK>
       (?$(J>Z(B . "0x24981") ; <CJK>
       (?$(J>[(B . "0x249B1") ; <CJK>
       (?$(J>\(B . "0x24B01") ; <CJK>
       (?$(J>](B . "0x3F2D") ; <CJK>
       (?$(J>^(B . "0x24B5E") ; <CJK>
       (?$(J>_(B . "0x24B62") ; <CJK>
       (?$(J>`(B . "0x3F2E") ; <CJK>
       (?$(J>a(B . "0x3F2C") ; <CJK>
       (?$(J>b(B . "0x3F2B") ; <CJK>
       (?$(J>c(B . "0x3F30") ; <CJK>
       (?$(J>d(B . "0x24B5B") ; <CJK>
       (?$(J>e(B . "0x3F4E") ; <CJK>
       (?$(J>f(B . "0x24C96") ; <CJK>
       (?$(J>g(B . "0x24C93") ; <CJK>
       (?$(J>h(B . "0x3F64") ; <CJK>
       (?$(J>i(B . "0x3F61") ; <CJK>
       (?$(J>j(B . "0x24C92") ; <CJK>
       (?$(J>k(B . "0x7575") ; <CJK>
       (?$(J>l(B . "0x2F939") ; <CJK>
       (?$(J>m(B . "0x3F70") ; <CJK>
       (?$(J>n(B . "0x3FA6") ; <CJK>
       (?$(J>o(B . "0x3FA4") ; <CJK>
       (?$(J>p(B . "0x24DC4") ; <CJK>
       (?$(J>q(B . "0x24DC7") ; <CJK>
       (?$(J>r(B . "0x24DC3") ; <CJK>
       (?$(J>s(B . "0x3FA8") ; <CJK>
       (?$(J>t(B . "0x3FA2") ; <CJK>
       (?$(J>u(B . "0x24DC8") ; <CJK>
       (?$(J>v(B . "0x3FA7") ; <CJK>
       (?$(J>w(B . "0x75EC") ; <CJK>
       (?$(J>x(B . "0x3FA5") ; <CJK>
       (?$(J>y(B . "0x24DCA") ; <CJK>
       (?$(J>z(B . "0x3FA9") ; <CJK>
       (?$(J>{(B . "0x24DC5") ; <CJK>
       (?$(J>|(B . "0x24DCF") ; <CJK>
       (?$(J>}(B . "0x24DDC") ; <CJK>
       (?$(J>~(B . "0x24F7C") ; <CJK>
       (?$(J?!(B . "0x25001") ; <CJK>
       (?$(J?"(B . "0x403D") ; <CJK>
       (?$(J?#(B . "0x251D3") ; <CJK>
       (?$(J?$(B . "0x251DC") ; <CJK>
       (?$(J?%(B . "0x4044") ; <CJK>
       (?$(J?&(B . "0x4045") ; <CJK>
       (?$(J?'(B . "0x4046") ; <CJK>
       (?$(J?((B . "0x251D4") ; <CJK>
       (?$(J?)(B . "0x7757") ; <CJK>
       (?$(J?*(B . "0x251CC") ; <CJK>
       (?$(J?+(B . "0x4047") ; <CJK>
       (?$(J?,(B . "0x4048") ; <CJK>
       (?$(J?-(B . "0x4042") ; <CJK>
       (?$(J?.(B . "0x251D6") ; <CJK>
       (?$(J?/(B . "0x251DB") ; <CJK>
       (?$(J?0(B . "0x4041") ; <CJK>
       (?$(J?1(B . "0x251D5") ; <CJK>
       (?$(J?2(B . "0x253D9") ; <CJK>
       (?$(J?3(B . "0x4094") ; <CJK>
       (?$(J?4(B . "0x253DD") ; <CJK>
       (?$(J?5(B . "0x253DC") ; <CJK>
       (?$(J?6(B . "0x253E0") ; <CJK>
       (?$(J?7(B . "0x254CC") ; <CJK>
       (?$(J?8(B . "0x40C0") ; <CJK>
       (?$(J?9(B . "0x40B8") ; <CJK>
       (?$(J?:(B . "0x40C1") ; <CJK>
       (?$(J?;(B . "0x40C2") ; <CJK>
       (?$(J?<(B . "0x40BB") ; <CJK>
       (?$(J?=(B . "0x40BD") ; <CJK>
       (?$(J?>(B . "0x40BF") ; <CJK>
       (?$(J??(B . "0x40B9") ; <CJK>
       (?$(J?@(B . "0x40B7") ; <CJK>
       (?$(J?A(B . "0x254D2") ; <CJK>
       (?$(J?B(B . "0x40C7") ; <CJK>
       (?$(J?C(B . "0x254D3") ; <CJK>
       (?$(J?D(B . "0x410C") ; <CJK>
       (?$(J?E(B . "0x410B") ; <CJK>
       (?$(J?F(B . "0x797B") ; <CJK>
       (?$(J?G(B . "0x4110") ; <CJK>
       (?$(J?H(B . "0x2568D") ; <CJK>
       (?$(J?I(B . "0x415D") ; <CJK>
       (?$(J?J(B . "0x7A21") ; <CJK>
       (?$(J?K(B . "0x415A") ; <CJK>
       (?$(J?L(B . "0x4158") ; <CJK>
       (?$(J?M(B . "0x4156") ; <CJK>
       (?$(J?N(B . "0x257D8") ; <CJK>
       (?$(J?O(B . "0x4154") ; <CJK>
       (?$(J?P(B . "0x7A16") ; <CJK>
       (?$(J?Q(B . "0x257BC") ; <CJK>
       (?$(J?R(B . "0x41A8") ; <CJK>
       (?$(J?S(B . "0x41A7") ; <CJK>
       (?$(J?T(B . "0x41CF") ; <CJK>
       (?$(J?U(B . "0x41D0") ; <CJK>
       (?$(J?V(B . "0x25A8A") ; <CJK>
       (?$(J?W(B . "0x7AE8") ; <CJK>
       (?$(J?X(B . "0x25A8B") ; <CJK>
       (?$(J?Y(B . "0x25A8D") ; <CJK>
       (?$(J?Z(B . "0x41D1") ; <CJK>
       (?$(J?[(B . "0x41EB") ; <CJK>
       (?$(J?\(B . "0x25B53") ; <CJK>
       (?$(J?](B . "0x41FB") ; <CJK>
       (?$(J?^(B . "0x7B6A") ; <CJK>
       (?$(J?_(B . "0x25B59") ; <CJK>
       (?$(J?`(B . "0x41FD") ; <CJK>
       (?$(J?a(B . "0x41F8") ; <CJK>
       (?$(J?b(B . "0x41F7") ; <CJK>
       (?$(J?c(B . "0x4200") ; <CJK>
       (?$(J?d(B . "0x25B56") ; <CJK>
       (?$(J?e(B . "0x25B57") ; <CJK>
       (?$(J?f(B . "0x41F6") ; <CJK>
       (?$(J?g(B . "0x7B5F") ; <CJK>
       (?$(J?h(B . "0x25E73") ; <CJK>
       (?$(J?i(B . "0x2601B") ; <CJK>
       (?$(J?j(B . "0x42DF") ; <CJK>
       (?$(J?k(B . "0x26021") ; <CJK>
       (?$(J?l(B . "0x26016") ; <CJK>
       (?$(J?m(B . "0x26018") ; <CJK>
       (?$(J?n(B . "0x42E2") ; <CJK>
       (?$(J?o(B . "0x42E4") ; <CJK>
       (?$(J?p(B . "0x26044") ; <CJK>
       (?$(J?q(B . "0x7D82") ; <CJK>
       (?$(J?r(B . "0x26026") ; <CJK>
       (?$(J?s(B . "0x42E3") ; <CJK>
       (?$(J?t(B . "0x26236") ; <CJK>
       (?$(J?u(B . "0x4359") ; <CJK>
       (?$(J?v(B . "0x4371") ; <CJK>
       (?$(J?w(B . "0x438E") ; <CJK>
       (?$(J?x(B . "0x438C") ; <CJK>
       (?$(J?y(B . "0x2643A") ; <CJK>
       (?$(J?z(B . "0x43A4") ; <CJK>
       (?$(J?{(B . "0x264F4") ; <CJK>
       (?$(J?|(B . "0x8055") ; <CJK>
       (?$(J?}(B . "0x4414") ; <CJK>
       (?$(J?~(B . "0x26762") ; <CJK>
       (?$(J@!(B . "0x2675B") ; <CJK>
       (?$(J@"(B . "0x2676A") ; <CJK>
       (?$(J@#(B . "0x4411") ; <CJK>
       (?$(J@$(B . "0x26768") ; <CJK>
       (?$(J@%(B . "0x441B") ; <CJK>
       (?$(J@&(B . "0x4412") ; <CJK>
       (?$(J@'(B . "0x440E") ; <CJK>
       (?$(J@((B . "0x4415") ; <CJK>
       (?$(J@)(B . "0x8168") ; <CJK>
       (?$(J@*(B . "0x4410") ; <CJK>
       (?$(J@+(B . "0x26781") ; <CJK>
       (?$(J@,(B . "0x4417") ; <CJK>
       (?$(J@-(B . "0x8246") ; <CJK>
       (?$(J@.(B . "0x8243") ; <CJK>
       (?$(J@/(B . "0x4470") ; <CJK>
       (?$(J@0(B . "0x44ED") ; <CJK>
       (?$(J@1(B . "0x26CE7") ; <CJK>
       (?$(J@2(B . "0x44EE") ; <CJK>
       (?$(J@3(B . "0x26CE6") ; <CJK>
       (?$(J@4(B . "0x26CD1") ; <CJK>
       (?$(J@5(B . "0x26D11") ; <CJK>
       (?$(J@6(B . "0x8481") ; <CJK>
       (?$(J@7(B . "0x26CD0") ; <CJK>
       (?$(J@8(B . "0x26CD9") ; <CJK>
       (?$(J@9(B . "0x26D0A") ; <CJK>
       (?$(J@:(B . "0x44F4") ; <CJK>
       (?$(J@;(B . "0x26CDA") ; <CJK>
       (?$(J@<(B . "0x26CDD") ; <CJK>
       (?$(J@=(B . "0x26CC8") ; <CJK>
       (?$(J@>(B . "0x26CE2") ; <CJK>
       (?$(J@?(B . "0x26CE9") ; <CJK>
       (?$(J@@(B . "0x26CCB") ; <CJK>
       (?$(J@A(B . "0x847C") ; <CJK>
       (?$(J@B(B . "0x26CCC") ; <CJK>
       (?$(J@C(B . "0x26CC1") ; <CJK>
       (?$(J@D(B . "0x846A") ; <CJK>
       (?$(J@E(B . "0x26CDE") ; <CJK>
       (?$(J@F(B . "0x8488") ; <CJK>
       (?$(J@G(B . "0x44F2") ; <CJK>
       (?$(J@H(B . "0x44F8") ; <CJK>
       (?$(J@I(B . "0x44F3") ; <CJK>
       (?$(J@J(B . "0x26D51") ; <CJK>
       (?$(J@K(B . "0x26D12") ; <CJK>
       (?$(J@L(B . "0x44FA") ; <CJK>
       (?$(J@M(B . "0x26CE0") ; <CJK>
       (?$(J@N(B . "0x26D2B") ; <CJK>
       (?$(J@O(B . "0x2F9B4") ; <CJK>
       (?$(J@P(B . "0x272D8") ; <CJK>
       (?$(J@Q(B . "0x272D1") ; <CJK>
       (?$(J@R(B . "0x8710") ; <CJK>
       (?$(J@S(B . "0x272D2") ; <CJK>
       (?$(J@T(B . "0x272CD") ; <CJK>
       (?$(J@U(B . "0x871F") ; <CJK>
       (?$(J@V(B . "0x45B6") ; <CJK>
       (?$(J@W(B . "0x45B7") ; <CJK>
       (?$(J@X(B . "0x2733D") ; <CJK>
       (?$(J@Y(B . "0x870F") ; <CJK>
       (?$(J@Z(B . "0x272CA") ; <CJK>
       (?$(J@[(B . "0x45BA") ; <CJK>
       (?$(J@\(B . "0x272CB") ; <CJK>
       (?$(J@](B . "0x45BC") ; <CJK>
       (?$(J@^(B . "0x272D7") ; <CJK>
       (?$(J@_(B . "0x275F4") ; <CJK>
       (?$(J@`(B . "0x463B") ; <CJK>
       (?$(J@a(B . "0x88D3") ; <CJK>
       (?$(J@b(B . "0x462F") ; <CJK>
       (?$(J@c(B . "0x27687") ; <CJK>
       (?$(J@d(B . "0x2768B") ; <CJK>
       (?$(J@e(B . "0x27683") ; <CJK>
       (?$(J@f(B . "0x4637") ; <CJK>
       (?$(J@g(B . "0x4699") ; <CJK>
       (?$(J@h(B . "0x279C5") ; <CJK>
       (?$(J@i(B . "0x279D2") ; <CJK>
       (?$(J@j(B . "0x279C6") ; <CJK>
       (?$(J@k(B . "0x279D3") ; <CJK>
       (?$(J@l(B . "0x46D9") ; <CJK>
       (?$(J@m(B . "0x46D8") ; <CJK>
       (?$(J@n(B . "0x46D7") ; <CJK>
       (?$(J@o(B . "0x279F0") ; <CJK>
       (?$(J@p(B . "0x279CD") ; <CJK>
       (?$(J@q(B . "0x279CC") ; <CJK>
       (?$(J@r(B . "0x279DC") ; <CJK>
       (?$(J@s(B . "0x279D6") ; <CJK>
       (?$(J@t(B . "0x4736") ; <CJK>
       (?$(J@u(B . "0x27BE6") ; <CJK>
       (?$(J@v(B . "0x27C41") ; <CJK>
       (?$(J@w(B . "0x27C3F") ; <CJK>
       (?$(J@x(B . "0x8C87") ; <CJK>
       (?$(J@y(B . "0x27CC5") ; <CJK>
       (?$(J@z(B . "0x27CC0") ; <CJK>
       (?$(J@{(B . "0x27CC6") ; <CJK>
       (?$(J@|(B . "0x27CBE") ; <CJK>
       (?$(J@}(B . "0x27CBF") ; <CJK>
       (?$(J@~(B . "0x8CC6") ; <CJK>
       (?$(JA!(B . "0x4770") ; <CJK>
       (?$(JA"(B . "0x27D63") ; <CJK>
       (?$(JA#(B . "0x27ED3") ; <CJK>
       (?$(JA$(B . "0x27EDA") ; <CJK>
       (?$(JA%(B . "0x27ED5") ; <CJK>
       (?$(JA&(B . "0x47A5") ; <CJK>
       (?$(JA'(B . "0x47A6") ; <CJK>
       (?$(JA((B . "0x47A9") ; <CJK>
       (?$(JA)(B . "0x47EE") ; <CJK>
       (?$(JA*(B . "0x4854") ; <CJK>
       (?$(JA+(B . "0x282EE") ; <CJK>
       (?$(JA,(B . "0x4857") ; <CJK>
       (?$(JA-(B . "0x282FC") ; <CJK>
       (?$(JA.(B . "0x28414") ; <CJK>
       (?$(JA/(B . "0x48A1") ; <CJK>
       (?$(JA0(B . "0x28523") ; <CJK>
       (?$(JA1(B . "0x28522") ; <CJK>
       (?$(JA2(B . "0x28530") ; <CJK>
       (?$(JA3(B . "0x286B5") ; <CJK>
       (?$(JA4(B . "0x48D3") ; <CJK>
       (?$(JA5(B . "0x28738") ; <CJK>
       (?$(JA6(B . "0x48D4") ; <CJK>
       (?$(JA7(B . "0x2873F") ; <CJK>
       (?$(JA8(B . "0x48D7") ; <CJK>
       (?$(JA9(B . "0x90CC") ; <CJK>
       (?$(JA:(B . "0x916D") ; <CJK>
       (?$(JA;(B . "0x9170") ; <CJK>
       (?$(JA<(B . "0x48F7") ; <CJK>
       (?$(JA=(B . "0x48F6") ; <CJK>
       (?$(JA>(B . "0x48F9") ; <CJK>
       (?$(JA?(B . "0x48F8") ; <CJK>
       (?$(JA@(B . "0x9258") ; <CJK>
       (?$(JAA(B . "0x9242") ; <CJK>
       (?$(JAB(B . "0x9268") ; <CJK>
       (?$(JAC(B . "0x9269") ; <CJK>
       (?$(JAD(B . "0x28968") ; <CJK>
       (?$(JAE(B . "0x28967") ; <CJK>
       (?$(JAF(B . "0x9243") ; <CJK>
       (?$(JAG(B . "0x28965") ; <CJK>
       (?$(JAH(B . "0x9247") ; <CJK>
       (?$(JAI(B . "0x498A") ; <CJK>
       (?$(JAJ(B . "0x28C75") ; <CJK>
       (?$(JAK(B . "0x28CF7") ; <CJK>
       (?$(JAL(B . "0x28CF3") ; <CJK>
       (?$(JAM(B . "0x28CF6") ; <CJK>
       (?$(JAN(B . "0x4994") ; <CJK>
       (?$(JAO(B . "0x28D00") ; <CJK>
       (?$(JAP(B . "0x4993") ; <CJK>
       (?$(JAQ(B . "0x28CFF") ; <CJK>
       (?$(JAR(B . "0x28CF5") ; <CJK>
       (?$(JAS(B . "0x959D") ; <CJK>
       (?$(JAT(B . "0x49DD") ; <CJK>
       (?$(JAU(B . "0x49DC") ; <CJK>
       (?$(JAV(B . "0x49F7") ; <CJK>
       (?$(JAW(B . "0x96CF") ; <CJK>
       (?$(JAX(B . "0x29092") ; <CJK>
       (?$(JAY(B . "0x29206") ; <CJK>
       (?$(JAZ(B . "0x4A42") ; <CJK>
       (?$(JA[(B . "0x29207") ; <CJK>
       (?$(JA\(B . "0x2926B") ; <CJK>
       (?$(JA](B . "0x4A54") ; <CJK>
       (?$(JA^(B . "0x2926C") ; <CJK>
       (?$(JA_(B . "0x4A55") ; <CJK>
       (?$(JA`(B . "0x29393") ; <CJK>
       (?$(JAa(B . "0x4A8F") ; <CJK>
       (?$(JAb(B . "0x29394") ; <CJK>
       (?$(JAc(B . "0x97F4") ; <CJK>
       (?$(JAd(B . "0x4AB4") ; <CJK>
       (?$(JAe(B . "0x4AB3") ; <CJK>
       (?$(JAf(B . "0x29462") ; <CJK>
       (?$(JAg(B . "0x29463") ; <CJK>
       (?$(JAh(B . "0x9809") ; <CJK>
       (?$(JAi(B . "0x2945F") ; <CJK>
       (?$(JAj(B . "0x29464") ; <CJK>
       (?$(JAk(B . "0x2945B") ; <CJK>
       (?$(JAl(B . "0x29459") ; <CJK>
       (?$(JAm(B . "0x4AFB") ; <CJK>
       (?$(JAn(B . "0x4AFD") ; <CJK>
       (?$(JAo(B . "0x295A4") ; <CJK>
       (?$(JAp(B . "0x295AC") ; <CJK>
       (?$(JAq(B . "0x98AB") ; <CJK>
       (?$(JAr(B . "0x4AFC") ; <CJK>
       (?$(JAs(B . "0x296B5") ; <CJK>
       (?$(JAt(B . "0x4B2C") ; <CJK>
       (?$(JAu(B . "0x4B2F") ; <CJK>
       (?$(JAv(B . "0x296AE") ; <CJK>
       (?$(JAw(B . "0x4B2B") ; <CJK>
       (?$(JAx(B . "0x296C5") ; <CJK>
       (?$(JAy(B . "0x4B33") ; <CJK>
       (?$(JAz(B . "0x4B34") ; <CJK>
       (?$(JA{(B . "0x98FB") ; <CJK>
       (?$(JA|(B . "0x2983B") ; <CJK>
       (?$(JA}(B . "0x9AAC") ; <CJK>
       (?$(JA~(B . "0x9AAE") ; <CJK>
       (?$(JB!(B . "0x9AAA") ; <CJK>
       (?$(JB"(B . "0x4BE8") ; <CJK>
       (?$(JB#(B . "0x29ABF") ; <CJK>
       (?$(JB$(B . "0x29C2B") ; <CJK>
       (?$(JB%(B . "0x29C84") ; <CJK>
       (?$(JB&(B . "0x29C80") ; <CJK>
       (?$(JB'(B . "0x29D4D") ; <CJK>
       (?$(JB((B . "0x29D4F") ; <CJK>
       (?$(JB)(B . "0x9B5C") ; <CJK>
       (?$(JB*(B . "0x29D4C") ; <CJK>
       (?$(JB+(B . "0x29F92") ; <CJK>
       (?$(JB,(B . "0x4D5D") ; <CJK>
       (?$(JB-(B . "0x50D2") ; <CJK>
       (?$(JB.(B . "0x3485") ; <CJK>
       (?$(JB/(B . "0x3488") ; <CJK>
       (?$(JB0(B . "0x203AE") ; <CJK>
       (?$(JB1(B . "0x20379") ; <CJK>
       (?$(JB2(B . "0x348E") ; <CJK>
       (?$(JB3(B . "0x3484") ; <CJK>
       (?$(JB4(B . "0x20371") ; <CJK>
       (?$(JB5(B . "0x50DF") ; <CJK>
       (?$(JB6(B . "0x203B3") ; <CJK>
       (?$(JB7(B . "0x3483") ; <CJK>
       (?$(JB8(B . "0x2032C") ; <CJK>
       (?$(JB9(B . "0x20377") ; <CJK>
       (?$(JB:(B . "0x2052F") ; <CJK>
       (?$(JB;(B . "0x207C3") ; <CJK>
       (?$(JB<(B . "0x3502") ; <CJK>
       (?$(JB=(B . "0x207CD") ; <CJK>
       (?$(JB>(B . "0x3506") ; <CJK>
       (?$(JB?(B . "0x3505") ; <CJK>
       (?$(JB@(B . "0x207C9") ; <CJK>
       (?$(JBA(B . "0x34FE") ; <CJK>
       (?$(JBB(B . "0x3501") ; <CJK>
       (?$(JBC(B . "0x3500") ; <CJK>
       (?$(JBD(B . "0x207CE") ; <CJK>
       (?$(JBE(B . "0x208A5") ; <CJK>
       (?$(JBF(B . "0x208A0") ; <CJK>
       (?$(JBG(B . "0x208FE") ; <CJK>
       (?$(JBH(B . "0x20959") ; <CJK>
       (?$(JBI(B . "0x20A9A") ; <CJK>
       (?$(JBJ(B . "0x35E7") ; <CJK>
       (?$(JBK(B . "0x5619") ; <CJK>
       (?$(JBL(B . "0x20EE4") ; <CJK>
       (?$(JBM(B . "0x20ED7") ; <CJK>
       (?$(JBN(B . "0x20EDC") ; <CJK>
       (?$(JBO(B . "0x35E6") ; <CJK>
       (?$(JBP(B . "0x20EE7") ; <CJK>
       (?$(JBQ(B . "0x35ED") ; <CJK>
       (?$(JBR(B . "0x35E2") ; <CJK>
       (?$(JBS(B . "0x35EB") ; <CJK>
       (?$(JBT(B . "0x20EE5") ; <CJK>
       (?$(JBU(B . "0x35E8") ; <CJK>
       (?$(JBV(B . "0x35EC") ; <CJK>
       (?$(JBW(B . "0x560A") ; <CJK>
       (?$(JBX(B . "0x3624") ; <CJK>
       (?$(JBY(B . "0x589A") ; <CJK>
       (?$(JBZ(B . "0x21414") ; <CJK>
       (?$(JB[(B . "0x3662") ; <CJK>
       (?$(JB\(B . "0x213F1") ; <CJK>
       (?$(JB](B . "0x3661") ; <CJK>
       (?$(JB^(B . "0x3660") ; <CJK>
       (?$(JB_(B . "0x3664") ; <CJK>
       (?$(JB`(B . "0x368B") ; <CJK>
       (?$(JBa(B . "0x215B6") ; <CJK>
       (?$(JBb(B . "0x2166E") ; <CJK>
       (?$(JBc(B . "0x2166C") ; <CJK>
       (?$(JBd(B . "0x21681") ; <CJK>
       (?$(JBe(B . "0x21842") ; <CJK>
       (?$(JBf(B . "0x3719") ; <CJK>
       (?$(JBg(B . "0x3716") ; <CJK>
       (?$(JBh(B . "0x3718") ; <CJK>
       (?$(JBi(B . "0x3722") ; <CJK>
       (?$(JBj(B . "0x2181A") ; <CJK>
       (?$(JBk(B . "0x371D") ; <CJK>
       (?$(JBl(B . "0x3717") ; <CJK>
       (?$(JBm(B . "0x371E") ; <CJK>
       (?$(JBn(B . "0x21827") ; <CJK>
       (?$(JBo(B . "0x21825") ; <CJK>
       (?$(JBp(B . "0x21817") ; <CJK>
       (?$(JBq(B . "0x2181C") ; <CJK>
       (?$(JBr(B . "0x2183D") ; <CJK>
       (?$(JBs(B . "0x21820") ; <CJK>
       (?$(JBt(B . "0x3769") ; <CJK>
       (?$(JBu(B . "0x376A") ; <CJK>
       (?$(JBv(B . "0x21A81") ; <CJK>
       (?$(JBw(B . "0x376C") ; <CJK>
       (?$(JBx(B . "0x377A") ; <CJK>
       (?$(JBy(B . "0x378A") ; <CJK>
       (?$(JBz(B . "0x21C09") ; <CJK>
       (?$(JB{(B . "0x21CC6") ; <CJK>
       (?$(JB|(B . "0x21CC4") ; <CJK>
       (?$(JB}(B . "0x379C") ; <CJK>
       (?$(JB~(B . "0x21CC5") ; <CJK>
       (?$(JC!(B . "0x37FD") ; <CJK>
       (?$(JC"(B . "0x37F9") ; <CJK>
       (?$(JC#(B . "0x21EEF") ; <CJK>
       (?$(JC$(B . "0x37FF") ; <CJK>
       (?$(JC%(B . "0x21EDF") ; <CJK>
       (?$(JC&(B . "0x21EDE") ; <CJK>
       (?$(JC'(B . "0x21EEE") ; <CJK>
       (?$(JC((B . "0x21EF5") ; <CJK>
       (?$(JC)(B . "0x21EEC") ; <CJK>
       (?$(JC*(B . "0x37FC") ; <CJK>
       (?$(JC+(B . "0x21EDD") ; <CJK>
       (?$(JC,(B . "0x5D85") ; <CJK>
       (?$(JC-(B . "0x37FB") ; <CJK>
       (?$(JC.(B . "0x3802") ; <CJK>
       (?$(JC/(B . "0x385F") ; <CJK>
       (?$(JC0(B . "0x5E56") ; <CJK>
       (?$(JC1(B . "0x385E") ; <CJK>
       (?$(JC2(B . "0x385D") ; <CJK>
       (?$(JC3(B . "0x385C") ; <CJK>
       (?$(JC4(B . "0x22122") ; <CJK>
       (?$(JC5(B . "0x5E51") ; <CJK>
       (?$(JC6(B . "0x3892") ; <CJK>
       (?$(JC7(B . "0x22297") ; <CJK>
       (?$(JC8(B . "0x22295") ; <CJK>
       (?$(JC9(B . "0x3894") ; <CJK>
       (?$(JC:(B . "0x3895") ; <CJK>
       (?$(JC;(B . "0x38D1") ; <CJK>
       (?$(JC<(B . "0x224A9") ; <CJK>
       (?$(JC=(B . "0x38F1") ; <CJK>
       (?$(JC>(B . "0x22553") ; <CJK>
       (?$(JC?(B . "0x5FB1") ; <CJK>
       (?$(JC@(B . "0x22556") ; <CJK>
       (?$(JCA(B . "0x22555") ; <CJK>
       (?$(JCB(B . "0x3977") ; <CJK>
       (?$(JCC(B . "0x396F") ; <CJK>
       (?$(JCD(B . "0x227E3") ; <CJK>
       (?$(JCE(B . "0x227E2") ; <CJK>
       (?$(JCF(B . "0x3987") ; <CJK>
       (?$(JCG(B . "0x397D") ; <CJK>
       (?$(JCH(B . "0x397C") ; <CJK>
       (?$(JCI(B . "0x397E") ; <CJK>
       (?$(JCJ(B . "0x3985") ; <CJK>
       (?$(JCK(B . "0x398B") ; <CJK>
       (?$(JCL(B . "0x3986") ; <CJK>
       (?$(JCM(B . "0x3980") ; <CJK>
       (?$(JCN(B . "0x6168") ; <CJK>
       (?$(JCO(B . "0x227A9") ; <CJK>
       (?$(JCP(B . "0x3978") ; <CJK>
       (?$(JCQ(B . "0x2F8AB") ; <CJK>
       (?$(JCR(B . "0x22833") ; <CJK>
       (?$(JCS(B . "0x2280A") ; <CJK>
       (?$(JCT(B . "0x39BA") ; <CJK>
       (?$(JCU(B . "0x22A59") ; <CJK>
       (?$(JCV(B . "0x3A33") ; <CJK>
       (?$(JCW(B . "0x22CBC") ; <CJK>
       (?$(JCX(B . "0x3A2D") ; <CJK>
       (?$(JCY(B . "0x22CC4") ; <CJK>
       (?$(JCZ(B . "0x22CC7") ; <CJK>
       (?$(JC[(B . "0x22CC6") ; <CJK>
       (?$(JC\(B . "0x3A37") ; <CJK>
       (?$(JC](B . "0x645A") ; <CJK>
       (?$(JC^(B . "0x6463") ; <CJK>
       (?$(JC_(B . "0x22CB8") ; <CJK>
       (?$(JC`(B . "0x22CDA") ; <CJK>
       (?$(JCa(B . "0x3A2E") ; <CJK>
       (?$(JCb(B . "0x22CB7") ; <CJK>
       (?$(JCc(B . "0x22CC0") ; <CJK>
       (?$(JCd(B . "0x3A3D") ; <CJK>
       (?$(JCe(B . "0x22CCD") ; <CJK>
       (?$(JCf(B . "0x3AA0") ; <CJK>
       (?$(JCg(B . "0x22FBC") ; <CJK>
       (?$(JCh(B . "0x22FAB") ; <CJK>
       (?$(JCi(B . "0x3AA3") ; <CJK>
       (?$(JCj(B . "0x23086") ; <CJK>
       (?$(JCk(B . "0x669B") ; <CJK>
       (?$(JCl(B . "0x2325A") ; <CJK>
       (?$(JCm(B . "0x66A3") ; <CJK>
       (?$(JCn(B . "0x3B0E") ; <CJK>
       (?$(JCo(B . "0x669E") ; <CJK>
       (?$(JCp(B . "0x23343") ; <CJK>
       (?$(JCq(B . "0x3BB6") ; <CJK>
       (?$(JCr(B . "0x235AC") ; <CJK>
       (?$(JCs(B . "0x3BAB") ; <CJK>
       (?$(JCt(B . "0x3BAD") ; <CJK>
       (?$(JCu(B . "0x3BA6") ; <CJK>
       (?$(JCv(B . "0x235BE") ; <CJK>
       (?$(JCw(B . "0x69B8") ; <CJK>
       (?$(JCx(B . "0x3BAA") ; <CJK>
       (?$(JCy(B . "0x69BA") ; <CJK>
       (?$(JCz(B . "0x3BB1") ; <CJK>
       (?$(JC{(B . "0x235AB") ; <CJK>
       (?$(JC|(B . "0x3BA8") ; <CJK>
       (?$(JC}(B . "0x3BAF") ; <CJK>
       (?$(JC~(B . "0x3BB0") ; <CJK>
       (?$(JD!(B . "0x3BA7") ; <CJK>
       (?$(JD"(B . "0x3BB2") ; <CJK>
       (?$(JD#(B . "0x3B9D") ; <CJK>
       (?$(JD$(B . "0x3BA5") ; <CJK>
       (?$(JD%(B . "0x3BB5") ; <CJK>
       (?$(JD&(B . "0x21B3E") ; <CJK>
       (?$(JD'(B . "0x69C7") ; <CJK>
       (?$(JD((B . "0x69D7") ; <CJK>
       (?$(JD)(B . "0x238F9") ; <CJK>
       (?$(JD*(B . "0x3C41") ; <CJK>
       (?$(JD+(B . "0x238F3") ; <CJK>
       (?$(JD,(B . "0x238F7") ; <CJK>
       (?$(JD-(B . "0x6B70") ; <CJK>
       (?$(JD.(B . "0x23A45") ; <CJK>
       (?$(JD/(B . "0x23A48") ; <CJK>
       (?$(JD0(B . "0x3C72") ; <CJK>
       (?$(JD1(B . "0x6B9D") ; <CJK>
       (?$(JD2(B . "0x3C6F") ; <CJK>
       (?$(JD3(B . "0x3C71") ; <CJK>
       (?$(JD4(B . "0x23A44") ; <CJK>
       (?$(JD5(B . "0x3C85") ; <CJK>
       (?$(JD6(B . "0x23AAF") ; <CJK>
       (?$(JD7(B . "0x23AB1") ; <CJK>
       (?$(JD8(B . "0x3CA4") ; <CJK>
       (?$(JD9(B . "0x3CA5") ; <CJK>
       (?$(JD:(B . "0x3CA6") ; <CJK>
       (?$(JD;(B . "0x23BCF") ; <CJK>
       (?$(JD<(B . "0x3CA8") ; <CJK>
       (?$(JD=(B . "0x23BCB") ; <CJK>
       (?$(JD>(B . "0x23BCD") ; <CJK>
       (?$(JD?(B . "0x3CA3") ; <CJK>
       (?$(JD@(B . "0x23C50") ; <CJK>
       (?$(JDA(B . "0x23EEC") ; <CJK>
       (?$(JDB(B . "0x23F1A") ; <CJK>
       (?$(JDC(B . "0x6F16") ; <CJK>
       (?$(JDD(B . "0x6F24") ; <CJK>
       (?$(JDE(B . "0x23ED8") ; <CJK>
       (?$(JDF(B . "0x3D43") ; <CJK>
       (?$(JDG(B . "0x23ED0") ; <CJK>
       (?$(JDH(B . "0x23ED1") ; <CJK>
       (?$(JDI(B . "0x3D3D") ; <CJK>
       (?$(JDJ(B . "0x3D45") ; <CJK>
       (?$(JDK(B . "0x23E7B") ; <CJK>
       (?$(JDL(B . "0x23ED2") ; <CJK>
       (?$(JDM(B . "0x3D44") ; <CJK>
       (?$(JDN(B . "0x23ED4") ; <CJK>
       (?$(JDO(B . "0x23EE7") ; <CJK>
       (?$(JDP(B . "0x23EDF") ; <CJK>
       (?$(JDQ(B . "0x23EDE") ; <CJK>
       (?$(JDR(B . "0x6F45") ; <CJK>
       (?$(JDS(B . "0x23ED9") ; <CJK>
       (?$(JDT(B . "0x23ECF") ; <CJK>
       (?$(JDU(B . "0x2430D") ; <CJK>
       (?$(JDV(B . "0x3DE3") ; <CJK>
       (?$(JDW(B . "0x7179") ; <CJK>
       (?$(JDX(B . "0x7193") ; <CJK>
       (?$(JDY(B . "0x3DDF") ; <CJK>
       (?$(JDZ(B . "0x3DE4") ; <CJK>
       (?$(JD[(B . "0x717A") ; <CJK>
       (?$(JD\(B . "0x3DE5") ; <CJK>
       (?$(JD](B . "0x24338") ; <CJK>
       (?$(JD^(B . "0x7254") ; <CJK>
       (?$(JD_(B . "0x3E22") ; <CJK>
       (?$(JD`(B . "0x3E4A") ; <CJK>
       (?$(JDa(B . "0x246A9") ; <CJK>
       (?$(JDb(B . "0x3E49") ; <CJK>
       (?$(JDc(B . "0x3E44") ; <CJK>
       (?$(JDd(B . "0x3E4B") ; <CJK>
       (?$(JDe(B . "0x3E87") ; <CJK>
       (?$(JDf(B . "0x3E89") ; <CJK>
       (?$(JDg(B . "0x3E92") ; <CJK>
       (?$(JDh(B . "0x3E91") ; <CJK>
       (?$(JDi(B . "0x3E90") ; <CJK>
       (?$(JDj(B . "0x3E8E") ; <CJK>
       (?$(JDk(B . "0x2483E") ; <CJK>
       (?$(JDl(B . "0x24846") ; <CJK>
       (?$(JDm(B . "0x249ED") ; <CJK>
       (?$(JDn(B . "0x2F930") ; <CJK>
       (?$(JDo(B . "0x3F12") ; <CJK>
       (?$(JDp(B . "0x3F10") ; <CJK>
       (?$(JDq(B . "0x3F11") ; <CJK>
       (?$(JDr(B . "0x24B6C") ; <CJK>
       (?$(JDs(B . "0x3F32") ; <CJK>
       (?$(JDt(B . "0x3F34") ; <CJK>
       (?$(JDu(B . "0x3F37") ; <CJK>
       (?$(JDv(B . "0x3F33") ; <CJK>
       (?$(JDw(B . "0x3F36") ; <CJK>
       (?$(JDx(B . "0x3F35") ; <CJK>
       (?$(JDy(B . "0x3F65") ; <CJK>
       (?$(JDz(B . "0x24CAC") ; <CJK>
       (?$(JD{(B . "0x757C") ; <CJK>
       (?$(JD|(B . "0x757B") ; <CJK>
       (?$(JD}(B . "0x24DC9") ; <CJK>
       (?$(JD~(B . "0x7612") ; <CJK>
       (?$(JE!(B . "0x3FB0") ; <CJK>
       (?$(JE"(B . "0x24E12") ; <CJK>
       (?$(JE#(B . "0x3FAF") ; <CJK>
       (?$(JE$(B . "0x3FAA") ; <CJK>
       (?$(JE%(B . "0x24DFD") ; <CJK>
       (?$(JE&(B . "0x24E01") ; <CJK>
       (?$(JE'(B . "0x24E11") ; <CJK>
       (?$(JE((B . "0x3FAB") ; <CJK>
       (?$(JE)(B . "0x24E89") ; <CJK>
       (?$(JE*(B . "0x24E05") ; <CJK>
       (?$(JE+(B . "0x24DFE") ; <CJK>
       (?$(JE,(B . "0x24E0B") ; <CJK>
       (?$(JE-(B . "0x24E20") ; <CJK>
       (?$(JE.(B . "0x24E04") ; <CJK>
       (?$(JE/(B . "0x24F88") ; <CJK>
       (?$(JE0(B . "0x3FF3") ; <CJK>
       (?$(JE1(B . "0x25002") ; <CJK>
       (?$(JE2(B . "0x3FF4") ; <CJK>
       (?$(JE3(B . "0x25003") ; <CJK>
       (?$(JE4(B . "0x76B6") ; <CJK>
       (?$(JE5(B . "0x76E0") ; <CJK>
       (?$(JE6(B . "0x4008") ; <CJK>
       (?$(JE7(B . "0x404E") ; <CJK>
       (?$(JE8(B . "0x4055") ; <CJK>
       (?$(JE9(B . "0x404B") ; <CJK>
       (?$(JE:(B . "0x25229") ; <CJK>
       (?$(JE;(B . "0x2523B") ; <CJK>
       (?$(JE<(B . "0x404D") ; <CJK>
       (?$(JE=(B . "0x7773") ; <CJK>
       (?$(JE>(B . "0x25206") ; <CJK>
       (?$(JE?(B . "0x4052") ; <CJK>
       (?$(JE@(B . "0x7772") ; <CJK>
       (?$(JEA(B . "0x404C") ; <CJK>
       (?$(JEB(B . "0x7770") ; <CJK>
       (?$(JEC(B . "0x4050") ; <CJK>
       (?$(JED(B . "0x4053") ; <CJK>
       (?$(JEE(B . "0x25203") ; <CJK>
       (?$(JEF(B . "0x4051") ; <CJK>
       (?$(JEG(B . "0x25378") ; <CJK>
       (?$(JEH(B . "0x25379") ; <CJK>
       (?$(JEI(B . "0x2537D") ; <CJK>
       (?$(JEJ(B . "0x4089") ; <CJK>
       (?$(JEK(B . "0x2537F") ; <CJK>
       (?$(JEL(B . "0x4095") ; <CJK>
       (?$(JEM(B . "0x40CC") ; <CJK>
       (?$(JEN(B . "0x40C8") ; <CJK>
       (?$(JEO(B . "0x40CE") ; <CJK>
       (?$(JEP(B . "0x25532") ; <CJK>
       (?$(JEQ(B . "0x40CA") ; <CJK>
       (?$(JER(B . "0x25500") ; <CJK>
       (?$(JES(B . "0x789D") ; <CJK>
       (?$(JET(B . "0x25522") ; <CJK>
       (?$(JEU(B . "0x40CD") ; <CJK>
       (?$(JEV(B . "0x256A9") ; <CJK>
       (?$(JEW(B . "0x415C") ; <CJK>
       (?$(JEX(B . "0x4167") ; <CJK>
       (?$(JEY(B . "0x4169") ; <CJK>
       (?$(JEZ(B . "0x4165") ; <CJK>
       (?$(JE[(B . "0x4162") ; <CJK>
       (?$(JE\(B . "0x25804") ; <CJK>
       (?$(JE](B . "0x7A27") ; <CJK>
       (?$(JE^(B . "0x7A35") ; <CJK>
       (?$(JE_(B . "0x2F959") ; <CJK>
       (?$(JE`(B . "0x41AA") ; <CJK>
       (?$(JEa(B . "0x259B8") ; <CJK>
       (?$(JEb(B . "0x25A9B") ; <CJK>
       (?$(JEc(B . "0x41D2") ; <CJK>
       (?$(JEd(B . "0x7BA2") ; <CJK>
       (?$(JEe(B . "0x4203") ; <CJK>
       (?$(JEf(B . "0x420C") ; <CJK>
       (?$(JEg(B . "0x25B92") ; <CJK>
       (?$(JEh(B . "0x4209") ; <CJK>
       (?$(JEi(B . "0x4206") ; <CJK>
       (?$(JEj(B . "0x4205") ; <CJK>
       (?$(JEk(B . "0x7B89") ; <CJK>
       (?$(JEl(B . "0x25B8F") ; <CJK>
       (?$(JEm(B . "0x420B") ; <CJK>
       (?$(JEn(B . "0x4208") ; <CJK>
       (?$(JEo(B . "0x25B98") ; <CJK>
       (?$(JEp(B . "0x7BA5") ; <CJK>
       (?$(JEq(B . "0x25BAE") ; <CJK>
       (?$(JEr(B . "0x428E") ; <CJK>
       (?$(JEs(B . "0x25E9D") ; <CJK>
       (?$(JEt(B . "0x7CB6") ; <CJK>
       (?$(JEu(B . "0x42E8") ; <CJK>
       (?$(JEv(B . "0x26049") ; <CJK>
       (?$(JEw(B . "0x26050") ; <CJK>
       (?$(JEx(B . "0x26046") ; <CJK>
       (?$(JEy(B . "0x42EA") ; <CJK>
       (?$(JEz(B . "0x2604E") ; <CJK>
       (?$(JE{(B . "0x7DA5") ; <CJK>
       (?$(JE|(B . "0x7DC3") ; <CJK>
       (?$(JE}(B . "0x26055") ; <CJK>
       (?$(JE~(B . "0x42E9") ; <CJK>
       (?$(JF!(B . "0x42EB") ; <CJK>
       (?$(JF"(B . "0x26064") ; <CJK>
       (?$(JF#(B . "0x42F0") ; <CJK>
       (?$(JF$(B . "0x26238") ; <CJK>
       (?$(JF%(B . "0x434B") ; <CJK>
       (?$(JF&(B . "0x7FAB") ; <CJK>
       (?$(JF'(B . "0x4373") ; <CJK>
       (?$(JF((B . "0x4375") ; <CJK>
       (?$(JF)(B . "0x4392") ; <CJK>
       (?$(JF*(B . "0x4391") ; <CJK>
       (?$(JF+(B . "0x4393") ; <CJK>
       (?$(JF,(B . "0x8025") ; <CJK>
       (?$(JF-(B . "0x43A7") ; <CJK>
       (?$(JF.(B . "0x43A6") ; <CJK>
       (?$(JF/(B . "0x43A8") ; <CJK>
       (?$(JF0(B . "0x43AA") ; <CJK>
       (?$(JF1(B . "0x264FE") ; <CJK>
       (?$(JF2(B . "0x43A9") ; <CJK>
       (?$(JF3(B . "0x8059") ; <CJK>
       (?$(JF4(B . "0x43BB") ; <CJK>
       (?$(JF5(B . "0x43BC") ; <CJK>
       (?$(JF6(B . "0x43BA") ; <CJK>
       (?$(JF7(B . "0x43BD") ; <CJK>
       (?$(JF8(B . "0x4427") ; <CJK>
       (?$(JF9(B . "0x8185") ; <CJK>
       (?$(JF:(B . "0x267A6") ; <CJK>
       (?$(JF;(B . "0x4424") ; <CJK>
       (?$(JF<(B . "0x441E") ; <CJK>
       (?$(JF=(B . "0x441F") ; <CJK>
       (?$(JF>(B . "0x441D") ; <CJK>
       (?$(JF?(B . "0x4420") ; <CJK>
       (?$(JF@(B . "0x4423") ; <CJK>
       (?$(JFA(B . "0x4429") ; <CJK>
       (?$(JFB(B . "0x4422") ; <CJK>
       (?$(JFC(B . "0x2679C") ; <CJK>
       (?$(JFD(B . "0x26799") ; <CJK>
       (?$(JFE(B . "0x441C") ; <CJK>
       (?$(JFF(B . "0x818E") ; <CJK>
       (?$(JFG(B . "0x4428") ; <CJK>
       (?$(JFH(B . "0x267B5") ; <CJK>
       (?$(JFI(B . "0x267A3") ; <CJK>
       (?$(JFJ(B . "0x267A0") ; <CJK>
       (?$(JFK(B . "0x267A7") ; <CJK>
       (?$(JFL(B . "0x2679B") ; <CJK>
       (?$(JFM(B . "0x269DF") ; <CJK>
       (?$(JFN(B . "0x269E1") ; <CJK>
       (?$(JFO(B . "0x4471") ; <CJK>
       (?$(JFP(B . "0x4473") ; <CJK>
       (?$(JFQ(B . "0x4472") ; <CJK>
       (?$(JFR(B . "0x26A4D") ; <CJK>
       (?$(JFS(B . "0x4502") ; <CJK>
       (?$(JFT(B . "0x26DF3") ; <CJK>
       (?$(JFU(B . "0x26D6F") ; <CJK>
       (?$(JFV(B . "0x26D69") ; <CJK>
       (?$(JFW(B . "0x44FE") ; <CJK>
       (?$(JFX(B . "0x84BE") ; <CJK>
       (?$(JFY(B . "0x26D6B") ; <CJK>
       (?$(JFZ(B . "0x26D78") ; <CJK>
       (?$(JF[(B . "0x26D87") ; <CJK>
       (?$(JF\(B . "0x4508") ; <CJK>
       (?$(JF](B . "0x26D85") ; <CJK>
       (?$(JF^(B . "0x26D82") ; <CJK>
       (?$(JF_(B . "0x26D90") ; <CJK>
       (?$(JF`(B . "0x4507") ; <CJK>
       (?$(JFa(B . "0x4504") ; <CJK>
       (?$(JFb(B . "0x26D80") ; <CJK>
       (?$(JFc(B . "0x26D67") ; <CJK>
       (?$(JFd(B . "0x4500") ; <CJK>
       (?$(JFe(B . "0x44FC") ; <CJK>
       (?$(JFf(B . "0x26D61") ; <CJK>
       (?$(JFg(B . "0x4544") ; <CJK>
       (?$(JFh(B . "0x26D93") ; <CJK>
       (?$(JFi(B . "0x44F1") ; <CJK>
       (?$(JFj(B . "0x26DF2") ; <CJK>
       (?$(JFk(B . "0x26D86") ; <CJK>
       (?$(JFl(B . "0x84A6") ; <CJK>
       (?$(JFm(B . "0x4506") ; <CJK>
       (?$(JFn(B . "0x271CD") ; <CJK>
       (?$(JFo(B . "0x271C4") ; <CJK>
       (?$(JFp(B . "0x45C6") ; <CJK>
       (?$(JFq(B . "0x45C3") ; <CJK>
       (?$(JFr(B . "0x45C1") ; <CJK>
       (?$(JFs(B . "0x45C2") ; <CJK>
       (?$(JFt(B . "0x2730F") ; <CJK>
       (?$(JFu(B . "0x45C4") ; <CJK>
       (?$(JFv(B . "0x45C7") ; <CJK>
       (?$(JFw(B . "0x2730D") ; <CJK>
       (?$(JFx(B . "0x45BF") ; <CJK>
       (?$(JFy(B . "0x45D2") ; <CJK>
       (?$(JFz(B . "0x27373") ; <CJK>
       (?$(JF{(B . "0x45CA") ; <CJK>
       (?$(JF|(B . "0x2F9BA") ; <CJK>
       (?$(JF}(B . "0x2730A") ; <CJK>
       (?$(JF~(B . "0x872F") ; <CJK>
       (?$(JG!(B . "0x27308") ; <CJK>
       (?$(JG"(B . "0x27313") ; <CJK>
       (?$(JG#(B . "0x4613") ; <CJK>
       (?$(JG$(B . "0x275F8") ; <CJK>
       (?$(JG%(B . "0x4630") ; <CJK>
       (?$(JG&(B . "0x463E") ; <CJK>
       (?$(JG'(B . "0x4639") ; <CJK>
       (?$(JG((B . "0x276AB") ; <CJK>
       (?$(JG)(B . "0x276A8") ; <CJK>
       (?$(JG*(B . "0x463C") ; <CJK>
       (?$(JG+(B . "0x463F") ; <CJK>
       (?$(JG,(B . "0x276A5") ; <CJK>
       (?$(JG-(B . "0x4634") ; <CJK>
       (?$(JG.(B . "0x463D") ; <CJK>
       (?$(JG/(B . "0x276C3") ; <CJK>
       (?$(JG0(B . "0x276A4") ; <CJK>
       (?$(JG1(B . "0x4638") ; <CJK>
       (?$(JG2(B . "0x276D4") ; <CJK>
       (?$(JG3(B . "0x276BA") ; <CJK>
       (?$(JG4(B . "0x277F1") ; <CJK>
       (?$(JG5(B . "0x89A0") ; <CJK>
       (?$(JG6(B . "0x4682") ; <CJK>
       (?$(JG7(B . "0x2783F") ; <CJK>
       (?$(JG8(B . "0x4683") ; <CJK>
       (?$(JG9(B . "0x278EA") ; <CJK>
       (?$(JG:(B . "0x469B") ; <CJK>
       (?$(JG;(B . "0x279F7") ; <CJK>
       (?$(JG<(B . "0x46E0") ; <CJK>
       (?$(JG=(B . "0x46DD") ; <CJK>
       (?$(JG>(B . "0x279FA") ; <CJK>
       (?$(JG?(B . "0x279F5") ; <CJK>
       (?$(JG@(B . "0x46DE") ; <CJK>
       (?$(JGA(B . "0x279FE") ; <CJK>
       (?$(JGB(B . "0x46E3") ; <CJK>
       (?$(JGC(B . "0x46E5") ; <CJK>
       (?$(JGD(B . "0x27A00") ; <CJK>
       (?$(JGE(B . "0x8A97") ; <CJK>
       (?$(JGF(B . "0x46E2") ; <CJK>
       (?$(JGG(B . "0x27A02") ; <CJK>
       (?$(JGH(B . "0x279FB") ; <CJK>
       (?$(JGI(B . "0x27A07") ; <CJK>
       (?$(JGJ(B . "0x46DF") ; <CJK>
       (?$(JGK(B . "0x27A1A") ; <CJK>
       (?$(JGL(B . "0x472E") ; <CJK>
       (?$(JGM(B . "0x27BB8") ; <CJK>
       (?$(JGN(B . "0x4737") ; <CJK>
       (?$(JGO(B . "0x4738") ; <CJK>
       (?$(JGP(B . "0x27BE9") ; <CJK>
       (?$(JGQ(B . "0x27BEB") ; <CJK>
       (?$(JGR(B . "0x27C50") ; <CJK>
       (?$(JGS(B . "0x27C4F") ; <CJK>
       (?$(JGT(B . "0x8C8B") ; <CJK>
       (?$(JGU(B . "0x27D86") ; <CJK>
       (?$(JGV(B . "0x3562") ; <CJK>
       (?$(JGW(B . "0x27D8E") ; <CJK>
       (?$(JGX(B . "0x4794") ; <CJK>
       (?$(JGY(B . "0x4793") ; <CJK>
       (?$(JGZ(B . "0x47AB") ; <CJK>
       (?$(JG[(B . "0x47AD") ; <CJK>
       (?$(JG\(B . "0x27EF0") ; <CJK>
       (?$(JG](B . "0x27EFB") ; <CJK>
       (?$(JG^(B . "0x47F5") ; <CJK>
       (?$(JG_(B . "0x47F7") ; <CJK>
       (?$(JG`(B . "0x28042") ; <CJK>
       (?$(JGa(B . "0x47F6") ; <CJK>
       (?$(JGb(B . "0x47F8") ; <CJK>
       (?$(JGc(B . "0x28085") ; <CJK>
       (?$(JGd(B . "0x47FB") ; <CJK>
       (?$(JGe(B . "0x47F9") ; <CJK>
       (?$(JGf(B . "0x4858") ; <CJK>
       (?$(JGg(B . "0x485A") ; <CJK>
       (?$(JGh(B . "0x28305") ; <CJK>
       (?$(JGi(B . "0x4859") ; <CJK>
       (?$(JGj(B . "0x8F0F") ; <CJK>
       (?$(JGk(B . "0x4885") ; <CJK>
       (?$(JGl(B . "0x48A4") ; <CJK>
       (?$(JGm(B . "0x48D8") ; <CJK>
       (?$(JGn(B . "0x48D9") ; <CJK>
       (?$(JGo(B . "0x2874B") ; <CJK>
       (?$(JGp(B . "0x48DD") ; <CJK>
       (?$(JGq(B . "0x48C8") ; <CJK>
       (?$(JGr(B . "0x28763") ; <CJK>
       (?$(JGs(B . "0x48FA") ; <CJK>
       (?$(JGt(B . "0x48FB") ; <CJK>
       (?$(JGu(B . "0x9275") ; <CJK>
       (?$(JGv(B . "0x4927") ; <CJK>
       (?$(JGw(B . "0x929F") ; <CJK>
       (?$(JGx(B . "0x492A") ; <CJK>
       (?$(JGy(B . "0x4925") ; <CJK>
       (?$(JGz(B . "0x28999") ; <CJK>
       (?$(JG{(B . "0x4928") ; <CJK>
       (?$(JG|(B . "0x28C81") ; <CJK>
       (?$(JG}(B . "0x28D17") ; <CJK>
       (?$(JG~(B . "0x28D10") ; <CJK>
       (?$(JH!(B . "0x28D12") ; <CJK>
       (?$(JH"(B . "0x95A6") ; <CJK>
       (?$(JH#(B . "0x4995") ; <CJK>
       (?$(JH$(B . "0x969A") ; <CJK>
       (?$(JH%(B . "0x28EFA") ; <CJK>
       (?$(JH&(B . "0x28EF3") ; <CJK>
       (?$(JH'(B . "0x28EF2") ; <CJK>
       (?$(JH((B . "0x28EF5") ; <CJK>
       (?$(JH)(B . "0x28EF6") ; <CJK>
       (?$(JH*(B . "0x28FBB") ; <CJK>
       (?$(JH+(B . "0x28FC2") ; <CJK>
       (?$(JH,(B . "0x290A7") ; <CJK>
       (?$(JH-(B . "0x4A0F") ; <CJK>
       (?$(JH.(B . "0x4A11") ; <CJK>
       (?$(JH/(B . "0x290A8") ; <CJK>
       (?$(JH0(B . "0x290A3") ; <CJK>
       (?$(JH1(B . "0x4A10") ; <CJK>
       (?$(JH2(B . "0x290AA") ; <CJK>
       (?$(JH3(B . "0x4A15") ; <CJK>
       (?$(JH4(B . "0x4A13") ; <CJK>
       (?$(JH5(B . "0x9757") ; <CJK>
       (?$(JH6(B . "0x291DC") ; <CJK>
       (?$(JH7(B . "0x4A47") ; <CJK>
       (?$(JH8(B . "0x4A46") ; <CJK>
       (?$(JH9(B . "0x2920F") ; <CJK>
       (?$(JH:(B . "0x4A59") ; <CJK>
       (?$(JH;(B . "0x4A5B") ; <CJK>
       (?$(JH<(B . "0x29279") ; <CJK>
       (?$(JH=(B . "0x4A5E") ; <CJK>
       (?$(JH>(B . "0x2927F") ; <CJK>
       (?$(JH?(B . "0x29285") ; <CJK>
       (?$(JH@(B . "0x4A5A") ; <CJK>
       (?$(JHA(B . "0x4A91") ; <CJK>
       (?$(JHB(B . "0x4A92") ; <CJK>
       (?$(JHC(B . "0x4A90") ; <CJK>
       (?$(JHD(B . "0x4A93") ; <CJK>
       (?$(JHE(B . "0x2941B") ; <CJK>
       (?$(JHF(B . "0x97F7") ; <CJK>
       (?$(JHG(B . "0x4ABE") ; <CJK>
       (?$(JHH(B . "0x29477") ; <CJK>
       (?$(JHI(B . "0x29476") ; <CJK>
       (?$(JHJ(B . "0x29498") ; <CJK>
       (?$(JHK(B . "0x4ABC") ; <CJK>
       (?$(JHL(B . "0x4ABB") ; <CJK>
       (?$(JHM(B . "0x4AB7") ; <CJK>
       (?$(JHN(B . "0x4AB9") ; <CJK>
       (?$(JHO(B . "0x2947A") ; <CJK>
       (?$(JHP(B . "0x4B01") ; <CJK>
       (?$(JHQ(B . "0x4AFE") ; <CJK>
       (?$(JHR(B . "0x295BC") ; <CJK>
       (?$(JHS(B . "0x295BA") ; <CJK>
       (?$(JHT(B . "0x4B02") ; <CJK>
       (?$(JHU(B . "0x295B6") ; <CJK>
       (?$(JHV(B . "0x4AFF") ; <CJK>
       (?$(JHW(B . "0x98B0") ; <CJK>
       (?$(JHX(B . "0x295B4") ; <CJK>
       (?$(JHY(B . "0x4B00") ; <CJK>
       (?$(JHZ(B . "0x296CF") ; <CJK>
       (?$(JH[(B . "0x4B37") ; <CJK>
       (?$(JH\(B . "0x4B3A") ; <CJK>
       (?$(JH](B . "0x4B6F") ; <CJK>
       (?$(JH^(B . "0x4B77") ; <CJK>
       (?$(JH_(B . "0x4B79") ; <CJK>
       (?$(JH`(B . "0x99C6") ; <CJK>
       (?$(JHa(B . "0x2987B") ; <CJK>
       (?$(JHb(B . "0x4BC8") ; <CJK>
       (?$(JHc(B . "0x29A1C") ; <CJK>
       (?$(JHd(B . "0x29A21") ; <CJK>
       (?$(JHe(B . "0x29A1D") ; <CJK>
       (?$(JHf(B . "0x29AC0") ; <CJK>
       (?$(JHg(B . "0x4BF2") ; <CJK>
       (?$(JHh(B . "0x29AFF") ; <CJK>
       (?$(JHi(B . "0x4BF1") ; <CJK>
       (?$(JHj(B . "0x4BF0") ; <CJK>
       (?$(JHk(B . "0x9B62") ; <CJK>
       (?$(JHl(B . "0x29D56") ; <CJK>
       (?$(JHm(B . "0x4C34") ; <CJK>
       (?$(JHn(B . "0x29FA1") ; <CJK>
       (?$(JHo(B . "0x29FA2") ; <CJK>
       (?$(JHp(B . "0x29FA6") ; <CJK>
       (?$(JHq(B . "0x2A256") ; <CJK>
       (?$(JHr(B . "0x2A257") ; <CJK>
       (?$(JHs(B . "0x4D2C") ; <CJK>
       (?$(JHt(B . "0x4D2D") ; <CJK>
       (?$(JHu(B . "0x2A301") ; <CJK>
       (?$(JHv(B . "0x2A3ED") ; <CJK>
       (?$(JHw(B . "0x2FA1C") ; <CJK>
       (?$(JHx(B . "0x2A5F2") ; <CJK>
       (?$(JHy(B . "0x50FA") ; <CJK>
       (?$(JHz(B . "0x203B8") ; <CJK>
       (?$(JH{(B . "0x3491") ; <CJK>
       (?$(JH|(B . "0x203C0") ; <CJK>
       (?$(JH}(B . "0x3494") ; <CJK>
       (?$(JH~(B . "0x203B7") ; <CJK>
       (?$(JI!(B . "0x203E1") ; <CJK>
       (?$(JI"(B . "0x34C4") ; <CJK>
       (?$(JI#(B . "0x350A") ; <CJK>
       (?$(JI$(B . "0x207E8") ; <CJK>
       (?$(JI%(B . "0x5285") ; <CJK>
       (?$(JI&(B . "0x208B2") ; <CJK>
       (?$(JI'(B . "0x3552") ; <CJK>
       (?$(JI((B . "0x20AAE") ; <CJK>
       (?$(JI)(B . "0x3559") ; <CJK>
       (?$(JI*(B . "0x366F") ; <CJK>
       (?$(JI+(B . "0x20F7E") ; <CJK>
       (?$(JI,(B . "0x35F2") ; <CJK>
       (?$(JI-(B . "0x35F4") ; <CJK>
       (?$(JI.(B . "0x5643") ; <CJK>
       (?$(JI/(B . "0x20F76") ; <CJK>
       (?$(JI0(B . "0x35F1") ; <CJK>
       (?$(JI1(B . "0x563C") ; <CJK>
       (?$(JI2(B . "0x20F96") ; <CJK>
       (?$(JI3(B . "0x366A") ; <CJK>
       (?$(JI4(B . "0x21420") ; <CJK>
       (?$(JI5(B . "0x21421") ; <CJK>
       (?$(JI6(B . "0x21423") ; <CJK>
       (?$(JI7(B . "0x21429") ; <CJK>
       (?$(JI8(B . "0x21677") ; <CJK>
       (?$(JI9(B . "0x21851") ; <CJK>
       (?$(JI:(B . "0x3724") ; <CJK>
       (?$(JI;(B . "0x21856") ; <CJK>
       (?$(JI<(B . "0x3723") ; <CJK>
       (?$(JI=(B . "0x21888") ; <CJK>
       (?$(JI>(B . "0x21859") ; <CJK>
       (?$(JI?(B . "0x21855") ; <CJK>
       (?$(JI@(B . "0x3727") ; <CJK>
       (?$(JIA(B . "0x21997") ; <CJK>
       (?$(JIB(B . "0x21998") ; <CJK>
       (?$(JIC(B . "0x376D") ; <CJK>
       (?$(JID(B . "0x5BED") ; <CJK>
       (?$(JIE(B . "0x376E") ; <CJK>
       (?$(JIF(B . "0x376F") ; <CJK>
       (?$(JIG(B . "0x21AA1") ; <CJK>
       (?$(JIH(B . "0x21AA3") ; <CJK>
       (?$(JII(B . "0x5C35") ; <CJK>
       (?$(JIJ(B . "0x379F") ; <CJK>
       (?$(JIK(B . "0x380A") ; <CJK>
       (?$(JIL(B . "0x3806") ; <CJK>
       (?$(JIM(B . "0x380E") ; <CJK>
       (?$(JIN(B . "0x21F0A") ; <CJK>
       (?$(JIO(B . "0x380D") ; <CJK>
       (?$(JIP(B . "0x3805") ; <CJK>
       (?$(JIQ(B . "0x21F3D") ; <CJK>
       (?$(JIR(B . "0x21F0C") ; <CJK>
       (?$(JIS(B . "0x380B") ; <CJK>
       (?$(JIT(B . "0x3810") ; <CJK>
       (?$(JIU(B . "0x382E") ; <CJK>
       (?$(JIV(B . "0x2213D") ; <CJK>
       (?$(JIW(B . "0x22139") ; <CJK>
       (?$(JIX(B . "0x222B0") ; <CJK>
       (?$(JIY(B . "0x222B2") ; <CJK>
       (?$(JIZ(B . "0x222AE") ; <CJK>
       (?$(JI[(B . "0x3896") ; <CJK>
       (?$(JI\(B . "0x3897") ; <CJK>
       (?$(JI](B . "0x38C4") ; <CJK>
       (?$(JI^(B . "0x5F47") ; <CJK>
       (?$(JI_(B . "0x38C5") ; <CJK>
       (?$(JI`(B . "0x22420") ; <CJK>
       (?$(JIa(B . "0x38D2") ; <CJK>
       (?$(JIb(B . "0x2256E") ; <CJK>
       (?$(JIc(B . "0x2256D") ; <CJK>
       (?$(JId(B . "0x2256A") ; <CJK>
       (?$(JIe(B . "0x3981") ; <CJK>
       (?$(JIf(B . "0x22832") ; <CJK>
       (?$(JIg(B . "0x398E") ; <CJK>
       (?$(JIh(B . "0x3990") ; <CJK>
       (?$(JIi(B . "0x398F") ; <CJK>
       (?$(JIj(B . "0x22839") ; <CJK>
       (?$(JIk(B . "0x3991") ; <CJK>
       (?$(JIl(B . "0x3995") ; <CJK>
       (?$(JIm(B . "0x3993") ; <CJK>
       (?$(JIn(B . "0x227A3") ; <CJK>
       (?$(JIo(B . "0x616D") ; <CJK>
       (?$(JIp(B . "0x2287F") ; <CJK>
       (?$(JIq(B . "0x22835") ; <CJK>
       (?$(JIr(B . "0x2283D") ; <CJK>
       (?$(JIs(B . "0x229F4") ; <CJK>
       (?$(JIt(B . "0x229F5") ; <CJK>
       (?$(JIu(B . "0x3A3B") ; <CJK>
       (?$(JIv(B . "0x3A48") ; <CJK>
       (?$(JIw(B . "0x22D48") ; <CJK>
       (?$(JIx(B . "0x22D28") ; <CJK>
       (?$(JIy(B . "0x3A46") ; <CJK>
       (?$(JIz(B . "0x3A47") ; <CJK>
       (?$(JI{(B . "0x22D27") ; <CJK>
       (?$(JI|(B . "0x22D32") ; <CJK>
       (?$(JI}(B . "0x22D2C") ; <CJK>
       (?$(JI~(B . "0x3A4C") ; <CJK>
       (?$(JJ!(B . "0x22D2E") ; <CJK>
       (?$(JJ"(B . "0x3A4A") ; <CJK>
       (?$(JJ#(B . "0x3A50") ; <CJK>
       (?$(JJ$(B . "0x3A43") ; <CJK>
       (?$(JJ%(B . "0x22D23") ; <CJK>
       (?$(JJ&(B . "0x22D31") ; <CJK>
       (?$(JJ'(B . "0x2F8C5") ; <CJK>
       (?$(JJ((B . "0x3A49") ; <CJK>
       (?$(JJ)(B . "0x3AA6") ; <CJK>
       (?$(JJ*(B . "0x3AA5") ; <CJK>
       (?$(JJ+(B . "0x3AA4") ; <CJK>
       (?$(JJ,(B . "0x22FC9") ; <CJK>
       (?$(JJ-(B . "0x23089") ; <CJK>
       (?$(JJ.(B . "0x3AB9") ; <CJK>
       (?$(JJ/(B . "0x230BB") ; <CJK>
       (?$(JJ0(B . "0x3ACE") ; <CJK>
       (?$(JJ1(B . "0x3ACF") ; <CJK>
       (?$(JJ2(B . "0x3B13") ; <CJK>
       (?$(JJ3(B . "0x23397") ; <CJK>
       (?$(JJ4(B . "0x23393") ; <CJK>
       (?$(JJ5(B . "0x23628") ; <CJK>
       (?$(JJ6(B . "0x3BC6") ; <CJK>
       (?$(JJ7(B . "0x3BC5") ; <CJK>
       (?$(JJ8(B . "0x3BCA") ; <CJK>
       (?$(JJ9(B . "0x3BD9") ; <CJK>
       (?$(JJ:(B . "0x3BC1") ; <CJK>
       (?$(JJ;(B . "0x23618") ; <CJK>
       (?$(JJ<(B . "0x2363B") ; <CJK>
       (?$(JJ=(B . "0x69F5") ; <CJK>
       (?$(JJ>(B . "0x23627") ; <CJK>
       (?$(JJ?(B . "0x23624") ; <CJK>
       (?$(JJ@(B . "0x2361B") ; <CJK>
       (?$(JJA(B . "0x23631") ; <CJK>
       (?$(JJB(B . "0x3BCB") ; <CJK>
       (?$(JJC(B . "0x23626") ; <CJK>
       (?$(JJD(B . "0x236A3") ; <CJK>
       (?$(JJE(B . "0x2363F") ; <CJK>
       (?$(JJF(B . "0x23622") ; <CJK>
       (?$(JJG(B . "0x23619") ; <CJK>
       (?$(JJH(B . "0x6A03") ; <CJK>
       (?$(JJI(B . "0x23641") ; <CJK>
       (?$(JJJ(B . "0x2362B") ; <CJK>
       (?$(JJK(B . "0x6A65") ; <CJK>
       (?$(JJL(B . "0x3C42") ; <CJK>
       (?$(JJM(B . "0x2390C") ; <CJK>
       (?$(JJN(B . "0x6B75") ; <CJK>
       (?$(JJO(B . "0x3C74") ; <CJK>
       (?$(JJP(B . "0x3C73") ; <CJK>
       (?$(JJQ(B . "0x23A4E") ; <CJK>
       (?$(JJR(B . "0x23AB9") ; <CJK>
       (?$(JJS(B . "0x23AFA") ; <CJK>
       (?$(JJT(B . "0x23BE9") ; <CJK>
       (?$(JJU(B . "0x23BE8") ; <CJK>
       (?$(JJV(B . "0x23BE4") ; <CJK>
       (?$(JJW(B . "0x6F8A") ; <CJK>
       (?$(JJX(B . "0x6F56") ; <CJK>
       (?$(JJY(B . "0x3D52") ; <CJK>
       (?$(JJZ(B . "0x23F5F") ; <CJK>
       (?$(JJ[(B . "0x23F5D") ; <CJK>
       (?$(JJ\(B . "0x23F52") ; <CJK>
       (?$(JJ](B . "0x3D50") ; <CJK>
       (?$(JJ^(B . "0x23F74") ; <CJK>
       (?$(JJ_(B . "0x3D4B") ; <CJK>
       (?$(JJ`(B . "0x23F46") ; <CJK>
       (?$(JJa(B . "0x3D4C") ; <CJK>
       (?$(JJb(B . "0x3D6D") ; <CJK>
       (?$(JJc(B . "0x23FAA") ; <CJK>
       (?$(JJd(B . "0x6F98") ; <CJK>
       (?$(JJe(B . "0x23F4A") ; <CJK>
       (?$(JJf(B . "0x23F59") ; <CJK>
       (?$(JJg(B . "0x23F4B") ; <CJK>
       (?$(JJh(B . "0x3D4F") ; <CJK>
       (?$(JJi(B . "0x6F68") ; <CJK>
       (?$(JJj(B . "0x3DF0") ; <CJK>
       (?$(JJk(B . "0x24350") ; <CJK>
       (?$(JJl(B . "0x7234") ; <CJK>
       (?$(JJm(B . "0x7245") ; <CJK>
       (?$(JJn(B . "0x3E4D") ; <CJK>
       (?$(JJo(B . "0x3E4C") ; <CJK>
       (?$(JJp(B . "0x246D0") ; <CJK>
       (?$(JJq(B . "0x3E4F") ; <CJK>
       (?$(JJr(B . "0x3E4E") ; <CJK>
       (?$(JJs(B . "0x3E50") ; <CJK>
       (?$(JJt(B . "0x246CC") ; <CJK>
       (?$(JJu(B . "0x735C") ; <CJK>
       (?$(JJv(B . "0x3E96") ; <CJK>
       (?$(JJw(B . "0x7356") ; <CJK>
       (?$(JJx(B . "0x24864") ; <CJK>
       (?$(JJy(B . "0x24865") ; <CJK>
       (?$(JJz(B . "0x3E97") ; <CJK>
       (?$(JJ{(B . "0x3E95") ; <CJK>
       (?$(JJ|(B . "0x3E98") ; <CJK>
       (?$(JJ}(B . "0x2485C") ; <CJK>
       (?$(JJ~(B . "0x24A15") ; <CJK>
       (?$(JK!(B . "0x3EEC") ; <CJK>
       (?$(JK"(B . "0x3EEB") ; <CJK>
       (?$(JK#(B . "0x3F13") ; <CJK>
       (?$(JK$(B . "0x3F14") ; <CJK>
       (?$(JK%(B . "0x3F38") ; <CJK>
       (?$(JK&(B . "0x3F3A") ; <CJK>
       (?$(JK'(B . "0x3F39") ; <CJK>
       (?$(JK((B . "0x24B79") ; <CJK>
       (?$(JK)(B . "0x3F68") ; <CJK>
       (?$(JK*(B . "0x3F67") ; <CJK>
       (?$(JK+(B . "0x24CC5") ; <CJK>
       (?$(JK,(B . "0x24CB8") ; <CJK>
       (?$(JK-(B . "0x24E2C") ; <CJK>
       (?$(JK.(B . "0x3FBE") ; <CJK>
       (?$(JK/(B . "0x3FBC") ; <CJK>
       (?$(JK0(B . "0x24E37") ; <CJK>
       (?$(JK1(B . "0x24E35") ; <CJK>
       (?$(JK2(B . "0x24E31") ; <CJK>
       (?$(JK3(B . "0x3FBB") ; <CJK>
       (?$(JK4(B . "0x24E2F") ; <CJK>
       (?$(JK5(B . "0x3FBA") ; <CJK>
       (?$(JK6(B . "0x24E2B") ; <CJK>
       (?$(JK7(B . "0x3FB9") ; <CJK>
       (?$(JK8(B . "0x3FB7") ; <CJK>
       (?$(JK9(B . "0x24E2D") ; <CJK>
       (?$(JK:(B . "0x24E2A") ; <CJK>
       (?$(JK;(B . "0x3FC1") ; <CJK>
       (?$(JK<(B . "0x24F95") ; <CJK>
       (?$(JK=(B . "0x3FF7") ; <CJK>
       (?$(JK>(B . "0x2523E") ; <CJK>
       (?$(JK?(B . "0x4060") ; <CJK>
       (?$(JK@(B . "0x25247") ; <CJK>
       (?$(JKA(B . "0x25245") ; <CJK>
       (?$(JKB(B . "0x4059") ; <CJK>
       (?$(JKC(B . "0x405C") ; <CJK>
       (?$(JKD(B . "0x405A") ; <CJK>
       (?$(JKE(B . "0x4058") ; <CJK>
       (?$(JKF(B . "0x25252") ; <CJK>
       (?$(JKG(B . "0x405B") ; <CJK>
       (?$(JKH(B . "0x25270") ; <CJK>
       (?$(JKI(B . "0x25250") ; <CJK>
       (?$(JKJ(B . "0x25258") ; <CJK>
       (?$(JKK(B . "0x25251") ; <CJK>
       (?$(JKL(B . "0x2523D") ; <CJK>
       (?$(JKM(B . "0x405D") ; <CJK>
       (?$(JKN(B . "0x25241") ; <CJK>
       (?$(JKO(B . "0x2520C") ; <CJK>
       (?$(JKP(B . "0x2523C") ; <CJK>
       (?$(JKQ(B . "0x25386") ; <CJK>
       (?$(JKR(B . "0x25383") ; <CJK>
       (?$(JKS(B . "0x25389") ; <CJK>
       (?$(JKT(B . "0x253F3") ; <CJK>
       (?$(JKU(B . "0x40D4") ; <CJK>
       (?$(JKV(B . "0x40D3") ; <CJK>
       (?$(JKW(B . "0x78BF") ; <CJK>
       (?$(JKX(B . "0x40D2") ; <CJK>
       (?$(JKY(B . "0x78BD") ; <CJK>
       (?$(JKZ(B . "0x2552D") ; <CJK>
       (?$(JK[(B . "0x40D7") ; <CJK>
       (?$(JK\(B . "0x40D1") ; <CJK>
       (?$(JK](B . "0x78E4") ; <CJK>
       (?$(JK^(B . "0x40D5") ; <CJK>
       (?$(JK_(B . "0x256C5") ; <CJK>
       (?$(JK`(B . "0x2F955") ; <CJK>
       (?$(JKa(B . "0x416D") ; <CJK>
       (?$(JKb(B . "0x416F") ; <CJK>
       (?$(JKc(B . "0x7A34") ; <CJK>
       (?$(JKd(B . "0x4175") ; <CJK>
       (?$(JKe(B . "0x416C") ; <CJK>
       (?$(JKf(B . "0x4174") ; <CJK>
       (?$(JKg(B . "0x25843") ; <CJK>
       (?$(JKh(B . "0x4173") ; <CJK>
       (?$(JKi(B . "0x25837") ; <CJK>
       (?$(JKj(B . "0x25845") ; <CJK>
       (?$(JKk(B . "0x7A36") ; <CJK>
       (?$(JKl(B . "0x41AC") ; <CJK>
       (?$(JKm(B . "0x259E5") ; <CJK>
       (?$(JKn(B . "0x25AA6") ; <CJK>
       (?$(JKo(B . "0x25BDB") ; <CJK>
       (?$(JKp(B . "0x4210") ; <CJK>
       (?$(JKq(B . "0x25BDA") ; <CJK>
       (?$(JKr(B . "0x25BE6") ; <CJK>
       (?$(JKs(B . "0x7BBA") ; <CJK>
       (?$(JKt(B . "0x7BBC") ; <CJK>
       (?$(JKu(B . "0x420F") ; <CJK>
       (?$(JKv(B . "0x7BC8") ; <CJK>
       (?$(JKw(B . "0x4223") ; <CJK>
       (?$(JKx(B . "0x7BC3") ; <CJK>
       (?$(JKy(B . "0x421D") ; <CJK>
       (?$(JKz(B . "0x7BB6") ; <CJK>
       (?$(JK{(B . "0x420E") ; <CJK>
       (?$(JK|(B . "0x25BF8") ; <CJK>
       (?$(JK}(B . "0x25BE9") ; <CJK>
       (?$(JK~(B . "0x4215") ; <CJK>
       (?$(JL!(B . "0x7BC2") ; <CJK>
       (?$(JL"(B . "0x4213") ; <CJK>
       (?$(JL#(B . "0x25BE8") ; <CJK>
       (?$(JL$(B . "0x25BF6") ; <CJK>
       (?$(JL%(B . "0x421B") ; <CJK>
       (?$(JL&(B . "0x7BC5") ; <CJK>
       (?$(JL'(B . "0x4222") ; <CJK>
       (?$(JL((B . "0x4226") ; <CJK>
       (?$(JL)(B . "0x25BE7") ; <CJK>
       (?$(JL*(B . "0x7BBD") ; <CJK>
       (?$(JL+(B . "0x7BB0") ; <CJK>
       (?$(JL,(B . "0x4221") ; <CJK>
       (?$(JL-(B . "0x421C") ; <CJK>
       (?$(JL.(B . "0x4217") ; <CJK>
       (?$(JL/(B . "0x25BD5") ; <CJK>
       (?$(JL0(B . "0x421A") ; <CJK>
       (?$(JL1(B . "0x7BBB") ; <CJK>
       (?$(JL2(B . "0x25ED3") ; <CJK>
       (?$(JL3(B . "0x25EC7") ; <CJK>
       (?$(JL4(B . "0x25ED1") ; <CJK>
       (?$(JL5(B . "0x4299") ; <CJK>
       (?$(JL6(B . "0x25EC3") ; <CJK>
       (?$(JL7(B . "0x4297") ; <CJK>
       (?$(JL8(B . "0x26080") ; <CJK>
       (?$(JL9(B . "0x26098") ; <CJK>
       (?$(JL:(B . "0x42FD") ; <CJK>
       (?$(JL;(B . "0x26084") ; <CJK>
       (?$(JL<(B . "0x42F6") ; <CJK>
       (?$(JL=(B . "0x42FE") ; <CJK>
       (?$(JL>(B . "0x42F5") ; <CJK>
       (?$(JL?(B . "0x42FF") ; <CJK>
       (?$(JL@(B . "0x42F7") ; <CJK>
       (?$(JLA(B . "0x26097") ; <CJK>
       (?$(JLB(B . "0x26083") ; <CJK>
       (?$(JLC(B . "0x26081") ; <CJK>
       (?$(JLD(B . "0x4301") ; <CJK>
       (?$(JLE(B . "0x7E04") ; <CJK>
       (?$(JLF(B . "0x2608C") ; <CJK>
       (?$(JLG(B . "0x26242") ; <CJK>
       (?$(JLH(B . "0x263AB") ; <CJK>
       (?$(JLI(B . "0x4377") ; <CJK>
       (?$(JLJ(B . "0x263A3") ; <CJK>
       (?$(JLK(B . "0x263A6") ; <CJK>
       (?$(JLL(B . "0x2645C") ; <CJK>
       (?$(JLM(B . "0x26469") ; <CJK>
       (?$(JLN(B . "0x26467") ; <CJK>
       (?$(JLO(B . "0x43AB") ; <CJK>
       (?$(JLP(B . "0x2658B") ; <CJK>
       (?$(JLQ(B . "0x265A8") ; <CJK>
       (?$(JLR(B . "0x43C0") ; <CJK>
       (?$(JLS(B . "0x267D8") ; <CJK>
       (?$(JLT(B . "0x4431") ; <CJK>
       (?$(JLU(B . "0x442E") ; <CJK>
       (?$(JLV(B . "0x2F989") ; <CJK>
       (?$(JLW(B . "0x267DC") ; <CJK>
       (?$(JLX(B . "0x442C") ; <CJK>
       (?$(JLY(B . "0x267E0") ; <CJK>
       (?$(JLZ(B . "0x267E5") ; <CJK>
       (?$(JL[(B . "0x4432") ; <CJK>
       (?$(JL\(B . "0x442F") ; <CJK>
       (?$(JL](B . "0x442B") ; <CJK>
       (?$(JL^(B . "0x442D") ; <CJK>
       (?$(JL_(B . "0x4433") ; <CJK>
       (?$(JL`(B . "0x26918") ; <CJK>
       (?$(JLa(B . "0x26919") ; <CJK>
       (?$(JLb(B . "0x81F1") ; <CJK>
       (?$(JLc(B . "0x4457") ; <CJK>
       (?$(JLd(B . "0x445C") ; <CJK>
       (?$(JLe(B . "0x447B") ; <CJK>
       (?$(JLf(B . "0x26A5F") ; <CJK>
       (?$(JLg(B . "0x26A5E") ; <CJK>
       (?$(JLh(B . "0x447A") ; <CJK>
       (?$(JLi(B . "0x26E02") ; <CJK>
       (?$(JLj(B . "0x8522") ; <CJK>
       (?$(JLk(B . "0x4513") ; <CJK>
       (?$(JLl(B . "0x451E") ; <CJK>
       (?$(JLm(B . "0x4517") ; <CJK>
       (?$(JLn(B . "0x4520") ; <CJK>
       (?$(JLo(B . "0x452A") ; <CJK>
       (?$(JLp(B . "0x4511") ; <CJK>
       (?$(JLq(B . "0x4515") ; <CJK>
       (?$(JLr(B . "0x450F") ; <CJK>
       (?$(JLs(B . "0x4518") ; <CJK>
       (?$(JLt(B . "0x8538") ; <CJK>
       (?$(JLu(B . "0x26E12") ; <CJK>
       (?$(JLv(B . "0x26E36") ; <CJK>
       (?$(JLw(B . "0x452C") ; <CJK>
       (?$(JLx(B . "0x8532") ; <CJK>
       (?$(JLy(B . "0x2F9A8") ; <CJK>
       (?$(JLz(B . "0x8510") ; <CJK>
       (?$(JL{(B . "0x26E23") ; <CJK>
       (?$(JL|(B . "0x26E03") ; <CJK>
       (?$(JL}(B . "0x451C") ; <CJK>
       (?$(JL~(B . "0x26E00") ; <CJK>
       (?$(JM!(B . "0x4529") ; <CJK>
       (?$(JM"(B . "0x26E46") ; <CJK>
       (?$(JM#(B . "0x26E61") ; <CJK>
       (?$(JM$(B . "0x4512") ; <CJK>
       (?$(JM%(B . "0x854F") ; <CJK>
       (?$(JM&(B . "0x4597") ; <CJK>
       (?$(JM'(B . "0x27384") ; <CJK>
       (?$(JM((B . "0x8772") ; <CJK>
       (?$(JM)(B . "0x2736B") ; <CJK>
       (?$(JM*(B . "0x27362") ; <CJK>
       (?$(JM+(B . "0x27356") ; <CJK>
       (?$(JM,(B . "0x2736A") ; <CJK>
       (?$(JM-(B . "0x27352") ; <CJK>
       (?$(JM.(B . "0x27355") ; <CJK>
       (?$(JM/(B . "0x45D4") ; <CJK>
       (?$(JM0(B . "0x45D0") ; <CJK>
       (?$(JM1(B . "0x877C") ; <CJK>
       (?$(JM2(B . "0x27361") ; <CJK>
       (?$(JM3(B . "0x2F9BB") ; <CJK>
       (?$(JM4(B . "0x27358") ; <CJK>
       (?$(JM5(B . "0x27377") ; <CJK>
       (?$(JM6(B . "0x45D3") ; <CJK>
       (?$(JM7(B . "0x4614") ; <CJK>
       (?$(JM8(B . "0x276D7") ; <CJK>
       (?$(JM9(B . "0x4646") ; <CJK>
       (?$(JM:(B . "0x4645") ; <CJK>
       (?$(JM;(B . "0x276DE") ; <CJK>
       (?$(JM<(B . "0x4643") ; <CJK>
       (?$(JM=(B . "0x276DF") ; <CJK>
       (?$(JM>(B . "0x890D") ; <CJK>
       (?$(JM?(B . "0x4644") ; <CJK>
       (?$(JM@(B . "0x4648") ; <CJK>
       (?$(JMA(B . "0x276D1") ; <CJK>
       (?$(JMB(B . "0x4647") ; <CJK>
       (?$(JMC(B . "0x276E2") ; <CJK>
       (?$(JMD(B . "0x276E1") ; <CJK>
       (?$(JME(B . "0x276DD") ; <CJK>
       (?$(JMF(B . "0x8908") ; <CJK>
       (?$(JMG(B . "0x4649") ; <CJK>
       (?$(JMH(B . "0x4685") ; <CJK>
       (?$(JMI(B . "0x2784B") ; <CJK>
       (?$(JMJ(B . "0x4684") ; <CJK>
       (?$(JMK(B . "0x2784E") ; <CJK>
       (?$(JML(B . "0x469D") ; <CJK>
       (?$(JMM(B . "0x278FC") ; <CJK>
       (?$(JMN(B . "0x469E") ; <CJK>
       (?$(JMO(B . "0x46A0") ; <CJK>
       (?$(JMP(B . "0x278FA") ; <CJK>
       (?$(JMQ(B . "0x469C") ; <CJK>
       (?$(JMR(B . "0x278FB") ; <CJK>
       (?$(JMS(B . "0x469F") ; <CJK>
       (?$(JMT(B . "0x278FE") ; <CJK>
       (?$(JMU(B . "0x46F7") ; <CJK>
       (?$(JMV(B . "0x46EA") ; <CJK>
       (?$(JMW(B . "0x27A31") ; <CJK>
       (?$(JMX(B . "0x46EF") ; <CJK>
       (?$(JMY(B . "0x46E9") ; <CJK>
       (?$(JMZ(B . "0x46F3") ; <CJK>
       (?$(JM[(B . "0x46F0") ; <CJK>
       (?$(JM\(B . "0x46EB") ; <CJK>
       (?$(JM](B . "0x27A38") ; <CJK>
       (?$(JM^(B . "0x46EC") ; <CJK>
       (?$(JM_(B . "0x46F2") ; <CJK>
       (?$(JM`(B . "0x46F5") ; <CJK>
       (?$(JMa(B . "0x46EE") ; <CJK>
       (?$(JMb(B . "0x27A3A") ; <CJK>
       (?$(JMc(B . "0x27BBB") ; <CJK>
       (?$(JMd(B . "0x473A") ; <CJK>
       (?$(JMe(B . "0x474B") ; <CJK>
       (?$(JMf(B . "0x27C59") ; <CJK>
       (?$(JMg(B . "0x474A") ; <CJK>
       (?$(JMh(B . "0x474C") ; <CJK>
       (?$(JMi(B . "0x27CDB") ; <CJK>
       (?$(JMj(B . "0x27CDF") ; <CJK>
       (?$(JMk(B . "0x27CE2") ; <CJK>
       (?$(JMl(B . "0x4779") ; <CJK>
       (?$(JMm(B . "0x477B") ; <CJK>
       (?$(JMn(B . "0x4778") ; <CJK>
       (?$(JMo(B . "0x27D9E") ; <CJK>
       (?$(JMp(B . "0x27DA1") ; <CJK>
       (?$(JMq(B . "0x47B5") ; <CJK>
       (?$(JMr(B . "0x27F10") ; <CJK>
       (?$(JMs(B . "0x47B4") ; <CJK>
       (?$(JMt(B . "0x47B7") ; <CJK>
       (?$(JMu(B . "0x8D9E") ; <CJK>
       (?$(JMv(B . "0x4809") ; <CJK>
       (?$(JMw(B . "0x47FE") ; <CJK>
       (?$(JMx(B . "0x4808") ; <CJK>
       (?$(JMy(B . "0x4807") ; <CJK>
       (?$(JMz(B . "0x28076") ; <CJK>
       (?$(JM{(B . "0x2807F") ; <CJK>
       (?$(JM|(B . "0x2807D") ; <CJK>
       (?$(JM}(B . "0x4806") ; <CJK>
       (?$(JM~(B . "0x4804") ; <CJK>
       (?$(JN!(B . "0x4805") ; <CJK>
       (?$(JN"(B . "0x47FF") ; <CJK>
       (?$(JN#(B . "0x480B") ; <CJK>
       (?$(JN$(B . "0x28082") ; <CJK>
       (?$(JN%(B . "0x28257") ; <CJK>
       (?$(JN&(B . "0x483B") ; <CJK>
       (?$(JN'(B . "0x485D") ; <CJK>
       (?$(JN((B . "0x485C") ; <CJK>
       (?$(JN)(B . "0x485F") ; <CJK>
       (?$(JN*(B . "0x485E") ; <CJK>
       (?$(JN+(B . "0x8F28") ; <CJK>
       (?$(JN,(B . "0x2832E") ; <CJK>
       (?$(JN-(B . "0x8F21") ; <CJK>
       (?$(JN.(B . "0x4883") ; <CJK>
       (?$(JN/(B . "0x2858B") ; <CJK>
       (?$(JN0(B . "0x2858D") ; <CJK>
       (?$(JN1(B . "0x48A7") ; <CJK>
       (?$(JN2(B . "0x9066") ; <CJK>
       (?$(JN3(B . "0x906C") ; <CJK>
       (?$(JN4(B . "0x28590") ; <CJK>
       (?$(JN5(B . "0x48A8") ; <CJK>
       (?$(JN6(B . "0x286EC") ; <CJK>
       (?$(JN7(B . "0x2876F") ; <CJK>
       (?$(JN8(B . "0x2876B") ; <CJK>
       (?$(JN9(B . "0x28771") ; <CJK>
       (?$(JN:(B . "0x28778") ; <CJK>
       (?$(JN;(B . "0x90F6") ; <CJK>
       (?$(JN<(B . "0x48E0") ; <CJK>
       (?$(JN=(B . "0x48DF") ; <CJK>
       (?$(JN>(B . "0x48FE") ; <CJK>
       (?$(JN?(B . "0x48FC") ; <CJK>
       (?$(JN@(B . "0x48FF") ; <CJK>
       (?$(JNA(B . "0x48FD") ; <CJK>
       (?$(JNB(B . "0x289AD") ; <CJK>
       (?$(JNC(B . "0x492C") ; <CJK>
       (?$(JND(B . "0x92EC") ; <CJK>
       (?$(JNE(B . "0x92BA") ; <CJK>
       (?$(JNF(B . "0x92E3") ; <CJK>
       (?$(JNG(B . "0x92BD") ; <CJK>
       (?$(JNH(B . "0x499D") ; <CJK>
       (?$(JNI(B . "0x28D2F") ; <CJK>
       (?$(JNJ(B . "0x95B4") ; <CJK>
       (?$(JNK(B . "0x28F78") ; <CJK>
       (?$(JNL(B . "0x4A40") ; <CJK>
       (?$(JNM(B . "0x291F8") ; <CJK>
       (?$(JNN(B . "0x29219") ; <CJK>
       (?$(JNO(B . "0x4A5F") ; <CJK>
       (?$(JNP(B . "0x2929B") ; <CJK>
       (?$(JNQ(B . "0x29294") ; <CJK>
       (?$(JNR(B . "0x29297") ; <CJK>
       (?$(JNS(B . "0x29299") ; <CJK>
       (?$(JNT(B . "0x293A6") ; <CJK>
       (?$(JNU(B . "0x293A4") ; <CJK>
       (?$(JNV(B . "0x293A7") ; <CJK>
       (?$(JNW(B . "0x97D1") ; <CJK>
       (?$(JNX(B . "0x29495") ; <CJK>
       (?$(JNY(B . "0x4AC0") ; <CJK>
       (?$(JNZ(B . "0x9823") ; <CJK>
       (?$(JN[(B . "0x29490") ; <CJK>
       (?$(JN\(B . "0x4AC1") ; <CJK>
       (?$(JN](B . "0x4AC6") ; <CJK>
       (?$(JN^(B . "0x2949B") ; <CJK>
       (?$(JN_(B . "0x295C4") ; <CJK>
       (?$(JN`(B . "0x4B04") ; <CJK>
       (?$(JNa(B . "0x4B05") ; <CJK>
       (?$(JNb(B . "0x295C6") ; <CJK>
       (?$(JNc(B . "0x990B") ; <CJK>
       (?$(JNd(B . "0x4B3E") ; <CJK>
       (?$(JNe(B . "0x4B3D") ; <CJK>
       (?$(JNf(B . "0x4B40") ; <CJK>
       (?$(JNg(B . "0x4B3F") ; <CJK>
       (?$(JNh(B . "0x296E3") ; <CJK>
       (?$(JNi(B . "0x4B42") ; <CJK>
       (?$(JNj(B . "0x296DF") ; <CJK>
       (?$(JNk(B . "0x296DD") ; <CJK>
       (?$(JNl(B . "0x296E7") ; <CJK>
       (?$(JNm(B . "0x4B84") ; <CJK>
       (?$(JNn(B . "0x4B82") ; <CJK>
       (?$(JNo(B . "0x4B7F") ; <CJK>
       (?$(JNp(B . "0x4B85") ; <CJK>
       (?$(JNq(B . "0x29A2D") ; <CJK>
       (?$(JNr(B . "0x29A2C") ; <CJK>
       (?$(JNs(B . "0x4BCC") ; <CJK>
       (?$(JNt(B . "0x9AB2") ; <CJK>
       (?$(JNu(B . "0x4BCB") ; <CJK>
       (?$(JNv(B . "0x4BCD") ; <CJK>
       (?$(JNw(B . "0x29A34") ; <CJK>
       (?$(JNx(B . "0x29A38") ; <CJK>
       (?$(JNy(B . "0x9ADB") ; <CJK>
       (?$(JNz(B . "0x29B1D") ; <CJK>
       (?$(JN{(B . "0x4BF5") ; <CJK>
       (?$(JN|(B . "0x29B1A") ; <CJK>
       (?$(JN}(B . "0x29B1B") ; <CJK>
       (?$(JN~(B . "0x29B14") ; <CJK>
       (?$(JO!(B . "0x9AF0") ; <CJK>
       (?$(JO"(B . "0x29B17") ; <CJK>
       (?$(JO#(B . "0x29C21") ; <CJK>
       (?$(JO$(B . "0x4C20") ; <CJK>
       (?$(JO%(B . "0x4C21") ; <CJK>
       (?$(JO&(B . "0x29CAA") ; <CJK>
       (?$(JO'(B . "0x29CA1") ; <CJK>
       (?$(JO((B . "0x4C37") ; <CJK>
       (?$(JO)(B . "0x4C3E") ; <CJK>
       (?$(JO*(B . "0x9B73") ; <CJK>
       (?$(JO+(B . "0x4C3D") ; <CJK>
       (?$(JO,(B . "0x9B6E") ; <CJK>
       (?$(JO-(B . "0x29D63") ; <CJK>
       (?$(JO.(B . "0x29D79") ; <CJK>
       (?$(JO/(B . "0x29D60") ; <CJK>
       (?$(JO0(B . "0x9B65") ; <CJK>
       (?$(JO1(B . "0x29D62") ; <CJK>
       (?$(JO2(B . "0x4C3C") ; <CJK>
       (?$(JO3(B . "0x29D61") ; <CJK>
       (?$(JO4(B . "0x4C38") ; <CJK>
       (?$(JO5(B . "0x9B6A") ; <CJK>
       (?$(JO6(B . "0x29D70") ; <CJK>
       (?$(JO7(B . "0x9B6D") ; <CJK>
       (?$(JO8(B . "0x29D6A") ; <CJK>
       (?$(JO9(B . "0x4C3B") ; <CJK>
       (?$(JO:(B . "0x29FC8") ; <CJK>
       (?$(JO;(B . "0x4CB0") ; <CJK>
       (?$(JO<(B . "0x29FC5") ; <CJK>
       (?$(JO=(B . "0x29FBE") ; <CJK>
       (?$(JO>(B . "0x29FC2") ; <CJK>
       (?$(JO?(B . "0x4CAD") ; <CJK>
       (?$(JO@(B . "0x4CB2") ; <CJK>
       (?$(JOA(B . "0x4CB8") ; <CJK>
       (?$(JOB(B . "0x9D0B") ; <CJK>
       (?$(JOC(B . "0x29FC7") ; <CJK>
       (?$(JOD(B . "0x4CAF") ; <CJK>
       (?$(JOE(B . "0x29FB0") ; <CJK>
       (?$(JOF(B . "0x29FCA") ; <CJK>
       (?$(JOG(B . "0x4D1A") ; <CJK>
       (?$(JOH(B . "0x9E76") ; <CJK>
       (?$(JOI(B . "0x4D20") ; <CJK>
       (?$(JOJ(B . "0x4D21") ; <CJK>
       (?$(JOK(B . "0x4D30") ; <CJK>
       (?$(JOL(B . "0x9EA8") ; <CJK>
       (?$(JOM(B . "0x4D2F") ; <CJK>
       (?$(JON(B . "0x2A30D") ; <CJK>
       (?$(JOO(B . "0x2A307") ; <CJK>
       (?$(JOP(B . "0x2A396") ; <CJK>
       (?$(JOQ(B . "0x2A3EF") ; <CJK>
       (?$(JOR(B . "0x4D5F") ; <CJK>
       (?$(JOS(B . "0x4D60") ; <CJK>
       (?$(JOT(B . "0x2A41E") ; <CJK>
       (?$(JOU(B . "0x2A41D") ; <CJK>
       (?$(JOV(B . "0x9F11") ; <CJK>
       (?$(JOW(B . "0x2A590") ; <CJK>
       (?$(JOX(B . "0x203EB") ; <CJK>
       (?$(JOY(B . "0x348A") ; <CJK>
       (?$(JOZ(B . "0x5119") ; <CJK>
       (?$(JO[(B . "0x349C") ; <CJK>
       (?$(JO\(B . "0x203EE") ; <CJK>
       (?$(JO](B . "0x349A") ; <CJK>
       (?$(JO^(B . "0x203EF") ; <CJK>
       (?$(JO_(B . "0x203EC") ; <CJK>
       (?$(JO`(B . "0x207FA") ; <CJK>
       (?$(JOa(B . "0x350C") ; <CJK>
       (?$(JOb(B . "0x350B") ; <CJK>
       (?$(JOc(B . "0x350D") ; <CJK>
       (?$(JOd(B . "0x5292") ; <CJK>
       (?$(JOe(B . "0x20904") ; <CJK>
       (?$(JOf(B . "0x20FD3") ; <CJK>
       (?$(JOg(B . "0x35FE") ; <CJK>
       (?$(JOh(B . "0x20FD1") ; <CJK>
       (?$(JOi(B . "0x20FFA") ; <CJK>
       (?$(JOj(B . "0x35FF") ; <CJK>
       (?$(JOk(B . "0x35FB") ; <CJK>
       (?$(JOl(B . "0x35FC") ; <CJK>
       (?$(JOm(B . "0x3609") ; <CJK>
       (?$(JOn(B . "0x20FC8") ; <CJK>
       (?$(JOo(B . "0x3600") ; <CJK>
       (?$(JOp(B . "0x20FD5") ; <CJK>
       (?$(JOq(B . "0x5675") ; <CJK>
       (?$(JOr(B . "0x20FCD") ; <CJK>
       (?$(JOs(B . "0x20FD2") ; <CJK>
       (?$(JOt(B . "0x20FFB") ; <CJK>
       (?$(JOu(B . "0x2122A") ; <CJK>
       (?$(JOv(B . "0x21488") ; <CJK>
       (?$(JOw(B . "0x21461") ; <CJK>
       (?$(JOx(B . "0x3671") ; <CJK>
       (?$(JOy(B . "0x21463") ; <CJK>
       (?$(JOz(B . "0x21462") ; <CJK>
       (?$(JO{(B . "0x596F") ; <CJK>
       (?$(JO|(B . "0x20057") ; <CJK>
       (?$(JO}(B . "0x218C8") ; <CJK>
       (?$(JO~(B . "0x21898") ; <CJK>
       (?$(JP!(B . "0x372B") ; <CJK>
       (?$(JP"(B . "0x21AC1") ; <CJK>
       (?$(JP#(B . "0x21F3F") ; <CJK>
       (?$(JP$(B . "0x21F41") ; <CJK>
       (?$(JP%(B . "0x3814") ; <CJK>
       (?$(JP&(B . "0x3811") ; <CJK>
       (?$(JP'(B . "0x3812") ; <CJK>
       (?$(JP((B . "0x22152") ; <CJK>
       (?$(JP)(B . "0x3863") ; <CJK>
       (?$(JP*(B . "0x2215E") ; <CJK>
       (?$(JP+(B . "0x386E") ; <CJK>
       (?$(JP,(B . "0x389A") ; <CJK>
       (?$(JP-(B . "0x222C7") ; <CJK>
       (?$(JP.(B . "0x389B") ; <CJK>
       (?$(JP/(B . "0x22370") ; <CJK>
       (?$(JP0(B . "0x22427") ; <CJK>
       (?$(JP1(B . "0x38C8") ; <CJK>
       (?$(JP2(B . "0x22471") ; <CJK>
       (?$(JP3(B . "0x224B0") ; <CJK>
       (?$(JP4(B . "0x38F6") ; <CJK>
       (?$(JP5(B . "0x22842") ; <CJK>
       (?$(JP6(B . "0x22843") ; <CJK>
       (?$(JP7(B . "0x61A5") ; <CJK>
       (?$(JP8(B . "0x398C") ; <CJK>
       (?$(JP9(B . "0x3997") ; <CJK>
       (?$(JP:(B . "0x39A2") ; <CJK>
       (?$(JP;(B . "0x61A0") ; <CJK>
       (?$(JP<(B . "0x22857") ; <CJK>
       (?$(JP=(B . "0x2289D") ; <CJK>
       (?$(JP>(B . "0x22D89") ; <CJK>
       (?$(JP?(B . "0x22D8D") ; <CJK>
       (?$(JP@(B . "0x22D8B") ; <CJK>
       (?$(JPA(B . "0x22D80") ; <CJK>
       (?$(JPB(B . "0x22D92") ; <CJK>
       (?$(JPC(B . "0x22D8A") ; <CJK>
       (?$(JPD(B . "0x22DC8") ; <CJK>
       (?$(JPE(B . "0x3A54") ; <CJK>
       (?$(JPF(B . "0x22D8F") ; <CJK>
       (?$(JPG(B . "0x22D93") ; <CJK>
       (?$(JPH(B . "0x22D91") ; <CJK>
       (?$(JPI(B . "0x3AA8") ; <CJK>
       (?$(JPJ(B . "0x22FF2") ; <CJK>
       (?$(JPK(B . "0x22FDE") ; <CJK>
       (?$(JPL(B . "0x3AA9") ; <CJK>
       (?$(JPM(B . "0x230C8") ; <CJK>
       (?$(JPN(B . "0x65B4") ; <CJK>
       (?$(JPO(B . "0x65D8") ; <CJK>
       (?$(JPP(B . "0x66C2") ; <CJK>
       (?$(JPQ(B . "0x3B18") ; <CJK>
       (?$(JPR(B . "0x3B17") ; <CJK>
       (?$(JPS(B . "0x3B1D") ; <CJK>
       (?$(JPT(B . "0x232A7") ; <CJK>
       (?$(JPU(B . "0x232A1") ; <CJK>
       (?$(JPV(B . "0x3B31") ; <CJK>
       (?$(JPW(B . "0x2368C") ; <CJK>
       (?$(JPX(B . "0x2367F") ; <CJK>
       (?$(JPY(B . "0x3BD8") ; <CJK>
       (?$(JPZ(B . "0x3BD5") ; <CJK>
       (?$(JP[(B . "0x2367B") ; <CJK>
       (?$(JP\(B . "0x23695") ; <CJK>
       (?$(JP](B . "0x23699") ; <CJK>
       (?$(JP^(B . "0x3BE1") ; <CJK>
       (?$(JP_(B . "0x2368E") ; <CJK>
       (?$(JP`(B . "0x3BD4") ; <CJK>
       (?$(JPa(B . "0x236DA") ; <CJK>
       (?$(JPb(B . "0x2368A") ; <CJK>
       (?$(JPc(B . "0x2369C") ; <CJK>
       (?$(JPd(B . "0x3BE3") ; <CJK>
       (?$(JPe(B . "0x2367E") ; <CJK>
       (?$(JPf(B . "0x3C44") ; <CJK>
       (?$(JPg(B . "0x3C45") ; <CJK>
       (?$(JPh(B . "0x2391A") ; <CJK>
       (?$(JPi(B . "0x23A55") ; <CJK>
       (?$(JPj(B . "0x3C76") ; <CJK>
       (?$(JPk(B . "0x3C75") ; <CJK>
       (?$(JPl(B . "0x23A60") ; <CJK>
       (?$(JPm(B . "0x6BA8") ; <CJK>
       (?$(JPn(B . "0x3C88") ; <CJK>
       (?$(JPo(B . "0x3CAA") ; <CJK>
       (?$(JPp(B . "0x23BFB") ; <CJK>
       (?$(JPq(B . "0x3CAB") ; <CJK>
       (?$(JPr(B . "0x3CAC") ; <CJK>
       (?$(JPs(B . "0x23BFD") ; <CJK>
       (?$(JPt(B . "0x3D57") ; <CJK>
       (?$(JPu(B . "0x6F83") ; <CJK>
       (?$(JPv(B . "0x3D60") ; <CJK>
       (?$(JPw(B . "0x3D5D") ; <CJK>
       (?$(JPx(B . "0x3D6B") ; <CJK>
       (?$(JPy(B . "0x23FD0") ; <CJK>
       (?$(JPz(B . "0x3D63") ; <CJK>
       (?$(JP{(B . "0x3D67") ; <CJK>
       (?$(JP|(B . "0x23FC5") ; <CJK>
       (?$(JP}(B . "0x3D5E") ; <CJK>
       (?$(JP~(B . "0x23FD2") ; <CJK>
       (?$(JQ!(B . "0x24011") ; <CJK>
       (?$(JQ"(B . "0x6FC5") ; <CJK>
       (?$(JQ#(B . "0x71CD") ; <CJK>
       (?$(JQ$(B . "0x3DF9") ; <CJK>
       (?$(JQ%(B . "0x3DF3") ; <CJK>
       (?$(JQ&(B . "0x243AD") ; <CJK>
       (?$(JQ'(B . "0x243A4") ; <CJK>
       (?$(JQ((B . "0x243A9") ; <CJK>
       (?$(JQ)(B . "0x243B0") ; <CJK>
       (?$(JQ*(B . "0x2439D") ; <CJK>
       (?$(JQ+(B . "0x3DF6") ; <CJK>
       (?$(JQ,(B . "0x24598") ; <CJK>
       (?$(JQ-(B . "0x729C") ; <CJK>
       (?$(JQ.(B . "0x3E51") ; <CJK>
       (?$(JQ/(B . "0x3E53") ; <CJK>
       (?$(JQ0(B . "0x3E52") ; <CJK>
       (?$(JQ1(B . "0x24892") ; <CJK>
       (?$(JQ2(B . "0x3E9B") ; <CJK>
       (?$(JQ3(B . "0x2488A") ; <CJK>
       (?$(JQ4(B . "0x3E9C") ; <CJK>
       (?$(JQ5(B . "0x2488D") ; <CJK>
       (?$(JQ6(B . "0x24896") ; <CJK>
       (?$(JQ7(B . "0x3EF7") ; <CJK>
       (?$(JQ8(B . "0x7499") ; <CJK>
       (?$(JQ9(B . "0x748F") ; <CJK>
       (?$(JQ:(B . "0x7491") ; <CJK>
       (?$(JQ;(B . "0x24A45") ; <CJK>
       (?$(JQ<(B . "0x24A4B") ; <CJK>
       (?$(JQ=(B . "0x24B0F") ; <CJK>
       (?$(JQ>(B . "0x24B16") ; <CJK>
       (?$(JQ?(B . "0x3F3B") ; <CJK>
       (?$(JQ@(B . "0x24B8A") ; <CJK>
       (?$(JQA(B . "0x3F3E") ; <CJK>
       (?$(JQB(B . "0x3F3D") ; <CJK>
       (?$(JQC(B . "0x24CC9") ; <CJK>
       (?$(JQD(B . "0x3F69") ; <CJK>
       (?$(JQE(B . "0x24CC8") ; <CJK>
       (?$(JQF(B . "0x24CCA") ; <CJK>
       (?$(JQG(B . "0x24E64") ; <CJK>
       (?$(JQH(B . "0x3FC3") ; <CJK>
       (?$(JQI(B . "0x3FC4") ; <CJK>
       (?$(JQJ(B . "0x3FC7") ; <CJK>
       (?$(JQK(B . "0x24E5D") ; <CJK>
       (?$(JQL(B . "0x24E63") ; <CJK>
       (?$(JQM(B . "0x7639") ; <CJK>
       (?$(JQN(B . "0x3FC6") ; <CJK>
       (?$(JQO(B . "0x762E") ; <CJK>
       (?$(JQP(B . "0x3FC8") ; <CJK>
       (?$(JQQ(B . "0x24E88") ; <CJK>
       (?$(JQR(B . "0x24F3A") ; <CJK>
       (?$(JQS(B . "0x24F39") ; <CJK>
       (?$(JQT(B . "0x769F") ; <CJK>
       (?$(JQU(B . "0x76A0") ; <CJK>
       (?$(JQV(B . "0x3FE6") ; <CJK>
       (?$(JQW(B . "0x3FF8") ; <CJK>
       (?$(JQX(B . "0x25017") ; <CJK>
       (?$(JQY(B . "0x25093") ; <CJK>
       (?$(JQZ(B . "0x4007") ; <CJK>
       (?$(JQ[(B . "0x25095") ; <CJK>
       (?$(JQ\(B . "0x4064") ; <CJK>
       (?$(JQ](B . "0x4068") ; <CJK>
       (?$(JQ^(B . "0x25276") ; <CJK>
       (?$(JQ_(B . "0x7794") ; <CJK>
       (?$(JQ`(B . "0x4065") ; <CJK>
       (?$(JQa(B . "0x77AE") ; <CJK>
       (?$(JQb(B . "0x25280") ; <CJK>
       (?$(JQc(B . "0x2527B") ; <CJK>
       (?$(JQd(B . "0x4069") ; <CJK>
       (?$(JQe(B . "0x25248") ; <CJK>
       (?$(JQf(B . "0x252A8") ; <CJK>
       (?$(JQg(B . "0x25288") ; <CJK>
       (?$(JQh(B . "0x2538B") ; <CJK>
       (?$(JQi(B . "0x2538A") ; <CJK>
       (?$(JQj(B . "0x2538C") ; <CJK>
       (?$(JQk(B . "0x253FC") ; <CJK>
       (?$(JQl(B . "0x40DA") ; <CJK>
       (?$(JQm(B . "0x40E0") ; <CJK>
       (?$(JQn(B . "0x78E6") ; <CJK>
       (?$(JQo(B . "0x25558") ; <CJK>
       (?$(JQp(B . "0x40DE") ; <CJK>
       (?$(JQq(B . "0x25551") ; <CJK>
       (?$(JQr(B . "0x25555") ; <CJK>
       (?$(JQs(B . "0x25553") ; <CJK>
       (?$(JQt(B . "0x411C") ; <CJK>
       (?$(JQu(B . "0x411D") ; <CJK>
       (?$(JQv(B . "0x411A") ; <CJK>
       (?$(JQw(B . "0x256DC") ; <CJK>
       (?$(JQx(B . "0x417B") ; <CJK>
       (?$(JQy(B . "0x417A") ; <CJK>
       (?$(JQz(B . "0x417C") ; <CJK>
       (?$(JQ{(B . "0x2585C") ; <CJK>
       (?$(JQ|(B . "0x4178") ; <CJK>
       (?$(JQ}(B . "0x4177") ; <CJK>
       (?$(JQ~(B . "0x25865") ; <CJK>
       (?$(JR!(B . "0x2F95A") ; <CJK>
       (?$(JR"(B . "0x41B1") ; <CJK>
       (?$(JR#(B . "0x259EE") ; <CJK>
       (?$(JR$(B . "0x41B2") ; <CJK>
       (?$(JR%(B . "0x41B0") ; <CJK>
       (?$(JR&(B . "0x259F0") ; <CJK>
       (?$(JR'(B . "0x7ABC") ; <CJK>
       (?$(JR((B . "0x259F2") ; <CJK>
       (?$(JR)(B . "0x4236") ; <CJK>
       (?$(JR*(B . "0x25C35") ; <CJK>
       (?$(JR+(B . "0x422E") ; <CJK>
       (?$(JR,(B . "0x25C22") ; <CJK>
       (?$(JR-(B . "0x7BD6") ; <CJK>
       (?$(JR.(B . "0x25C20") ; <CJK>
       (?$(JR/(B . "0x4234") ; <CJK>
       (?$(JR0(B . "0x25C2D") ; <CJK>
       (?$(JR1(B . "0x25C28") ; <CJK>
       (?$(JR2(B . "0x25C26") ; <CJK>
       (?$(JR3(B . "0x25C3C") ; <CJK>
       (?$(JR4(B . "0x422A") ; <CJK>
       (?$(JR5(B . "0x25C38") ; <CJK>
       (?$(JR6(B . "0x4233") ; <CJK>
       (?$(JR7(B . "0x422D") ; <CJK>
       (?$(JR8(B . "0x422F") ; <CJK>
       (?$(JR9(B . "0x4231") ; <CJK>
       (?$(JR:(B . "0x422B") ; <CJK>
       (?$(JR;(B . "0x4232") ; <CJK>
       (?$(JR<(B . "0x25C2A") ; <CJK>
       (?$(JR=(B . "0x4235") ; <CJK>
       (?$(JR>(B . "0x25C1A") ; <CJK>
       (?$(JR?(B . "0x25C30") ; <CJK>
       (?$(JR@(B . "0x25BE3") ; <CJK>
       (?$(JRA(B . "0x25C19") ; <CJK>
       (?$(JRB(B . "0x25EE9") ; <CJK>
       (?$(JRC(B . "0x25EE7") ; <CJK>
       (?$(JRD(B . "0x7CCF") ; <CJK>
       (?$(JRE(B . "0x260D6") ; <CJK>
       (?$(JRF(B . "0x260C4") ; <CJK>
       (?$(JRG(B . "0x4308") ; <CJK>
       (?$(JRH(B . "0x26087") ; <CJK>
       (?$(JRI(B . "0x4306") ; <CJK>
       (?$(JRJ(B . "0x260C7") ; <CJK>
       (?$(JRK(B . "0x260D9") ; <CJK>
       (?$(JRL(B . "0x7E18") ; <CJK>
       (?$(JRM(B . "0x260DF") ; <CJK>
       (?$(JRN(B . "0x434D") ; <CJK>
       (?$(JRO(B . "0x4361") ; <CJK>
       (?$(JRP(B . "0x2630A") ; <CJK>
       (?$(JRQ(B . "0x26301") ; <CJK>
       (?$(JRR(B . "0x263B1") ; <CJK>
       (?$(JRS(B . "0x4378") ; <CJK>
       (?$(JRT(B . "0x263C1") ; <CJK>
       (?$(JRU(B . "0x4394") ; <CJK>
       (?$(JRV(B . "0x4395") ; <CJK>
       (?$(JRW(B . "0x26476") ; <CJK>
       (?$(JRX(B . "0x2650D") ; <CJK>
       (?$(JRY(B . "0x2650E") ; <CJK>
       (?$(JRZ(B . "0x43C1") ; <CJK>
       (?$(JR[(B . "0x43C3") ; <CJK>
       (?$(JR\(B . "0x806D") ; <CJK>
       (?$(JR](B . "0x26807") ; <CJK>
       (?$(JR^(B . "0x4439") ; <CJK>
       (?$(JR_(B . "0x26809") ; <CJK>
       (?$(JR`(B . "0x26816") ; <CJK>
       (?$(JRa(B . "0x443A") ; <CJK>
       (?$(JRb(B . "0x443B") ; <CJK>
       (?$(JRc(B . "0x4435") ; <CJK>
       (?$(JRd(B . "0x4436") ; <CJK>
       (?$(JRe(B . "0x2680E") ; <CJK>
       (?$(JRf(B . "0x443C") ; <CJK>
       (?$(JRg(B . "0x8190") ; <CJK>
       (?$(JRh(B . "0x26806") ; <CJK>
       (?$(JRi(B . "0x2691E") ; <CJK>
       (?$(JRj(B . "0x2694A") ; <CJK>
       (?$(JRk(B . "0x4458") ; <CJK>
       (?$(JRl(B . "0x447C") ; <CJK>
       (?$(JRm(B . "0x447D") ; <CJK>
       (?$(JRn(B . "0x448D") ; <CJK>
       (?$(JRo(B . "0x448C") ; <CJK>
       (?$(JRp(B . "0x26EA6") ; <CJK>
       (?$(JRq(B . "0x26E91") ; <CJK>
       (?$(JRr(B . "0x453B") ; <CJK>
       (?$(JRs(B . "0x453F") ; <CJK>
       (?$(JRt(B . "0x26EB8") ; <CJK>
       (?$(JRu(B . "0x26E96") ; <CJK>
       (?$(JRv(B . "0x4532") ; <CJK>
       (?$(JRw(B . "0x452D") ; <CJK>
       (?$(JRx(B . "0x26EC5") ; <CJK>
       (?$(JRy(B . "0x452F") ; <CJK>
       (?$(JRz(B . "0x4539") ; <CJK>
       (?$(JR{(B . "0x452E") ; <CJK>
       (?$(JR|(B . "0x453A") ; <CJK>
       (?$(JR}(B . "0x26F0A") ; <CJK>
       (?$(JR~(B . "0x4536") ; <CJK>
       (?$(JS!(B . "0x4531") ; <CJK>
       (?$(JS"(B . "0x453E") ; <CJK>
       (?$(JS#(B . "0x4538") ; <CJK>
       (?$(JS$(B . "0x8552") ; <CJK>
       (?$(JS%(B . "0x4534") ; <CJK>
       (?$(JS&(B . "0x26EB2") ; <CJK>
       (?$(JS'(B . "0x4541") ; <CJK>
       (?$(JS((B . "0x26EB7") ; <CJK>
       (?$(JS)(B . "0x26EB4") ; <CJK>
       (?$(JS*(B . "0x26E89") ; <CJK>
       (?$(JS+(B . "0x26E8D") ; <CJK>
       (?$(JS,(B . "0x4530") ; <CJK>
       (?$(JS-(B . "0x26E87") ; <CJK>
       (?$(JS.(B . "0x26EC2") ; <CJK>
       (?$(JS/(B . "0x26E9C") ; <CJK>
       (?$(JS0(B . "0x26E92") ; <CJK>
       (?$(JS1(B . "0x4543") ; <CJK>
       (?$(JS2(B . "0x26ECA") ; <CJK>
       (?$(JS3(B . "0x8550") ; <CJK>
       (?$(JS4(B . "0x26E8A") ; <CJK>
       (?$(JS5(B . "0x271E0") ; <CJK>
       (?$(JS6(B . "0x4598") ; <CJK>
       (?$(JS7(B . "0x271E6") ; <CJK>
       (?$(JS8(B . "0x271E5") ; <CJK>
       (?$(JS9(B . "0x87A0") ; <CJK>
       (?$(JS:(B . "0x273A5") ; <CJK>
       (?$(JS;(B . "0x273B3") ; <CJK>
       (?$(JS<(B . "0x8786") ; <CJK>
       (?$(JS=(B . "0x45DA") ; <CJK>
       (?$(JS>(B . "0x45D7") ; <CJK>
       (?$(JS?(B . "0x273B5") ; <CJK>
       (?$(JS@(B . "0x273AF") ; <CJK>
       (?$(JSA(B . "0x8795") ; <CJK>
       (?$(JSB(B . "0x273B0") ; <CJK>
       (?$(JSC(B . "0x273CC") ; <CJK>
       (?$(JSD(B . "0x878C") ; <CJK>
       (?$(JSE(B . "0x273A2") ; <CJK>
       (?$(JSF(B . "0x273BE") ; <CJK>
       (?$(JSG(B . "0x273C6") ; <CJK>
       (?$(JSH(B . "0x273AC") ; <CJK>
       (?$(JSI(B . "0x273AE") ; <CJK>
       (?$(JSJ(B . "0x4618") ; <CJK>
       (?$(JSK(B . "0x8860") ; <CJK>
       (?$(JSL(B . "0x2F9C3") ; <CJK>
       (?$(JSM(B . "0x27708") ; <CJK>
       (?$(JSN(B . "0x27705") ; <CJK>
       (?$(JSO(B . "0x4652") ; <CJK>
       (?$(JSP(B . "0x8928") ; <CJK>
       (?$(JSQ(B . "0x276FE") ; <CJK>
       (?$(JSR(B . "0x464E") ; <CJK>
       (?$(JSS(B . "0x8920") ; <CJK>
       (?$(JST(B . "0x27700") ; <CJK>
       (?$(JSU(B . "0x464F") ; <CJK>
       (?$(JSV(B . "0x4650") ; <CJK>
       (?$(JSW(B . "0x27864") ; <CJK>
       (?$(JSX(B . "0x27868") ; <CJK>
       (?$(JSY(B . "0x89A8") ; <CJK>
       (?$(JSZ(B . "0x4686") ; <CJK>
       (?$(JS[(B . "0x4687") ; <CJK>
       (?$(JS\(B . "0x4689") ; <CJK>
       (?$(JS](B . "0x2786A") ; <CJK>
       (?$(JS^(B . "0x27869") ; <CJK>
       (?$(JS_(B . "0x2790D") ; <CJK>
       (?$(JS`(B . "0x27912") ; <CJK>
       (?$(JSa(B . "0x46A2") ; <CJK>
       (?$(JSb(B . "0x46A3") ; <CJK>
       (?$(JSc(B . "0x2790F") ; <CJK>
       (?$(JSd(B . "0x46A1") ; <CJK>
       (?$(JSe(B . "0x27A67") ; <CJK>
       (?$(JSf(B . "0x27A79") ; <CJK>
       (?$(JSg(B . "0x27A72") ; <CJK>
       (?$(JSh(B . "0x27A66") ; <CJK>
       (?$(JSi(B . "0x27A7C") ; <CJK>
       (?$(JSj(B . "0x46F9") ; <CJK>
       (?$(JSk(B . "0x46FD") ; <CJK>
       (?$(JSl(B . "0x27A68") ; <CJK>
       (?$(JSm(B . "0x27A85") ; <CJK>
       (?$(JSn(B . "0x27A76") ; <CJK>
       (?$(JSo(B . "0x27A74") ; <CJK>
       (?$(JSp(B . "0x27A71") ; <CJK>
       (?$(JSq(B . "0x27A64") ; <CJK>
       (?$(JSr(B . "0x473E") ; <CJK>
       (?$(JSs(B . "0x473C") ; <CJK>
       (?$(JSt(B . "0x27BF8") ; <CJK>
       (?$(JSu(B . "0x474D") ; <CJK>
       (?$(JSv(B . "0x27C6C") ; <CJK>
       (?$(JSw(B . "0x474E") ; <CJK>
       (?$(JSx(B . "0x27CEB") ; <CJK>
       (?$(JSy(B . "0x4781") ; <CJK>
       (?$(JSz(B . "0x4783") ; <CJK>
       (?$(JS{(B . "0x4782") ; <CJK>
       (?$(JS|(B . "0x27DB8") ; <CJK>
       (?$(JS}(B . "0x4780") ; <CJK>
       (?$(JS~(B . "0x4788") ; <CJK>
       (?$(JT!(B . "0x27F2D") ; <CJK>
       (?$(JT"(B . "0x27F2E") ; <CJK>
       (?$(JT#(B . "0x27F28") ; <CJK>
       (?$(JT$(B . "0x27F29") ; <CJK>
       (?$(JT%(B . "0x27F31") ; <CJK>
       (?$(JT&(B . "0x47B9") ; <CJK>
       (?$(JT'(B . "0x27F2F") ; <CJK>
       (?$(JT((B . "0x27F2A") ; <CJK>
       (?$(JT)(B . "0x8E3A") ; <CJK>
       (?$(JT*(B . "0x280A4") ; <CJK>
       (?$(JT+(B . "0x280B7") ; <CJK>
       (?$(JT,(B . "0x280BF") ; <CJK>
       (?$(JT-(B . "0x4811") ; <CJK>
       (?$(JT.(B . "0x480D") ; <CJK>
       (?$(JT/(B . "0x4810") ; <CJK>
       (?$(JT0(B . "0x4813") ; <CJK>
       (?$(JT1(B . "0x28263") ; <CJK>
       (?$(JT2(B . "0x483C") ; <CJK>
       (?$(JT3(B . "0x4862") ; <CJK>
       (?$(JT4(B . "0x4863") ; <CJK>
       (?$(JT5(B . "0x28367") ; <CJK>
       (?$(JT6(B . "0x285BE") ; <CJK>
       (?$(JT7(B . "0x2F9E0") ; <CJK>
       (?$(JT8(B . "0x28795") ; <CJK>
       (?$(JT9(B . "0x2879C") ; <CJK>
       (?$(JT:(B . "0x4903") ; <CJK>
       (?$(JT;(B . "0x4906") ; <CJK>
       (?$(JT<(B . "0x4902") ; <CJK>
       (?$(JT=(B . "0x4901") ; <CJK>
       (?$(JT>(B . "0x28871") ; <CJK>
       (?$(JT?(B . "0x28872") ; <CJK>
       (?$(JT@(B . "0x4905") ; <CJK>
       (?$(JTA(B . "0x2886F") ; <CJK>
       (?$(JTB(B . "0x9194") ; <CJK>
       (?$(JTC(B . "0x9311") ; <CJK>
       (?$(JTD(B . "0x289F1") ; <CJK>
       (?$(JTE(B . "0x9337") ; <CJK>
       (?$(JTF(B . "0x4936") ; <CJK>
       (?$(JTG(B . "0x289E8") ; <CJK>
       (?$(JTH(B . "0x4935") ; <CJK>
       (?$(JTI(B . "0x9343") ; <CJK>
       (?$(JTJ(B . "0x2F9EA") ; <CJK>
       (?$(JTK(B . "0x49A1") ; <CJK>
       (?$(JTL(B . "0x49A3") ; <CJK>
       (?$(JTM(B . "0x28D49") ; <CJK>
       (?$(JTN(B . "0x28D64") ; <CJK>
       (?$(JTO(B . "0x49A0") ; <CJK>
       (?$(JTP(B . "0x28D48") ; <CJK>
       (?$(JTQ(B . "0x49EA") ; <CJK>
       (?$(JTR(B . "0x96A6") ; <CJK>
       (?$(JTS(B . "0x49E8") ; <CJK>
       (?$(JTT(B . "0x28F2C") ; <CJK>
       (?$(JTU(B . "0x28FE1") ; <CJK>
       (?$(JTV(B . "0x28FEF") ; <CJK>
       (?$(JTW(B . "0x290C0") ; <CJK>
       (?$(JTX(B . "0x4A21") ; <CJK>
       (?$(JTY(B . "0x4A1B") ; <CJK>
       (?$(JTZ(B . "0x290D7") ; <CJK>
       (?$(JT[(B . "0x290D4") ; <CJK>
       (?$(JT\(B . "0x4A49") ; <CJK>
       (?$(JT](B . "0x4A48") ; <CJK>
       (?$(JT^(B . "0x292AD") ; <CJK>
       (?$(JT_(B . "0x9795") ; <CJK>
       (?$(JT`(B . "0x4A62") ; <CJK>
       (?$(JTa(B . "0x4A61") ; <CJK>
       (?$(JTb(B . "0x4A64") ; <CJK>
       (?$(JTc(B . "0x4A60") ; <CJK>
       (?$(JTd(B . "0x4A63") ; <CJK>
       (?$(JTe(B . "0x292AE") ; <CJK>
       (?$(JTf(B . "0x292AC") ; <CJK>
       (?$(JTg(B . "0x9796") ; <CJK>
       (?$(JTh(B . "0x4A66") ; <CJK>
       (?$(JTi(B . "0x4AAC") ; <CJK>
       (?$(JTj(B . "0x4AAB") ; <CJK>
       (?$(JTk(B . "0x29427") ; <CJK>
       (?$(JTl(B . "0x294AE") ; <CJK>
       (?$(JTm(B . "0x4AC3") ; <CJK>
       (?$(JTn(B . "0x294B0") ; <CJK>
       (?$(JTo(B . "0x4AC4") ; <CJK>
       (?$(JTp(B . "0x9825") ; <CJK>
       (?$(JTq(B . "0x294C0") ; <CJK>
       (?$(JTr(B . "0x294C4") ; <CJK>
       (?$(JTs(B . "0x4B08") ; <CJK>
       (?$(JTt(B . "0x4B09") ; <CJK>
       (?$(JTu(B . "0x4B0A") ; <CJK>
       (?$(JTv(B . "0x4B06") ; <CJK>
       (?$(JTw(B . "0x4B07") ; <CJK>
       (?$(JTx(B . "0x4B41") ; <CJK>
       (?$(JTy(B . "0x29707") ; <CJK>
       (?$(JTz(B . "0x4B45") ; <CJK>
       (?$(JT{(B . "0x296FD") ; <CJK>
       (?$(JT|(B . "0x4B43") ; <CJK>
       (?$(JT}(B . "0x4B44") ; <CJK>
       (?$(JT~(B . "0x9926") ; <CJK>
       (?$(JU!(B . "0x9934") ; <CJK>
       (?$(JU"(B . "0x4B47") ; <CJK>
       (?$(JU#(B . "0x2FA04") ; <CJK>
       (?$(JU$(B . "0x2981B") ; <CJK>
       (?$(JU%(B . "0x2981C") ; <CJK>
       (?$(JU&(B . "0x4B71") ; <CJK>
       (?$(JU'(B . "0x298B2") ; <CJK>
       (?$(JU((B . "0x298B4") ; <CJK>
       (?$(JU)(B . "0x298B7") ; <CJK>
       (?$(JU*(B . "0x298B1") ; <CJK>
       (?$(JU+(B . "0x298B3") ; <CJK>
       (?$(JU,(B . "0x298AE") ; <CJK>
       (?$(JU-(B . "0x4B8B") ; <CJK>
       (?$(JU.(B . "0x4BD4") ; <CJK>
       (?$(JU/(B . "0x4BD3") ; <CJK>
       (?$(JU0(B . "0x4BD1") ; <CJK>
       (?$(JU1(B . "0x9ABA") ; <CJK>
       (?$(JU2(B . "0x4BD2") ; <CJK>
       (?$(JU3(B . "0x29A3F") ; <CJK>
       (?$(JU4(B . "0x29B36") ; <CJK>
       (?$(JU5(B . "0x4BF7") ; <CJK>
       (?$(JU6(B . "0x4BF8") ; <CJK>
       (?$(JU7(B . "0x29B31") ; <CJK>
       (?$(JU8(B . "0x29B3B") ; <CJK>
       (?$(JU9(B . "0x29B35") ; <CJK>
       (?$(JU:(B . "0x29B3A") ; <CJK>
       (?$(JU;(B . "0x29B37") ; <CJK>
       (?$(JU<(B . "0x29C22") ; <CJK>
       (?$(JU=(B . "0x29C36") ; <CJK>
       (?$(JU>(B . "0x29C32") ; <CJK>
       (?$(JU?(B . "0x4C22") ; <CJK>
       (?$(JU@(B . "0x29CC0") ; <CJK>
       (?$(JUA(B . "0x4C45") ; <CJK>
       (?$(JUB(B . "0x4C41") ; <CJK>
       (?$(JUC(B . "0x9B81") ; <CJK>
       (?$(JUD(B . "0x4C40") ; <CJK>
       (?$(JUE(B . "0x9B8A") ; <CJK>
       (?$(JUF(B . "0x29D85") ; <CJK>
       (?$(JUG(B . "0x9B7F") ; <CJK>
       (?$(JUH(B . "0x4C42") ; <CJK>
       (?$(JUI(B . "0x29D89") ; <CJK>
       (?$(JUJ(B . "0x4CC1") ; <CJK>
       (?$(JUK(B . "0x4CC5") ; <CJK>
       (?$(JUL(B . "0x29FE1") ; <CJK>
       (?$(JUM(B . "0x4CBB") ; <CJK>
       (?$(JUN(B . "0x4CB9") ; <CJK>
       (?$(JUO(B . "0x4CBD") ; <CJK>
       (?$(JUP(B . "0x4CC9") ; <CJK>
       (?$(JUQ(B . "0x2A00A") ; <CJK>
       (?$(JUR(B . "0x9D11") ; <CJK>
       (?$(JUS(B . "0x2A009") ; <CJK>
       (?$(JUT(B . "0x4CBF") ; <CJK>
       (?$(JUU(B . "0x4CC7") ; <CJK>
       (?$(JUV(B . "0x29FE8") ; <CJK>
       (?$(JUW(B . "0x4CC3") ; <CJK>
       (?$(JUX(B . "0x4D24") ; <CJK>
       (?$(JUY(B . "0x4D31") ; <CJK>
       (?$(JUZ(B . "0x4D33") ; <CJK>
       (?$(JU[(B . "0x2A318") ; <CJK>
       (?$(JU\(B . "0x4D32") ; <CJK>
       (?$(JU](B . "0x4D34") ; <CJK>
       (?$(JU^(B . "0x4D52") ; <CJK>
       (?$(JU_(B . "0x4D61") ; <CJK>
       (?$(JU`(B . "0x9ED9") ; <CJK>
       (?$(JUa(B . "0x4D7A") ; <CJK>
       (?$(JUb(B . "0x4D82") ; <CJK>
       (?$(JUc(B . "0x9F3C") ; <CJK>
       (?$(JUd(B . "0x2A5C5") ; <CJK>
       (?$(JUe(B . "0x5123") ; <CJK>
       (?$(JUf(B . "0x2040D") ; <CJK>
       (?$(JUg(B . "0x2040C") ; <CJK>
       (?$(JUh(B . "0x20421") ; <CJK>
       (?$(JUi(B . "0x512C") ; <CJK>
       (?$(JUj(B . "0x20616") ; <CJK>
       (?$(JUk(B . "0x2080E") ; <CJK>
       (?$(JUl(B . "0x350F") ; <CJK>
       (?$(JUm(B . "0x5295") ; <CJK>
       (?$(JUn(B . "0x20817") ; <CJK>
       (?$(JUo(B . "0x3523") ; <CJK>
       (?$(JUp(B . "0x3525") ; <CJK>
       (?$(JUq(B . "0x21048") ; <CJK>
       (?$(JUr(B . "0x3606") ; <CJK>
       (?$(JUs(B . "0x3608") ; <CJK>
       (?$(JUt(B . "0x5688") ; <CJK>
       (?$(JUu(B . "0x21055") ; <CJK>
       (?$(JUv(B . "0x21049") ; <CJK>
       (?$(JUw(B . "0x2104C") ; <CJK>
       (?$(JUx(B . "0x568B") ; <CJK>
       (?$(JUy(B . "0x2104F") ; <CJK>
       (?$(JUz(B . "0x2103D") ; <CJK>
       (?$(JU{(B . "0x367A") ; <CJK>
       (?$(JU|(B . "0x3677") ; <CJK>
       (?$(JU}(B . "0x2148A") ; <CJK>
       (?$(JU~(B . "0x214A8") ; <CJK>
       (?$(JV!(B . "0x2168A") ; <CJK>
       (?$(JV"(B . "0x372E") ; <CJK>
       (?$(JV#(B . "0x218CB") ; <CJK>
       (?$(JV$(B . "0x372F") ; <CJK>
       (?$(JV%(B . "0x218D5") ; <CJK>
       (?$(JV&(B . "0x221D4") ; <CJK>
       (?$(JV'(B . "0x381B") ; <CJK>
       (?$(JV((B . "0x3813") ; <CJK>
       (?$(JV)(B . "0x21F5C") ; <CJK>
       (?$(JV*(B . "0x21F75") ; <CJK>
       (?$(JV+(B . "0x3866") ; <CJK>
       (?$(JV,(B . "0x22161") ; <CJK>
       (?$(JV-(B . "0x3865") ; <CJK>
       (?$(JV.(B . "0x21696") ; <CJK>
       (?$(JV/(B . "0x38F7") ; <CJK>
       (?$(JV0(B . "0x2258A") ; <CJK>
       (?$(JV1(B . "0x228D0") ; <CJK>
       (?$(JV2(B . "0x61E1") ; <CJK>
       (?$(JV3(B . "0x61D7") ; <CJK>
       (?$(JV4(B . "0x22849") ; <CJK>
       (?$(JV5(B . "0x228CF") ; <CJK>
       (?$(JV6(B . "0x399C") ; <CJK>
       (?$(JV7(B . "0x22DD6") ; <CJK>
       (?$(JV8(B . "0x22D7F") ; <CJK>
       (?$(JV9(B . "0x3A53") ; <CJK>
       (?$(JV:(B . "0x22DD2") ; <CJK>
       (?$(JV;(B . "0x22DCF") ; <CJK>
       (?$(JV<(B . "0x23006") ; <CJK>
       (?$(JV=(B . "0x23009") ; <CJK>
       (?$(JV>(B . "0x3ABA") ; <CJK>
       (?$(JV?(B . "0x65A3") ; <CJK>
       (?$(JV@(B . "0x3B22") ; <CJK>
       (?$(JVA(B . "0x66D3") ; <CJK>
       (?$(JVB(B . "0x23706") ; <CJK>
       (?$(JVC(B . "0x236F1") ; <CJK>
       (?$(JVD(B . "0x23704") ; <CJK>
       (?$(JVE(B . "0x6A8B") ; <CJK>
       (?$(JVF(B . "0x236FA") ; <CJK>
       (?$(JVG(B . "0x236F4") ; <CJK>
       (?$(JVH(B . "0x3BEB") ; <CJK>
       (?$(JVI(B . "0x3BDD") ; <CJK>
       (?$(JVJ(B . "0x236F9") ; <CJK>
       (?$(JVK(B . "0x3BEF") ; <CJK>
       (?$(JVL(B . "0x2368B") ; <CJK>
       (?$(JVM(B . "0x23703") ; <CJK>
       (?$(JVN(B . "0x3C47") ; <CJK>
       (?$(JVO(B . "0x3C46") ; <CJK>
       (?$(JVP(B . "0x239A2") ; <CJK>
       (?$(JVQ(B . "0x3C78") ; <CJK>
       (?$(JVR(B . "0x6BAC") ; <CJK>
       (?$(JVS(B . "0x3C89") ; <CJK>
       (?$(JVT(B . "0x23C0C") ; <CJK>
       (?$(JVU(B . "0x23C0B") ; <CJK>
       (?$(JVV(B . "0x3D68") ; <CJK>
       (?$(JVW(B . "0x3D76") ; <CJK>
       (?$(JVX(B . "0x3D74") ; <CJK>
       (?$(JVY(B . "0x3D79") ; <CJK>
       (?$(JVZ(B . "0x24024") ; <CJK>
       (?$(JV[(B . "0x3D7A") ; <CJK>
       (?$(JV\(B . "0x3D77") ; <CJK>
       (?$(JV](B . "0x2F914") ; <CJK>
       (?$(JV^(B . "0x3D71") ; <CJK>
       (?$(JV_(B . "0x24025") ; <CJK>
       (?$(JV`(B . "0x3D72") ; <CJK>
       (?$(JVa(B . "0x243F6") ; <CJK>
       (?$(JVb(B . "0x3DFF") ; <CJK>
       (?$(JVc(B . "0x243FB") ; <CJK>
       (?$(JVd(B . "0x3E05") ; <CJK>
       (?$(JVe(B . "0x24532") ; <CJK>
       (?$(JVf(B . "0x245FB") ; <CJK>
       (?$(JVg(B . "0x3E54") ; <CJK>
       (?$(JVh(B . "0x246F2") ; <CJK>
       (?$(JVi(B . "0x246F3") ; <CJK>
       (?$(JVj(B . "0x3E9E") ; <CJK>
       (?$(JVk(B . "0x3E9F") ; <CJK>
       (?$(JVl(B . "0x7374") ; <CJK>
       (?$(JVm(B . "0x2489C") ; <CJK>
       (?$(JVn(B . "0x24A72") ; <CJK>
       (?$(JVo(B . "0x3EFA") ; <CJK>
       (?$(JVp(B . "0x24A74") ; <CJK>
       (?$(JVq(B . "0x3F44") ; <CJK>
       (?$(JVr(B . "0x3F3F") ; <CJK>
       (?$(JVs(B . "0x3F40") ; <CJK>
       (?$(JVt(B . "0x24B86") ; <CJK>
       (?$(JVu(B . "0x3F42") ; <CJK>
       (?$(JVv(B . "0x24B8E") ; <CJK>
       (?$(JVw(B . "0x24B90") ; <CJK>
       (?$(JVx(B . "0x3F51") ; <CJK>
       (?$(JVy(B . "0x24BCD") ; <CJK>
       (?$(JVz(B . "0x24BF7") ; <CJK>
       (?$(JV{(B . "0x24CD6") ; <CJK>
       (?$(JV|(B . "0x24E84") ; <CJK>
       (?$(JV}(B . "0x24E95") ; <CJK>
       (?$(JV~(B . "0x24E8A") ; <CJK>
       (?$(JW!(B . "0x7640") ; <CJK>
       (?$(JW"(B . "0x3FCA") ; <CJK>
       (?$(JW#(B . "0x24E97") ; <CJK>
       (?$(JW$(B . "0x7641") ; <CJK>
       (?$(JW%(B . "0x3FCE") ; <CJK>
       (?$(JW&(B . "0x3FC9") ; <CJK>
       (?$(JW'(B . "0x24FA0") ; <CJK>
       (?$(JW((B . "0x24FA1") ; <CJK>
       (?$(JW)(B . "0x25022") ; <CJK>
       (?$(JW*(B . "0x250A6") ; <CJK>
       (?$(JW+(B . "0x250A4") ; <CJK>
       (?$(JW,(B . "0x4009") ; <CJK>
       (?$(JW-(B . "0x76E8") ; <CJK>
       (?$(JW.(B . "0x406C") ; <CJK>
       (?$(JW/(B . "0x406E") ; <CJK>
       (?$(JW0(B . "0x4070") ; <CJK>
       (?$(JW1(B . "0x406D") ; <CJK>
       (?$(JW2(B . "0x406B") ; <CJK>
       (?$(JW3(B . "0x4071") ; <CJK>
       (?$(JW4(B . "0x4072") ; <CJK>
       (?$(JW5(B . "0x252AF") ; <CJK>
       (?$(JW6(B . "0x252B0") ; <CJK>
       (?$(JW7(B . "0x252BD") ; <CJK>
       (?$(JW8(B . "0x408C") ; <CJK>
       (?$(JW9(B . "0x40E4") ; <CJK>
       (?$(JW:(B . "0x25576") ; <CJK>
       (?$(JW;(B . "0x40E1") ; <CJK>
       (?$(JW<(B . "0x2557B") ; <CJK>
       (?$(JW=(B . "0x25579") ; <CJK>
       (?$(JW>(B . "0x78F6") ; <CJK>
       (?$(JW?(B . "0x40E7") ; <CJK>
       (?$(JW@(B . "0x7900") ; <CJK>
       (?$(JWA(B . "0x40E2") ; <CJK>
       (?$(JWB(B . "0x411F") ; <CJK>
       (?$(JWC(B . "0x256EE") ; <CJK>
       (?$(JWD(B . "0x256F1") ; <CJK>
       (?$(JWE(B . "0x417E") ; <CJK>
       (?$(JWF(B . "0x25894") ; <CJK>
       (?$(JWG(B . "0x4180") ; <CJK>
       (?$(JWH(B . "0x7A59") ; <CJK>
       (?$(JWI(B . "0x7A55") ; <CJK>
       (?$(JWJ(B . "0x25891") ; <CJK>
       (?$(JWK(B . "0x41B9") ; <CJK>
       (?$(JWL(B . "0x41B7") ; <CJK>
       (?$(JWM(B . "0x41B8") ; <CJK>
       (?$(JWN(B . "0x25A10") ; <CJK>
       (?$(JWO(B . "0x41BA") ; <CJK>
       (?$(JWP(B . "0x7AF4") ; <CJK>
       (?$(JWQ(B . "0x25AAF") ; <CJK>
       (?$(JWR(B . "0x41D3") ; <CJK>
       (?$(JWS(B . "0x423F") ; <CJK>
       (?$(JWT(B . "0x7C04") ; <CJK>
       (?$(JWU(B . "0x4245") ; <CJK>
       (?$(JWV(B . "0x4241") ; <CJK>
       (?$(JWW(B . "0x7C15") ; <CJK>
       (?$(JWX(B . "0x4242") ; <CJK>
       (?$(JWY(B . "0x4243") ; <CJK>
       (?$(JWZ(B . "0x423B") ; <CJK>
       (?$(JW[(B . "0x4238") ; <CJK>
       (?$(JW\(B . "0x25C7B") ; <CJK>
       (?$(JW](B . "0x25C77") ; <CJK>
       (?$(JW^(B . "0x423A") ; <CJK>
       (?$(JW_(B . "0x7BF5") ; <CJK>
       (?$(JW`(B . "0x25C80") ; <CJK>
       (?$(JWa(B . "0x25CC6") ; <CJK>
       (?$(JWb(B . "0x423C") ; <CJK>
       (?$(JWc(B . "0x25C7C") ; <CJK>
       (?$(JWd(B . "0x25C90") ; <CJK>
       (?$(JWe(B . "0x423E") ; <CJK>
       (?$(JWf(B . "0x25CA3") ; <CJK>
       (?$(JWg(B . "0x25C7D") ; <CJK>
       (?$(JWh(B . "0x25CBD") ; <CJK>
       (?$(JWi(B . "0x429E") ; <CJK>
       (?$(JWj(B . "0x429F") ; <CJK>
       (?$(JWk(B . "0x42A1") ; <CJK>
       (?$(JWl(B . "0x25F13") ; <CJK>
       (?$(JWm(B . "0x429B") ; <CJK>
       (?$(JWn(B . "0x4312") ; <CJK>
       (?$(JWo(B . "0x26111") ; <CJK>
       (?$(JWp(B . "0x26144") ; <CJK>
       (?$(JWq(B . "0x2610D") ; <CJK>
       (?$(JWr(B . "0x4318") ; <CJK>
       (?$(JWs(B . "0x430C") ; <CJK>
       (?$(JWt(B . "0x26314") ; <CJK>
       (?$(JWu(B . "0x4362") ; <CJK>
       (?$(JWv(B . "0x263B8") ; <CJK>
       (?$(JWw(B . "0x437A") ; <CJK>
       (?$(JWx(B . "0x263B7") ; <CJK>
       (?$(JWy(B . "0x26483") ; <CJK>
       (?$(JWz(B . "0x43AE") ; <CJK>
       (?$(JW{(B . "0x43AF") ; <CJK>
       (?$(JW|(B . "0x26514") ; <CJK>
       (?$(JW}(B . "0x43AD") ; <CJK>
       (?$(JW~(B . "0x2651C") ; <CJK>
       (?$(JX!(B . "0x43C4") ; <CJK>
       (?$(JX"(B . "0x43C7") ; <CJK>
       (?$(JX#(B . "0x43C6") ; <CJK>
       (?$(JX$(B . "0x43C5") ; <CJK>
       (?$(JX%(B . "0x265D4") ; <CJK>
       (?$(JX&(B . "0x265D5") ; <CJK>
       (?$(JX'(B . "0x81C1") ; <CJK>
       (?$(JX((B . "0x4440") ; <CJK>
       (?$(JX)(B . "0x26843") ; <CJK>
       (?$(JX*(B . "0x26842") ; <CJK>
       (?$(JX+(B . "0x443F") ; <CJK>
       (?$(JX,(B . "0x4441") ; <CJK>
       (?$(JX-(B . "0x2F98A") ; <CJK>
       (?$(JX.(B . "0x26841") ; <CJK>
       (?$(JX/(B . "0x2694E") ; <CJK>
       (?$(JX0(B . "0x447F") ; <CJK>
       (?$(JX1(B . "0x26A87") ; <CJK>
       (?$(JX2(B . "0x4486") ; <CJK>
       (?$(JX3(B . "0x4481") ; <CJK>
       (?$(JX4(B . "0x4480") ; <CJK>
       (?$(JX5(B . "0x448E") ; <CJK>
       (?$(JX6(B . "0x454A") ; <CJK>
       (?$(JX7(B . "0x26F39") ; <CJK>
       (?$(JX8(B . "0x4547") ; <CJK>
       (?$(JX9(B . "0x26F8F") ; <CJK>
       (?$(JX:(B . "0x26F2A") ; <CJK>
       (?$(JX;(B . "0x454B") ; <CJK>
       (?$(JX<(B . "0x4546") ; <CJK>
       (?$(JX=(B . "0x454E") ; <CJK>
       (?$(JX>(B . "0x857D") ; <CJK>
       (?$(JX?(B . "0x26F2B") ; <CJK>
       (?$(JX@(B . "0x85A5") ; <CJK>
       (?$(JXA(B . "0x26F50") ; <CJK>
       (?$(JXB(B . "0x4548") ; <CJK>
       (?$(JXC(B . "0x26F6E") ; <CJK>
       (?$(JXD(B . "0x4545") ; <CJK>
       (?$(JXE(B . "0x26F3B") ; <CJK>
       (?$(JXF(B . "0x26F53") ; <CJK>
       (?$(JXG(B . "0x26F5F") ; <CJK>
       (?$(JXH(B . "0x26F2F") ; <CJK>
       (?$(JXI(B . "0x26F30") ; <CJK>
       (?$(JXJ(B . "0x26F38") ; <CJK>
       (?$(JXK(B . "0x26F4C") ; <CJK>
       (?$(JXL(B . "0x271F1") ; <CJK>
       (?$(JXM(B . "0x45DB") ; <CJK>
       (?$(JXN(B . "0x45E7") ; <CJK>
       (?$(JXO(B . "0x45E4") ; <CJK>
       (?$(JXP(B . "0x27407") ; <CJK>
       (?$(JXQ(B . "0x27416") ; <CJK>
       (?$(JXR(B . "0x45E1") ; <CJK>
       (?$(JXS(B . "0x27414") ; <CJK>
       (?$(JXT(B . "0x45E9") ; <CJK>
       (?$(JXU(B . "0x273FB") ; <CJK>
       (?$(JXV(B . "0x45E5") ; <CJK>
       (?$(JXW(B . "0x45E0") ; <CJK>
       (?$(JXX(B . "0x45E3") ; <CJK>
       (?$(JXY(B . "0x273F8") ; <CJK>
       (?$(JXZ(B . "0x27410") ; <CJK>
       (?$(JX[(B . "0x2741D") ; <CJK>
       (?$(JX\(B . "0x273FF") ; <CJK>
       (?$(JX](B . "0x2740B") ; <CJK>
       (?$(JX^(B . "0x27404") ; <CJK>
       (?$(JX_(B . "0x45EA") ; <CJK>
       (?$(JX`(B . "0x273FE") ; <CJK>
       (?$(JXa(B . "0x275FF") ; <CJK>
       (?$(JXb(B . "0x893A") ; <CJK>
       (?$(JXc(B . "0x4654") ; <CJK>
       (?$(JXd(B . "0x4658") ; <CJK>
       (?$(JXe(B . "0x465C") ; <CJK>
       (?$(JXf(B . "0x27723") ; <CJK>
       (?$(JXg(B . "0x4655") ; <CJK>
       (?$(JXh(B . "0x468B") ; <CJK>
       (?$(JXi(B . "0x468C") ; <CJK>
       (?$(JXj(B . "0x46A6") ; <CJK>
       (?$(JXk(B . "0x46A5") ; <CJK>
       (?$(JXl(B . "0x2792A") ; <CJK>
       (?$(JXm(B . "0x27AA0") ; <CJK>
       (?$(JXn(B . "0x27A98") ; <CJK>
       (?$(JXo(B . "0x27A9C") ; <CJK>
       (?$(JXp(B . "0x46FF") ; <CJK>
       (?$(JXq(B . "0x27A9E") ; <CJK>
       (?$(JXr(B . "0x27AA6") ; <CJK>
       (?$(JXs(B . "0x27AB5") ; <CJK>
       (?$(JXt(B . "0x27AB0") ; <CJK>
       (?$(JXu(B . "0x4730") ; <CJK>
       (?$(JXv(B . "0x4740") ; <CJK>
       (?$(JXw(B . "0x4741") ; <CJK>
       (?$(JXx(B . "0x27CF9") ; <CJK>
       (?$(JXy(B . "0x27CF5") ; <CJK>
       (?$(JXz(B . "0x4786") ; <CJK>
       (?$(JX{(B . "0x27DD2") ; <CJK>
       (?$(JX|(B . "0x47BF") ; <CJK>
       (?$(JX}(B . "0x47BD") ; <CJK>
       (?$(JX~(B . "0x27F50") ; <CJK>
       (?$(JY!(B . "0x27F4E") ; <CJK>
       (?$(JY"(B . "0x27F4B") ; <CJK>
       (?$(JY#(B . "0x27F52") ; <CJK>
       (?$(JY$(B . "0x27F4D") ; <CJK>
       (?$(JY%(B . "0x47BE") ; <CJK>
       (?$(JY&(B . "0x4819") ; <CJK>
       (?$(JY'(B . "0x280E4") ; <CJK>
       (?$(JY((B . "0x481C") ; <CJK>
       (?$(JY)(B . "0x280DA") ; <CJK>
       (?$(JY*(B . "0x481B") ; <CJK>
       (?$(JY+(B . "0x4817") ; <CJK>
       (?$(JY,(B . "0x4818") ; <CJK>
       (?$(JY-(B . "0x8E51") ; <CJK>
       (?$(JY.(B . "0x280DF") ; <CJK>
       (?$(JY/(B . "0x280E8") ; <CJK>
       (?$(JY0(B . "0x483D") ; <CJK>
       (?$(JY1(B . "0x486A") ; <CJK>
       (?$(JY2(B . "0x4866") ; <CJK>
       (?$(JY3(B . "0x28370") ; <CJK>
       (?$(JY4(B . "0x28372") ; <CJK>
       (?$(JY5(B . "0x4867") ; <CJK>
       (?$(JY6(B . "0x28377") ; <CJK>
       (?$(JY7(B . "0x4868") ; <CJK>
       (?$(JY8(B . "0x48AD") ; <CJK>
       (?$(JY9(B . "0x48AE") ; <CJK>
       (?$(JY:(B . "0x285E6") ; <CJK>
       (?$(JY;(B . "0x287AA") ; <CJK>
       (?$(JY<(B . "0x48D6") ; <CJK>
       (?$(JY=(B . "0x4909") ; <CJK>
       (?$(JY>(B . "0x2888C") ; <CJK>
       (?$(JY?(B . "0x9198") ; <CJK>
       (?$(JY@(B . "0x28889") ; <CJK>
       (?$(JYA(B . "0x490C") ; <CJK>
       (?$(JYB(B . "0x490A") ; <CJK>
       (?$(JYC(B . "0x28A32") ; <CJK>
       (?$(JYD(B . "0x493B") ; <CJK>
       (?$(JYE(B . "0x493A") ; <CJK>
       (?$(JYF(B . "0x9384") ; <CJK>
       (?$(JYG(B . "0x9381") ; <CJK>
       (?$(JYH(B . "0x28A7A") ; <CJK>
       (?$(JYI(B . "0x936F") ; <CJK>
       (?$(JYJ(B . "0x28C9E") ; <CJK>
       (?$(JYK(B . "0x28CA0") ; <CJK>
       (?$(JYL(B . "0x28D70") ; <CJK>
       (?$(JYM(B . "0x49AF") ; <CJK>
       (?$(JYN(B . "0x49AA") ; <CJK>
       (?$(JYO(B . "0x49AB") ; <CJK>
       (?$(JYP(B . "0x28D6E") ; <CJK>
       (?$(JYQ(B . "0x28D66") ; <CJK>
       (?$(JYR(B . "0x49B1") ; <CJK>
       (?$(JYS(B . "0x28D65") ; <CJK>
       (?$(JYT(B . "0x49AC") ; <CJK>
       (?$(JYU(B . "0x49EC") ; <CJK>
       (?$(JYV(B . "0x28F7F") ; <CJK>
       (?$(JYW(B . "0x28FE0") ; <CJK>
       (?$(JYX(B . "0x4A01") ; <CJK>
       (?$(JYY(B . "0x28FFF") ; <CJK>
       (?$(JYZ(B . "0x290F6") ; <CJK>
       (?$(JY[(B . "0x290F7") ; <CJK>
       (?$(JY\(B . "0x290F5") ; <CJK>
       (?$(JY](B . "0x4A23") ; <CJK>
       (?$(JY^(B . "0x290FC") ; <CJK>
       (?$(JY_(B . "0x4A24") ; <CJK>
       (?$(JY`(B . "0x4A1E") ; <CJK>
       (?$(JYa(B . "0x290F9") ; <CJK>
       (?$(JYb(B . "0x4A4A") ; <CJK>
       (?$(JYc(B . "0x4A65") ; <CJK>
       (?$(JYd(B . "0x4A6A") ; <CJK>
       (?$(JYe(B . "0x292CA") ; <CJK>
       (?$(JYf(B . "0x292C3") ; <CJK>
       (?$(JYg(B . "0x292C6") ; <CJK>
       (?$(JYh(B . "0x4A69") ; <CJK>
       (?$(JYi(B . "0x293B8") ; <CJK>
       (?$(JYj(B . "0x293BD") ; <CJK>
       (?$(JYk(B . "0x4A95") ; <CJK>
       (?$(JYl(B . "0x293BC") ; <CJK>
       (?$(JYm(B . "0x29405") ; <CJK>
       (?$(JYn(B . "0x294E0") ; <CJK>
       (?$(JYo(B . "0x294E9") ; <CJK>
       (?$(JYp(B . "0x9842") ; <CJK>
       (?$(JYq(B . "0x294DF") ; <CJK>
       (?$(JYr(B . "0x294EC") ; <CJK>
       (?$(JYs(B . "0x4ACC") ; <CJK>
       (?$(JYt(B . "0x294E5") ; <CJK>
       (?$(JYu(B . "0x294DE") ; <CJK>
       (?$(JYv(B . "0x2FA00") ; <CJK>
       (?$(JYw(B . "0x4ACF") ; <CJK>
       (?$(JYx(B . "0x294F0") ; <CJK>
       (?$(JYy(B . "0x294E3") ; <CJK>
       (?$(JYz(B . "0x4B0F") ; <CJK>
       (?$(JY{(B . "0x295EC") ; <CJK>
       (?$(JY|(B . "0x4B0E") ; <CJK>
       (?$(JY}(B . "0x4B0B") ; <CJK>
       (?$(JY~(B . "0x4B10") ; <CJK>
       (?$(JZ!(B . "0x4B0D") ; <CJK>
       (?$(JZ"(B . "0x4B0C") ; <CJK>
       (?$(JZ#(B . "0x295F2") ; <CJK>
       (?$(JZ$(B . "0x295EF") ; <CJK>
       (?$(JZ%(B . "0x295E9") ; <CJK>
       (?$(JZ&(B . "0x296FB") ; <CJK>
       (?$(JZ'(B . "0x4B46") ; <CJK>
       (?$(JZ((B . "0x4B48") ; <CJK>
       (?$(JZ)(B . "0x9937") ; <CJK>
       (?$(JZ*(B . "0x4B49") ; <CJK>
       (?$(JZ+(B . "0x29737") ; <CJK>
       (?$(JZ,(B . "0x298DE") ; <CJK>
       (?$(JZ-(B . "0x4B91") ; <CJK>
       (?$(JZ.(B . "0x4B8E") ; <CJK>
       (?$(JZ/(B . "0x298DA") ; <CJK>
       (?$(JZ0(B . "0x4BD8") ; <CJK>
       (?$(JZ1(B . "0x4BD6") ; <CJK>
       (?$(JZ2(B . "0x29A4B") ; <CJK>
       (?$(JZ3(B . "0x4BDA") ; <CJK>
       (?$(JZ4(B . "0x29A49") ; <CJK>
       (?$(JZ5(B . "0x4BD7") ; <CJK>
       (?$(JZ6(B . "0x29AD5") ; <CJK>
       (?$(JZ7(B . "0x9AFF") ; <CJK>
       (?$(JZ8(B . "0x4BF9") ; <CJK>
       (?$(JZ9(B . "0x29B52") ; <CJK>
       (?$(JZ:(B . "0x29B47") ; <CJK>
       (?$(JZ;(B . "0x4BFC") ; <CJK>
       (?$(JZ<(B . "0x29B48") ; <CJK>
       (?$(JZ=(B . "0x29CCC") ; <CJK>
       (?$(JZ>(B . "0x29CD0") ; <CJK>
       (?$(JZ?(B . "0x9BA9") ; <CJK>
       (?$(JZ@(B . "0x4C4A") ; <CJK>
       (?$(JZA(B . "0x9BA7") ; <CJK>
       (?$(JZB(B . "0x4C4E") ; <CJK>
       (?$(JZC(B . "0x9BB3") ; <CJK>
       (?$(JZD(B . "0x9BAC") ; <CJK>
       (?$(JZE(B . "0x9BB0") ; <CJK>
       (?$(JZF(B . "0x29D86") ; <CJK>
       (?$(JZG(B . "0x29DA7") ; <CJK>
       (?$(JZH(B . "0x29DA3") ; <CJK>
       (?$(JZI(B . "0x9B9C") ; <CJK>
       (?$(JZJ(B . "0x29DB6") ; <CJK>
       (?$(JZK(B . "0x29DAD") ; <CJK>
       (?$(JZL(B . "0x2A013") ; <CJK>
       (?$(JZM(B . "0x9D3C") ; <CJK>
       (?$(JZN(B . "0x9D1C") ; <CJK>
       (?$(JZO(B . "0x9D3A") ; <CJK>
       (?$(JZP(B . "0x4CD3") ; <CJK>
       (?$(JZQ(B . "0x4CCD") ; <CJK>
       (?$(JZR(B . "0x4CD1") ; <CJK>
       (?$(JZS(B . "0x2A017") ; <CJK>
       (?$(JZT(B . "0x2A022") ; <CJK>
       (?$(JZU(B . "0x9D32") ; <CJK>
       (?$(JZV(B . "0x9D34") ; <CJK>
       (?$(JZW(B . "0x2A049") ; <CJK>
       (?$(JZX(B . "0x2A026") ; <CJK>
       (?$(JZY(B . "0x2FA0C") ; <CJK>
       (?$(JZZ(B . "0x2A03C") ; <CJK>
       (?$(JZ[(B . "0x2A028") ; <CJK>
       (?$(JZ\(B . "0x2A2A8") ; <CJK>
       (?$(JZ](B . "0x9EC7") ; <CJK>
       (?$(JZ^(B . "0x2A3FB") ; <CJK>
       (?$(JZ_(B . "0x4D62") ; <CJK>
       (?$(JZ`(B . "0x2A432") ; <CJK>
       (?$(JZa(B . "0x2A4D6") ; <CJK>
       (?$(JZb(B . "0x2A548") ; <CJK>
       (?$(JZc(B . "0x4D83") ; <CJK>
       (?$(JZd(B . "0x9F3F") ; <CJK>
       (?$(JZe(B . "0x2A5C6") ; <CJK>
       (?$(JZf(B . "0x4D92") ; <CJK>
       (?$(JZg(B . "0x349F") ; <CJK>
       (?$(JZh(B . "0x34A0") ; <CJK>
       (?$(JZi(B . "0x20425") ; <CJK>
       (?$(JZj(B . "0x20426") ; <CJK>
       (?$(JZk(B . "0x20424") ; <CJK>
       (?$(JZl(B . "0x20433") ; <CJK>
       (?$(JZm(B . "0x20570") ; <CJK>
       (?$(JZn(B . "0x3527") ; <CJK>
       (?$(JZo(B . "0x20B90") ; <CJK>
       (?$(JZp(B . "0x360B") ; <CJK>
       (?$(JZq(B . "0x21095") ; <CJK>
       (?$(JZr(B . "0x210A1") ; <CJK>
       (?$(JZs(B . "0x21092") ; <CJK>
       (?$(JZt(B . "0x2108F") ; <CJK>
       (?$(JZu(B . "0x2109F") ; <CJK>
       (?$(JZv(B . "0x21096") ; <CJK>
       (?$(JZw(B . "0x21098") ; <CJK>
       (?$(JZx(B . "0x2109D") ; <CJK>
       (?$(JZy(B . "0x210A0") ; <CJK>
       (?$(JZz(B . "0x368D") ; <CJK>
       (?$(JZ{(B . "0x21697") ; <CJK>
       (?$(JZ|(B . "0x218EB") ; <CJK>
       (?$(JZ}(B . "0x3770") ; <CJK>
       (?$(JZ~(B . "0x21F87") ; <CJK>
       (?$(J[!(B . "0x5EEB") ; <CJK>
       (?$(J["(B . "0x22432") ; <CJK>
       (?$(J[#(B . "0x399A") ; <CJK>
       (?$(J[$(B . "0x399F") ; <CJK>
       (?$(J[%(B . "0x399D") ; <CJK>
       (?$(J[&(B . "0x228D8") ; <CJK>
       (?$(J['(B . "0x228FB") ; <CJK>
       (?$(J[((B . "0x22906") ; <CJK>
       (?$(J[)(B . "0x399B") ; <CJK>
       (?$(J[*(B . "0x228D1") ; <CJK>
       (?$(J[+(B . "0x61D5") ; <CJK>
       (?$(J[,(B . "0x2F8B0") ; <CJK>
       (?$(J[-(B . "0x3A60") ; <CJK>
       (?$(J[.(B . "0x3A64") ; <CJK>
       (?$(J[/(B . "0x3A69") ; <CJK>
       (?$(J[0(B . "0x3A63") ; <CJK>
       (?$(J[1(B . "0x3A67") ; <CJK>
       (?$(J[2(B . "0x3A62") ; <CJK>
       (?$(J[3(B . "0x22DF6") ; <CJK>
       (?$(J[4(B . "0x22E04") ; <CJK>
       (?$(J[5(B . "0x22DFE") ; <CJK>
       (?$(J[6(B . "0x6502") ; <CJK>
       (?$(J[7(B . "0x22DFF") ; <CJK>
       (?$(J[8(B . "0x22DF7") ; <CJK>
       (?$(J[9(B . "0x23018") ; <CJK>
       (?$(J[:(B . "0x3AAC") ; <CJK>
       (?$(J[;(B . "0x23014") ; <CJK>
       (?$(J[<(B . "0x230CD") ; <CJK>
       (?$(J[=(B . "0x23120") ; <CJK>
       (?$(J[>(B . "0x232DE") ; <CJK>
       (?$(J[?(B . "0x3B26") ; <CJK>
       (?$(J[@(B . "0x3B23") ; <CJK>
       (?$(J[A(B . "0x3B25") ; <CJK>
       (?$(J[B(B . "0x23745") ; <CJK>
       (?$(J[C(B . "0x23753") ; <CJK>
       (?$(J[D(B . "0x3BF8") ; <CJK>
       (?$(J[E(B . "0x2374B") ; <CJK>
       (?$(J[F(B . "0x23755") ; <CJK>
       (?$(J[G(B . "0x23741") ; <CJK>
       (?$(J[H(B . "0x3BF7") ; <CJK>
       (?$(J[I(B . "0x3BFB") ; <CJK>
       (?$(J[J(B . "0x3BFA") ; <CJK>
       (?$(J[K(B . "0x2375C") ; <CJK>
       (?$(J[L(B . "0x23754") ; <CJK>
       (?$(J[M(B . "0x23A71") ; <CJK>
       (?$(J[N(B . "0x23AD0") ; <CJK>
       (?$(J[O(B . "0x3CB0") ; <CJK>
       (?$(J[P(B . "0x3CAF") ; <CJK>
       (?$(J[Q(B . "0x23C53") ; <CJK>
       (?$(J[R(B . "0x24029") ; <CJK>
       (?$(J[S(B . "0x2407E") ; <CJK>
       (?$(J[T(B . "0x3D7E") ; <CJK>
       (?$(J[U(B . "0x24079") ; <CJK>
       (?$(J[V(B . "0x3D7D") ; <CJK>
       (?$(J[W(B . "0x3D80") ; <CJK>
       (?$(J[X(B . "0x24070") ; <CJK>
       (?$(J[Y(B . "0x2406A") ; <CJK>
       (?$(J[Z(B . "0x3D7F") ; <CJK>
       (?$(J[[(B . "0x3D86") ; <CJK>
       (?$(J[\(B . "0x24085") ; <CJK>
       (?$(J[](B . "0x24064") ; <CJK>
       (?$(J[^(B . "0x7012") ; <CJK>
       (?$(J[_(B . "0x24078") ; <CJK>
       (?$(J[`(B . "0x3D81") ; <CJK>
       (?$(J[a(B . "0x24432") ; <CJK>
       (?$(J[b(B . "0x24427") ; <CJK>
       (?$(J[c(B . "0x2442F") ; <CJK>
       (?$(J[d(B . "0x3E24") ; <CJK>
       (?$(J[e(B . "0x3E58") ; <CJK>
       (?$(J[f(B . "0x3E57") ; <CJK>
       (?$(J[g(B . "0x3EA0") ; <CJK>
       (?$(J[h(B . "0x248BA") ; <CJK>
       (?$(J[i(B . "0x3EFE") ; <CJK>
       (?$(J[j(B . "0x24A71") ; <CJK>
       (?$(J[k(B . "0x24A8C") ; <CJK>
       (?$(J[l(B . "0x3F15") ; <CJK>
       (?$(J[m(B . "0x24B1A") ; <CJK>
       (?$(J[n(B . "0x3F47") ; <CJK>
       (?$(J[o(B . "0x3F46") ; <CJK>
       (?$(J[p(B . "0x24B98") ; <CJK>
       (?$(J[q(B . "0x24CE4") ; <CJK>
       (?$(J[r(B . "0x3F6B") ; <CJK>
       (?$(J[s(B . "0x3F6C") ; <CJK>
       (?$(J[t(B . "0x7585") ; <CJK>
       (?$(J[u(B . "0x7654") ; <CJK>
       (?$(J[v(B . "0x24EC2") ; <CJK>
       (?$(J[w(B . "0x3FCC") ; <CJK>
       (?$(J[x(B . "0x24EBA") ; <CJK>
       (?$(J[y(B . "0x7655") ; <CJK>
       (?$(J[z(B . "0x24EC8") ; <CJK>
       (?$(J[{(B . "0x3FCB") ; <CJK>
       (?$(J[|(B . "0x76A7") ; <CJK>
       (?$(J[}(B . "0x76A8") ; <CJK>
       (?$(J[~(B . "0x3FF9") ; <CJK>
       (?$(J\!(B . "0x250B9") ; <CJK>
       (?$(J\"(B . "0x250B8") ; <CJK>
       (?$(J\#(B . "0x250A5") ; <CJK>
       (?$(J\$(B . "0x252E2") ; <CJK>
       (?$(J\%(B . "0x4078") ; <CJK>
       (?$(J\&(B . "0x407A") ; <CJK>
       (?$(J\'(B . "0x4075") ; <CJK>
       (?$(J\((B . "0x252D9") ; <CJK>
       (?$(J\)(B . "0x4076") ; <CJK>
       (?$(J\*(B . "0x4077") ; <CJK>
       (?$(J\+(B . "0x252AC") ; <CJK>
       (?$(J\,(B . "0x252DD") ; <CJK>
       (?$(J\-(B . "0x40EA") ; <CJK>
       (?$(J\.(B . "0x40EE") ; <CJK>
       (?$(J\/(B . "0x40ED") ; <CJK>
       (?$(J\0(B . "0x2559D") ; <CJK>
       (?$(J\1(B . "0x40EC") ; <CJK>
       (?$(J\2(B . "0x790F") ; <CJK>
       (?$(J\3(B . "0x25711") ; <CJK>
       (?$(J\4(B . "0x25703") ; <CJK>
       (?$(J\5(B . "0x4184") ; <CJK>
       (?$(J\6(B . "0x4185") ; <CJK>
       (?$(J\7(B . "0x4183") ; <CJK>
       (?$(J\8(B . "0x258EE") ; <CJK>
       (?$(J\9(B . "0x41BC") ; <CJK>
       (?$(J\:(B . "0x41BD") ; <CJK>
       (?$(J\;(B . "0x41D4") ; <CJK>
       (?$(J\<(B . "0x25CA4") ; <CJK>
       (?$(J\=(B . "0x25CD8") ; <CJK>
       (?$(J\>(B . "0x25CDD") ; <CJK>
       (?$(J\?(B . "0x25CDE") ; <CJK>
       (?$(J\@(B . "0x4255") ; <CJK>
       (?$(J\A(B . "0x25CE7") ; <CJK>
       (?$(J\B(B . "0x4250") ; <CJK>
       (?$(J\C(B . "0x424C") ; <CJK>
       (?$(J\D(B . "0x4248") ; <CJK>
       (?$(J\E(B . "0x25CD4") ; <CJK>
       (?$(J\F(B . "0x4253") ; <CJK>
       (?$(J\G(B . "0x25CCE") ; <CJK>
       (?$(J\H(B . "0x4257") ; <CJK>
       (?$(J\I(B . "0x4254") ; <CJK>
       (?$(J\J(B . "0x424E") ; <CJK>
       (?$(J\K(B . "0x424A") ; <CJK>
       (?$(J\L(B . "0x4251") ; <CJK>
       (?$(J\M(B . "0x25CF1") ; <CJK>
       (?$(J\N(B . "0x25CD3") ; <CJK>
       (?$(J\O(B . "0x4249") ; <CJK>
       (?$(J\P(B . "0x424B") ; <CJK>
       (?$(J\Q(B . "0x4263") ; <CJK>
       (?$(J\R(B . "0x25CCA") ; <CJK>
       (?$(J\S(B . "0x25CE9") ; <CJK>
       (?$(J\T(B . "0x42A7") ; <CJK>
       (?$(J\U(B . "0x42A6") ; <CJK>
       (?$(J\V(B . "0x42A4") ; <CJK>
       (?$(J\W(B . "0x25F1A") ; <CJK>
       (?$(J\X(B . "0x25F41") ; <CJK>
       (?$(J\Y(B . "0x2F968") ; <CJK>
       (?$(J\Z(B . "0x7CE4") ; <CJK>
       (?$(J\[(B . "0x7CE5") ; <CJK>
       (?$(J\\(B . "0x2613D") ; <CJK>
       (?$(J\](B . "0x26140") ; <CJK>
       (?$(J\^(B . "0x7E65") ; <CJK>
       (?$(J\_(B . "0x7E4E") ; <CJK>
       (?$(J\`(B . "0x4317") ; <CJK>
       (?$(J\a(B . "0x26143") ; <CJK>
       (?$(J\b(B . "0x4316") ; <CJK>
       (?$(J\c(B . "0x2613F") ; <CJK>
       (?$(J\d(B . "0x2613C") ; <CJK>
       (?$(J\e(B . "0x4363") ; <CJK>
       (?$(J\f(B . "0x26321") ; <CJK>
       (?$(J\g(B . "0x26320") ; <CJK>
       (?$(J\h(B . "0x7F82") ; <CJK>
       (?$(J\i(B . "0x263C6") ; <CJK>
       (?$(J\j(B . "0x437B") ; <CJK>
       (?$(J\k(B . "0x437C") ; <CJK>
       (?$(J\l(B . "0x263D1") ; <CJK>
       (?$(J\m(B . "0x263CA") ; <CJK>
       (?$(J\n(B . "0x2648E") ; <CJK>
       (?$(J\o(B . "0x26491") ; <CJK>
       (?$(J\p(B . "0x43B0") ; <CJK>
       (?$(J\q(B . "0x802D") ; <CJK>
       (?$(J\r(B . "0x265E3") ; <CJK>
       (?$(J\s(B . "0x26888") ; <CJK>
       (?$(J\t(B . "0x4442") ; <CJK>
       (?$(J\u(B . "0x26870") ; <CJK>
       (?$(J\v(B . "0x4444") ; <CJK>
       (?$(J\w(B . "0x2699D") ; <CJK>
       (?$(J\x(B . "0x26A9D") ; <CJK>
       (?$(J\y(B . "0x26A91") ; <CJK>
       (?$(J\z(B . "0x26A98") ; <CJK>
       (?$(J\{(B . "0x26A99") ; <CJK>
       (?$(J\|(B . "0x4488") ; <CJK>
       (?$(J\}(B . "0x448F") ; <CJK>
       (?$(J\~(B . "0x4553") ; <CJK>
       (?$(J]!(B . "0x455B") ; <CJK>
       (?$(J]"(B . "0x26FBF") ; <CJK>
       (?$(J]#(B . "0x4559") ; <CJK>
       (?$(J]$(B . "0x26FAE") ; <CJK>
       (?$(J]%(B . "0x26FB1") ; <CJK>
       (?$(J]&(B . "0x26FCC") ; <CJK>
       (?$(J]'(B . "0x27004") ; <CJK>
       (?$(J]((B . "0x85CA") ; <CJK>
       (?$(J])(B . "0x27016") ; <CJK>
       (?$(J]*(B . "0x26FCD") ; <CJK>
       (?$(J]+(B . "0x4554") ; <CJK>
       (?$(J],(B . "0x85BC") ; <CJK>
       (?$(J]-(B . "0x26FE0") ; <CJK>
       (?$(J].(B . "0x26FCB") ; <CJK>
       (?$(J]/(B . "0x26FD4") ; <CJK>
       (?$(J]0(B . "0x26FC9") ; <CJK>
       (?$(J]1(B . "0x271FF") ; <CJK>
       (?$(J]2(B . "0x4599") ; <CJK>
       (?$(J]3(B . "0x271FD") ; <CJK>
       (?$(J]4(B . "0x27457") ; <CJK>
       (?$(J]5(B . "0x27452") ; <CJK>
       (?$(J]6(B . "0x27450") ; <CJK>
       (?$(J]7(B . "0x27445") ; <CJK>
       (?$(J]8(B . "0x2744D") ; <CJK>
       (?$(J]9(B . "0x45F1") ; <CJK>
       (?$(J]:(B . "0x27453") ; <CJK>
       (?$(J];(B . "0x45EF") ; <CJK>
       (?$(J]<(B . "0x27482") ; <CJK>
       (?$(J]=(B . "0x27444") ; <CJK>
       (?$(J]>(B . "0x275CE") ; <CJK>
       (?$(J]?(B . "0x275CF") ; <CJK>
       (?$(J]@(B . "0x275D2") ; <CJK>
       (?$(J]A(B . "0x27602") ; <CJK>
       (?$(J]B(B . "0x2774F") ; <CJK>
       (?$(J]C(B . "0x27758") ; <CJK>
       (?$(J]D(B . "0x4662") ; <CJK>
       (?$(J]E(B . "0x27743") ; <CJK>
       (?$(J]F(B . "0x4663") ; <CJK>
       (?$(J]G(B . "0x27752") ; <CJK>
       (?$(J]H(B . "0x4660") ; <CJK>
       (?$(J]I(B . "0x4661") ; <CJK>
       (?$(J]J(B . "0x465F") ; <CJK>
       (?$(J]K(B . "0x27749") ; <CJK>
       (?$(J]L(B . "0x27753") ; <CJK>
       (?$(J]M(B . "0x2774D") ; <CJK>
       (?$(J]N(B . "0x468D") ; <CJK>
       (?$(J]O(B . "0x27884") ; <CJK>
       (?$(J]P(B . "0x468E") ; <CJK>
       (?$(J]Q(B . "0x27883") ; <CJK>
       (?$(J]R(B . "0x27932") ; <CJK>
       (?$(J]S(B . "0x27AE2") ; <CJK>
       (?$(J]T(B . "0x4709") ; <CJK>
       (?$(J]U(B . "0x27AE4") ; <CJK>
       (?$(J]V(B . "0x27AD3") ; <CJK>
       (?$(J]W(B . "0x4705") ; <CJK>
       (?$(J]X(B . "0x27AD5") ; <CJK>
       (?$(J]Y(B . "0x27ADD") ; <CJK>
       (?$(J]Z(B . "0x4703") ; <CJK>
       (?$(J][(B . "0x4706") ; <CJK>
       (?$(J]\(B . "0x27AEC") ; <CJK>
       (?$(J]](B . "0x27AE6") ; <CJK>
       (?$(J]^(B . "0x27AD2") ; <CJK>
       (?$(J]_(B . "0x27AFA") ; <CJK>
       (?$(J]`(B . "0x27ADA") ; <CJK>
       (?$(J]a(B . "0x4731") ; <CJK>
       (?$(J]b(B . "0x27C06") ; <CJK>
       (?$(J]c(B . "0x27C04") ; <CJK>
       (?$(J]d(B . "0x474F") ; <CJK>
       (?$(J]e(B . "0x27C7B") ; <CJK>
       (?$(J]f(B . "0x27D04") ; <CJK>
       (?$(J]g(B . "0x27D02") ; <CJK>
       (?$(J]h(B . "0x4766") ; <CJK>
       (?$(J]i(B . "0x8CFF") ; <CJK>
       (?$(J]j(B . "0x47C4") ; <CJK>
       (?$(J]k(B . "0x27F60") ; <CJK>
       (?$(J]l(B . "0x47C3") ; <CJK>
       (?$(J]m(B . "0x47C1") ; <CJK>
       (?$(J]n(B . "0x47C5") ; <CJK>
       (?$(J]o(B . "0x28107") ; <CJK>
       (?$(J]p(B . "0x28105") ; <CJK>
       (?$(J]q(B . "0x2810C") ; <CJK>
       (?$(J]r(B . "0x4821") ; <CJK>
       (?$(J]s(B . "0x2815A") ; <CJK>
       (?$(J]t(B . "0x481F") ; <CJK>
       (?$(J]u(B . "0x4822") ; <CJK>
       (?$(J]v(B . "0x2811A") ; <CJK>
       (?$(J]w(B . "0x4827") ; <CJK>
       (?$(J]x(B . "0x4820") ; <CJK>
       (?$(J]y(B . "0x2838A") ; <CJK>
       (?$(J]z(B . "0x486D") ; <CJK>
       (?$(J]{(B . "0x486C") ; <CJK>
       (?$(J]|(B . "0x486B") ; <CJK>
       (?$(J]}(B . "0x486F") ; <CJK>
       (?$(J]~(B . "0x4870") ; <CJK>
       (?$(J^!(B . "0x2838C") ; <CJK>
       (?$(J^"(B . "0x28609") ; <CJK>
       (?$(J^#(B . "0x288A6") ; <CJK>
       (?$(J^$(B . "0x91A6") ; <CJK>
       (?$(J^%(B . "0x288AC") ; <CJK>
       (?$(J^&(B . "0x288A9") ; <CJK>
       (?$(J^'(B . "0x4942") ; <CJK>
       (?$(J^((B . "0x28A8B") ; <CJK>
       (?$(J^)(B . "0x93B6") ; <CJK>
       (?$(J^*(B . "0x28A8C") ; <CJK>
       (?$(J^+(B . "0x4944") ; <CJK>
       (?$(J^,(B . "0x4940") ; <CJK>
       (?$(J^-(B . "0x28A88") ; <CJK>
       (?$(J^.(B . "0x28A89") ; <CJK>
       (?$(J^/(B . "0x493F") ; <CJK>
       (?$(J^0(B . "0x28A93") ; <CJK>
       (?$(J^1(B . "0x93AB") ; <CJK>
       (?$(J^2(B . "0x498B") ; <CJK>
       (?$(J^3(B . "0x28D83") ; <CJK>
       (?$(J^4(B . "0x28F4F") ; <CJK>
       (?$(J^5(B . "0x4A25") ; <CJK>
       (?$(J^6(B . "0x4A28") ; <CJK>
       (?$(J^7(B . "0x29120") ; <CJK>
       (?$(J^8(B . "0x9721") ; <CJK>
       (?$(J^9(B . "0x29236") ; <CJK>
       (?$(J^:(B . "0x292E2") ; <CJK>
       (?$(J^;(B . "0x4A75") ; <CJK>
       (?$(J^<(B . "0x4A72") ; <CJK>
       (?$(J^=(B . "0x292EE") ; <CJK>
       (?$(J^>(B . "0x4A6F") ; <CJK>
       (?$(J^?(B . "0x292E7") ; <CJK>
       (?$(J^@(B . "0x292E9") ; <CJK>
       (?$(J^A(B . "0x4A76") ; <CJK>
       (?$(J^B(B . "0x4A71") ; <CJK>
       (?$(J^C(B . "0x97A7") ; <CJK>
       (?$(J^D(B . "0x292DF") ; <CJK>
       (?$(J^E(B . "0x4A97") ; <CJK>
       (?$(J^F(B . "0x293C7") ; <CJK>
       (?$(J^G(B . "0x4AD7") ; <CJK>
       (?$(J^H(B . "0x29509") ; <CJK>
       (?$(J^I(B . "0x4AD6") ; <CJK>
       (?$(J^J(B . "0x29501") ; <CJK>
       (?$(J^K(B . "0x4AD8") ; <CJK>
       (?$(J^L(B . "0x4ADC") ; <CJK>
       (?$(J^M(B . "0x4ADB") ; <CJK>
       (?$(J^N(B . "0x4AD4") ; <CJK>
       (?$(J^O(B . "0x983E") ; <CJK>
       (?$(J^P(B . "0x4B13") ; <CJK>
       (?$(J^Q(B . "0x4B11") ; <CJK>
       (?$(J^R(B . "0x4B14") ; <CJK>
       (?$(J^S(B . "0x29605") ; <CJK>
       (?$(J^T(B . "0x2960C") ; <CJK>
       (?$(J^U(B . "0x29778") ; <CJK>
       (?$(J^V(B . "0x2975D") ; <CJK>
       (?$(J^W(B . "0x4B51") ; <CJK>
       (?$(J^X(B . "0x4B50") ; <CJK>
       (?$(J^Y(B . "0x4B53") ; <CJK>
       (?$(J^Z(B . "0x4B54") ; <CJK>
       (?$(J^[(B . "0x4B52") ; <CJK>
       (?$(J^\(B . "0x2975E") ; <CJK>
       (?$(J^](B . "0x29760") ; <CJK>
       (?$(J^^(B . "0x29767") ; <CJK>
       (?$(J^_(B . "0x4B6D") ; <CJK>
       (?$(J^`(B . "0x2FA05") ; <CJK>
       (?$(J^a(B . "0x298F4") ; <CJK>
       (?$(J^b(B . "0x4B95") ; <CJK>
       (?$(J^c(B . "0x4B99") ; <CJK>
       (?$(J^d(B . "0x298F1") ; <CJK>
       (?$(J^e(B . "0x4B9A") ; <CJK>
       (?$(J^f(B . "0x298FA") ; <CJK>
       (?$(J^g(B . "0x4B93") ; <CJK>
       (?$(J^h(B . "0x4B97") ; <CJK>
       (?$(J^i(B . "0x298F8") ; <CJK>
       (?$(J^j(B . "0x298F9") ; <CJK>
       (?$(J^k(B . "0x29909") ; <CJK>
       (?$(J^l(B . "0x298FD") ; <CJK>
       (?$(J^m(B . "0x298F7") ; <CJK>
       (?$(J^n(B . "0x4BDC") ; <CJK>
       (?$(J^o(B . "0x29A59") ; <CJK>
       (?$(J^p(B . "0x4BFD") ; <CJK>
       (?$(J^q(B . "0x29B60") ; <CJK>
       (?$(J^r(B . "0x29B68") ; <CJK>
       (?$(J^s(B . "0x4BFE") ; <CJK>
       (?$(J^t(B . "0x4C00") ; <CJK>
       (?$(J^u(B . "0x4C02") ; <CJK>
       (?$(J^v(B . "0x4C01") ; <CJK>
       (?$(J^w(B . "0x4C03") ; <CJK>
       (?$(J^x(B . "0x29B6A") ; <CJK>
       (?$(J^y(B . "0x29C14") ; <CJK>
       (?$(J^z(B . "0x29C3E") ; <CJK>
       (?$(J^{(B . "0x29CE4") ; <CJK>
       (?$(J^|(B . "0x4C27") ; <CJK>
       (?$(J^}(B . "0x4C26") ; <CJK>
       (?$(J^~(B . "0x4C24") ; <CJK>
       (?$(J_!(B . "0x4C4C") ; <CJK>
       (?$(J_"(B . "0x9BBC") ; <CJK>
       (?$(J_#(B . "0x4C50") ; <CJK>
       (?$(J_$(B . "0x4C55") ; <CJK>
       (?$(J_%(B . "0x4C53") ; <CJK>
       (?$(J_&(B . "0x9BB7") ; <CJK>
       (?$(J_'(B . "0x4C52") ; <CJK>
       (?$(J_((B . "0x29DD2") ; <CJK>
       (?$(J_)(B . "0x4C57") ; <CJK>
       (?$(J_*(B . "0x9BBE") ; <CJK>
       (?$(J_+(B . "0x4C58") ; <CJK>
       (?$(J_,(B . "0x4CD6") ; <CJK>
       (?$(J_-(B . "0x2A058") ; <CJK>
       (?$(J_.(B . "0x2A050") ; <CJK>
       (?$(J_/(B . "0x4CD4") ; <CJK>
       (?$(J_0(B . "0x2A05C") ; <CJK>
       (?$(J_1(B . "0x4CDA") ; <CJK>
       (?$(J_2(B . "0x4CD9") ; <CJK>
       (?$(J_3(B . "0x28119") ; <CJK>
       (?$(J_4(B . "0x9D62") ; <CJK>
       (?$(J_5(B . "0x4CD5") ; <CJK>
       (?$(J_6(B . "0x4CE4") ; <CJK>
       (?$(J_7(B . "0x2FA0E") ; <CJK>
       (?$(J_8(B . "0x4CDC") ; <CJK>
       (?$(J_9(B . "0x4D1B") ; <CJK>
       (?$(J_:(B . "0x9E8F") ; <CJK>
       (?$(J_;(B . "0x4D37") ; <CJK>
       (?$(J_<(B . "0x4D36") ; <CJK>
       (?$(J_=(B . "0x4D4B") ; <CJK>
       (?$(J_>(B . "0x9ECB") ; <CJK>
       (?$(J_?(B . "0x4D66") ; <CJK>
       (?$(J_@(B . "0x4D76") ; <CJK>
       (?$(J_A(B . "0x2A4DF") ; <CJK>
       (?$(J_B(B . "0x4D7E") ; <CJK>
       (?$(J_C(B . "0x4D7D") ; <CJK>
       (?$(J_D(B . "0x4D7F") ; <CJK>
       (?$(J_E(B . "0x4D84") ; <CJK>
       (?$(J_F(B . "0x4D8B") ; <CJK>
       (?$(J_G(B . "0x2A5D9") ; <CJK>
       (?$(J_H(B . "0x4D94") ; <CJK>
       (?$(J_I(B . "0x34A1") ; <CJK>
       (?$(J_J(B . "0x3511") ; <CJK>
       (?$(J_K(B . "0x20966") ; <CJK>
       (?$(J_L(B . "0x3610") ; <CJK>
       (?$(J_M(B . "0x56A9") ; <CJK>
       (?$(J_N(B . "0x210E1") ; <CJK>
       (?$(J_O(B . "0x210EF") ; <CJK>
       (?$(J_P(B . "0x210E8") ; <CJK>
       (?$(J_Q(B . "0x21233") ; <CJK>
       (?$(J_R(B . "0x5913") ; <CJK>
       (?$(J_S(B . "0x218FE") ; <CJK>
       (?$(J_T(B . "0x3732") ; <CJK>
       (?$(J_U(B . "0x5BF4") ; <CJK>
       (?$(J_V(B . "0x21AEF") ; <CJK>
       (?$(J_W(B . "0x21AEC") ; <CJK>
       (?$(J_X(B . "0x21CEC") ; <CJK>
       (?$(J_Y(B . "0x21F9C") ; <CJK>
       (?$(J_Z(B . "0x3820") ; <CJK>
       (?$(J_[(B . "0x21F99") ; <CJK>
       (?$(J_\(B . "0x22170") ; <CJK>
       (?$(J_](B . "0x2216E") ; <CJK>
       (?$(J_^(B . "0x389D") ; <CJK>
       (?$(J__(B . "0x22441") ; <CJK>
       (?$(J_`(B . "0x61EC") ; <CJK>
       (?$(J_a(B . "0x61EF") ; <CJK>
       (?$(J_b(B . "0x22902") ; <CJK>
       (?$(J_c(B . "0x22901") ; <CJK>
       (?$(J_d(B . "0x39A5") ; <CJK>
       (?$(J_e(B . "0x22A1B") ; <CJK>
       (?$(J_f(B . "0x22E23") ; <CJK>
       (?$(J_g(B . "0x22E25") ; <CJK>
       (?$(J_h(B . "0x22E24") ; <CJK>
       (?$(J_i(B . "0x22E26") ; <CJK>
       (?$(J_j(B . "0x22E33") ; <CJK>
       (?$(J_k(B . "0x22E2F") ; <CJK>
       (?$(J_l(B . "0x2308F") ; <CJK>
       (?$(J_m(B . "0x23356") ; <CJK>
       (?$(J_n(B . "0x3C02") ; <CJK>
       (?$(J_o(B . "0x3BFE") ; <CJK>
       (?$(J_p(B . "0x3C01") ; <CJK>
       (?$(J_q(B . "0x6AD6") ; <CJK>
       (?$(J_r(B . "0x3C03") ; <CJK>
       (?$(J_s(B . "0x3BFF") ; <CJK>
       (?$(J_t(B . "0x23799") ; <CJK>
       (?$(J_u(B . "0x3C04") ; <CJK>
       (?$(J_v(B . "0x2F8ED") ; <CJK>
       (?$(J_w(B . "0x3C4A") ; <CJK>
       (?$(J_x(B . "0x23AD9") ; <CJK>
       (?$(J_y(B . "0x3D87") ; <CJK>
       (?$(J_z(B . "0x240B7") ; <CJK>
       (?$(J_{(B . "0x3D84") ; <CJK>
       (?$(J_|(B . "0x240B6") ; <CJK>
       (?$(J_}(B . "0x3D85") ; <CJK>
       (?$(J_~(B . "0x7209") ; <CJK>
       (?$(J`!(B . "0x24454") ; <CJK>
       (?$(J`"(B . "0x24457") ; <CJK>
       (?$(J`#(B . "0x2447A") ; <CJK>
       (?$(J`$(B . "0x3E59") ; <CJK>
       (?$(J`%(B . "0x7379") ; <CJK>
       (?$(J`&(B . "0x24A8E") ; <CJK>
       (?$(J`'(B . "0x74C6") ; <CJK>
       (?$(J`((B . "0x24A90") ; <CJK>
       (?$(J`)(B . "0x24AB9") ; <CJK>
       (?$(J`*(B . "0x3F04") ; <CJK>
       (?$(J`+(B . "0x3F49") ; <CJK>
       (?$(J`,(B . "0x3F48") ; <CJK>
       (?$(J`-(B . "0x24CEF") ; <CJK>
       (?$(J`.(B . "0x3F6D") ; <CJK>
       (?$(J`/(B . "0x3FD2") ; <CJK>
       (?$(J`0(B . "0x3FD3") ; <CJK>
       (?$(J`1(B . "0x24EE2") ; <CJK>
       (?$(J`2(B . "0x3FD1") ; <CJK>
       (?$(J`3(B . "0x24ED6") ; <CJK>
       (?$(J`4(B . "0x24ED8") ; <CJK>
       (?$(J`5(B . "0x24EDA") ; <CJK>
       (?$(J`6(B . "0x24EDE") ; <CJK>
       (?$(J`7(B . "0x3FE7") ; <CJK>
       (?$(J`8(B . "0x400A") ; <CJK>
       (?$(J`9(B . "0x77C3") ; <CJK>
       (?$(J`:(B . "0x25308") ; <CJK>
       (?$(J`;(B . "0x25304") ; <CJK>
       (?$(J`<(B . "0x2530A") ; <CJK>
       (?$(J`=(B . "0x2530B") ; <CJK>
       (?$(J`>(B . "0x25302") ; <CJK>
       (?$(J`?(B . "0x40F0") ; <CJK>
       (?$(J`@(B . "0x255AA") ; <CJK>
       (?$(J`A(B . "0x255C1") ; <CJK>
       (?$(J`B(B . "0x791F") ; <CJK>
       (?$(J`C(B . "0x258D7") ; <CJK>
       (?$(J`D(B . "0x258D9") ; <CJK>
       (?$(J`E(B . "0x7A65") ; <CJK>
       (?$(J`F(B . "0x258DE") ; <CJK>
       (?$(J`G(B . "0x258DA") ; <CJK>
       (?$(J`H(B . "0x41BE") ; <CJK>
       (?$(J`I(B . "0x41BF") ; <CJK>
       (?$(J`J(B . "0x25A2A") ; <CJK>
       (?$(J`K(B . "0x7AC6") ; <CJK>
       (?$(J`L(B . "0x7C3A") ; <CJK>
       (?$(J`M(B . "0x25D31") ; <CJK>
       (?$(J`N(B . "0x7C36") ; <CJK>
       (?$(J`O(B . "0x25D2B") ; <CJK>
       (?$(J`P(B . "0x25D2C") ; <CJK>
       (?$(J`Q(B . "0x25D29") ; <CJK>
       (?$(J`R(B . "0x25D2E") ; <CJK>
       (?$(J`S(B . "0x425E") ; <CJK>
       (?$(J`T(B . "0x25D27") ; <CJK>
       (?$(J`U(B . "0x25D28") ; <CJK>
       (?$(J`V(B . "0x425B") ; <CJK>
       (?$(J`W(B . "0x25D5F") ; <CJK>
       (?$(J`X(B . "0x25D30") ; <CJK>
       (?$(J`Y(B . "0x25D24") ; <CJK>
       (?$(J`Z(B . "0x7CEB") ; <CJK>
       (?$(J`[(B . "0x42AB") ; <CJK>
       (?$(J`\(B . "0x25F3A") ; <CJK>
       (?$(J`](B . "0x42AC") ; <CJK>
       (?$(J`^(B . "0x25F39") ; <CJK>
       (?$(J`_(B . "0x25F40") ; <CJK>
       (?$(J``(B . "0x26180") ; <CJK>
       (?$(J`a(B . "0x26184") ; <CJK>
       (?$(J`b(B . "0x431F") ; <CJK>
       (?$(J`c(B . "0x431D") ; <CJK>
       (?$(J`d(B . "0x26175") ; <CJK>
       (?$(J`e(B . "0x26176") ; <CJK>
       (?$(J`f(B . "0x431C") ; <CJK>
       (?$(J`g(B . "0x2617C") ; <CJK>
       (?$(J`h(B . "0x431E") ; <CJK>
       (?$(J`i(B . "0x26178") ; <CJK>
       (?$(J`j(B . "0x2619B") ; <CJK>
       (?$(J`k(B . "0x2617E") ; <CJK>
       (?$(J`l(B . "0x2625A") ; <CJK>
       (?$(J`m(B . "0x4364") ; <CJK>
       (?$(J`n(B . "0x2632C") ; <CJK>
       (?$(J`o(B . "0x7F84") ; <CJK>
       (?$(J`p(B . "0x2649C") ; <CJK>
       (?$(J`q(B . "0x26847") ; <CJK>
       (?$(J`r(B . "0x2688A") ; <CJK>
       (?$(J`s(B . "0x4448") ; <CJK>
       (?$(J`t(B . "0x4447") ; <CJK>
       (?$(J`u(B . "0x26927") ; <CJK>
       (?$(J`v(B . "0x2704A") ; <CJK>
       (?$(J`w(B . "0x455E") ; <CJK>
       (?$(J`x(B . "0x4561") ; <CJK>
       (?$(J`y(B . "0x27027") ; <CJK>
       (?$(J`z(B . "0x85E0") ; <CJK>
       (?$(J`{(B . "0x85F3") ; <CJK>
       (?$(J`|(B . "0x2702E") ; <CJK>
       (?$(J`}(B . "0x27026") ; <CJK>
       (?$(J`~(B . "0x27208") ; <CJK>
       (?$(Ja!(B . "0x45F7") ; <CJK>
       (?$(Ja"(B . "0x274BD") ; <CJK>
       (?$(Ja#(B . "0x27496") ; <CJK>
       (?$(Ja$(B . "0x45F4") ; <CJK>
       (?$(Ja%(B . "0x45F8") ; <CJK>
       (?$(Ja&(B . "0x881E") ; <CJK>
       (?$(Ja'(B . "0x274BE") ; <CJK>
       (?$(Ja((B . "0x2748E") ; <CJK>
       (?$(Ja)(B . "0x27774") ; <CJK>
       (?$(Ja*(B . "0x4664") ; <CJK>
       (?$(Ja+(B . "0x27780") ; <CJK>
       (?$(Ja,(B . "0x4692") ; <CJK>
       (?$(Ja-(B . "0x468F") ; <CJK>
       (?$(Ja.(B . "0x4690") ; <CJK>
       (?$(Ja/(B . "0x89B4") ; <CJK>
       (?$(Ja0(B . "0x4693") ; <CJK>
       (?$(Ja1(B . "0x46A8") ; <CJK>
       (?$(Ja2(B . "0x2793C") ; <CJK>
       (?$(Ja3(B . "0x2793D") ; <CJK>
       (?$(Ja4(B . "0x46A9") ; <CJK>
       (?$(Ja5(B . "0x2793A") ; <CJK>
       (?$(Ja6(B . "0x27942") ; <CJK>
       (?$(Ja7(B . "0x89F9") ; <CJK>
       (?$(Ja8(B . "0x27B24") ; <CJK>
       (?$(Ja9(B . "0x27B06") ; <CJK>
       (?$(Ja:(B . "0x8B44") ; <CJK>
       (?$(Ja;(B . "0x470E") ; <CJK>
       (?$(Ja<(B . "0x27B15") ; <CJK>
       (?$(Ja=(B . "0x470F") ; <CJK>
       (?$(Ja>(B . "0x27B02") ; <CJK>
       (?$(Ja?(B . "0x27B0C") ; <CJK>
       (?$(Ja@(B . "0x470B") ; <CJK>
       (?$(JaA(B . "0x27B08") ; <CJK>
       (?$(JaB(B . "0x27B0A") ; <CJK>
       (?$(JaC(B . "0x27B05") ; <CJK>
       (?$(JaD(B . "0x27B1C") ; <CJK>
       (?$(JaE(B . "0x4710") ; <CJK>
       (?$(JaF(B . "0x4751") ; <CJK>
       (?$(JaG(B . "0x27C82") ; <CJK>
       (?$(JaH(B . "0x4750") ; <CJK>
       (?$(JaI(B . "0x27C86") ; <CJK>
       (?$(JaJ(B . "0x4763") ; <CJK>
       (?$(JaK(B . "0x27E03") ; <CJK>
       (?$(JaL(B . "0x27F7B") ; <CJK>
       (?$(JaM(B . "0x47C7") ; <CJK>
       (?$(JaN(B . "0x27F7A") ; <CJK>
       (?$(JaO(B . "0x8E71") ; <CJK>
       (?$(JaP(B . "0x4824") ; <CJK>
       (?$(JaQ(B . "0x4826") ; <CJK>
       (?$(JaR(B . "0x8E6E") ; <CJK>
       (?$(JaS(B . "0x28180") ; <CJK>
       (?$(JaT(B . "0x8E79") ; <CJK>
       (?$(JaU(B . "0x28158") ; <CJK>
       (?$(JaV(B . "0x8EC4") ; <CJK>
       (?$(JaW(B . "0x4874") ; <CJK>
       (?$(JaX(B . "0x4873") ; <CJK>
       (?$(JaY(B . "0x4872") ; <CJK>
       (?$(JaZ(B . "0x283AA") ; <CJK>
       (?$(Ja[(B . "0x283AB") ; <CJK>
       (?$(Ja\(B . "0x28436") ; <CJK>
       (?$(Ja](B . "0x2844A") ; <CJK>
       (?$(Ja^(B . "0x48B1") ; <CJK>
       (?$(Ja_(B . "0x908C") ; <CJK>
       (?$(Ja`(B . "0x287D6") ; <CJK>
       (?$(Jaa(B . "0x490E") ; <CJK>
       (?$(Jab(B . "0x4911") ; <CJK>
       (?$(Jac(B . "0x4910") ; <CJK>
       (?$(Jad(B . "0x490F") ; <CJK>
       (?$(Jae(B . "0x4912") ; <CJK>
       (?$(Jaf(B . "0x4949") ; <CJK>
       (?$(Jag(B . "0x93C9") ; <CJK>
       (?$(Jah(B . "0x494F") ; <CJK>
       (?$(Jai(B . "0x494D") ; <CJK>
       (?$(Jaj(B . "0x28B03") ; <CJK>
       (?$(Jak(B . "0x28ACF") ; <CJK>
       (?$(Jal(B . "0x4955") ; <CJK>
       (?$(Jam(B . "0x28D9F") ; <CJK>
       (?$(Jan(B . "0x28DA2") ; <CJK>
       (?$(Jao(B . "0x2902A") ; <CJK>
       (?$(Jap(B . "0x2902F") ; <CJK>
       (?$(Jaq(B . "0x29144") ; <CJK>
       (?$(Jar(B . "0x29140") ; <CJK>
       (?$(Jas(B . "0x4A2C") ; <CJK>
       (?$(Jat(B . "0x4A2B") ; <CJK>
       (?$(Jau(B . "0x29311") ; <CJK>
       (?$(Jav(B . "0x2930F") ; <CJK>
       (?$(Jaw(B . "0x4A79") ; <CJK>
       (?$(Jax(B . "0x2930D") ; <CJK>
       (?$(Jay(B . "0x29307") ; <CJK>
       (?$(Jaz(B . "0x29303") ; <CJK>
       (?$(Ja{(B . "0x4A7A") ; <CJK>
       (?$(Ja|(B . "0x97B0") ; <CJK>
       (?$(Ja}(B . "0x4A99") ; <CJK>
       (?$(Ja~(B . "0x4A9A") ; <CJK>
       (?$(Jb!(B . "0x29435") ; <CJK>
       (?$(Jb"(B . "0x4AAE") ; <CJK>
       (?$(Jb#(B . "0x4AAF") ; <CJK>
       (?$(Jb$(B . "0x29504") ; <CJK>
       (?$(Jb%(B . "0x4AE4") ; <CJK>
       (?$(Jb&(B . "0x4AE1") ; <CJK>
       (?$(Jb'(B . "0x4ADE") ; <CJK>
       (?$(Jb((B . "0x4AE6") ; <CJK>
       (?$(Jb)(B . "0x4ADF") ; <CJK>
       (?$(Jb*(B . "0x29526") ; <CJK>
       (?$(Jb+(B . "0x4AE7") ; <CJK>
       (?$(Jb,(B . "0x4AE2") ; <CJK>
       (?$(Jb-(B . "0x4AE0") ; <CJK>
       (?$(Jb.(B . "0x2951E") ; <CJK>
       (?$(Jb/(B . "0x4AE5") ; <CJK>
       (?$(Jb0(B . "0x985A") ; <CJK>
       (?$(Jb1(B . "0x2960E") ; <CJK>
       (?$(Jb2(B . "0x4B18") ; <CJK>
       (?$(Jb3(B . "0x2961D") ; <CJK>
       (?$(Jb4(B . "0x2961E") ; <CJK>
       (?$(Jb5(B . "0x2961F") ; <CJK>
       (?$(Jb6(B . "0x4B56") ; <CJK>
       (?$(Jb7(B . "0x29788") ; <CJK>
       (?$(Jb8(B . "0x9946") ; <CJK>
       (?$(Jb9(B . "0x2978D") ; <CJK>
       (?$(Jb:(B . "0x29791") ; <CJK>
       (?$(Jb;(B . "0x29780") ; <CJK>
       (?$(Jb<(B . "0x4B6E") ; <CJK>
       (?$(Jb=(B . "0x29854") ; <CJK>
       (?$(Jb>(B . "0x29855") ; <CJK>
       (?$(Jb?(B . "0x4B9D") ; <CJK>
       (?$(Jb@(B . "0x4BA0") ; <CJK>
       (?$(JbA(B . "0x4B9C") ; <CJK>
       (?$(JbB(B . "0x29925") ; <CJK>
       (?$(JbC(B . "0x2991A") ; <CJK>
       (?$(JbD(B . "0x4BA1") ; <CJK>
       (?$(JbE(B . "0x4BA2") ; <CJK>
       (?$(JbF(B . "0x4B9F") ; <CJK>
       (?$(JbG(B . "0x4BDF") ; <CJK>
       (?$(JbH(B . "0x4BDE") ; <CJK>
       (?$(JbI(B . "0x9AC3") ; <CJK>
       (?$(JbJ(B . "0x4BEA") ; <CJK>
       (?$(JbK(B . "0x29B88") ; <CJK>
       (?$(JbL(B . "0x4C06") ; <CJK>
       (?$(JbM(B . "0x29B7A") ; <CJK>
       (?$(JbN(B . "0x4C04") ; <CJK>
       (?$(JbO(B . "0x9B0F") ; <CJK>
       (?$(JbP(B . "0x29B80") ; <CJK>
       (?$(JbQ(B . "0x29D1E") ; <CJK>
       (?$(JbR(B . "0x29DFC") ; <CJK>
       (?$(JbS(B . "0x29E25") ; <CJK>
       (?$(JbT(B . "0x4C5F") ; <CJK>
       (?$(JbU(B . "0x9BF4") ; <CJK>
       (?$(JbV(B . "0x9BFA") ; <CJK>
       (?$(JbW(B . "0x4C5C") ; <CJK>
       (?$(JbX(B . "0x29E0B") ; <CJK>
       (?$(JbY(B . "0x4C5E") ; <CJK>
       (?$(JbZ(B . "0x29E06") ; <CJK>
       (?$(Jb[(B . "0x29E04") ; <CJK>
       (?$(Jb\(B . "0x9BDD") ; <CJK>
       (?$(Jb](B . "0x4C59") ; <CJK>
       (?$(Jb^(B . "0x29DF9") ; <CJK>
       (?$(Jb_(B . "0x29E00") ; <CJK>
       (?$(Jb`(B . "0x4C64") ; <CJK>
       (?$(Jba(B . "0x4C5D") ; <CJK>
       (?$(Jbb(B . "0x4C62") ; <CJK>
       (?$(Jbc(B . "0x29E02") ; <CJK>
       (?$(Jbd(B . "0x4C65") ; <CJK>
       (?$(Jbe(B . "0x29E07") ; <CJK>
       (?$(Jbf(B . "0x9BED") ; <CJK>
       (?$(Jbg(B . "0x4C5B") ; <CJK>
       (?$(Jbh(B . "0x9BEF") ; <CJK>
       (?$(Jbi(B . "0x2A0B5") ; <CJK>
       (?$(Jbj(B . "0x4CDD") ; <CJK>
       (?$(Jbk(B . "0x2A087") ; <CJK>
       (?$(Jbl(B . "0x4CDF") ; <CJK>
       (?$(Jbm(B . "0x2A093") ; <CJK>
       (?$(Jbn(B . "0x2FA0F") ; <CJK>
       (?$(Jbo(B . "0x4CE2") ; <CJK>
       (?$(Jbp(B . "0x2A0BE") ; <CJK>
       (?$(Jbq(B . "0x2A266") ; <CJK>
       (?$(Jbr(B . "0x4D27") ; <CJK>
       (?$(Jbs(B . "0x2A2C7") ; <CJK>
       (?$(Jbt(B . "0x2A2CF") ; <CJK>
       (?$(Jbu(B . "0x9E96") ; <CJK>
       (?$(Jbv(B . "0x4D3A") ; <CJK>
       (?$(Jbw(B . "0x4D3C") ; <CJK>
       (?$(Jbx(B . "0x2A33D") ; <CJK>
       (?$(Jby(B . "0x4D39") ; <CJK>
       (?$(Jbz(B . "0x2A33C") ; <CJK>
       (?$(Jb{(B . "0x2A347") ; <CJK>
       (?$(Jb|(B . "0x4D3D") ; <CJK>
       (?$(Jb}(B . "0x4D3B") ; <CJK>
       (?$(Jb~(B . "0x9EB3") ; <CJK>
       (?$(Jc!(B . "0x4D4C") ; <CJK>
       (?$(Jc"(B . "0x2A3C3") ; <CJK>
       (?$(Jc#(B . "0x4D68") ; <CJK>
       (?$(Jc$(B . "0x9EE2") ; <CJK>
       (?$(Jc%(B . "0x2A51B") ; <CJK>
       (?$(Jc&(B . "0x4D80") ; <CJK>
       (?$(Jc'(B . "0x4D85") ; <CJK>
       (?$(Jc((B . "0x2A5C9") ; <CJK>
       (?$(Jc)(B . "0x4D95") ; <CJK>
       (?$(Jc*(B . "0x2A5DD") ; <CJK>
       (?$(Jc+(B . "0x4D96") ; <CJK>
       (?$(Jc,(B . "0x2A693") ; <CJK>
       (?$(Jc-(B . "0x9F8F") ; <CJK>
       (?$(Jc.(B . "0x2043D") ; <CJK>
       (?$(Jc/(B . "0x34A4") ; <CJK>
       (?$(Jc0(B . "0x3512") ; <CJK>
       (?$(Jc1(B . "0x56B1") ; <CJK>
       (?$(Jc2(B . "0x3625") ; <CJK>
       (?$(Jc3(B . "0x214E6") ; <CJK>
       (?$(Jc4(B . "0x5B41") ; <CJK>
       (?$(Jc5(B . "0x3737") ; <CJK>
       (?$(Jc6(B . "0x21AF7") ; <CJK>
       (?$(Jc7(B . "0x21FB0") ; <CJK>
       (?$(Jc8(B . "0x21FAE") ; <CJK>
       (?$(Jc9(B . "0x5E71") ; <CJK>
       (?$(Jc:(B . "0x3868") ; <CJK>
       (?$(Jc;(B . "0x3867") ; <CJK>
       (?$(Jc<(B . "0x389E") ; <CJK>
       (?$(Jc=(B . "0x2259F") ; <CJK>
       (?$(Jc>(B . "0x2259E") ; <CJK>
       (?$(Jc?(B . "0x22930") ; <CJK>
       (?$(Jc@(B . "0x39AA") ; <CJK>
       (?$(JcA(B . "0x2294F") ; <CJK>
       (?$(JcB(B . "0x39A9") ; <CJK>
       (?$(JcC(B . "0x39A4") ; <CJK>
       (?$(JcD(B . "0x22927") ; <CJK>
       (?$(JcE(B . "0x22951") ; <CJK>
       (?$(JcF(B . "0x3A71") ; <CJK>
       (?$(JcG(B . "0x3A6F") ; <CJK>
       (?$(JcH(B . "0x22E51") ; <CJK>
       (?$(JcI(B . "0x22E54") ; <CJK>
       (?$(JcJ(B . "0x22E56") ; <CJK>
       (?$(JcK(B . "0x23027") ; <CJK>
       (?$(JcL(B . "0x3AAD") ; <CJK>
       (?$(JcM(B . "0x23024") ; <CJK>
       (?$(JcN(B . "0x6AF6") ; <CJK>
       (?$(JcO(B . "0x3C0C") ; <CJK>
       (?$(JcP(B . "0x6AF2") ; <CJK>
       (?$(JcQ(B . "0x3C0B") ; <CJK>
       (?$(JcR(B . "0x237EC") ; <CJK>
       (?$(JcS(B . "0x237C4") ; <CJK>
       (?$(JcT(B . "0x3C0F") ; <CJK>
       (?$(JcU(B . "0x3C79") ; <CJK>
       (?$(JcV(B . "0x240F8") ; <CJK>
       (?$(JcW(B . "0x240F6") ; <CJK>
       (?$(JcX(B . "0x240F7") ; <CJK>
       (?$(JcY(B . "0x240ED") ; <CJK>
       (?$(JcZ(B . "0x3D8D") ; <CJK>
       (?$(Jc[(B . "0x3D8F") ; <CJK>
       (?$(Jc\(B . "0x240F4") ; <CJK>
       (?$(Jc](B . "0x240EF") ; <CJK>
       (?$(Jc^(B . "0x3D8E") ; <CJK>
       (?$(Jc_(B . "0x3E0C") ; <CJK>
       (?$(Jc`(B . "0x2447F") ; <CJK>
       (?$(Jca(B . "0x244A2") ; <CJK>
       (?$(Jcb(B . "0x2447E") ; <CJK>
       (?$(Jcc(B . "0x3EA6") ; <CJK>
       (?$(Jcd(B . "0x248C5") ; <CJK>
       (?$(Jce(B . "0x3EA3") ; <CJK>
       (?$(Jcf(B . "0x3EA4") ; <CJK>
       (?$(Jcg(B . "0x3EA5") ; <CJK>
       (?$(Jch(B . "0x7588") ; <CJK>
       (?$(Jci(B . "0x3F6E") ; <CJK>
       (?$(Jcj(B . "0x24EF1") ; <CJK>
       (?$(Jck(B . "0x24EF2") ; <CJK>
       (?$(Jcl(B . "0x3FFA") ; <CJK>
       (?$(Jcm(B . "0x2502F") ; <CJK>
       (?$(Jcn(B . "0x407C") ; <CJK>
       (?$(Jco(B . "0x407E") ; <CJK>
       (?$(Jcp(B . "0x407B") ; <CJK>
       (?$(Jcq(B . "0x407D") ; <CJK>
       (?$(Jcr(B . "0x25323") ; <CJK>
       (?$(Jcs(B . "0x25329") ; <CJK>
       (?$(Jct(B . "0x408D") ; <CJK>
       (?$(Jcu(B . "0x40F4") ; <CJK>
       (?$(Jcv(B . "0x40F3") ; <CJK>
       (?$(Jcw(B . "0x2571B") ; <CJK>
       (?$(Jcx(B . "0x258EB") ; <CJK>
       (?$(Jcy(B . "0x4189") ; <CJK>
       (?$(Jcz(B . "0x258EA") ; <CJK>
       (?$(Jc{(B . "0x25A33") ; <CJK>
       (?$(Jc|(B . "0x41C0") ; <CJK>
       (?$(Jc}(B . "0x25D63") ; <CJK>
       (?$(Jc~(B . "0x4265") ; <CJK>
       (?$(Jd!(B . "0x25D92") ; <CJK>
       (?$(Jd"(B . "0x25D65") ; <CJK>
       (?$(Jd#(B . "0x42AD") ; <CJK>
       (?$(Jd$(B . "0x4325") ; <CJK>
       (?$(Jd%(B . "0x261A0") ; <CJK>
       (?$(Jd&(B . "0x2F970") ; <CJK>
       (?$(Jd'(B . "0x2625E") ; <CJK>
       (?$(Jd((B . "0x43C9") ; <CJK>
       (?$(Jd)(B . "0x268AA") ; <CJK>
       (?$(Jd*(B . "0x444A") ; <CJK>
       (?$(Jd+(B . "0x268A9") ; <CJK>
       (?$(Jd,(B . "0x8267") ; <CJK>
       (?$(Jd-(B . "0x4489") ; <CJK>
       (?$(Jd.(B . "0x2709C") ; <CJK>
       (?$(Jd/(B . "0x4566") ; <CJK>
       (?$(Jd0(B . "0x4570") ; <CJK>
       (?$(Jd1(B . "0x27092") ; <CJK>
       (?$(Jd2(B . "0x456D") ; <CJK>
       (?$(Jd3(B . "0x4569") ; <CJK>
       (?$(Jd4(B . "0x4567") ; <CJK>
       (?$(Jd5(B . "0x27086") ; <CJK>
       (?$(Jd6(B . "0x4572") ; <CJK>
       (?$(Jd7(B . "0x860E") ; <CJK>
       (?$(Jd8(B . "0x456E") ; <CJK>
       (?$(Jd9(B . "0x27083") ; <CJK>
       (?$(Jd:(B . "0x459C") ; <CJK>
       (?$(Jd;(B . "0x45FC") ; <CJK>
       (?$(Jd<(B . "0x45FD") ; <CJK>
       (?$(Jd=(B . "0x4604") ; <CJK>
       (?$(Jd>(B . "0x45FF") ; <CJK>
       (?$(Jd?(B . "0x2F9C2") ; <CJK>
       (?$(Jd@(B . "0x45FE") ; <CJK>
       (?$(JdA(B . "0x4600") ; <CJK>
       (?$(JdB(B . "0x274CE") ; <CJK>
       (?$(JdC(B . "0x4666") ; <CJK>
       (?$(JdD(B . "0x4669") ; <CJK>
       (?$(JdE(B . "0x27793") ; <CJK>
       (?$(JdF(B . "0x46AA") ; <CJK>
       (?$(JdG(B . "0x46AB") ; <CJK>
       (?$(JdH(B . "0x4717") ; <CJK>
       (?$(JdI(B . "0x27B2E") ; <CJK>
       (?$(JdJ(B . "0x27B27") ; <CJK>
       (?$(JdK(B . "0x27B28") ; <CJK>
       (?$(JdL(B . "0x4715") ; <CJK>
       (?$(JdM(B . "0x8B5E") ; <CJK>
       (?$(JdN(B . "0x4712") ; <CJK>
       (?$(JdO(B . "0x8D0E") ; <CJK>
       (?$(JdP(B . "0x27E18") ; <CJK>
       (?$(JdQ(B . "0x27E16") ; <CJK>
       (?$(JdR(B . "0x27F8D") ; <CJK>
       (?$(JdS(B . "0x47CA") ; <CJK>
       (?$(JdT(B . "0x27F8E") ; <CJK>
       (?$(JdU(B . "0x47C9") ; <CJK>
       (?$(JdV(B . "0x47CB") ; <CJK>
       (?$(JdW(B . "0x27F90") ; <CJK>
       (?$(JdX(B . "0x27F8F") ; <CJK>
       (?$(JdY(B . "0x28181") ; <CJK>
       (?$(JdZ(B . "0x4829") ; <CJK>
       (?$(Jd[(B . "0x4828") ; <CJK>
       (?$(Jd\(B . "0x2818A") ; <CJK>
       (?$(Jd](B . "0x2818C") ; <CJK>
       (?$(Jd^(B . "0x2828D") ; <CJK>
       (?$(Jd_(B . "0x4840") ; <CJK>
       (?$(Jd`(B . "0x4875") ; <CJK>
       (?$(Jda(B . "0x4876") ; <CJK>
       (?$(Jdb(B . "0x283B2") ; <CJK>
       (?$(Jdc(B . "0x4888") ; <CJK>
       (?$(Jdd(B . "0x287D9") ; <CJK>
       (?$(Jde(B . "0x91B6") ; <CJK>
       (?$(Jdf(B . "0x4957") ; <CJK>
       (?$(Jdg(B . "0x9401") ; <CJK>
       (?$(Jdh(B . "0x28B0D") ; <CJK>
       (?$(Jdi(B . "0x495F") ; <CJK>
       (?$(Jdj(B . "0x28B13") ; <CJK>
       (?$(Jdk(B . "0x941D") ; <CJK>
       (?$(Jdl(B . "0x4958") ; <CJK>
       (?$(Jdm(B . "0x495B") ; <CJK>
       (?$(Jdn(B . "0x28B1B") ; <CJK>
       (?$(Jdo(B . "0x942F") ; <CJK>
       (?$(Jdp(B . "0x28DAC") ; <CJK>
       (?$(Jdq(B . "0x49B3") ; <CJK>
       (?$(Jdr(B . "0x28DB3") ; <CJK>
       (?$(Jds(B . "0x49EF") ; <CJK>
       (?$(Jdt(B . "0x2915E") ; <CJK>
       (?$(Jdu(B . "0x4A30") ; <CJK>
       (?$(Jdv(B . "0x29160") ; <CJK>
       (?$(Jdw(B . "0x29168") ; <CJK>
       (?$(Jdx(B . "0x29163") ; <CJK>
       (?$(Jdy(B . "0x29169") ; <CJK>
       (?$(Jdz(B . "0x29167") ; <CJK>
       (?$(Jd{(B . "0x4A41") ; <CJK>
       (?$(Jd|(B . "0x4A4B") ; <CJK>
       (?$(Jd}(B . "0x29328") ; <CJK>
       (?$(Jd~(B . "0x4A7D") ; <CJK>
       (?$(Je!(B . "0x2932E") ; <CJK>
       (?$(Je"(B . "0x29330") ; <CJK>
       (?$(Je#(B . "0x4A7C") ; <CJK>
       (?$(Je$(B . "0x29326") ; <CJK>
       (?$(Je%(B . "0x29331") ; <CJK>
       (?$(Je&(B . "0x29341") ; <CJK>
       (?$(Je'(B . "0x97E0") ; <CJK>
       (?$(Je((B . "0x293DA") ; <CJK>
       (?$(Je)(B . "0x97DB") ; <CJK>
       (?$(Je*(B . "0x2F9FA") ; <CJK>
       (?$(Je+(B . "0x2940B") ; <CJK>
       (?$(Je,(B . "0x9861") ; <CJK>
       (?$(Je-(B . "0x29534") ; <CJK>
       (?$(Je.(B . "0x29533") ; <CJK>
       (?$(Je/(B . "0x4AE8") ; <CJK>
       (?$(Je0(B . "0x4AEA") ; <CJK>
       (?$(Je1(B . "0x4AE9") ; <CJK>
       (?$(Je2(B . "0x29539") ; <CJK>
       (?$(Je3(B . "0x2953B") ; <CJK>
       (?$(Je4(B . "0x29540") ; <CJK>
       (?$(Je5(B . "0x29630") ; <CJK>
       (?$(Je6(B . "0x4B1B") ; <CJK>
       (?$(Je7(B . "0x29632") ; <CJK>
       (?$(Je8(B . "0x29637") ; <CJK>
       (?$(Je9(B . "0x4B55") ; <CJK>
       (?$(Je:(B . "0x994A") ; <CJK>
       (?$(Je;(B . "0x4B59") ; <CJK>
       (?$(Je<(B . "0x4B58") ; <CJK>
       (?$(Je=(B . "0x29781") ; <CJK>
       (?$(Je>(B . "0x2979F") ; <CJK>
       (?$(Je?(B . "0x297A7") ; <CJK>
       (?$(Je@(B . "0x4BA4") ; <CJK>
       (?$(JeA(B . "0x4BA3") ; <CJK>
       (?$(JeB(B . "0x29944") ; <CJK>
       (?$(JeC(B . "0x29947") ; <CJK>
       (?$(JeD(B . "0x29948") ; <CJK>
       (?$(JeE(B . "0x2993D") ; <CJK>
       (?$(JeF(B . "0x9A33") ; <CJK>
       (?$(JeG(B . "0x4BA7") ; <CJK>
       (?$(JeH(B . "0x29949") ; <CJK>
       (?$(JeI(B . "0x4BE0") ; <CJK>
       (?$(JeJ(B . "0x29A80") ; <CJK>
       (?$(JeK(B . "0x29BA0") ; <CJK>
       (?$(JeL(B . "0x29B9D") ; <CJK>
       (?$(JeM(B . "0x4C08") ; <CJK>
       (?$(JeN(B . "0x4C0A") ; <CJK>
       (?$(JeO(B . "0x4C09") ; <CJK>
       (?$(JeP(B . "0x29B9C") ; <CJK>
       (?$(JeQ(B . "0x29C47") ; <CJK>
       (?$(JeR(B . "0x29D07") ; <CJK>
       (?$(JeS(B . "0x4C71") ; <CJK>
       (?$(JeT(B . "0x9C0F") ; <CJK>
       (?$(JeU(B . "0x4C6C") ; <CJK>
       (?$(JeV(B . "0x29E49") ; <CJK>
       (?$(JeW(B . "0x9C11") ; <CJK>
       (?$(JeX(B . "0x29E44") ; <CJK>
       (?$(JeY(B . "0x9C03") ; <CJK>
       (?$(JeZ(B . "0x9C01") ; <CJK>
       (?$(Je[(B . "0x4C6E") ; <CJK>
       (?$(Je\(B . "0x29EDF") ; <CJK>
       (?$(Je](B . "0x9C16") ; <CJK>
       (?$(Je^(B . "0x29E4C") ; <CJK>
       (?$(Je_(B . "0x9BFD") ; <CJK>
       (?$(Je`(B . "0x29E4F") ; <CJK>
       (?$(Jea(B . "0x4CE0") ; <CJK>
       (?$(Jeb(B . "0x4CEE") ; <CJK>
       (?$(Jec(B . "0x2A0C1") ; <CJK>
       (?$(Jed(B . "0x4CEB") ; <CJK>
       (?$(Jee(B . "0x2A0B9") ; <CJK>
       (?$(Jef(B . "0x2A0CB") ; <CJK>
       (?$(Jeg(B . "0x2A0CF") ; <CJK>
       (?$(Jeh(B . "0x2A0C4") ; <CJK>
       (?$(Jei(B . "0x9D93") ; <CJK>
       (?$(Jej(B . "0x4CEA") ; <CJK>
       (?$(Jek(B . "0x4CEF") ; <CJK>
       (?$(Jel(B . "0x4CE7") ; <CJK>
       (?$(Jem(B . "0x2A0CA") ; <CJK>
       (?$(Jen(B . "0x2A0C3") ; <CJK>
       (?$(Jeo(B . "0x2A2D0") ; <CJK>
       (?$(Jep(B . "0x2A351") ; <CJK>
       (?$(Jeq(B . "0x4D48") ; <CJK>
       (?$(Jer(B . "0x4D49") ; <CJK>
       (?$(Jes(B . "0x2A3A8") ; <CJK>
       (?$(Jet(B . "0x2A3C7") ; <CJK>
       (?$(Jeu(B . "0x2A3C6") ; <CJK>
       (?$(Jev(B . "0x4D4D") ; <CJK>
       (?$(Jew(B . "0x2A3CA") ; <CJK>
       (?$(Jex(B . "0x2A402") ; <CJK>
       (?$(Jey(B . "0x4D55") ; <CJK>
       (?$(Jez(B . "0x2A45D") ; <CJK>
       (?$(Je{(B . "0x2A45A") ; <CJK>
       (?$(Je|(B . "0x4D6A") ; <CJK>
       (?$(Je}(B . "0x4D6C") ; <CJK>
       (?$(Je~(B . "0x2A459") ; <CJK>
       (?$(Jf!(B . "0x4D6B") ; <CJK>
       (?$(Jf"(B . "0x2A4CC") ; <CJK>
       (?$(Jf#(B . "0x2A51C") ; <CJK>
       (?$(Jf$(B . "0x2A5CC") ; <CJK>
       (?$(Jf%(B . "0x4D98") ; <CJK>
       (?$(Jf&(B . "0x4D99") ; <CJK>
       (?$(Jf'(B . "0x4D97") ; <CJK>
       (?$(Jf((B . "0x2A5E8") ; <CJK>
       (?$(Jf)(B . "0x2A5EC") ; <CJK>
       (?$(Jf*(B . "0x2A5EA") ; <CJK>
       (?$(Jf+(B . "0x2A6AD") ; <CJK>
       (?$(Jf,(B . "0x2A6B0") ; <CJK>
       (?$(Jf-(B . "0x2045F") ; <CJK>
       (?$(Jf.(B . "0x20458") ; <CJK>
       (?$(Jf/(B . "0x20457") ; <CJK>
       (?$(Jf0(B . "0x535B") ; <CJK>
       (?$(Jf1(B . "0x20B93") ; <CJK>
       (?$(Jf2(B . "0x3616") ; <CJK>
       (?$(Jf3(B . "0x2113B") ; <CJK>
       (?$(Jf4(B . "0x56BF") ; <CJK>
       (?$(Jf5(B . "0x21134") ; <CJK>
       (?$(Jf6(B . "0x214F2") ; <CJK>
       (?$(Jf7(B . "0x3739") ; <CJK>
       (?$(Jf8(B . "0x21AFD") ; <CJK>
       (?$(Jf9(B . "0x21C1D") ; <CJK>
       (?$(Jf:(B . "0x3825") ; <CJK>
       (?$(Jf;(B . "0x5DCE") ; <CJK>
       (?$(Jf<(B . "0x22304") ; <CJK>
       (?$(Jf=(B . "0x22448") ; <CJK>
       (?$(Jf>(B . "0x22958") ; <CJK>
       (?$(Jf?(B . "0x22E4F") ; <CJK>
       (?$(Jf@(B . "0x3A74") ; <CJK>
       (?$(JfA(B . "0x22E6E") ; <CJK>
       (?$(JfB(B . "0x22E72") ; <CJK>
       (?$(JfC(B . "0x3AAE") ; <CJK>
       (?$(JfD(B . "0x2302E") ; <CJK>
       (?$(JfE(B . "0x237FC") ; <CJK>
       (?$(JfF(B . "0x237F4") ; <CJK>
       (?$(JfG(B . "0x23C36") ; <CJK>
       (?$(JfH(B . "0x2410E") ; <CJK>
       (?$(JfI(B . "0x3D92") ; <CJK>
       (?$(JfJ(B . "0x3D94") ; <CJK>
       (?$(JfK(B . "0x24114") ; <CJK>
       (?$(JfL(B . "0x3D95") ; <CJK>
       (?$(JfM(B . "0x24119") ; <CJK>
       (?$(JfN(B . "0x3E0D") ; <CJK>
       (?$(JfO(B . "0x244A6") ; <CJK>
       (?$(JfP(B . "0x3E25") ; <CJK>
       (?$(JfQ(B . "0x24AC9") ; <CJK>
       (?$(JfR(B . "0x24AC0") ; <CJK>
       (?$(JfS(B . "0x24ACC") ; <CJK>
       (?$(JfT(B . "0x24B1B") ; <CJK>
       (?$(JfU(B . "0x24BAA") ; <CJK>
       (?$(JfV(B . "0x24BA8") ; <CJK>
       (?$(JfW(B . "0x24F03") ; <CJK>
       (?$(JfX(B . "0x3FD5") ; <CJK>
       (?$(JfY(B . "0x3FD6") ; <CJK>
       (?$(JfZ(B . "0x76AC") ; <CJK>
       (?$(Jf[(B . "0x3FE8") ; <CJK>
       (?$(Jf\(B . "0x25035") ; <CJK>
       (?$(Jf](B . "0x407F") ; <CJK>
       (?$(Jf^(B . "0x77D2") ; <CJK>
       (?$(Jf_(B . "0x40F5") ; <CJK>
       (?$(Jf`(B . "0x40F6") ; <CJK>
       (?$(Jfa(B . "0x40F7") ; <CJK>
       (?$(Jfb(B . "0x255D9") ; <CJK>
       (?$(Jfc(B . "0x4124") ; <CJK>
       (?$(Jfd(B . "0x418D") ; <CJK>
       (?$(Jfe(B . "0x418A") ; <CJK>
       (?$(Jff(B . "0x25A3F") ; <CJK>
       (?$(Jfg(B . "0x25A3D") ; <CJK>
       (?$(Jfh(B . "0x426C") ; <CJK>
       (?$(Jfi(B . "0x4266") ; <CJK>
       (?$(Jfj(B . "0x426A") ; <CJK>
       (?$(Jfk(B . "0x25D8B") ; <CJK>
       (?$(Jfl(B . "0x4267") ; <CJK>
       (?$(Jfm(B . "0x426D") ; <CJK>
       (?$(Jfn(B . "0x4268") ; <CJK>
       (?$(Jfo(B . "0x7C52") ; <CJK>
       (?$(Jfp(B . "0x25D68") ; <CJK>
       (?$(Jfq(B . "0x25D8A") ; <CJK>
       (?$(Jfr(B . "0x25F58") ; <CJK>
       (?$(Jfs(B . "0x25F57") ; <CJK>
       (?$(Jft(B . "0x261CE") ; <CJK>
       (?$(Jfu(B . "0x261BC") ; <CJK>
       (?$(Jfv(B . "0x261C0") ; <CJK>
       (?$(Jfw(B . "0x261C1") ; <CJK>
       (?$(Jfx(B . "0x261BF") ; <CJK>
       (?$(Jfy(B . "0x261AB") ; <CJK>
       (?$(Jfz(B . "0x2625F") ; <CJK>
       (?$(Jf{(B . "0x4365") ; <CJK>
       (?$(Jf|(B . "0x264A6") ; <CJK>
       (?$(Jf}(B . "0x439A") ; <CJK>
       (?$(Jf~(B . "0x26529") ; <CJK>
       (?$(Jg!(B . "0x43B1") ; <CJK>
       (?$(Jg"(B . "0x444B") ; <CJK>
       (?$(Jg#(B . "0x444D") ; <CJK>
       (?$(Jg$(B . "0x444C") ; <CJK>
       (?$(Jg%(B . "0x444E") ; <CJK>
       (?$(Jg&(B . "0x268B8") ; <CJK>
       (?$(Jg'(B . "0x4573") ; <CJK>
       (?$(Jg((B . "0x4575") ; <CJK>
       (?$(Jg)(B . "0x270DD") ; <CJK>
       (?$(Jg*(B . "0x270D6") ; <CJK>
       (?$(Jg+(B . "0x2F9B1") ; <CJK>
       (?$(Jg,(B . "0x270D5") ; <CJK>
       (?$(Jg-(B . "0x270E7") ; <CJK>
       (?$(Jg.(B . "0x270D8") ; <CJK>
       (?$(Jg/(B . "0x274EC") ; <CJK>
       (?$(Jg0(B . "0x4603") ; <CJK>
       (?$(Jg1(B . "0x27500") ; <CJK>
       (?$(Jg2(B . "0x27507") ; <CJK>
       (?$(Jg3(B . "0x274FD") ; <CJK>
       (?$(Jg4(B . "0x274F1") ; <CJK>
       (?$(Jg5(B . "0x274FF") ; <CJK>
       (?$(Jg6(B . "0x277AA") ; <CJK>
       (?$(Jg7(B . "0x277B0") ; <CJK>
       (?$(Jg8(B . "0x27B48") ; <CJK>
       (?$(Jg9(B . "0x471E") ; <CJK>
       (?$(Jg:(B . "0x27B53") ; <CJK>
       (?$(Jg;(B . "0x8B73") ; <CJK>
       (?$(Jg<(B . "0x27B4D") ; <CJK>
       (?$(Jg=(B . "0x4719") ; <CJK>
       (?$(Jg>(B . "0x471C") ; <CJK>
       (?$(Jg?(B . "0x471A") ; <CJK>
       (?$(Jg@(B . "0x471D") ; <CJK>
       (?$(JgA(B . "0x8B76") ; <CJK>
       (?$(JgB(B . "0x27B43") ; <CJK>
       (?$(JgC(B . "0x27B50") ; <CJK>
       (?$(JgD(B . "0x4743") ; <CJK>
       (?$(JgE(B . "0x4752") ; <CJK>
       (?$(JgF(B . "0x27C8C") ; <CJK>
       (?$(JgG(B . "0x27E27") ; <CJK>
       (?$(JgH(B . "0x4795") ; <CJK>
       (?$(JgI(B . "0x27F99") ; <CJK>
       (?$(JgJ(B . "0x47CC") ; <CJK>
       (?$(JgK(B . "0x281B1") ; <CJK>
       (?$(JgL(B . "0x482B") ; <CJK>
       (?$(JgM(B . "0x281B0") ; <CJK>
       (?$(JgN(B . "0x281AA") ; <CJK>
       (?$(JgO(B . "0x281AC") ; <CJK>
       (?$(JgP(B . "0x482A") ; <CJK>
       (?$(JgQ(B . "0x8EC7") ; <CJK>
       (?$(JgR(B . "0x4877") ; <CJK>
       (?$(JgS(B . "0x283C8") ; <CJK>
       (?$(JgT(B . "0x283CA") ; <CJK>
       (?$(JgU(B . "0x28642") ; <CJK>
       (?$(JgV(B . "0x287E0") ; <CJK>
       (?$(JgW(B . "0x288E7") ; <CJK>
       (?$(JgX(B . "0x288E8") ; <CJK>
       (?$(JgY(B . "0x288E6") ; <CJK>
       (?$(JgZ(B . "0x4913") ; <CJK>
       (?$(Jg[(B . "0x4914") ; <CJK>
       (?$(Jg\(B . "0x9434") ; <CJK>
       (?$(Jg](B . "0x28B5B") ; <CJK>
       (?$(Jg^(B . "0x28B56") ; <CJK>
       (?$(Jg_(B . "0x495D") ; <CJK>
       (?$(Jg`(B . "0x28B5A") ; <CJK>
       (?$(Jga(B . "0x4960") ; <CJK>
       (?$(Jgb(B . "0x943E") ; <CJK>
       (?$(Jgc(B . "0x4962") ; <CJK>
       (?$(Jgd(B . "0x28CB8") ; <CJK>
       (?$(Jge(B . "0x28DC5") ; <CJK>
       (?$(Jgf(B . "0x49B2") ; <CJK>
       (?$(Jgg(B . "0x49F0") ; <CJK>
       (?$(Jgh(B . "0x29048") ; <CJK>
       (?$(Jgi(B . "0x2917D") ; <CJK>
       (?$(Jgj(B . "0x2917C") ; <CJK>
       (?$(Jgk(B . "0x29181") ; <CJK>
       (?$(Jgl(B . "0x29182") ; <CJK>
       (?$(Jgm(B . "0x29162") ; <CJK>
       (?$(Jgn(B . "0x4A4C") ; <CJK>
       (?$(Jgo(B . "0x29345") ; <CJK>
       (?$(Jgp(B . "0x4A82") ; <CJK>
       (?$(Jgq(B . "0x97BC") ; <CJK>
       (?$(Jgr(B . "0x4A81") ; <CJK>
       (?$(Jgs(B . "0x4A9B") ; <CJK>
       (?$(Jgt(B . "0x293E3") ; <CJK>
       (?$(Jgu(B . "0x4AA4") ; <CJK>
       (?$(Jgv(B . "0x4AEE") ; <CJK>
       (?$(Jgw(B . "0x4AEC") ; <CJK>
       (?$(Jgx(B . "0x29550") ; <CJK>
       (?$(Jgy(B . "0x4AED") ; <CJK>
       (?$(Jgz(B . "0x2954F") ; <CJK>
       (?$(Jg{(B . "0x4AF0") ; <CJK>
       (?$(Jg|(B . "0x4AEF") ; <CJK>
       (?$(Jg}(B . "0x29639") ; <CJK>
       (?$(Jg~(B . "0x4B1D") ; <CJK>
       (?$(Jh!(B . "0x2963A") ; <CJK>
       (?$(Jh"(B . "0x4B60") ; <CJK>
       (?$(Jh#(B . "0x4B5E") ; <CJK>
       (?$(Jh$(B . "0x4B5D") ; <CJK>
       (?$(Jh%(B . "0x297C1") ; <CJK>
       (?$(Jh&(B . "0x2994E") ; <CJK>
       (?$(Jh'(B . "0x2996E") ; <CJK>
       (?$(Jh((B . "0x4BB1") ; <CJK>
       (?$(Jh)(B . "0x4BAB") ; <CJK>
       (?$(Jh*(B . "0x4BAC") ; <CJK>
       (?$(Jh+(B . "0x4BAD") ; <CJK>
       (?$(Jh,(B . "0x29971") ; <CJK>
       (?$(Jh-(B . "0x4BAE") ; <CJK>
       (?$(Jh.(B . "0x29A8C") ; <CJK>
       (?$(Jh/(B . "0x29A89") ; <CJK>
       (?$(Jh0(B . "0x4BE2") ; <CJK>
       (?$(Jh1(B . "0x29AE5") ; <CJK>
       (?$(Jh2(B . "0x29BB3") ; <CJK>
       (?$(Jh3(B . "0x29BB6") ; <CJK>
       (?$(Jh4(B . "0x29BB4") ; <CJK>
       (?$(Jh5(B . "0x29C4D") ; <CJK>
       (?$(Jh6(B . "0x9B39") ; <CJK>
       (?$(Jh7(B . "0x29D13") ; <CJK>
       (?$(Jh8(B . "0x29E78") ; <CJK>
       (?$(Jh9(B . "0x9C2A") ; <CJK>
       (?$(Jh:(B . "0x4C7B") ; <CJK>
       (?$(Jh;(B . "0x9C26") ; <CJK>
       (?$(Jh<(B . "0x4C78") ; <CJK>
       (?$(Jh=(B . "0x4C75") ; <CJK>
       (?$(Jh>(B . "0x9C27") ; <CJK>
       (?$(Jh?(B . "0x29E72") ; <CJK>
       (?$(Jh@(B . "0x4CF2") ; <CJK>
       (?$(JhA(B . "0x4CF4") ; <CJK>
       (?$(JhB(B . "0x4CF3") ; <CJK>
       (?$(JhC(B . "0x9DC0") ; <CJK>
       (?$(JhD(B . "0x9DC9") ; <CJK>
       (?$(JhE(B . "0x2A275") ; <CJK>
       (?$(JhF(B . "0x2A2DA") ; <CJK>
       (?$(JhG(B . "0x2A2D7") ; <CJK>
       (?$(JhH(B . "0x4D3F") ; <CJK>
       (?$(JhI(B . "0x4D3E") ; <CJK>
       (?$(JhJ(B . "0x4D40") ; <CJK>
       (?$(JhK(B . "0x4D4E") ; <CJK>
       (?$(JhL(B . "0x4D57") ; <CJK>
       (?$(JhM(B . "0x4D59") ; <CJK>
       (?$(JhN(B . "0x4D58") ; <CJK>
       (?$(JhO(B . "0x2FA16") ; <CJK>
       (?$(JhP(B . "0x2A469") ; <CJK>
       (?$(JhQ(B . "0x2A467") ; <CJK>
       (?$(JhR(B . "0x4D6E") ; <CJK>
       (?$(JhS(B . "0x2A466") ; <CJK>
       (?$(JhT(B . "0x2A46F") ; <CJK>
       (?$(JhU(B . "0x2A471") ; <CJK>
       (?$(JhV(B . "0x9EEC") ; <CJK>
       (?$(JhW(B . "0x2A4CF") ; <CJK>
       (?$(JhX(B . "0x2A523") ; <CJK>
       (?$(JhY(B . "0x4D81") ; <CJK>
       (?$(JhZ(B . "0x4D86") ; <CJK>
       (?$(Jh[(B . "0x2A5A5") ; <CJK>
       (?$(Jh\(B . "0x4D8F") ; <CJK>
       (?$(Jh](B . "0x2A5FE") ; <CJK>
       (?$(Jh^(B . "0x2A5FB") ; <CJK>
       (?$(Jh_(B . "0x2A5FD") ; <CJK>
       (?$(Jh`(B . "0x9F68") ; <CJK>
       (?$(Jha(B . "0x4D9B") ; <CJK>
       (?$(Jhb(B . "0x4DB1") ; <CJK>
       (?$(Jhc(B . "0x4DB3") ; <CJK>
       (?$(Jhd(B . "0x2116D") ; <CJK>
       (?$(Jhe(B . "0x373A") ; <CJK>
       (?$(Jhf(B . "0x21B05") ; <CJK>
       (?$(Jhg(B . "0x21C20") ; <CJK>
       (?$(Jhh(B . "0x3827") ; <CJK>
       (?$(Jhi(B . "0x21FC8") ; <CJK>
       (?$(Jhj(B . "0x21FC9") ; <CJK>
       (?$(Jhk(B . "0x386A") ; <CJK>
       (?$(Jhl(B . "0x39AC") ; <CJK>
       (?$(Jhm(B . "0x23127") ; <CJK>
       (?$(Jhn(B . "0x3C18") ; <CJK>
       (?$(Jho(B . "0x2381E") ; <CJK>
       (?$(Jhp(B . "0x23936") ; <CJK>
       (?$(Jhq(B . "0x3C4C") ; <CJK>
       (?$(Jhr(B . "0x2413D") ; <CJK>
       (?$(Jhs(B . "0x3D96") ; <CJK>
       (?$(Jht(B . "0x248D7") ; <CJK>
       (?$(Jhu(B . "0x3F4A") ; <CJK>
       (?$(Jhv(B . "0x24BAD") ; <CJK>
       (?$(Jhw(B . "0x24D00") ; <CJK>
       (?$(Jhx(B . "0x4081") ; <CJK>
       (?$(Jhy(B . "0x2533A") ; <CJK>
       (?$(Jhz(B . "0x4083") ; <CJK>
       (?$(Jh{(B . "0x40F9") ; <CJK>
       (?$(Jh|(B . "0x40F8") ; <CJK>
       (?$(Jh}(B . "0x25726") ; <CJK>
       (?$(Jh~(B . "0x418E") ; <CJK>
       (?$(Ji!(B . "0x418F") ; <CJK>
       (?$(Ji"(B . "0x41C1") ; <CJK>
       (?$(Ji#(B . "0x25DB7") ; <CJK>
       (?$(Ji$(B . "0x25DB6") ; <CJK>
       (?$(Ji%(B . "0x25DC0") ; <CJK>
       (?$(Ji&(B . "0x4270") ; <CJK>
       (?$(Ji'(B . "0x25D9B") ; <CJK>
       (?$(Ji((B . "0x4271") ; <CJK>
       (?$(Ji)(B . "0x261D8") ; <CJK>
       (?$(Ji*(B . "0x432A") ; <CJK>
       (?$(Ji+(B . "0x432D") ; <CJK>
       (?$(Ji,(B . "0x437D") ; <CJK>
       (?$(Ji-(B . "0x8032") ; <CJK>
       (?$(Ji.(B . "0x8031") ; <CJK>
       (?$(Ji/(B . "0x268C0") ; <CJK>
       (?$(Ji0(B . "0x444F") ; <CJK>
       (?$(Ji1(B . "0x268BF") ; <CJK>
       (?$(Ji2(B . "0x26ABF") ; <CJK>
       (?$(Ji3(B . "0x4490") ; <CJK>
       (?$(Ji4(B . "0x27120") ; <CJK>
       (?$(Ji5(B . "0x270D0") ; <CJK>
       (?$(Ji6(B . "0x2710E") ; <CJK>
       (?$(Ji7(B . "0x4579") ; <CJK>
       (?$(Ji8(B . "0x2711D") ; <CJK>
       (?$(Ji9(B . "0x2711E") ; <CJK>
       (?$(Ji:(B . "0x27115") ; <CJK>
       (?$(Ji;(B . "0x27114") ; <CJK>
       (?$(Ji<(B . "0x2751E") ; <CJK>
       (?$(Ji=(B . "0x2752C") ; <CJK>
       (?$(Ji>(B . "0x4605") ; <CJK>
       (?$(Ji?(B . "0x277B9") ; <CJK>
       (?$(Ji@(B . "0x277B8") ; <CJK>
       (?$(JiA(B . "0x277B6") ; <CJK>
       (?$(JiB(B . "0x2789E") ; <CJK>
       (?$(JiC(B . "0x2789C") ; <CJK>
       (?$(JiD(B . "0x2794D") ; <CJK>
       (?$(JiE(B . "0x89FD") ; <CJK>
       (?$(JiF(B . "0x27B6E") ; <CJK>
       (?$(JiG(B . "0x27B60") ; <CJK>
       (?$(JiH(B . "0x4721") ; <CJK>
       (?$(JiI(B . "0x27B64") ; <CJK>
       (?$(JiJ(B . "0x27B62") ; <CJK>
       (?$(JiK(B . "0x261E5") ; <CJK>
       (?$(JiL(B . "0x4732") ; <CJK>
       (?$(JiM(B . "0x27FA3") ; <CJK>
       (?$(JiN(B . "0x47CD") ; <CJK>
       (?$(JiO(B . "0x47CF") ; <CJK>
       (?$(JiP(B . "0x283D2") ; <CJK>
       (?$(JiQ(B . "0x283D5") ; <CJK>
       (?$(JiR(B . "0x908E") ; <CJK>
       (?$(JiS(B . "0x4916") ; <CJK>
       (?$(JiT(B . "0x4915") ; <CJK>
       (?$(JiU(B . "0x49B5") ; <CJK>
       (?$(JiV(B . "0x4A08") ; <CJK>
       (?$(JiW(B . "0x29055") ; <CJK>
       (?$(JiX(B . "0x4A32") ; <CJK>
       (?$(JiY(B . "0x29193") ; <CJK>
       (?$(JiZ(B . "0x4A33") ; <CJK>
       (?$(Ji[(B . "0x4A34") ; <CJK>
       (?$(Ji\(B . "0x4A3C") ; <CJK>
       (?$(Ji](B . "0x29356") ; <CJK>
       (?$(Ji^(B . "0x97C2") ; <CJK>
       (?$(Ji_(B . "0x293E9") ; <CJK>
       (?$(Ji`(B . "0x4A9C") ; <CJK>
       (?$(Jia(B . "0x29445") ; <CJK>
       (?$(Jib(B . "0x4AF4") ; <CJK>
       (?$(Jic(B . "0x4AF2") ; <CJK>
       (?$(Jid(B . "0x2967C") ; <CJK>
       (?$(Jie(B . "0x4B62") ; <CJK>
       (?$(Jif(B . "0x297D3") ; <CJK>
       (?$(Jig(B . "0x4B61") ; <CJK>
       (?$(Jih(B . "0x4B64") ; <CJK>
       (?$(Jii(B . "0x4BB5") ; <CJK>
       (?$(Jij(B . "0x9A4B") ; <CJK>
       (?$(Jik(B . "0x4BB4") ; <CJK>
       (?$(Jil(B . "0x2998E") ; <CJK>
       (?$(Jim(B . "0x29A97") ; <CJK>
       (?$(Jin(B . "0x4BE3") ; <CJK>
       (?$(Jio(B . "0x29A9B") ; <CJK>
       (?$(Jip(B . "0x29A99") ; <CJK>
       (?$(Jiq(B . "0x9B1C") ; <CJK>
       (?$(Jir(B . "0x4C0E") ; <CJK>
       (?$(Jis(B . "0x29BCF") ; <CJK>
       (?$(Jit(B . "0x9B1B") ; <CJK>
       (?$(Jiu(B . "0x29C59") ; <CJK>
       (?$(Jiv(B . "0x4C2C") ; <CJK>
       (?$(Jiw(B . "0x4C2B") ; <CJK>
       (?$(Jix(B . "0x29D20") ; <CJK>
       (?$(Jiy(B . "0x29D23") ; <CJK>
       (?$(Jiz(B . "0x29D2A") ; <CJK>
       (?$(Ji{(B . "0x4C85") ; <CJK>
       (?$(Ji|(B . "0x4C81") ; <CJK>
       (?$(Ji}(B . "0x4C7E") ; <CJK>
       (?$(Ji~(B . "0x4C83") ; <CJK>
       (?$(Jj!(B . "0x4C80") ; <CJK>
       (?$(Jj"(B . "0x29EB0") ; <CJK>
       (?$(Jj#(B . "0x9C42") ; <CJK>
       (?$(Jj$(B . "0x2A12F") ; <CJK>
       (?$(Jj%(B . "0x9DD4") ; <CJK>
       (?$(Jj&(B . "0x4CFB") ; <CJK>
       (?$(Jj'(B . "0x4CF7") ; <CJK>
       (?$(Jj((B . "0x2A132") ; <CJK>
       (?$(Jj)(B . "0x2A143") ; <CJK>
       (?$(Jj*(B . "0x2A13F") ; <CJK>
       (?$(Jj+(B . "0x2A139") ; <CJK>
       (?$(Jj,(B . "0x4CF8") ; <CJK>
       (?$(Jj-(B . "0x2A130") ; <CJK>
       (?$(Jj.(B . "0x2A2DD") ; <CJK>
       (?$(Jj/(B . "0x2A3DA") ; <CJK>
       (?$(Jj0(B . "0x2A3DB") ; <CJK>
       (?$(Jj1(B . "0x4D5A") ; <CJK>
       (?$(Jj2(B . "0x2A484") ; <CJK>
       (?$(Jj3(B . "0x2A47F") ; <CJK>
       (?$(Jj4(B . "0x2A472") ; <CJK>
       (?$(Jj5(B . "0x2A480") ; <CJK>
       (?$(Jj6(B . "0x2A4EE") ; <CJK>
       (?$(Jj7(B . "0x4D78") ; <CJK>
       (?$(Jj8(B . "0x2A52A") ; <CJK>
       (?$(Jj9(B . "0x2A522") ; <CJK>
       (?$(Jj:(B . "0x2A571") ; <CJK>
       (?$(Jj;(B . "0x2A5CD") ; <CJK>
       (?$(Jj<(B . "0x4D9D") ; <CJK>
       (?$(Jj=(B . "0x4D9C") ; <CJK>
       (?$(Jj>(B . "0x2A60F") ; <CJK>
       (?$(Jj?(B . "0x2A618") ; <CJK>
       (?$(Jj@(B . "0x2046A") ; <CJK>
       (?$(JjA(B . "0x34A9") ; <CJK>
       (?$(JjB(B . "0x34BF") ; <CJK>
       (?$(JjC(B . "0x56D0") ; <CJK>
       (?$(JjD(B . "0x56CF") ; <CJK>
       (?$(JjE(B . "0x21B0C") ; <CJK>
       (?$(JjF(B . "0x5DDA") ; <CJK>
       (?$(JjG(B . "0x225A6") ; <CJK>
       (?$(JjH(B . "0x3A77") ; <CJK>
       (?$(JjI(B . "0x3A76") ; <CJK>
       (?$(JjJ(B . "0x23037") ; <CJK>
       (?$(JjK(B . "0x3ABB") ; <CJK>
       (?$(JjL(B . "0x66EA") ; <CJK>
       (?$(JjM(B . "0x23AE2") ; <CJK>
       (?$(JjN(B . "0x3D9B") ; <CJK>
       (?$(JjO(B . "0x244BC") ; <CJK>
       (?$(JjP(B . "0x3E0F") ; <CJK>
       (?$(JjQ(B . "0x3E5B") ; <CJK>
       (?$(JjR(B . "0x24AD5") ; <CJK>
       (?$(JjS(B . "0x3F4C") ; <CJK>
       (?$(JjT(B . "0x3F6F") ; <CJK>
       (?$(JjU(B . "0x3FD9") ; <CJK>
       (?$(JjV(B . "0x24F12") ; <CJK>
       (?$(JjW(B . "0x4082") ; <CJK>
       (?$(JjX(B . "0x2534B") ; <CJK>
       (?$(JjY(B . "0x25341") ; <CJK>
       (?$(JjZ(B . "0x253A1") ; <CJK>
       (?$(Jj[(B . "0x255EC") ; <CJK>
       (?$(Jj\(B . "0x4274") ; <CJK>
       (?$(Jj](B . "0x4272") ; <CJK>
       (?$(Jj^(B . "0x25DD4") ; <CJK>
       (?$(Jj_(B . "0x25DD8") ; <CJK>
       (?$(Jj`(B . "0x25DD9") ; <CJK>
       (?$(Jja(B . "0x4273") ; <CJK>
       (?$(Jjb(B . "0x25DDA") ; <CJK>
       (?$(Jjc(B . "0x25F6C") ; <CJK>
       (?$(Jjd(B . "0x25F6D") ; <CJK>
       (?$(Jje(B . "0x42B1") ; <CJK>
       (?$(Jjf(B . "0x432E") ; <CJK>
       (?$(Jjg(B . "0x261E7") ; <CJK>
       (?$(Jjh(B . "0x261EB") ; <CJK>
       (?$(Jji(B . "0x261EC") ; <CJK>
       (?$(Jjj(B . "0x26262") ; <CJK>
       (?$(Jjk(B . "0x434E") ; <CJK>
       (?$(Jjl(B . "0x2652B") ; <CJK>
       (?$(Jjm(B . "0x2660D") ; <CJK>
       (?$(Jjn(B . "0x268CD") ; <CJK>
       (?$(Jjo(B . "0x26AC3") ; <CJK>
       (?$(Jjp(B . "0x2713F") ; <CJK>
       (?$(Jjq(B . "0x2713C") ; <CJK>
       (?$(Jjr(B . "0x2713E") ; <CJK>
       (?$(Jjs(B . "0x2713D") ; <CJK>
       (?$(Jjt(B . "0x2713A") ; <CJK>
       (?$(Jju(B . "0x27138") ; <CJK>
       (?$(Jjv(B . "0x27544") ; <CJK>
       (?$(Jjw(B . "0x27545") ; <CJK>
       (?$(Jjx(B . "0x460B") ; <CJK>
       (?$(Jjy(B . "0x27548") ; <CJK>
       (?$(Jjz(B . "0x27550") ; <CJK>
       (?$(Jj{(B . "0x466C") ; <CJK>
       (?$(Jj|(B . "0x8B89") ; <CJK>
       (?$(Jj}(B . "0x27B78") ; <CJK>
       (?$(Jj~(B . "0x27B79") ; <CJK>
       (?$(Jk!(B . "0x478B") ; <CJK>
       (?$(Jk"(B . "0x27E3E") ; <CJK>
       (?$(Jk#(B . "0x47D0") ; <CJK>
       (?$(Jk$(B . "0x482D") ; <CJK>
       (?$(Jk%(B . "0x28654") ; <CJK>
       (?$(Jk&(B . "0x48E4") ; <CJK>
       (?$(Jk'(B . "0x4971") ; <CJK>
       (?$(Jk((B . "0x28BB9") ; <CJK>
       (?$(Jk)(B . "0x9458") ; <CJK>
       (?$(Jk*(B . "0x496F") ; <CJK>
       (?$(Jk+(B . "0x2905F") ; <CJK>
       (?$(Jk,(B . "0x4A87") ; <CJK>
       (?$(Jk-(B . "0x4AA5") ; <CJK>
       (?$(Jk.(B . "0x29572") ; <CJK>
       (?$(Jk/(B . "0x29575") ; <CJK>
       (?$(Jk0(B . "0x4B1E") ; <CJK>
       (?$(Jk1(B . "0x4B65") ; <CJK>
       (?$(Jk2(B . "0x4BB9") ; <CJK>
       (?$(Jk3(B . "0x4BB7") ; <CJK>
       (?$(Jk4(B . "0x4BB8") ; <CJK>
       (?$(Jk5(B . "0x4BE4") ; <CJK>
       (?$(Jk6(B . "0x29AA3") ; <CJK>
       (?$(Jk7(B . "0x29AA5") ; <CJK>
       (?$(Jk8(B . "0x29BDC") ; <CJK>
       (?$(Jk9(B . "0x29BDD") ; <CJK>
       (?$(Jk:(B . "0x29C5A") ; <CJK>
       (?$(Jk;(B . "0x4C8C") ; <CJK>
       (?$(Jk<(B . "0x4C89") ; <CJK>
       (?$(Jk=(B . "0x4C8A") ; <CJK>
       (?$(Jk>(B . "0x29EDB") ; <CJK>
       (?$(Jk?(B . "0x29EDC") ; <CJK>
       (?$(Jk@(B . "0x4C8B") ; <CJK>
       (?$(JkA(B . "0x2A1AB") ; <CJK>
       (?$(JkB(B . "0x2A184") ; <CJK>
       (?$(JkC(B . "0x2A176") ; <CJK>
       (?$(JkD(B . "0x4D01") ; <CJK>
       (?$(JkE(B . "0x4CFE") ; <CJK>
       (?$(JkF(B . "0x9DE7") ; <CJK>
       (?$(JkG(B . "0x4D03") ; <CJK>
       (?$(JkH(B . "0x4D06") ; <CJK>
       (?$(JkI(B . "0x2A183") ; <CJK>
       (?$(JkJ(B . "0x9DEA") ; <CJK>
       (?$(JkK(B . "0x9DF1") ; <CJK>
       (?$(JkL(B . "0x2A27F") ; <CJK>
       (?$(JkM(B . "0x4D1D") ; <CJK>
       (?$(JkN(B . "0x4D43") ; <CJK>
       (?$(JkO(B . "0x2A373") ; <CJK>
       (?$(JkP(B . "0x2A3AD") ; <CJK>
       (?$(JkQ(B . "0x2A3B0") ; <CJK>
       (?$(JkR(B . "0x4D4F") ; <CJK>
       (?$(JkS(B . "0x2A40F") ; <CJK>
       (?$(JkT(B . "0x2A40C") ; <CJK>
       (?$(JkU(B . "0x4D5B") ; <CJK>
       (?$(JkV(B . "0x4D70") ; <CJK>
       (?$(JkW(B . "0x2A579") ; <CJK>
       (?$(JkX(B . "0x4D88") ; <CJK>
       (?$(JkY(B . "0x2A577") ; <CJK>
       (?$(JkZ(B . "0x2A57A") ; <CJK>
       (?$(Jk[(B . "0x4D89") ; <CJK>
       (?$(Jk\(B . "0x9F44") ; <CJK>
       (?$(Jk](B . "0x2A632") ; <CJK>
       (?$(Jk^(B . "0x2A627") ; <CJK>
       (?$(Jk_(B . "0x2A62A") ; <CJK>
       (?$(Jk`(B . "0x2A62C") ; <CJK>
       (?$(Jka(B . "0x9F6D") ; <CJK>
       (?$(Jkb(B . "0x2A628") ; <CJK>
       (?$(Jkc(B . "0x2A629") ; <CJK>
       (?$(Jkd(B . "0x2A638") ; <CJK>
       (?$(Jke(B . "0x2082F") ; <CJK>
       (?$(Jkf(B . "0x2117B") ; <CJK>
       (?$(Jkg(B . "0x21B0D") ; <CJK>
       (?$(Jkh(B . "0x5DD9") ; <CJK>
       (?$(Jki(B . "0x21FD6") ; <CJK>
       (?$(Jkj(B . "0x21FD5") ; <CJK>
       (?$(Jkk(B . "0x22EA1") ; <CJK>
       (?$(Jkl(B . "0x2384C") ; <CJK>
       (?$(Jkm(B . "0x3D9E") ; <CJK>
       (?$(Jkn(B . "0x3D9F") ; <CJK>
       (?$(Jko(B . "0x3EA7") ; <CJK>
       (?$(Jkp(B . "0x3F4B") ; <CJK>
       (?$(Jkq(B . "0x3FDB") ; <CJK>
       (?$(Jkr(B . "0x3FDA") ; <CJK>
       (?$(Jks(B . "0x24FC0") ; <CJK>
       (?$(Jkt(B . "0x77D6") ; <CJK>
       (?$(Jku(B . "0x408E") ; <CJK>
       (?$(Jkv(B . "0x4276") ; <CJK>
       (?$(Jkw(B . "0x25DF4") ; <CJK>
       (?$(Jkx(B . "0x4330") ; <CJK>
       (?$(Jky(B . "0x432F") ; <CJK>
       (?$(Jkz(B . "0x261F0") ; <CJK>
       (?$(Jk{(B . "0x4366") ; <CJK>
       (?$(Jk|(B . "0x2633F") ; <CJK>
       (?$(Jk}(B . "0x457E") ; <CJK>
       (?$(Jk~(B . "0x2755D") ; <CJK>
       (?$(Jl!(B . "0x27572") ; <CJK>
       (?$(Jl"(B . "0x27562") ; <CJK>
       (?$(Jl#(B . "0x883A") ; <CJK>
       (?$(Jl$(B . "0x27566") ; <CJK>
       (?$(Jl%(B . "0x8975") ; <CJK>
       (?$(Jl&(B . "0x466F") ; <CJK>
       (?$(Jl'(B . "0x27B88") ; <CJK>
       (?$(Jl((B . "0x47D1") ; <CJK>
       (?$(Jl)(B . "0x482F") ; <CJK>
       (?$(Jl*(B . "0x281E8") ; <CJK>
       (?$(Jl+(B . "0x281E4") ; <CJK>
       (?$(Jl,(B . "0x48B2") ; <CJK>
       (?$(Jl-(B . "0x4918") ; <CJK>
       (?$(Jl.(B . "0x4917") ; <CJK>
       (?$(Jl/(B . "0x288FF") ; <CJK>
       (?$(Jl0(B . "0x4976") ; <CJK>
       (?$(Jl1(B . "0x291AF") ; <CJK>
       (?$(Jl2(B . "0x291AE") ; <CJK>
       (?$(Jl3(B . "0x4A4F") ; <CJK>
       (?$(Jl4(B . "0x4A89") ; <CJK>
       (?$(Jl5(B . "0x293F2") ; <CJK>
       (?$(Jl6(B . "0x29448") ; <CJK>
       (?$(Jl7(B . "0x29581") ; <CJK>
       (?$(Jl8(B . "0x2957E") ; <CJK>
       (?$(Jl9(B . "0x4AF5") ; <CJK>
       (?$(Jl:(B . "0x4B1F") ; <CJK>
       (?$(Jl;(B . "0x29652") ; <CJK>
       (?$(Jl<(B . "0x297EF") ; <CJK>
       (?$(Jl=(B . "0x9A5D") ; <CJK>
       (?$(Jl>(B . "0x4BE5") ; <CJK>
       (?$(Jl?(B . "0x29AAD") ; <CJK>
       (?$(Jl@(B . "0x29BE6") ; <CJK>
       (?$(JlA(B . "0x4C10") ; <CJK>
       (?$(JlB(B . "0x29BED") ; <CJK>
       (?$(JlC(B . "0x4C0F") ; <CJK>
       (?$(JlD(B . "0x29BE9") ; <CJK>
       (?$(JlE(B . "0x29C61") ; <CJK>
       (?$(JlF(B . "0x29C60") ; <CJK>
       (?$(JlG(B . "0x29D33") ; <CJK>
       (?$(JlH(B . "0x4C2F") ; <CJK>
       (?$(JlI(B . "0x4C30") ; <CJK>
       (?$(JlJ(B . "0x9C64") ; <CJK>
       (?$(JlK(B . "0x29F0B") ; <CJK>
       (?$(JlL(B . "0x29F08") ; <CJK>
       (?$(JlM(B . "0x4C93") ; <CJK>
       (?$(JlN(B . "0x4C94") ; <CJK>
       (?$(JlO(B . "0x29F07") ; <CJK>
       (?$(JlP(B . "0x4D07") ; <CJK>
       (?$(JlQ(B . "0x4D09") ; <CJK>
       (?$(JlR(B . "0x4D08") ; <CJK>
       (?$(JlS(B . "0x2A1CA") ; <CJK>
       (?$(JlT(B . "0x4D0B") ; <CJK>
       (?$(JlU(B . "0x2A1C6") ; <CJK>
       (?$(JlV(B . "0x9E0A") ; <CJK>
       (?$(JlW(B . "0x2A284") ; <CJK>
       (?$(JlX(B . "0x2A2EB") ; <CJK>
       (?$(JlY(B . "0x2A37D") ; <CJK>
       (?$(JlZ(B . "0x4D50") ; <CJK>
       (?$(Jl[(B . "0x4D71") ; <CJK>
       (?$(Jl\(B . "0x2A49B") ; <CJK>
       (?$(Jl](B . "0x2A4A2") ; <CJK>
       (?$(Jl^(B . "0x2A4A1") ; <CJK>
       (?$(Jl_(B . "0x2A4A0") ; <CJK>
       (?$(Jl`(B . "0x2A49C") ; <CJK>
       (?$(Jla(B . "0x4D7B") ; <CJK>
       (?$(Jlb(B . "0x4D7C") ; <CJK>
       (?$(Jlc(B . "0x2A580") ; <CJK>
       (?$(Jld(B . "0x9F73") ; <CJK>
       (?$(Jle(B . "0x2A640") ; <CJK>
       (?$(Jlf(B . "0x4DA1") ; <CJK>
       (?$(Jlg(B . "0x2A639") ; <CJK>
       (?$(Jlh(B . "0x2A63C") ; <CJK>
       (?$(Jli(B . "0x4DA0") ; <CJK>
       (?$(Jlj(B . "0x4DA2") ; <CJK>
       (?$(Jlk(B . "0x208CA") ; <CJK>
       (?$(Jll(B . "0x361B") ; <CJK>
       (?$(Jlm(B . "0x21189") ; <CJK>
       (?$(Jln(B . "0x3682") ; <CJK>
       (?$(Jlo(B . "0x2303C") ; <CJK>
       (?$(Jlp(B . "0x23940") ; <CJK>
       (?$(Jlq(B . "0x24163") ; <CJK>
       (?$(Jlr(B . "0x24169") ; <CJK>
       (?$(Jls(B . "0x3FE9") ; <CJK>
       (?$(Jlt(B . "0x25353") ; <CJK>
       (?$(Jlu(B . "0x4084") ; <CJK>
       (?$(Jlv(B . "0x77E1") ; <CJK>
       (?$(Jlw(B . "0x25917") ; <CJK>
       (?$(Jlx(B . "0x2591A") ; <CJK>
       (?$(Jly(B . "0x25E00") ; <CJK>
       (?$(Jlz(B . "0x42B3") ; <CJK>
       (?$(Jl{(B . "0x4334") ; <CJK>
       (?$(Jl|(B . "0x4333") ; <CJK>
       (?$(Jl}(B . "0x4580") ; <CJK>
       (?$(Jl~(B . "0x2756F") ; <CJK>
       (?$(Jm!(B . "0x278AB") ; <CJK>
       (?$(Jm"(B . "0x46AD") ; <CJK>
       (?$(Jm#(B . "0x27B91") ; <CJK>
       (?$(Jm$(B . "0x4744") ; <CJK>
       (?$(Jm%(B . "0x4755") ; <CJK>
       (?$(Jm&(B . "0x27FB1") ; <CJK>
       (?$(Jm'(B . "0x47D2") ; <CJK>
       (?$(Jm((B . "0x281EF") ; <CJK>
       (?$(Jm)(B . "0x28DF1") ; <CJK>
       (?$(Jm*(B . "0x28DF2") ; <CJK>
       (?$(Jm+(B . "0x291B7") ; <CJK>
       (?$(Jm,(B . "0x291B5") ; <CJK>
       (?$(Jm-(B . "0x4A8A") ; <CJK>
       (?$(Jm.(B . "0x29586") ; <CJK>
       (?$(Jm/(B . "0x2965A") ; <CJK>
       (?$(Jm0(B . "0x4B67") ; <CJK>
       (?$(Jm1(B . "0x299C6") ; <CJK>
       (?$(Jm2(B . "0x299CB") ; <CJK>
       (?$(Jm3(B . "0x4BE6") ; <CJK>
       (?$(Jm4(B . "0x29AB2") ; <CJK>
       (?$(Jm5(B . "0x4C13") ; <CJK>
       (?$(Jm6(B . "0x29BF3") ; <CJK>
       (?$(Jm7(B . "0x9B2D") ; <CJK>
       (?$(Jm8(B . "0x29F27") ; <CJK>
       (?$(Jm9(B . "0x4C97") ; <CJK>
       (?$(Jm:(B . "0x9E0C") ; <CJK>
       (?$(Jm;(B . "0x2A1D5") ; <CJK>
       (?$(Jm<(B . "0x2A1D8") ; <CJK>
       (?$(Jm=(B . "0x4D0C") ; <CJK>
       (?$(Jm>(B . "0x2A1EC") ; <CJK>
       (?$(Jm?(B . "0x2A287") ; <CJK>
       (?$(Jm@(B . "0x2A2F2") ; <CJK>
       (?$(JmA(B . "0x4D46") ; <CJK>
       (?$(JmB(B . "0x4D5C") ; <CJK>
       (?$(JmC(B . "0x4D74") ; <CJK>
       (?$(JmD(B . "0x4D72") ; <CJK>
       (?$(JmE(B . "0x2A4AD") ; <CJK>
       (?$(JmF(B . "0x2A4B0") ; <CJK>
       (?$(JmG(B . "0x2A4FD") ; <CJK>
       (?$(JmH(B . "0x9F1F") ; <CJK>
       (?$(JmI(B . "0x2A587") ; <CJK>
       (?$(JmJ(B . "0x2A64A") ; <CJK>
       (?$(JmK(B . "0x4DA4") ; <CJK>
       (?$(JmL(B . "0x4DA3") ; <CJK>
       (?$(JmM(B . "0x2A64E") ; <CJK>
       (?$(JmN(B . "0x2A649") ; <CJK>
       (?$(JmO(B . "0x2A651") ; <CJK>
       (?$(JmP(B . "0x2A64D") ; <CJK>
       (?$(JmQ(B . "0x4DB4") ; <CJK>
       (?$(JmR(B . "0x20472") ; <CJK>
       (?$(JmS(B . "0x3536") ; <CJK>
       (?$(JmT(B . "0x21B16") ; <CJK>
       (?$(JmU(B . "0x2386D") ; <CJK>
       (?$(JmV(B . "0x23941") ; <CJK>
       (?$(JmW(B . "0x3CB2") ; <CJK>
       (?$(JmX(B . "0x24171") ; <CJK>
       (?$(JmY(B . "0x24174") ; <CJK>
       (?$(JmZ(B . "0x3F16") ; <CJK>
       (?$(Jm[(B . "0x7C70") ; <CJK>
       (?$(Jm\(B . "0x4277") ; <CJK>
       (?$(Jm](B . "0x25F7C") ; <CJK>
       (?$(Jm^(B . "0x457F") ; <CJK>
       (?$(Jm_(B . "0x2718A") ; <CJK>
       (?$(Jm`(B . "0x27956") ; <CJK>
       (?$(Jma(B . "0x487D") ; <CJK>
       (?$(Jmb(B . "0x9479") ; <CJK>
       (?$(Jmc(B . "0x28BFA") ; <CJK>
       (?$(Jmd(B . "0x974A") ; <CJK>
       (?$(Jme(B . "0x4A8C") ; <CJK>
       (?$(Jmf(B . "0x2965B") ; <CJK>
       (?$(Jmg(B . "0x4B68") ; <CJK>
       (?$(Jmh(B . "0x4BBE") ; <CJK>
       (?$(Jmi(B . "0x4C15") ; <CJK>
       (?$(Jmj(B . "0x2A1F5") ; <CJK>
       (?$(Jmk(B . "0x2A1F0") ; <CJK>
       (?$(Jml(B . "0x2A2F3") ; <CJK>
       (?$(Jmm(B . "0x2A37F") ; <CJK>
       (?$(Jmn(B . "0x2A413") ; <CJK>
       (?$(Jmo(B . "0x4D75") ; <CJK>
       (?$(Jmp(B . "0x4DA5") ; <CJK>
       (?$(Jmq(B . "0x21B19") ; <CJK>
       (?$(Jmr(B . "0x22985") ; <CJK>
       (?$(Jms(B . "0x22EB0") ; <CJK>
       (?$(Jmt(B . "0x24177") ; <CJK>
       (?$(Jmu(B . "0x255FF") ; <CJK>
       (?$(Jmv(B . "0x4278") ; <CJK>
       (?$(Jmw(B . "0x4335") ; <CJK>
       (?$(Jmx(B . "0x7E9D") ; <CJK>
       (?$(Jmy(B . "0x4582") ; <CJK>
       (?$(Jmz(B . "0x27187") ; <CJK>
       (?$(Jm{(B . "0x4583") ; <CJK>
       (?$(Jm|(B . "0x2718B") ; <CJK>
       (?$(Jm}(B . "0x4671") ; <CJK>
       (?$(Jm~(B . "0x27B9E") ; <CJK>
       (?$(Jn!(B . "0x487E") ; <CJK>
       (?$(Jn"(B . "0x4A8E") ; <CJK>
       (?$(Jn#(B . "0x2958F") ; <CJK>
       (?$(Jn$(B . "0x9960") ; <CJK>
       (?$(Jn%(B . "0x4B69") ; <CJK>
       (?$(Jn&(B . "0x29839") ; <CJK>
       (?$(Jn'(B . "0x299D4") ; <CJK>
       (?$(Jn((B . "0x29AF1") ; <CJK>
       (?$(Jn)(B . "0x29C02") ; <CJK>
       (?$(Jn*(B . "0x29C6B") ; <CJK>
       (?$(Jn+(B . "0x29D40") ; <CJK>
       (?$(Jn,(B . "0x4C9A") ; <CJK>
       (?$(Jn-(B . "0x4C9B") ; <CJK>
       (?$(Jn.(B . "0x2A210") ; <CJK>
       (?$(Jn/(B . "0x2A4BE") ; <CJK>
       (?$(Jn0(B . "0x2A4B9") ; <CJK>
       (?$(Jn1(B . "0x4D90") ; <CJK>
       (?$(Jn2(B . "0x2A664") ; <CJK>
       (?$(Jn3(B . "0x9F9E") ; <CJK>
       (?$(Jn4(B . "0x24AE9") ; <CJK>
       (?$(Jn5(B . "0x27190") ; <CJK>
       (?$(Jn6(B . "0x4586") ; <CJK>
       (?$(Jn7(B . "0x4585") ; <CJK>
       (?$(Jn8(B . "0x2721C") ; <CJK>
       (?$(Jn9(B . "0x460E") ; <CJK>
       (?$(Jn:(B . "0x27592") ; <CJK>
       (?$(Jn;(B . "0x278AE") ; <CJK>
       (?$(Jn<(B . "0x27BA3") ; <CJK>
       (?$(Jn=(B . "0x4919") ; <CJK>
       (?$(Jn>(B . "0x291C9") ; <CJK>
       (?$(Jn?(B . "0x4BC0") ; <CJK>
       (?$(Jn@(B . "0x299D8") ; <CJK>
       (?$(JnA(B . "0x29D44") ; <CJK>
       (?$(JnB(B . "0x2A224") ; <CJK>
       (?$(JnC(B . "0x9EF8") ; <CJK>
       (?$(JnD(B . "0x9F3A") ; <CJK>
       (?$(JnE(B . "0x9F7D") ; <CJK>
       (?$(JnF(B . "0x2A670") ; <CJK>
       (?$(JnG(B . "0x2A6D3") ; <CJK>
       (?$(JnH(B . "0x400D") ; <CJK>
       (?$(JnI(B . "0x4C16") ; <CJK>
       (?$(JnJ(B . "0x2A4C3") ; <CJK>
       (?$(JnK(B . "0x4DA9") ; <CJK>
       (?$(JnL(B . "0x4DAA") ; <CJK>
       (?$(JnM(B . "0x4085") ; <CJK>
       (?$(JnN(B . "0x25E21") ; <CJK>
       (?$(JnO(B . "0x26ACA") ; <CJK>
       (?$(JnP(B . "0x2759C") ; <CJK>
       (?$(JnQ(B . "0x29C73") ; <CJK>
       (?$(JnR(B . "0x2A386") ; <CJK>
       (?$(JnS(B . "0x2A5C1") ; <CJK>
       (?$(JnT(B . "0x29C09") ; <CJK>
       (?$(JnU(B . "0x9F96") ; <CJK>
       (?$(JnV(B . "0x2A6D5") ; <CJK>
       (?$(JnW(B . "0x4BC2") ; <CJK>
       (?$(JnX(B . "0x4C31") ; <CJK>
       (?$(JnY(B . "0x4D11") ; <CJK>
       (?$(JnZ(B . "0x4DAB") ; <CJK>
       (?$(Jn[(B . "0x4C9C") ; <CJK>
       (?$(Jn\(B . "0x291D4") ; <CJK>
       ))))

(provide 'u-cns-4)

;;; u-cns-4.el ends here
 
