/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:	 Mark Allender (allender@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

#include <stdio.h>
#include <X11/X.h>
#include <X11/StringDefs.h>
#include <mbus/api.h>
#include <mbus/keyword.h>
#include "extern.h"
#include "graph.h"
#include "callback.h"
#include "elision.h"

typedef struct {
  char *color_list;
  char *callback_list;
  char *elision_policy;
  Cursor cursor;		/* The cursor to display on this graph */
  Pixel cursor_fg;		/* The foreground color of the cursor */
  Pixel cursor_bg;		/* The background color of the cursor */
} ResourceData, *ResourceData_ptr;

ResourceData data;

static XtResource DefaultResources[] = 
{
  {
    "displaytable", "DisplayTable", XtRString, sizeof (String),
    XtOffset(ResourceData_ptr, color_list), XtRString, NULL
  },
  {
    "callbacktable", "CallbackTable", XtRString, sizeof (String),
    XtOffset(ResourceData_ptr, callback_list), XtRString, NULL
  }, 
  {
    "elisionpolicy", "ElisionPolicy", XtRString, sizeof (String),
    XtOffset(ResourceData_ptr, elision_policy), XtRString, NULL
  },
  {
    "cursor", XtCCursor, XtRCursor, sizeof (Cursor),
    XtOffset (ResourceData_ptr, cursor), XtRString, "left_ptr"
  },
  {
    "cursor-foreground", XtCForeground, XtRPixel, sizeof (Pixel),
    XtOffset (ResourceData_ptr, cursor_fg), XtRString, XtDefaultForeground
  },
  {
    "cursor-background", XtCBackground, XtRPixel, sizeof (Pixel),
    XtOffset (ResourceData_ptr, cursor_bg), XtRString, XtDefaultBackground
  }
};

extern Widget toplevel_widget;
 
/*
 *  GetDefaultResources will get the application default resources
 *  for the browser.  This is only done once, at the start of the prgram.
 *  This will set up the color tables, and callback stuff.
*/
void
GetResources(widget)
     Widget widget;
{
  char *type;
  short etype;
  struct mb_object *sexp_table;
  XColor color[2];
  Colormap color_map;
  Arg args[10];  

  XtGetApplicationResources(widget, &data, DefaultResources,
			    XtNumber(DefaultResources), NULL, 0);
  
/*
 *  Check the color list and see if there were some application
 *  defaults that need to be added into the list.  We must also check
 *  to see if the widget for which we are grabbing resources is the
 *  toplevel widget, cause if so, we put the resource in a different
 *  place.
*/
  if (data.color_list != NULL) {
    sexp_table = MBparse_Cstring(data.color_list);
    if (widget == toplevel_widget)
      ParseDisplayTable(sexp_table,
		      &(BrowserDisplays->common),
		      &(BrowserDisplays->nodes),
		      &(BrowserDisplays->edges), TRUE, FALSE);
    else
      ParseDisplayTable(sexp_table,
		      &(graph->display_table->common),
		      &(graph->display_table->nodes),
		      &(graph->display_table->edges), TRUE, FALSE);
  }

		      
/*
 *  See if the callback list has something in it. If it does, then parse
 *  the list, and put it in the approiate place.
*/
  if (data.callback_list != NULL) {
    sexp_table = MBparse_Cstring(data.callback_list);
    if (widget == toplevel_widget)
      ParseCallbacks(sexp_table, &CallbackKeys, &CallbackFunctions, TRUE);
    else
      ParseCallbacks(sexp_table, &(graph->callback_keys),
		     &(graph->callback_functions), TRUE);

  }
/*
 *  Now check on the elision type that is going to be used.  There are
 *  several different types.  See elision.h for a definition of the
 *  types.
*/
#if 0
  type = data.elision_policy;
  if (type != NULL) {

/*
 *  Decide on the type of elision that the user has decided on.
*/

    if (!strcmp(type, "inbound-edge"))
      etype = INBOUND_TO_SN;
    else if (!strcmp(type, "inbound-edge-and-node"))
      etype = INBOUND_AND_NODE;
    else if (!strcmp(type, "outbound-edge"))
      etype = OUTBOUND_TO_SN;
    else if (!strcmp(type, "outbound-edge-and-node"))
      etype = OUTBOUND_AND_NODE;
    else if (!strcmp(type,"super-node"))
      etype = SUPER_NODE;
    else
      etype = REMOVE_ALL;
/*
 *  Now, assign this to the correct location
*/

    if (widget == toplevel_widget)
      ElisionPolicy = etype;
    else
      graph->elision_policy = etype;
  }
#endif
/* Set up the cursor */
  XtSetArg(args[0], XtNcolormap, &color_map);
  XtGetValues (widget, args, 1);
  color[0].pixel = data.cursor_fg;
  color[1].pixel = data.cursor_bg;
  XQueryColors (XtDisplay(widget), color_map, color, 2);
  XRecolorCursor (XtDisplay(widget), data.cursor, &color[0], &color[1]);
  XDefineCursor (XtDisplay(widget), XtWindow(widget), data.cursor);
}

