/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	keyword.c: Keyword parsing package */
/* widget server utilities */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/lib/RCS/keyword.c,v $ */

static char rcsid[] = "MBkeyword.c $Revision: 2.1.1.1 $ $Date: 91/11/15 13:35:25 $ $State: Exp $ $Author: carroll $";

/* ------------------------------------------------------------------------ */
#include <stdio.h>

#include "api.h"
#include "mbus.h"
#include "keyword.h"

#define NULLP(x) (NULL == (x) || ((MB_NAMEP((x)) && !MBcompare_Cstring((x), "nil"))))
/* ------------------------------------------------------------------------ */
/* Not everybody has strdup() (unbelievable, huh?) */
char *
MBstrdup(s) char *s;
{
  char *new;
  if (NULL == s) return NULL;
  new = (char *)MBmalloc_func(strlen(s)+1);
  strcpy(new,s);
  return new;
}
/* ------------------------------------------------------------------------ */
void
MBparse_keywords(sexp, table, count)
     t_sexp sexp;
     t_keyword_entry table;
     int count;
{
  int i;
  t_sexp keyword, target, tmp;

  /* clear flags */
  for ( i = 0 ; i < count ; ++i ) table[i].found = 0;

  /* now go through the sexp, dealing with each keyword */
  for ( ; MB_CONSP(sexp) ; sexp = MBnthcdr(sexp,2))
    {
      /* Get the putative key, and verify that it looks right */
      keyword = MB_CAR(sexp);
      if (! MB_NAMEP(keyword)) continue;

      /* Get the alledged key value and do basic checks */
      target = MBnth(sexp, 1);
      if (NULL == target) break;	/* nothing left, leave */

      /* see if the keyword is in the table */
      for ( i = 0 ; i < count ; ++i )
	{
	  if (table[i].found) continue;	/* already found */
	  if (!MBcompare_Cstring(keyword,table[i].keyword))
	    {
	      table[i].found = 1;
	      switch (table[i].type)
		{
		case KEYWORD_SEXP:
		  table[i].result = (void *) target;
		  break;
		case KEYWORD_GET_SEXP:
		  table[i].result = (void *) MBduplicate(target);
		  break;
		case KEYWORD_RAW:
		  tmp = MBprint(target, NULL);
		  table[i].result = (void *) MBCstring(tmp);
		  MBfree(tmp);
		  break;
		case KEYWORD_COOKED:
		  table[i].result = (void *) MBCstring(target);
		  break;
		case KEYWORD_FLAG:
		  table[i].result =
		    (void *)(NULLP(target) ? KEYWORD_FALSE : KEYWORD_TRUE);
		  break;
		case KEYWORD_INT:
		  {
		    char *str, *tmp;
		    long n;

		    str = MBCstring(target);
		    if (NULL == str || *str == '\0')
		      table[i].result = table[i].value;
		    else
		      {
			n = strtol(str, &tmp, 0);
			if (tmp == str) table[i].result = table[i].value;
			else table[i].result = (void *)n;
		      }
		    MBfree_func(str);
		  }
		  break;
		}
	    }
	}
    }

  /* set defaults for those not found */
  for ( i = 0 ; i < count ; ++i )
    {
      if (!table[i].found)
	switch (table[i].type)
	  {
	  case KEYWORD_COOKED:
	  case KEYWORD_RAW:
	    table[i].result = (void *) MBstrdup((char *) table[i].value);
	    break;
	  case KEYWORD_INT:
	  case KEYWORD_SEXP:
	  case KEYWORD_FLAG:
	    table[i].result = table[i].value;
	    break;
	  case KEYWORD_GET_SEXP:
	    table[i].result = (void *)MBduplicate((t_sexp) table[i].value);
	    break;
	  }
    }
}
  
/* ------------------------------------------------------------------------ */
int
MBkeywordp(e) t_sexp e;
{
  return MB_NAMEP(e) && ':' == MBpeek_char(e);
}
/* ------------------------------------------------------------------------ */
