/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *	Modified: Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server header file */

/* ------------------------------------------------------------------------ */
#include <stdio.h>
#include "config.h"
/* ------------------------------------------------------------------------ */
/* The various Motif includes that we need */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <X11/Shell.h>

/* ------------------------------------------------------------------------ */
/* basic system includes */
#ifdef USE_STRINGS_H
#include <strings.h>
#define strchr index
#else
#include <string.h>
#endif

/* ------------------------------------------------------------------------ */
/* MBus includes */

#if 0
#include <mbus/mbus.h>
#include <mbus/extern.h>
#include <mbus/api.h>
#else
#include "mbus/api.h"
#include "mbus/mbus.h"
#include "mbus/keyword.h"
#endif

/* ------------------------------------------------------------------------ */
#include "ws.h"
/* ------------------------------------------------------------------------ */
/* Global Variables */

extern int MBLogLevel;

extern t_mb_connection mbus;	/* connection to the MBus */

extern Widget toplevel_widget;		/* anchor widget */
extern Widget control_panel;		/* the control panel for the WS */
extern t_generic_widget toplevel_shells;

extern Atom xa_cb_editable;
extern Atom xa_cb_terminate;
extern Atom xa_cb_dropchild;	/* For when an area drops the child (splat) */
extern Atom xa_cb_true;
extern Atom xa_cb_false;
extern Atom xa_wm_delete_window;
/* ------------------------------------------------------------------------ */
/* functions */

#ifdef __STDC__
extern t_mbus_reply ParseReplyList(t_sexp);
#else
extern t_mbus_reply ParseReplyList();
#endif

extern char * strdup();
extern XmString CtoXmString();
extern char * QuotifyString();
extern t_sexp Getnth();

extern char * PrintSexp();
extern char * ChunkToString();
extern char * ContextString();
extern Widget CreatePushButton();
extern Widget CreateSubmenuButton();
extern Widget CreateTitle();

extern t_generic_widget MakeShell();
extern t_generic_widget MakeField();
extern t_generic_widget HandleBusItem();
extern t_generic_widget FindToplevelShellID();

extern void UpdateWidgetList();
extern void RemoveWidgetList();
extern int ManageWidgetList();		/* returns number of widgets in */

extern void GenericReply();
extern void ReplyCallback();
extern t_mbus_reply NewReply();
extern void FreeReply();
extern void SendReply();
extern t_generic_widget RemoveChildFromList();
/* ------------------------------------------------------------------------ */
