/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	popup.c: Create Motif popups of various sorts. */
/* widget server popup support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node117.text,v $ */

static char rcsid[] = "popup.c $Revision: 1.0 $ $Date: 92/03/16 08:38:30 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
/* ------------------------------------------------------------------------ */
PopupDeleteCallback(w, widget, data)
     Widget w;
     Widget widget;
     caddr_t data;
{
  XtDestroyWidget(widget);
}
/* ------------------------------------------------------------------------ */
PopupMapCallback(w, stuff, data)
     Widget w;
     caddr_t stuff;
     caddr_t data;
{
  WidgetAtMouse(w);
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct popupKW[] =
{
  { ":popup-for", NULL, KEYWORD_SEXP },
  { ":label", NULL, KEYWORD_COOKED },
};

Widget
CreatePopupBox(sexp, type)
     t_sexp sexp;
     t_popup_box_type type;
{
  t_sexp s_str, s_popup_for;
  XmString xm_str, xm_label;
  char *str, *label;
  int n;
  Widget popup, w;
  Arg argl[3];
  Widget w_parent = toplevel_widget;
  t_generic_widget sw;

  s_str = MBnth(sexp,1);
  if (!MB_NAMEP(s_str) && !MB_STRINGP(s_str)) return;

  n = 0;
  MBparse_keywords(MBnthcdr(sexp,2), popupKW, ARRAY_SIZE(popupKW));
  s_popup_for = (t_sexp)popupKW[n++].result;
  label = (char *)popupKW[n++].result;

  str = MBCstring(s_str);
  xm_str = CtoXmString(str);
  xm_label = CtoXmString(NULL == label ? "Done" : label);

  if (NULL != s_popup_for && NULL != (sw = FindToplevelShellID(s_popup_for)))
    w_parent = sw->widget;

  n = 0;
  XtSetArg(argl[n], XmNmessageString, xm_str), ++n;
  XtSetArg(argl[n], XmNokLabelString, xm_label), ++n;
  XtSetArg(argl[n], XmNdefaultPosition, False), ++n;
  switch (type)
    {
    case POPUP_WARNING:
      popup = XmCreateWarningDialog(w_parent, "CB Warning", argl, n);
      XtVaSetValues(XtParent(popup), XmNtitle, "CB Warning", NULL);
      break;
    case POPUP_MESSAGE:
      popup = XmCreateMessageDialog(w_parent, "CB Message", argl, n);
      XtVaSetValues(XtParent(popup), XmNtitle, "CB Message", NULL);
      break;
    case POPUP_ERROR:
      popup = XmCreateErrorDialog(w_parent, "CB Error", argl, n);
      XtVaSetValues(XtParent(popup), XmNtitle, "CB Error", NULL);
      break;
    default: return NULL;		/* bad type, cancel operation */
    }

  XtVaSetValues(XtParent(popup), XmNdeleteResponse, XmDESTROY, NULL);
  XtAddCallback(popup, XmNmapCallback, PopupMapCallback, NULL);
  XtAddCallback(popup, XmNokCallback, PopupDeleteCallback, XtParent(popup));

  /* Let's turn off some buttons */
  w = XmMessageBoxGetChild(popup, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(w);
  w = XmMessageBoxGetChild(popup, XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(w);

  XtFree(xm_str); XtFree(str); XtFree(xm_label); XtFree(label);
  XtRealizeWidget(popup);
  return popup;
}
/* ------------------------------------------------------------------------ */
Widget
PopupWarning(sexp) t_sexp sexp;
{
  return CreatePopupBox(sexp, POPUP_WARNING);
}
/* ------------------------------------------------------------------------ */
static XmString ErrorOkLabel = NULL;
Widget
PopupError(sexp) t_sexp sexp;
{
  return CreatePopupBox(sexp, POPUP_ERROR);
}
/* ------------------------------------------------------------------------ */
/* Popup message - format is (message "message") */
static XmString MessageOkLabel = NULL;
Widget
PopupMessage(sexp) t_sexp sexp;
{
  return CreatePopupBox(sexp, POPUP_MESSAGE);
}
/* ------------------------------------------------------------------------ */
/* Format is (info "id" "message" [ "item" ... ]) */

static XmString InfoOkLabel = NULL;

Widget
PopupInfo(sexp) t_sexp sexp;
{
  t_sexp s_message;
  char *message;
  int n=0;
  Widget popup, box, w, rc, form;
  Arg argl[8];

  s_message = MBnth(sexp,2);
  if (!MB_NAMEP(s_message) && !MB_STRINGP(s_message)) return NULL;

  if (NULL == InfoOkLabel) InfoOkLabel = CtoXmString("Done");

  message = MBCstring(s_message);

  n = 0;
  XtSetArg(argl[n], XmNallowShellResize, True), ++n;
  XtSetArg(argl[n], XmNtitle, "CB Info"), ++n;
  XtSetArg(argl[n], XmNdefaultPosition, False), ++n;
  popup = XmCreateDialogShell(toplevel_widget, "info", argl, n);

  n = 0;
  XtSetArg(argl[n], XmNdefaultPosition, False), ++n;
  form = XtCreateWidget("form", xmFormWidgetClass, popup, argl, n);

  n = 0;
  XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
  XtSetArg(argl[n], XmNorientation, XmVERTICAL), ++n;
  XtSetArg(argl[n], XmNresizeHeight, True), ++n;
  XtSetArg(argl[n], XmNresizeWidth, True), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  rc = XtCreateWidget("labels", xmRowColumnWidgetClass, form, argl, n);

  /* title and separator time */
  w = CreateTitle(message, rc);
  XtManageChild(w);
  w = XtCreateWidget("separator", xmSeparatorGadgetClass, rc, NULL, 0);
  XtManageChild(w);

  for ( sexp = MBnthcdr(sexp, 3) ; MB_CONSP(sexp) ; sexp = MB_CDR(sexp) )
    {
      t_sexp item;
      char * str;

      item = MB_CAR(sexp);
      if (MB_STRINGP(item))
	{
	  str = MBCstring(item);
	  w = CreateTitle(str, rc);
	  if (NULL != w) XtManageChild(w);
	  XtFree(str);
	}
    }

  n = 0;
  XtSetArg(argl[n], XmNdialogType, XmDIALOG_INFORMATION), ++n;
  XtSetArg(argl[n], XmNdefaultButtonType, XmDIALOG_OK_BUTTON), ++n;
  XtSetArg(argl[n], XmNokLabelString, InfoOkLabel), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNbottomAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNtopAttachment, XmATTACH_WIDGET), ++n;
  XtSetArg(argl[n], XmNtopWidget, rc), ++n;
  box = XtCreateWidget("box", xmMessageBoxWidgetClass, form, argl, n);
  XtUnmanageChild(XmMessageBoxGetChild(box, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(box, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(box, XmDIALOG_MESSAGE_LABEL));
/*
  XtUnmanageChild(XmMessageBoxGetChild(box, XmDIALOG_SEPARATOR));
*/
  XtUnmanageChild(XmMessageBoxGetChild(box, XmDIALOG_SYMBOL_LABEL));

  XtAddCallback(box, XmNokCallback, PopupDeleteCallback, popup);
  XtAddCallback(popup, XmNpopupCallback, PopupMapCallback, NULL);
  XtManageChild(box);
  XtManageChild(form);
  XtRealizeWidget(popup);

  XtFree(message);

  return rc;
}
/* ------------------------------------------------------------------------ */
