/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.ProxyListIterator;

public class FilterListIterator
extends ProxyListIterator {
    private Predicate predicate;
    private Object nextObject;
    private boolean nextObjectSet = false;
    private Object previousObject;
    private boolean previousObjectSet = false;
    private int nextIndex = 0;

    public FilterListIterator() {
    }

    public FilterListIterator(ListIterator listIterator) {
        super(listIterator);
    }

    public FilterListIterator(ListIterator listIterator, Predicate predicate) {
        super(listIterator);
        this.predicate = predicate;
    }

    public FilterListIterator(Predicate predicate) {
        this.predicate = predicate;
    }

    public void add(Object object) {
        throw new UnsupportedOperationException("FilterListIterator.add(Object) is not supported.");
    }

    private void clearNextObject() {
        this.nextObject = null;
        this.nextObjectSet = false;
    }

    private void clearPreviousObject() {
        this.previousObject = null;
        this.previousObjectSet = false;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    public boolean hasPrevious() {
        if (this.previousObjectSet) {
            return true;
        }
        return this.setPreviousObject();
    }

    public Object next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        ++this.nextIndex;
        Object object = this.nextObject;
        this.clearNextObject();
        return object;
    }

    public int nextIndex() {
        return this.nextIndex;
    }

    public Object previous() {
        if (!this.previousObjectSet && !this.setPreviousObject()) {
            throw new NoSuchElementException();
        }
        --this.nextIndex;
        Object object = this.previousObject;
        this.clearPreviousObject();
        return object;
    }

    public int previousIndex() {
        return this.nextIndex - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException("FilterListIterator.remove() is not supported.");
    }

    public void set(Object object) {
        throw new UnsupportedOperationException("FilterListIterator.set(Object) is not supported.");
    }

    private boolean setNextObject() {
        ListIterator listIterator = this.getListIterator();
        Predicate predicate = this.getPredicate();
        if (this.previousObjectSet) {
            this.clearPreviousObject();
            if (!this.setNextObject()) {
                return false;
            }
            this.clearNextObject();
        }
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!predicate.evaluate(e)) continue;
            this.nextObject = e;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    private boolean setPreviousObject() {
        ListIterator listIterator = this.getListIterator();
        Predicate predicate = this.getPredicate();
        if (this.nextObjectSet) {
            this.clearNextObject();
            if (!this.setPreviousObject()) {
                return false;
            }
            this.clearPreviousObject();
        }
        while (listIterator.hasPrevious()) {
            Object e = listIterator.previous();
            if (!predicate.evaluate(e)) continue;
            this.previousObject = e;
            this.previousObjectSet = true;
            return true;
        }
        return false;
    }
}

