/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jde.util.DynamicClassLoader;

public class Completion {
    public static void isAncestorOf(String ancestor, String child) {
        try {
            Class<?> classAncestor = Class.forName(ancestor);
            Class<?> classChild = Class.forName(child);
            if (classAncestor.isAssignableFrom(classChild)) {
                System.out.println("t");
            } else {
                System.out.println("nil");
            }
        }
        catch (Exception ex) {
            System.out.println("nil");
        }
    }

    private static boolean isAccessible(Member member, int level) {
        switch (level) {
            case 0: {
                return Modifier.isProtected(member.getModifiers());
            }
            case 1: {
                return Modifier.isPrivate(member.getModifiers()) || Modifier.isProtected(member.getModifiers());
            }
        }
        return false;
    }

    private static boolean isAccessible(Class cls, int level) {
        switch (level) {
            case 0: {
                return Modifier.isProtected(cls.getModifiers());
            }
            case 1: {
                return Modifier.isPrivate(cls.getModifiers()) || Modifier.isProtected(cls.getModifiers());
            }
        }
        return false;
    }

    private static void listClassInfo(Class c, int level) {
        System.out.println("(list ");
        System.out.print("(list ");
        Field[] fields = c.getFields();
        int index = 0;
        while (index < fields.length) {
            Field field = fields[index];
            System.out.print("(list \"" + field.getName() + "\" \"" + Completion.className(field.getType()) + "\")");
            ++index;
        }
        fields = c.getDeclaredFields();
        int index2 = 0;
        while (index2 < fields.length) {
            Field field = fields[index2];
            if (Completion.isAccessible(field, level)) {
                System.out.print("(list \"" + field.getName() + "\" \"" + Completion.className(field.getType()) + "\")");
            }
            ++index2;
        }
        System.out.println(")");
        System.out.print("(list ");
        Constructor<?>[] constrs = c.getConstructors();
        int index3 = 0;
        while (index3 < constrs.length) {
            Constructor<?> constructor = constrs[index3];
            System.out.print("(list \"");
            System.out.print(constructor.getName() + "\" ");
            Completion.listClassArray(constructor.getParameterTypes());
            System.out.print(")");
            ++index3;
        }
        constrs = c.getDeclaredConstructors();
        int index4 = 0;
        while (index4 < constrs.length) {
            Constructor<?> constructor = constrs[index4];
            if (Completion.isAccessible(constructor, level)) {
                System.out.print("(list \"");
                System.out.print(constructor.getName() + "\" ");
                Completion.listClassArray(constructor.getParameterTypes());
                System.out.print(")");
            }
            ++index4;
        }
        System.out.print(")");
        System.out.println("(list ");
        Method[] methods = c.getMethods();
        int index5 = 0;
        while (index5 < methods.length) {
            Method method = methods[index5];
            System.out.print("(list \"");
            System.out.print(method.getName() + "\" \"");
            System.out.print(Completion.className(method.getReturnType()) + "\" ");
            Completion.listClassArray(method.getParameterTypes());
            System.out.print(")");
            ++index5;
        }
        methods = c.getDeclaredMethods();
        int index6 = 0;
        while (index6 < methods.length) {
            Method method = methods[index6];
            if (Completion.isAccessible(method, level)) {
                System.out.print("(list \"");
                System.out.print(method.getName() + "\" \"");
                System.out.print(Completion.className(method.getReturnType()) + "\" ");
                Completion.listClassArray(method.getParameterTypes());
                System.out.print(")");
            }
            ++index6;
        }
        System.out.println(")");
        Class<?>[] classes = c.getDeclaredClasses();
        System.out.println("(list ");
        int length = classes.length;
        int i = 0;
        while (i < length) {
            Class<?> cls = classes[i];
            if (Completion.isAccessible(cls, level)) {
                System.out.print("(list \"");
                System.out.print(cls.getName() + "\"");
                System.out.print(")");
            }
            ++i;
        }
        System.out.println(")");
        System.out.println(")");
    }

    private static void listClassInfo(Class c) {
        System.out.println("(list ");
        Field[] fields = c.getFields();
        System.out.print("(list ");
        int index = 0;
        while (index < fields.length) {
            Field field = fields[index];
            if (Modifier.isPublic(field.getModifiers())) {
                System.out.print("(list \"" + field.getName() + "\" \"" + Completion.className(field.getType()) + "\")");
            }
            ++index;
        }
        System.out.println(")");
        Constructor<?>[] constrs = c.getDeclaredConstructors();
        System.out.print("(list ");
        int index2 = 0;
        while (index2 < constrs.length) {
            Constructor<?> constructor = constrs[index2];
            if (Modifier.isPublic(constructor.getModifiers())) {
                System.out.print("(list \"");
                System.out.print(constructor.getName() + "\" ");
                Completion.listClassArray(constructor.getParameterTypes());
                System.out.print(")");
            }
            ++index2;
        }
        System.out.print(")");
        Method[] methods = c.getMethods();
        System.out.println("(list ");
        int index3 = 0;
        while (index3 < methods.length) {
            Method method = methods[index3];
            if (Modifier.isPublic(method.getModifiers())) {
                System.out.print("(list \"");
                System.out.print(method.getName() + "\" \"");
                System.out.print(Completion.className(method.getReturnType()) + "\" ");
                Completion.listClassArray(method.getParameterTypes());
                System.out.print(")");
            }
            ++index3;
        }
        System.out.println(")");
        Class<?>[] classes = c.getDeclaredClasses();
        System.out.println("(list ");
        int length = classes.length;
        int i = 0;
        while (i < length) {
            Class<?> cls = classes[i];
            if (Modifier.isPublic(cls.getModifiers())) {
                System.out.print("(list \"");
                System.out.print(cls.getName() + "\"");
                System.out.print(")");
            }
            ++i;
        }
        System.out.println(")");
        System.out.println(")");
    }

    public static void getClassInfo(String className) {
        try {
            DynamicClassLoader dcl = new DynamicClassLoader();
            Class c = dcl.loadClass(className);
            if (c != null) {
                Completion.listClassInfo(c);
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("nil");
        }
    }

    public static void getClassInfo(String className, int accessLevel) {
        try {
            DynamicClassLoader dcl = new DynamicClassLoader();
            Class c = dcl.loadClass(className);
            if (c != null) {
                Completion.listClassInfo(c, accessLevel);
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("nil");
        }
    }

    public static void getClassInfo(String className, String[] imports, int accessLevel) {
        int i = 0;
        while (i < imports.length) {
            String name = imports[i] + className;
            try {
                Class<?> c = Class.forName(name);
                if (c != null) {
                    Completion.listClassInfo(c, accessLevel);
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            ++i;
        }
        System.out.println("nil");
    }

    static String className(Class c) {
        if (c.isArray()) {
            return c.getComponentType().getName() + "[]";
        }
        return c.getName();
    }

    static void listClassArray(Class[] classes) {
        int i = 0;
        while (i < classes.length) {
            System.out.print("\"");
            System.out.print(Completion.className(classes[i]));
            System.out.print("\" ");
            ++i;
        }
    }
}

