/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import jde.wizards.DefaultNameFactory;
import jde.wizards.InterfaceFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.NotAnAbstractClassException;
import jde.wizards.Signature;

public class AbstractClassFactory
extends InterfaceFactory {
    static AbstractClassFactory abstractClassFactory;

    public AbstractClassFactory() {
    }

    public AbstractClassFactory(NameFactory factory) {
        super(factory);
    }

    public void process(String argAbstracClassName) throws ClassNotFoundException, NotAnAbstractClassException {
        this.process(argAbstracClassName, true);
    }

    public void process(String name, boolean truncate) throws ClassNotFoundException, NotAnAbstractClassException {
        Class<?> aclass;
        int iModifiers;
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        if (!Modifier.isAbstract(iModifiers = (aclass = Class.forName(name)).getModifiers())) {
            throw new NotAnAbstractClassException(name);
        }
        Object[] methods = this.getAbstractMethods(aclass);
        int i = 0;
        while (i < methods.length) {
            this.sortByDeclaringClass(new Signature((Method)methods[i], this, truncate));
            ++i;
        }
    }

    private Object[] getAbstractMethods(Class argClass) {
        Method[] methods = argClass.getMethods();
        Vector<Method> abstractMethods = new Vector<Method>();
        int i = 0;
        boolean j = false;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isAbstract(method.getModifiers())) {
                abstractMethods.add(method);
            }
            ++i;
        }
        return abstractMethods.toArray();
    }

    public static void getImportedClasses() {
        String res = "(list ";
        Enumeration i = AbstractClassFactory.abstractClassFactory.imports.keys();
        while (i.hasMoreElements()) {
            Class c = (Class)i.nextElement();
            res = res + "\"" + c.getName() + "\" ";
        }
        res = res + ")";
        MethodFactory.println(res);
    }

    public static void makeAbstractClass(String name, boolean javadoc, boolean truncate, boolean newline) {
        if (abstractClassFactory == null) {
            abstractClassFactory = new AbstractClassFactory();
        }
        abstractClassFactory.flush();
        abstractClassFactory.makeAbstractClassInternal(name, javadoc, truncate, newline);
    }

    private void makeAbstractClassInternal(String name, boolean javadoc, boolean truncate, boolean newline) {
        try {
            this.process(name, truncate);
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find abstract class named: " + name + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (NotAnAbstractClassException e) {
            MethodFactory.println("(error \"Error: " + name + " is not an abstract class.\")");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dump(new PrintWriter(System.out, true), javadoc, truncate, newline);
    }
}

