;;; $Author: CBmgr $
;;; $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node64.text,v $
;;; $Date: 92/03/16 08:19:22 $
;;; $Revision: 1.0 $
;;; $Locker:  $
;;; This file is part of the
;;;
;;;      Delta Project  (ConversationBuilder)
;;;      Human-Computer Interaction Laboratory
;;;      University of Illinois at Urbana-Champaign
;;;      Department of Computer Science
;;;      1304 W. Springfield Avenue
;;;      Urbana, Illinois 61801
;;;      USA
;;;
;;;      c 1989,1990,1991 Board of Trustees
;;;              University of Illinois
;;;              All Rights Reserved
;;;
;;;      This file is distributed under license and is confidential
;;;
;;;      Author:  Simon Kaplan (kaplan@cs.uiuc.edu)
;;;               Alan Carroll (carroll@cs.uiuc.edu)
;;;
;;;      Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
;;;      Direct enquiries to the project leader please.
;;;

(require 'cl)
;;;
;;; ---------------------------------------------------------------------------
;;; Basic engine state variables.
;;; This set is for configuring the system 

;;; ------------------------------------------------------------------------
;;;

;;;
;;;
;;; --------------------------------------------------------------------------
;;; This is all wrong, but I haven't gotten around to changing it yet:

;;; The dispatcher. This is the heart of it all. The dispatcher reads the
;;; engine output stream looking for S-expressions or the terminator string,
;;; starting on a line. When an S-expression is found, the car is used as
;;; a key into the dispatch table (passes as an argument). The table is an
;;; alist of (key . function) pairs. The function is called with the (cdr) of
;;; the S-expression. S-expressions with a car of 'dispatch are handled
;;; internally by the dispatcher.
;;;
;;; The dispatcher can be called recursively from the handler functions.
;;; The caller should pass in a dispatch table to be used. The dispatcher
;;; will run until either the terminator string is seen or the dispatcher is
;;; given the argument of "return". When the dispatcher returns it returns a
;;; list of ( after-hooks values ) where after-hooks is a hook variable with
;;; hooks that should be run after the current handler finishes. Values is
;;; an alist, generated by handlers called in the recursive dispatch.

(defmacro with-mbus-open (&rest body)
  (`
    (if (mbus:bus-open-p mbus:*server*)
      (progn (,@ body))
      (message "No connection to bus")
)))

(defun mbus:open ()
  (when (not (mbus:bus-open-p mbus:*server*))
    (setq mbus:*server*
      (mbus:bus-open mbus:*server-name* mbus:*server-buffer*
	mbus:*host* mbus:*port* mbus:*xa-dispatch*
  )))
  ;; Try to clean stuff up - there shouldn't be any other dispatchers for
  ;; this property.
  (resume-property mbus:*xa-dispatch*)
  (pop-property mbus:*xa-dispatch*)
  (pop-property mbus:*xa-dispatch*)
  (push-property mbus:*xa-dispatch* 'mbus:run-dispatcher)
)

(defun mbus:close ()
  (delete-process mbus:*server*)
)
;;; -------------------------------------------------------------------------

(defmacro mbus-dispatch-after (hook)
  (` (push (, hook) *MBUS-DISPATCH-AFTER-HOOKS*))
)

(defmacro mbus-dispatch-value (key value)
  (` (push (cons (, key) (, value)) *MBUS-DISPATCH-VALUES*))
)

(defmacro mbus-dispatch-get-value (key)
  (` (assq (, key) *MBUS-DISPATCH-VALUES*))
)

(defun mbus-dispatch-push-value (key value)
  (let ((data (assq key *MBUS-DISPATCH-VALUES*)))
    (if data
      (setcdr data (cons value (cdr data)))
      (push (list key value) *MBUS-DISPATCH-VALUES*)
)))

(defun mbus-run-after-hooks (return)

  "Run the after hooks with the dispatch values as given by RETURN,
the value returned by the call to (mbus-dispatch). Each after hook is
passed a single argument, the dispatch values alist."

  (let
    (
      (hooks (car return))
      (values (cadr return))
    )
    (mapcar (function (lambda (func) (funcall func values))) hooks)
))

(defmacro mbus-set-dispatch (key func list)
  (`
    (setq (, list)
      (cons
	(cons (, key) (, func))
	(alist-delete (, key) (, list))
))))

;;;
;;; Internal stuff
;;;

(defun mbus:dispatch-log (s)
  (save-excursion
    (set-buffer (get-buffer-create " *MBUS Dispatch Log*"))
    (goto-char (point-max))
    (insert s "\n")
))

(defun mbus-status (s)
  (when *mbus-noisy*
    (set-property xa-mbus-status s (minibuf-screen))
;    (message s)
    (push s *mbus-status-stack*)
  )
  (if *mbus-log* (mbus:dispatch-log (concat "+" s)))
)

(defun mbus-status-pop (s)
  (if *mbus-log* (mbus:dispatch-log (concat "-" s)))
  (when *mbus-noisy*
    (let ((p (or (pop *mbus-status-stack*)) ""))
      (set-property xa-mbus-status p (minibuf-screen))
;      (message p)
)))

(defun mbus-status-clear ()
  (when *mbus-noisy*
    (set-property xa-mbus-status "*" (minibuf-screen))
;    (message "")
  )
  (setq *mbus-status-stack* nil)
)

(defun mbus:run-dispatcher (type val screen)
  (let ((epoch::event-handler-abort nil))
    (while
      (let
	(
	  (ret (mbus-dispatch *mbus-dispatch-dispatch*))
	)
	(mbus-run-after-hooks ret)	;run the hooks
	(not (memq (caddr ret) '( eof lost-connection )))
))))

(defun mbus-dispatch (handlers)
  (mbus-status "Dispatch")
  (let ( flag input *MBUS-DISPATCH-AFTER-HOOKS* *MBUS-DISPATCH-VALUES* )
    (while (not flag)
      (setq input
	(mbus:bus-safe-read-sexp mbus:*server-mark*
	  (symbol-buffer-value
	    'mbus:*bus-sexp-mark* (marker-buffer mbus:*server-mark*)
      )))
      (cond
	((eq input 'eof) (setq flag 'eof))
	((listp input)			;it's an S-expression, yay!
	  (let*
	    (
	      (key (car input))
	      (func (and key (cdr (assq key handlers))))
	    )
	    (cond
	      (func
		(mbus-status (format "+%s" key))
		(funcall func (cdr input))
		(mbus-status-pop (format "-%s" key))
	      )
	      (key
		(mbus:dispatch-log (format "No dispatch for %s" key))
	      )
	      (t (mbus:dispatch-log (format "Invalid dispatch form")))
	)))
	((eq input 'lost-connection)
	  (mbus:dispatch-log "Lost connection")
	  (setq flag 'lost-connection)
	)
	;; TO DO:  This is a hack since we were getting a \215 symbol
	;; (character) from the TI explorers in place of a carriage
	;; return.  If we don't ignore it here, the entire good sexpression
	;; right behind it will be lost when we set the flag to terminate.
	;; Need to think about how to do this better.
	((symbolp input)
	  t				; If symbol, just ignore
	)
	(t
	  (mbus:dispatch-log (format "Bad engine return %s" input))
	  (setq flag 'terminate)
	)
    ))
    (mbus-status-pop "Dispatch")
    (list *MBUS-DISPATCH-AFTER-HOOKS* *MBUS-DISPATCH-VALUES* flag)
))

;;; --------------------------------------------------------------------------
