/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	Author: Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

#include "extern.h"
#include "graph.h"
#include "elision.h"
#include <stdio.h>

/* Max_edge_check tells the number of pixels away from the pointer
 * (in a box) to go when looking for an edge.
 */
#define MAX_EDGE_CHECK 2

Graph *
GraphLookup (gid, graph_list)
  char *gid;
  struct TableStruct *graph_list;
{
  struct TableStruct *table_ptr;
  if (gid)
  {
    for (table_ptr = graph_list; table_ptr; table_ptr = table_ptr->next)
    {
      if (!strcmp(gid, table_ptr->id)) {
	return table_ptr->graph;
      }
    }
  }
  return NULL;
}

char *
LookupId (graph)
     Graph *graph;
{
  struct TableStruct *table_ptr;

  if (graph)
  {
    for (table_ptr = GraphList; table_ptr; table_ptr = table_ptr->next)
    {
      if (graph == table_ptr->graph) {
	return table_ptr->id;
      }
    }
  }
  return NULL;
}

/*
 *  The NodeLookup routine checks the graph for the existence of a node.
 *  It either returns a pointer to that vertex, or NULL.  We pass in the
 *  list to scan as well.  This makes things nice when we want to scan
 *  down either the normal node list, or the saved list.
*/
Vertex *
NodeLookup(name, vertex_list)
  char *name;
  Vertex *vertex_list;
{
  Vertex *node;

  for (node = vertex_list; node != NULL; node = node->next)
    if (!strcmp(node->values->i_name, name))
      return node;
  return NULL;
}  

Edge *
EdgeLookup(name, edge_list)
  char *name;
  Edge *edge_list;
{
  Edge *edge;

  for (edge = edge_list; edge != NULL; edge = edge->next)
    if (!strcmp(edge->values->i_name, name))
      return edge;
  return NULL;
}  

Vertex *
LocateVertex(x,y)
     int x,y;
{
  Vertex *node, *ret_node = NULL;
  coord_t xc, yc;

  xc = (coord_t)x / (coord_t)graph->viewing_area.width;
  yc = (coord_t)y / (coord_t)graph->viewing_area.height;
  for (node = graph->v; node != NULL; node = node->next) {
    /* Here we have to loop through all the nodes all the time.  If we
     * don't, then the user looks for the vertex at the point and gets the
     * first node found (which was the first one drawn), but there may be
     * other nodes plotted on top and those are the ones the user expects
     * to get
     */
    if (!NodeHidden(node) &&
	InBox(xc, yc, MINX(node), MINY(node), MAXX(node), MAXY(node)))
	ret_node = node;
  }
  return ret_node;
}

unsigned long
ColorAt (window_area, x, y, background)
  warea window_area;
  int x, y;
{
  /* If the location is off the screen, we will return the background
   * color.
   */
  XImage *Image;
  unsigned long pixel;
  /* This is a pretty dumb way to do this, but I don't know any better
   * ways without holding a pixmap internally.  Actually this isn't a
   * bad idea since it would make redraws (for expose events) much
   * nicer.  But for now...
   */
  if (x < 0 || x >= window_area.width || y < 0 || y >= window_area.height)
  {
    return background;
  }
  
  Image = XGetImage (XtDisplay(window_area.widget),
		     XtWindow(window_area.widget),
		     x, y, 1, 1, -1, XYPixmap);
  pixel = XGetPixel (Image, 0, 0);
  XDestroyImage (Image);
  return pixel;
}

Edge *
CheckForEdge (x, y, background)
  int x, y;
  unsigned long background;
{
  unsigned long color, edge_color, new_color;
  Edge *edge;
  Display *view_dpy;
  Window view_win;
  XFontStruct *font;

  view_dpy = XtDisplay(graph->viewing_area.widget);
  view_win = XtWindow(graph->viewing_area.widget);

  color = ColorAt (graph->viewing_area, x, y, background);

  if (color == background)
      return NULL;
  else
  {
    /* Set the point to a know color that wouldn't normally be used
     * for an edge or node.
     */
    XSetForeground(view_dpy, graph->text_gc, graph->background);
    XDrawPoint(view_dpy, view_win, graph->text_gc, x, y);
    for (edge = graph->edges; edge; edge = edge->next)
    {
      RetTypeInfo(edge->values->type, EDGEMASK, &edge_color, &font);
      if (edge_color == color)
      {
	DrawEdge(edge);
	new_color = ColorAt (graph->viewing_area, x, y, background);
	if (new_color == color)
	    break;
      }
    }
  }
  DrawAllNodes(VIEW_NODES);	/* Tidy up the nodes */
  return edge;
}
    
Edge *
LocateEdge(x, y)
  int x, y;
{
  int count, i;
  Edge *object;
  
  object = CheckForEdge (x, y, graph->background);
  count = 1;
  while (!object && count < MAX_EDGE_CHECK)
  {
    for (i = y - count; !object && i <= y + count; i++)
    {
      object = CheckForEdge(x - count, i, graph->background);
      if (!object)
	  object = CheckForEdge(x + count, i, graph->background);
    }
    for (i = x - count + 1; !object && i < x + count; i++)
    {
      object = CheckForEdge(i, y - count, graph->background);
      if (!object)
	  object = CheckForEdge(i, y + count, graph->background);
    }
    count++;
  }
  return object;
}

void
LocateObject(x,y, object, flag)
  int x,y;
  void **object;
  int *flag;
{
  if (!(*object = (void *)LocateVertex(x,y)))
      if (!(*object = (void *)LocateEdge(x,y)))
	  *flag = NULL;
      else
	  *flag = EDGEMASK;
  else
      *flag = NODEMASK;
}

