/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:  Mark Allender (allender@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
*/
/*
 *  This file contains the motif code to make menu bars and menus
 *  and other related things (including the menu bar callbacks).
*/
#include "config.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/CascadeB.h>
#include <Xm/PushBG.h>
#include "elision.h"
#include "extern.h"

Widget
AddMenuItem(menu, name, needseparator, callback, call_data)
     Widget menu;
     char *name;
     int needseparator;
     void (*callback)();
     caddr_t call_data;
{
  Widget newbutton, separator;
  Arg args[10];
  int n;

/*
 *  create the separator if needed.
*/
  if (needseparator == True) {
    separator = XmCreateSeparatorGadget(menu, "separator", NULL, 0);
    XtManageChild(separator);
  }
/*
 *  Now, just create the new menu option.
*/
  n = 0;
  newbutton = XmCreatePushButtonGadget(menu, name, args, n);
  XtManageChild(newbutton);
/*
 *  Now, add the callback for the menu item
*/
  if (callback != NULL)
    XtAddCallback(newbutton, XmNactivateCallback, callback, call_data);

  return (newbutton);
}

Widget
CreateMenu(menu_bar, name)
     Widget menu_bar;
     char *name;
{
  Widget cascade_button, menu_widget;
  Arg args[10];
  int n;
  char new_name[50];

  n = 0;
  cascade_button = XmCreateCascadeButton(menu_bar, name, args, n);
  XtManageChild(cascade_button);
/*
 *  create the new name for class of menu
*/
  strcpy(new_name, name);
  strcat(new_name, "Menu");
  n = 0;
  menu_widget = XmCreatePulldownMenu(menu_bar, new_name, args, n);
  n = 0;
  XtSetArg(args[n], XmNsubMenuId, menu_widget); n++;
  XtSetValues(cascade_button, args, n);
  return (menu_widget);
}

/*
 *  This routine creates the menu bar appearing on the top of the drawing
 *  area.
*/
Widget
CreateMenuBar (parent)
     Widget parent;
{
/*
 * CreateMenubar() creates a menu bar in the parent widget, assumed
 * to be a main window widget.
*/

  Widget menu_bar, option_menu;
  Arg args[10];
  int n;
  extern void ElisionControlPanel();
  extern void AntiElisionControlPanel();
  extern void ShowGraphDisplayTable();
  extern void ShowBrowserDisplayTable();

/*
 *  Create menu bar.
*/

  n = 0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  menu_bar = XmCreateMenuBar(parent, "menu_bar", args, n);
  XtManageChild(menu_bar);

/*
 *  create the menu bar options, and possible menu items for them
*/
  
  option_menu = CreateMenu(menu_bar, "Options");
  AddMenuItem(option_menu, "Elision Policies", False, ElisionControlPanel,
	      (caddr_t)graph);
  AddMenuItem(option_menu, "UnElision Policies", False,
	      AntiElisionControlPanel, (caddr_t)graph);
  AddMenuItem(option_menu, "Graph Display Table", True, ShowGraphDisplayTable,
	      (caddr_t)graph);
  AddMenuItem(option_menu, "Browser Display Table", False,
	      ShowBrowserDisplayTable, (caddr_t)graph);
  return menu_bar;
}

