/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	container.c: The container widget */
/* widget server container driver code */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node109.text,v $ */

static char rcsid[] = "container.c $Revision: 1.1 $ $Date: 92/05/08 15:26:11 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/ScrolledW.h>
/* ------------------------------------------------------------------------ */
extern void
  ContainerRemove(), ContainerUpdate(), ContainerReply(),
  ContainerChildDestroyed(), ContainerRealized(),
  ContainerEditable(), ContainerTransmit();

extern t_generic_widget ContainerHandle();

struct widget_class_struct ContainerClassRecord =
{
  WS_CONTAINER, "container",
  ContainerHandle, ContainerRemove, NULL, ContainerUpdate, ContainerReply,
  ContainerRealized, ContainerTransmit, ContainerEditable,
} ;
/* ------------------------------------------------------------------------ */
/* a container consists of a scrolled window with a form widget inside.
 * the sub items are layed out left to right inside the form, under the
 * title widget.
 * The title widget is managed only if it has been set.
 */
typedef struct container_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  t_generic_widget items;
  char *title;				/* also flag for if title bar */
  Widget form_widget;
  Widget title_widget;
} * t_container_widget;

/* ------------------------------------------------------------------------ */
/* Find the widest subwidget, and make all widgets that width. We do this
 * so that when the container is realized, it doesn't lock up in an infinite
 * loop trying to decide how wide the subwidgets should be. This happens
 * when two subwidgets are scrolled lists, non-empty, with a listSizePolicy
 * of XmRESIZE_IF_POSSIBLE.
 * The astute observer will note that there's no real need to deal with the
 * height as well as the width. However, it turns out to be the case that if
 * the height is _not_ set, it ends up being 0. Why, I don't know. My
 * theories are not printable.
 */
void
ContainerNormalize(container) t_container_widget container;
{
  t_generic_widget item;
  Dimension max_width = 0, max_height = 0;
  Arg argl[2];
  XtWidgetGeometry intended, preferred;

  for ( item = container->items ; NULL != item; item = item->next )
    {
      intended.request_mode = CWWidth | CWHeight | XtCWQueryOnly;
      intended.width = 60;		/* doesn't seem to matter much */
      intended.height = 20;
      XtQueryGeometry(item->widget, &intended, &preferred);
      if (preferred.width > max_width) max_width = preferred.width;
      if (preferred.height > max_height) max_height = preferred.height;
    }

  for ( item = container->items ; NULL != item; item = item->next )
    {
      XtSetArg(argl[0], XmNwidth, max_width);
      XtSetArg(argl[1], XmNheight, max_height);
      XtSetValues(item->widget, argl, 2);
    }
}
/* ------------------------------------------------------------------------ */
/* What we do here is reset all the attachments for the container form to
 * correspond to the current conditions of the container.
 */
void
ContainerAdjust(container) t_container_widget container;
{
  t_generic_widget item;
  int count = 0;
  int n, base;
  Dimension height;
  Arg argl[10];

  for ( item = container->items ; NULL != item; item = item->next )
    count += 1;

  if (0 == count) return;
  XtSetArg(argl[0], XmNfractionBase, count);
  XtSetValues(container->form_widget, argl, 1);

  base = 0;
  if (NULL == container->title)
    {
      XtSetArg(argl[base], XmNtopAttachment, XmATTACH_FORM), ++base;
    }
  else
    {
      XtSetArg(argl[0], XmNheight, &height);
      XtGetValues(container->title_widget, argl, 1);
      XtSetArg(argl[0], XmNbottomAttachment, XmATTACH_OPPOSITE_FORM);
      XtSetArg(argl[1], XmNbottomOffset, -height);
      XtSetValues(container->title_widget, argl, 2);
      XtSetArg(argl[base], XmNtopAttachment, XmATTACH_WIDGET), ++base;
      XtSetArg(argl[base], XmNtopWidget, container->title_widget), ++base;
    }

  /* loop through all the widgets and set their attachments */
  for ( item = container->items ; NULL != item ; item = item->next )
    {
      n = base;
      if (item == container->items)	/* rightmost child */
	XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
      else
	{
	  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_POSITION), ++n;
	  XtSetArg(argl[n], XmNrightPosition, count), ++n;
	}
      if (NULL == item->next)		/* leftmost child */
	XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
      else
	{
	  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_WIDGET), ++n;
	  XtSetArg(argl[n], XmNleftWidget, item->next->widget), ++n;
	}
      XtSetValues(item->widget, argl, n);
      count -= 1;
    }
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct ContainerKeywords[] =
{
  { ":title", NULL, KEYWORD_COOKED },
};

t_generic_widget
ContainerHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_container_widget container;
  t_generic_widget current;
  t_sexp item;
  int n, count;
  Arg argl[10];

  /* check things to see if they're in the right format */
  if (NULL == parent || NULL == sexp) return NULL;

  container = NEW_STRUCT(container_widget_struct);
  container->type = WS_CONTAINER;
  container->class = &ContainerClassRecord;
  container->parent = parent;
  container->top = parent->top;
  container->id = Getnth(sexp, 1);
  container->items = NULL;

  /* sexp should be (container "id" <items> &key ...) */
  MBparse_keywords(MBnthcdr(sexp,3), ContainerKeywords,
		ARRAY_SIZE(ContainerKeywords));
  container->title = (char *)ContainerKeywords[0].result;

  /* form */
  n = 0;
  XtSetArg(argl[n], XmNuserData, container), ++n;
  XtSetArg(argl[1], XmNresizable, True), ++n;

  container->form_widget = XtCreateWidget("form", xmFormWidgetClass,
					  parent->widget, argl, n);

  /* title */
  container->title_widget =
    CreateTitle(NULL == container->title ? "" : container->title,
		container->form_widget);
  XtSetArg(argl[0], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(argl[1], XmNrightAttachment, XmATTACH_FORM);
  XtSetArg(argl[2], XmNalignment, XmALIGNMENT_CENTER);
  XtSetArg(argl[3], XmNtopAttachment, XmATTACH_FORM);
  XtSetValues(container->title_widget, argl, 4);

  /* handle the sub items. They should all be children of the box
   * widget
   */
  container->widget = container->form_widget;

  count = 0;
  for ( item = MBnth(sexp,2) ; MB_CONSP(item) ; item = MB_CDR(item) )
    {
      current = HandleBusItem(container, MB_CAR(item));

      if (NULL != current)
	{
	  /* this will all get reset when we do the adjustment, but setting
	   * it now, also, will give us better initial layout
	   */
	  n = 0;
	  count += 1;			/* this will set _right_ position */
	  if (NULL == container->items)
	    XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
	  else
	    {
	      XtSetArg(argl[n], XmNleftAttachment, XmATTACH_WIDGET), ++n;
	      XtSetArg(argl[n], XmNleftWidget, container->items->widget), ++n;
	    }
	  if (NULL == container->title)
	    XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
	  else
	    {
	      XtSetArg(argl[n], XmNtopAttachment, XmATTACH_WIDGET), ++n;
	      XtSetArg(argl[n], XmNtopWidget, container->title_widget), ++n;
	    }
	  XtSetArg(argl[n], XmNbottomAttachment, XmATTACH_FORM), ++n;
	  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_POSITION), ++n;
	  XtSetArg(argl[n], XmNrightPosition, count), ++n;
	  XtSetValues(current->widget, argl, n);
	  current->next = container->items;
	  container->items = current;
	}
    }
  XtSetArg(argl[0], XmNfractionBase, count);
  XtSetValues(container->form_widget, argl, 1);

/*
  ManageWidgetList(container->items);

  ContainerNormalize(container);
*/

  if (NULL != container->title) XtManageChild(container->title_widget);

  container->widget = container->form_widget;

  return (t_generic_widget) container;
}

/* ------------------------------------------------------------------------ */
void
ContainerRemove(self) t_container_widget self;
{
  MBfree(self->id);
  RemoveWidgetList(self->items);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the container */
static struct keyword_entry_struct ContainerUpdateKeys[] =
{
  { ":label", NULL, KEYWORD_COOKED },
  { ":value", NULL, KEYWORD_COOKED },
};

void
ContainerUpdate(self,sexp)
     t_container_widget self;
     t_sexp sexp;
{
  XmString xm_string;
  char *label, *value;

  if (!MBequal(MBnth(sexp,1), self->id))
    {
      UpdateWidgetList(self->items, sexp);
    }
  else
    {

      MBparse_keywords(MBnthcdr(sexp,2), ContainerUpdateKeys,
		    ARRAY_SIZE(ContainerUpdateKeys));
      label = (char *)ContainerUpdateKeys[0].result;
      value = (char *)ContainerUpdateKeys[0].result;

      /*
	if (NULL != label) SetTitle(self->label_widget, label);
	if (NULL != value) XmTextSetString(self->text_widget, value);
	*/

      XtFree(label); XtFree(value);
    }
}
/* ------------------------------------------------------------------------ */
void
ContainerReply(self, reply)
     t_container_widget self;
     t_mbus_reply reply;
{
  self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
/* Transmit data to the MBus */
void
ContainerTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_container_widget self;
{
  TransmitWidgetList(message, orig_reply, self->items);
}
/* ------------------------------------------------------------------------ */
void
ContainerEditable(self,flag)
     t_container_widget self;
     int flag;
{
  EditableWidgetList(self->items, flag);
}
/* ------------------------------------------------------------------------ */
/* Called by a child when it decides to destroy itself for whatever reason.
 * We should update our internal data to remove references to the child.
 * Assume that all of the childs internal and widgets stuff is taken care
 * of by the child.
 */
void
ContainerChildDestroyed(self, child)
     t_container_widget self;
     t_generic_widget child;
{
}
/* ------------------------------------------------------------------------ */
void
ContainerRealized(self) t_container_widget self;
{
  t_generic_widget item;

  ContainerNormalize(self);

  ManageWidgetList(self->items);

  for (item = self->items ; NULL != item ; item = item->next )
    item->class->realized(item);

  ContainerAdjust(self);
}
/* ------------------------------------------------------------------------ */
