/*
 * $Id: server_env.c,v 1.5 1992/09/22 04:29:23 proj Exp $
 */
/*
 * Copyright 1991, 1992 by OMRON Corporation
 * Copyright 1991, 1992 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of OMRON and MIT not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  OMRON and MIT make no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * OMRON, MIT AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL OMRON, MIT OR WNN CONSORTIUM BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *      Author: Seiji Kuwari    OMRON Corporation
 *                              kuwa@nff.ncl.omron.co.jp
 */

#include <stdio.h>
#include "commonhd.h"
#include "config.h"
#include "wnn_os.h"

typedef struct _server_env_struct {
    char *lang;
    char *env;
} server_env_struct;

static server_env_struct server_env[] = {
    {WNN_J_LANG, WNN_JSERVER_ENV},
    {WNN_C_LANG, WNN_CSERVER_ENV},
    {WNN_K_LANG, WNN_KSERVER_ENV},
    {WNN_T_LANG, WNN_TSERVER_ENV},
    {NULL, NULL}
};

char *
get_server_env(lang)
register char *lang;
{
    register server_env_struct *p;

    if (!lang || !*lang) return(NULL);

    for (p = server_env; p->lang; p++) {
	if (!strncmp(lang, p->lang, strlen(lang))) {
	    return(p->env);
	}
    }
    return(NULL);
}
