#!/bin/csh
# @OPENGROUP_COPYRIGHT@
# COPYRIGHT NOTICE
# Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
# Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
# ALL RIGHTS RESERVED (MOTIF). See the file named COPYRIGHT.MOTIF for
# the full copyright text.
# 
# This software is subject to an open license. It may only be
# used on, with or for operating systems which are themselves open
# source systems. You must contact The Open Group for a license
# allowing distribution and sublicensing of this software on, with,
# or for operating systems which are not Open Source programs.
# 
# See http://www.opengroup.org/openmotif/license for full
# details of the license agreement. Any use, reproduction, or
# distribution of the program constitutes recipient's acceptance of
# this agreement.
# 
# EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
# PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
# WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
# OR FITNESS FOR A PARTICULAR PURPOSE
# 
# EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
# NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
# EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGES.
# 
# HISTORY
#
# a known restriction of this script is that the arguments to -xrm (or
# any other flag!) must contain no spaces.

# default vars

set arglist = "$argv"
set Vistarun = false
set totalVista = false

#
# The following are Purify RUN related variables
#
# The format for specifying will be as follows:
#
#    RUN -memory <memory_switch>
#
# The various values of "memory_switch" and their meanings are as follows:
#
#     -all   - Log the complete Purify output
#     -leaks - Log only memoryleaks
#     -fm    - Log only Freed Memory Read (Write) access errors
#     -um    - Log only Uninintialized Memory Read (Write) access errors
#     -ab    - Log only Array Bound Read (Write) access errors
#     -fu    - Log only Freed and Uninintialized Memory access errors
#     -fa    - Log only Freed and Array Bound Memory access errors
#     -ua    - Log only Uninintialized and Array Bound Memory access errors
#
#
# All of the above will have memory leak information along with the
# specified information. Memory leak information will need to be
# stripped out with all the cases other than "-all" and "-leaks"
#

set Purifyrun = false
set memoryInfo = "-all"

set argcnt = $#argv
set argindex = 1
while ($argcnt != 0)
    switch ($argv[$argindex])
        case -bfa*:
            set Vistarun = true
            set argv[$argindex] = ""
            breaksw
        case -BFA*:
            set Vistarun = true
            set totalVista = true
            set argv[$argindex] = ""
            breaksw
        case -memory:
            set Purifyrun = true
            set argv[$argindex] = ""
            @ argcnt--
            @ argindex++
            set memoryInfo = $argv[$argindex]
            set argv[$argindex] = ""
            breaksw
        case -d*:
            @ argcnt--
            @ argindex++
            setenv DISPLAY $argv[$argindex]
            breaksw
    endsw
    @ argcnt--
    @ argindex++
end

set arglist = "$argv"

# Counter used for setting up Purify environment first time around
@ count = 0

if ($Vistarun == true) then
    echo "This is a Vista RUN"
endif

# clean up from previous runs

if (-e ./RUN_failures) then
    echo "backing up RUN_failures file"
    mv RUN_failures RUN_failures.bak
endif

touch RUN_failures

if (-e ./RUN_output) then
    echo "backing up output file"
    mv RUN_output RUN_output.bak
endif
touch RUN_output

if ($Purifyrun == true) then
    echo "This is a Purify RUN" >> RUN_output
endif

if ($Vistarun == true) then
    ls *.metg >& /dev/null
    if ($status == 0) then
        rm -f *.metg
    endif
    ls *.audg >& /dev/null
    if ($status == 0) then
        rm -f *.audg
    endif
    ls *.covg >& /dev/null
    if ($status == 0) then
        rm -f *.covg
    endif
endif

# noglob is needed to handle special cases

set noglob

# special cases. Specify ALL flags for tests which require them.
# remember all arguments MUST be a single word (ie no spaces)
# use single quotes around the right side.

# START CUSTOMIZE # 

<Customize>

# END CUSTOMIZE #
if ($count == 0 && $Purifyrun == true) then
    if (-e .purify.bak) then
        rm -f .purify.bak
    endif
    if (-e .purify) then
        mv .purify .purify.bak
    endif
    echo "This is a Purify RUN" >> RUN_output
    switch($memoryInfo)
        case -all:
            cp $TOP/tests/memory/.purify.all .purify
            breaksw
        case -fm:
            cp $TOP/tests/memory/.purify.fm .purify
            breaksw
        case -um:
            cp $TOP/tests/memory/.purify.um .purify
            breaksw
        case -ab:
            cp $TOP/tests/memory/.purify.ab .purify
            breaksw
        case -leaks:
            cp $TOP/tests/memory/.purify.leaks .purify
            breaksw
        case -fu:
            cp $TOP/tests/memory/.purify.fu .purify
            breaksw
        case -fa:
            cp $TOP/tests/memory/.purify.fa .purify
            breaksw
        case -ua:
            cp $TOP/tests/memory/.purify.ua .purify
            breaksw
    endsw
    @ count++
endif
    
    set test =($test)
    if ($Vistarun == true) then
        if !(-e $TOP/tests/Vista/libXm.M) then
            echo "Map file libXm.M not found in $TOP/tests/Vista" >> RUN_output            echo "No Vista reports generated" >> RUN_output
            set Vistarun = false
        endif
    endif
    if ($Vistarun == true) then
        set testname = `echo $test | awk '{print $1}'`
    endif
    if ($Purifyrun == true) then
		if ($?test_output) then
            set testname = `echo $test_output | awk -F'.' '{print $1}'`
		else
            set testname = `echo $test | awk '{print $1}'`
		endif
    endif

    if ($Purifyrun == true) then
        if (-e $testname.purify) then
            mv -f $testname.purify $testname.purify.bak
        endif
        setenv PURIFYLOGFILE $testname.purify
    endif
    
    echo "" >> RUN_output
    echo "Beginning test " $test[1] >> RUN_output
    echo "Beginning test " $test[1]
    if ($Vistarun == true && $totalVista == false) then
        set HIT_FILE = $TOP/tests/Vista/$testname.hits
        if (-e ${HIT_FILE}) then
            rm -f ${HIT_FILE}
        endif
    endif

# try to prevent it quitting if the test wasn't built
    if (-e $test[1]) then
        echo "Running " $test $arglist
        $test $arglist
        if ($status != 0) then
            if (-e core) then
                echo "backing up core to "$test[1]".core"
                mv core $test[1].core
            endif
            echo "failure in test: "$test[1] >> RUN_failures
            echo "FAILURE IN TEST: "$test[1] >> RUN_output
            echo "FAILURE IN TEST: "$test[1] 
        else if ($Vistarun == true $totalVista == false) then
            if (-e hits) then
                mv hits ${HIT_FILE}

                if (-e $testname.metg) then

                    MetGen $TOP/tests/Vista/libXm.M \
                    ./$testname.M >> $testname.metg

                    AudGen -T $testname.tally $TOP/tests/Vista/libXm.M \
                    ./$testname.M \
                    ${HIT_FILE} >> $testname.audg

                    CovGen $TOP/tests/Vista/libXm.M \
                    ./$testname.M \
                    $testname.tally >> $testname.covg
                else

                    MetGen $TOP/tests/Vista/libXm.M \
                    ./$testname.M > $testname.metg

                    AudGen -T $testname.tally $TOP/tests/Vista/libXm.M \
                    ./$testname.M \
                    ${HIT_FILE} > $testname.audg

                    CovGen $TOP/tests/Vista/libXm.M \
                    ./$testname.M \
                    $testname.tally > $testname.covg

                endif
                rm ${HIT_FILE}
                rm $testname.tally
            endif
            unset HIT_FILE
            unset testname
        else if ($Purifyrun == true) then
            unsetenv PURIFYLOGFILE
            unset testname
        endif
    else
        echo "Error - Test " $test " does not exist."
          echo "Error - Test " $test " does not exist" >> RUN_output
        continue
    endif

    echo "Ending test "$test[1]"" >> RUN_output
    echo "" >> RUN_output
    echo "Ending test "$test[1]""
    echo ""

end

unset noglob
#
# if totalVista is true, generate the overall coverage report for the
# directory
#
if ($Vistarun == true && $totalVista == true) then
    set dirname = `echo $cwd | awk -F '/' '{print $NF}'`
    if (-e hits) then
        MetGen $TOP/tests/Vista/libXm.M *.M > $dirname.metg

        AudGen -T $dirname.tally $TOP/tests/Vista/libXm.M *.M \
        hits > $dirname.audg

        CovGen $TOP/tests/Vista/libXm.M *.M $dirname.tally > $dirname.covg

    else
        echo "No hits file generated"
    endif
endif

#
# If Purifyrun, Generate memory related reports
#
if ($Purifyrun == true) then
    GetLeaks
endif

exit 0 
