/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHPrimitiveType;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Name;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHType
extends SimpleNode
implements BshClassManager.Listener {
    private Class baseType;
    private int arrayDims;
    private Class type;
    String descriptor;

    BSHType(int n) {
        super(n);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    SimpleNode getTypeNode() {
        return (SimpleNode)this.jjtGetChild(0);
    }

    public String getTypeDescriptor(CallStack callStack, Interpreter interpreter, String string) {
        String string2;
        if (this.descriptor != null) {
            return this.descriptor;
        }
        SimpleNode simpleNode = this.getTypeNode();
        if (simpleNode instanceof BSHPrimitiveType) {
            string2 = BSHType.getTypeDescriptor(((BSHPrimitiveType)simpleNode).type);
        } else {
            String string3 = ((BSHAmbiguousName)simpleNode).text;
            BshClassManager bshClassManager = interpreter.getClassManager();
            String string4 = bshClassManager.getClassBeingDefined(string3);
            Class clazz = null;
            if (string4 == null) {
                try {
                    clazz = ((BSHAmbiguousName)simpleNode).toClass(callStack, interpreter);
                }
                catch (EvalError evalError) {}
            } else {
                string3 = string4;
            }
            string2 = clazz != null ? BSHType.getTypeDescriptor(clazz) : (string == null || Name.isCompound(string3) ? "L" + string3.replace('.', '/') + ";" : "L" + string.replace('.', '/') + "/" + string3 + ";");
        }
        for (int i = 0; i < this.arrayDims; ++i) {
            string2 = "[" + string2;
        }
        this.descriptor = string2;
        return string2;
    }

    public Class getType(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.type != null) {
            return this.type;
        }
        SimpleNode simpleNode = this.getTypeNode();
        this.baseType = simpleNode instanceof BSHPrimitiveType ? ((BSHPrimitiveType)simpleNode).getType() : ((BSHAmbiguousName)simpleNode).toClass(callStack, interpreter);
        if (this.arrayDims > 0) {
            try {
                int[] nArray = new int[this.arrayDims];
                Object object = Array.newInstance(this.baseType, nArray);
                this.type = object.getClass();
            }
            catch (Exception exception) {
                throw new EvalError("Couldn't construct array type", this, callStack);
            }
        } else {
            this.type = this.baseType;
        }
        interpreter.getClassManager().addListener(this);
        return this.type;
    }

    public Class getBaseType() {
        return this.baseType;
    }

    public int getArrayDims() {
        return this.arrayDims;
    }

    public void classLoaderChanged() {
        this.type = null;
        this.baseType = null;
    }

    public static String getTypeDescriptor(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        String string = clazz.getName().replace('.', '/');
        if (string.startsWith("[") || string.endsWith(";")) {
            return string;
        }
        return "L" + string.replace('.', '/') + ";";
    }
}

