;; Japanese Character Input Package for Egg
;; Coded by S.Tomura, Electrotechnical Lab. (tomura@etl.go.jp)

;; This file is part of Egg on Mule (Multilingal Environment)

;; Egg is distributed in the forms of patches to GNU
;; Emacs under the terms of the GNU EMACS GENERAL PUBLIC
;; LICENSE which is distributed along with GNU Emacs by the
;; Free Software Foundation.

;; Egg is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied
;; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
;; PURPOSE.  See the GNU EMACS GENERAL PUBLIC LICENSE for
;; more details.

;; You should have received a copy of the GNU EMACS GENERAL
;; PUBLIC LICENSE along with Nemacs; see the file COPYING.
;; If not, write to the Free Software Foundation, 675 Mass
;; Ave, Cambridge, MA 02139, USA.

;;; 92.10.18 modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
;;;	Moved from egg.el
;;; 92.12.26 modified for Mule Ver.0.9.7 by T.Shingu <shingu@cpr.canon.co.jp>
;;;	JIS Hojo Kanji support.

(provide 'egg-jsymbol)

(defvar *ku1-alist* '(
	 ( "$B!!(B" . "$B!!(B")
	 ( "$B!"(B" . "$B!"(B")
	 ( "$B!#(B" . "$B!#(B")
	 ( "$B!$(B" . "$B!$(B")
	 ( "$B!%(B" . "$B!%(B")
	 ( "$B!&(B" . "$B!&(B")
	 ( "$B!'(B" . "$B!'(B")
	 ( "$B!((B" . "$B!((B")
	 ( "$B!)(B" . "$B!)(B")
	 ( "$B!*(B" . "$B!*(B")
	 ( "$B!+(B" . "$B!+(B")
	 ( "$B!,(B" . "$B!,(B")
	 ( "$B!-(B" . "$B!-(B")
	 ( "$B!.(B" . "$B!.(B")
	 ( "$B!/(B" . "$B!/(B")
	 ( "$B!0(B" . "$B!0(B")
	 ( "$B!1(B" . "$B!1(B")
	 ( "$B!2(B" . "$B!2(B")
	 ( "$B!3(B" . "$B!3(B")
	 ( "$B!4(B" . "$B!4(B")
	 ( "$B!5(B" . "$B!5(B")
	 ( "$B!6(B" . "$B!6(B")
	 ( "$B!7(B" . "$B!7(B")
	 ( "$B!8(B" . "$B!8(B")
	 ( "$B!9(B" . "$B!9(B")
	 ( "$B!:(B" . "$B!:(B")
	 ( "$B!;(B" . "$B!;(B")
	 ( "$B!<(B" . "$B!<(B")
	 ( "$B!=(B" . "$B!=(B")
	 ( "$B!>(B" . "$B!>(B")
	 ( "$B!?(B" . "$B!?(B")
	 ( "$B!@(B" . "$B!@(B")
	 ( "$B!A(B" . "$B!A(B")
	 ( "$B!B(B" . "$B!B(B")
	 ( "$B!C(B" . "$B!C(B")
	 ( "$B!D(B" . "$B!D(B")
	 ( "$B!E(B" . "$B!E(B")
	 ( "$B!F(B" . "$B!F(B")
	 ( "$B!G(B" . "$B!G(B")
	 ( "$B!H(B" . "$B!H(B")
	 ( "$B!I(B" . "$B!I(B")
	 ( "$B!J(B" . "$B!J(B")
	 ( "$B!K(B" . "$B!K(B")
	 ( "$B!L(B" . "$B!L(B")
	 ( "$B!M(B" . "$B!M(B")
	 ( "$B!N(B" . "$B!N(B")
	 ( "$B!O(B" . "$B!O(B")
	 ( "$B!P(B" . "$B!P(B")
	 ( "$B!Q(B" . "$B!Q(B")
	 ( "$B!R(B" . "$B!R(B")
	 ( "$B!S(B" . "$B!S(B")
	 ( "$B!T(B" . "$B!T(B")
	 ( "$B!U(B" . "$B!U(B")
	 ( "$B!V(B" . "$B!V(B")
	 ( "$B!W(B" . "$B!W(B")
	 ( "$B!X(B" . "$B!X(B")
	 ( "$B!Y(B" . "$B!Y(B")
	 ( "$B!Z(B" . "$B!Z(B")
	 ( "$B![(B" . "$B![(B")
	 ( "$B!\(B" . "$B!\(B")
	 ( "$B!](B" . "$B!](B")
	 ( "$B!^(B" . "$B!^(B")
	 ( "$B!_(B" . "$B!_(B")
	 ( "$B!`(B" . "$B!`(B")
	 ( "$B!a(B" . "$B!a(B")
	 ( "$B!b(B" . "$B!b(B")
	 ( "$B!c(B" . "$B!c(B")
	 ( "$B!d(B" . "$B!d(B")
	 ( "$B!e(B" . "$B!e(B")
	 ( "$B!f(B" . "$B!f(B")
	 ( "$B!g(B" . "$B!g(B")
	 ( "$B!h(B" . "$B!h(B")
	 ( "$B!i(B" . "$B!i(B")
	 ( "$B!j(B" . "$B!j(B")
	 ( "$B!k(B" . "$B!k(B")
	 ( "$B!l(B" . "$B!l(B")
	 ( "$B!m(B" . "$B!m(B")
	 ( "$B!n(B" . "$B!n(B")
	 ( "$B!o(B" . "$B!o(B")
	 ( "$B!p(B" . "$B!p(B")
	 ( "$B!q(B" . "$B!q(B")
	 ( "$B!r(B" . "$B!r(B")
	 ( "$B!s(B" . "$B!s(B")
	 ( "$B!t(B" . "$B!t(B")
	 ( "$B!u(B" . "$B!u(B")
	 ( "$B!v(B" . "$B!v(B")
	 ( "$B!w(B" . "$B!w(B")
	 ( "$B!x(B" . "$B!x(B")
	 ( "$B!y(B" . "$B!y(B")
	 ( "$B!z(B" . "$B!z(B")
	 ( "$B!{(B" . "$B!{(B")
	 ( "$B!|(B" . "$B!|(B")
	 ( "$B!}(B" . "$B!}(B")
	 ( "$B!~(B" . "$B!~(B")
))
(defvar *ku2-alist* '(
	 ( "$B"!(B" . "$B"!(B")
	 ( "$B""(B" . "$B""(B")
	 ( "$B"#(B" . "$B"#(B")
	 ( "$B"$(B" . "$B"$(B")
	 ( "$B"%(B" . "$B"%(B")
	 ( "$B"&(B" . "$B"&(B")
	 ( "$B"'(B" . "$B"'(B")
	 ( "$B"((B" . "$B"((B")
	 ( "$B")(B" . "$B")(B")
	 ( "$B"*(B" . "$B"*(B")
	 ( "$B"+(B" . "$B"+(B")
	 ( "$B",(B" . "$B",(B")
	 ( "$B"-(B" . "$B"-(B")
	 ( "$B".(B" . "$B".(B")
;	 ( "$B"/(B" . "$B"/(B")
;	 ( "$B"0(B" . "$B"0(B")
;	 ( "$B"1(B" . "$B"1(B")
;	 ( "$B"2(B" . "$B"2(B")
;	 ( "$B"3(B" . "$B"3(B")
;	 ( "$B"4(B" . "$B"4(B")
;	 ( "$B"5(B" . "$B"5(B")
;	 ( "$B"6(B" . "$B"6(B")
;	 ( "$B"7(B" . "$B"7(B")
;	 ( "$B"8(B" . "$B"8(B")
;	 ( "$B"9(B" . "$B"9(B")
	 ( "$B":(B" . "$B":(B")
	 ( "$B";(B" . "$B";(B")
	 ( "$B"<(B" . "$B"<(B")
	 ( "$B"=(B" . "$B"=(B")
	 ( "$B">(B" . "$B">(B")
	 ( "$B"?(B" . "$B"?(B")
	 ( "$B"@(B" . "$B"@(B")
	 ( "$B"A(B" . "$B"A(B")
;	 ( "$B"B(B" . "$B"B(B")
;	 ( "$B"C(B" . "$B"C(B")
;	 ( "$B"D(B" . "$B"D(B")
;	 ( "$B"E(B" . "$B"E(B")
;	 ( "$B"F(B" . "$B"F(B")
;	 ( "$B"G(B" . "$B"G(B")
;	 ( "$B"H(B" . "$B"H(B")
;	 ( "$B"I(B" . "$B"I(B")
	 ( "$B"J(B" . "$B"J(B")
	 ( "$B"K(B" . "$B"K(B")
	 ( "$B"L(B" . "$B"L(B")
	 ( "$B"M(B" . "$B"M(B")
	 ( "$B"N(B" . "$B"N(B")
	 ( "$B"O(B" . "$B"O(B")
	 ( "$B"P(B" . "$B"P(B")
;	 ( "$B"Q(B" . "$B"Q(B")
;	 ( "$B"R(B" . "$B"R(B")
;	 ( "$B"S(B" . "$B"S(B")
;	 ( "$B"T(B" . "$B"T(B")
;	 ( "$B"U(B" . "$B"U(B")
;	 ( "$B"V(B" . "$B"V(B")
;	 ( "$B"W(B" . "$B"W(B")
;	 ( "$B"X(B" . "$B"X(B")
;	 ( "$B"Y(B" . "$B"Y(B")
;	 ( "$B"Z(B" . "$B"Z(B")
;	 ( "$B"[(B" . "$B"[(B")
	 ( "$B"\(B" . "$B"\(B")
	 ( "$B"](B" . "$B"](B")
	 ( "$B"^(B" . "$B"^(B")
	 ( "$B"_(B" . "$B"_(B")
	 ( "$B"`(B" . "$B"`(B")
	 ( "$B"a(B" . "$B"a(B")
	 ( "$B"b(B" . "$B"b(B")
	 ( "$B"c(B" . "$B"c(B")
	 ( "$B"d(B" . "$B"d(B")
	 ( "$B"e(B" . "$B"e(B")
	 ( "$B"f(B" . "$B"f(B")
	 ( "$B"g(B" . "$B"g(B")
	 ( "$B"h(B" . "$B"h(B")
	 ( "$B"i(B" . "$B"i(B")
	 ( "$B"j(B" . "$B"j(B")
;	 ( "$B"k(B" . "$B"k(B")
;	 ( "$B"l(B" . "$B"l(B")
;	 ( "$B"m(B" . "$B"m(B")
;	 ( "$B"n(B" . "$B"n(B")
;	 ( "$B"o(B" . "$B"o(B")
;	 ( "$B"p(B" . "$B"p(B")
;	 ( "$B"q(B" . "$B"q(B")
	 ( "$B"r(B" . "$B"r(B")
	 ( "$B"s(B" . "$B"s(B")
	 ( "$B"t(B" . "$B"t(B")
	 ( "$B"u(B" . "$B"u(B")
	 ( "$B"v(B" . "$B"v(B")
	 ( "$B"w(B" . "$B"w(B")
	 ( "$B"x(B" . "$B"x(B")
	 ( "$B"y(B" . "$B"y(B")
;	 ( "$B"z(B" . "$B"z(B")
;	 ( "$B"{(B" . "$B"{(B")
;	 ( "$B"|(B" . "$B"|(B")
;	 ( "$B"}(B" . "$B"}(B")
	 ( "$B"~(B" . "$B"~(B")
))

(defvar egg:*symbol-alist* (append *ku1-alist* *ku2-alist*))

(defvar *ku3-alist* '(
;I	 ( "$B#!(B" . "$B#!(B")
;II	 ( "$B#"(B" . "$B#"(B")
;III	 ( "$B##(B" . "$B##(B")
;IV	 ( "$B#$(B" . "$B#$(B")
;V       ( "$B#%(B" . "$B#%(B")
;VI	 ( "$B#&(B" . "$B#&(B")
;VII	 ( "$B#'(B" . "$B#'(B")
;VIII	 ( "$B#((B" . "$B#((B")
;IX	 ( "$B#)(B" . "$B#)(B")
;X	 ( "$B#*(B" . "$B#*(B")
;XI	 ( "$B#+(B" . "$B#+(B")
;XII	 ( "$B#,(B" . "$B#,(B")
;XIII	 ( "$B#-(B" . "$B#-(B")
;XIV	 ( "$B#.(B" . "$B#.(B")
;XV	 ( "$B#/(B" . "$B#/(B")
	 ( "$B#0(B" . "$B#0(B")
	 ( "$B#1(B" . "$B#1(B")
	 ( "$B#2(B" . "$B#2(B")
	 ( "$B#3(B" . "$B#3(B")
	 ( "$B#4(B" . "$B#4(B")
	 ( "$B#5(B" . "$B#5(B")
	 ( "$B#6(B" . "$B#6(B")
	 ( "$B#7(B" . "$B#7(B")
	 ( "$B#8(B" . "$B#8(B")
	 ( "$B#9(B" . "$B#9(B")
;1/2	 ( "$B#:(B" . "$B#:(B")
;1/3	 ( "$B#;(B" . "$B#;(B")
;1/4	 ( "$B#<(B" . "$B#<(B")
;2/3	 ( "$B#=(B" . "$B#=(B")
;3/4	 ( "$B#>(B" . "$B#>(B")
;	 ( "$B#?(B" . "$B#?(B")
;	 ( "$B#@(B" . "$B#@(B")
	 ( "$B#A(B" . "$B#A(B")
	 ( "$B#B(B" . "$B#B(B")
	 ( "$B#C(B" . "$B#C(B")
	 ( "$B#D(B" . "$B#D(B")
	 ( "$B#E(B" . "$B#E(B")
	 ( "$B#F(B" . "$B#F(B")
	 ( "$B#G(B" . "$B#G(B")
	 ( "$B#H(B" . "$B#H(B")
	 ( "$B#I(B" . "$B#I(B")
	 ( "$B#J(B" . "$B#J(B")
	 ( "$B#K(B" . "$B#K(B")
	 ( "$B#L(B" . "$B#L(B")
	 ( "$B#M(B" . "$B#M(B")
	 ( "$B#N(B" . "$B#N(B")
	 ( "$B#O(B" . "$B#O(B")
	 ( "$B#P(B" . "$B#P(B")
	 ( "$B#Q(B" . "$B#Q(B")
	 ( "$B#R(B" . "$B#R(B")
	 ( "$B#S(B" . "$B#S(B")
	 ( "$B#T(B" . "$B#T(B")
	 ( "$B#U(B" . "$B#U(B")
	 ( "$B#V(B" . "$B#V(B")
	 ( "$B#W(B" . "$B#W(B")
	 ( "$B#X(B" . "$B#X(B")
	 ( "$B#Y(B" . "$B#Y(B")
	 ( "$B#Z(B" . "$B#Z(B")
;	 ( "$B#[(B" . "$B#[(B")
;	 ( "$B#\(B" . "$B#\(B")
;	 ( "$B#](B" . "$B#](B")
;	 ( "$B#^(B" . "$B#^(B")
;	 ( "$B#_(B" . "$B#_(B")
;	 ( "$B#`(B" . "$B#`(B")
	 ( "$B#a(B" . "$B#a(B")
	 ( "$B#b(B" . "$B#b(B")
	 ( "$B#c(B" . "$B#c(B")
	 ( "$B#d(B" . "$B#d(B")
	 ( "$B#e(B" . "$B#e(B")
	 ( "$B#f(B" . "$B#f(B")
	 ( "$B#g(B" . "$B#g(B")
	 ( "$B#h(B" . "$B#h(B")
	 ( "$B#i(B" . "$B#i(B")
	 ( "$B#j(B" . "$B#j(B")
	 ( "$B#k(B" . "$B#k(B")
	 ( "$B#l(B" . "$B#l(B")
	 ( "$B#m(B" . "$B#m(B")
	 ( "$B#n(B" . "$B#n(B")
	 ( "$B#o(B" . "$B#o(B")
	 ( "$B#p(B" . "$B#p(B")
	 ( "$B#q(B" . "$B#q(B")
	 ( "$B#r(B" . "$B#r(B")
	 ( "$B#s(B" . "$B#s(B")
	 ( "$B#t(B" . "$B#t(B")
	 ( "$B#u(B" . "$B#u(B")
	 ( "$B#v(B" . "$B#v(B")
	 ( "$B#w(B" . "$B#w(B")
	 ( "$B#x(B" . "$B#x(B")
	 ( "$B#y(B" . "$B#y(B")
	 ( "$B#z(B" . "$B#z(B")
;	 ( "$B#{(B" . "$B#{(B")
;	 ( "$B#|(B" . "$B#|(B")
;	 ( "$B#}(B" . "$B#}(B")
;	 ( "$B#~(B" . "$B#~(B")
))

(defvar egg:*alphanumeric-alist* *ku3-alist*)

(defvar *ku4-alist* '(

	 ( "$B$!(B" . "$B$!(B")
	 ( "$B$"(B" . "$B$"(B")
	 ( "$B$#(B" . "$B$#(B")
	 ( "$B$$(B" . "$B$$(B")
	 ( "$B$%(B" . "$B$%(B")
	 ( "$B$&(B" . "$B$&(B")
	 ( "$B$'(B" . "$B$'(B")
	 ( "$B$((B" . "$B$((B")
	 ( "$B$)(B" . "$B$)(B")
	 ( "$B$*(B" . "$B$*(B")
	 ( "$B$+(B" . "$B$+(B")
	 ( "$B$,(B" . "$B$,(B")
	 ( "$B$-(B" . "$B$-(B")
	 ( "$B$.(B" . "$B$.(B")
	 ( "$B$/(B" . "$B$/(B")
	 ( "$B$0(B" . "$B$0(B")
	 ( "$B$1(B" . "$B$1(B")
	 ( "$B$2(B" . "$B$2(B")
	 ( "$B$3(B" . "$B$3(B")
	 ( "$B$4(B" . "$B$4(B")
	 ( "$B$5(B" . "$B$5(B")
	 ( "$B$6(B" . "$B$6(B")
	 ( "$B$7(B" . "$B$7(B")
	 ( "$B$8(B" . "$B$8(B")
	 ( "$B$9(B" . "$B$9(B")
	 ( "$B$:(B" . "$B$:(B")
	 ( "$B$;(B" . "$B$;(B")
	 ( "$B$<(B" . "$B$<(B")
	 ( "$B$=(B" . "$B$=(B")
	 ( "$B$>(B" . "$B$>(B")
	 ( "$B$?(B" . "$B$?(B")
	 ( "$B$@(B" . "$B$@(B")
	 ( "$B$A(B" . "$B$A(B")
	 ( "$B$B(B" . "$B$B(B")
	 ( "$B$C(B" . "$B$C(B")
	 ( "$B$D(B" . "$B$D(B")
	 ( "$B$E(B" . "$B$E(B")
	 ( "$B$F(B" . "$B$F(B")
	 ( "$B$G(B" . "$B$G(B")
	 ( "$B$H(B" . "$B$H(B")
	 ( "$B$I(B" . "$B$I(B")
	 ( "$B$J(B" . "$B$J(B")
	 ( "$B$K(B" . "$B$K(B")
	 ( "$B$L(B" . "$B$L(B")
	 ( "$B$M(B" . "$B$M(B")
	 ( "$B$N(B" . "$B$N(B")
	 ( "$B$O(B" . "$B$O(B")
	 ( "$B$P(B" . "$B$P(B")
	 ( "$B$Q(B" . "$B$Q(B")
	 ( "$B$R(B" . "$B$R(B")
	 ( "$B$S(B" . "$B$S(B")
	 ( "$B$T(B" . "$B$T(B")
	 ( "$B$U(B" . "$B$U(B")
	 ( "$B$V(B" . "$B$V(B")
	 ( "$B$W(B" . "$B$W(B")
	 ( "$B$X(B" . "$B$X(B")
	 ( "$B$Y(B" . "$B$Y(B")
	 ( "$B$Z(B" . "$B$Z(B")
	 ( "$B$[(B" . "$B$[(B")
	 ( "$B$\(B" . "$B$\(B")
	 ( "$B$](B" . "$B$](B")
	 ( "$B$^(B" . "$B$^(B")
	 ( "$B$_(B" . "$B$_(B")
	 ( "$B$`(B" . "$B$`(B")
	 ( "$B$a(B" . "$B$a(B")
	 ( "$B$b(B" . "$B$b(B")
	 ( "$B$c(B" . "$B$c(B")
	 ( "$B$d(B" . "$B$d(B")
	 ( "$B$e(B" . "$B$e(B")
	 ( "$B$f(B" . "$B$f(B")
	 ( "$B$g(B" . "$B$g(B")
	 ( "$B$h(B" . "$B$h(B")
	 ( "$B$i(B" . "$B$i(B")
	 ( "$B$j(B" . "$B$j(B")
	 ( "$B$k(B" . "$B$k(B")
	 ( "$B$l(B" . "$B$l(B")
	 ( "$B$m(B" . "$B$m(B")
	 ( "$B$n(B" . "$B$n(B")
	 ( "$B$o(B" . "$B$o(B")
	 ( "$B$p(B" . "$B$p(B")
	 ( "$B$q(B" . "$B$q(B")
	 ( "$B$r(B" . "$B$r(B")
	 ( "$B$s(B" . "$B$s(B")
;	 ( "$B$t(B" . "$B$t(B")
;	 ( "$B$u(B" . "$B$u(B")
;	 ( "$B$v(B" . "$B$v(B")
;	 ( "$B$w(B" . "$B$w(B")
;	 ( "$B$x(B" . "$B$x(B")
;	 ( "$B$y(B" . "$B$y(B")
;	 ( "$B$z(B" . "$B$z(B")
;	 ( "$B${(B" . "$B${(B")
;	 ( "$B$|(B" . "$B$|(B")
;	 ( "$B$}(B" . "$B$}(B")
;	 ( "$B$~(B" . "$B$~(B")
))

(defvar egg:*hiragana-alist* *ku4-alist*)

(defvar *ku5-alist* '(
	 ( "$B%!(B" . "$B%!(B")
	 ( "$B%"(B" . "$B%"(B")
	 ( "$B%#(B" . "$B%#(B")
	 ( "$B%$(B" . "$B%$(B")
	 ( "$B%%(B" . "$B%%(B")
	 ( "$B%&(B" . "$B%&(B")
	 ( "$B%'(B" . "$B%'(B")
	 ( "$B%((B" . "$B%((B")
	 ( "$B%)(B" . "$B%)(B")
	 ( "$B%*(B" . "$B%*(B")
	 ( "$B%+(B" . "$B%+(B")
	 ( "$B%,(B" . "$B%,(B")
	 ( "$B%-(B" . "$B%-(B")
	 ( "$B%.(B" . "$B%.(B")
	 ( "$B%/(B" . "$B%/(B")
	 ( "$B%0(B" . "$B%0(B")
	 ( "$B%1(B" . "$B%1(B")
	 ( "$B%2(B" . "$B%2(B")
	 ( "$B%3(B" . "$B%3(B")
	 ( "$B%4(B" . "$B%4(B")
	 ( "$B%5(B" . "$B%5(B")
	 ( "$B%6(B" . "$B%6(B")
	 ( "$B%7(B" . "$B%7(B")
	 ( "$B%8(B" . "$B%8(B")
	 ( "$B%9(B" . "$B%9(B")
	 ( "$B%:(B" . "$B%:(B")
	 ( "$B%;(B" . "$B%;(B")
	 ( "$B%<(B" . "$B%<(B")
	 ( "$B%=(B" . "$B%=(B")
	 ( "$B%>(B" . "$B%>(B")
	 ( "$B%?(B" . "$B%?(B")
	 ( "$B%@(B" . "$B%@(B")
	 ( "$B%A(B" . "$B%A(B")
	 ( "$B%B(B" . "$B%B(B")
	 ( "$B%C(B" . "$B%C(B")
	 ( "$B%D(B" . "$B%D(B")
	 ( "$B%E(B" . "$B%E(B")
	 ( "$B%F(B" . "$B%F(B")
	 ( "$B%G(B" . "$B%G(B")
	 ( "$B%H(B" . "$B%H(B")
	 ( "$B%I(B" . "$B%I(B")
	 ( "$B%J(B" . "$B%J(B")
	 ( "$B%K(B" . "$B%K(B")
	 ( "$B%L(B" . "$B%L(B")
	 ( "$B%M(B" . "$B%M(B")
	 ( "$B%N(B" . "$B%N(B")
	 ( "$B%O(B" . "$B%O(B")
	 ( "$B%P(B" . "$B%P(B")
	 ( "$B%Q(B" . "$B%Q(B")
	 ( "$B%R(B" . "$B%R(B")
	 ( "$B%S(B" . "$B%S(B")
	 ( "$B%T(B" . "$B%T(B")
	 ( "$B%U(B" . "$B%U(B")
	 ( "$B%V(B" . "$B%V(B")
	 ( "$B%W(B" . "$B%W(B")
	 ( "$B%X(B" . "$B%X(B")
	 ( "$B%Y(B" . "$B%Y(B")
	 ( "$B%Z(B" . "$B%Z(B")
	 ( "$B%[(B" . "$B%[(B")
	 ( "$B%\(B" . "$B%\(B")
	 ( "$B%](B" . "$B%](B")
	 ( "$B%^(B" . "$B%^(B")
	 ( "$B%_(B" . "$B%_(B")
	 ( "$B%`(B" . "$B%`(B")
	 ( "$B%a(B" . "$B%a(B")
	 ( "$B%b(B" . "$B%b(B")
	 ( "$B%c(B" . "$B%c(B")
	 ( "$B%d(B" . "$B%d(B")
	 ( "$B%e(B" . "$B%e(B")
	 ( "$B%f(B" . "$B%f(B")
	 ( "$B%g(B" . "$B%g(B")
	 ( "$B%h(B" . "$B%h(B")
	 ( "$B%i(B" . "$B%i(B")
	 ( "$B%j(B" . "$B%j(B")
	 ( "$B%k(B" . "$B%k(B")
	 ( "$B%l(B" . "$B%l(B")
	 ( "$B%m(B" . "$B%m(B")
	 ( "$B%n(B" . "$B%n(B")
	 ( "$B%o(B" . "$B%o(B")
	 ( "$B%p(B" . "$B%p(B")
	 ( "$B%q(B" . "$B%q(B")
	 ( "$B%r(B" . "$B%r(B")
	 ( "$B%s(B" . "$B%s(B")
	 ( "$B%t(B" . "$B%t(B")
	 ( "$B%u(B" . "$B%u(B")
	 ( "$B%v(B" . "$B%v(B")
;	 ( "$B%w(B" . "$B%w(B")
;	 ( "$B%x(B" . "$B%x(B")
;	 ( "$B%y(B" . "$B%y(B")
;	 ( "$B%z(B" . "$B%z(B")
;	 ( "$B%{(B" . "$B%{(B")
;	 ( "$B%|(B" . "$B%|(B")
;	 ( "$B%}(B" . "$B%}(B")
;	 ( "$B%~(B" . "$B%~(B")
))

(defvar egg:*katakana-alist* *ku5-alist*)

(defvar *ku6-alist* '(
	 ( "$B&!(B" . "$B&!(B")
	 ( "$B&"(B" . "$B&"(B")
	 ( "$B&#(B" . "$B&#(B")
	 ( "$B&$(B" . "$B&$(B")
	 ( "$B&%(B" . "$B&%(B")
	 ( "$B&&(B" . "$B&&(B")
	 ( "$B&'(B" . "$B&'(B")
	 ( "$B&((B" . "$B&((B")
	 ( "$B&)(B" . "$B&)(B")
	 ( "$B&*(B" . "$B&*(B")
	 ( "$B&+(B" . "$B&+(B")
	 ( "$B&,(B" . "$B&,(B")
	 ( "$B&-(B" . "$B&-(B")
	 ( "$B&.(B" . "$B&.(B")
	 ( "$B&/(B" . "$B&/(B")
	 ( "$B&0(B" . "$B&0(B")
	 ( "$B&1(B" . "$B&1(B")
	 ( "$B&2(B" . "$B&2(B")
	 ( "$B&3(B" . "$B&3(B")
	 ( "$B&4(B" . "$B&4(B")
	 ( "$B&5(B" . "$B&5(B")
	 ( "$B&6(B" . "$B&6(B")
	 ( "$B&7(B" . "$B&7(B")
	 ( "$B&8(B" . "$B&8(B")
;	 ( "$B&9(B" . "$B&9(B")
;	 ( "$B&:(B" . "$B&:(B")
;	 ( "$B&;(B" . "$B&;(B")
;	 ( "$B&<(B" . "$B&<(B")
;	 ( "$B&=(B" . "$B&=(B")
;	 ( "$B&>(B" . "$B&>(B")
;	 ( "$B&?(B" . "$B&?(B")
;	 ( "$B&@(B" . "$B&@(B")
	 ( "$B&A(B" . "$B&A(B")
	 ( "$B&B(B" . "$B&B(B")
	 ( "$B&C(B" . "$B&C(B")
	 ( "$B&D(B" . "$B&D(B")
	 ( "$B&E(B" . "$B&E(B")
	 ( "$B&F(B" . "$B&F(B")
	 ( "$B&G(B" . "$B&G(B")
	 ( "$B&H(B" . "$B&H(B")
	 ( "$B&I(B" . "$B&I(B")
	 ( "$B&J(B" . "$B&J(B")
	 ( "$B&K(B" . "$B&K(B")
	 ( "$B&L(B" . "$B&L(B")
	 ( "$B&M(B" . "$B&M(B")
	 ( "$B&N(B" . "$B&N(B")
	 ( "$B&O(B" . "$B&O(B")
	 ( "$B&P(B" . "$B&P(B")
	 ( "$B&Q(B" . "$B&Q(B")
	 ( "$B&R(B" . "$B&R(B")
	 ( "$B&S(B" . "$B&S(B")
	 ( "$B&T(B" . "$B&T(B")
	 ( "$B&U(B" . "$B&U(B")
	 ( "$B&V(B" . "$B&V(B")
	 ( "$B&W(B" . "$B&W(B")
	 ( "$B&X(B" . "$B&X(B")
;	 ( "$B&Y(B" . "$B&Y(B")
;	 ( "$B&Z(B" . "$B&Z(B")
;	 ( "$B&[(B" . "$B&[(B")
;	 ( "$B&\(B" . "$B&\(B")
;	 ( "$B&](B" . "$B&](B")
;	 ( "$B&^(B" . "$B&^(B")
;	 ( "$B&_(B" . "$B&_(B")
;	 ( "$B&`(B" . "$B&`(B")
;(a)	 ( "$B&a(B" . "$B&a(B")
;(b)	 ( "$B&b(B" . "$B&b(B")
;(c)	 ( "$B&c(B" . "$B&c(B")
;(d)	 ( "$B&d(B" . "$B&d(B")
;(e)	 ( "$B&e(B" . "$B&e(B")
;(f)	 ( "$B&f(B" . "$B&f(B")
;(g)	 ( "$B&g(B" . "$B&g(B")
;(h)	 ( "$B&h(B" . "$B&h(B")
;(i)	 ( "$B&i(B" . "$B&i(B")
;(j)	 ( "$B&j(B" . "$B&j(B")
;(k)	 ( "$B&k(B" . "$B&k(B")
;(l)	 ( "$B&l(B" . "$B&l(B")
;(m)	 ( "$B&m(B" . "$B&m(B")
;(n)	 ( "$B&n(B" . "$B&n(B")
;(o)	 ( "$B&o(B" . "$B&o(B")
;(p)	 ( "$B&p(B" . "$B&p(B")
;(q)	 ( "$B&q(B" . "$B&q(B")
;(r)	 ( "$B&r(B" . "$B&r(B")
;(s)	 ( "$B&s(B" . "$B&s(B")
;(t)	 ( "$B&t(B" . "$B&t(B")
;(u)	 ( "$B&u(B" . "$B&u(B")
;(v)	 ( "$B&v(B" . "$B&v(B")
;(w)	 ( "$B&w(B" . "$B&w(B")
;(x)	 ( "$B&x(B" . "$B&x(B")
;(y)	 ( "$B&y(B" . "$B&y(B")
;(z)	 ( "$B&z(B" . "$B&z(B")
;	 ( "$B&{(B" . "$B&{(B")
;	 ( "$B&|(B" . "$B&|(B")
;	 ( "$B&}(B" . "$B&}(B")
;	 ( "$B&~(B" . "$B&~(B")
))

(defvar egg:*greek-alist* *ku6-alist*)

(defvar *ku7-alist* '(
	 ( "$B'!(B" . "$B'!(B")
	 ( "$B'"(B" . "$B'"(B")
	 ( "$B'#(B" . "$B'#(B")
	 ( "$B'$(B" . "$B'$(B")
	 ( "$B'%(B" . "$B'%(B")
	 ( "$B'&(B" . "$B'&(B")
	 ( "$B''(B" . "$B''(B")
	 ( "$B'((B" . "$B'((B")
	 ( "$B')(B" . "$B')(B")
	 ( "$B'*(B" . "$B'*(B")
	 ( "$B'+(B" . "$B'+(B")
	 ( "$B',(B" . "$B',(B")
	 ( "$B'-(B" . "$B'-(B")
	 ( "$B'.(B" . "$B'.(B")
	 ( "$B'/(B" . "$B'/(B")
	 ( "$B'0(B" . "$B'0(B")
	 ( "$B'1(B" . "$B'1(B")
	 ( "$B'2(B" . "$B'2(B")
	 ( "$B'3(B" . "$B'3(B")
	 ( "$B'4(B" . "$B'4(B")
	 ( "$B'5(B" . "$B'5(B")
	 ( "$B'6(B" . "$B'6(B")
	 ( "$B'7(B" . "$B'7(B")
	 ( "$B'8(B" . "$B'8(B")
	 ( "$B'9(B" . "$B'9(B")
	 ( "$B':(B" . "$B':(B")
	 ( "$B';(B" . "$B';(B")
	 ( "$B'<(B" . "$B'<(B")
	 ( "$B'=(B" . "$B'=(B")
	 ( "$B'>(B" . "$B'>(B")
	 ( "$B'?(B" . "$B'?(B")
	 ( "$B'@(B" . "$B'@(B")
	 ( "$B'A(B" . "$B'A(B")
;(1)	 ( "$B'B(B" . "$B'B(B")
;(2)	 ( "$B'C(B" . "$B'C(B")
;(3)	 ( "$B'D(B" . "$B'D(B")
;(4)	 ( "$B'E(B" . "$B'E(B")
;(5)	 ( "$B'F(B" . "$B'F(B")
;(6)	 ( "$B'G(B" . "$B'G(B")
;(7)	 ( "$B'H(B" . "$B'H(B")
;(8)	 ( "$B'I(B" . "$B'I(B")
;(9)	 ( "$B'J(B" . "$B'J(B")
;(10)	 ( "$B'K(B" . "$B'K(B")
;(11)	 ( "$B'L(B" . "$B'L(B")
;(12)	 ( "$B'M(B" . "$B'M(B")
;(13)	 ( "$B'N(B" . "$B'N(B")
;(14)	 ( "$B'O(B" . "$B'O(B")
;(15)	 ( "$B'P(B" . "$B'P(B")
	 ( "$B'Q(B" . "$B'Q(B")
	 ( "$B'R(B" . "$B'R(B")
	 ( "$B'S(B" . "$B'S(B")
	 ( "$B'T(B" . "$B'T(B")
	 ( "$B'U(B" . "$B'U(B")
	 ( "$B'V(B" . "$B'V(B")
	 ( "$B'W(B" . "$B'W(B")
	 ( "$B'X(B" . "$B'X(B")
	 ( "$B'Y(B" . "$B'Y(B")
	 ( "$B'Z(B" . "$B'Z(B")
	 ( "$B'[(B" . "$B'[(B")
	 ( "$B'\(B" . "$B'\(B")
	 ( "$B'](B" . "$B'](B")
	 ( "$B'^(B" . "$B'^(B")
	 ( "$B'_(B" . "$B'_(B")
	 ( "$B'`(B" . "$B'`(B")
	 ( "$B'a(B" . "$B'a(B")
	 ( "$B'b(B" . "$B'b(B")
	 ( "$B'c(B" . "$B'c(B")
	 ( "$B'd(B" . "$B'd(B")
	 ( "$B'e(B" . "$B'e(B")
	 ( "$B'f(B" . "$B'f(B")
	 ( "$B'g(B" . "$B'g(B")
	 ( "$B'h(B" . "$B'h(B")
	 ( "$B'i(B" . "$B'i(B")
	 ( "$B'j(B" . "$B'j(B")
	 ( "$B'k(B" . "$B'k(B")
	 ( "$B'l(B" . "$B'l(B")
	 ( "$B'm(B" . "$B'm(B")
	 ( "$B'n(B" . "$B'n(B")
	 ( "$B'o(B" . "$B'o(B")
	 ( "$B'p(B" . "$B'p(B")
	 ( "$B'q(B" . "$B'q(B")
;i	 ( "$B'r(B" . "$B'r(B")
;ii	 ( "$B's(B" . "$B's(B")
;iii	 ( "$B't(B" . "$B't(B")
;iv	 ( "$B'u(B" . "$B'u(B")
;v	 ( "$B'v(B" . "$B'v(B")
;vi	 ( "$B'w(B" . "$B'w(B")
;vii	 ( "$B'x(B" . "$B'x(B")
;viii	 ( "$B'y(B" . "$B'y(B")
;ix	 ( "$B'z(B" . "$B'z(B")
;x	 ( "$B'{(B" . "$B'{(B")
;|	 ( "$B'|(B" . "$B'|(B")
;'	 ( "$B'}(B" . "$B'}(B")
;''	 ( "$B'~(B" . "$B'~(B")
))

(defvar egg:*russian-alist* *ku7-alist*)

(defvar *ku8-alist* '(
	 ( "$B(!(B" . "$B(!(B")
	 ( "$B("(B" . "$B("(B")
	 ( "$B(#(B" . "$B(#(B")
	 ( "$B($(B" . "$B($(B")
	 ( "$B(%(B" . "$B(%(B")
	 ( "$B(&(B" . "$B(&(B")
	 ( "$B('(B" . "$B('(B")
	 ( "$B(((B" . "$B(((B")
	 ( "$B()(B" . "$B()(B")
	 ( "$B(*(B" . "$B(*(B")
	 ( "$B(+(B" . "$B(+(B")
	 ( "$B(,(B" . "$B(,(B")
	 ( "$B(-(B" . "$B(-(B")
	 ( "$B(.(B" . "$B(.(B")
	 ( "$B(/(B" . "$B(/(B")
	 ( "$B(0(B" . "$B(0(B")
	 ( "$B(1(B" . "$B(1(B")
	 ( "$B(2(B" . "$B(2(B")
	 ( "$B(3(B" . "$B(3(B")
	 ( "$B(4(B" . "$B(4(B")
	 ( "$B(5(B" . "$B(5(B")
	 ( "$B(6(B" . "$B(6(B")
	 ( "$B(7(B" . "$B(7(B")
	 ( "$B(8(B" . "$B(8(B")
	 ( "$B(9(B" . "$B(9(B")
	 ( "$B(:(B" . "$B(:(B")
	 ( "$B(;(B" . "$B(;(B")
	 ( "$B(<(B" . "$B(<(B")
	 ( "$B(=(B" . "$B(=(B")
	 ( "$B(>(B" . "$B(>(B")
	 ( "$B(?(B" . "$B(?(B")
	 ( "$B(@(B" . "$B(@(B")
;	 ( "$B(A(B" . "$B(A(B")
;	 ( "$B(B(B" . "$B(B(B")
;	 ( "$B(C(B" . "$B(C(B")
;	 ( "$B(D(B" . "$B(D(B")
;	 ( "$B(E(B" . "$B(E(B")
;*	 ( "$B(F(B" . "$B(F(B")
;*	 ( "$B(G(B" . "$B(G(B")
;*	 ( "$B(H(B" . "$B(H(B")
;*	 ( "$B(I(B" . "$B(I(B")
;*	 ( "$B(J(B" . "$B(J(B")
;*	 ( "$B(K(B" . "$B(K(B")
;*	 ( "$B(L(B" . "$B(L(B")
;*	 ( "$B(M(B" . "$B(M(B")
;*	 ( "$B(N(B" . "$B(N(B")
;*	 ( "$B(O(B" . "$B(O(B")
;*	 ( "$B(P(B" . "$B(P(B")
;*	 ( "$B(Q(B" . "$B(Q(B")
;*	 ( "$B(R(B" . "$B(R(B")
;*	 ( "$B(S(B" . "$B(S(B")
;*	 ( "$B(T(B" . "$B(T(B")
;*	 ( "$B(U(B" . "$B(U(B")
;*	 ( "$B(V(B" . "$B(V(B")
;*	 ( "$B(W(B" . "$B(W(B")
;*	 ( "$B(X(B" . "$B(X(B")
;*	 ( "$B(Y(B" . "$B(Y(B")
;*	 ( "$B(Z(B" . "$B(Z(B")
;*	 ( "$B([(B" . "$B([(B")
;*	 ( "$B(\(B" . "$B(\(B")
;*	 ( "$B(](B" . "$B(](B")
;*	 ( "$B(^(B" . "$B(^(B")
;*	 ( "$B(_(B" . "$B(_(B")
;*	 ( "$B(`(B" . "$B(`(B")
;*	 ( "$B(a(B" . "$B(a(B")
;*	 ( "$B(b(B" . "$B(b(B")
;*	 ( "$B(c(B" . "$B(c(B")
;*	 ( "$B(d(B" . "$B(d(B")
;*	 ( "$B(e(B" . "$B(e(B")
;*	 ( "$B(f(B" . "$B(f(B")
;*	 ( "$B(g(B" . "$B(g(B")
;*	 ( "$B(h(B" . "$B(h(B")
;*	 ( "$B(i(B" . "$B(i(B")
;*	 ( "$B(j(B" . "$B(j(B")
;*	 ( "$B(k(B" . "$B(k(B")
;*	 ( "$B(l(B" . "$B(l(B")
;*	 ( "$B(m(B" . "$B(m(B")
;*	 ( "$B(n(B" . "$B(n(B")
;*	 ( "$B(o(B" . "$B(o(B")
;*	 ( "$B(p(B" . "$B(p(B")
;*	 ( "$B(q(B" . "$B(q(B")
;*	 ( "$B(r(B" . "$B(r(B")
;*	 ( "$B(s(B" . "$B(s(B")
;*	 ( "$B(t(B" . "$B(t(B")
;*	 ( "$B(u(B" . "$B(u(B")
;*	 ( "$B(v(B" . "$B(v(B")
;*	 ( "$B(w(B" . "$B(w(B")
;*	 ( "$B(x(B" . "$B(x(B")
;*	 ( "$B(y(B" . "$B(y(B")
;*	 ( "$B(z(B" . "$B(z(B")
;	 ( "$B({(B" . "$B({(B")
;	 ( "$B(|(B" . "$B(|(B")
;	 ( "$B(}(B" . "$B(}(B")
;	 ( "$B(~(B" . "$B(~(B")
))

(defvar egg:*keisen-alist* *ku8-alist*)

(defun make-all-jis-code-alist ()
  (let ((result nil) (ku 116))
    (while (<  32 ku)
      (let ((ten 126))
	(while (< 32 ten)
	  (setq result (cons 
			(let ((str (make-string 1 0)))
			  (aset str 0 (make-char (find-charset 'japanese-jisx0208)  ku ten))
			  (cons str str))
			result))
	  (setq ten (1- ten))))
      (setq ku (1- ku)))
    result))

(defun make-jis-first-level-code-alist ()
  (let ((result nil) (ku 79))
    (while (<=  48 ku)
      (let ((ten 126))
	(while (<= 33 ten)
	  (setq result (cons 
			(let ((str (make-string 1 0)))
			  (aset str 0 (make-char (find-charset 'japanese-jisx0208)  ku ten))
			  (cons str str))
			result))
	  (setq ten (1- ten))))
      (setq ku (1- ku)))
    result))

(defun make-jis-second-level-code-alist ()
  (let ((result nil) (ku 116))
    (while (<= 80 ku)
      (let ((ten 126))
	(while (<= 33 ten)
	  (setq result (cons 
			(let ((str (make-string 1 0))) ; by T.Shingu
			  (aset str 0 (make-char (find-charset 'japanese-jisx0208)  ku ten))
			  (cons str str))
			result))
	  (setq ten (1- ten))))
      (setq ku (1- ku)))
    result))

(defun make-jis-hojo-kanji-code-alist ()
  (let ((result nil) (ku 109))
    (while (<=  34 ku)
      (let ((ten 126))
	(while (<= 33 ten)
	  (setq result (cons 
			(let ((str (make-string 1 0)))
			  (aset str 0 (make-char (find-charset 'japanese-jisx0212)  ku ten))
			  (cons str str))
			result))
	  (setq ten (1- ten))))
      (setq ku (1- ku)))
    result))

;;;(defvar egg:*all-jis-code-alist* (make-all-jis-code-alist))

(defvar egg:*first-level-alist*  (make-jis-first-level-code-alist))
(defvar egg:*second-level-alist* (make-jis-second-level-code-alist))
(defvar egg:*hojo-kanji-alist* (make-jis-hojo-kanji-code-alist))

(defvar *symbol-input-menu*
  (list 'menu "$B5-9fF~NO(B:"
	(list 
	 (cons "JIS$BF~NO(B"
	       '(jis-code-input))
	 (cons "$B5-9f(B"
	       (list 'menu "$B5-9f(B:" egg:*symbol-alist*))
	 (cons "$B1Q?t;z(B"
	       (list 'menu "$B1Q?t;z(B:" egg:*alphanumeric-alist*))
	 (cons "$B$R$i$,$J(B"
	       (list 'menu "$B$R$i$,$J(B:" egg:*hiragana-alist*))
	 (cons "$B%+%?%+%J(B"
	       (list 'menu "$B%+%?%+%J(B:" egg:*katakana-alist*))
	 (cons "$B%.%j%7%cJ8;z(B"
	       (list 'menu "$B%.%j%7%cJ8;z(B:" egg:*greek-alist*))
	 (cons "$B%m%7%"J8;z(B"
	       (list 'menu "$B%m%7%"J8;z(B:" egg:*russian-alist*))
	 (cons "$B7S@~(B"
	       (list 'menu "$B7S@~(B:" egg:*keisen-alist*))
	 ;; 92.7.8 by T.Shingu
	 (cons "$BIt<sF~NO(B"
	       '(busyu-input))
	 (cons "$B2h?tF~NO(B"
	       '(kakusuu-input))
	 ;; end of patch
	 (cons "$BBh0l?e=`(B"
	       (list 'menu "$BBh0l?e=`(B:" egg:*first-level-alist*))
	 (cons "$BBhFs?e=`(B"
	       (list 'menu "$BBhFs?e=`(B:" egg:*second-level-alist*))
	 (cons "$BJd=u4A;z(B"
	       (list 'menu "$BJd=u4A;z(B:" egg:*hojo-kanji-alist*))
	;; (cons "$BA4%3!<%I!J>/$7;~4V$,3]$+$j$^$9!#!K(B"
	;;       (list 'menu "$BA4%3!<%I(B:" egg:*all-jis-code-alist*))
	 )))
