(require 'quail)
;; # HANYU input table for mule
;; AUTHOR:      Chue Chi To ($(GUAJ5dp(B)
;; DATE:        28 NOV 1994
;; ENCODE:	BIG5
;; MULTICHOICE:	YES
;; PROMPT:	$(GDcEFrSD+!Jv|Mx!K(B
;; # define keys
;; VALIDINPUTKEY:	abcdefghijklmnopqrstuvwxyz/?;:'"\|[{]}`~!@#$%^&*()-_=+
;; SELECTKEY:	1\040
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	.>
;; MOVELEFT:	,<
;; REPEATKEY:	\020\022
;; # the following line must not be removed
;; BEGINDICTIONARY
(quail-define-package
 "chinese-cns-quick" "Chinese-CNS" "$(Gv|(BC"
 t
 "$(GDcEFrSD+!Jv|Mx!K(BCNS

	$(GiGk#v|MxrSD+uomu(B

   [Q $(GEC(B] [W $(GFp(B] [E $(GEU(B] [R $(GDG(B] [T $(GE=(B] [Y $(GD3(B] [U $(GDT(B] [I $(GEA(B] [O $(GD)(B] [P $(GE@(B]

    [A $(GEJ(B] [S $(GDS(B] [D $(GEM(B] [F $(GEV(B] [G $(GDH(B] [H $(GHL(B] [J $(GD2(B] [L $(GDc(B]
	
      [Z  ] [X $(GyE(B] [C $(GOZ(B] [V $(GDL(B] [B $(GEL(B] [N $(GD^(B] [M $(GD!(B] 
"
 '(
  ("." . quail-next-translation-block)
  ("," . quail-prev-translation-block)
  )
 nil nil)

(quail-define-rules
;; #
("a"    "$(GEJEK(B")
("aa"    "$(G_^_`bfd<Myso$(H`;'-CK[S[W[Z(B")
("ab"    "$(G[)_]bg$(H*u5lJ^$(GM|$(HPoeVah(B")
("ac"    "$(Gw`wnx:{B|O$(H<JCJWA$(Gi%$(HjT(B")
("ad"    "$(GQQbe$(H$:$(GN;$(H."d:CEUP(B")
("ae"    "$(G^2d>d@m3spY7x;$(H`?'''.*x5n[X(B")
("af"    "$(G_bdyd|pru|w_$(H'r'y<H=iCGDgPlWE\1agh}j~k3$(G__$(Hk4p8m)nio~p!(B")
("ag"    "$(GbXbck\vL$(H.M/U$(GMv$(H:ih~<GUQW>[Y`=ge(B")
("ah"    "$(G]pdBMxl`$(HHS'('1*p5o<IBQ(B")
("ai"    "$(GUkbhk]k_QVpq$(HPn$;*mB{(B")
("aj"    "$(GJTd=d?jLppzO{<$(H$9:*<E$(GH.$(HCLWFHVPmWB(B")
("ak"    "$(GQPbbu{$(H$<'&'*=q$(GN"$(HCFp9CMPpW?[V\}`>jS(B")
("al"    "$(GM{N!I;_\$(HWC$(GgP$(H*q*w@xNW(B")
("am"    "$(GM}QSSmUqdAi$$(H:)J]$(GFY$(HWGjU[Td8(B")
("an"    "$(GTJ$(H"N$(GO\$(H'0AA*n(B")
("ao"    "$(GQR$(Hat$(GQWUrX`dXk[wa$(H'+'J*sPjPkaf(B")
("ap"    "$(GY2_,Mz|:$(Hh|*o(B")
("aq"    "$(Gu}$(HCHlYWDdN(B")
("ar"    "$(GUpYB[&_ck^k`m4QOod$(H_X$(Guzu~$(H*t/XHTTF(B")
("as"    "$(G[+QTyq$(HA@'%')*y/V/W3p(B")
("at"    "$(GQUbdeAw^N#yC$(Hd9HUJ_W@(B")
("au"    "$(GP#QMR_UnY([%oepnE;$(H#fgd$='/*r5k5m<D<F<KABD%D'K3[U`<(B")
("av"    "$(GUm['HbdC$(HlZ$(Gzo$(HUO(B")
("aw"    "$(GUo$(Hl[(B")
("ax"    "$(Gro$(HUR(B")
("ay"    "$(G[($(H[R(B")
("b"    "$(GEL(B")
("ba"    "$(GW[$(HbB$(GeGfno/u&y%$(H-&7P?0EEF9YTZc]i(B")
("bb"    "$(GO0Xl\heBfsjRp6N%qP$(Hjr$(GuU|T$(H(P9T>@>C>DEFF?M0XcZ^]h^[bif&(B")
("bc"    "$(GL&TBaOmymzqxuSuVw-{u|D$(H,z$(GKJ$(H@LpbN<TRXbYW[f]jdRf%gtiClBln(B")
("bd"    "$(GNhOY\i`zeIeJmwwx$(H%M(9-!11$(GIw$(H3%bA7L8OF<G`TV^X(B")
("be"    "$(GN$O2O4R;]Icxf(f)ktmZnN$(H,E5q8K8S$(GL?$(H?2qxEBEDFAFCL)N;RDU{Z]^Wbjd@iDiF(B")
("bf"    "$(G\B`SNfk5$(Hq($(GnQqQqltJtKy\zV{O}E$(HEAL,M,TWV9XkYCYYY\Y]]k^Fbke!f'fLhThUiak)k2k6m*(B")
("bg"    "$(G\:eDeMf'k1nLpJqOrstFt}vmwf$(H207M$(GK>$(H8Mo:8P8Q?4B-ECF>H[S'S-WHY_i`knmr(B")
("bh"    "$(GRbRcX@XBZ3Z4f#nOo2J/qy$(Hc`$x%$-'-(17>?(B")
("bi"    "$(GO3P%TAVwXAaLjSo-t:uW|V}/}3$(H$t$w,C$(GK<$(H,wl5,y-%/18N>EHoMzS)S,Z4^YfKfpgxjt(B")
("bj"    "$(GK;S[aPK8eK$(Hg6$(Gfpy0$(H(:(N3$7O>B?6E?F=HnS(TPTQXiYXZb]g]ldcg3(B")
("bk"    "$(GUuW^WaZuaKisnMtH$(H"i+~,{-)$(GTq$(H7Kq)CNEGF:L*Xj[v_b`pc\g4ix(B")
("bl"    "$(Gf&go$(H(O,I,|14$(GS.$(H2/Y^3<3>@u@{@|H+N=OBV=(B")
("bm"    "$(GK=S)S2aJf$iuo,$(H!*,G-#$(GEb$(H12js8L@O@QFFG^M$RGS*^U(B")
("bn"    "$(GGHHZI4K1P,TKW\D}b1$(Hf#$(Gks$(H!h!}#/$v(;(L(M,x10223o7N7U8T9UFDL.Z_(B")
("bo"    "$(GVz\<]HaSb:eCeEfws0u%vMvoxT$(H,~-*/Y/Z152.218JFBL+$(GTC$(HXf^V]m(B")
("bp"    "$(Gf%s^t|ylyrzz$(H?5M/Xh[x$(GVy$(H_c(B")
("bq"    "$(GS'\;aUf!FntI$(H]f7TG_YU(B")
("br"    "$(GLRS/W_Wbb0b2b4fofvmvo*o~qws1u$uNuQvnzE$(H#,)K*{-$181;7Q?1EHFGM.TSZd$(GGQ$(Hc[l@h.(B")
("bs"    "$(GHYI7O8Wg^9jP{.{p$(H,D,H-"16[y^Z$(GEy$(HiE(B")
("bt"    "$(GFwWf\mmxtGz/Eu|($(HlA$(G|U$(HGYM+M-[w_d(B")
("bu"    "$(GFxKDKfM%O1O5R]FoS0$(Hp($(GWZW`\k]<aIaQc*eLk2z-$(H'3*z,B,F,}3N8I8R>>>A>F?/@M@NE>E@FEL2N.SgXdYVY[Z`_Gg!mUnQ(B")
("bv"    "$(GO,Wc\9\nItaN$(Hc]$(Gf"jTk4o.sOu#xi{H$(H(8132-7R?3B@F@S+Xe(B")
("bw"    "$(Girf*rI$(HYZF;(B")
("bx"    "$(GWjw,(B")
("by"    "$(GaRDe$(H8U(B")
("c"    "$(GOZ(B")
("ca"    "$(G_d$(Hj<$(GgHrc$(HA:Nw[1[F[J[N_~j8(B")
("cb"    "$(GgBoZo[rjwYw[y6},$(HA=H6HJHONeU7$(Gb\$(H[/qaUK[G[L[O`.d-gLj@jNlSn7n=(B")
("cc"    "$(G]NgcgdoawUwX{5}=$(HGXH:[D$(GX^$(H[IpX`6`Tc~gYj>jBjIjKn6oY(B")
("cd"    "$(GrhwW|L$(H:#:&HPN_NxN|N~$(GkT$(HUAn<[,[7`0`2d'd.gSjMjPlRlU(B")
("ce"    "$(GgMrguluvuwy;|M$(HA2A;NrU.U1U4$(Gba$(HUGr1[5[A[C`#`&`'d(gVgZjHlWn8o[(B")
("cf"    "$(GuuwVy=y>|K$(H'zA+$(Gup$(HV7r/[.[3[=d"d0dye%gPg[j=jEm6(B")
("cg"    "$(GkVo_obriuty:yAzL{7}?$(H#L$(GbZ$(H:%qdH5NfNtO!U9[B`(`3gUqb(B")
("ch"    "$(GJ.bYgKoYrfux$(H:!:'A>UId/$(GE!$(HcY'"gQg`j5jLlV(B")
("ci"    "$(G]j]l]ogIgJrdy?{:{{$(H9P9~A.A5A9H7HD$(GD|$(HHKr7N}U,U8U<_;_yd!d#gRg]g_j9jFn?qAqD(B")
("cj"    "$(GoXo`ocy9{9}5$(H9zA6$(GX\$(HNboZNd[;[K`/d5g^j:jA(B")
("ck"    "$(GgAkOumuqy8$(H'"5i9|A0HCNgU5`)g0gTj6$(GEX$(Hj;r0(B")
("cl"    "$(GMtP3]me%gCgO$(H">$(GD9$(H%,_{3AA/A3NpT}UC(B")
("cm"    "$(GWQ]n$(HqC$(Gb]g@usy7$(HH8H@HBHNNsNvTNUE[0[<`-d%d,gN(B")
("cn"    "$(GVUX[X]b_$(H,:-a3E3G$(GP'$(H9}n:A7N`NjNqUH[8]\`"(B")
("co"    "$(G`#b`r_$(HA4HEHRNhU2[2`%c}gMgWjCjO$(G[C$(HlNqElPlX(B")
("cp"    "$(Gllrl$(H9{A*A-H4H=HINcU3UBW.[H`$$(GMC$(Ha[pYd)d6g\jJlMoRoX(B")
("cq"    "$(H9QHG$(Guo$(HN{lQ`1j7(B")
("cr"    "$(G]kg?gEgGkRkSkUo]rarkrmurwSw\w]$(HH9H>H?HFHHHL$(GKG$(HN8pZNaNkNlNmNuU0U:U=U@UJ[+[6[9[E`!`7`8d$d+gOjQ(B")
("cs"    "$(Gb[gLkPo\uywT{;$(H3F:$A)NnNyjGlT$(GD{$(Hqc(B")
("ct"    "$(GkYrbwZ{||o$(H#r$(GRY$(HA,n>U/[4d&d2j?(B")
("cu"    "$(GJ%Nib^gFkZo^reI+y5$(Hd4$(GzM$(H-b0"A1A8A<H<HANiNzU?UF[-[>[?[M`9d3(B")
("cv"    "$(GkXr`y@}+$(H:"H;N^U-$(GkQ$(HU6o\UD[@_z_}`4`5d1lO(B")
("cw"    "$(GgNgDrn$(HqB$(Gun{6{8$(Hd*jD(B")
("cx"    "$(H[:$(GzN$(H_|n;(B")
("cy"    "$(GX_$(HU;HMHQ(B")
("d"    "$(GEM(B")
("da"    "$(GQi_}dHm;suN+x?$(HeW/n/t<Y<xCUE;JiK%K*P|WIWLWYal(B")
("db"    "$(GQc[/[3_kQX_l$(HmS$(G_{_|i)i,pxp{p}$(H"U':++/e/i6064<f<qC]ChCjCnCsCxJpJrPqPrPyQ*Q6]&]+akapgo(B")
("dc"    "$(GdOi+kjpwrJvNvPx=$(H"W+.+0+9/d6/<Q<_JfJ|K$Q,TUWMWNWW]%aqebo/$(G_v$(Hp`(B")
("dd"    "$(GN/V,[4_o_pi-mCsx$(H$>$D$E+3/g6"6)6768<`<a<p<s<t<zCQCWC[C\JwQ%WbWd]"$(GJW$(H`Ni(dOdPe](B")
("de"    "$(GN.N2[:[B_u_ym5v"$(H'F'G+&5y6'$(GFv$(H<TmT<W<]<uC_CcCfJnQ!Q"]*areXeY(B")
("df"    "$(GN1Q]\T_i`OdUe[m:mBq!$(H+766<S<mCeJ{K!K"K#K'PwQ3WTWZhM$(GN0$(Hh]q"k+nop:pr(B")
("dg"    "$(GN3QZUzU}V.[8_zi.vSvU{b$(H'9/j44$(GJ[$(H5to15{5~6%6269CtCyJ}Q1Q5WJWf]$mR(B")
("dh"    "$(GJYJ^N:QeZ2[.dN}H$(H'7'?*}$(GD_$(H6(]463<kCoP}Q$We(B")
("di"    "$(GJZJaN4[1_qbydRi2i4pspyq"vTx<$(H$C$G'<$(GDP$(H'Aq$+5+C9/JlJsMxPuQ.WR]#]6k\k^l4nAq!(B")
("dj"    "$(GJ_N6N8Ql[0[2F]_r$(Hl_$(GdIdPi0m6pu$(H(7+!/r65<d<nCRJxK(O1PxQ#Q2WPWQWX]'amdMgq(B")
("dk"    "$(GN7UwZy[6dJm<m>pzss$(H!;$A$(GJ\$(H+-W^+;/\=}CTCgCuJeJqJvO2Q/(B")
("dl"    "$(GN5QkQm[;dEdLm7sv$(H"S+?/b/h/p5z6+$(GJV$(H6.\C9n9o<y@y(B")
("dm"    "$(GJ`QdQgQnU{V!_xdKi/plsq$(H'B'D+$+*+>/`$(GF[$(H6,r+8B<M<U<X<cCOCYCdJgPtPzP~Q4]1i#k](B")
("dn"    "$(GN&N9L.P*$(H]2$(GV/V0dTvR$(H!K"P"Q"T$F'I+)/a/f5|<jCPCqCzW`(B")
("do"    "$(GQaUxV+dGmAptp|stvO$(H'6'=+2+6+A/q$(GKt$(H5uec6:<Z<[<b<oCbI#PvP{WS]!].]3an(B")
("dp"    "$(GN-_w$(Hi!$(Gcws`y_|;$(H"V$@'@'H*|+(/_;l<e<|CwW%Wc\~(B")
("dq"    "$(G_sx8$(H'E*~C=$(GSt$(HCZk_CvFHWKWU]((B")
("dr"    "$(GQ_QbQhU~V(V*[5_h_mdWi(i3JXi5$(Hi'$(Gm9szx>y~zr$(H+%+'+<+=/m5w5x6$6&6-61<N<\<r<w<{C^CmCrJdJmU]W]ajaoe[(B")
("ds"    "$(GN'QjdQi&i'$(H"R$?'>+"+,+@+D/^/s5}PsW_$(GH5$(H])e\(B")
("dt"    "$(G[7dSpvvQ$(H'4+#+:$(GQ`$(H/[i$5s6*JkJtJ~Q(gp(B")
("du"    "$(GF^$(Hea$(GJ]N(N,R^V"V-Vs[=[AdMdVi8p~q#ys}#$(H$B'5'8';'C+/+1+4/k6#<R<^CiJyK)Q)Q+Q7]/(B")
("dv"    "$(GYb_tU|m=$(Hk`$(Gzp$(H/]5r5v6!<O<VCXC`CaCpJcJjK&WOWa`Oasi"(B")
("dw"    "$(GQf_ni1srswzq$(H/c<gCSCV$(GN)$(HE,q#Q0Wg]0eZ(B")
("dx"    "$(GyI$(HJu$(Gm8$(HWVi%ai(B")
("dy"    "$(GQo[<$(H+B/l$(GH6$(H<P]5<vJo(B")
("e"    "$(GEU(B")
("ea"    "$(GN\R/[_`IiOmQmX$(H$S'O6T$(GJr$(H6[b#6c=-=9=TDGKHQ^Q_QhX%(B")
("eb"    "$(GR+V<V>VBVI[R[d[h`9`;`?d_dddli?i@iEJliH$(Hkc$(GiImRmSt,yu|`$(H$U050:6V=.=?=F=QD+D4DODPKBKMKPKSKUQLQTW|X.]=a~b%eli3(B")
("ec"    "$(GQ{[S[mdei=iDmVm\q'q2t#v\xBxE$(H!a'P'V060D6H6R=C$(GNU$(HD.qpD/DKQFQGQKQcU>X'`*`+`:awb"emeogsi*i,i6mYp=q[(B")
("ed"    "$(GHAJoN]QYQpV%VE[-[J[T[e[g`,`2drekiWmUq)}2$(H+V+Z0-040?0B0H6\6b6g=6=SD2D7DLDM$(GH?$(HKIb$KTQOQWX0X1(B")
("ee"    "$(GJwNDNLV?VF[V[``.`KiBiJiPmLq(t-v^$(H$Z$(GJt$(H$[i8'd6J6U<9=,D?DDK6K7K<QYQi]<]Da|b!ek(B")
("ef"    "$(G[K[I[M$(Hpj$(GdcdfiFiQiUmMmNm]q=t.v1vYw~$(H'T+d=1=4=7=I=KD0D3DHKWK^QPQSQVQ]QbX*]EaxeihPi1i7(B")
("eg"    "$(GNCVCVL[U[b[f`3`:`LJm`M$(HmV$(GcUdimJmWt)t0zt{e$(H!P+Q+S+c.R096_:u=VB7D>DFKNKXK[WtX-aya{ejkdkekf(B")
("eh"    "$(GJxNFV;VD`=`@iVmT$(H$P$(GJg$(H$Wr?'_'b0KKCKJK_X!X)(B")
("ei"    "$(GHBHFHGJpNNNONaX)[Q[X`EdgDFiX$(Hpc$(Gm[q,t'v]$(H"]"_$N$R'Q'^0*0L6`=MD6D8D<D@DIK?KDQHQ`WzX(]A]Ra}eri/i2p;(B")
("ej"    "$(GH>HENMR![kFd`B$(Ho3$(G`Dd`dmi<iNmPq+$(H$\'S076I6S=:=<=WDBK9KEQQQeWvWx]>]Fkb(B")
("ek"    "$(GJvJ{NWR'[L[a`1`GdqdsiCiRq.q/yv$(H"\$Q'X+O+]+`+g$(GJn$(H+kW~010>0@0C0G6a=2=;=>=D=P=ZD=K>KOKVKZQIQRQ\Qf(B")
("el"    "$(GK!N`QzVA[\[]`HiL$(H"`$X+e0(0,036QK:QJWy$(GJs$(HX#]C(B")
("em"    "$(GJ|NTN_R*V=[H`/`4djq1t*xCxD$(H$T'U'i$(GH@$(H'lmX'n6G6K6N6f=G=XD1DAK;K\QMQZeni0(B")
("en"    "$(GJuJzNPQ~VN[W`-`A`Ct"Fev_$(Hi.$(Gx@}$$(H!b"^'e'f+R+i+m.-0<6X=/KAKY(B")
("eo"    "$(GN[R.VK[liAiGiKt%t&t/$(H']'`08$(GNV$(H6Ded6M="=ED)D:KLKQKRQUWuW}X"X2(B")
("ep"    "$(GJ~NENGJhN^$(Hep$(GR-VJ[P[[vBv[{d$(H$Y$]+W6Y6];\DNK=KGQaX&X+X/]B]GaSeh(B")
("eq"    "$(GQ}$(H'R+\+h0+5J$(GQy$(H==X$=UDJQDQdQg(B")
("er"    "$(GNINJNKNXNYR"R$R%R(VGVH[N[Z[j`5`<dadoiSNHq0$(Hi+#F'Z'\'g'j'k+X+Y+[+a+l0.020I6E6^6h6j=0=3=8=A=B=J=L>QD,D5DCEQK@QXW{(B")
("es"    "$(GJ}`0`8db$(H!c$K$(GHD$(H'YQE'h'o+T+b0F6e(B")
("et"    "$(GNQR1`yd^dhdkmKq-t(tExF$(H$L$M$(GNB$(H+Pr>006O7J=N=OD;KK]?]@b&kakg(B")
("eu"    "$(GHCJiJjJkJqNSNZQ|R#FfR,$(Hp>$(GR0VM[Y[c`+`7`F`JiTmOq3t+$(H"[$O$V'm+j0)0/0;0=0E6F6P6W6d6i=)=@=R=[D9K5K]egi5o4(B")
("ev"    "$(GR&TrV:Yg[^`6`>fMi>iMq*q4$(H"Z'W+_0J=H$(GH=$(HD*q%DEKFazeqi)i-(B")
("ew"    "$(GXX[idnmYvZyt$(H'[$(GNR$(H+Up<+f6L=5=YD-WwX,(B")
("ex"    "$(Gt$xAdp$(H6ZQN(B")
("ey"    "$(GV@[OJy$(H'amW+^(B")
("f"    "$(GEV(B")
("fa"    "$(Gh)\Pq5$(Hf7$(Gt8t`$(H=f>mQnRiX6(B")
("fb"    "$(GR4WeK9Z&$(Hkt$(G[rh\j4n6vcz'$(H*30W6s6w=gDZDbDdK`KiM1QqQsRhX>XBY3]Lki(B")
("fc"    "$(Gdvo+t^yK$(H0_KaKb$(GVP$(HO3qGX5XA]K`Vd7eskv(B")
("fd"    "$(GRv_jdwi*HMt4$(Hb*$(Gt5xH$(H$_'v6q=]DTDUKeLfRgX<(B")
("fe"    "$(Ge"e$t3t7t\P5xG$(H]M1k6p<=K4Qz(B")
("ff"    "$(Gdxi^j3q<Ncq?$(Hp?$(Gqfqjv`z]{M|*$(H=a>wDfQlRVX:XCetm.nm(B")
("fg"    "$(GYX]zc^dud}mfv}z.K"$(H'u'&+n0N0\1o6{D_DeEzGGQtb(ewm[(B")
("fh"    "$(GL,NdW>d{tbE7$(H"ar@1q6l6v=k(B")
("fi"    "$(GR2r-K#t6$(Hqu$(Gz($(H'x+v,hX7X=Y4Y6]J^<_=b+khmZ(B")
("fj"    "$(G[p[qj2oBUh$(H's]H(H,f,j8%=\=^DQDXD]LhQoX4X8X9(B")
("fk"    "$(GUgZq_Td~elq6t9t_Gz$(H'pY5't+t,i=eDcQ}X@(B")
("fl"    "$(GoP$(H9k'q1n(B")
("fm"    "$(Gi[$(H$^+o+s0M0U$(G\O$(H6or,=_=dD`Y7bf(B")
("fn"    "$(GNbP(hcI2$(H*=][,e.)0[E(QwR5Rj(B")
("fo"    "$(Gfmt1$(H!<0O$(GNe$(H0Tcn6u<~=`Qk(B")
("fp"    "$(Gi]q>sn$(H0S$(G`U$(HPAa6QrQx]I(B")
("fq"    "$(GUSVO_?iaF$q7$(HU^0cB~DSD\(B")
("fr"    "$(GL~$(H_W$(GR6R:VR`NiYqgt2ta$(H0X0]6n6t6x6y8$>nDRD^DaKgKjQm(B")
("fs"    "$(GR5R8GIVQ$(Hi:$(G^8$(H8#(B")
("ft"    "$(Gdzhb\Nq9$(HiX$(Gvayw$(H0Z8&=hKdKhQub'(B")
("fu"    "$(GL:R9R\\7q&q8qR$(H'w+p.!0Y1l1p6m=cAVDWE{$(GG<$(HKcq&QpT7YK_Ic&ctmB(B")
("fv"    "$(Gjv$(H,g6kBCDV$(Ge#$(HIZkjLeLgQvZB(B")
("fw"    "$(Gzu$(H>lD[$(Ge5$(HX;qr_u(B")
("fx"    "$(G`Q$(HX?i9(B")
("fy"    "$(H+u6z0V(B")
("g"    "$(GDH(B")
("ga"    "$(GlAo5YYzT$(Hj[:b(B")
("gb"    "$(GTjTmk7EtsY$(Ho2$(G|^$(H.W484;4B:f:oB.B3B4I=IAIDIH\Vg:(B")
("gc"    "$(GcXk6lBo1onv>wC$(H4HB)$(GKK$(HB+q^T[ULZec_eCg8gXgbl`(B")
("gd"    "$(GGg$(H%y)X.P40414I4L4M:dB5$(GGb$(HGfj$GiQ&TYVS(B")
("ge"    "$(GL[]O^^`&gpn'o7u_$(H&#.X474E4K$(GIc$(HAvm$Bh?~IBJhQ[RFW<Y=Zf_K_^iA(B")
("gf"    "$(Gc\Iem_$(Hnn$(Gm`q;sNvb$(H4?:kIKX3^Ka'g9hJlkllna(B")
("gg"    "$(GTkYTh<jW$(H%})T)^.N.Q4G:c:q:s$(GGd$(HINpwN>OxTZlC(B")
("gh"    "$(G_%b?$(H#N$(G^[$(H4:IE9W@T(B")
("gi"    "$(GGyPlYZc[c]h@u<$(H"*%x&".O434N:r$(GF*$(H;;p)GbI>OqOzZ;\W_5_6(B")
("gj"    "$(GM1YUYVk8twtx{S$(H$H.U3'4@IGOtTXVV$(GLY$(HdI(B")
("gk"    "$(GTlZr]P^ah?lE$(H%v$(GTi$(H)Zo"9V:eIMQ~VTVW(B")
("gl"    "$(GGa$(Hm=$(GIfL]SYXV$(H-Y-Z.YII(B")
("gm"    "$(GIaLZL\PPYQ^ccYl@pKw(x0$(H%r%z$(GI_$(H%{i^454=4D9X:a:h@SB0B6B9GkI?(B")
("gn"    "$(H!O")#K%Q%s.V.Z:tGh$(GI^$(HGj]^I@(B")
("go"    "$(GKLPT^\`!cVsK$(H)V$(GIb$(H/xZhE%GdGlOuVUWk(B")
("gp"    "$(G{`J5$(H#JPC%t&!)R/!B*IJJ*(B")
("gq"    "$(Glx$(H%~)S$(Gl?$(H)[PU4ADmPT(B")
("gr"    "$(GLXPQY[^E^`b>cEcTcWh-o6qU$(H%u%w)U)]4F4J:nB1GeGgOy_ecQcR$(GGO$(HcXp4e=m<(B")
("gs"    "$(GI6I]PRPSc<$(H%U%|-S:pB2IL$(GGe$(HIP(B")
("gt"    "$(GVu^bcZ$(H)`B,$(GLW$(HOshn\X\Y]eeB(B")
("gu"    "$(GXD^Yh:ttuXvl|}$(H!9"(#M)W)\.T3(42$(GGf$(H46n"494O:m@UAWGcN-Ore-e.g7(B")
("gv"    "$(GX0^F^Z^]b=x.POyf$(Hm>)Q.L:gICJ`(B")
("gw"    "$(GlF$(H'$4C:lB/Zg(B")
("gx"    "$(H4<eD(B")
("gy"    "$(GL9I`L^x)SX(B")
("h"    "$(GHL(B")
("ha"    "$(GM~Q$S|\ra1j-j/n(vyv|z&$(H',*vEdRC$(GFu$(HWsr"W"]:^-^^efiQ(B")
("hb"    "$(GO6PuU:a!a%a,i`j"n%n2q^qdvWw|{J|@$(H*48VBbEfEo$(GM/$(HEpp%FJKnLMLOLYL[R@S4XFY&Y2^#^9^_`ubWe|f3f6m4m?(B")
("hc"    "$(Gb;$(Hqz$(Gb|j(jXo3qXq{s%uav)vxv{xJxYy&{A{m}1}K$(H1P=p?=E^HfRZReUfY,Y.\/^"^*`S`UbUdkf1g}hKiPiWkFn+p*q,(B")
("hd"    "$(GEgF}$(Hi@$(GH7H8K(K]LwRuUAWi[?[@ecg#hMi7j.p$pPq`t[$(H0a1X<l=m>\>]EbEeEuFKFMLZL`R^S0Y(Y*[le#(B")
("he"    "$(GJ2M>Q%QtQxRWTQV3WnWo[F_&c(dZe^n)p-q|wvxWx[yNz{E0$(H!?qq#u1f7x7|;Y>^DjLNLbOES2WoWp];e&eyhumjnypIq'qk(B")
("hf"    "$(GRqVT^$`'kzqWqax&x'z,|x}F$(H2q53;t?<KfL}M2QyXyY/YE\3\4\:]N]}$(GK7$(H^,qPa+a,a-a/a5bSe"e)evexh>hWhYhZh[i?iOk8k9k<kDlaltm,m-m3m5nkoxp#ptpu(B")
("hg"    "$(GK'M;RVSlY)_(a#a.bve_f,j!ken3}%}&$(H)_.S0b2r$(GE1$(H7jo<9K>f>hE]ErS3VZXEY#Y%]|^;bldlhXiSiUiykGmh(B")
("hh"    "$(GNlRpW8\IqZq\vswq}*$(H(Q+z,_1T1e7"7z>[ARHgO9RbX{^5a@bMja$(GKN$(HnD(B")
("hi"    "$(GD=G#GhHaI<J<K3N{Q!RmSxU+VVXpZ5\J\qa+a3j)p%qctXw{xZz$$(H"?#t$(GD;$(H$`pm&W(0+|1.2k7{8[><@#L1RdT&\{]~^+_<bOfNgyhci>l6mcmgmknVo>pA(B")
("hj"    "$(GL8O]Q8RoRtVrW2W3a"a4j1kvtYt{v9vzzK$(H#P$q&q0&<@@&DlEaEvFLLcRB^0$(GDE$(HbQnxbXf2gnlHmi(B")
("hk"    "$(GIYMSNkW4W=WhZv\3c_crefhelbn5p*s[tV|\$(H"'1d>bBiDkEsJ(L-Q>RcV$W!W;\i^7a>a?b>bVe0krn`$(GE5$(Hnvp+nwoo(B")
("hl"    "$(GF(GML<MTO&OVTNZ9bSegk|oS$(H!7,\-]-_-`25$(GEH$(H3@pF>c8!8Y9p9r7oA"H/H0H1L_NXOFU$^6^8n5(B")
("hm"    "$(GFb$(HqU$(GFmM<O*PMR<R>U@URW5\'\G\Kehj*j,n4nJqbqtw)|>$(H&V&X,d-,1#1R1U1i7#7w=nE_EcLVYb^'^)^1dje2fMnU(B")
("hn"    "$(GHgI3L0L1L2M=SOWlXE\C]4^7ayfLkWl,n-nlnmp9r/|h$(H-L$(GD-$(H1aq\1j7r94@'@(ATE'ExHsK{K|K}L\LaR4R`T*Ug\D^3hdiTkQ(B")
("ho"    "$(GEWEfFBFjN<O;U?W7Z6Z7Z:ein&n1tZvVx\$(H!,0}1g;Z>d?8C}En$(GD,$(HK,o;K-LXL]LdR_^.^4^:bLbmiVibn2(B")
("hp"    "$(GHJK0KeM?Q+S}UIWkZ>\pczd&eahfjYlalkpVqes6tTx4xX{l$(H!((D,[,^1V$(GET$(H1cez7I7g7sD(O:^(dUeK(B")
("hq"    "$(GQ#Q&[u_>a-d]jNu($(H"f$(GE\$(H'{m\;[?>C!DiJ@LPP@Y0(B")
("hr"    "$(GGWG[H_I?IKLOLUQ"R=Z;\L\s^R`W`wa/a0e`j'j0kmn$n0oAoqq}v4wJx]z^{-$(H*S$(GGV$(H*Tn(1S52547!7$7h7p7q7t7u7v7y7~8W=(>e>g>iE`EqEwKmLUO4Ra^2bGbRe1e3f,f5hehmj!(B")
("hs"    "$(GEeJ1K4MRWmY/\M`ia2cqemf+p:zv$(H"b#2(G)51Q8Z??EtI+Y$YabNfP$(GEB$(HgAq+(B")
("ht"    "$(GHfQ7\Fj+j[msmuqNz%z0$(H1/1b$(GE*$(H24ms7H7}EmY'Yc^/bPbTg~h\ml(B")
("hu"    "$(GF)G?H\K5L#NgO'R`RaS4U5W<Y'ZS^w_'ES`v$(Hpx$(Ga$ejn.n/z<$(H"g$(*&,]0#0~191h262Z7n8":D=*=l=o>jBjEkFIGBKoLLL^O5RARfS/S1T9VpVtY+Y-Y1Y`^!`bm0p,(B")
("hv"    "$(GP~fTgqj{q_tWvtw}|0$(H,c/2;3$(GLg$(H>ZrCBDElP"V#ZFZt^]e{htmfp-r)(B")
("hw"    "$(G\H`lg>vrx*x^|?$(H*?+{0%1W$(GVg$(H8XlcLK]df4fOks(B")
("hx"    "$(Gn*vwH^$(H-+icf0(B")
("hy"    "$(GFXEvZ8$(He4$(G_=oj$(HLWY)`c(B")
("i"    "$(GEA(B")
("ia"    "$(H*l5,bKI~V}(B")
("ib"    "$(GU9UvZ+l[t~K-$(H!gme.$I|L@f/iN(B")
("ic"    "$(G^(b3cmFZeY$(HpE$(Gfqi|l]o4y<y]$(H.(3&@RI}J"RXdSj^p$pD(B")
("id"    "$(Gl)t]v3$(H(B*;+8.'.w/u$(GJ+$(H7am87i>kCkEYLCVyXz\=(B")
("ie"    "$(GGCJePyTEZ*_#`xcneZlYlc$(H#m$(GFc$(H,XkA.y5+>XBfLJha(B")
("if"    "$(GZ,ZQc%i\ky|.|y$(H+q>yBdP;$(GR3$(HP>o5RSRTV;VD\6^Ja0d{hGm!nd(B")
("ig"    "$(GTFU<U=h8$(H"<*83k:0AjB8IFLBP<ZK$(GO#$(H\;kY(B")
("ih"    "$(GW)Y6haFS$(H#^LF#o.z(B")
("ii"    "$(GI0M4k{lZxV{I{Q$(H&p(C*7$(GH($(H.ko&1I1JBeJ!Z<]{_4lb(B")
("ij"    "$(GU;tS$(H5/@o$(GH&$(HE[k@LHV{]z(B")
("ik"    "$(GK2RiZsl^m/$(H!d#-$(GE]$(H,Ye+1M=rJ#LA(B")
("il"    "$(GO%RkSgW.^~h`jVkIl\G|$(H#qcu(w,W,Z-[38@vI'NQ(B")
("im"    "$(GH'M5MPRjW-W0$(H!{.}7_I{RWXx$(GH"$(H\<pv(B")
("in"    "$(GJ)L)\&_!gnGF$(H#pkP%S1"3lAn(B")
("io"    "$(GH9M2DfZ.$(HbJ$(GjOp7wD$(H![*:/{1O5-5.6=7`LELIP=(B")
("ip"    "$(GJ*Q)RlUCWd^&_)cvhhlipUs\x2}"$(H!Z#v*9*@HtIzLGPQmM$(GD]$(HrA(B")
("iq"    "$(GPx\@lwHI|[$(HhsLDQ{V|(B")
("ir"    "$(GI/M3P8P;TGTSW*W+F:i~$(Hk?$(GqStR$(H%O.&1K1L1N7d:E>YEZh_(B")
("is"    "$(GW1H)$(H$r,V(B")
("it"    "$(GJ;\6e@vqx3$(H*6>=>V$(GFO$(HBc(B")
("iu"    "$(GE8M6O$W/Z-_"a~Dxp,$(Hh`#n%N7bE\Q@RUa8(B")
("iv"    "$(GP\PdfQ{kK@$(H!]hr.%7c>WJ$Uhe*(B")
("iw"    "$(GVfi}TD$(H.xVzBg(B")
("ix"    "$(HqR(B")
("iy"    "$(GyH(B")
("j"    "$(GD2(B")
("ja"    "$(GWRO/Yn$(HLQ$(Gm2(B")
("jb"    "$(GPkS-U(^o_gk:oCoGy/|=$(H!=1Z9a;:NN$(GM+$(HTpntTtZx(B")
("jc"    "$(GVxYkb5hRk3sbuTwlyByMyjF~z"$(Hn9;9@eBOG|HeR\TTU_`QgB(B")
("jd"    "$(GGsGuIuIxIzUyV&^peeF\hS$(Hn4$(Gi6y`$(H(F4u7k>_IdQ'TsW\Y!Zv\d],_lcre^gD(B")
("je"    "$(GYjYmhToD$(H9b;8$(GEE$(HBNe/I3K2QCTqZy(B")
("jf"    "$(GWD`ThVlNlQn+s7x_zU$(H;4ToV3X~a$dzgChEhIk'k,k=l~m&m'm1ne$(GLx$(HqL(B")
("jg"    "$(G\DaFcRg'h=hpj#wR$(H7m9c?9$(GPi$(H@pd<H!K8VY(B")
("jh"    "$(GhPhQRr$(H&8cq@mAk(B")
("ji"    "$(GI{XGYq^'^;_<jmlOwK|g$(H(E3-?x@i@kPSTrW:Z-\>c7fq$(GGv$(Hj(lG(B")
("jj"    "$(GKOP2U#XFbKclg%D\h~$(Hj-$(GrR{2$(H@bEgR[cs(B")
("jk"    "$(GGPQJRsZta'D7g$$(HLR$(GhNrTvvwL$(H#\,a3,7l@c@g(B")
("jl"    "$(GZ}]gz\$(H.h$(GPh$(H1]Y"3:9lG}NT(B")
("jm"    "$(GL{N~O(PgWPDIg&$(HoV$(Gk<qstU|c$(H@jEhM&bg(B")
("jn"    "$(GKgO)P+S\TIXq^4hOn,K6rS$(HOM!S!T"h.*9d@lAlLS(B")
("jo"    "$(GU%\E]TbJp+$(H(5)x1Y1^4t;7?-$(GLy$(H@ngEBPGzL!R]Wi\e^$_kcoeS(B")
("jp"    "$(GGwHR_-oJpTx1$(H9`;];^$(GFF$(HX}j*cp(B")
("jq"    "$(GhzmcsdK&v'$(Ha9$(Gy.$(H>0(B")
("jr"    "$(GLzP:PjU$U'U)Yla&a(bHhUj$uPu]$(H&9,r.i@d@h@qG~IfNMNOTuXr$(GF,$(HZz_V(B")
("js"    "$(GL6P/W9W:$(H)4.j$(GHS$(HVg(B")
("jt"    "$(H;5G{$(GF%$(H_mr9lFoU(B")
("ju"    "$(GI,IyL}OQWSXHYo]Sedg~k;k=q]$(H#],`1[1\1_9^9_;6@fNLQATvZ{\?^%^&$(GD$$(HfDn#(B")
("jv"    "$(GLfU&U*azoIpQu^u`Gxvu$(Hj,$(G{Z$(HI\IeX|Z@Zwj+(B")
("jw"    "$(G^nbIlPL|oH$(Hn3$(GrQ$(HByZugFj)(B")
("jx"    "$(HEi(B")
("jy"    "$(G^m$(HH"(B")
("k"    "$(GDK$(H!!(B")
("ka"    "$(GY]H1[x$(Hb:$(GlG$(H"OE.E6L"XM(B")
("kb"    "$(GH4FLJ($(Hr:$(GO7V[ViW]Z'[v`ne(e*mlqKqLvjxR$(H!.0h7-7C=t=|>5>8BRE8R$R)]O]P]ci=(B")
("kc"    "$(Gb7e:r~vdxLzy|b$(H'|1(:2E7$(GVY$(HR'kmR>(B")
("kd"    "$(GQ^[y[ze?Gt$(H0iE9=u>4Dt(B")
("ke"    "$(GROVk[D`smpmrt=$(H0j<7<8='=v$(GE.$(H={o8DrKsL%R:]ab,b7m](B")
("kf"    "$(GK)LbRRe8gmo{tCy[$(H'}DoDpF*R#$(GHH$(HR&qQXXX]X_\8]Qa(d|e$e'hLnfoq(B")
("kg"    "$(GK*PXVZ\1btGc{f$(Ho9$(G|a$(H#_$c$g0f1&;<>9E:R!R8kk(B")
("kh"    "$(Gil$(H$b0d$(GVo$(H>3X[>7XG(B")
("ki"    "$(GE4R?ToD:\.$(HR<$(GhDimqA$(H!8"5('7D=zDnR9(B")
("kj"    "$(Ge<icqJvi$(H"c,",v7%7+$(Ge9$(H]bo#(B")
("kk"    "$(GRAVh[s`[ibioy{$(H=sL#L'R(XKXWX\b;$(GEY$(Ho7(B")
("kl"    "$(GNnRQSh$(H"+$d&$0g$(GI|$(H3;o63?9tE3IQKrb8(B")
("km"    "$(GNoVjVlVmVq`\`pcoik$(H(!(%(&(6,$2'$(GFJ$(H7,]`J?R7XZ(B")
("kn"    "$(GE#GjNyP&\2`mint<$(H!e"d$f$(GD&$(H$oL$%R(#)b.,0k1+7)7F>/E4(B")
("ko"    "$(GNqNzVX\$mexSIh$(H,'`@1-6<7A<}=yE/E5R%R=XLX^(B")
("kp"    "$(G`ol/vk{i$(H$p($,#,>$(G\0$(H,?XY567(R;R?(B")
("kq"    "$(H,p$(G{j$(H7BXJ(B")
("kr"    "$(GF-LaNpVp`re>hEmmmq$(H(",!,%-Q.;0e1'1*7&7.7E7G=w>6Ds$(GE{$(HE-b=E1E2L&L((B")
("ks"    "$(GGktBD0$(H!R1)!~(B")
("kt"    "$(GLd[w$(H1,$(G\4`qmnsS$(H,&(B")
("ku"    "$(GFgLcDRNx$(HR"$(GRPRSY1tD$(H$e+L.q2Y7'7*:4D$DqE0Kq(B")
("kv"    "$(GVW\/]6`Ze)e=R@ve$(Hmb$(Gyz$(H"2'~)w=xXHXIb9i<(B")
("kw"    "$(Gmo`YpM$(Hb<(B")
("kx"    "$(Hf$(B")
("ky"    "$(GVn$(H>:$(Ge7e;$(H$a(B")
("l"    "$(GDc(B")
("la"    "$(GUsj}lWM.uB$(Hl:2m2t5)9@@$@+M_McN$So_+c8fzl/(B")
("lb"    "$(GP$S+S,fAfPjnmbnbnhnsp#z:{$$(H.u2d2v9'919<G1$(GDZ$(HG2pMG7G@MuN!StSzS~T+T1Z0Z9ZH_'_(_/_?c2c>cDiw(B")
("lc"    "$(Gb6b8b{oop5r+s4xI$(H96;WB_B`IwMb$(G^{$(HP7oJT"T'Za_&c(c-c0c5fffripl7l8(B")
("ld"    "$(Ge&jzncnq$(H-M-N2`9><i@,@.$(Gau$(HG3irG6G:M\MiMkSiSsT.VuZ,ZI_2c<fsf|(B")
("le"    "$(G]7h_neno$(H&O'c2_2x2~93G+Mf$(GNj$(HMgq]MtN(N)S|S}T!T4_1c?iul9(B")
("lf"    "$(Gr,p(s8$(Hos$(Gu>xw$(HJaM}P9P:SlZ.Z6_)_-_Bc.c1c4nj(B")
("lg"    "$(GZ)]+arasfBfSlVniu9X2$(H;VpLG,G;MoT)_>fiispK(B")
("lh"    "$(GSPX-i#jq$(H(i2i2z9BG.IyN%Sw_0_F$(GOO$(Hc*(B")
("li"    "$(GHeX,]3fFr2w9xq{($(H-J-O5*9"9*9799=j$(GG}$(HG5qtMdMyZ8\g_CaQaRc/c6cCfmfxl1q8q9(B")
("lj"    "$(GX+`VfHh[j|njoEr1u7u8w8$(H-GMrP8T%T,_@c+$(GX'$(Hc@fwfl(B")
("lk"    "$(GFAX&X1_Yaqa|fCm0u;xx$(H&N2b2g$(GF8$(H4PnS9$9:?~@-IxMvSrT(T6Z*Z3Z7_D(B")
("ll"    "$(GEZFsHkOXX(jpna$(H%)(h$(GDU$(H2eiv2j2u@}G0MsN*SqU!Vx_,(B")
("lm"    "$(GSu[$],]/]2]8`kh^jJu?$(H2o2w9+$(GSL$(H92oL9A9FG/MaMpShZ=ZJ_.fgftoH(B")
("ln"    "$(GXnfKh"nknr$(H!Y#.(g(j-I..2[2h2y?w?z$(GFQ$(HDhT$(B")
("lo"    "$(Gxsz9$(H&P2\2a2s9)9-9=B^G-G4$(GG>$(HG?itM^SvS{T2T3\h_Ec3cAcBfuf{(B")
("lp"    "$(GH3M@X3Z=]*_+u@{)$(H-H2^2p95Z5Z?_*_3c,eJmz$(GF!$(Hn!q7(B")
("lq"    "$(GO.^|$(H+x98$(GHW$(H?uq:@%@/MjT0(B")
("lr"    "$(G]-].atavaxfOfUjrjuj~M-nf$(Hfy$(Gr4xu$(H*2+y9%9&909;9??y@)@0@1@2MeN#VvZ)Z+ZGc)(B")
("ls"    "$(Gr*$(H$n9#9.$(G]1$(H9Gc'Kl(B")
("lt"    "$(GVvipjou:z;|GR[$(H*1pN?vG9Z1Z2Z>m|(B")
("lu"    "$(GS1]:^zckfGfJfWjljtr3w7xr{r$(H!5#k#l.v2]2c2f2l2n2}8\?}@*$(GD*$(HG<qfM]MmMqM|N"Q?SkSuSxZ:_Ac=dh(B")
("lv"    "$(GY_Z(jxnnr0u=uD{'$(H4]?|@5G)$(GSM$(HG*oIG8MlM~SnSpSyT/Z/`WfkfvoF(B")
("lw"    "$(G]9^yawFqlX$(HoK$(Gndw:xv$(H%19(M`SjT-fjl0(B")
("lx"    "$(HBa$(GaH$(HMnm{iq(B")
("ly"    "$(GOf$(HSm$(Gjw$(H9,N&(B")
("m"    "$(GD!(B")
("ma"    "$(GRGTPUlV2HKo)$(Hgh$(GoVpm$(H0r<L=%>,>;D~EMH3XQ[*]Z]o(B")
("mb"    "$(GGBNvV_V~\jE_`|$(Hma$(Ge,e/eUl0mhofy}{=$(H"p,50v737<D{ESEWL3L;N9NZN]Q<R,RIUWXOXpXu['[(]yb.cxdie}f)lL(B")
("mc"    "$(GXC^!`^bzePeRfrg`gbieizqBqVs!s$tNvXyLSwy|$(HpC$(G{v|<$(H0m79:I>-AQK.KvNoQ:RJRK_]`Eb-b/dBeef-g2giiHiMj\(B")
("md"    "$(GP4V#V1V`\>`_`fa5bWiwkKkNoTqzrvtAz!$(H$i(A.g0w3D6@$(GD@$(H7>pU:H>)>N>UENEPEVH]KyKzR0R3RNRRU)UX]V]s]u_qe`e~(B")
("me"    "$(GN?R)RDTnW"[~]Ge-eSkLlhrHt@v%w;xNy3$(H,O,P,U1@6?9v=#>&>'DzE$L9L=U'U(_tb0eE$(GJf$(Hh3qFp\(B")
("mf"    "$(GF|TOVS[o\Aifiyn#p)qEtQy4yY{4$(H0^=~>"OJQ=V1V2V5V8XmXn__`}a)a1b)cyd}iLk*kqm%m(m`oWor$(GDb$(Ho|r=qMqm(B")
("mg"    "$(GH]NsPNV]VaYS\!_XbrbseWmjm}ogrwsLyFE^|!$(Hp]%Z);)Y1C72757]>P?:AKN[U+XTXo_skom^(B")
("mh"    "$(GJ0RFReRge.mF$(H!%"$'L()(,)9+H,)$(GE[$(H,Mls,Q,t709w>KAMDxD|GAH\J'L6R-XqXv]Xc|gk(B")
("mi"    "$(GEPFiFkO"RES#SNW!XIXZZR`$`]bxfIg[igivkwqCqTr.tPukxMzQ|f|wDi$(H!fpW$j,-1D1G1H3C7=>$>O@"ETJ=KwMhN\R2ROU&XSXw[_bHc;f+gjiIl2l\(B")
("mj"    "$(GFMV|a}e1eOeVmgD[oU$(Hj4$(Gom{>$(H$h(((/(<)8):,.0n3B>SR+TOWn]W]w]xb3bEgJgm(B")
("mk"    "$(GJRJUNtNuQIQrS3Zz]h_V`}bwe3h%i_zP}<$(H#Q"M'K(+$(GE2$(H,sq*0l0y>+E#H_K0L?R1RMXlXt]Y]v_a`HbFf!f}l]p@(B")
("ml"    "$(GKXKYQKSrW#Xo[}e+g;kf{z|N$(H!'!1"r"s"t$k%+(-(t(v,,,4,8,R-\363739:v$(GHT$(H@wj/H,H-NRNScwe;gg(B")
("mm"    "$(GD5DVDkDlEaF_G'K\KiN=OgQqW$W&]{`%`jbVeXmim{q%qur^zs|pD(|q$(Hq{#6#j$l(=+G,/,30x1?3"3s6B>LD#DuE"ELH^KuL5L8Q;]8^S_wbD(B")
("mn"    "$(GEzGDGEL/SkY+\#\?`dc8e4h#ii$(H!)!|"e(1(?)2./0s1A1E$(GD#$(H7;`D@KD}L<[^(B")
("mo"    "$(GJ'K+KIL%RhW%^<``i:qFqGs}t>vpxU$(H(k,L0q3#6A747:9H>JC|DyEJG[GxN:O%R*R/[)]ScZ$(GDv$(HdDj2f.gK(B")
("mp"    "$(GRHUE_*`b`hhgy^yy$(H#w(*(@,N/"0p1<$(GH;$(HA$q`R.W$a7j1p^(B")
("mq"    "$(GqDtM$(H/}0t$(GRJ$(H0uDw7X>#B}(B")
("mr"    "$(GF{I@IAQsRBTWTdVbV}`e`geTg<g=ihixkMm~p>ruui{?$(H,*,+,2,60|1>1F7177787V7[7^=&>%>(>*>TA%A&A(DvEKEOH2I-KtKxL>RHRQU%UV]U]q`F`G$(GF+$(H]tpVcz(B")
("ms"    "$(GE|FIP0W']|m|sDyGDa$(H!&_v!-#776?;A'ALXs(B")
("mt"    "$(GKHN|RCRZJ-Rf$(HjW$(Gn"tOujzJ$(H";,0/~1=9RK/RLWmXR[&_`_r_xb2b4c{f*g1(B")
("mu"    "$(GDwE-NrV^W(XY\"\=`a`c`~e0eQgYgZido'oWrxr|v$vg$(H?}!>%Y(>)7,1,70o0z6>7Z9S9u9y=$>!B]E!EUN+N,RPU*WlZ%]pa=md$(GDB$(Hn@(B")
("mv"    "$(GS$SQ[|a{i{n!ohrtt?wuzwzx|P|n|r$(H!$)v7Y>I>M$(GKQ$(HG\jVL4L7[]\bdCj3(B")
("mw"    "$(Ge2gXwg$(H7WXP]T$(GHi$(H]riJbCbIf"(B")
("mx"    "$(G{~$(Hb1(B")
("my"    "$(GOdoiry$(H(.$(GD6$(H,TER.20{>.(B")
("n"    "$(GD^(B")
("na"    "$(Gbjp'yU{K$(H:+$(GSp$(HEIqIT;`wk#n^nbpi(B")
("nb"    "$(GbkbmgRrqsRsZS(v/$(Hqi$(GyV$(H(|-d.|2351:/V)`Cdndwh7j{k$lvl|nTohonq;(B")
("nc"    "$(GDQ$(HqJ$(GSWgSg_hC$(HHWP?USUd[g`,`RhBjRlwnY(B")
("nd"    "$(GFEH#Q[V)Xfq[$(H"3"w-h:.Cl$(GDM$(H\#qh]-a!dxh@hDjyk!n$n_pg(B")
("ne"    "$(GKbL*Ob]r]y`u{L{s|-$(H!:!`&R,@9J$(GE/$(HN/oiN1PgV.dvh4h5j|o'(B")
("nf"    "$(GU!^#e!kakcq@s;x$yQyTzZ{P|,K%$(H"4ot0P4s50OLUz`B`yhSjqk0k;ncoM(B")
("ng"    "$(GJ,KEXdXh]tbolClDv0x!$(H:j$(GD`$(HAFr8AHGCOwhAk&n[(B")
("nh"    "$(Gblw=$(H3I$(GFy$(HHpdtV(V*\"(B")
("ni"    "$(GFPGiL"M8ONOaZ0]0]ungs~xtz=$(H&S(xBzB|GJHZM{OHT#\$\)_7_8lym_nZoeof$(GDJ$(Hqg(B")
("nj"    "$(GP|XbZ|]vkbHjl_$(HnW$(G|+$(H"xJ&dJg"(B")
("nk"    "$(GIvPYRTv.$(H9IAD$(GD4$(HO#lxPdV+[[dqj}(B")
("nl"    "$(GE?oRx"$(H-P-e$(GE>$(H9qj0@zN0V>\&`x(B")
("nm"    "$(GG"M7O`U>XgbnbppSxQ$(H%/&T$(GDN$(H({pd.{4r?)@9@;HXO$OIV'\%\-lznXoj(B")
("nn"    "$(GDhKcRd_$a6h!D'$(H"ye9-gAGI(V%b5(B")
("no"    "$(GDOENFtLvM9MUPfSyXcXeb/bibqrGrprr|Y$(H-c3H$(GD<$(H=!om@:\'`{h6jzn](B")
("np"    "$(GQ*Q,Z<v!yDzY$(H%-J9OGV-\!d;$(GO^$(Hh8r<h;(B")
("nq"    "$(GK,PzSqfXH`v-$(Hk"$(G|X$(H!0_J(B")
("nr"    "$(GO_Y\]qfiyW|W}@$(H&Q(y:,>GGFJ%T:\*\+\,\.`v`z`|a#$(GGX$(HcWqjdoduh9k%lu(B")
("ns"    "$(GK_P-P.SRY-$(H!i(z-fV&\($(GD%$(Hn\(B")
("nt"    "$(GLuRX`tgQKa}A$(Hpe,AHY\c(B")
("nu"    "$(GE6GNHcI-K`Xa\-]wp&s5s?$(H!Q"v#s%.%0&6*01:$(GD"$(HGDpfGEL/P6T<UTV,Wq["a"dmdpdrdsh:l{ol(B")
("nv"    "$(GSoZ/b}$(H&4:z$(GSn$(HACphAEV~h?jx(B")
("nw"    "$(G]s$(Hokh<l}(B")
("nx"    "$(H"#`Aog$(G]x$(HqK(B")
("ny"    "$(H:-$(GF@$(HhC(B")
("o"    "$(GD)(B")
("oa"    "$(GKvT,T5XrX}_aI$dD$(Hqo$(Ggrgvl&sC$(H%@3c3eA\I%]njZ(B")
("ob"    "$(GI)KyK|K~OoOpT(T*T>X{Y#\l^,c+e]ghgzg}p0s,tL$(H!t!y'N)(-w3V3Z3\3h:9=+AbH|S.Uk$(GDy$(H`YaB(B")
("oc"    "$(GKrT4X~]L]Mb<c,c0fug|kkl$opp3s#sAI.$(H!4r!#*-o-~3a:7:=AfHyI!\FgajdjejfkOnC(B")
("od"    "$(GElG2I'K}OqOtV4[>^-buou$(H+E/v$(GEj$(H3Rn|:?HzH}UjWh^NdWjg(B")
("oe"    "$(GOkOvXiXu`)c!c3s@wdwsyO$(H!j"Y$(GG;$(H(~f()a-n-u.[/P::A`OUUn[i\Hi4(B")
("of"    "$(GI#O{Xs`(`P`Resgws:tmG-v2$(Hr4$(Gv8x#{N{X$(H!U!w#'-i-l-s-z0Q0R3]6}:;:<AZA]AdAhDYI"OPOQV6VC[h\9\Ea.a2e8h^m/n}owoy(B")
("og"    "$(GG6G@HnIdKoL!OcO|^_b~c1gVEkgs$(Hp[$(Gg{zc|d$(H%;)*),)0-y3T3_3`:6>HAIONUUV@[\`^gzkNmmoO(B")
("oh"    "$(GG$G9NAT:c2D+c5$(Hle!v"zHh\J`[(B")
("oi"    "$(GEoEqG%G1I&JdKnOzT$^+^.c.jsl!osp2s)wtx+zS}.Ei$(H!pdX!s"}#()1-q-|3b3jHwJ>(B")
("oj"    "$(GE)F#T)T=Z{^0kpl"w'$(H!m$(GDo$(H"{`X%9-j-t3J3g:CAYA[H~[a(B")
("ok"    "$(GFzG.G3JSKpOlOmOuT#T7V8WMEmXx$(Hg|$(GY$ZwZx^1c-knsm{W$(H#$%3)%,K3O3f:A<;ASAiO7OROW`Z`_(B")
("ol"    "$(GG4G7HzL;LTOWSiY&$(H!_!q!x$(GDu$(H!z[%"X$J%J+M,JA!A#HiU#Um(B")
("om"    "$(GEcG0G:HvDnH~$(Hld$(GI%O}R~T&T+[G\_\c`*aEc/l#yP$(H!E!F!G!I"~#")!-{3^:8:>F6OO`PaE(B")
("on"    "$(GDpDrDtG,HoHsKsKxOyO~QwT.T/XjXtY!D?Y"$(H``$(G^6aTl-l.$(H!3!A!H!o!L#!%6%7).)3-r1!3KI)V?VB]](B")
("oo"    "$(GHXH}I*KzOnOrV7^)c#gxgyl'q$$(H!l%4$(GG/$(H%5nF(K-m/z3YAeAgD!H{NIOYVA[k]7`](B")
("op"    "$(GEnG8HpKqMBZ?Z@E'c4$(Hn{$(Gc{k~pWs*zb$(H!r%2%=%I&Z*A*N-}.m/#3W57:3AcOX\GaCiG(B")
("oq"    "$(GH!HrI!KlT'UUG5V5$(Hi;$(GXyXzjZ$(H%F+}I$(B")
("or"    "$(GGYHt$(Hjc$(GHuHwHxHyH|I(IVO!O<OjOsOwP!T!T"T-T3T6T8T?XwYG^/gegfgukqs($(H#&%8%>%?%C%G%K%L)#)--x4':5?#A_O6O8OVQ8g{(B")
("os"    "$(GG+H<I"V{^*Dsc$$(HHx$(GgU$(H!2"|%:)'(B")
("ot"    "$(GKwHmK{$(Hmp$(G\5`{i;kop1$(H#)%D*<3U?"UlXadVjb(B")
("ou"    "$(GHOKuM)M*T%T0T2T<c"d\gggtr6zR$(H!J!X!k!n!u$(GEp$(H#+aD$I%A%B)$)&)))+-k-v.t3i6C:@:BA^BYD&HvOT(B")
("ov"    "$(GKmSzT1T;V6XvX|Y%];eNl%otv*$(H%<%H&5(})")/-p$(GHq$(H2|qH3Q3S3XAaOS[j\I`\e7(B")
("ow"    "$(Gl(sBwr$(H0'$(GH{$(H3PI&3d7@9x>2(B")
("ox"    "$(Gp4s+$(H3[(B")
("oy"    "$(GOxT9$(H##$(GDq$(H#%+N%E(B")
("p"    "$(GE@(B")
("pa"    "$(GH0MJRUZHlp$(H'2*H*L5C;bJ/J4$(GH/$(HPJ(B")
("pb"    "$(GP1UJZE_2_4hos_$(H&^/&$(GMH$(H/(PP/+5I;jBpBqJ1PEPNPO(B")
("pc"    "$(G^"c|gahklsqYx6$(H&f$(GMG$(H5HeL@PBmBuBvPMQBQj^AaUaZ(B")
("pd"    "$(GUQZNZPc~d"pX$(H%V*P/*/.1m5=5A;g;iPL$(GD>$(HW(W[(B")
("pe"    "$(Ghihjmt$(H#{$!&k$(G_7$(H/,o*5?;k;sBtaVaX(B")
("pf"    "$(G_:lqltlu$(H$&+r595<$(GQ0$(H5Eo)BnJ0O?PKV4\5bahRk.m+(B")
("pg"    "$(GMIZM_8gWlms]wezj$(H#O*G*R/)//J.$(GJ9$(HJ7l;OvkZ(B")
("ph"    "$(GE&FRUOZKhnE"$(H!\PG&[+J;hJ3(B")
("pi"    "$(GE%H%DDJ:$(HaW$(GMFQ2d$$(H&o5>BoJ-PR\p(B")
("pj"    "$(GZBZFZIlrzk$(H"B$(GUM$(H#3W*#~&\;c;fJ,PH(B")
("pk"    "$(GGJJ8MDloE~p[$(H\q"@$$*B*M5DBwJ5J;W,(B")
("pl"    "$(Gg9hm$(H#}$(GUL$(H$%;p(s*j-^(B")
("pm"    "$(GMEMLMOQ1_0E$ym$(H'%&d&m58;mJ2J<(B")
("pn"    "$(GI5MN_3_9$(H!"!6$(GGG$(H"AaY$'*D*K:G\m(B")
("po"    "$(Gij$(H$"&g*J$(G_.$(H+F\r;qW&W-\o(B")
("pp"    "$(GMAMMZOpYpZER$(H$#PI&_*E5F5G;_(B")
("pq"    "$(Glne~p\$(H,;&l(B")
("pr"    "$(GMKQ.Q3Q4Q5UKZCZLd#$(H&]&a&b&i*I*O*Q-R/05:$(GF;$(H5@W+:F;nJ8J:(B")
("ps"    "$(G_/_1hl$(H&h&j3q$(GI9$(HI*(B")
("pt"    "$(GQ6d!E`d'$(H/%*C(B")
("pu"    "$(GE}J7Q-UPE:Wp$(HW'$(GZA_5c}x7$(H#z#|%W&c&n'M.1/'/-5;@6BrPDPF(B")
("pv"    "$(GQ/ZDZGZJ_;x5$(H&`/$2{;e;o;r$(GH$$(HJ6hvW)a\(B")
("pw"    "$(GY0_6$(H&e$(GK/$(H*FBl;d(B")
("px"    "$(HBs\n(B")
("py"    "$(GUN$(H5B#y(B")
("q"    "$(GEC(B")
("qa"    "$(GQ@QNZ]_B_ehw$(H$.$(GMi$(H5pac<*C+C.JAJKJTM((B")
("qb"    "$(GUVUYU_ZaZe_G_Sd,d8hrnKpipkzm$(H$4&v&}*d/8$(GOe$(H5Za]5^5`5d;y<(<6C%C,C2C8JBP]P`PbYR\t(B")
("qc"    "$(GQA]Jd4l~vDvJ$(H/G5O5[$(GFV$(H5fmQC(C-C>JOPYP^UMUe\s(B")
("qd"    "$(GMnU[W6ZXZgZhZi_Cd/pgr{$(H"C"F*X,u/6/>/N$(GHU$(H/ohw5h<%<.C?C@JZQ-W7a_(B")
("qe"    "$(GJHJMM^V9Zf_Nd0d2m!m&J@sl$(Hk}$(GvF|8$(H$//7/C0A5T5W5cJP(B")
("qf"    "$(GZTZp_A_Oh{m$m(m)sh$(H$-*f5P6~;}>xC/C9CAJH$(GWC$(HJIq0JNV0abhHo+o,(B")
("qg"    "$(GMXQFQHU^UbZ^Zd_Ihylzp_sk{a$(H*Z*g/D$(GJC$(H/ImN<-<4C$GHP\eP(B")
("qh"    "$(GJLMf_Rh|J=$(H&yJY/L2*JL(B")
("qi"    "$(GMhMrQ=JFQu$(Hp7$(GWTd1d3fDm+qvyp{%$(H"J"K$+&u&x/=?{JEPWP[W3\u(B")
("qj"    "$(GJ?M[McUdZ`_J_Lhsm,oFpevGDdzl$(HW/"D"G*e/E/M5N5]<0C)JQJXP_(B")
("qk"    "$(GJPM`PVPWUcZWZn_DJB_E$(H\v$(G_Phqhthum%vI$(H"I$5&~*V/F/J;~PVW2W4W9(B")
("ql"    "$(GJOKZMeUam#vE$(H$8%*$(GJK$(H&|cv*W/;9s<#JFW8\w(B")
("qm"    "$(GJJMjQ<QCU\Z1ZU_Md*hxp^$(H&t&{/H$(GH+$(H5Rhy5S5a;x;{C1C3C;(B")
("qn"    "$(GJ>JIMZQ9UeZcsgFT$(H"HeO$7*_*`5V;z;|<,(B")
("qo"    "$(GJAJNQGUWU]ZZZl_Hl{m-pcphrzsi$(H$0&w'!5b<)JJJS$(GE3$(HNHhzPX\x(B")
("qp"    "$(GJGMYQ?ZmldpbvHx9$(H$1&z*b.~555Q5g<1Bk$(GH,$(HC4mPJCJRPBa^eM(B")
("qq"    "$(GMWUTZ[l}L`pa$(HPa;v;w<&JU(B")
("qr"    "$(GM]M_MbMmMqQ>H*QD$(HPc$(GQETXUZZo\ed-d.d5k'pjsj$(H*]*^,S/9/:/A5L5M5U5Y8D8E<3>RC'C:JGJM(B")
("qs"    "$(GM\MaMoQBc=d+l|pd$(H!^*Y*\8CC#$(GFU$(HF8YQJD(B")
("qt"    "$(GMkQ;WU_Q$(H&s$(GMV$(H<+eRC&C*C5PZ(B")
("qu"    "$(GJDJEMgMlU`EDWV$(HUY$(GWWZVZ\Z_Zk]=d6d7m"m*{V|9|_$(H"E"L$*$,$2$3$6&r/5/</@/K5K5\<'<5C7C<JVJWO&(B")
("qv"    "$(GQ:OPUX$(Hp}$(GZY_Khvyn$(H*[*a*c/?5_5e<"<$<2C0G>I[W0W1W6^Ta`aaeNeQhxk[(B")
("qw"    "$(G_@m'p`Mdpf$(HC"$(Gyo$(H<!</(B")
("qx"    "$(G_F\osf$(HC65X(B")
("qy"    "$(GMpZbZjFW$(H$)mO/B(B")
("r"    "$(GDG(B")
("ra"    "$(GY9Y@$(Hq?$(GcDh3o<sGv<y)$(H)P3}:J:R:WCIO`OeTcVNZi\Rcbcig;(B")
("rb"    "$(GIQTRTUTZTfY>^@^C^Mh'l4l6p;rKrOsHwEwF$(H$u%_%d%l3|:UAoAsAuB%NDNEOcOoTn$(GGR$(HZplDZq\O_icccjg@(B")
("rc"    "$(GF<PCSZT^^xfxh(h1l;o8p@sIwHwo{x$(H%e.7.<4*ApAtAwAyI;OhOiOnTd_faJcgeAg>$(GF7$(HkSq_mG(B")
("rd"    "$(GIDL@LKPAPHT`^IcAf}g"o:o=pArNzGGT|4$(Hn/"%)D.A.I3+3w4-AzA|A}I:NBTjZl(B")
("re"    "$(GIULNTYYHbFpErL$(H.:3t9Z9\:LAxB"CBNGOk$(GIN$(HTer.TgTl\P\QaFaHg=pQqy(B")
("rf"    "$(G^TcBcCcJcOkxl3l5p?x%x,|z$(H#=$(GYA$(H#?ou:O:VI/I0I5OmZs\2\Lcdk5nr(B")
("rg"    "$(GIGP>T\YD^G^SrPv#{0GS{[$(Hq@$(G};$(H#>)?.?.H4,:X@WGoGqGvI8TbTkVG\UaGckkRkTn-(B")
("rh"    "$(GIJIMIPITh4o;F1$(H%[Zo.3.9:M@_NKVK(B")
("ri"    "$(GG\LLTb^OcHd)h/l>o9p]y(yezHze{/{Y|]$(H#8#;%\%m%o$(GGU$(H.Dn,3)@`A~GpO_OgVLclhlmE(B")
("rj"    "$(G^J^LcNh5l7wIzd})$(H#@%i)=)I$(GYE$(H.Cch3x4#4)<?I9I<OjOlT_Th\T(B")
("rk"    "$(GIRP6P9P@PKT]T_TeYK^P^U^VbBcLIFg!$(Hj&$(Gh&h0pGu\xKyd$(H#9#<)G*i9[I2OdVJVM(B")
("rl"    "$(GF5IXLFLGTaTcXWYJbRh2kHF0l<$(H[$$(G{w$(H#E.83=:N:Z:]H.PhU"[#(B")
("rm"    "$(GLCF2LE$(Hn1$(GY<]Q^?^K^Nc?cKl8uYuZ$(H#C%]%c%k%n)<4$@^I1I6Zme>(B")
("rn"    "$(GGZI1I>IWLIP<PJTV^H^QsFF/$(H#0Zr%^%`)H.G3*4!B$GnGuI4OZ(B")
("ro"    "$(GILKMLMP=IBY;$(Hj%$(G]R^WbEf|h*h,l:pDpFsEsJwGy'y*$(H)C.5.>.B3u3{4+NANJOfTaVOVPZncm(B")
("rp"    "$(GFaG]LQYFb@cId%p<x-$(H#:%j)M)N@[GrGs$(GF9$(HNCoTObTmce(B")
("rq"    "$(GzI$(H#A)E)O$(GPI$(H3zlE:^@VVHg<(B")
("rr"    "$(GLALBLDPBPDPETTT[Y?YL^>^AbGcGcMf{h+k9l2o>o@pBzf$(H%a%f%h)>)A)F.@.F4&$(GIH$(H:SaI:_@X@Z@\@]ArA{GwI7L:T]T`Tf_j(B")
("rs"    "$(GF=LS^:bAfzF6l1$(HB&$(GrM$(H%b%g)L(B")
("rt"    "$(GbCY:cF$(He?$(Gl9y+$(H#B.49Y:Y@YAqB!Gm\N\S(B")
("ru"    "$(GEsICDYIE$(HqT$(GIOISKWLHLJPGYCYIbDf@f~o?y,y-$(H#D.=3y3~4"4%9]:K:[;IB#B'GtHuI.L0N@O^OaT\]9aKe<n.p3(B")
("rv"    "$(G^Dfyh.pCpHybyc|%$(H)@.E3v:Q:\N?T^TiVIZk_ggGmFn0pRp|$(G^B$(Hq>(B")
("rw"    "$(Gp=$(H.6:T$(GP?$(HGypTZj_hg?(B")
("rx"    "$(Gl=u[YM{1$(He@:P\Mcf(B")
("ry"    "$(GY=c@LP$(H4(NF@a(B")
("s"    "$(GDS(B")
("sa"    "$(G\dlRw*$(HO<h0julgnHnR$(GYs$(Hod(B")
("sb"    "$(GM,U,Y5aMp"u!u"yRyS|&F"$(H)yr38GVwYP`l`qaNdgh2lpnL(B")
("sc"    "$(GPFh$o0oxs&tv{}|)|v}8$(H&:Uc[P[ebhc^ca$(GE($(HdYq|j_jvjwp6pa(B")
("sd"    "$(GU"^lgisy$(H!M<h$(GPm$(HP*r%[|`nd\f8h#nK(B")
("se"    "$(GL=J!U.$(Hlq$(Gc&d[lSmHv,$(H8=O>PeS!V!`id]h'h*jl(B")
("sf"    "$(GXkiZWYj;$(Hr;$(GmawyzX{E{G|/$(H6r=bHrM'OKV:XD^La4aOd~e(fAgchNhOk/ngnpnqp'psqNqe(B")
("sg"    "$(GM#PpYRc>e{jKowpI$(HJb$(GGK$(HVXr2[p[t`rd`gfh,hjo`(B")
("sh"    "$(Gl+$(H"!2(3L8A$(GD.$(HUolrUyU~`hdflj(B")
("si"    "$(GYp\g^rlvo}vCvfwzzWDCzh$(Hjn2+HlMwUvXN_9gvj`(B")
("sj"    "$(Gg(jIw+|R$(H.l?*HjI,S"Up[n[o[z$(GHV$(H^RnO`d`k`tjhlhlmnInM(B")
("sk"    "$(GJQgjkroyp!$(H8@:(O;$(GDg$(HOAnPR}S&[m[q`oh%jjlo(B")
("sl"    "$(GH[I:K[OUS&XU\fbUgkuh$(H"u#52)9m?+?7$(GGL$(HNUp~O@T~^\`g(B")
("sm"    "$(GHQtu$(H,q8FM)M*$(GD/$(HUroaUsU|YSjplfnN(B")
("sn"    "$(GL-$(Hi_$(GqH$(H!V""%P(J2,3m3rS%`sb6h!h/h1(B")
("so"    "$(GO:jMmDs-|S|u$(H8>A?F7IgS$[rau$(GE9$(HdZj'h&h((B")
("sp"    "$(GI~J4J6PoUDlfljovs3ty{o}GFG$(HHkli\kd[jk(B")
("sq"    "$(Geze}se`Xz~$(HnG;uQ|h$(B")
("sr"    "$(GF3F4III}M"Y3Y4aGo|s/s2u'wwz?F.{D$(Hh+%X4v8??,EXUuUwUxU}[u[{`jdadbfJh)(B")
("ss"    "$(GL4e|v+FH$(H#1Uq8HOC(B")
("st"    "$(GS"Yt\bPniq$(Hb@$(Go(s.tz||}7$(H"=8<HmVE`f(B")
("su"    "$(GDXEwJ"L$M!WXglku{*DW|'$(Hr$$s0!0$@8O=ODR~UNV"[s`md_dejmqn(B")
("sv"    "$(GU-Y^hXsTuExy}0$(H",)64qBM$(GO[$(HI]r&M%VbZC`eh"h-jiobocr#(B")
("sw"    "$(H&;$(GwP$(HUtjo[}(B")
("sx"    "$(HnJ(B")
("sy"    "$(GTMYu$(Hd^(B")
("t"    "$(GE=(B")
("ta"    "$(GX![*_[aam1n_Mwu0$(Hmu$(Gw3xp$(H?ZF{F}G$M@^|`Kf[(B")
("tb"    "$(GS?Ut]&_fa]ade\f-f3f9h]j]j^jbr}xmOK$(H(Zmw-A.#2@8j8m8z?d?eAUFqFtM>MBMCMJMOS7SISOS]YeYkYqYvYw[`^`^tc$c%fUhbi]ihl.(B")
("tc"    "$(GKdL'L(T@c'z6}D$(H?R?cFoM9M=S9UbYiYl$(GGA$(HYoq}Y~^d^e^f^h^lbdbvfWfYgrigj]oCp_(B")
("td"    "$(GQ\WvW}X"\w]%^k_~aeahaldFf4f=s{v&whxoyiz1z7{!$(H$~2L8k8u?X?oFRF|JzM4M?MHO,STS\YdYt$(GKB$(HdKl&l"(B")
("te"    "$(GOJaZa_afanf<nXn`r)v;xnzg$(H(_(d2%878`8s8v?M?P?W?\E<$(GOB$(HF5o]FjFsG%G'HbMKMYMZO/S6S:SZSdY{Z"^g^q^u_#fTf_f`ilk|(B")
("tf"    "$(GWO]$dtjcjejfnRn[q:r&r(w4u5wiyZ{F|E|Q}6}I$(H(b-??JFTFZFlL|MEMVR{SBSDSNSVS[YOYx$(GOI$(HY|qOZ$a&a*bpbwc"c#eufVh=ink1k:k>l,m"m#nhoDo^opo{o}p"q4(B")
("tg"    "$(GX$YW\`\}cSf:h;olw6yEz4|F$(H$z-=2<2D2U8o8p8t?`AJFrM;SJSYYfZ#^w^~$(GWz$(Ha:q5byb~d=iel%mvmxo?(B")
("th"    "$(GOES7S=Y*\tr$$(H"l(^-/$(GOA$(H2&r58e?_MRSMSaYu\B^j^n(B")
("ti"    "$(GOHSGW{\a^qaod(exhWjhnTnWnYnZu+x`xk$(H!D%"%#%T(e->-@-D2M2W8q?U?b@!APFVFxM:MAMDMIO*SASCSFSRYhYn^p^s^}_!btb}c:fR$(GKC$(Hfnq~fol3l^myoG(B")
("tj"    "$(GS>SsWuWw\vaWaYa^d:f.nUn]r"u-u1$(H%!-02:$(GE+$(H2>ii8w?&?aANFcFgF~H#J\MWO(S>SWW=Yr`LfQ(B")
("tk"    "$(GHd$(Hl-$(GS!SAWx\{^d_Wd9e'f1khnSu2wjxgxl$(H(R(W(X(]-1282I2N?SFPG&M7MLMXS=S@^y^{a<b{fe(B")
("tl"    "$(GOCOF$(HlJ$(GSJ_ZkJoQr]u*$(H(u-X2T2V<A?T@~H`HaNVPiS8SGS`T|Y}^o_pgHgIikjX(B")
("tm"    "$(GOLSISjU8\yaDf0jkkgu.w0xf|#$(H(f-8-B272?4>898a?j?C$(GFl$(H?HpJ?O?iF4FkFmFwM<MGMMO-S#S?SLSQSUYm^i`I`aijl'o@(B")
("tn"    "$(GS5Wt\%]!hBqIu4$(H"k"m$|(S(Y(\(a-3.+2;2B2K2P888:8}:1?'?Q?V?sFQFUFdFfHcMNR|Ygbnbub|fS$(GP)$(Hfal)im(B")
("to"    "$(GO?X#\x`"abacaieyi9j`mEr#zF{c$(H(`,o-9-:-<298d8f8x?(?D?L?mD"MSMUSESKS^S_Se_$bqbrbxdFfGfX$(GO>$(Hl(q3pS(B")
("tp"    "$(GOGUBUGcucyg]lgn^q~r!u3$(H${(V-2-C2=2G8^8i$(GOD$(H;`o(?Y?tFiG"J)MPMTS<Yp\j\l^b^caTf\f^fcidl$(B")
("tq"    "$(Gf2lysc{#|"$(H/32X?KFu$(GHP$(HMQfbO'Ys^m^z_"bodE(B")
("tr"    "$(GS:S;S<SDSHWyW|W~\|]#aCaVa[f/f8j\jgjiz3z@$(H)B-4-62H2J2O2Q8g8h?B?f?h?lFOFWF_FnM6M8MFO+RzSH$(GS9$(HTH'!UZU\^r^x`MdHfZfdglifl#q6(B")
("ts"    "$(GS8WsY,Y.]"c9c;f7qrw/ya$(H"n-;-F$(GO=$(H2CSP8r8y8{8|?kFYFaFhFpG#M5O0O\(B")
("tt"    "$(GG~Vt\zf5jajdw1z5z8Dj$(H!Nmt-.2S8b?N?rFNG(GZO)^a`JbzdL(B")
("tu"    "$(GO@PsS6SBSCSESFS{Wr\u]'a`akf;g^nVw2w<|s}($(H$}(T(U([(c-52F$(GO-$(H8]r-8n?@?E?G?I?]?qAOF3F^FbFeFyO.S5SSScXgYjZ![b^v_HavioqY(B")
("tv"    "$(GPZRIWqa\ajamf6g)jjnIokoru)z2$(H2E2R8_8l?F?[FXF\F]F`FvFzG!M3S;SXU[Yy^kbsc!dG$(GKA$(HjYoEl!l*oA(B")
("tw"    "$(GS@j_n\r%u,u/xj{"$(H-72A8c?g?n?pFSF[SfYzbe$(GH2$(Hf]l+(B")
("tx"    "$(Gw.r'w5$(H?^(B")
("ty"    "$(GaXag$(H$y-E$(G\~$(HSboB(B")
("u"    "$(GDT(B")
("ua"    "$(H)~5#&KIkP3ItP.(B")
("ub"    "$(GY}Z!U/Z"$(HkW$(Gci$(H*..n4y;E;NIjP2d>d?(B")
("uc"    "$(GsVwp{]$(H&=$(GsU$(H5'mL;PIvgu(B")
("ud"    "$(GsX$(H4w;HBVBW$(GY{$(HVomni&(B")
("ue"    "$(GJ&U1$(H#c&J4z$(GJ#$(H;F(B")
("uf"    "$(GW,YvR7$(HBZP5P1(B")
("ug"    "$(GY~$(H)|*#;R;TIoIp$(GYz$(HkXq-(B")
("uh"    "$(H#b#d$(GD1$(H;>Ir;CIl(B")
("ui"    "$(GPwU3X*Z#^uykzi$(H"8&E;?;SBX$(GPq$(HIqm~IuP-VhVsaPgwhq(B")
("uj"    "$(GU4$(H.r4x5"$(GM&$(H5%Vr;LH$IhVk(B")
("uk"    "$(GsW|5$(H#g&C$(GD~$(HJ[o%Kp(B")
("ul"    "$(GhY$(H!+#h#i&B**$(GS%$(HlIlK(B")
("um"    "$(Gcj$(H&@$(GYw$(H&AIs){(B")
("un"    "$(GJ$^3^5$(H#e&G$(GG{$(H*!Am*(3n;G;K;O(B")
("uo"    "$(GU6^tlUuR$(H)z4}$(GU0$(H4~\f;QC~InP4Vn(B")
("up"    "$(GY|$(H&<*)3M;J$(GM$$(HBUeI(B")
("uq"    "$(H;MP+Vm(B")
("ur"    "$(GPrU2YxhZ$(H&?&D&F&H*$*%*+*,.o.p4|5($(GM'$(H;UhpBSBTB\(B")
("us"    "$(H&>&I&L*/;BIi!WP,Vq(B")
("ut"    "$(GlTwBX?}C$(H&M#`(B")
("uu"    "$(GG=U7YyZ$uF|lEx$(H"6P/"7"9"j#a)}*"--5!;A?A(B")
("uv"    "$(H*'*-.s5&;@;DIm$(G^v$(HVimKVj(B")
("uw"    "$(H4{5$$(GM($(H;=P0B[(B")
("uy"    "$(HVl(B")
("v"    "$(GDL(B")
("va"    "$(GYfa@jEqotcv~Ydw%$(Ho.$(Gxc{@$(H4f;+>{P$Rp(B")
("vb"    "$(GTuWJYa^gccM0eo$(H''$(GhFhGjAjClLn7n>qmth$(H#T&*)o)s*54T4p:~;";,;1F$F'I_LmM"O~RqY?\Z\^^=b]b`iYkUpG(B")
("vc"    "$(GqiqnsPtdtsz*z}}>$(H4V4k$(Gcb$(H;0q/B:P%P'VdY@b^eGkukw(B")
("vd"    "$(GGpLhR}Z%^hcpepjBlIm?m@tl{\$(H&2&7)h4Y4m8/:y$(GGo$(H;#o0;*>}BGF!F-IXLiLqVeYHYIf<(B")
("ve"    "$(GIrWH^icgj9j:j<jGmIn@nAnBtq$(H&U$(GFC$(H4Wkx4e4j;.F"F#IWI`LpRwV^^HbckV(B")
("vf"    "$(GHNK$$(Hm2$(GLra<a=cdhJhKhLj7lKn8oztgtow#|Z}J$(H1t4`4b4d6|:wB;BHI^LkM!O}P!Y>YJ\7^Ga3eHf?hVi[k7(B")
("vg"    "$(GIlIsP_PaT}WFaAjDz|$(H&%)u.c1s4\4g8);2>r>~F%IORx$(GIg$(HVfq1\[\a^EdAky(B")
("vh"    "$(GLpTzW@WLnEtetrIn$(H#WLt&-.b81:}E|F(IV(B")
("vi"    "$(GLkMQRwRzR|T|WIYr\R^}qksQtpz+{&|CGr}'$(Hqv#S#X&,&3,l1v4i8*85B>BBBFITY<\`^@_:bYc9p5(B")
("vj"    "$(GYea9j8lJn=nDtixa$(H"1#R&&)f1{4U$(GGm$(H4[b_4l;-BJIRLjLzO|P(RkY9^?^C^M(B")
("vk"    "$(GIoNmP]H-Pe$(Ho$$(GTpTvWA\^a7cahHmdn:xd|H$(H#Y&(,m.\._1u84;'>uB=E}IYL{RlRtRuV`^Bb[eFmH(B")
("vl"    "$(GTtTx\YbTeqn<vK$(H!##V#[&1'#,k.a1w1z$(GO+$(H:xNY>zE~(B")
("vm"    "$(GLoRx\ZennC|B$(H!B!C".&'&)&.)e.]$(GLl$(H4Xho8+83;&;)B<LrLyO{RmV[V_Y8b\f:(B")
("vn"    "$(GM:P^R{TL\V^ec6{_$(H#U$(GIq$(H(In~)k.f1x1y8';%;(?!Rv\]aM(B")
("vo"    "$(GLsPbc`j5n?nFtk$(H*>.^4S4a8.:|$(GEh$(H>oq2>p>|IaIbLnVaXV^>^D^If;i\(B")
("vp"    "$(GLiP`Q'UFWGWKcfchtj|6$(H"-$(GIm$(H4oq.8(;X>vIULsRsVcbZf9mI(B")
("vq"    "$(G\QaBn9tn|7Lt$(H)qfB*U/40`bbf@(B")
("vr"    "$(GLjLnYc\U^ja8a>a?hIj6j?j@lHn;v=w!{y$(H&+&0)c)d)l)m)p)r)t+w.`1B4Q4Z4^$(GGq$(H4ciZ4h8,8082;!>tBEF)F,IcKkLxP#RrYDYF(B")
("vs"    "$(GFDFNI8IjIkE<T~$(HYG$(GW?c:$(H&/)gIS(B")
("vt"    "$(GIpLm$(Hmo$(GP[\]ceqhvA$(H;$>qE=P&YA\_iB(B")
("vu"    "$(GRyTwGnT{$(HpB$(GWEXTY`\S\W^fa:j>lMqpw"xbyg{^}9$(H"0#Z)i)j.d1r1|4R4_:{>sB?BAF&F+LlLwL~RoY;(B")
("vv"    "$(GPcTsTyYherfRj=pNtfyh{C|AIi$(H"/o=)n.e4nBILoLvV]Y:f=f>mJ(B")
("vw"    "$(G\XjFLqmk$(HV\$(Gt;v@w&wQ$(H(48-;/BLP)Rn(B")
("vx"    "$(Gw$$(HBKYB(B")
("vy"    "$(G\\$(HLu(B")
("w"    "$(GFp(B")
("wa"    "$(Gew{R$(H^P(B")
("wb"    "$(GPL$(HfE$(GS*Tg$(H#H4.4/:`?$(B")
("wc"    "$(G\,F>]K$(Hnu$(Gb9cQv(}B$(HOpdT(B")
("wd"    "$(GIZN*$(H%p?%F0YNe_$(GG`$(HqZ(B")
("we"    "$(H1%<:,=>1\zE+F2(B")
("wf"    "$(Gc)nGs9|e$(H,n$(G\[$(HfFqlkBkznsovpHpopp(B")
("wg"    "$(G\*h>p.qqv?K^xe$(Ho!1}86K~^Om9(B")
("wh"    "$(GI\$(H1$p&2!(B")
("wi"    "$(GRnfEh6F`xP$(HYL%q7?(B")
("wj"    "$(GEQ$(HYM$(GYP\+eHeu$(H!@VR(B")
("wk"    "$(GRMRNs<$(H\y$(GG^$(HaL(B")
("wl"    "$(GNwFrRL$(H(3(B")
("wm"    "$(Get{h$(H,<1~2#$(GYO$(HF.fIa;(B")
("wn"    "$(GhAjHs=]i$(H#Ie,$m^Q(B")
("wo"    "$(G\8F?s|$(H2$.K/y(B")
("wp"    "$(GQvUHcsnH$(H#G+K$(GQ($(H2"V<J+M#(B")
("wq"    "$(GVc^X$(H]_(B")
("wr"    "$(GLVThWN\)e6v5G_x($(HqS.J@FiKmq(B")
("ws"    "$(Gv7K.$(H\\(B")
("wt"    "$(HB(m;(B")
("wu"    "$(GYNI[v6$(Hk{E*F1\@\AkCkE(B")
("wv"    "$(GcPRK$(H"&m:(2@4REVQ(B")
("ww"    "$(HR6$(Gh7$(HRy(B")
("wy"    "$(Gev$(HF/(B")
("xf"    "$(H'2'1'3'9'4'5'6'7'8(B")
("xh"    "$(H';'<'='>':'?'B'@'A(B")
("xl"    "$(H'C(B")
("xm"    "$(H'D(B")
("xo"    "$(H'E'F'H'G(B")
("xr"    "$(H')'('*'0'+','-'.'/(B")
("y"    "$(GD3(B")
("ya"    "$(GSc$(Hp0$(GSvfaffnzoNr=rDx{x|$(H31TDTMcJcKeUg((B")
("yb"    "$(GK:K?O9PtPv]A]V]Wg2g5g\j&jQjUk!k.k/k@nPnyo"oKr7rAuJFKue$(Hpz$(GwAwMy!}!$(H/Q357f9fCCCDGVH'RYTxZQZWZ[Z}[~_LcEcFg*g,(B")
("yc"    "$(GG)SVS]fti!rYr\s"uIwmyJ{t|$|3|m}-}4$(H@>GaH(HdM[O"T>U`Ua[Q$(GDz$(H_[qWcTg)g5h{j"kJm@nBoS(B")
("yd"    "$(GKRKSKjQLSdV$V'X=X>XL[9]debfdg+Jbnw$(Hnz$(Gn{o#r;r<uGzB$(H*k9!EjEyGRN7TJ_QcM(B")
("ye"    "$(GL>N>$(Hp/$(GOS]Ca*b"b.bLg1h}kFmGrF{,$(H*h+I/O9g9j@tK1T=TBVFX`_N_R_Sb?cNiRj#j.n'o_(B")
("yf"    "$(GWB[n]ba;f`kAm^nunvoLr9r[v:y$yX}:$(H7eHqV/\0\|_Z`~a%cScUe5g+$(GKk$(HhFr(hQk(k-mCnloNozpkplpnqsr'(B")
("yg"    "$(G[,]^]ca)b!bMbPfgg6gTh9k-kdo!pLEdpo$(Hq=$(GsMwbwcwkx/|J|~$(H(mGIGLGMTwZNZ\(B")
("yh"    "$(GP}])]?b,dYhdr8Jcw@$(Hpy(n,(8~9N9eH&_%hg(B")
("yi"    "$(GV\X6Yi]D^%bOf]klpRrBrWsauMy"Fhz>$(Hm}$(Gza|j$(H,b/|3!5j>a@DBxT?T@Z&g#l=(B")
("yj"    "$(GKPKTL5L7SSX5EGX9$(Hq<$(G[{]B]Y]a]}b#g*o$rUrVubxOxzx~z)zA{3{n|t$(H(q@sTGTzZMZPZZ[d_McIg-hk(B")
("yk"    "$(GG(L_MsPUUfX%XJZ~]@_Uf>flk(m.oMugw>yx$(H(p(r9O<<@?N5PfT{$(GEF$(H_OqwdQg$g&kM(B")
("yl"    "$(GOTSfX;]F]Z][]e]fd;g:ORk>$(Hhi"q%'%(/T>`GKH*NPhh(B")
("ym"    "$(GEOKhSKX7["\(]]apb%D8b($(Hp.$(Gb*f\kEntnxw?z_|k$(H!/8;<>@IAXE)GNN3ZLZRZV[c_Y_ncLfHizl>m7mDn%o-oQ(B")
("yn"    "$(GHlKUL+OhSTTHX<](c7g7l*p8pOrCvhDmxh$(Hpq$(GzD$(H'$(l,93.32E&GTO[XUcVe6fhklk~(B")
("yo"    "$(GSbVdXP[!]\fZg-k$k0o&p/ucwN{g|2|{$(H/w6;<B?.@CC{GQG]$(GG*$(HK+l?Q9TATKTyWjZT_oadZ(eTi~l<(B")
("yp"    "$(GJ3N@S~X:[#]EctfYk"k%les>{T|I$(H"o#x&Y-U;a@GGO$(GH:$(HN4rDTEW#ZUaAcPg'mAn*pOr*(B")
("yq"    "$(Gf[g.g0r:[trX$(HW5$(GrZuf$(H33@H(B")
("yr"    "$(GI=KFS^S_SaSeW;XOXQXRXmY8]U]_^=b$b&b'b-bNfNf^fcfhfjfkg4i"k#k*kBkin~r>r?y#zCz[z`{+|1$(H)J-W1`3/30347\9h@@@A@E@rGPGWH)ZO_TcHg/$(GF'$(HkIr6kKkpoPp1(B")
("ys"    "$(GL3Ui]>]`b)f?f_fbk,u6uHy1$(H#4%%-V.09i@<@JO]ZS\K$(GEI$(HcGp{e:(B")
("yt"    "$(GP{XS]Xk&qMuOx}$(H-K-T$(GG!$(H@=qVGULTZX[!_\ddhfkH(B")
("yu"    "$(GG&N}OMOiP"X4X8XK[E]~^seFfeg,g8itk)kCkDoOr5t!uKuLwOz#$(H":%&(o/S7S9L9M<C@7@BGST8TC$(GEr$(HTLrBWrZ'Z|Z~_P_UfCf~g%i|kLp2qX(B")
("yv"    "$(GGlHhKVLeP7UjX.X/XM]5bQfVg3j%jyk?npn|r@rEs'uAuCudy2{U{q|i$(H7/9C9D9E@3G=N'$(GDA$(HN2'#N6T5TIUiZAZDZEcOi{i}nE(B")
("yw"    "$(GVeXNg/kGzn$(HH%ZYaeg.n&$(GS`$(Hn)pP(B")
("yx"    "$(Gk}n}(B")
("yy"    "$(GF&MuE,SU$(H/R$(Gb+k+o%(B")
;v "z\,"     "$(G!"!#!.!/(B")
;v "z\."     "$(G!%!$!&!0!1(B")
("z\;"     "$(G!'!2!"!#!.!/(B")
("z\:"     "$(G!(!+!3!%!$!&!0!1(B")
("z\'"     "$(G!e!d(B")
("z\""     "$(G!g!f!h!i!q(B")
("z\\"     "$(G"`"b#M(B")
("z\|"     "$(G!6!8!:"^(B")
("z\/"     "$(G"_"a#L(B")
("z\?"     "$(G!)!4(B")
("z\<"     "$(G!R"6"A!T"H(B")
("z\>"     "$(G!S"7"B!U(B")
("z\["     "$(G!F!J!b!H!L!V!Z!X!\(B")
("z\]"     "$(G!G!K!c!I!M!W![!Y!](B")
("z\{"     "$(G!B!`!D(B ")
("z\}"     "$(G!C!a!E(B")
("z\`"     "$(G!j!k(B")
("z\~"     "$(G"D"+",!<!=(B")
("z\!"     "$(G!*!5(B")
("z\@"     "$(G"i"n(B")
("z\#"     "$(G!l"-(B")
("z\$"     "$(G"c"l(B")
("z\%"     "$(G"h"m(B")
("z\&"     "$(G!m".(B")
("z\*"     "$(G!n"/!o!w!x(B")
("z\("     "$(G!>!^!@(B")
("z\)"     "$(G!?!_!A(B")
("z\-"     "$(G!7!9"#"$"1"@(B")
("z\_"     "$(G"%"&(B")
("z\="     "$(G"8"C(B")
("z\+"     "$(G"0"?(B")
)
