(*^

::[paletteColors = 128; 
	fontset = title, "New York", 24, L3, center, bold, nohscroll;
	fontset = subtitle, "New York", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "New York", 14, L2, center, bold, nohscroll;
	fontset = section, "New York", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "New York", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "New York", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "New York", 12, L2, nohscroll;
	fontset = smalltext, "New York", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Parametric  Plots
;[s]
2:0,1;17,0;18,-1;
2:1,32,24,Chicago,1,24,0,0,0;1,29,22,Geneva,1,24,0,0,0;
:[font = text; inactive; ]
This example comes from section 5.5.
This packages supercedes that standard package ParametricPlot3D.m.
;[s]
2:0,1;103,0;104,-1;
2:1,16,12,Chicago,0,12,0,0,0;1,16,12,Geneva,0,12,0,0,0;
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
;[s]
2:0,1;16,0;17,-1;
2:1,14,10,Chicago,1,10,0,0,0;1,13,10,Geneva,1,10,0,0,0;
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

;[s]
3:0,0;67,1;93,0;470,-1;
2:2,14,10,Chicago,0,10,0,0,0;1,14,10,Chicago,2,10,0,0,0;
:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Rotated Parabola
:[font = text; inactive; ]
The parabola is rotated around the z axis.
;[s]
2:0,1;42,0;43,-1;
2:1,16,12,Chicago,0,12,0,0,0;1,16,12,Geneva,0,12,0,0,0;
:[font = input; endGroup; ]
CylindricalPlot3D[ r^2, {r, 0, 1}, {phi, 0, 2Pi} ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Hyperboloid
;[s]
2:0,1;11,0;12,-1;
2:1,16,12,Chicago,1,12,0,0,0;1,14,10,Courier,1,12,0,0,0;
:[font = input; endGroup; ]
CylindricalPlot3D[ 1.5 Sqrt[1 + r^2],
	{r, 0, 2}, {phi, 0, 2Pi} ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Catenoid
;[s]
2:0,1;8,0;9,-1;
2:1,16,12,Chicago,1,12,0,0,0;1,14,10,Courier,1,12,0,0,0;
:[font = input; endGroup; ]
ParametricPlot3D[ {Cosh[z] Cos[phi], Cosh[z] Sin[phi], z},
	{z, -2, 2}, {phi, 0, 2Pi}, Boxed -> False ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Spherical Harmonic Y[3, 1]
;[s]
2:0,1;26,0;27,-1;
2:1,16,12,Chicago,1,12,0,0,0;1,14,10,Courier,1,12,0,0,0;
:[font = text; inactive; ]
by precomputing the value of the spherical harmonic, the program takes less time to compute the picture.
;[s]
2:0,1;104,0;105,-1;
2:1,16,12,Chicago,0,12,0,0,0;1,16,12,Geneva,0,12,0,0,0;
:[font = input; ]
y31 = Abs[ N[SphericalHarmonicY[3, 1, theta, 0]] ];
:[font = input; endGroup; endGroup; ]
SphericalPlot3D[ y31,
	{theta, 0, Pi, Pi/24}, {phi, 0, 2Pi} ];
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`NewParametricPlot3D`"]
(*
:[font = input; initialization; ]
*)
ParametricPlot3D::usage =
	"ParametricPlot3D[{x,y,z,(style)}, {u,u0,u1,(du)}, {v,v0,v1,(dv)}, (options..)]
	plots a 3D parametric surface. Options are passed to Show[]"
(*
:[font = input; initialization; ]
*)
PointParametricPlot3D::usage =
	"PointParametricPlot3D[{x,y,z}, {u,u0,u1,(du)}, {v,v0,v1,(dv)}, (options..)]
	plots a two-parameter set of points in space. Options are passed to Show[]."
(*
:[font = input; initialization; ]
*)
SpaceCurve::usage = "SpaceCurve[{x,y,z}, {u,u0,u1,(du)}, (options..)]
	plots a 3D parametric curve. Options are passed to Show[]."
(*
:[font = input; initialization; ]
*)
PointSpaceCurve::usage = "PointSpaceCurve[{x,y,z}, {u,u0,u1,(du)}, (options..)]
	plots a one-parameter set of points in space. Options are passed to Show[]"
(*
:[font = input; initialization; ]
*)
SphericalPlot3D::usage = "SphericalPlot3D[r, {theta-range}, {phi-range}, (options...)]
	plots r as a function of the angles theta and phi.
	SphericalPlot3D[{r, style}, ...] uses style to render each surface patch"
(*
:[font = input; initialization; ]
*)
CylindricalPlot3D::usage = "CylindricalPlot3D[z, {r-range}, {phi-range}, (options...)]
	plots z as a function of r and phi.
	CylindricalPlot3D[{z, style},  ...] uses style to render each surface patch"
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
MakePolygons[vl_List] :=
	Block[{l = vl, l1 = Map[RotateLeft, vl], mesh},
		mesh = {l, RotateLeft[l], RotateLeft[l1], l1};
		mesh = Map[Drop[#, -1]&, mesh, {1}];
		mesh = Map[Drop[#, -1]&, mesh, {2}];
		Polygon /@ Transpose[ Map[Flatten[#, 1]&, mesh] ]
	]  /; TensorRank[vl] == 3 && Dimensions[vl][[3]] == 3
(*
:[font = input; initialization; ]
*)
MakePolygons[vl_List] :=
	Block[{l, l1, mesh, cols},
		l = Map[Take[#, 3]&, vl, {2}]; (* the coords *)
		l1 = Map[RotateLeft, l];
		cols = Map[#[[4]]&, vl, {2}];  (* the colors *)
		mesh = {l, RotateLeft[l], RotateLeft[l1], l1};
		mesh = Map[Drop[#, -1]&, mesh, {1}];
		mesh = Map[Drop[#, -1]&, mesh, {2}];
		cols = Drop[cols, -1];
		cols = Map[Drop[#, -1]&, cols, {1}];
		mesh = Polygon /@ Transpose[ Map[Flatten[#, 1]&, mesh] ];
		Flatten[Transpose[{Flatten[cols], mesh}]]
	]  /; TensorRank[vl] == 3 && Dimensions[vl][[3]] == 4
(*
:[font = input; initialization; ]
*)

FilterOptions[ command_Symbol, opts___ ] :=
	Block[{keywords = First /@ Options[command]},
		Sequence @@ Select[ {opts}, MemberQ[keywords, First[#]]& ]
	]
(*
:[font = input; initialization; ]
*)
Attributes[ParametricPlot3D] = {HoldFirst}
(*
:[font = input; initialization; ]
*)
ParametricPlot3D[ fun_,
		{u_, u0_, u1_, du_:Automatic}, {v_, v0_, v1_, dv_:Automatic}, opts___ ] :=
	Block[{plotpoints, ndu = N[du], ndv = N[dv]},
		plotpoints = PlotPoints /. {opts} /. Options[Plot3D];
		If[ du === Automatic, ndu = N[(u1-u0)/(plotpoints-1)] ];
		If[ dv === Automatic, ndv = N[(v1-v0)/(plotpoints-1)] ];
		Show[ Graphics3D[MakePolygons[Table[ N[fun],
		                                     {u, u0, u1, ndu}, {v, v0, v1, ndv}] ]],
		      FilterOptions[Graphics3D, opts] ]
	]  /; NumberQ[N[u0]] && NumberQ[N[u1]] && NumberQ[N[v0]] && NumberQ[N[v1]]
(*
:[font = input; initialization; ]
*)
Attributes[PointParametricPlot3D] = {HoldFirst}
(*
:[font = input; initialization; ]
*)
PointParametricPlot3D[ fun_,
		{u_, u0_, u1_, du_:Automatic}, {v_, v0_, v1_, dv_:Automatic}, opts___ ] :=
	Block[{plotpoints, ndu = N[du], ndv = N[dv]},
		plotpoints = PlotPoints /. {opts} /. Options[Plot3D];
		If[ du === Automatic, ndu = N[(u1-u0)/(plotpoints-1)] ];
		If[ dv === Automatic, ndv = N[(v1-v0)/(plotpoints-1)] ];
		Show[ Graphics3D[Table[ Point[N[fun]], {u, u0, u1, ndu}, {v, v0, v1, ndv} ]],
		      FilterOptions[Graphics3D, opts] ]
	]  /; NumberQ[N[u0]] && NumberQ[N[u1]] && NumberQ[N[v0]] && NumberQ[N[v1]]
(*
:[font = input; initialization; ]
*)
Attributes[SpaceCurve] = {HoldFirst}
(*
:[font = input; initialization; ]
*)
SpaceCurve[ fun_, ul:{_, u0_, u1_, du_}, opts___ ] :=
	Show[ Graphics3D[Line[Table[ N[fun], ul ]]], FilterOptions[Graphics3D, opts] ] /;
			NumberQ[N[u0]] && NumberQ[N[u1]] && NumberQ[N[du]]
(*
:[font = input; initialization; ]
*)
SpaceCurve[ fun_, {u_, u0_, u1_}, opts___ ] :=
    Block[{plotpoints},
    	plotpoints = PlotPoints /. {opts} /. Options[Plot3D];
	SpaceCurve[ fun, {u, u0, u1, (u1-u0)/(plotpoints-1)}, opts ]
    ]
(*
:[font = input; initialization; ]
*)
Attributes[PointSpaceCurve] = {HoldFirst}
(*
:[font = input; initialization; ]
*)
PointSpaceCurve[ fun_, ul:{_, u0_, u1_, du_}, opts___ ] :=
	Show[ Graphics3D[Table[ Point[N[fun]], ul ]], FilterOptions[Graphics3D, opts] ] /;
			NumberQ[N[u0]] && NumberQ[N[u1]] && NumberQ[N[du]]
(*
:[font = input; initialization; ]
*)
PointSpaceCurve[ fun_, {u_, u0_, u1_}, opts___ ] :=
    Block[{plotpoints},
    	plotpoints = PlotPoints /. {opts} /. Options[Plot3D];
	PointSpaceCurve[ fun, {u, u0, u1, (u1-u0)/(plotpoints-1)}, opts ]
    ]
(*
:[font = input; initialization; ]
*)
Attributes[SphericalPlot3D] = {HoldFirst}
(*
:[font = input; initialization; ]
*)
SphericalPlot3D[ {r_, style_}, tlist:{theta_, __}, plist:{phi_, __}, opts___ ] :=
	Block[{rs},
		ParametricPlot3D[ {(rs = r) Sin[theta] Cos[phi],
		                   rs Sin[theta] Sin[phi],
		                   rs Cos[theta],
		                   style},
		                  tlist, plist, opts ]
	]
(*
:[font = input; initialization; ]
*)
SphericalPlot3D[ r_, tlist:{theta_, __}, plist:{phi_, __}, opts___ ] :=
      ParametricPlot3D[ r{Sin[theta] Cos[phi],
                          Sin[theta] Sin[phi],
                          Cos[theta]},
                        tlist, plist, opts ]
(*
:[font = input; initialization; ]
*)
Attributes[CylindricalPlot3D] = {HoldFirst}
(*
:[font = input; initialization; ]
*)
CylindricalPlot3D[ {z_, style_}, rlist:{r_, __}, plist:{phi_, __}, opts___ ] :=
	ParametricPlot3D[{r Cos[phi], r Sin[phi], z, style}, rlist, plist, opts]
(*
:[font = input; initialization; ]
*)
CylindricalPlot3D[ z_, rlist:{r_, __}, plist:{phi_, __}, opts___ ] :=
	ParametricPlot3D[{r Cos[phi], r Sin[phi], z}, rlist, plist, opts]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[ParametricPlot3D, PointParametricPlot3D, SpaceCurve,
	PointSpaceCurve, SphericalPlot3D, CylindricalPlot3D]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)