(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Newton's Formula and Fixed Points of Functions
:[font = text; inactive; ]
This example comes from subsection 4.3.4.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Golden Ratio
:[font = text; inactive; ]
a) naive fixed point iteration
:[font = input; ]
Needs["Utilities`Until`"]
:[font = input; ]
x = N[1, 20]
Until[ x=1+1/x, x==1+1/x ]; x
:[font = text; inactive; ]
b) Newton's method
:[font = input; endGroup; ]
NewtonFixedPoint[ 1 + 1/#&, N[2, 20] ]
:[font = subsection; inactive; startGroup; Cclosed; ]
Square Roots
:[font = text; inactive; ]
a) showing the intermediate steps in Newton's formula
:[font = input; ]
r = 2
x = N[1, 40]
Do[ x = (x + r/x)/2; Print[x], {7}]
:[font = text; inactive; ]
b) Using Nest[]
:[font = input; ]
Nest[ (# + r/#)/2&, N[1, 40], 7 ]
:[font = text; inactive; ]
c) As a fixed point
:[font = input; endGroup; ]
r = 2
FixedPoint[ (# + r/#)/2&, N[1, 40] ]
:[font = subsection; inactive; startGroup; Cclosed; ]
Fixed Point of the Cosine
:[font = text; inactive; ]
a) Naive fixed point
:[font = input; ]
FixedPoint[ Cos, N[1/2, 40] ]
:[font = text; inactive; ]
b) Newton's method
:[font = input; endGroup; endGroup; ]
NewtonFixedPoint[ Cos, N[1, 40] ]
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`Newton`"]
(*
:[font = input; initialization; ]
*)
NewtonZero::usage = "NewtonZero[expr, x, x0] finds a zero of expr as a function of x
	using the initial guess x0 to start the iteration. NewtonZero[f, x0] finds
	a zero of the function f. The recursion limit determines the
	maximum number of iteration steps that are performed."
(*
:[font = input; initialization; ]
*)
NewtonFixedPoint::usage = "NewtonFixedPoint[f, x0] finds a fixed point
	of the function f using the initial guess x0 to start the iteration."
(*
:[font = input; initialization; ]
*)
Newton::noconv = "Iteration did not converge in `1` steps."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
NewtonZero[expr_, x_, x0_] := NewtonZero[ Function[x, expr], x0 ]
(*
:[font = input; initialization; ]
*)
NewtonZero[f_, x0_] :=
	Block[{res, x0a, prec = Precision[x0], fp = f'},
		x0a = SetPrecision[x0, prec + 10];
		res = FixedPoint[(# - f[#]/fp[#])&, x0a, $RecursionLimit];
		x0a = f[res];
		If [ Accuracy[x0a] - Precision[x0a] < prec,
			Message[Newton::noconv, $RecursionLimit] ];
		N[res, prec]
	]
(*
:[font = input; initialization; ]
*)
NewtonFixedPoint[f_, x0_] := NewtonZero[(f[#] - #)&, x0]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[ NewtonZero, NewtonFixedPoint]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)