/*-
 * amigaECSC.c --
 *	Functions for handling color server on amiga custom chips
 *
 * Copyright (c) 1987 by the Regents of the University of California
 * Copyright (c) 1987 by Adam de Boor, UC Berkeley
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 *
 */

/************************************************************
  Copyright 1994 by Olivier Raoul
  Copyright 1987 by Sun Microsystems, Inc. Mountain View, CA.
  
  All Rights Reserved
  
  Permission  to  use,  copy,  modify,  and  distribute   this
  software  and  its documentation for any purpose and without
  fee is hereby granted, provided that the above copyright no-
  tice  appear  in all copies and that both that copyright no-
  tice and this permission notice appear in  supporting  docu-
  mentation,  and  that the names of Sun or MIT not be used in
  advertising or publicity pertaining to distribution  of  the
  software  without specific prior written permission. Sun and
  M.I.T. make no representations about the suitability of this
  software for any purpose. It is provided "as is" without any
  express or implied warranty.
  
  SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
  NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
  ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
  PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
  THE USE OR PERFORMANCE OF THIS SOFTWARE.
  
  ********************************************************/
#include "pixmapstr.h"
int         fd;

#ifndef	lint
static char sccsid[] = "%W %G Copyright 1987 Sun Micro";
#endif

/*-
 * Copyright (c) 1987 by Sun Microsystems,  Inc.
 */

#include    "amiga.h"
#include    "resource.h"

#include    <sys/mman.h>
#include    "servermd.h"
#include    <sys/ioctl.h>
#include    <sys/types.h>
#include    <stdlib.h>
#include    <stdio.h>

#define MAXWIDTH	671	/* this is stupid */
extern int displayWidth;
extern int displayHeight;

char *mapaddr, *mapbottom, *maptop;
int bplcfb;
int bplsize;
int mapsize;
int bplmfb;
int nplanes;

/*-
 *-----------------------------------------------------------------------
 * amigaECSCInit --
 *	Attempt to find and initialize a CCColor framebuffer
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Most of the elements of the ScreenRec are filled in.  The
 *	video is enabled for the frame buffer...
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static Bool
amigaECSCInit (index, pScreen, argc, argv)
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    ScreenPtr	  pScreen;  	/* The Screen to initialize */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    if (!cfbScreenInit(pScreen,
		       amigaFbs[index].fb,
		       amigaFbs[index].info.view.vs.width,
		       amigaFbs[index].info.view.vs.height,
		       monitorResolution, monitorResolution,
		       amigaFbs[index].info.view.vs.width))
	return (FALSE);
  
    if (!amigaScreenAllocate (pScreen))
	return FALSE;
  
    amigaCCScreenInit (pScreen);
  
    if (!amigaScreenInit (pScreen))
	return FALSE;
    /*
     * Enable video output...? 
     */
    (void) amigaSaveScreen(pScreen, SCREEN_SAVER_OFF);
    
    return cfbCreateDefColormap(pScreen);
}

/*-
 *-----------------------------------------------------------------------
 * amigaECSCProbe --
 *	Attempt to find and initialize a CCColor framebuffer
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Memory is allocated for the frame buffer and the buffer is mapped. 
 *
 *-----------------------------------------------------------------------
 */

static u_long color[] = {
    0x000000,
    0x0f0f0f,
    0x00000a,
    0x00000f,
    0x000500,
    0x000a00,
    0x000f00,
    0x050000,
    0x0a0000,
    0x0f0000,
    0x000505,
    0x000a0a,
    0x000f0f,
    0x050005,
    0x0a000a,
    0x0f000f
};

/*ARGSUSED*/
Bool
amigaECSCProbe(pScreenInfo, index, fbNum, argc, argv)
     ScreenInfo	  *pScreenInfo;	/* The screenInfo struct */
     int	  index;    	/* The index of pScreen in the ScreenInfo */
     int	  fbNum;    	/* Index into the amigaFbData array */
     int	  argc;	    	/* The number of the Server's arguments. */
     char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    struct view_size vs;
    bmap_t bm;
    colormap_t cmap;
    pointer fb;
    int i;
    u_long junkcolor[sizeof(color) / sizeof(color[0])];

    mapaddr = NULL;
#if 0
    nplanes = amigaECSCDepth();
#else
    nplanes = GetDepth();
#endif

    if ((fd = xopen_view()) == -1)
	return FALSE;

    if (ioctl(fd, VIOCGSIZE, &vs) == -1) {
	perror("ioctl VIOCGSIZE");
        (void) close(fd);
        return FALSE;
    }

    vs.width = 640;
    vs.height = displayHeight;
    vs.depth = nplanes;
    if (ioctl(fd, VIOCSSIZE, &vs) == -1) {
	perror("ioctl VIOCSSIZE");
        (void) close(fd);
        return FALSE;
    }

    if (ioctl(fd, VIOCGBMAP, &bm) == -1) {
	perror("ioctl VIOCGBMAP");
        (void) close(fd);
        return FALSE;
    }
  
    mapsize = bm.bytes_per_row*bm.rows;
    if ((mapaddr = mmap(0, bm.bytes_per_row * bm.rows * bm.depth,
        PROT_READ | PROT_WRITE, MAP_FILE, fd, (off_t) 0)) == (caddr_t) -1) {
	Error("mapping CC");
	(void) close(fd);
	return FALSE;
    }
  
    memset(mapaddr, 255, mapsize);
    bplmfb = bm.bytes_per_row;
    bplcfb = (vs.width - (vs.width % (1 << nplanes))) / (8 / vs.depth);

    if ((fb = malloc(bplcfb * vs.height)) == NULL) {
	perror("malloc fb");
        (void) close(fd);
        return FALSE;
    }

    mapbottom = fb;
    maptop = mapbottom + bplcfb * vs.height;
    fprintf(stderr, "Initializing tables...");
    inittab(&bm);
    fprintf(stderr, " done\n");

    cmap.first = 0;
    cmap.size = 1 << nplanes;
    cmap.entry = junkcolor;
    if (ioctl(fd, VIOCGCMAP, &cmap) == -1) {
	perror("ioctl VIOCGCMAP");
	(void) close(fd);
	return FALSE;
    }

    cmap.entry = color;
    if (ioctl(fd, VIOCSCMAP, &cmap) == -1) {
	perror("ioctl VIOCSCMAP");
	(void) close(fd);
	return FALSE;
    }

#ifndef GDBUG
    if (ioctl(fd, VIOCDISPLAY, 0)) {
        perror("ioctl VIOCDISPLAY");
	(void) close(fd);
        return FALSE;
    }
#endif

    amigaFbs[index].fb = fb;
    amigaFbs[index].fd = fd;
    amigaFbs[index].info.view.bm = bm;
    amigaFbs[index].info.view.vs = vs;
    amigaFbs[index].EnterLeave = NULL;

    return TRUE;
}

Bool
amigaECSCCreate(pScreenInfo, argc, argv)
     ScreenInfo	  *pScreenInfo;
     int    	  argc;
     char    	  **argv;
{
    return (AddScreen(amigaECSCInit, argc, argv) >= 0);
}

static void
amigaCCUpdateColormap(pScreen, index, count, rmap, gmap, bmap)
     ScreenPtr	pScreen;
     int	index, count;
     u_char	*rmap, *gmap, *bmap;
{
    long color[1 << nplanes];
    colormap_t cmap;

    cmap.type = CM_COLOR;
    cmap.red_mask = 0xFF;
    cmap.green_mask = 0xFF;
    cmap.blue_mask = 0xFF;
    cmap.first = 0;
    cmap.size = 1 << nplanes;
    cmap.entry = color;

    if (ioctl(fd, VIOCGCMAP, &cmap) == -1)
	perror("ioctl VIOCGCMAP");

    while (count--) {
	cmap.entry[index] = ((rmap[index] >> 4) << 16) |
	    ((gmap[index] >> 4) << 8) |
		((bmap[index] >> 4));
	index++;
    }

    if (ioctl(fd, VIOCSCMAP, &cmap) == -1)
	perror("ioctl VIOCSCMAP");
}


/*-
 *-----------------------------------------------------------------------
 * amigaCCInstallColormap --
 *	Install given colormap.
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Existing map is uninstalled.
 *	All clients requesting ColormapNotify are notified
 *
 *-----------------------------------------------------------------------
 */
static void
amigaCCInstallColormap(cmap)
    ColormapPtr	cmap;
{
    SetupScreen(cmap->pScreen);
    register int i;
    register Entry *pent;
    register VisualPtr pVisual = cmap->pVisual;
    u_char	  rmap[1 << nplanes], gmap[1 << nplanes], bmap[1 << nplanes];
  
    if (cmap == pPrivate->installedMap)
	return;
    if (pPrivate->installedMap)
	WalkTree(pPrivate->installedMap->pScreen, TellLostMap,
		 (pointer) &(pPrivate->installedMap->mid));
    if ((pVisual->class | DynamicClass) == DirectColor) {
	for (i = 0; i < (1 << nplanes); i++) {
	    pent = &cmap->red[(i & pVisual->redMask) >>
			      pVisual->offsetRed];
	    rmap[i] = pent->co.local.red >> 8;
	    pent = &cmap->green[(i & pVisual->greenMask) >>
				pVisual->offsetGreen];
	    gmap[i] = pent->co.local.green >> 8;
	    pent = &cmap->blue[(i & pVisual->blueMask) >>
			       pVisual->offsetBlue];
	    bmap[i] = pent->co.local.blue >> 8;
	}
    } else {
	for (i = 0, pent = cmap->red;
	     i < pVisual->ColormapEntries;
	     i++, pent++) {
	    if (pent->fShared) {
		rmap[i] = pent->co.shco.red->color >> 8;
		gmap[i] = pent->co.shco.green->color >> 8;
		bmap[i] = pent->co.shco.blue->color >> 8;
	    }
	    else {
		rmap[i] = pent->co.local.red >> 8;
		gmap[i] = pent->co.local.green >> 8;
		bmap[i] = pent->co.local.blue >> 8;
	    }
	}
    }
    pPrivate->installedMap = cmap;
    (*pPrivate->UpdateColormap) (cmap->pScreen, 0, 1 << nplanes,
				 rmap, gmap, bmap);
    WalkTree(cmap->pScreen, TellGainedMap, (pointer) &(cmap->mid));
}

/*-
 *-----------------------------------------------------------------------
 * amigaCCUninstallColormap --
 *	Uninstall given colormap.
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	default map is installed
 *	All clients requesting ColormapNotify are notified
 *
 *-----------------------------------------------------------------------
 */
static void
amigaCCUninstallColormap(cmap)
    ColormapPtr	cmap;
{
    SetupScreen(cmap->pScreen);
    if (cmap == pPrivate->installedMap) {
	Colormap defMapID = cmap->pScreen->defColormap;
    
	if (cmap->mid != defMapID) {
	    ColormapPtr defMap = (ColormapPtr) LookupIDByType(defMapID,
							      RT_COLORMAP);
      
	    if (defMap)
		(*cmap->pScreen->InstallColormap)(defMap);
	    else
		ErrorF("amigaCC: Can't find default colormap\n");
	}
    }
}

/*-
 *-----------------------------------------------------------------------
 * amigaCCListInstalledColormaps --
 *	Fills in the list with the IDs of the installed maps
 *
 * Results:
 *	Returns the number of IDs in the list
 *
 * Side Effects:
 *	None
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static int
amigaCCListInstalledColormaps(pScreen, pCmapList)
    ScreenPtr	pScreen;
    Colormap	*pCmapList;
{
    SetupScreen(pScreen);
    *pCmapList = pPrivate->installedMap->mid;
    return (1);
}


/*-
 *-----------------------------------------------------------------------
 * amigaCCStoreColors --
 *	Sets the pixels in pdefs into the specified map.
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	None
 *
 *-----------------------------------------------------------------------
 */
static void
amigaCCStoreColors(pmap, ndef, pdefs)
    ColormapPtr	pmap;
    int		ndef;
    xColorItem	*pdefs;
{
    SetupScreen(pmap->pScreen);
    u_char	rmap[1 << nplanes], gmap[1 << nplanes], bmap[1 << nplanes];
    xColorItem	expanddefs[1 << nplanes];
    register int i;
  
    if (pmap != pPrivate->installedMap)
	return;
    if ((pmap->pVisual->class | DynamicClass) == DirectColor) {
	ndef = cfbExpandDirectColors(pmap, ndef, pdefs, expanddefs);
	pdefs = expanddefs;
    }
    while (ndef--) {
	i = pdefs->pixel;
	rmap[i] = pdefs->red >> 8;
	gmap[i] = pdefs->green >> 8;
	bmap[i] = pdefs->blue >> 8;
	(*pPrivate->UpdateColormap) (pmap->pScreen, i, 1, rmap, gmap, bmap);
	pdefs++;
    }
}

amigaCCScreenInit (pScreen)
     ScreenPtr	pScreen;
{
    extern Bool	FlipPixels;
    SetupScreen (pScreen);
    pScreen->InstallColormap = amigaCCInstallColormap;
    pScreen->UninstallColormap = amigaCCUninstallColormap;
    pScreen->ListInstalledColormaps = amigaCCListInstalledColormaps;
    pScreen->StoreColors = amigaCCStoreColors;
    pPrivate->UpdateColormap = amigaCCUpdateColormap;
    if (FlipPixels) {
	pScreen->whitePixel = 1;
	pScreen->blackPixel = 0;
    }
}
