/*-
 * amigaECSM.c --
 *	Functions for handling monochrome server on amiga custom chips
 *
 * Copyright (c) 1987 by the Regents of the University of California
 * Copyright (c) 1987 by Adam de Boor, UC Berkeley
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 *
 */

/************************************************************
Copyright 1994 by Eduardo Horvath
Copyright 1987 by Sun Microsystems, Inc. Mountain View, CA.

                    All Rights Reserved

Permission  to  use,  copy,  modify,  and  distribute   this
software  and  its documentation for any purpose and without
fee is hereby granted, provided that the above copyright no-
tice  appear  in all copies and that both that copyright no-
tice and this permission notice appear in  supporting  docu-
mentation,  and  that the names of Sun or MIT not be used in
advertising or publicity pertaining to distribution  of  the
software  without specific prior written permission. Sun and
M.I.T. make no representations about the suitability of this
software for any purpose. It is provided "as is" without any
express or implied warranty.

SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/


#ifndef	lint
static char sccsid[] = "%W %G Copyright 1987 Sun Micro";
#endif

/*-
 * Copyright (c) 1987 by Sun Microsystems,  Inc.
 */

#include    "amiga.h"
#include    "resource.h"

#include    <sys/mman.h>

/*-
 *-----------------------------------------------------------------------
 * amigaECSMInit --
 *	Attempt to find and initialize a bw2 framebuffer
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Most of the elements of the ScreenRec are filled in.  The
 *	video is enabled for the frame buffer...
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static Bool
amigaECSMInit (index, pScreen, argc, argv)
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    ScreenPtr	  pScreen;  	/* The Screen to initialize */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    if (!mfbScreenInit(pScreen,
		       amigaFbs[index].fb,
		       amigaFbs[index].info.view.vs.width,
		       amigaFbs[index].info.view.vs.height,
		       monitorResolution, monitorResolution,
		       amigaFbs[index].info.view.vs.width))
	return (FALSE);

    if (!amigaScreenAllocate (pScreen) || !amigaScreenInit (pScreen))
	return FALSE;

    pScreen->whitePixel = 0;
    pScreen->blackPixel = 1;

    /*
     * Enable video output...? 
     */
    (void) amigaSaveScreen(pScreen, SCREEN_SAVER_OFF);

    return mfbCreateDefColormap(pScreen);
}


/*-
 *-----------------------------------------------------------------------
 * amigaECSMProbe --
 *	Attempt to find and initialize a bw2 framebuffer
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Memory is allocated for the frame buffer and the buffer is mapped. 
 *
 *-----------------------------------------------------------------------
 */

/* These are set by ddxProcessArgument */
int displayWidth = 689;
int displayHeight = 440;
int displayDepth = 1;
int displayXOffset;
int displayYOffset;

/*ARGSUSED*/
Bool
amigaECSMProbe(pScreenInfo, index, fbNum, argc, argv)
    ScreenInfo	  *pScreenInfo;	/* The screenInfo struct */
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    int	    	  fbNum;    	/* Index into the amigaFbData array */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    int         fd;
    int		pagemask, mapsize;
    caddr_t	addr, mapaddr;
    struct view_size vs;
    bmap_t	bm;

    if ((fd = xopen_view()) == -1)
	return FALSE;

    if (ioctl(fd, VIOCGSIZE, &vs)) {
        perror("ioctl VIOCGSIZE");
        (void) close(fd);
        return FALSE;
    }

    vs.width = displayWidth;
    vs.height = displayHeight;
    vs.depth = displayDepth;
    vs.x = displayXOffset;
    vs.y = displayYOffset;

    if (ioctl(fd, VIOCSSIZE, &vs)) {
        perror("ioctl VIOCGSIZE");
        (void) close(fd);
        return FALSE;
    }

    if (ioctl(fd, VIOCGSIZE, &vs)) {
        perror("ioctl VIOCGSIZE");
        (void) close(fd);
        return FALSE;
    }

    if (ioctl(fd, VIOCGBMAP, &bm)) {
        perror("ioctl VIOCGBMAP");
        (void) close(fd);
        return FALSE;
    }

    if ((mapaddr = mmap(0, bm.bytes_per_row*bm.rows*bm.depth,
        PROT_READ | PROT_WRITE, MAP_FILE, fd, (off_t) 0)) == (caddr_t) -1) {
        Error("mapping ECSM");
        (void) close(fd);
        return FALSE;
    }

#ifndef GDBUG
    if (ioctl(fd, VIOCDISPLAY, 0)) {
        perror("ioctl VIOCDISPLAY");
        (void) close(fd);
        return FALSE;
    }
#endif

    amigaFbs[index].fb = (pointer) mapaddr;
    amigaFbs[index].fd = fd;
    amigaFbs[index].info.view.bm = bm;
    amigaFbs[index].info.view.vs = vs;
    amigaFbs[index].EnterLeave = NULL;

    return TRUE;
}

Bool
amigaECSMCreate(pScreenInfo, argc, argv)
    ScreenInfo	  *pScreenInfo;
    int	    	  argc;
    char    	  **argv;
{
    return (AddScreen(amigaECSMInit, argc, argv) >= 0);
}
