/************************************************************
Copyright 1994 by Eduardo Horvath
Copyright 1987 by Sun Microsystems, Inc. Mountain View, CA.

                    All Rights Reserved

Permission  to  use,  copy,  modify,  and  distribute   this
software  and  its documentation for any purpose and without
fee is hereby granted, provided that the above copyright no-
tice  appear  in all copies and that both that copyright no-
tice and this permission notice appear in  supporting  docu-
mentation,  and  that the names of Sun or MIT not be used in
advertising or publicity pertaining to distribution  of  the
software  without specific prior written permission. Sun and
M.I.T. make no representations about the suitability of this
software for any purpose. It is provided "as is" without any
express or implied warranty.

SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include	"amiga.h"
#include	"keysym.h"

/*
 *	XXX - Its not clear what to map these to for now.
 *	keysyms.h doesn't define enough function key names.
 */


#ifndef	XK_L1
#define	XK_L1	XK_Cancel
#define	XK_L2	XK_Redo
#define	XK_R1	NoSymbol
#define	XK_R2	NoSymbol
#define	XK_R3	NoSymbol
#define	XK_L3	XK_Menu
#define	XK_L4	XK_Undo
#define	XK_R4	NoSymbol
#define	XK_R5	NoSymbol
#define	XK_R6	NoSymbol
#define	XK_L5	XK_Insert
#define	XK_L6	XK_Select
#define	XK_R7	NoSymbol
#define	XK_R8	XK_Up
#define	XK_R9	NoSymbol
#define	XK_L7	XK_Execute
#define	XK_L8	XK_Print
#define	XK_R10	XK_Left
#define	XK_R11	XK_Home
#define	XK_R12	XK_Right
#define	XK_L9	XK_Find
#define	XK_L10	XK_Help
#define	XK_R13	NoSymbol
#define	XK_R14	XK_Down
#define	XK_R15	NoSymbol
#endif

static KeySym AmigaMap[] = {
	XK_quoteleft,	XK_asciitilde,		/* 0x00 */
	XK_1,		XK_exclam,		/* 0x1 */
	XK_2,		XK_at,			/* 0x2 */
	XK_3,		XK_numbersign,		/* 0x3 */
	XK_4,		XK_dollar,		/* 0x4 */
	XK_5,		XK_percent,		/* 0x5 */
	XK_6,		XK_asciicircum,		/* 0x6 */
	XK_7,		XK_ampersand,		/* 0x7 */
	XK_8,		XK_asterisk,		/* 0x8 */
	XK_9,		XK_parenleft,		/* 0x9 */
	XK_0,		XK_parenright,		/* 0xa */
	XK_minus,	XK_underscore,		/* 0xb */
	XK_equal,	XK_plus,		/* 0xc */
	XK_backslash,	XK_bar,			/* 0xd */
	NoSymbol,	NoSymbol,		/* 0xe */
	XK_KP_0,	XK_Insert,		/* 0xf */
	XK_q,		XK_Q,			/* 0x10 */
	XK_w,		XK_W,			/* 0x11 */
	XK_e,		XK_E,			/* 0x12 */
	XK_r,		XK_R,			/* 0x13 */
	XK_t,		XK_T,			/* 0x14 */
	XK_y,		XK_Y,			/* 0x15 */
	XK_u,		XK_U,			/* 0x16 */
	XK_i,		XK_I,			/* 0x17 */
	XK_o,		XK_O,			/* 0x18 */
	XK_p,		XK_P,			/* 0x19 */
	XK_bracketleft,	XK_braceleft,		/* 0x1a */
	XK_bracketright,XK_braceright,		/* 0x1b */
	NoSymbol,	NoSymbol,		/* 0x1c */
	XK_KP_1,	XK_End,			/* 0x1d */
	XK_KP_2,	XK_Down,		/* 0x1e */
	XK_KP_3,	XK_Next,		/* 0x1f */
	XK_a,		XK_A,			/* 0x20 */
	XK_s,		XK_S,			/* 0x21 */
	XK_d,		XK_D,			/* 0x22 */
	XK_f,		XK_F,			/* 0x23 */
	XK_g,		XK_G,			/* 0x24 */
	XK_h,		XK_H,			/* 0x25 */
	XK_j,		XK_J,			/* 0x26 */
	XK_k,		XK_K,			/* 0x27 */
	XK_l,		XK_L,			/* 0x28 */
	XK_semicolon,	XK_colon,		/* 0x29 */
	XK_quoteright,	XK_quotedbl,		/* 0x2a */
	NoSymbol,	NoSymbol,		/* 0x2b */
	NoSymbol,	NoSymbol,		/* 0x2c */
	XK_KP_4,	XK_Left,		/* 0x2d */
	XK_KP_5,	NoSymbol,		/* 0x2e */
	XK_KP_6,	XK_Right,		/* 0x2f */
	XK_Shift_L,	NoSymbol,		/* 0x30 */
	XK_z,		XK_Z,			/* 0x31 */
	XK_x,		XK_X,			/* 0x32 */
	XK_c,		XK_C,			/* 0x33 */
	XK_v,		XK_V,			/* 0x34 */
	XK_b,		XK_B,			/* 0x35 */
	XK_n,		XK_N,			/* 0x36 */
	XK_m,		XK_M,			/* 0x37 */
	XK_comma,	XK_less,		/* 0x38 */
	XK_period,	XK_greater,		/* 0x39 */
	XK_slash,	XK_question,		/* 0x3a */
	NoSymbol,	NoSymbol,		/* 0x3b */
	XK_KP_Decimal,	XK_Delete,		/* 0x3c */
	XK_KP_7,	XK_Home,		/* 0x3d */
	XK_KP_8,	XK_Up,			/* 0x3e */
	XK_KP_9,	XK_Prior,		/* 0x3f */
	XK_space,	NoSymbol,		/* 0x40 */
	XK_BackSpace,	NoSymbol,		/* 0x41 */
	XK_Tab,		NoSymbol,		/* 0x42 */
	XK_KP_Enter,	NoSymbol,		/* 0x43 */
	XK_Return,	NoSymbol,		/* 0x44 */
	XK_Escape,	NoSymbol,		/* 0x45 */
	XK_Delete,	NoSymbol,		/* 0x46 */
	NoSymbol,	NoSymbol,		/* 0x47 */
	NoSymbol,	NoSymbol,		/* 0x48 */
	NoSymbol,	NoSymbol,		/* 0x49 */
	XK_KP_Subtract,	NoSymbol,		/* 0x4a */
	NoSymbol,	NoSymbol,		/* 0x4b */
	XK_Up,		NoSymbol,		/* 0x4c */ 
	XK_Down,	NoSymbol,		/* 0x4d */
	XK_Right,	NoSymbol,		/* 0x4e */
	XK_Left,	NoSymbol,		/* 0x4f */
	XK_F1,		NoSymbol,		/* 0x50 */
	XK_F2,		NoSymbol,		/* 0x51 */
	XK_F3,		NoSymbol,		/* 0x52 */
	XK_F4,		NoSymbol,		/* 0x53 */
	XK_F5,		NoSymbol,		/* 0x54 */
	XK_F6,		NoSymbol,		/* 0x55 */
	XK_F7,		NoSymbol,		/* 0x56 */
	XK_F8,		NoSymbol,		/* 0x57 */
	XK_F9,		NoSymbol,		/* 0x58 */
	XK_F10,		NoSymbol,		/* 0x59 */
	XK_parenleft,	XK_Num_Lock,		/* 0x5a */
	XK_parenright,	XK_Pause,		/* 0x5b */
	XK_KP_Divide,	NoSymbol,		/* 0x5c */
	XK_KP_Multiply,	XK_Print,		/* 0x5d */
	XK_KP_Add,	NoSymbol,		/* 0x5e */
        XK_Help,	NoSymbol,		/* 0x5f */
	XK_Shift_L,	NoSymbol,		/* 0x60 */
	XK_Shift_R,	NoSymbol,		/* 0x61 */
	XK_Caps_Lock,	NoSymbol,		/* 0x62 */
	XK_Control_L,	NoSymbol,		/* 0x63 */
	XK_Alt_L,	NoSymbol,		/* 0x64 */
	XK_Alt_R,	NoSymbol,		/* 0x65 */
	XK_Meta_L,	NoSymbol,		/* 0x66 */
	XK_Meta_R,	NoSymbol,		/* 0x67 */
	NoSymbol,	NoSymbol,		/* 0x68 */
	NoSymbol,	NoSymbol,		/* 0x69 */
	NoSymbol,	NoSymbol,		/* 0x6a */
	NoSymbol,	NoSymbol,		/* 0x6b */
	NoSymbol,	NoSymbol,		/* 0x6c */
	NoSymbol,	NoSymbol,		/* 0x6d */
	NoSymbol,	NoSymbol,		/* 0x6e */
	NoSymbol,	NoSymbol,		/* 0x6f */
	NoSymbol,	NoSymbol,		/* 0x70 */
	NoSymbol,	NoSymbol,		/* 0x71 */
	NoSymbol,	NoSymbol,		/* 0x72 */
	NoSymbol,	NoSymbol,		/* 0x73 */
	NoSymbol,	NoSymbol,		/* 0x74 */
	NoSymbol,	NoSymbol,		/* 0x75 */
	NoSymbol,	NoSymbol,		/* 0x76 */
	NoSymbol,	NoSymbol,		/* 0x77 */
	NoSymbol,	NoSymbol,		/* 0x78 */
	NoSymbol,	NoSymbol,		/* 0x79 */
	NoSymbol,	NoSymbol,		/* 0x7a */
	NoSymbol,	NoSymbol,		/* 0x7b */
	NoSymbol,	NoSymbol,		/* 0x7c */
	NoSymbol,	NoSymbol,		/* 0x7d */
	NoSymbol,	NoSymbol,		/* 0x7e */
	NoSymbol,	NoSymbol,		/* 0x7f */
};


KeySymsRec amigaKeySyms[] = {
    /*	map	   minKeyCode	maxKC	width */
    (KeySym *)NULL,	0,	0,	0,
    (KeySym *)NULL,	0,	0,	0,
    (KeySym *)NULL,	0,	0,	0,
    (KeySym *)NULL,	0,	0,	0,
    AmigaMap,		0,	0x68,	2,
};

#define	cT	(ControlMask)
#define	sH	(ShiftMask)
#define	lK	(LockMask)
#define	mT	(Mod1Mask)
#define	m2	(Mod2Mask)

static CARD8 amigamodmap[MAP_LENGTH] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 00-0f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 10-1f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 20-2f */
    0,  0,  0,  0,  0,  0,  0,  0,  sH, 0,  0,  0,  0,  0,  0,  0, /* 30-3f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 40-4f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 50-5f */
    0,  0,  0,  0,  0,  0,  0,  0, sH, sH, lK, cT, mT, mT, m2, m2, /* 60-6f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 70-7f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 80-8f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 90-9f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* a0-af */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* b0-bf */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* c0-cf */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* d0-df */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* e0-ef */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* f0-ff */
};

CARD8 *amigaModMap[] = {
	NULL,
	NULL,
	NULL,
	NULL,
	amigamodmap,
};
