/*-
 * amigaRetinaC.c --
 *	Functions to support the Retina board as a memory frame buffer.
 */

/************************************************************
Copyright 1987 by Sun Microsystems, Inc. Mountain View, CA.

                    All Rights Reserved

Permission  to  use,  copy,  modify,  and  distribute   this
software  and  its documentation for any purpose and without
fee is hereby granted, provided that the above copyright no-
tice  appear  in all copies and that both that copyright no-
tice and this permission notice appear in  supporting  docu-
mentation,  and  that the names of Sun or MIT not be used in
advertising or publicity pertaining to distribution  of  the
software  without specific prior written permission. Sun and
M.I.T. make no representations about the suitability of this
software for any purpose. It is provided "as is" without any
express or implied warranty.

SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#ifndef	lint
static char sccsid[] = "@(#)amigaRetinaC.c	1.4 6/1/87 Copyright 1987 Sun Micro";
#endif

#include    "amiga.h"

#include    "colormap.h"
#include    "colormapst.h"
#include    "resource.h"
#include    <struct.h>
#include    <stdlib.h>
#include    <stdio.h>

/*-
 *-----------------------------------------------------------------------
 * amigaRetinaCInit --
 *	Attempt to find and initialize a retina framebuffer used as color
 *
 * Results:
 *	TRUE if everything went ok. FALSE if not.
 *
 * Side Effects:
 *	Most of the elements of the ScreenRec are filled in. Memory is
 *	allocated for the frame buffer and the buffer is mapped. The
 *	video is enabled for the frame buffer...
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static Bool
amigaRetinaCInit (index, pScreen, argc, argv)
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    ScreenPtr	  pScreen;  	/* The Screen to initialize */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    if (!cfbScreenInit (pScreen, amigaFbs[index].fb,
			amigaFbs[index].info.grf.gd_fbwidth,
			amigaFbs[index].info.grf.gd_fbheight,
			monitorResolution, monitorResolution,
			amigaFbs[index].info.grf.gd_fbwidth))
    	return (FALSE);
    
    if (!amigaScreenAllocate (pScreen))
	return FALSE;

    amigaCGScreenInit (pScreen);

    if (!amigaScreenInit (pScreen))
	return FALSE;

    amigaSaveScreen( pScreen, SCREEN_SAVER_OFF );

    return cfbCreateDefColormap(pScreen);
}

/*-
 *-----------------------------------------------------------------------
 * amigaRetinaCProbe --
 *	Attempt to find and initialize a retina framebuffer used as color
 *
 * Results:
 *	TRUE if everything went ok. FALSE if not.
 *
 * Side Effects:
 *	Memory is allocated for the frame buffer and the buffer is mapped.
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
Bool
amigaRetinaCProbe (pScreenInfo, index, fbNum, argc, argv)
    ScreenInfo	  *pScreenInfo;	/* The screenInfo struct */
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    int	    	  fbNum;    	/* Index into the amigaFbData array */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    int fd;

    if ((fd = open(amigaFbData[fbNum].devName, O_RDWR, 0)) == -1) {
	perror(amigaFbData[fbNum].devName);
	return FALSE;
    }

    if (!retina_setup(fd, pScreenInfo, index, fbNum, argc, argv)) {
	close(fd);
	return FALSE;
    }

    return TRUE;
}

Bool
amigaRetinaCCreate(pScreenInfo, argc, argv)
    ScreenInfo	  *pScreenInfo;
    int    	  argc;
    char    	  **argv;
{
    int i;

    i = AddScreen(amigaRetinaCInit, argc, argv);
    return TRUE;
}
